import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsCryptoKeyIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy.html#crypto_key_id KmsCryptoKeyIamPolicy#crypto_key_id}.
     *
     * @stability stable
     */
    readonly cryptoKeyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy.html#policy_data KmsCryptoKeyIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy.html google_kms_crypto_key_iam_policy}.
 *
 * @stability stable
 */
export declare class KmsCryptoKeyIamPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key_iam_policy.html google_kms_crypto_key_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyIamPolicyConfig);
    private _cryptoKeyId;
    /**
     * @stability stable
     */
    get cryptoKeyId(): string;
    /**
     * @stability stable
     */
    set cryptoKeyId(value: string);
    /**
     * @stability stable
     */
    get cryptoKeyIdInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyData;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
