import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsCryptoKeyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The KeyRing that this key belongs to. Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#key_ring KmsCryptoKey#key_ring}
     *
     * @stability stable
     */
    readonly keyRing: string;
    /**
     * Labels with user-defined metadata to apply to this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#labels KmsCryptoKey#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The resource name for the CryptoKey.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#name KmsCryptoKey#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The immutable purpose of this CryptoKey. See the [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose) for possible inputs. Default value: "ENCRYPT_DECRYPT" Possible values: ["ENCRYPT_DECRYPT", "ASYMMETRIC_SIGN", "ASYMMETRIC_DECRYPT"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#purpose KmsCryptoKey#purpose}
     *
     * @stability stable
     */
    readonly purpose?: string;
    /**
     * Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
     *
     * The first rotation will take place after the specified period. The rotation period has
     * the format of a decimal number with up to 9 fractional digits, followed by the
     * letter 's' (seconds). It must be greater than a day (ie, 86400).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#rotation_period KmsCryptoKey#rotation_period}
     *
     * @stability stable
     */
    readonly rotationPeriod?: string;
    /**
     * If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
     *
     * You must use the 'google_kms_key_ring_import_job' resource to import the CryptoKeyVersion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#skip_initial_version_creation KmsCryptoKey#skip_initial_version_creation}
     *
     * @stability stable
     */
    readonly skipInitialVersionCreation?: boolean;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#timeouts KmsCryptoKey#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KmsCryptoKeyTimeouts;
    /**
     * version_template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#version_template KmsCryptoKey#version_template}
     *
     * @stability stable
     */
    readonly versionTemplate?: KmsCryptoKeyVersionTemplate[];
}
/**
 * @stability stable
 */
export interface KmsCryptoKeyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#create KmsCryptoKey#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#delete KmsCryptoKey#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#update KmsCryptoKey#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface KmsCryptoKeyVersionTemplate {
    /**
     * The algorithm to use when creating a version based on this template. See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#algorithm KmsCryptoKey#algorithm}
     *
     * @stability stable
     */
    readonly algorithm: string;
    /**
     * The protection level to use when creating a version based on this template.
     *
     * Default value: "SOFTWARE" Possible values: ["SOFTWARE", "HSM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html#protection_level KmsCryptoKey#protection_level}
     *
     * @stability stable
     */
    readonly protectionLevel?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html google_kms_crypto_key}.
 *
 * @stability stable
 */
export declare class KmsCryptoKey extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key.html google_kms_crypto_key} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _keyRing;
    /**
     * @stability stable
     */
    get keyRing(): string;
    /**
     * @stability stable
     */
    set keyRing(value: string);
    /**
     * @stability stable
     */
    get keyRingInput(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _purpose?;
    /**
     * @stability stable
     */
    get purpose(): string;
    /**
     * @stability stable
     */
    set purpose(value: string);
    /**
     * @stability stable
     */
    resetPurpose(): void;
    /**
     * @stability stable
     */
    get purposeInput(): string | undefined;
    private _rotationPeriod?;
    /**
     * @stability stable
     */
    get rotationPeriod(): string;
    /**
     * @stability stable
     */
    set rotationPeriod(value: string);
    /**
     * @stability stable
     */
    resetRotationPeriod(): void;
    /**
     * @stability stable
     */
    get rotationPeriodInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _skipInitialVersionCreation?;
    /**
     * @stability stable
     */
    get skipInitialVersionCreation(): boolean;
    /**
     * @stability stable
     */
    set skipInitialVersionCreation(value: boolean);
    /**
     * @stability stable
     */
    resetSkipInitialVersionCreation(): void;
    /**
     * @stability stable
     */
    get skipInitialVersionCreationInput(): boolean | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): KmsCryptoKeyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: KmsCryptoKeyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KmsCryptoKeyTimeouts | undefined;
    private _versionTemplate?;
    /**
     * @stability stable
     */
    get versionTemplate(): KmsCryptoKeyVersionTemplate[];
    /**
     * @stability stable
     */
    set versionTemplate(value: KmsCryptoKeyVersionTemplate[]);
    /**
     * @stability stable
     */
    resetVersionTemplate(): void;
    /**
     * @stability stable
     */
    get versionTemplateInput(): KmsCryptoKeyVersionTemplate[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
