import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingBillingAccountExclusionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#billing_account LoggingBillingAccountExclusion#billing_account}.
     *
     * @stability stable
     */
    readonly billingAccount: string;
    /**
     * A human-readable description.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#description LoggingBillingAccountExclusion#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Whether this exclusion rule should be disabled or not. This defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#disabled LoggingBillingAccountExclusion#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean;
    /**
     * The filter to apply when excluding logs. Only log entries that match the filter are excluded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#filter LoggingBillingAccountExclusion#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * The name of the logging exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html#name LoggingBillingAccountExclusion#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html google_logging_billing_account_exclusion}.
 *
 * @stability stable
 */
export declare class LoggingBillingAccountExclusion extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_billing_account_exclusion.html google_logging_billing_account_exclusion} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingBillingAccountExclusionConfig);
    private _billingAccount;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    set billingAccount(value: string);
    /**
     * @stability stable
     */
    get billingAccountInput(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean;
    /**
     * @stability stable
     */
    set disabled(value: boolean);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | undefined;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
