import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MlEngineModelConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description specified for the model when it was created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#description MlEngineModel#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * One or more labels that you can add, to organize your models.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#labels MlEngineModel#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The name specified for the model.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#name MlEngineModel#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * If true, online prediction nodes send stderr and stdout streams to Stackdriver Logging.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#online_prediction_console_logging MlEngineModel#online_prediction_console_logging}
     *
     * @stability stable
     */
    readonly onlinePredictionConsoleLogging?: boolean;
    /**
     * If true, online prediction access logs are sent to StackDriver Logging.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#online_prediction_logging MlEngineModel#online_prediction_logging}
     *
     * @stability stable
     */
    readonly onlinePredictionLogging?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#project MlEngineModel#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The list of regions where the model is going to be deployed. Currently only one region per model is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#regions MlEngineModel#regions}
     *
     * @stability stable
     */
    readonly regions?: string[];
    /**
     * default_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#default_version MlEngineModel#default_version}
     *
     * @stability stable
     */
    readonly defaultVersion?: MlEngineModelDefaultVersion[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#timeouts MlEngineModel#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MlEngineModelTimeouts;
}
/**
 * @stability stable
 */
export interface MlEngineModelDefaultVersion {
    /**
     * The name specified for the version when it was created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#name MlEngineModel#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * @stability stable
 */
export interface MlEngineModelTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#create MlEngineModel#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html#delete MlEngineModel#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html google_ml_engine_model}.
 *
 * @stability stable
 */
export declare class MlEngineModel extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/ml_engine_model.html google_ml_engine_model} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MlEngineModelConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _onlinePredictionConsoleLogging?;
    /**
     * @stability stable
     */
    get onlinePredictionConsoleLogging(): boolean;
    /**
     * @stability stable
     */
    set onlinePredictionConsoleLogging(value: boolean);
    /**
     * @stability stable
     */
    resetOnlinePredictionConsoleLogging(): void;
    /**
     * @stability stable
     */
    get onlinePredictionConsoleLoggingInput(): boolean | undefined;
    private _onlinePredictionLogging?;
    /**
     * @stability stable
     */
    get onlinePredictionLogging(): boolean;
    /**
     * @stability stable
     */
    set onlinePredictionLogging(value: boolean);
    /**
     * @stability stable
     */
    resetOnlinePredictionLogging(): void;
    /**
     * @stability stable
     */
    get onlinePredictionLoggingInput(): boolean | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _regions?;
    /**
     * @stability stable
     */
    get regions(): string[];
    /**
     * @stability stable
     */
    set regions(value: string[]);
    /**
     * @stability stable
     */
    resetRegions(): void;
    /**
     * @stability stable
     */
    get regionsInput(): string[] | undefined;
    private _defaultVersion?;
    /**
     * @stability stable
     */
    get defaultVersion(): MlEngineModelDefaultVersion[];
    /**
     * @stability stable
     */
    set defaultVersion(value: MlEngineModelDefaultVersion[]);
    /**
     * @stability stable
     */
    resetDefaultVersion(): void;
    /**
     * @stability stable
     */
    get defaultVersionInput(): MlEngineModelDefaultVersion[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): MlEngineModelTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: MlEngineModelTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MlEngineModelTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
