import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * How to combine the results of multiple conditions to determine if an incident should be opened.
     *
     * Possible values: ["AND", "OR", "AND_WITH_MATCHING_RESOURCE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#combiner MonitoringAlertPolicy#combiner}
     *
     * @stability stable
     */
    readonly combiner: string;
    /**
     * A short name or phrase used to identify the policy in dashboards, notifications, and incidents.
     *
     * To avoid confusion, don't use
     * the same display name for multiple policies in the same project. The
     * name is limited to 512 Unicode characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#display_name MonitoringAlertPolicy#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether or not the policy is enabled. The default is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#enabled MonitoringAlertPolicy#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * Identifies the notification channels to which notifications should be sent when incidents are opened or closed or when new violations occur on an already opened incident.
     *
     * Each element of this array corresponds
     * to the name field in each of the NotificationChannel objects that are
     * returned from the notificationChannels.list method. The syntax of the
     * entries in this field is
     * 'projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#notification_channels MonitoringAlertPolicy#notification_channels}
     *
     * @stability stable
     */
    readonly notificationChannels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#project MonitoringAlertPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * This field is intended to be used for organizing and identifying the AlertPolicy objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#user_labels MonitoringAlertPolicy#user_labels}
     *
     * @stability stable
     */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
     * conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#conditions MonitoringAlertPolicy#conditions}
     *
     * @stability stable
     */
    readonly conditions: MonitoringAlertPolicyConditions[];
    /**
     * documentation block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#documentation MonitoringAlertPolicy#documentation}
     *
     * @stability stable
     */
    readonly documentation?: MonitoringAlertPolicyDocumentation[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#timeouts MonitoringAlertPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringAlertPolicyTimeouts;
}
/**
 * @stability stable
 */
export declare class MonitoringAlertPolicyCreationRecord extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mutateTime(): string;
    /**
     * @stability stable
     */
    get mutatedBy(): string;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionAbsentAggregations {
    /**
     * The alignment period for per-time series alignment.
     *
     * If present,
     * alignmentPeriod must be at least
     * 60 seconds. After per-time series
     * alignment, each time series will
     * contain data points only on the
     * period boundaries. If
     * perSeriesAligner is not specified
     * or equals ALIGN_NONE, then this
     * field is ignored. If
     * perSeriesAligner is specified and
     * does not equal ALIGN_NONE, then
     * this field must be defined;
     * otherwise an error is returned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#alignment_period MonitoringAlertPolicy#alignment_period}
     *
     * @stability stable
     */
    readonly alignmentPeriod?: string;
    /**
     * The approach to be used to combine time series.
     *
     * Not all reducer
     * functions may be applied to all
     * time series, depending on the
     * metric type and the value type of
     * the original time series.
     * Reduction may change the metric
     * type of value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
     *
     * @stability stable
     */
    readonly crossSeriesReducer?: string;
    /**
     * The set of fields to preserve when crossSeriesReducer is specified.
     *
     * The groupByFields determine how
     * the time series are partitioned
     * into subsets prior to applying the
     * aggregation function. Each subset
     * contains time series that have the
     * same value for each of the
     * grouping fields. Each individual
     * time series is a member of exactly
     * one subset. The crossSeriesReducer
     * is applied to each subset of time
     * series. It is not possible to
     * reduce across different resource
     * types, so this field implicitly
     * contains resource.type. Fields not
     * specified in groupByFields are
     * aggregated away. If groupByFields
     * is not specified and all the time
     * series have the same resource
     * type, then the time series are
     * aggregated into a single output
     * time series. If crossSeriesReducer
     * is not defined, this field is
     * ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#group_by_fields MonitoringAlertPolicy#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The approach to be used to align individual time series.
     *
     * Not all
     * alignment functions may be applied
     * to all time series, depending on
     * the metric type and value type of
     * the original time series.
     * Alignment may change the metric
     * type or the value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
     *
     * @stability stable
     */
    readonly perSeriesAligner?: string;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionAbsentTrigger {
    /**
     * The absolute number of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#count MonitoringAlertPolicy#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The percentage of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#percent MonitoringAlertPolicy#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionAbsent {
    /**
     * The amount of time that a time series must fail to report new data to be considered failing.
     *
     * Currently, only values that are a
     * multiple of a minute--e.g. 60s, 120s, or 300s
     * --are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#duration MonitoringAlertPolicy#duration}
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * A filter that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the MetricService.ListTimeSeries request (that call is useful to verify the time series that will be retrieved / processed) and must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#filter MonitoringAlertPolicy#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#aggregations MonitoringAlertPolicy#aggregations}
     *
     * @stability stable
     */
    readonly aggregations?: MonitoringAlertPolicyConditionsConditionAbsentAggregations[];
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#trigger MonitoringAlertPolicy#trigger}
     *
     * @stability stable
     */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionAbsentTrigger[];
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger {
    /**
     * The absolute number of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#count MonitoringAlertPolicy#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The percentage of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#percent MonitoringAlertPolicy#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage {
    /**
     * The amount of time that a time series must violate the threshold to be considered failing.
     *
     * Currently, only values that are a
     * multiple of a minute--e.g., 0, 60, 120, or
     * 300 seconds--are supported. If an invalid
     * value is given, an error will be returned.
     * When choosing a duration, it is useful to
     * keep in mind the frequency of the underlying
     * time series data (which may also be affected
     * by any alignments specified in the
     * aggregations field); a good duration is long
     * enough so that a single outlier does not
     * generate spurious alerts, but short enough
     * that unhealthy states are detected and
     * alerted on quickly.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#duration MonitoringAlertPolicy#duration}
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * Monitoring Query Language query that outputs a boolean stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#query MonitoringAlertPolicy#query}
     *
     * @stability stable
     */
    readonly query: string;
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#trigger MonitoringAlertPolicy#trigger}
     *
     * @stability stable
     */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguageTrigger[];
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThresholdAggregations {
    /**
     * The alignment period for per-time series alignment.
     *
     * If present,
     * alignmentPeriod must be at least
     * 60 seconds. After per-time series
     * alignment, each time series will
     * contain data points only on the
     * period boundaries. If
     * perSeriesAligner is not specified
     * or equals ALIGN_NONE, then this
     * field is ignored. If
     * perSeriesAligner is specified and
     * does not equal ALIGN_NONE, then
     * this field must be defined;
     * otherwise an error is returned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#alignment_period MonitoringAlertPolicy#alignment_period}
     *
     * @stability stable
     */
    readonly alignmentPeriod?: string;
    /**
     * The approach to be used to combine time series.
     *
     * Not all reducer
     * functions may be applied to all
     * time series, depending on the
     * metric type and the value type of
     * the original time series.
     * Reduction may change the metric
     * type of value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
     *
     * @stability stable
     */
    readonly crossSeriesReducer?: string;
    /**
     * The set of fields to preserve when crossSeriesReducer is specified.
     *
     * The groupByFields determine how
     * the time series are partitioned
     * into subsets prior to applying the
     * aggregation function. Each subset
     * contains time series that have the
     * same value for each of the
     * grouping fields. Each individual
     * time series is a member of exactly
     * one subset. The crossSeriesReducer
     * is applied to each subset of time
     * series. It is not possible to
     * reduce across different resource
     * types, so this field implicitly
     * contains resource.type. Fields not
     * specified in groupByFields are
     * aggregated away. If groupByFields
     * is not specified and all the time
     * series have the same resource
     * type, then the time series are
     * aggregated into a single output
     * time series. If crossSeriesReducer
     * is not defined, this field is
     * ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#group_by_fields MonitoringAlertPolicy#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The approach to be used to align individual time series.
     *
     * Not all
     * alignment functions may be applied
     * to all time series, depending on
     * the metric type and value type of
     * the original time series.
     * Alignment may change the metric
     * type or the value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
     *
     * @stability stable
     */
    readonly perSeriesAligner?: string;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations {
    /**
     * The alignment period for per-time series alignment.
     *
     * If present,
     * alignmentPeriod must be at least
     * 60 seconds. After per-time series
     * alignment, each time series will
     * contain data points only on the
     * period boundaries. If
     * perSeriesAligner is not specified
     * or equals ALIGN_NONE, then this
     * field is ignored. If
     * perSeriesAligner is specified and
     * does not equal ALIGN_NONE, then
     * this field must be defined;
     * otherwise an error is returned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#alignment_period MonitoringAlertPolicy#alignment_period}
     *
     * @stability stable
     */
    readonly alignmentPeriod?: string;
    /**
     * The approach to be used to combine time series.
     *
     * Not all reducer
     * functions may be applied to all
     * time series, depending on the
     * metric type and the value type of
     * the original time series.
     * Reduction may change the metric
     * type of value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["REDUCE_NONE", "REDUCE_MEAN", "REDUCE_MIN", "REDUCE_MAX", "REDUCE_SUM", "REDUCE_STDDEV", "REDUCE_COUNT", "REDUCE_COUNT_TRUE", "REDUCE_COUNT_FALSE", "REDUCE_FRACTION_TRUE", "REDUCE_PERCENTILE_99", "REDUCE_PERCENTILE_95", "REDUCE_PERCENTILE_50", "REDUCE_PERCENTILE_05"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#cross_series_reducer MonitoringAlertPolicy#cross_series_reducer}
     *
     * @stability stable
     */
    readonly crossSeriesReducer?: string;
    /**
     * The set of fields to preserve when crossSeriesReducer is specified.
     *
     * The groupByFields determine how
     * the time series are partitioned
     * into subsets prior to applying the
     * aggregation function. Each subset
     * contains time series that have the
     * same value for each of the
     * grouping fields. Each individual
     * time series is a member of exactly
     * one subset. The crossSeriesReducer
     * is applied to each subset of time
     * series. It is not possible to
     * reduce across different resource
     * types, so this field implicitly
     * contains resource.type. Fields not
     * specified in groupByFields are
     * aggregated away. If groupByFields
     * is not specified and all the time
     * series have the same resource
     * type, then the time series are
     * aggregated into a single output
     * time series. If crossSeriesReducer
     * is not defined, this field is
     * ignored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#group_by_fields MonitoringAlertPolicy#group_by_fields}
     *
     * @stability stable
     */
    readonly groupByFields?: string[];
    /**
     * The approach to be used to align individual time series.
     *
     * Not all
     * alignment functions may be applied
     * to all time series, depending on
     * the metric type and value type of
     * the original time series.
     * Alignment may change the metric
     * type or the value type of the time
     * series.Time series data must be
     * aligned in order to perform cross-
     * time series reduction. If
     * crossSeriesReducer is specified,
     * then perSeriesAligner must be
     * specified and not equal ALIGN_NONE
     * and alignmentPeriod must be
     * specified; otherwise, an error is
     * returned. Possible values: ["ALIGN_NONE", "ALIGN_DELTA", "ALIGN_RATE", "ALIGN_INTERPOLATE", "ALIGN_NEXT_OLDER", "ALIGN_MIN", "ALIGN_MAX", "ALIGN_MEAN", "ALIGN_COUNT", "ALIGN_SUM", "ALIGN_STDDEV", "ALIGN_COUNT_TRUE", "ALIGN_COUNT_FALSE", "ALIGN_FRACTION_TRUE", "ALIGN_PERCENTILE_99", "ALIGN_PERCENTILE_95", "ALIGN_PERCENTILE_50", "ALIGN_PERCENTILE_05", "ALIGN_PERCENT_CHANGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#per_series_aligner MonitoringAlertPolicy#per_series_aligner}
     *
     * @stability stable
     */
    readonly perSeriesAligner?: string;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThresholdTrigger {
    /**
     * The absolute number of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#count MonitoringAlertPolicy#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * The percentage of time series that must fail the predicate for the condition to be triggered.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#percent MonitoringAlertPolicy#percent}
     *
     * @stability stable
     */
    readonly percent?: number;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditionsConditionThreshold {
    /**
     * The comparison to apply between the time series (indicated by filter and aggregation) and the threshold (indicated by threshold_value).
     *
     * The comparison is applied
     * on each time series, with the time series on
     * the left-hand side and the threshold on the
     * right-hand side. Only COMPARISON_LT and
     * COMPARISON_GT are supported currently. Possible values: ["COMPARISON_GT", "COMPARISON_GE", "COMPARISON_LT", "COMPARISON_LE", "COMPARISON_EQ", "COMPARISON_NE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#comparison MonitoringAlertPolicy#comparison}
     *
     * @stability stable
     */
    readonly comparison: string;
    /**
     * A filter that identifies a time series that should be used as the denominator of a ratio that will be compared with the threshold.
     *
     * If
     * a denominator_filter is specified, the time
     * series specified by the filter field will be
     * used as the numerator.The filter is similar
     * to the one that is specified in the
     * MetricService.ListTimeSeries request (that
     * call is useful to verify the time series
     * that will be retrieved / processed) and must
     * specify the metric type and optionally may
     * contain restrictions on resource type,
     * resource labels, and metric labels. This
     * field may not exceed 2048 Unicode characters
     * in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#denominator_filter MonitoringAlertPolicy#denominator_filter}
     *
     * @stability stable
     */
    readonly denominatorFilter?: string;
    /**
     * The amount of time that a time series must violate the threshold to be considered failing.
     *
     * Currently, only values that are a
     * multiple of a minute--e.g., 0, 60, 120, or
     * 300 seconds--are supported. If an invalid
     * value is given, an error will be returned.
     * When choosing a duration, it is useful to
     * keep in mind the frequency of the underlying
     * time series data (which may also be affected
     * by any alignments specified in the
     * aggregations field); a good duration is long
     * enough so that a single outlier does not
     * generate spurious alerts, but short enough
     * that unhealthy states are detected and
     * alerted on quickly.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#duration MonitoringAlertPolicy#duration}
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * A filter that identifies which time series should be compared with the threshold.The filter is similar to the one that is specified in the MetricService.ListTimeSeries request (that call is useful to verify the time series that will be retrieved / processed) and must specify the metric type and optionally may contain restrictions on resource type, resource labels, and metric labels. This field may not exceed 2048 Unicode characters in length.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#filter MonitoringAlertPolicy#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * A value against which to compare the time series.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#threshold_value MonitoringAlertPolicy#threshold_value}
     *
     * @stability stable
     */
    readonly thresholdValue?: number;
    /**
     * aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#aggregations MonitoringAlertPolicy#aggregations}
     *
     * @stability stable
     */
    readonly aggregations?: MonitoringAlertPolicyConditionsConditionThresholdAggregations[];
    /**
     * denominator_aggregations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#denominator_aggregations MonitoringAlertPolicy#denominator_aggregations}
     *
     * @stability stable
     */
    readonly denominatorAggregations?: MonitoringAlertPolicyConditionsConditionThresholdDenominatorAggregations[];
    /**
     * trigger block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#trigger MonitoringAlertPolicy#trigger}
     *
     * @stability stable
     */
    readonly trigger?: MonitoringAlertPolicyConditionsConditionThresholdTrigger[];
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyConditions {
    /**
     * A short name or phrase used to identify the condition in dashboards, notifications, and incidents.
     *
     * To avoid confusion, don't use the same
     * display name for multiple conditions in the same
     * policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#display_name MonitoringAlertPolicy#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * condition_absent block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#condition_absent MonitoringAlertPolicy#condition_absent}
     *
     * @stability stable
     */
    readonly conditionAbsent?: MonitoringAlertPolicyConditionsConditionAbsent[];
    /**
     * condition_monitoring_query_language block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#condition_monitoring_query_language MonitoringAlertPolicy#condition_monitoring_query_language}
     *
     * @stability stable
     */
    readonly conditionMonitoringQueryLanguage?: MonitoringAlertPolicyConditionsConditionMonitoringQueryLanguage[];
    /**
     * condition_threshold block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#condition_threshold MonitoringAlertPolicy#condition_threshold}
     *
     * @stability stable
     */
    readonly conditionThreshold?: MonitoringAlertPolicyConditionsConditionThreshold[];
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyDocumentation {
    /**
     * The text of the documentation, interpreted according to mimeType.
     *
     * The content may not exceed 8,192 Unicode characters and may not
     * exceed more than 10,240 bytes when encoded in UTF-8 format,
     * whichever is smaller.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#content MonitoringAlertPolicy#content}
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * The format of the content field. Presently, only the value "text/markdown" is supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#mime_type MonitoringAlertPolicy#mime_type}
     *
     * @stability stable
     */
    readonly mimeType?: string;
}
/**
 * @stability stable
 */
export interface MonitoringAlertPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#create MonitoringAlertPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#delete MonitoringAlertPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html#update MonitoringAlertPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html google_monitoring_alert_policy}.
 *
 * @stability stable
 */
export declare class MonitoringAlertPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_alert_policy.html google_monitoring_alert_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringAlertPolicyConfig);
    private _combiner;
    /**
     * @stability stable
     */
    get combiner(): string;
    /**
     * @stability stable
     */
    set combiner(value: string);
    /**
     * @stability stable
     */
    get combinerInput(): string;
    /**
     * @stability stable
     */
    creationRecord(index: string): MonitoringAlertPolicyCreationRecord;
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean;
    /**
     * @stability stable
     */
    set enabled(value: boolean);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _notificationChannels?;
    /**
     * @stability stable
     */
    get notificationChannels(): string[];
    /**
     * @stability stable
     */
    set notificationChannels(value: string[]);
    /**
     * @stability stable
     */
    resetNotificationChannels(): void;
    /**
     * @stability stable
     */
    get notificationChannelsInput(): string[] | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _userLabels?;
    /**
     * @stability stable
     */
    get userLabels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set userLabels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetUserLabels(): void;
    /**
     * @stability stable
     */
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _conditions;
    /**
     * @stability stable
     */
    get conditions(): MonitoringAlertPolicyConditions[];
    /**
     * @stability stable
     */
    set conditions(value: MonitoringAlertPolicyConditions[]);
    /**
     * @stability stable
     */
    get conditionsInput(): MonitoringAlertPolicyConditions[];
    private _documentation?;
    /**
     * @stability stable
     */
    get documentation(): MonitoringAlertPolicyDocumentation[];
    /**
     * @stability stable
     */
    set documentation(value: MonitoringAlertPolicyDocumentation[]);
    /**
     * @stability stable
     */
    resetDocumentation(): void;
    /**
     * @stability stable
     */
    get documentationInput(): MonitoringAlertPolicyDocumentation[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringAlertPolicyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: MonitoringAlertPolicyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringAlertPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
