import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringSloConfig extends cdktf.TerraformMetaArguments {
    /**
     * A calendar period, semantically "since the start of the current <calendarPeriod>". Possible values: ["DAY", "WEEK", "FORTNIGHT", "MONTH"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#calendar_period MonitoringSlo#calendar_period}
     *
     * @stability stable
     */
    readonly calendarPeriod?: string;
    /**
     * Name used for UI elements listing this SLO.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#display_name MonitoringSlo#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The fraction of service that must be good in order for this objective to be met.
     *
     * 0 < goal <= 0.999
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#goal MonitoringSlo#goal}
     *
     * @stability stable
     */
    readonly goal: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#project MonitoringSlo#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A rolling time period, semantically "in the past X days". Must be between 1 to 30 days, inclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#rolling_period_days MonitoringSlo#rolling_period_days}
     *
     * @stability stable
     */
    readonly rollingPeriodDays?: number;
    /**
     * ID of the service to which this SLO belongs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#service MonitoringSlo#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#slo_id MonitoringSlo#slo_id}
     *
     * @stability stable
     */
    readonly sloId?: string;
    /**
     * basic_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#basic_sli MonitoringSlo#basic_sli}
     *
     * @stability stable
     */
    readonly basicSli?: MonitoringSloBasicSli[];
    /**
     * request_based_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#request_based_sli MonitoringSlo#request_based_sli}
     *
     * @stability stable
     */
    readonly requestBasedSli?: MonitoringSloRequestBasedSli[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#timeouts MonitoringSlo#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringSloTimeouts;
    /**
     * windows_based_sli block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#windows_based_sli MonitoringSlo#windows_based_sli}
     *
     * @stability stable
     */
    readonly windowsBasedSli?: MonitoringSloWindowsBasedSli[];
}
/**
 * @stability stable
 */
export interface MonitoringSloBasicSliAvailability {
    /**
     * Whether an availability SLI is enabled or not. Must be set to true. Defaults to 'true'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#enabled MonitoringSlo#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
}
/**
 * @stability stable
 */
export interface MonitoringSloBasicSliLatency {
    /**
     * A duration string, e.g. 10s. Good service is defined to be the count of requests made to this service that return in no more than threshold.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#threshold MonitoringSlo#threshold}
     *
     * @stability stable
     */
    readonly threshold: string;
}
/**
 * @stability stable
 */
export interface MonitoringSloBasicSli {
    /**
     * An optional set of locations to which this SLI is relevant.
     *
     * Telemetry from other locations will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * locations in which the Service has activity. For service types
     * that don't support breaking down by location, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#location MonitoringSlo#location}
     *
     * @stability stable
     */
    readonly location?: string[];
    /**
     * An optional set of RPCs to which this SLI is relevant.
     *
     * Telemetry from other methods will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * the Service's methods. For service types that don't support
     * breaking down by method, setting this field will result in an
     * error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#method MonitoringSlo#method}
     *
     * @stability stable
     */
    readonly method?: string[];
    /**
     * The set of API versions to which this SLI is relevant.
     *
     * Telemetry from other API versions will not be used to
     * calculate performance for this SLI. If omitted,
     * this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#version MonitoringSlo#version}
     *
     * @stability stable
     */
    readonly version?: string[];
    /**
     * availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#availability MonitoringSlo#availability}
     *
     * @stability stable
     */
    readonly availability?: MonitoringSloBasicSliAvailability[];
    /**
     * latency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#latency MonitoringSlo#latency}
     *
     * @stability stable
     */
    readonly latency?: MonitoringSloBasicSliLatency[];
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSliDistributionCutRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSliDistributionCut {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) aggregating values to quantify the good service provided.
     *
     * Must have ValueType = DISTRIBUTION and
     * MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_filter MonitoringSlo#distribution_filter}
     *
     * @stability stable
     */
    readonly distributionFilter: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloRequestBasedSliDistributionCutRange[];
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSliGoodTotalRatio {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying bad service provided, either demanded service that was not provided or demanded service that was of inadequate quality.
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#bad_service_filter MonitoringSlo#bad_service_filter}
     *
     * @stability stable
     */
    readonly badServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying good service provided. Must have ValueType = DOUBLE or ValueType = INT64 and must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_service_filter MonitoringSlo#good_service_filter}
     *
     * @stability stable
     */
    readonly goodServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying total demanded service.
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
     * must be set (good + bad = total is assumed).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#total_service_filter MonitoringSlo#total_service_filter}
     *
     * @stability stable
     */
    readonly totalServiceFilter?: string;
}
/**
 * @stability stable
 */
export interface MonitoringSloRequestBasedSli {
    /**
     * distribution_cut block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_cut MonitoringSlo#distribution_cut}
     *
     * @stability stable
     */
    readonly distributionCut?: MonitoringSloRequestBasedSliDistributionCut[];
    /**
     * good_total_ratio block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_total_ratio MonitoringSlo#good_total_ratio}
     *
     * @stability stable
     */
    readonly goodTotalRatio?: MonitoringSloRequestBasedSliGoodTotalRatio[];
}
/**
 * @stability stable
 */
export interface MonitoringSloTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#create MonitoringSlo#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#delete MonitoringSlo#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#update MonitoringSlo#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability {
    /**
     * Whether an availability SLI is enabled or not. Must be set to 'true. Defaults to 'true'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#enabled MonitoringSlo#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency {
    /**
     * A duration string, e.g. 10s. Good service is defined to be the count of requests made to this service that return in no more than threshold.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#threshold MonitoringSlo#threshold}
     *
     * @stability stable
     */
    readonly threshold: string;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance {
    /**
     * An optional set of locations to which this SLI is relevant.
     *
     * Telemetry from other locations will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * locations in which the Service has activity. For service types
     * that don't support breaking down by location, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#location MonitoringSlo#location}
     *
     * @stability stable
     */
    readonly location?: string[];
    /**
     * An optional set of RPCs to which this SLI is relevant.
     *
     * Telemetry from other methods will not be used to calculate
     * performance for this SLI. If omitted, this SLI applies to all
     * the Service's methods. For service types that don't support
     * breaking down by method, setting this field will result in an
     * error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#method MonitoringSlo#method}
     *
     * @stability stable
     */
    readonly method?: string[];
    /**
     * The set of API versions to which this SLI is relevant.
     *
     * Telemetry from other API versions will not be used to
     * calculate performance for this SLI. If omitted,
     * this SLI applies to all API versions. For service types
     * that don't support breaking down by version, setting this
     * field will result in an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#version MonitoringSlo#version}
     *
     * @stability stable
     */
    readonly version?: string[];
    /**
     * availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#availability MonitoringSlo#availability}
     *
     * @stability stable
     */
    readonly availability?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability[];
    /**
     * latency block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#latency MonitoringSlo#latency}
     *
     * @stability stable
     */
    readonly latency?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency[];
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) aggregating values to quantify the good service provided.
     *
     * Must have ValueType = DISTRIBUTION and
     * MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_filter MonitoringSlo#distribution_filter}
     *
     * @stability stable
     */
    readonly distributionFilter: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange[];
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying bad service provided, either demanded service that was not provided or demanded service that was of inadequate quality. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#bad_service_filter MonitoringSlo#bad_service_filter}
     *
     * @stability stable
     */
    readonly badServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying good service provided. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_service_filter MonitoringSlo#good_service_filter}
     *
     * @stability stable
     */
    readonly goodServiceFilter?: string;
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) quantifying total demanded service. Exactly two of good, bad, or total service filter must be defined (where good + bad = total is assumed).
     *
     * Must have ValueType = DOUBLE or ValueType = INT64 and
     * must have MetricKind = DELTA or MetricKind = CUMULATIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#total_service_filter MonitoringSlo#total_service_filter}
     *
     * @stability stable
     */
    readonly totalServiceFilter?: string;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance {
    /**
     * distribution_cut block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#distribution_cut MonitoringSlo#distribution_cut}
     *
     * @stability stable
     */
    readonly distributionCut?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut[];
    /**
     * good_total_ratio block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_total_ratio MonitoringSlo#good_total_ratio}
     *
     * @stability stable
     */
    readonly goodTotalRatio?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio[];
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliGoodTotalRatioThreshold {
    /**
     * If window performance >= threshold, the window is counted as good.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#threshold MonitoringSlo#threshold}
     *
     * @stability stable
     */
    readonly threshold?: number;
    /**
     * basic_sli_performance block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#basic_sli_performance MonitoringSlo#basic_sli_performance}
     *
     * @stability stable
     */
    readonly basicSliPerformance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance[];
    /**
     * performance block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#performance MonitoringSlo#performance}
     *
     * @stability stable
     */
    readonly performance?: MonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance[];
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricMeanInRangeRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricMeanInRange {
    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE. Mean value 'X' should satisfy 'range.min <= X < range.max' under good service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#time_series MonitoringSlo#time_series}
     *
     * @stability stable
     */
    readonly timeSeries: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloWindowsBasedSliMetricMeanInRangeRange[];
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricSumInRangeRange {
    /**
     * max value for the range (inclusive). If not given, will be set to "infinity", defining an open range ">= range.min".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#max MonitoringSlo#max}
     *
     * @stability stable
     */
    readonly max?: number;
    /**
     * Min value for the range (inclusive). If not given, will be set to "-infinity", defining an open range "< range.max".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#min MonitoringSlo#min}
     *
     * @stability stable
     */
    readonly min?: number;
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSliMetricSumInRange {
    /**
     * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) specifying the TimeSeries to use for evaluating window quality. The provided TimeSeries must have ValueType = INT64 or ValueType = DOUBLE and MetricKind = GAUGE.
     *
     * Summed value 'X' should satisfy
     * 'range.min <= X < range.max' for a good window.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#time_series MonitoringSlo#time_series}
     *
     * @stability stable
     */
    readonly timeSeries: string;
    /**
     * range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#range MonitoringSlo#range}
     *
     * @stability stable
     */
    readonly range: MonitoringSloWindowsBasedSliMetricSumInRangeRange[];
}
/**
 * @stability stable
 */
export interface MonitoringSloWindowsBasedSli {
    /**
     * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters) with ValueType = BOOL. The window is good if any true values appear in the window. One of 'good_bad_metric_filter', 'good_total_ratio_threshold', 'metric_mean_in_range', 'metric_sum_in_range' must be set for 'windows_based_sli'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_bad_metric_filter MonitoringSlo#good_bad_metric_filter}
     *
     * @stability stable
     */
    readonly goodBadMetricFilter?: string;
    /**
     * Duration over which window quality is evaluated, given as a duration string "{X}s" representing X seconds.
     *
     * Must be an
     * integer fraction of a day and at least 60s.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#window_period MonitoringSlo#window_period}
     *
     * @stability stable
     */
    readonly windowPeriod?: string;
    /**
     * good_total_ratio_threshold block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#good_total_ratio_threshold MonitoringSlo#good_total_ratio_threshold}
     *
     * @stability stable
     */
    readonly goodTotalRatioThreshold?: MonitoringSloWindowsBasedSliGoodTotalRatioThreshold[];
    /**
     * metric_mean_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#metric_mean_in_range MonitoringSlo#metric_mean_in_range}
     *
     * @stability stable
     */
    readonly metricMeanInRange?: MonitoringSloWindowsBasedSliMetricMeanInRange[];
    /**
     * metric_sum_in_range block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html#metric_sum_in_range MonitoringSlo#metric_sum_in_range}
     *
     * @stability stable
     */
    readonly metricSumInRange?: MonitoringSloWindowsBasedSliMetricSumInRange[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html google_monitoring_slo}.
 *
 * @stability stable
 */
export declare class MonitoringSlo extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_slo.html google_monitoring_slo} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringSloConfig);
    private _calendarPeriod?;
    /**
     * @stability stable
     */
    get calendarPeriod(): string;
    /**
     * @stability stable
     */
    set calendarPeriod(value: string);
    /**
     * @stability stable
     */
    resetCalendarPeriod(): void;
    /**
     * @stability stable
     */
    get calendarPeriodInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _goal;
    /**
     * @stability stable
     */
    get goal(): number;
    /**
     * @stability stable
     */
    set goal(value: number);
    /**
     * @stability stable
     */
    get goalInput(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _rollingPeriodDays?;
    /**
     * @stability stable
     */
    get rollingPeriodDays(): number;
    /**
     * @stability stable
     */
    set rollingPeriodDays(value: number);
    /**
     * @stability stable
     */
    resetRollingPeriodDays(): void;
    /**
     * @stability stable
     */
    get rollingPeriodDaysInput(): number | undefined;
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _sloId?;
    /**
     * @stability stable
     */
    get sloId(): string;
    /**
     * @stability stable
     */
    set sloId(value: string);
    /**
     * @stability stable
     */
    resetSloId(): void;
    /**
     * @stability stable
     */
    get sloIdInput(): string | undefined;
    private _basicSli?;
    /**
     * @stability stable
     */
    get basicSli(): MonitoringSloBasicSli[];
    /**
     * @stability stable
     */
    set basicSli(value: MonitoringSloBasicSli[]);
    /**
     * @stability stable
     */
    resetBasicSli(): void;
    /**
     * @stability stable
     */
    get basicSliInput(): MonitoringSloBasicSli[] | undefined;
    private _requestBasedSli?;
    /**
     * @stability stable
     */
    get requestBasedSli(): MonitoringSloRequestBasedSli[];
    /**
     * @stability stable
     */
    set requestBasedSli(value: MonitoringSloRequestBasedSli[]);
    /**
     * @stability stable
     */
    resetRequestBasedSli(): void;
    /**
     * @stability stable
     */
    get requestBasedSliInput(): MonitoringSloRequestBasedSli[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringSloTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: MonitoringSloTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringSloTimeouts | undefined;
    private _windowsBasedSli?;
    /**
     * @stability stable
     */
    get windowsBasedSli(): MonitoringSloWindowsBasedSli[];
    /**
     * @stability stable
     */
    set windowsBasedSli(value: MonitoringSloWindowsBasedSli[]);
    /**
     * @stability stable
     */
    resetWindowsBasedSli(): void;
    /**
     * @stability stable
     */
    get windowsBasedSliInput(): MonitoringSloWindowsBasedSli[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
