import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NotebooksEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * A brief description of this environment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#description NotebooksEnvironment#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Display name of this environment for the UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#display_name NotebooksEnvironment#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * A reference to the zone where the machine resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#location NotebooksEnvironment#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The name specified for the Environment instance. Format: projects/{project_id}/locations/{location}/environments/{environmentId}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#name NotebooksEnvironment#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Path to a Bash script that automatically runs after a notebook instance fully boots up.
     *
     * The path must be a URL or Cloud Storage path. Example: "gs://path-to-file/file-name"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#post_startup_script NotebooksEnvironment#post_startup_script}
     *
     * @stability stable
     */
    readonly postStartupScript?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#project NotebooksEnvironment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * container_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#container_image NotebooksEnvironment#container_image}
     *
     * @stability stable
     */
    readonly containerImage?: NotebooksEnvironmentContainerImage[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#timeouts NotebooksEnvironment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NotebooksEnvironmentTimeouts;
    /**
     * vm_image block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#vm_image NotebooksEnvironment#vm_image}
     *
     * @stability stable
     */
    readonly vmImage?: NotebooksEnvironmentVmImage[];
}
/**
 * @stability stable
 */
export interface NotebooksEnvironmentContainerImage {
    /**
     * The path to the container image repository. For example: gcr.io/{project_id}/{imageName}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#repository NotebooksEnvironment#repository}
     *
     * @stability stable
     */
    readonly repository: string;
    /**
     * The tag of the container image. If not specified, this defaults to the latest tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#tag NotebooksEnvironment#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
}
/**
 * @stability stable
 */
export interface NotebooksEnvironmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#create NotebooksEnvironment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#delete NotebooksEnvironment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#update NotebooksEnvironment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export interface NotebooksEnvironmentVmImage {
    /**
     * Use this VM image family to find the image; the newest image in this family will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#image_family NotebooksEnvironment#image_family}
     *
     * @stability stable
     */
    readonly imageFamily?: string;
    /**
     * Use VM image name to find the image.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#image_name NotebooksEnvironment#image_name}
     *
     * @stability stable
     */
    readonly imageName?: string;
    /**
     * The name of the Google Cloud project that this VM image belongs to. Format: projects/{project_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html#project NotebooksEnvironment#project}
     *
     * @stability stable
     */
    readonly project: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html google_notebooks_environment}.
 *
 * @stability stable
 */
export declare class NotebooksEnvironment extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_environment.html google_notebooks_environment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NotebooksEnvironmentConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _postStartupScript?;
    /**
     * @stability stable
     */
    get postStartupScript(): string;
    /**
     * @stability stable
     */
    set postStartupScript(value: string);
    /**
     * @stability stable
     */
    resetPostStartupScript(): void;
    /**
     * @stability stable
     */
    get postStartupScriptInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _containerImage?;
    /**
     * @stability stable
     */
    get containerImage(): NotebooksEnvironmentContainerImage[];
    /**
     * @stability stable
     */
    set containerImage(value: NotebooksEnvironmentContainerImage[]);
    /**
     * @stability stable
     */
    resetContainerImage(): void;
    /**
     * @stability stable
     */
    get containerImageInput(): NotebooksEnvironmentContainerImage[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): NotebooksEnvironmentTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: NotebooksEnvironmentTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NotebooksEnvironmentTimeouts | undefined;
    private _vmImage?;
    /**
     * @stability stable
     */
    get vmImage(): NotebooksEnvironmentVmImage[];
    /**
     * @stability stable
     */
    set vmImage(value: NotebooksEnvironmentVmImage[]);
    /**
     * @stability stable
     */
    resetVmImage(): void;
    /**
     * @stability stable
     */
    get vmImageInput(): NotebooksEnvironmentVmImage[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
