import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#constraint OrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#org_id OrganizationPolicy#org_id}.
     *
     * @stability stable
     */
    readonly orgId: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#version OrganizationPolicy#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#boolean_policy OrganizationPolicy#boolean_policy}
     *
     * @stability stable
     */
    readonly booleanPolicy?: OrganizationPolicyBooleanPolicy[];
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#list_policy OrganizationPolicy#list_policy}
     *
     * @stability stable
     */
    readonly listPolicy?: OrganizationPolicyListPolicy[];
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#restore_policy OrganizationPolicy#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: OrganizationPolicyRestorePolicy[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#timeouts OrganizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OrganizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#enforced OrganizationPolicy#enforced}
     *
     * @stability stable
     */
    readonly enforced: boolean;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#all OrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#values OrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export interface OrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#all OrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#values OrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export interface OrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#inherit_from_parent OrganizationPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#suggested_value OrganizationPolicy#suggested_value}
     *
     * @stability stable
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#allow OrganizationPolicy#allow}
     *
     * @stability stable
     */
    readonly allow?: OrganizationPolicyListPolicyAllow[];
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#deny OrganizationPolicy#deny}
     *
     * @stability stable
     */
    readonly deny?: OrganizationPolicyListPolicyDeny[];
}
/**
 * @stability stable
 */
export interface OrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#default OrganizationPolicy#default}
     *
     * @stability stable
     */
    readonly default: boolean;
}
/**
 * @stability stable
 */
export interface OrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#create OrganizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#delete OrganizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#read OrganizationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html#update OrganizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html google_organization_policy}.
 *
 * @stability stable
 */
export declare class OrganizationPolicy extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/organization_policy.html google_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrganizationPolicyConfig);
    private _constraint;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _orgId;
    /**
     * @stability stable
     */
    get orgId(): string;
    /**
     * @stability stable
     */
    set orgId(value: string);
    /**
     * @stability stable
     */
    get orgIdInput(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number;
    /**
     * @stability stable
     */
    set version(value: number);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    /**
     * @stability stable
     */
    get booleanPolicy(): OrganizationPolicyBooleanPolicy[];
    /**
     * @stability stable
     */
    set booleanPolicy(value: OrganizationPolicyBooleanPolicy[]);
    /**
     * @stability stable
     */
    resetBooleanPolicy(): void;
    /**
     * @stability stable
     */
    get booleanPolicyInput(): OrganizationPolicyBooleanPolicy[] | undefined;
    private _listPolicy?;
    /**
     * @stability stable
     */
    get listPolicy(): OrganizationPolicyListPolicy[];
    /**
     * @stability stable
     */
    set listPolicy(value: OrganizationPolicyListPolicy[]);
    /**
     * @stability stable
     */
    resetListPolicy(): void;
    /**
     * @stability stable
     */
    get listPolicyInput(): OrganizationPolicyListPolicy[] | undefined;
    private _restorePolicy?;
    /**
     * @stability stable
     */
    get restorePolicy(): OrganizationPolicyRestorePolicy[];
    /**
     * @stability stable
     */
    set restorePolicy(value: OrganizationPolicyRestorePolicy[]);
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): OrganizationPolicyRestorePolicy[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): OrganizationPolicyTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: OrganizationPolicyTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
