import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectIamCustomRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description for the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html#description ProjectIamCustomRole#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The names of the permissions this role grants when bound in an IAM policy.
     *
     * At least one permission must be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html#permissions ProjectIamCustomRole#permissions}
     *
     * @stability stable
     */
    readonly permissions: string[];
    /**
     * The project that the service account will be created in. Defaults to the provider project configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html#project ProjectIamCustomRole#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The camel case role id to use for this role. Cannot contain - characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html#role_id ProjectIamCustomRole#role_id}
     *
     * @stability stable
     */
    readonly roleId: string;
    /**
     * The current launch stage of the role. Defaults to GA.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html#stage ProjectIamCustomRole#stage}
     *
     * @stability stable
     */
    readonly stage?: string;
    /**
     * A human-readable title for the role.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html#title ProjectIamCustomRole#title}
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html google_project_iam_custom_role}.
 *
 * @stability stable
 */
export declare class ProjectIamCustomRole extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_iam_custom_role.html google_project_iam_custom_role} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectIamCustomRoleConfig);
    /**
     * @stability stable
     */
    get deleted(): boolean;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _permissions;
    /**
     * @stability stable
     */
    get permissions(): string[];
    /**
     * @stability stable
     */
    set permissions(value: string[]);
    /**
     * @stability stable
     */
    get permissionsInput(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _roleId;
    /**
     * @stability stable
     */
    get roleId(): string;
    /**
     * @stability stable
     */
    set roleId(value: string);
    /**
     * @stability stable
     */
    get roleIdInput(): string;
    private _stage?;
    /**
     * @stability stable
     */
    get stage(): string;
    /**
     * @stability stable
     */
    set stage(value: string);
    /**
     * @stability stable
     */
    resetStage(): void;
    /**
     * @stability stable
     */
    get stageInput(): string | undefined;
    private _title;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
