import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectUsageExportBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * The bucket to store reports in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html#bucket_name ProjectUsageExportBucket#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * A prefix for the reports, for instance, the project name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html#prefix ProjectUsageExportBucket#prefix}
     *
     * @stability stable
     */
    readonly prefix?: string;
    /**
     * The project to set the export bucket on. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html#project ProjectUsageExportBucket#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html#timeouts ProjectUsageExportBucket#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectUsageExportBucketTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectUsageExportBucketTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html#create ProjectUsageExportBucket#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html#delete ProjectUsageExportBucket#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html google_project_usage_export_bucket}.
 *
 * @stability stable
 */
export declare class ProjectUsageExportBucket extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_usage_export_bucket.html google_project_usage_export_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectUsageExportBucketConfig);
    private _bucketName;
    /**
     * @stability stable
     */
    get bucketName(): string;
    /**
     * @stability stable
     */
    set bucketName(value: string);
    /**
     * @stability stable
     */
    get bucketNameInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _prefix?;
    /**
     * @stability stable
     */
    get prefix(): string;
    /**
     * @stability stable
     */
    set prefix(value: string);
    /**
     * @stability stable
     */
    resetPrefix(): void;
    /**
     * @stability stable
     */
    get prefixInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ProjectUsageExportBucketTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ProjectUsageExportBucketTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectUsageExportBucketTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
