import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PubsubLiteSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the subscription.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#name PubsubLiteSubscription#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#project PubsubLiteSubscription#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#region PubsubLiteSubscription#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * A reference to a Topic resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#topic PubsubLiteSubscription#topic}
     *
     * @stability stable
     */
    readonly topic: string;
    /**
     * The zone of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#zone PubsubLiteSubscription#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * delivery_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#delivery_config PubsubLiteSubscription#delivery_config}
     *
     * @stability stable
     */
    readonly deliveryConfig?: PubsubLiteSubscriptionDeliveryConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#timeouts PubsubLiteSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PubsubLiteSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface PubsubLiteSubscriptionDeliveryConfig {
    /**
     * When this subscription should send messages to subscribers relative to messages persistence in storage. Possible values: ["DELIVER_IMMEDIATELY", "DELIVER_AFTER_STORED", "DELIVERY_REQUIREMENT_UNSPECIFIED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#delivery_requirement PubsubLiteSubscription#delivery_requirement}
     *
     * @stability stable
     */
    readonly deliveryRequirement: string;
}
/**
 * @stability stable
 */
export interface PubsubLiteSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#create PubsubLiteSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#delete PubsubLiteSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html#update PubsubLiteSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html google_pubsub_lite_subscription}.
 *
 * @stability stable
 */
export declare class PubsubLiteSubscription extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_subscription.html google_pubsub_lite_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PubsubLiteSubscriptionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _topic;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    get topicInput(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _deliveryConfig?;
    /**
     * @stability stable
     */
    get deliveryConfig(): PubsubLiteSubscriptionDeliveryConfig[];
    /**
     * @stability stable
     */
    set deliveryConfig(value: PubsubLiteSubscriptionDeliveryConfig[]);
    /**
     * @stability stable
     */
    resetDeliveryConfig(): void;
    /**
     * @stability stable
     */
    get deliveryConfigInput(): PubsubLiteSubscriptionDeliveryConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): PubsubLiteSubscriptionTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: PubsubLiteSubscriptionTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PubsubLiteSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
