import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SccSourceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The description of the source (max of 1024 characters).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#description SccSource#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The source’s display name.
     *
     * A source’s display name must be unique
     * amongst its siblings, for example, two sources with the same parent
     * can't share the same display name. The display name must start and end
     * with a letter or digit, may contain letters, digits, spaces, hyphens,
     * and underscores, and can be no longer than 32 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#display_name SccSource#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * The organization whose Cloud Security Command Center the Source lives in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#organization SccSource#organization}
     *
     * @stability stable
     */
    readonly organization: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#timeouts SccSource#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SccSourceTimeouts;
}
/**
 * @stability stable
 */
export interface SccSourceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#create SccSource#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#delete SccSource#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source.html#update SccSource#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/scc_source.html google_scc_source}.
 *
 * @stability stable
 */
export declare class SccSource extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/scc_source.html google_scc_source} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SccSourceConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _organization;
    /**
     * @stability stable
     */
    get organization(): string;
    /**
     * @stability stable
     */
    set organization(value: string);
    /**
     * @stability stable
     */
    get organizationInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): SccSourceTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: SccSourceTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SccSourceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
