import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecretManagerSecretVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * The current state of the SecretVersion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html#enabled SecretManagerSecretVersion#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * Secret Manager secret resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html#secret SecretManagerSecretVersion#secret}
     *
     * @stability stable
     */
    readonly secret: string;
    /**
     * The secret data. Must be no larger than 64KiB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html#secret_data SecretManagerSecretVersion#secret_data}
     *
     * @stability stable
     */
    readonly secretData: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html#timeouts SecretManagerSecretVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecretManagerSecretVersionTimeouts;
}
/**
 * @stability stable
 */
export interface SecretManagerSecretVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html#create SecretManagerSecretVersion#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html#delete SecretManagerSecretVersion#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html google_secret_manager_secret_version}.
 *
 * @stability stable
 */
export declare class SecretManagerSecretVersion extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/secret_manager_secret_version.html google_secret_manager_secret_version} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecretManagerSecretVersionConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get destroyTime(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean;
    /**
     * @stability stable
     */
    set enabled(value: boolean);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _secret;
    /**
     * @stability stable
     */
    get secret(): string;
    /**
     * @stability stable
     */
    set secret(value: string);
    /**
     * @stability stable
     */
    get secretInput(): string;
    private _secretData;
    /**
     * @stability stable
     */
    get secretData(): string;
    /**
     * @stability stable
     */
    set secretData(value: string);
    /**
     * @stability stable
     */
    get secretDataInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): SecretManagerSecretVersionTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: SecretManagerSecretVersionTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecretManagerSecretVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
