import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceNetworkingConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of VPC network connected with service producers using VPC peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#network ServiceNetworkingConnection#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Named IP address range(s) of PEERING type reserved for this service provider.
     *
     * Note that invoking this method with a different range when connection is already established will not reallocate already provisioned service producer subnetworks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#reserved_peering_ranges ServiceNetworkingConnection#reserved_peering_ranges}
     *
     * @stability stable
     */
    readonly reservedPeeringRanges: string[];
    /**
     * Provider peering service that is managing peering connectivity for a service provider organization.
     *
     * For Google services that support this functionality it is 'servicenetworking.googleapis.com'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#service ServiceNetworkingConnection#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#timeouts ServiceNetworkingConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServiceNetworkingConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface ServiceNetworkingConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#create ServiceNetworkingConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#delete ServiceNetworkingConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html#update ServiceNetworkingConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html google_service_networking_connection}.
 *
 * @stability stable
 */
export declare class ServiceNetworkingConnection extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_networking_connection.html google_service_networking_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceNetworkingConnectionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _network;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string;
    /**
     * @stability stable
     */
    get peering(): string;
    private _reservedPeeringRanges;
    /**
     * @stability stable
     */
    get reservedPeeringRanges(): string[];
    /**
     * @stability stable
     */
    set reservedPeeringRanges(value: string[]);
    /**
     * @stability stable
     */
    get reservedPeeringRangesInput(): string[];
    private _service;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): ServiceNetworkingConnectionTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: ServiceNetworkingConnectionTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServiceNetworkingConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
