import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SpannerDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional list of DDL statements to run inside the newly created database.
     *
     * Statements can create tables, indexes, etc. These statements
     * execute atomically with the creation of the database: if there is an
     * error in any statement, the database is not created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#ddl SpannerDatabase#ddl}
     *
     * @stability stable
     */
    readonly ddl?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#deletion_protection SpannerDatabase#deletion_protection}.
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean;
    /**
     * The instance to create the database on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#instance SpannerDatabase#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * A unique identifier for the database, which cannot be changed after the instance is created.
     *
     * Values are of the form [a-z][-a-z0-9]*[a-z0-9].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#name SpannerDatabase#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#project SpannerDatabase#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * encryption_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#encryption_config SpannerDatabase#encryption_config}
     *
     * @stability stable
     */
    readonly encryptionConfig?: SpannerDatabaseEncryptionConfig[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#timeouts SpannerDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SpannerDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface SpannerDatabaseEncryptionConfig {
    /**
     * Fully qualified name of the KMS key to use to encrypt this database.
     *
     * This key must exist
     * in the same location as the Spanner Database.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#kms_key_name SpannerDatabase#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
}
/**
 * @stability stable
 */
export interface SpannerDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#create SpannerDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#delete SpannerDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html#update SpannerDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html google_spanner_database}.
 *
 * @stability stable
 */
export declare class SpannerDatabase extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/spanner_database.html google_spanner_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SpannerDatabaseConfig);
    private _ddl?;
    /**
     * @stability stable
     */
    get ddl(): string[];
    /**
     * @stability stable
     */
    set ddl(value: string[]);
    /**
     * @stability stable
     */
    resetDdl(): void;
    /**
     * @stability stable
     */
    get ddlInput(): string[] | undefined;
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get state(): string;
    private _encryptionConfig?;
    /**
     * @stability stable
     */
    get encryptionConfig(): SpannerDatabaseEncryptionConfig[];
    /**
     * @stability stable
     */
    set encryptionConfig(value: SpannerDatabaseEncryptionConfig[]);
    /**
     * @stability stable
     */
    resetEncryptionConfig(): void;
    /**
     * @stability stable
     */
    get encryptionConfigInput(): SpannerDatabaseEncryptionConfig[] | undefined;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): SpannerDatabaseTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: SpannerDatabaseTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SpannerDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
