import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * The charset value.
     *
     * See MySQL's
     * [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
     * and Postgres' [Character Set Support](https://www.postgresql.org/docs/9.6/static/multibyte.html)
     * for more details and supported values. Postgres databases only support
     * a value of 'UTF8' at creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#charset SqlDatabase#charset}
     *
     * @stability stable
     */
    readonly charset?: string;
    /**
     * The collation value.
     *
     * See MySQL's
     * [Supported Character Sets and Collations](https://dev.mysql.com/doc/refman/5.7/en/charset-charsets.html)
     * and Postgres' [Collation Support](https://www.postgresql.org/docs/9.6/static/collation.html)
     * for more details and supported values. Postgres databases only support
     * a value of 'en_US.UTF8' at creation time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#collation SqlDatabase#collation}
     *
     * @stability stable
     */
    readonly collation?: string;
    /**
     * The name of the Cloud SQL instance. This does not include the project ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#instance SqlDatabase#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * The name of the database in the Cloud SQL instance. This does not include the project ID or instance name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#name SqlDatabase#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#project SqlDatabase#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#timeouts SqlDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SqlDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface SqlDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#create SqlDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#delete SqlDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sql_database.html#update SqlDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/sql_database.html google_sql_database}.
 *
 * @stability stable
 */
export declare class SqlDatabase extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/sql_database.html google_sql_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SqlDatabaseConfig);
    private _charset?;
    /**
     * @stability stable
     */
    get charset(): string;
    /**
     * @stability stable
     */
    set charset(value: string);
    /**
     * @stability stable
     */
    resetCharset(): void;
    /**
     * @stability stable
     */
    get charsetInput(): string | undefined;
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    set collation(value: string);
    /**
     * @stability stable
     */
    resetCollation(): void;
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): SqlDatabaseTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: SqlDatabaseTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
