import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the containing bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#bucket StorageBucketObject#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Cache-Control directive to specify caching behavior of object data.
     *
     * If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#cache_control StorageBucketObject#cache_control}
     *
     * @stability stable
     */
    readonly cacheControl?: string;
    /**
     * Data as string to be uploaded.
     *
     * Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content StorageBucketObject#content}
     *
     * @stability stable
     */
    readonly content?: string;
    /**
     * Content-Disposition of the object data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_disposition StorageBucketObject#content_disposition}
     *
     * @stability stable
     */
    readonly contentDisposition?: string;
    /**
     * Content-Encoding of the object data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_encoding StorageBucketObject#content_encoding}
     *
     * @stability stable
     */
    readonly contentEncoding?: string;
    /**
     * Content-Language of the object data.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_language StorageBucketObject#content_language}
     *
     * @stability stable
     */
    readonly contentLanguage?: string;
    /**
     * Content-Type of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#content_type StorageBucketObject#content_type}
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#detect_md5hash StorageBucketObject#detect_md5hash}.
     *
     * @stability stable
     */
    readonly detectMd5Hash?: string;
    /**
     * Resource name of the Cloud KMS key that will be used to encrypt the object.
     *
     * Overrides the object metadata's kmsKeyName value, if any.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#kms_key_name StorageBucketObject#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName?: string;
    /**
     * User-provided metadata, in key/value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#metadata StorageBucketObject#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
     * The name of the object. If you're interpolating the name of this object, see output_name instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#name StorageBucketObject#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A path to the data you want to upload. Must be defined if content is not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#source StorageBucketObject#source}
     *
     * @stability stable
     */
    readonly source?: string;
    /**
     * The StorageClass of the new bucket object.
     *
     * Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE. If not provided, this defaults to the bucket's default storage class or to a standard class.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html#storage_class StorageBucketObject#storage_class}
     *
     * @stability stable
     */
    readonly storageClass?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html google_storage_bucket_object}.
 *
 * @stability stable
 */
export declare class StorageBucketObject extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_object.html google_storage_bucket_object} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBucketObjectConfig);
    private _bucket;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string;
    private _cacheControl?;
    /**
     * @stability stable
     */
    get cacheControl(): string;
    /**
     * @stability stable
     */
    set cacheControl(value: string);
    /**
     * @stability stable
     */
    resetCacheControl(): void;
    /**
     * @stability stable
     */
    get cacheControlInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    resetContent(): void;
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _contentDisposition?;
    /**
     * @stability stable
     */
    get contentDisposition(): string;
    /**
     * @stability stable
     */
    set contentDisposition(value: string);
    /**
     * @stability stable
     */
    resetContentDisposition(): void;
    /**
     * @stability stable
     */
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    /**
     * @stability stable
     */
    get contentEncoding(): string;
    /**
     * @stability stable
     */
    set contentEncoding(value: string);
    /**
     * @stability stable
     */
    resetContentEncoding(): void;
    /**
     * @stability stable
     */
    get contentEncodingInput(): string | undefined;
    private _contentLanguage?;
    /**
     * @stability stable
     */
    get contentLanguage(): string;
    /**
     * @stability stable
     */
    set contentLanguage(value: string);
    /**
     * @stability stable
     */
    resetContentLanguage(): void;
    /**
     * @stability stable
     */
    get contentLanguageInput(): string | undefined;
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get crc32C(): string;
    private _detectMd5Hash?;
    /**
     * @stability stable
     */
    get detectMd5Hash(): string;
    /**
     * @stability stable
     */
    set detectMd5Hash(value: string);
    /**
     * @stability stable
     */
    resetDetectMd5Hash(): void;
    /**
     * @stability stable
     */
    get detectMd5HashInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _kmsKeyName?;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    set kmsKeyName(value: string);
    /**
     * @stability stable
     */
    resetKmsKeyName(): void;
    /**
     * @stability stable
     */
    get kmsKeyNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get md5Hash(): string;
    /**
     * @stability stable
     */
    get mediaLink(): string;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    /**
     * @stability stable
     */
    get outputName(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    set storageClass(value: string);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
