import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Enables Bucket Policy Only access to a bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#bucket_policy_only StorageBucket#bucket_policy_only}
     *
     * @stability stable
     */
    readonly bucketPolicyOnly?: boolean;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#default_event_based_hold StorageBucket#default_event_based_hold}.
     *
     * @stability stable
     */
    readonly defaultEventBasedHold?: boolean;
    /**
     * When deleting a bucket, this boolean option will delete all contained objects.
     *
     * If you try to delete a bucket that contains objects, Terraform will fail that run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#force_destroy StorageBucket#force_destroy}
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean;
    /**
     * A set of key/value label pairs to assign to the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#labels StorageBucket#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * The Google Cloud Storage location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#location StorageBucket#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#name StorageBucket#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#project StorageBucket#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Enables Requester Pays on a storage bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#requester_pays StorageBucket#requester_pays}
     *
     * @stability stable
     */
    readonly requesterPays?: boolean;
    /**
     * The Storage Class of the new bucket. Supported values include: STANDARD, MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#storage_class StorageBucket#storage_class}
     *
     * @stability stable
     */
    readonly storageClass?: string;
    /**
     * Enables uniform bucket-level access on a bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#uniform_bucket_level_access StorageBucket#uniform_bucket_level_access}
     *
     * @stability stable
     */
    readonly uniformBucketLevelAccess?: boolean;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#cors StorageBucket#cors}
     *
     * @stability stable
     */
    readonly cors?: StorageBucketCors[];
    /**
     * encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#encryption StorageBucket#encryption}
     *
     * @stability stable
     */
    readonly encryption?: StorageBucketEncryption[];
    /**
     * lifecycle_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#lifecycle_rule StorageBucket#lifecycle_rule}
     *
     * @stability stable
     */
    readonly lifecycleRule?: StorageBucketLifecycleRule[];
    /**
     * logging block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#logging StorageBucket#logging}
     *
     * @stability stable
     */
    readonly logging?: StorageBucketLogging[];
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#retention_policy StorageBucket#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: StorageBucketRetentionPolicy[];
    /**
     * versioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#versioning StorageBucket#versioning}
     *
     * @stability stable
     */
    readonly versioning?: StorageBucketVersioning[];
    /**
     * website block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#website StorageBucket#website}
     *
     * @stability stable
     */
    readonly website?: StorageBucketWebsite[];
}
/**
 * @stability stable
 */
export interface StorageBucketCors {
    /**
     * The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#max_age_seconds StorageBucket#max_age_seconds}
     *
     * @stability stable
     */
    readonly maxAgeSeconds?: number;
    /**
     * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#method StorageBucket#method}
     *
     * @stability stable
     */
    readonly method?: string[];
    /**
     * The list of Origins eligible to receive CORS response headers.
     *
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#origin StorageBucket#origin}
     *
     * @stability stable
     */
    readonly origin?: string[];
    /**
     * The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#response_header StorageBucket#response_header}
     *
     * @stability stable
     */
    readonly responseHeader?: string[];
}
/**
 * @stability stable
 */
export interface StorageBucketEncryption {
    /**
     * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
     *
     * You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#default_kms_key_name StorageBucket#default_kms_key_name}
     *
     * @stability stable
     */
    readonly defaultKmsKeyName: string;
}
/**
 * @stability stable
 */
export interface StorageBucketLifecycleRuleAction {
    /**
     * The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#storage_class StorageBucket#storage_class}
     *
     * @stability stable
     */
    readonly storageClass?: string;
    /**
     * The type of the action of this Lifecycle Rule. Supported values include: Delete and SetStorageClass.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#type StorageBucket#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface StorageBucketLifecycleRuleCondition {
    /**
     * Minimum age of an object in days to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#age StorageBucket#age}
     *
     * @stability stable
     */
    readonly age?: number;
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#created_before StorageBucket#created_before}
     *
     * @stability stable
     */
    readonly createdBefore?: string;
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#custom_time_before StorageBucket#custom_time_before}
     *
     * @stability stable
     */
    readonly customTimeBefore?: string;
    /**
     * Number of days elapsed since the user-specified timestamp set on an object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#days_since_custom_time StorageBucket#days_since_custom_time}
     *
     * @stability stable
     */
    readonly daysSinceCustomTime?: number;
    /**
     * Number of days elapsed since the noncurrent timestamp of an object. This 							condition is relevant only for versioned objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#days_since_noncurrent_time StorageBucket#days_since_noncurrent_time}
     *
     * @stability stable
     */
    readonly daysSinceNoncurrentTime?: number;
    /**
     * Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#matches_storage_class StorageBucket#matches_storage_class}
     *
     * @stability stable
     */
    readonly matchesStorageClass?: string[];
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#noncurrent_time_before StorageBucket#noncurrent_time_before}
     *
     * @stability stable
     */
    readonly noncurrentTimeBefore?: string;
    /**
     * Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#num_newer_versions StorageBucket#num_newer_versions}
     *
     * @stability stable
     */
    readonly numNewerVersions?: number;
    /**
     * Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#with_state StorageBucket#with_state}
     *
     * @stability stable
     */
    readonly withState?: string;
}
/**
 * @stability stable
 */
export interface StorageBucketLifecycleRule {
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#action StorageBucket#action}
     *
     * @stability stable
     */
    readonly action: StorageBucketLifecycleRuleAction[];
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#condition StorageBucket#condition}
     *
     * @stability stable
     */
    readonly condition: StorageBucketLifecycleRuleCondition[];
}
/**
 * @stability stable
 */
export interface StorageBucketLogging {
    /**
     * The bucket that will receive log objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#log_bucket StorageBucket#log_bucket}
     *
     * @stability stable
     */
    readonly logBucket: string;
    /**
     * The object prefix for log objects.
     *
     * If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#log_object_prefix StorageBucket#log_object_prefix}
     *
     * @stability stable
     */
    readonly logObjectPrefix?: string;
}
/**
 * @stability stable
 */
export interface StorageBucketRetentionPolicy {
    /**
     * If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.
     *
     * Caution: Locking a bucket is an irreversible action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#is_locked StorageBucket#is_locked}
     *
     * @stability stable
     */
    readonly isLocked?: boolean;
    /**
     * The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived.
     *
     * The value must be less than 3,155,760,000 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#retention_period StorageBucket#retention_period}
     *
     * @stability stable
     */
    readonly retentionPeriod: number;
}
/**
 * @stability stable
 */
export interface StorageBucketVersioning {
    /**
     * While set to true, versioning is fully enabled for this bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#enabled StorageBucket#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean;
}
/**
 * @stability stable
 */
export interface StorageBucketWebsite {
    /**
     * Behaves as the bucket's directory index where missing objects are treated as potential directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#main_page_suffix StorageBucket#main_page_suffix}
     *
     * @stability stable
     */
    readonly mainPageSuffix?: string;
    /**
     * The custom object to return when a requested resource is not found.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#not_found_page StorageBucket#not_found_page}
     *
     * @stability stable
     */
    readonly notFoundPage?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html google_storage_bucket}.
 *
 * @stability stable
 */
export declare class StorageBucket extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html google_storage_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBucketConfig);
    private _bucketPolicyOnly?;
    /**
     * @stability stable
     */
    get bucketPolicyOnly(): boolean;
    /**
     * @stability stable
     */
    set bucketPolicyOnly(value: boolean);
    /**
     * @stability stable
     */
    resetBucketPolicyOnly(): void;
    /**
     * @stability stable
     */
    get bucketPolicyOnlyInput(): boolean | undefined;
    private _defaultEventBasedHold?;
    /**
     * @stability stable
     */
    get defaultEventBasedHold(): boolean;
    /**
     * @stability stable
     */
    set defaultEventBasedHold(value: boolean);
    /**
     * @stability stable
     */
    resetDefaultEventBasedHold(): void;
    /**
     * @stability stable
     */
    get defaultEventBasedHoldInput(): boolean | undefined;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _requesterPays?;
    /**
     * @stability stable
     */
    get requesterPays(): boolean;
    /**
     * @stability stable
     */
    set requesterPays(value: boolean);
    /**
     * @stability stable
     */
    resetRequesterPays(): void;
    /**
     * @stability stable
     */
    get requesterPaysInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    set storageClass(value: string);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    private _uniformBucketLevelAccess?;
    /**
     * @stability stable
     */
    get uniformBucketLevelAccess(): boolean;
    /**
     * @stability stable
     */
    set uniformBucketLevelAccess(value: boolean);
    /**
     * @stability stable
     */
    resetUniformBucketLevelAccess(): void;
    /**
     * @stability stable
     */
    get uniformBucketLevelAccessInput(): boolean | undefined;
    /**
     * @stability stable
     */
    get url(): string;
    private _cors?;
    /**
     * @stability stable
     */
    get cors(): StorageBucketCors[];
    /**
     * @stability stable
     */
    set cors(value: StorageBucketCors[]);
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): StorageBucketCors[] | undefined;
    private _encryption?;
    /**
     * @stability stable
     */
    get encryption(): StorageBucketEncryption[];
    /**
     * @stability stable
     */
    set encryption(value: StorageBucketEncryption[]);
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): StorageBucketEncryption[] | undefined;
    private _lifecycleRule?;
    /**
     * @stability stable
     */
    get lifecycleRule(): StorageBucketLifecycleRule[];
    /**
     * @stability stable
     */
    set lifecycleRule(value: StorageBucketLifecycleRule[]);
    /**
     * @stability stable
     */
    resetLifecycleRule(): void;
    /**
     * @stability stable
     */
    get lifecycleRuleInput(): StorageBucketLifecycleRule[] | undefined;
    private _logging?;
    /**
     * @stability stable
     */
    get logging(): StorageBucketLogging[];
    /**
     * @stability stable
     */
    set logging(value: StorageBucketLogging[]);
    /**
     * @stability stable
     */
    resetLogging(): void;
    /**
     * @stability stable
     */
    get loggingInput(): StorageBucketLogging[] | undefined;
    private _retentionPolicy?;
    /**
     * @stability stable
     */
    get retentionPolicy(): StorageBucketRetentionPolicy[];
    /**
     * @stability stable
     */
    set retentionPolicy(value: StorageBucketRetentionPolicy[]);
    /**
     * @stability stable
     */
    resetRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): StorageBucketRetentionPolicy[] | undefined;
    private _versioning?;
    /**
     * @stability stable
     */
    get versioning(): StorageBucketVersioning[];
    /**
     * @stability stable
     */
    set versioning(value: StorageBucketVersioning[]);
    /**
     * @stability stable
     */
    resetVersioning(): void;
    /**
     * @stability stable
     */
    get versioningInput(): StorageBucketVersioning[] | undefined;
    private _website?;
    /**
     * @stability stable
     */
    get website(): StorageBucketWebsite[];
    /**
     * @stability stable
     */
    set website(value: StorageBucketWebsite[]);
    /**
     * @stability stable
     */
    resetWebsite(): void;
    /**
     * @stability stable
     */
    get websiteInput(): StorageBucketWebsite[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
