import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageDefaultObjectAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#bucket StorageDefaultObjectAccessControl#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * The entity holding the permission, in one of the following forms: user-{{userId}} user-{{email}} (such as "user-liz@example.com") group-{{groupId}} group-{{email}} (such as "group-example@googlegroups.com") domain-{{domain}} (such as "domain-example.com") project-team-{{projectId}} allUsers allAuthenticatedUsers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#entity StorageDefaultObjectAccessControl#entity}
     *
     * @stability stable
     */
    readonly entity: string;
    /**
     * The name of the object, if applied to an object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#object StorageDefaultObjectAccessControl#object}
     *
     * @stability stable
     */
    readonly object?: string;
    /**
     * The access permission for the entity. Possible values: ["OWNER", "READER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#role StorageDefaultObjectAccessControl#role}
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#timeouts StorageDefaultObjectAccessControl#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageDefaultObjectAccessControlTimeouts;
}
/**
 * @stability stable
 */
export declare class StorageDefaultObjectAccessControlProjectTeam extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get projectNumber(): string;
    /**
     * @stability stable
     */
    get team(): string;
}
/**
 * @stability stable
 */
export interface StorageDefaultObjectAccessControlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#create StorageDefaultObjectAccessControl#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#delete StorageDefaultObjectAccessControl#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html#update StorageDefaultObjectAccessControl#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html google_storage_default_object_access_control}.
 *
 * @stability stable
 */
export declare class StorageDefaultObjectAccessControl extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_default_object_access_control.html google_storage_default_object_access_control} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageDefaultObjectAccessControlConfig);
    private _bucket;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string;
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    get email(): string;
    private _entity;
    /**
     * @stability stable
     */
    get entity(): string;
    /**
     * @stability stable
     */
    set entity(value: string);
    /**
     * @stability stable
     */
    get entityInput(): string;
    /**
     * @stability stable
     */
    get entityId(): string;
    /**
     * @stability stable
     */
    get generation(): number;
    /**
     * @stability stable
     */
    get id(): string;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    resetObject(): void;
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
    /**
     * @stability stable
     */
    projectTeam(index: string): StorageDefaultObjectAccessControlProjectTeam;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): StorageDefaultObjectAccessControlTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: StorageDefaultObjectAccessControlTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageDefaultObjectAccessControlTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
