import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageObjectAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#bucket StorageObjectAccessControl#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * The entity holding the permission, in one of the following forms: user-{{userId}} user-{{email}} (such as "user-liz@example.com") group-{{groupId}} group-{{email}} (such as "group-example@googlegroups.com") domain-{{domain}} (such as "domain-example.com") project-team-{{projectId}} allUsers allAuthenticatedUsers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#entity StorageObjectAccessControl#entity}
     *
     * @stability stable
     */
    readonly entity: string;
    /**
     * The name of the object to apply the access control to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#object StorageObjectAccessControl#object}
     *
     * @stability stable
     */
    readonly object: string;
    /**
     * The access permission for the entity. Possible values: ["OWNER", "READER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#role StorageObjectAccessControl#role}
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#timeouts StorageObjectAccessControl#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageObjectAccessControlTimeouts;
}
/**
 * @stability stable
 */
export declare class StorageObjectAccessControlProjectTeam extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get projectNumber(): string;
    /**
     * @stability stable
     */
    get team(): string;
}
/**
 * @stability stable
 */
export interface StorageObjectAccessControlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#create StorageObjectAccessControl#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#delete StorageObjectAccessControl#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html#update StorageObjectAccessControl#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html google_storage_object_access_control}.
 *
 * @stability stable
 */
export declare class StorageObjectAccessControl extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_object_access_control.html google_storage_object_access_control} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageObjectAccessControlConfig);
    private _bucket;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string;
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    get email(): string;
    private _entity;
    /**
     * @stability stable
     */
    get entity(): string;
    /**
     * @stability stable
     */
    set entity(value: string);
    /**
     * @stability stable
     */
    get entityInput(): string;
    /**
     * @stability stable
     */
    get entityId(): string;
    /**
     * @stability stable
     */
    get generation(): number;
    /**
     * @stability stable
     */
    get id(): string;
    private _object;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string;
    /**
     * @stability stable
     */
    projectTeam(index: string): StorageObjectAccessControlProjectTeam;
    private _role;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string;
    private _timeouts?;
    /**
     * @stability stable
     */
    get timeouts(): StorageObjectAccessControlTimeouts;
    /**
     * @stability stable
     */
    set timeouts(value: StorageObjectAccessControlTimeouts);
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageObjectAccessControlTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
