import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageTransferJobConfig extends cdktf.TerraformMetaArguments {
    /**
     * Unique description to identify the Transfer Job.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#description StorageTransferJob#description}
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The project in which the resource belongs. If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#project StorageTransferJob#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Status of the job.
     *
     * Default: ENABLED. NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#status StorageTransferJob#status}
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule StorageTransferJob#schedule}
     *
     * @stability stable
     */
    readonly schedule: StorageTransferJobSchedule[];
    /**
     * transfer_spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#transfer_spec StorageTransferJob#transfer_spec}
     *
     * @stability stable
     */
    readonly transferSpec: StorageTransferJobTransferSpec[];
}
/**
 * @stability stable
 */
export interface StorageTransferJobScheduleScheduleEndDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#day StorageTransferJob#day}
     *
     * @stability stable
     */
    readonly day: number;
    /**
     * Month of year. Must be from 1 to 12.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#month StorageTransferJob#month}
     *
     * @stability stable
     */
    readonly month: number;
    /**
     * Year of date. Must be from 1 to 9999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#year StorageTransferJob#year}
     *
     * @stability stable
     */
    readonly year: number;
}
/**
 * @stability stable
 */
export interface StorageTransferJobScheduleScheduleStartDate {
    /**
     * Day of month. Must be from 1 to 31 and valid for the year and month.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#day StorageTransferJob#day}
     *
     * @stability stable
     */
    readonly day: number;
    /**
     * Month of year. Must be from 1 to 12.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#month StorageTransferJob#month}
     *
     * @stability stable
     */
    readonly month: number;
    /**
     * Year of date. Must be from 1 to 9999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#year StorageTransferJob#year}
     *
     * @stability stable
     */
    readonly year: number;
}
/**
 * @stability stable
 */
export interface StorageTransferJobScheduleStartTimeOfDay {
    /**
     * Hours of day in 24 hour format. Should be from 0 to 23.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#hours StorageTransferJob#hours}
     *
     * @stability stable
     */
    readonly hours: number;
    /**
     * Minutes of hour of day. Must be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#minutes StorageTransferJob#minutes}
     *
     * @stability stable
     */
    readonly minutes: number;
    /**
     * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#nanos StorageTransferJob#nanos}
     *
     * @stability stable
     */
    readonly nanos: number;
    /**
     * Seconds of minutes of the time. Must normally be from 0 to 59.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#seconds StorageTransferJob#seconds}
     *
     * @stability stable
     */
    readonly seconds: number;
}
/**
 * @stability stable
 */
export interface StorageTransferJobSchedule {
    /**
     * schedule_end_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule_end_date StorageTransferJob#schedule_end_date}
     *
     * @stability stable
     */
    readonly scheduleEndDate?: StorageTransferJobScheduleScheduleEndDate[];
    /**
     * schedule_start_date block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#schedule_start_date StorageTransferJob#schedule_start_date}
     *
     * @stability stable
     */
    readonly scheduleStartDate: StorageTransferJobScheduleScheduleStartDate[];
    /**
     * start_time_of_day block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#start_time_of_day StorageTransferJob#start_time_of_day}
     *
     * @stability stable
     */
    readonly startTimeOfDay?: StorageTransferJobScheduleStartTimeOfDay[];
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey {
    /**
     * AWS Key ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#access_key_id StorageTransferJob#access_key_id}
     *
     * @stability stable
     */
    readonly accessKeyId: string;
    /**
     * AWS Secret Access Key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#secret_access_key StorageTransferJob#secret_access_key}
     *
     * @stability stable
     */
    readonly secretAccessKey: string;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAwsS3DataSource {
    /**
     * S3 Bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * aws_access_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#aws_access_key StorageTransferJob#aws_access_key}
     *
     * @stability stable
     */
    readonly awsAccessKey: StorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey[];
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials {
    /**
     * Azure shared access signature.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#sas_token StorageTransferJob#sas_token}
     *
     * @stability stable
     */
    readonly sasToken: string;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecAzureBlobStorageDataSource {
    /**
     * The container to transfer from the Azure Storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#container StorageTransferJob#container}
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * Root path to transfer objects.
     *
     * Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#path StorageTransferJob#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * The name of the Azure Storage account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#storage_account StorageTransferJob#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount: string;
    /**
     * azure_credentials block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#azure_credentials StorageTransferJob#azure_credentials}
     *
     * @stability stable
     */
    readonly azureCredentials: StorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials[];
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecGcsDataSink {
    /**
     * Google Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecGcsDataSource {
    /**
     * Google Cloud Storage bucket name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#bucket_name StorageTransferJob#bucket_name}
     *
     * @stability stable
     */
    readonly bucketName: string;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecHttpDataSource {
    /**
     * The URL that points to the file that stores the object list entries.
     *
     * This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#list_url StorageTransferJob#list_url}
     *
     * @stability stable
     */
    readonly listUrl: string;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecObjectConditions {
    /**
     * exclude_prefixes must follow the requirements described for include_prefixes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#exclude_prefixes StorageTransferJob#exclude_prefixes}
     *
     * @stability stable
     */
    readonly excludePrefixes?: string[];
    /**
     * If include_refixes is specified, objects that satisfy the object conditions must have names that start with one of the include_prefixes and that do not start with any of the exclude_prefixes.
     *
     * If include_prefixes is not specified, all objects except those that have names starting with one of the exclude_prefixes must satisfy the object conditions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#include_prefixes StorageTransferJob#include_prefixes}
     *
     * @stability stable
     */
    readonly includePrefixes?: string[];
    /**
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#max_time_elapsed_since_last_modification StorageTransferJob#max_time_elapsed_since_last_modification}
     *
     * @stability stable
     */
    readonly maxTimeElapsedSinceLastModification?: string;
    /**
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#min_time_elapsed_since_last_modification StorageTransferJob#min_time_elapsed_since_last_modification}
     *
     * @stability stable
     */
    readonly minTimeElapsedSinceLastModification?: string;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpecTransferOptions {
    /**
     * Whether objects should be deleted from the source after they are transferred to the sink.
     *
     * Note that this option and delete_objects_unique_in_sink are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#delete_objects_from_source_after_transfer StorageTransferJob#delete_objects_from_source_after_transfer}
     *
     * @stability stable
     */
    readonly deleteObjectsFromSourceAfterTransfer?: boolean;
    /**
     * Whether objects that exist only in the sink should be deleted.
     *
     * Note that this option and delete_objects_from_source_after_transfer are mutually exclusive.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#delete_objects_unique_in_sink StorageTransferJob#delete_objects_unique_in_sink}
     *
     * @stability stable
     */
    readonly deleteObjectsUniqueInSink?: boolean;
    /**
     * Whether overwriting objects that already exist in the sink is allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#overwrite_objects_already_existing_in_sink StorageTransferJob#overwrite_objects_already_existing_in_sink}
     *
     * @stability stable
     */
    readonly overwriteObjectsAlreadyExistingInSink?: boolean;
}
/**
 * @stability stable
 */
export interface StorageTransferJobTransferSpec {
    /**
     * aws_s3_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#aws_s3_data_source StorageTransferJob#aws_s3_data_source}
     *
     * @stability stable
     */
    readonly awsS3DataSource?: StorageTransferJobTransferSpecAwsS3DataSource[];
    /**
     * azure_blob_storage_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#azure_blob_storage_data_source StorageTransferJob#azure_blob_storage_data_source}
     *
     * @stability stable
     */
    readonly azureBlobStorageDataSource?: StorageTransferJobTransferSpecAzureBlobStorageDataSource[];
    /**
     * gcs_data_sink block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#gcs_data_sink StorageTransferJob#gcs_data_sink}
     *
     * @stability stable
     */
    readonly gcsDataSink?: StorageTransferJobTransferSpecGcsDataSink[];
    /**
     * gcs_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#gcs_data_source StorageTransferJob#gcs_data_source}
     *
     * @stability stable
     */
    readonly gcsDataSource?: StorageTransferJobTransferSpecGcsDataSource[];
    /**
     * http_data_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#http_data_source StorageTransferJob#http_data_source}
     *
     * @stability stable
     */
    readonly httpDataSource?: StorageTransferJobTransferSpecHttpDataSource[];
    /**
     * object_conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#object_conditions StorageTransferJob#object_conditions}
     *
     * @stability stable
     */
    readonly objectConditions?: StorageTransferJobTransferSpecObjectConditions[];
    /**
     * transfer_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html#transfer_options StorageTransferJob#transfer_options}
     *
     * @stability stable
     */
    readonly transferOptions?: StorageTransferJobTransferSpecTransferOptions[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html google_storage_transfer_job}.
 *
 * @stability stable
 */
export declare class StorageTransferJob extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_transfer_job.html google_storage_transfer_job} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageTransferJobConfig);
    /**
     * @stability stable
     */
    get creationTime(): string;
    /**
     * @stability stable
     */
    get deletionTime(): string;
    private _description;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastModificationTime(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): StorageTransferJobSchedule[];
    /**
     * @stability stable
     */
    set schedule(value: StorageTransferJobSchedule[]);
    /**
     * @stability stable
     */
    get scheduleInput(): StorageTransferJobSchedule[];
    private _transferSpec;
    /**
     * @stability stable
     */
    get transferSpec(): StorageTransferJobTransferSpec[];
    /**
     * @stability stable
     */
    set transferSpec(value: StorageTransferJobTransferSpec[]);
    /**
     * @stability stable
     */
    get transferSpecInput(): StorageTransferJobTransferSpec[];
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
