# Autosubmit API

# Table of Contents

1. [Overview](#overview)
2. [Autosubmit Big Picture](#autosubmit-big-picture)
3. [General Knowledge Requirements](#general-knowledge-requirements)
4. [Deployment](#deployment)

## Overview

Autosubmit API is a package that consumes the information generated by Autosubmit and serves it as an API.

Distribution: https://pypi.org/project/autosubmit-api/

See the wiki for documentation.

## Autosubmit Big Picture

![Autosubmit Big Picture](/docs/Total_Autosubmit_Diagram.png)

In this image you can see the flow of information in the **Autosubmit environment**.

* **Autosubmit**: Machines running Autosubmit.
* **Remote Platforms**: Platforms (HPCs in most cases) to which Autosubmit connects to run jobs. 
* **Experiment Database**: Starting from Autosubmit `3.13.0`, each experiment generates a set of databases that save important (reusable) information about it. We have the `historical database`, `graph database`, `structures database`.
* **File System**: The file system where the experiment files are stored.
* **Data Process Workers**: **Autosubmit API** implements a set of workers that periodically collect information from the experiments or complement that information. In the current **BSC** implementation, these workers are running no `bscesweb04` under `webadmin` user.
* **Main Database**: **Autosubmit API** uses a centralized database to keep track of important experiment information. The **workers** fill this information. **Autosubmit** also writes into this database.
* **Autosubmit API**: See [Autosubmit API](https://earth.bsc.es/gitlab/es/autosubmit_api). Currently, under **BSC** implementation, this API is running on `bscesweb04` under `webadmin` user. This API exposes a set of requests that **Autosubmit GUI** consumes and serves to the users through the front end.
* **Autosubmit GUI**: This project.
* **Authentication Server**: **BSC Central Authentication Service**.
* **Users**: Users that access the GUI through their web browsers from any device. The current implementation requires that an user generates a token using the Authentication server once every 5 days.

## General Knowledge Requirements

* Python 2.7
* Object Oriented Programming
* Flask
* Gunicorn
* Unit testing




