# -*- coding: utf-8 -*-

block_dic = {
    "a": '''
 .----------------.
| .--------------. |
| |      __      | |
| |     /  \     | |
| |    / /\ \    | |
| |   / ____ \   | |
| | _/ /    \ \_ | |
| ||____|  |____|| |
| |              | |
| '--------------' |
 '----------------'
''',
    "b": '''
 .----------------.
| .--------------. |
| |   ______     | |
| |  |_   _ \    | |
| |    | |_) |   | |
| |    |  __'.   | |
| |   _| |__) |  | |
| |  |_______/   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "c": '''
 .----------------.
| .--------------. |
| |     ______   | |
| |   .' ___  |  | |
| |  / .'   \_|  | |
| |  | |         | |
| |  \ `.___.'\  | |
| |   `._____.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "d": '''
 .----------------.
| .--------------. |
| |  ________    | |
| | |_   ___ `.  | |
| |   | |   `. \ | |
| |   | |    | | | |
| |  _| |___.' / | |
| | |________.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "e": '''
 .----------------.
| .--------------. |
| |  _________   | |
| | |_   ___  |  | |
| |   | |_  \_|  | |
| |   |  _|  _   | |
| |  _| |___/ |  | |
| | |_________|  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "f": '''
 .----------------.
| .--------------. |
| |  _________   | |
| | |_   ___  |  | |
| |   | |_  \_|  | |
| |   |  _|      | |
| |  _| |_       | |
| | |_____|      | |
| |              | |
| '--------------' |
 '----------------'
''',
    "g": '''
 .----------------.
| .--------------. |
| |    ______    | |
| |  .' ___  |   | |
| | / .'   \_|   | |
| | | |    ____  | |
| | \ `.___]  _| | |
| |  `._____.'   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "h": '''
 .----------------.
| .--------------. |
| |  ____  ____  | |
| | |_   ||   _| | |
| |   | |__| |   | |
| |   |  __  |   | |
| |  _| |  | |_  | |
| | |____||____| | |
| |              | |
| '--------------' |
 '----------------'
''',
    "i": '''
 .----------------.
| .--------------. |
| |     _____    | |
| |    |_   _|   | |
| |      | |     | |
| |      | |     | |
| |     _| |_    | |
| |    |_____|   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "j": '''
 .----------------.
| .--------------. |
| |     _____    | |
| |    |_   _|   | |
| |      | |     | |
| |   _  | |     | |
| |  | |_' |     | |
| |  `.___.'     | |
| |              | |
| '--------------' |
 '----------------'
''',
    "k": '''
 .----------------.
| .--------------. |
| |  ___  ____   | |
| | |_  ||_  _|  | |
| |   | |_/ /    | |
| |   |  __'.    | |
| |  _| |  \ \_  | |
| | |____||____| | |
| |              | |
| '--------------' |
 '----------------'
''',
    "l": '''
 .----------------.
| .--------------. |
| |   _____      | |
| |  |_   _|     | |
| |    | |       | |
| |    | |   _   | |
| |   _| |__/ |  | |
| |  |________|  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "m": '''
 .----------------.
| .--------------. |
| | ____    ____ | |
| ||_   \  /   _|| |
| |  |   \/   |  | |
| |  | |\  /| |  | |
| | _| |_\/_| |_ | |
| ||_____||_____|| |
| |              | |
| '--------------' |
 '----------------'
''',
    "n": '''
 .-----------------.
| .--------------. |
| | ____  _____  | |
| ||_   \|_   _| | |
| |  |   \ | |   | |
| |  | |\ \| |   | |
| | _| |_\   |_  | |
| ||_____|\____| | |
| |              | |
| '--------------' |
 '----------------'
''',
    "o": '''
 .----------------.
| .--------------. |
| |     ____     | |
| |   .'    `.   | |
| |  /  .--.  \  | |
| |  | |    | |  | |
| |  \  `--'  /  | |
| |   `.____.'   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "p": '''
 .----------------.
| .--------------. |
| |   ______     | |
| |  |_   __ \   | |
| |    | |__) |  | |
| |    |  ___/   | |
| |   _| |_      | |
| |  |_____|     | |
| |              | |
| '--------------' |
 '----------------'
''',
    "q": '''
 .----------------.
| .--------------. |
| |    ___       | |
| |  .'   '.     | |
| | /  .-.  \    | |
| | | |   | |    | |
| | \  `-'  \_   | |
| |  `.___.\__|  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "r": '''
 .----------------.
| .--------------. |
| |  _______     | |
| | |_   __ \    | |
| |   | |__) |   | |
| |   |  __ /    | |
| |  _| |  \ \_  | |
| | |____| |___| | |
| |              | |
| '--------------' |
 '----------------'
''',
    "s": '''
 .----------------.
| .--------------. |
| |    _______   | |
| |   /  ___  |  | |
| |  |  (__ \_|  | |
| |   '.___`-.   | |
| |  |`\____) |  | |
| |  |_______.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "t": '''
 .----------------.
| .--------------. |
| |  _________   | |
| | |  _   _  |  | |
| | |_/ | | \_|  | |
| |     | |      | |
| |    _| |_     | |
| |   |_____|    | |
| |              | |
| '--------------' |
 '----------------'
''',
    "u": '''
 .----------------.
| .--------------. |
| | _____  _____ | |
| ||_   _||_   _|| |
| |  | |    | |  | |
| |  | '    ' |  | |
| |   \ `--' /   | |
| |    `.__.'    | |
| |              | |
| '--------------' |
 '----------------'
''',
    "v": '''
 .----------------.
| .--------------. |
| | ____   ____  | |
| ||_  _| |_  _| | |
| |  \ \   / /   | |
| |   \ \ / /    | |
| |    \ ' /     | |
| |     \_/      | |
| |              | |
| '--------------' |
 '----------------'
''',
    "w": '''
 .----------------.
| .--------------. |
| | _____  _____ | |
| ||_   _||_   _|| |
| |  | | /\ | |  | |
| |  | |/  \| |  | |
| |  |   /\   |  | |
| |  |__/  \__|  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "x": '''
 .----------------.
| .--------------. |
| |  ____  ____  | |
| | |_  _||_  _| | |
| |   \ \  / /   | |
| |    > `' <    | |
| |  _/ /'`\ \_  | |
| | |____||____| | |
| |              | |
| '--------------' |
 '----------------'
''',
    "y": '''
 .----------------.
| .--------------. |
| |  ____  ____  | |
| | |_  _||_  _| | |
| |   \ \  / /   | |
| |    \ \/ /    | |
| |    _|  |_    | |
| |   |______|   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "z": '''
 .----------------.
| .--------------. |
| |   ________   | |
| |  |  __   _|  | |
| |  |_/  / /    | |
| |     .'.' _   | |
| |   _/ /__/ |  | |
| |  |________|  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "1": '''
 .----------------.
| .--------------. |
| |     __       | |
| |    /  |      | |
| |    `| |      | |
| |     | |      | |
| |    _| |_     | |
| |   |_____|    | |
| |              | |
| '--------------' |
 '----------------'
''',
    "2": '''
 .----------------.
| .--------------. |
| |    _____     | |
| |   / ___ `.   | |
| |  |_/___) |   | |
| |   .'____.'   | |
| |  / /____     | |
| |  |_______|   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "3": '''
 .----------------.
| .--------------. |
| |    ______    | |
| |   / ____ `.  | |
| |   `'  __) |  | |
| |   _  |__ '.  | |
| |  | \____) |  | |
| |   \______.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "4": '''
 .----------------.
| .--------------. |
| |   _    _     | |
| |  | |  | |    | |
| |  | |__| |_   | |
| |  |____   _|  | |
| |      _| |_   | |
| |     |_____|  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "5": '''
 .----------------.
| .--------------. |
| |   _______    | |
| |  |  _____|   | |
| |  | |____     | |
| |  '_.____''.  | |
| |  | \____) |  | |
| |   \______.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "6": '''
 .----------------.
| .--------------. |
| |    ______    | |
| |  .' ____ \   | |
| |  | |____\_|  | |
| |  | '____`'.  | |
| |  | (____) |  | |
| |  '.______.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "7": '''
 .----------------.
| .--------------. |
| |   _______    | |
| |  |  ___  |   | |
| |  |_/  / /    | |
| |      / /     | |
| |     / /      | |
| |    /_/       | |
| |              | |
| '--------------' |
 '----------------'
''',
    "8": '''
 .----------------.
| .--------------. |
| |     ____     | |
| |   .' __ '.   | |
| |   | (__) |   | |
| |   .`____'.   | |
| |  | (____) |  | |
| |  `.______.'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "9": '''
 .----------------.
| .--------------. |
| |    ______    | |
| |  .' ____ '.  | |
| |  | (____) |  | |
| |  '_.____. |  | |
| |  | \____| |  | |
| |   \______,'  | |
| |              | |
| '--------------' |
 '----------------'
''',
    "0": '''
 .----------------.
| .--------------. |
| |     ____     | |
| |   .'    '.   | |
| |  |  .--.  |  | |
| |  | |    | |  | |
| |  |  `--'  |  | |
| |   '.____.'   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "`": '''
 .----------------.
| .--------------. |
| |              | |
| |      __      | |
| |     |  |     | |
| |      \_|     | |
| |              | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    "~": '''
 .----------------.
| .--------------. |
| |              | |
| |    ___.-.    | |
| |   |  ___|    | |
| |   '-'        | |
| |              | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    "!": '''
 .----------------.
| .--------------. |
| |              | |
| |      _       | |
| |     | |      | |
| |     | |      | |
| |     | |      | |
| |     |_|      | |
| |     (_)      | |
| '--------------' |
 '----------------'
''',
    "@": '''
 .----------------.
| .--------------. |
| |     ____     | |
| |   .' __ \    | |
| |  / .'  \ |   | |
| |  | | (_/ |   | |
| |  \ `.__.'\   | |
| |   `.___ .'   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "%": '''
 .----------------.
| .--------------. |
| |        __    | |
| |    _  / /    | |
| |   (_)/ /     | |
| |     / / _    | |
| |    / / (_)   | |
| |   /_/        | |
| |              | |
| '--------------' |
 '----------------'
''',
    "^": '''
 .----------------.
| .--------------. |
| |     ___      | |
| |    / _ \     | |
| |   |_/ \_|    | |
| |              | |
| |              | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    "&": '''
 .----------------.
| .--------------. |
| |    ___       | |
| |  .' _ '.     | |
| |  | (_) '___  | |
| |  .`___'/ _/  | |
| | | (___)  \_  | |
| | `._____.\__| | |
| |              | |
| '--------------' |
 '----------------'
''',
    "*": '''
 .----------------.
| .--------------. |
| |      _       | |
| |   /\| |/\    | |
| |   \     /    | |
| |  |_     _|   | |
| |   /     \    | |
| |   \/|_|\/    | |
| |              | |
| '--------------' |
 '----------------'
''',
    "(": '''
 .----------------.
| .--------------. |
| |      __      | |
| |    .' _|     | |
| |    | |       | |
| |    | |       | |
| |    | |_      | |
| |    `.__|     | |
| |              | |
| '--------------' |
 '----------------'
''',
    ")": '''
 .----------------.
| .--------------. |
| |     __       | |
| |    |_ `.     | |
| |      | |     | |
| |      | |     | |
| |     _| |     | |
| |    |__,'     | |
| |              | |
| '--------------' |
 '----------------'
''',
    "-": '''
 .----------------.
| .--------------. |
| |              | |
| |              | |
| |    ______    | |
| |   |______|   | |
| |              | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    "+": '''
 .----------------.
| .--------------. |
| |      _       | |
| |     | |      | |
| |  ___| |___   | |
| | |___   ___|  | |
| |     | |      | |
| |     |_|      | |
| |              | |
| '--------------' |
 '----------------'
''',
    "_": '''
 .----------------.
| .--------------. |
| |              | |
| |              | |
| |              | |
| |              | |
| |              | |
| |   _______    | |
| |  |_______|   | |
| '--------------' |
 '----------------'
''',
    "=": '''
 .----------------.
| .--------------. |
| |              | |
| |    ______    | |
| |   |______|   | |
| |    ______    | |
| |   |______|   | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    "{": '''
 .----------------.
| .--------------. |
| |       __     | |
| |     .' _/    | |
| |     | |      | |
| |    < <       | |
| |     | |_     | |
| |     `.__\    | |
| |              | |
| '--------------' |
 '----------------'
''',
    "}": '''
 .----------------.
| .--------------. |
| |     __       | |
| |    \_ `.     | |
| |      | |     | |
| |       > >    | |
| |     _| |     | |
| |    /__.'     | |
| |              | |
| '--------------' |
 '----------------'
''',
    "[": '''
 .----------------.
| .--------------. |
| |      ___     | |
| |     |  _|    | |
| |     | |      | |
| |     | |      | |
| |     | |_     | |
| |     |___|    | |
| |              | |
| '--------------' |
 '----------------'
''',
    "]": '''
 .----------------.
| .--------------. |
| |     ___      | |
| |    |_  |     | |
| |      | |     | |
| |      | |     | |
| |     _| |     | |
| |    |___|     | |
| |              | |
| '--------------' |
 '----------------'
''',
    "\\": '''
 .----------------.
| .--------------. |
| |    __        | |
| |    \ \       | |
| |     \ \      | |
| |      \ \     | |
| |       \ \    | |
| |        \_\   | |
| |              | |
| '--------------' |
 '----------------'
''',
    "|": '''
 .----------------.
| .--------------. |
| |      _       | |
| |     | |      | |
| |     | |      | |
| |     | |      | |
| |     | |      | |
| |     |_|      | |
| |              | |
| '--------------' |
 '----------------'
''',
    ":": '''
 .----------------.
| .--------------. |
| |              | |
| |      _       | |
| |     (_)      | |
| |      _       | |
| |     (_)      | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    ";": '''
 .----------------.
| .--------------. |
| |              | |
| |       _      | |
| |      (_)     | |
| |       _      | |
| |      | )     | |
| |      )/      | |
| |              | |
| '--------------' |
 '----------------'
''',
    '"': '''
 .----------------.
| .--------------. |
| |     _  _     | |
| |    | || |    | |
| |    \_|\_|    | |
| |              | |
| |              | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    "'": '''
 .----------------.
| .--------------. |
| |      _       | |
| |     | |      | |
| |     \_|      | |
| |              | |
| |              | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
''',
    ",": '''
 .----------------.
| .--------------. |
| |              | |
| |              | |
| |              | |
| |              | |
| |      _       | |
| |     )_/      | |
| |              | |
| '--------------' |
 '----------------'
''',
    ".": '''
 .----------------.
| .--------------. |
| |              | |
| |              | |
| |              | |
| |              | |
| |      _       | |
| |     (_)      | |
| |              | |
| '--------------' |
 '----------------'
''',
    "?": '''
 .----------------.
| .--------------. |
| |    ______    | |
| |   / _ __ `.  | |
| |  |_/____) |  | |
| |    /  ___.'  | |
| |    |_|       | |
| |    (_)       | |
| |              | |
| '--------------' |
 '----------------'
''',
    "/": '''
 .----------------.
| .--------------. |
| |        __    | |
| |       / /    | |
| |      / /     | |
| |     / /      | |
| |    / /       | |
| |   /_/        | |
| |              | |
| '--------------' |
 '----------------'
''',
    ">": '''
 .----------------.
| .--------------. |
| |      _       | |
| |     \ \      | |
| |      \ \     | |
| |       > >    | |
| |      / /     | |
| |     /_/      | |
| |              | |
| '--------------' |
 '----------------'
''',
    "<": '''
 .----------------.
| .--------------. |
| |       _      | |
| |      / /     | |
| |     / /      | |
| |    < <       | |
| |     \ \      | |
| |      \_\     | |
| |              | |
| '--------------' |
 '----------------'
''',
    "#": '''
 .----------------.
| .--------------. |
| |    _  _      | |
| |  _| || |_    | |
| | |_| || |_|   | |
| | |_| || |_|   | |
| |   |_||_|     | |
| |              | |
| |              | |
| '--------------' |
 '----------------'
'''
}

standard_dic = {
    '$': u'  _  \n | | \n/ __)\n\\__ \\\n(   /\n |_| \n',
    '(': u'  __\n / /\n| | \n| | \n| | \n \\_\\\n',
    ',': u'   \n   \n   \n _ \n( )\n|/ \n',
    '0': u'  ___  \n / _ \\ \n| | | |\n| |_| |\n \\___/ \n       \n',
    '4': u' _  _   \n| || |  \n| || |_ \n|__   _|\n   |_|  \n        \n',
    '8': u'  ___  \n ( _ ) \n / _ \\ \n| (_) |\n \\___/ \n       \n',
    '<': u'  __\n / /\n/ / \n\\ \\ \n \\_\\\n    \n',
    '@': u'   ____  \n  / __ \\ \n / / _` |\n| | (_| |\n \\ \\__,_|\n  \\____/ \n',
    'D': u' ____  \n|  _ \\ \n| | | |\n| |_| |\n|____/ \n       \n',
    'H': u' _   _ \n| | | |\n| |_| |\n|  _  |\n|_| |_|\n       \n',
    'L': u' _     \n| |    \n| |    \n| |___ \n|_____|\n       \n',
    'P': u' ____  \n|  _ \\ \n| |_) |\n|  __/ \n|_|    \n       \n',
    'T': u' _____ \n|_   _|\n  | |  \n  | |  \n  |_|  \n       \n',
    'X': u'__  __\n\\ \\/ /\n \\  / \n /  \\ \n/_/\\_\\\n      \n',
    '\\': u'__    \n\\ \\   \n \\ \\  \n  \\ \\ \n   \\_\\\n      \n',
    '`': u' _ \n( )\n \\|\n   \n   \n   \n',
    'd': u'     _ \n  __| |\n / _` |\n| (_| |\n \\__,_|\n       \n',
    'h': u" _     \n| |__  \n| '_ \\ \n| | | |\n|_| |_|\n       \n",
    'l': u' _ \n| |\n| |\n| |\n|_|\n   \n',
    'p': u"       \n _ __  \n| '_ \\ \n| |_) |\n| .__/ \n|_|    \n",
    't': u' _   \n| |_ \n| __|\n| |_ \n \\__|\n     \n',
    'x': u'      \n__  __\n\\ \\/ /\n >  < \n/_/\\_\\\n      \n',
    '|': u' _ \n| |\n| |\n| |\n| |\n|_|\n',
    '#': u'   _  _   \n _| || |_ \n|_  ..  _|\n|_      _|\n  |_||_|  \n          \n',
    "'": u' _ \n( )\n|/ \n   \n   \n   \n',
    '+': u'       \n   _   \n _| |_ \n|_   _|\n  |_|  \n       \n',
    '/': u'    __\n   / /\n  / / \n / /  \n/_/   \n      \n',
    '3': u' _____ \n|___ / \n  |_ \\ \n ___) |\n|____/ \n       \n',
    '7': u' _____ \n|___  |\n   / / \n  / /  \n /_/   \n       \n',
    ';': u'   \n _ \n(_)\n _ \n( )\n|/ \n',
    '?': u' ___ \n|__ \\\n  / /\n |_| \n (_) \n     \n',
    'C': u'  ____ \n / ___|\n| |    \n| |___ \n \\____|\n       \n',
    'G': u'  ____ \n / ___|\n| |  _ \n| |_| |\n \\____|\n       \n',
    'K': u" _  __\n| |/ /\n| ' / \n| . \\ \n|_|\\_\\\n      \n",
    'O': u'  ___  \n / _ \\ \n| | | |\n| |_| |\n \\___/ \n       \n',
    'S': u' ____  \n/ ___| \n\\___ \\ \n ___) |\n|____/ \n       \n',
    'W': u'__        __\n\\ \\      / /\n \\ \\ /\\ / / \n  \\ V  V /  \n   \\_/\\_/   \n            \n',
    '[': u' __ \n| _|\n| | \n| | \n| | \n|__|\n',
    '_': u'       \n       \n       \n       \n _____ \n|_____|\n',
    'c': u'      \n  ___ \n / __|\n| (__ \n \\___|\n      \n',
    'g': u'       \n  __ _ \n / _` |\n| (_| |\n \\__, |\n |___/ \n',
    'k': u' _    \n| | __\n| |/ /\n|   < \n|_|\\_\\\n      \n',
    'o': u'       \n  ___  \n / _ \\ \n| (_) |\n \\___/ \n       \n',
    's': u'     \n ___ \n/ __|\n\\__ \\\n|___/\n     \n',
    'w': u'          \n__      __\n\\ \\ /\\ / /\n \\ V  V / \n  \\_/\\_/  \n          \n',
    '{': u'   __\n  / /\n | | \n< <  \n | | \n  \\_\\\n',
    '"': u' _ _ \n( | )\n V V \n     \n     \n     \n',
    '&': u'  ___   \n ( _ )  \n / _ \\/\\\n| (_>  <\n \\___/\\/\n        \n',
    '*': u'      \n__/\\__\n\\    /\n/_  _\\\n  \\/  \n      \n',
    '.': u'   \n   \n   \n _ \n(_)\n   \n',
    '2': u' ____  \n|___ \\ \n  __) |\n / __/ \n|_____|\n       \n',
    '6': u"  __   \n / /_  \n| '_ \\ \n| (_) |\n \\___/ \n       \n",
    ':': u'   \n _ \n(_)\n _ \n(_)\n   \n',
    '>': u'__  \n\\ \\ \n \\ \\\n / /\n/_/ \n    \n',
    'B': u' ____  \n| __ ) \n|  _ \\ \n| |_) |\n|____/ \n       \n',
    'F': u' _____ \n|  ___|\n| |_   \n|  _|  \n|_|    \n       \n',
    'J': u'     _ \n    | |\n _  | |\n| |_| |\n \\___/ \n       \n',
    'N': u' _   _ \n| \\ | |\n|  \\| |\n| |\\  |\n|_| \\_|\n       \n',
    'R': u' ____  \n|  _ \\ \n| |_) |\n|  _ < \n|_| \\_\\\n       \n',
    'V': u'__     __\n\\ \\   / /\n \\ \\ / / \n  \\ V /  \n   \\_/   \n         \n',
    'Z': u' _____\n|__  /\n  / / \n / /_ \n/____|\n      \n',
    '^': u' /\\ \n|/\\|\n    \n    \n    \n    \n',
    'b': u" _     \n| |__  \n| '_ \\ \n| |_) |\n|_.__/ \n       \n",
    'f': u'  __ \n / _|\n| |_ \n|  _|\n|_|  \n     \n',
    'j': u'   _ \n  (_)\n  | |\n  | |\n _/ |\n|__/ \n',
    'n': u"       \n _ __  \n| '_ \\ \n| | | |\n|_| |_|\n       \n",
    'r': u"      \n _ __ \n| '__|\n| |   \n|_|   \n      \n",
    'v': u'       \n__   __\n\\ \\ / /\n \\ V / \n  \\_/  \n       \n',
    'z': u'     \n ____\n|_  /\n / / \n/___|\n     \n',
    '~': u' /\\/|\n|/\\/ \n     \n     \n     \n     \n',
    '!': u' _ \n| |\n| |\n|_|\n(_)\n   \n',
    '%': u' _  __\n(_)/ /\n  / / \n / /_ \n/_/(_)\n      \n',
    ')': u'__  \n\\ \\ \n | |\n | |\n | |\n/_/ \n',
    '-': u'       \n       \n _____ \n|_____|\n       \n       \n',
    '1': u' _ \n/ |\n| |\n| |\n|_|\n   \n',
    '5': u' ____  \n| ___| \n|___ \\ \n ___) |\n|____/ \n       \n',
    '9': u'  ___  \n / _ \\ \n| (_) |\n \\__, |\n   /_/ \n       \n',
    '=': u'       \n _____ \n|_____|\n|_____|\n       \n       \n',
    'A': u'    _    \n   / \\   \n  / _ \\  \n / ___ \\ \n/_/   \\_\\\n         \n',
    'E': u' _____ \n| ____|\n|  _|  \n| |___ \n|_____|\n       \n',
    'I': u' ___ \n|_ _|\n | | \n | | \n|___|\n     \n',
    'M': u' __  __ \n|  \\/  |\n| |\\/| |\n| |  | |\n|_|  |_|\n        \n',
    'Q': u'  ___  \n / _ \\ \n| | | |\n| |_| |\n \\__\\_\\\n       \n',
    'U': u' _   _ \n| | | |\n| | | |\n| |_| |\n \\___/ \n       \n',
    'Y': u'__   __\n\\ \\ / /\n \\ V / \n  | |  \n  |_|  \n       \n',
    ']': u' __ \n|_ |\n | |\n | |\n | |\n|__|\n',
    'a': u'       \n  __ _ \n / _` |\n| (_| |\n \\__,_|\n       \n',
    'e': u'      \n  ___ \n / _ \\\n|  __/\n \\___|\n      \n',
    'i': u' _ \n(_)\n| |\n| |\n|_|\n   \n',
    'm': u"           \n _ __ ___  \n| '_ ` _ \\ \n| | | | | |\n|_| |_| |_|\n           \n",
    'q': u'       \n  __ _ \n / _` |\n| (_| |\n \\__, |\n    |_|\n',
    'u': u'       \n _   _ \n| | | |\n| |_| |\n \\__,_|\n       \n',
    'y': u'       \n _   _ \n| | | |\n| |_| |\n \\__, |\n |___/ \n',
    '}': u'__   \n\\ \\  \n | | \n  > >\n | | \n/_/  \n',
    " ": u' \n \n \n \n \n \n'}

avatar_dic = {
    '!': u' _ \n/ \\\n| |\n\\_/\n(_)\n   \n',
    ' ': u'  \n  \n  \n  \n  \n  \n',
    '#': u'       \n_/|_|\\_\n\\  _  /\n/  _  \\\n \\| |/ \n       \n',
    '"': u'_  _\n\\||/\n    \n    \n    \n    \n',
    '%': u'_    \n\\|/\\ \n / / \n/ /_ \n\\/ \\|\n     \n',
    '$': u' /| \n/ _\\\n\\ \\ \n_\\ \\\n\\  /\n |/ \n',
    "'": u' _\n|/\n  \n  \n  \n  \n',
    '&': u' _   \n/.\\  \n\\ _\\_\n/|/ /\n\\__/\\\n     \n',
    ')': u'___ \n\\_ \\\n  \\|\n _/|\n/__/\n    \n',
    '(': u' ___\n/ _/\n|/  \n|\\_ \n\\__\\\n    \n',
    '+': u'   _   \n _| |_ \n|_   _|\n  |_|  \n       \n       \n',
    '*': u'      \n_/||\\_\n\\    /\n/    \\\n \\||/ \n      \n',
    '-': u'      \n      \n_____ \n\\____\\\n      \n      \n',
    ',': u'  \n  \n  \n  \n _\n|/\n',
    '/': u'    \n  /\\\n / /\n/ / \n\\/  \n    \n',
    '.': u'  \n  \n  \n__\n\\/\n  \n',
    '1': u' _ \n/ \\\n| |\n| |\n\\_/\n   \n',
    '0': u' ____ \n/  _ \\\n| / \\|\n| \\_/|\n\\____/\n      \n',
    '3': u'_____ \n\\__  \\\n  /  |\n _\\  |\n/____/\n      \n',
    '2': u' ____ \n/_   \\\n /   /\n/   /_\n\\____/\n      \n',
    '5': u' ____ \n/ ___\\\n|    \\\n\\___ |\n\\____/\n      \n',
    '4': u'    _ \n/\\ / |\n\\_\\| |\n   | |\n   \\_|\n      \n',
    '7': u' ____ \n/ _  \\\n\\/ | |\n   | |\n   \\_/\n      \n',
    '6': u'    _ \n __/ \\\n/__  |\n|\\/  |\n\\____/\n      \n',
    '9': u' ____ \n/__  \\\n|\\/  |\n\\__  |\n   \\_/\n      \n',
    '8': u' ____ \n/ ___\\\n\\ \\ //\n/ /_\\\\\n\\____/\n      \n',
    ';': u'  \n  \n__\n\\/\n _\n|/\n',
    ':': u'  \n__\n\\/\n__\n\\/\n  \n',
    '=': u'      \n_____ \n\\____\\\n_____ \n\\____\\\n      \n',
    '<': u'  ___\n / _/\n/ /  \n\\ \\_ \n \\__\\\n     \n',
    '?': u' ____ \n/ _  \\\n\\/ \\ |\n   / /\n   \\/ \n   \\/ \n',
    '>': u'___  \n\\_ \\ \n  \\ \\\n _/ /\n/__/ \n     \n',
    '@': u' ____ \n/  __\\\n| /_//\n| \\\\/_\n\\____/\n      \n',
    '[': u' ___\n/ _/\n||  \n||_ \n\\__\\\n    \n',
    ']': u'___ \n\\_ \\\n  ||\n _||\n/__/\n    \n',
    '\\': u'    \n/\\  \n\\ \\ \n \\ \\\n  \\/\n    \n',
    '_': u'      \n      \n      \n      \n_____ \n\\____\\\n',
    '^': u'/\\\n  \n  \n  \n  \n  \n',
    'a': u' ____ \n/  _ \\\n| / \\|\n| |-||\n\\_/ \\|\n      \n',
    '`': u'_ \n\\|\n  \n  \n  \n  \n',
    'c': u' ____ \n/   _\\\n|  /  \n|  \\_ \n\\____/\n      \n',
    'b': u' ____ \n/  _ \\\n| | //\n| |_\\\\\n\\____/\n      \n',
    'e': u' _____\n/  __/\n|  \\  \n|  /_ \n\\____\\\n      \n',
    'd': u' ____ \n/  _ \\\n| | \\|\n| |_/|\n\\____/\n      \n',
    'g': u' _____\n/  __/\n| |  _\n| |_//\n\\____\\\n      \n',
    'f': u' _____\n/    /\n|  __\\\n| |   \n\\_/   \n      \n',
    'i': u' _ \n/ \\\n| |\n| |\n\\_/\n   \n',
    'h': u' _    \n/ \\ /|\n| |_||\n| | ||\n\\_/ \\|\n      \n',
    'k': u' _  __\n/ |/ /\n|   / \n|   \\ \n\\_|\\_\\\n      \n',
    'j': u'    _ \n   / |\n   | |\n/\\_| |\n\\____/\n      \n',
    'm': u' _     \n/ \\__/|\n| |\\/||\n| |  ||\n\\_/  \\|\n       \n',
    'l': u' _    \n/ \\   \n| |   \n| |_/\\\n\\____/\n      \n',
    'o': u' ____ \n/  _ \\\n| / \\|\n| \\_/|\n\\____/\n      \n',
    'n': u' _     \n/ \\  /|\n| |\\ ||\n| | \\||\n\\_/  \\|\n       \n',
    'q': u' ____ \n/  _ \\\n| / \\|\n| \\_\\|\n\\____\\\n      \n',
    'p': u' ____ \n/  __\\\n|  \\/|\n|  __/\n\\_/   \n      \n',
    's': u' ____ \n/ ___\\\n|    \\\n\\___ |\n\\____/\n      \n',
    'r': u' ____ \n/  __\\\n|  \\/|\n|    /\n\\_/\\_\\\n      \n',
    'u': u' _    \n/ \\ /\\\n| | ||\n| \\_/|\n\\____/\n      \n',
    't': u' _____ \n/__ __\\\n  / \\  \n  | |  \n  \\_/  \n       \n',
    'w': u' _     \n/ \\  /|\n| |  ||\n| |/\\||\n\\_/  \\|\n       \n',
    'v': u' _    \n/ \\ |\\\n| | //\n| \\// \n\\__/  \n      \n',
    'y': u'___  _\n\\  \\//\n \\  / \n / /  \n/_/   \n      \n',
    'x': u'___  _\n\\  \\//\n \\  / \n /  \\ \n/__/\\\\\n      \n',
    '{': u'____\n\\ _/\n//  \n\\\\_ \n/__\\\n    \n',
    'z': u' ____ \n/_   \\\n /   /\n/   /_\n\\____/\n      \n',
    '}': u'____\n\\_ /\n  \\\\\n _//\n/__\\\n    \n',
    '|': u' _ \n| |\n\\_/\n _ \n/ \\\n|_|\n',
    '~': u'/\\//\n \\/ \n    \n    \n    \n    \n'}

banner_dic = {
    '$': u' #####  \n#  #  # \n#  #    \n #####  \n   #  # \n#  #  # \n #####  \n        \n',
    '(': u'  ## \n #   \n#    \n#    \n#    \n #   \n  ## \n     \n',
    ',': u'    \n    \n    \n    \n### \n### \n #  \n#   \n',
    '0': u'  ###   \n #   #  \n#     # \n#     # \n#     # \n #   #  \n  ###   \n        \n',
    '4': u'#       \n#    #  \n#    #  \n#    #  \n####### \n     #  \n     #  \n        \n',
    '8': u' #####  \n#     # \n#     # \n #####  \n#     # \n#     # \n #####  \n        \n',
    '<': u'   # \n  #  \n #   \n#    \n #   \n  #  \n   # \n     \n',
    '@': u' #####  \n#     # \n# ### # \n# ### # \n# ####  \n#       \n #####  \n        \n',
    'D': u'######  \n#     # \n#     # \n#     # \n#     # \n#     # \n######  \n        \n',
    'H': u'#     # \n#     # \n#     # \n####### \n#     # \n#     # \n#     # \n        \n',
    'L': u'#       \n#       \n#       \n#       \n#       \n#       \n####### \n        \n',
    'P': u'######  \n#     # \n#     # \n######  \n#       \n#       \n#       \n        \n',
    'T': u'####### \n   #    \n   #    \n   #    \n   #    \n   #    \n   #    \n        \n',
    'X': u'#     # \n #   #  \n  # #   \n   #    \n  # #   \n #   #  \n#     # \n        \n',
    '\\': u'#       \n #      \n  #     \n   #    \n    #   \n     #  \n      # \n        \n',
    '`': u'### \n### \n #  \n  # \n    \n    \n    \n    \n',
    'd': u'       \n#####  \n#    # \n#    # \n#    # \n#    # \n#####  \n       \n',
    'h': u'       \n#    # \n#    # \n###### \n#    # \n#    # \n#    # \n       \n',
    'l': u'       \n#      \n#      \n#      \n#      \n#      \n###### \n       \n',
    'p': u'       \n#####  \n#    # \n#    # \n#####  \n#      \n#      \n       \n',
    't': u'      \n##### \n  #   \n  #   \n  #   \n  #   \n  #   \n      \n',
    'x': u'       \n#    # \n #  #  \n  ##   \n  ##   \n #  #  \n#    # \n       \n',
    '|': u'# \n# \n# \n  \n# \n# \n# \n  \n',
    '#': u'  # #   \n  # #   \n####### \n  # #   \n####### \n  # #   \n  # #   \n        \n',
    "'": u'### \n### \n #  \n#   \n    \n    \n    \n    \n',
    '+': u'      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n',
    '/': u'      # \n     #  \n    #   \n   #    \n  #     \n #      \n#       \n        \n',
    '3': u' #####  \n#     # \n      # \n #####  \n      # \n#     # \n #####  \n        \n',
    '7': u'####### \n#    #  \n    #   \n   #    \n  #     \n  #     \n  #     \n        \n',
    ';': u'    \n### \n### \n    \n### \n### \n #  \n#   \n',
    '?': u' #####  \n#     # \n      # \n   ###  \n   #    \n        \n   #    \n        \n',
    'C': u' #####  \n#     # \n#       \n#       \n#       \n#     # \n #####  \n        \n',
    'G': u' #####  \n#     # \n#       \n#  #### \n#     # \n#     # \n #####  \n        \n',
    'K': u'#    # \n#   #  \n#  #   \n###    \n#  #   \n#   #  \n#    # \n       \n',
    'O': u'####### \n#     # \n#     # \n#     # \n#     # \n#     # \n####### \n        \n',
    'S': u' #####  \n#     # \n#       \n #####  \n      # \n#     # \n #####  \n        \n',
    'W': u'#     # \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n ## ##  \n        \n',
    '[': u'##### \n#     \n#     \n#     \n#     \n#     \n##### \n      \n',
    '_': u'        \n        \n        \n        \n        \n        \n        \n####### \n',
    'c': u'       \n ####  \n#    # \n#      \n#      \n#    # \n ####  \n       \n',
    'g': u'       \n ####  \n#    # \n#      \n#  ### \n#    # \n ####  \n       \n',
    'k': u'       \n#    # \n#   #  \n####   \n#  #   \n#   #  \n#    # \n       \n',
    'o': u'       \n ####  \n#    # \n#    # \n#    # \n#    # \n ####  \n       \n',
    's': u'       \n ####  \n#      \n ####  \n     # \n#    # \n ####  \n       \n',
    'w': u'       \n#    # \n#    # \n#    # \n# ## # \n##  ## \n#    # \n       \n',
    '{': u'  ### \n #    \n #    \n##    \n #    \n #    \n  ### \n      \n',
    '"': u'### ### \n### ### \n #   #  \n        \n        \n        \n        \n        \n',
    '&': u'  ##    \n #  #   \n  ##    \n ###    \n#   # # \n#    #  \n ###  # \n        \n',
    '*': u'        \n #   #  \n  # #   \n####### \n  # #   \n #   #  \n        \n        \n',
    '.': u'    \n    \n    \n    \n### \n### \n### \n    \n',
    '2': u' #####  \n#     # \n      # \n #####  \n#       \n#       \n####### \n        \n',
    '6': u' #####  \n#     # \n#       \n######  \n#     # \n#     # \n #####  \n        \n',
    ':': u' #  \n### \n #  \n    \n #  \n### \n #  \n    \n',
    '>': u'#    \n #   \n  #  \n   # \n  #  \n #   \n#    \n     \n',
    'B': u'######  \n#     # \n#     # \n######  \n#     # \n#     # \n######  \n        \n',
    'F': u'####### \n#       \n#       \n#####   \n#       \n#       \n#       \n        \n',
    'J': u'      # \n      # \n      # \n      # \n#     # \n#     # \n #####  \n        \n',
    'N': u'#     # \n##    # \n# #   # \n#  #  # \n#   # # \n#    ## \n#     # \n        \n',
    'R': u'######  \n#     # \n#     # \n######  \n#   #   \n#    #  \n#     # \n        \n',
    'V': u'#     # \n#     # \n#     # \n#     # \n #   #  \n  # #   \n   #    \n        \n',
    'Z': u'####### \n     #  \n    #   \n   #    \n  #     \n #      \n####### \n        \n',
    '^': u'  #   \n # #  \n#   # \n      \n      \n      \n      \n      \n',
    'b': u'       \n#####  \n#    # \n#####  \n#    # \n#    # \n#####  \n       \n',
    'f': u'       \n###### \n#      \n#####  \n#      \n#      \n#      \n       \n',
    'j': u'       \n     # \n     # \n     # \n     # \n#    # \n ####  \n       \n',
    'n': u'       \n#    # \n##   # \n# #  # \n#  # # \n#   ## \n#    # \n       \n',
    'r': u'       \n#####  \n#    # \n#    # \n#####  \n#   #  \n#    # \n       \n',
    'v': u'       \n#    # \n#    # \n#    # \n#    # \n #  #  \n  ##   \n       \n',
    'z': u'       \n###### \n    #  \n   #   \n  #    \n #     \n###### \n       \n',
    '~': u' ##     \n#  #  # \n    ##  \n        \n        \n        \n        \n        \n',
    '!': u'### \n### \n### \n #  \n    \n### \n### \n    \n',
    '%': u'###   # \n# #  #  \n### #   \n   #    \n  # ### \n #  # # \n#   ### \n        \n',
    ')': u'##   \n  #  \n   # \n   # \n   # \n  #  \n##   \n     \n',
    '-': u'      \n      \n      \n##### \n      \n      \n      \n      \n',
    '1': u'  #   \n ##   \n# #   \n  #   \n  #   \n  #   \n##### \n      \n',
    '5': u'####### \n#       \n#       \n######  \n      # \n#     # \n #####  \n        \n',
    '9': u' #####  \n#     # \n#     # \n ###### \n      # \n#     # \n #####  \n        \n',
    '=': u'      \n      \n##### \n      \n##### \n      \n      \n      \n',
    'A': u'   #    \n  # #   \n #   #  \n#     # \n####### \n#     # \n#     # \n        \n',
    'E': u'####### \n#       \n#       \n#####   \n#       \n#       \n####### \n        \n',
    'I': u'### \n #  \n #  \n #  \n #  \n #  \n### \n    \n',
    'M': u'#     # \n##   ## \n# # # # \n#  #  # \n#     # \n#     # \n#     # \n        \n',
    'Q': u' #####  \n#     # \n#     # \n#     # \n#   # # \n#    #  \n #### # \n        \n',
    'U': u'#     # \n#     # \n#     # \n#     # \n#     # \n#     # \n #####  \n        \n',
    'Y': u'#     # \n #   #  \n  # #   \n   #    \n   #    \n   #    \n   #    \n        \n',
    ']': u'##### \n    # \n    # \n    # \n    # \n    # \n##### \n      \n',
    'a': u'       \n  ##   \n #  #  \n#    # \n###### \n#    # \n#    # \n       \n',
    'e': u'       \n###### \n#      \n#####  \n#      \n#      \n###### \n       \n',
    'i': u'  \n# \n# \n# \n# \n# \n# \n  \n',
    'm': u'       \n#    # \n##  ## \n# ## # \n#    # \n#    # \n#    # \n       \n',
    'q': u'       \n ####  \n#    # \n#    # \n#  # # \n#   #  \n ### # \n       \n',
    'u': u'       \n#    # \n#    # \n#    # \n#    # \n#    # \n ####  \n       \n',
    'y': u'      \n#   # \n # #  \n  #   \n  #   \n  #   \n  #   \n      \n',
    '}': u'###   \n   #  \n   #  \n   ## \n   #  \n   #  \n###   \n      \n'}

basic_dic = {
    '!': u'db \n88 \nYP \n   \ndb \nYP \n   \n   \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'        \n db db  \nC88888D \n 88 88  \nC88888D \n YP YP  \n        \n        \n',
    '"': u".o. .o. \n`8' `8' \n        \n        \n        \n        \n        \n        \n",
    '%': u"db   dD \nYP  d8' \n   d8'  \n  d8'   \n d8' db \nd8'  YP \n        \n        \n",
    '$': u"   A    \n.d8888. \n88'8 YP \n`8b8.   \n  `V8b. \ndb 8 8D \n`8888Y' \n   V    \n",
    "'": u"Cb \n`D \n ' \n   \n   \n   \n   \n   \n",
    '&': u".d888b.  \n8P   8D  \n`Vb d8'  \n d88C dD \nC8' d8D  \n`888P Yb \n         \n         \n",
    ')': u'Cb     \n `8b   \n   8b  \n   88D \n   8P  \n .8P   \nCP     \n       \n',
    '(': u"    dD \n  d8'  \n d8    \nC88    \n V8    \n  V8.  \n    VD \n       \n",
    '+': u'       \n  db   \n  88   \nC8888D \n  88   \n  VP   \n       \n       \n',
    '*': u"        \n8. A .8 \n`8.8.8' \n  888   \n.d'8`b. \n8' V `8 \n        \n        \n",
    '-': u'       \n       \n       \nC8888D \n       \n       \n       \n       \n',
    ',': u'   \n   \n   \n   \ndb \nV8 \n P \n   \n',
    '/': u"     dD \n    d8' \n   d8'  \n  d8'   \n d8'    \nC8'     \n        \n        \n",
    '.': u'   \n   \n   \n   \ndb \nVP \n   \n   \n',
    '1': u' db \no88 \n 88 \n 88 \n 88 \n VP \n    \n    \n',
    '0': u" .d88b.  \n.8P  88. \n88  d'88 \n88 d' 88 \n`88  d8' \n `Y88P'  \n         \n         \n",
    '3': u"d8888b. \nVP  `8D \n  oooY' \n  ~~~b. \ndb   8D \nY8888P' \n        \n        \n",
    '2': u".d888b. \nVP  `8D \n   odD' \n .88'   \nj88.    \n888888D \n        \n        \n",
    '5': u"  ooooo \n 8P~~~~ \ndP      \nV8888b. \n    `8D \n88oobY' \n        \n        \n",
    '4': u"  j88D  \n j8~88  \nj8' 88  \nV88888D \n    88  \n    VP  \n        \n        \n",
    '7': u"d88888D \nVP  d8' \n   d8'  \n  d8'   \n d8'    \nd8'     \n        \n        \n",
    '6': u"   dD   \n  d8'   \n d8'    \nd8888b. \n88' `8D \n`8888P  \n        \n        \n",
    '9': u".d888b. \n88' `8D \n`V8o88' \n   d8'  \n  d8'   \n d8'    \n        \n        \n",
    '8': u".d888b. \n88   8D \n`VoooY' \n.d~~~b. \n88   8D \n`Y888P' \n        \n        \n",
    ';': u'   \ndb \nVP \n   \ndb \nV8 \n P \n   \n',
    ':': u'   \ndb \nVP \n   \ndb \nVP \n   \n   \n',
    '=': u'       \nC8888D \n       \nC8888D \n       \n       \n       \n       \n',
    '<': u'       \n   .dP \n .d8   \n,P     \n`b     \n `Vb   \n   `Vb \n       \n',
    '?': u".d888b. \nVP  `8D \n   odD' \n  8P'   \n  oo    \n  VP    \n        \n        \n",
    '>': u"       \nVb     \n `Vb   \n   `V. \n   .d' \n .dP   \ndP     \n       \n",
    '@': u" .o888b. \nd8'   Y8 \n8P db dP \n8b V8o8P \nY8.    d \n `Y888P' \n         \n         \n",
    '[': u'd88D \n88   \n88   \n88   \n88   \nL88D \n     \n     \n',
    ']': u'C88D \n  88 \n  88 \n  88 \n  88 \nC888 \n     \n     \n',
    '\\': u'Cb      \n`8b     \n `8b    \n  `8b   \n   `8b  \n    `8D \n        \n        \n',
    '_': u'        \n        \n        \n        \n        \nC88888D \n        \n        \n',
    '^': u"   db    \n .dPVb.  \ndP'  `Vb \n         \n         \n         \n         \n         \n",
    'a': u" .d8b.  \nd8' `8b \n88ooo88 \n88~~~88 \n88   88 \nYP   YP \n        \n        \n",
    '`': u"dD \nC' \n ` \n   \n   \n   \n   \n   \n",
    'c': u" .o88b. \nd8P  Y8 \n8P      \n8b      \nY8b  d8 \n `Y88P' \n        \n        \n",
    'b': u"d8888b. \n88  `8D \n88oooY' \n88~~~b. \n88   8D \nY8888P' \n        \n        \n",
    'e': u"d88888b \n88'     \n88ooooo \n88~~~~~ \n88.     \nY88888P \n        \n        \n",
    'd': u"d8888b. \n88  `8D \n88   88 \n88   88 \n88  .8D \nY8888D' \n        \n        \n",
    'g': u" d888b  \n88' Y8b \n88      \n88  ooo \n88. ~8~ \n Y888P  \n        \n        \n",
    'f': u"d88888b \n88'     \n88ooo   \n88~~~   \n88      \nYP      \n        \n        \n",
    'i': u"d888888b \n  `88'   \n   88    \n   88    \n  .88.   \nY888888P \n         \n         \n",
    'h': u'db   db \n88   88 \n88ooo88 \n88~~~88 \n88   88 \nYP   YP \n        \n        \n',
    'k': u"db   dD \n88 ,8P' \n88,8P   \n88`8b   \n88 `88. \nYP   YD \n        \n        \n",
    'j': u"   d88b \n   `8P' \n    88  \n    88  \ndb. 88  \nY8888P  \n        \n        \n",
    'm': u".88b  d88. \n88'YbdP`88 \n88  88  88 \n88  88  88 \n88  88  88 \nYP  YP  YP \n           \n           \n",
    'l': u'db      \n88      \n88      \n88      \n88booo. \nY88888P \n        \n        \n',
    'o': u" .d88b.  \n.8P  Y8. \n88    88 \n88    88 \n`8b  d8' \n `Y88P'  \n         \n         \n",
    'n': u'd8b   db \n888o  88 \n88V8o 88 \n88 V8o88 \n88  V888 \nVP   V8P \n         \n         \n',
    'q': u" .d88b.  \n.8P  Y8. \n88    88 \n88    88 \n`8P  d8' \n `Y88'Y8 \n         \n         \n",
    'p': u"d8888b. \n88  `8D \n88oodD' \n88~~~   \n88      \n88      \n        \n        \n",
    's': u".d8888. \n88'  YP \n`8bo.   \n  `Y8b. \ndb   8D \n`8888Y' \n        \n        \n",
    'r': u"d8888b. \n88  `8D \n88oobY' \n88`8b   \n88 `88. \n88   YD \n        \n        \n",
    'u': u"db    db \n88    88 \n88    88 \n88    88 \n88b  d88 \n~Y8888P' \n         \n         \n",
    't': u"d888888b \n`~~88~~' \n   88    \n   88    \n   88    \n   YP    \n         \n         \n",
    'w': u"db   d8b   db \n88   I8I   88 \n88   I8I   88 \nY8   I8I   88 \n`8b d8'8b d8' \n `8b8' `8d8'  \n              \n              \n",
    'v': u"db    db \n88    88 \nY8    8P \n`8b  d8' \n `8bd8'  \n   YP    \n         \n         \n",
    'y': u"db    db \n`8b  d8' \n `8bd8'  \n   88    \n   88    \n   YP    \n         \n         \n",
    'x': u"db    db \n`8b  d8' \n `8bd8'  \n .dPYb.  \n.8P  Y8. \nYP    YP \n         \n         \n",
    '{': u"   .8P \n   8'  \n .dP   \nC88    \n `Yb   \n   8.  \n   `8b \n       \n",
    'z': u"d88888D \nYP  d8' \n   d8'  \n  d8'   \n d8' db \nd88888P \n        \n        \n",
    '}': u"V8.    \n `8    \n  Vb.  \n   88D \n  dP'  \n .8    \nC8'    \n       \n",
    '|': u'8 \n8 \n8 \n  \n8 \n8 \n8 \n  \n',
    '~': u" .oo.  . \nP'  `VP' \n         \n         \n         \n         \n         \n         \n"}

bulbhead_dic = {
    '!': u'/\\\n)(\n\\/\n()\n',
    ' ': u'  \n  \n  \n  \n',
    '#': u' | | \n-|-|-\n-|-|-\n | | \n',
    '"': u'||\n  \n  \n  \n',
    '%': u' _  _  \n(_)/ ) \n  / /_ \n (_/(_)\n',
    '$': u' _|_ \n/ |_)\n\\_| \\\n(_|_/\n',
    "'": u'/\n \n \n \n',
    '&': u'  _  \n ( ) \n /_\\/\n(__/\\\n',
    ')': u' _  \n( \\ \n ) )\n(_/ \n',
    '(': u'  _ \n / )\n( ( \n \\_)\n',
    '+': u'   _   \n _| |_ \n(_   _)\n  |_|  \n',
    '*': u'   \n\\|/\n/|\\\n   \n',
    '-': u'     \n ___ \n(___)\n     \n',
    ',': u'  \n  \n()\n/ \n',
    '/': u'   _ \n  / )\n / / \n(_/  \n',
    '.': u'  \n  \n  \n()\n',
    '1': u' __ \n/  )\n )( \n(__)\n',
    '0': u'  ___  \n / _ \\ \n( (_) )\n \\___/ \n',
    '3': u' ___ \n(__ )\n (_ \\\n(___/\n',
    '2': u' ___  \n(__ \\ \n / _/ \n(____)\n',
    '5': u' ___ \n| __)\n|__ \\\n(___/\n',
    '4': u'  __  \n /. | \n(_  _)\n  (_) \n',
    '7': u' ___ \n(__ )\n / / \n(_/  \n',
    '6': u'  _  \n / ) \n/ _ \\\n\\___/\n',
    '9': u' ___ \n/ _ \\\n\\_  /\n (_/ \n',
    '8': u' ___ \n( _ )\n/ _ \\\n\\___/\n',
    ';': u'()\n  \n()\n/ \n',
    ':': u'  \n()\n  \n()\n',
    '=': u' ___ \n(___)\n ___ \n(___)\n',
    '<': u'  __\n / /\n< < \n \\_\\\n',
    '?': u' ___ \n(__ )\n (_/ \n (_) \n',
    '>': u'__  \n\\ \\ \n > >\n/_/ \n',
    '@': u'  __ \n /  \\\n| ()/\n \\__ \n',
    '[': u' __\n|  \n|  \n|__\n',
    ']': u'__ \n  |\n  |\n__|\n',
    '\\': u' _   \n( \\  \n \\ \\ \n  \\_)\n',
    '_': u'     \n     \n ___ \n(___)\n',
    '^': u' / \\ \n(_^_)\n     \n     \n',
    'a': u'   __   \n  /__\\  \n /(__)\\ \n(__)(__)\n',
    '`': u'\\\n \n \n \n',
    'c': u'  ___ \n / __)\n( (__ \n \\___)\n',
    'b': u' ____ \n(  _ \\\n ) _ <\n(____/\n',
    'e': u' ____ \n( ___)\n )__) \n(____)\n',
    'd': u' ____  \n(  _ \\ \n )(_) )\n(____/ \n',
    'g': u'  ___ \n / __)\n( (_-.\n \\___/\n',
    'f': u' ____ \n( ___)\n )__) \n(__)  \n',
    'i': u' ____ \n(_  _)\n _)(_ \n(____)\n',
    'h': u' _   _ \n( )_( )\n ) _ ( \n(_) (_)\n',
    'k': u' _  _ \n( )/ )\n )  ( \n(_)\\_)\n',
    'j': u'  ____ \n (_  _)\n.-_)(  \n\\____) \n',
    'm': u' __  __ \n(  \\/  )\n )    ( \n(_/\\/\\_)\n',
    'l': u' __   \n(  )  \n )(__ \n(____)\n',
    'o': u' _____ \n(  _  )\n )(_)( \n(_____)\n',
    'n': u' _  _ \n( \\( )\n )  ( \n(_)\\_)\n',
    'q': u' _____ \n(  _  )\n )(_)( \n(___/\\\\\n',
    'p': u' ____ \n(  _ \\\n )___/\n(__)  \n',
    's': u' ___ \n/ __)\n\\__ \\\n(___/\n',
    'r': u' ____ \n(  _ \\\n )   /\n(_)\\_)\n',
    'u': u' __  __ \n(  )(  )\n )(__)( \n(______)\n',
    't': u' ____ \n(_  _)\n  )(  \n (__) \n',
    'w': u' _    _ \n( \\/\\/ )\n )    ( \n(__/\\__)\n',
    'v': u' _  _ \n( \\/ )\n \\  / \n  \\/  \n',
    'y': u' _  _ \n( \\/ )\n \\  / \n (__) \n',
    'x': u' _  _ \n( \\/ )\n )  ( \n(_/\\_)\n',
    '{': u' ,-\n_| \n | \n `-\n',
    'z': u' ____ \n(_   )\n / /_ \n(____)\n',
    '}': u"-. \n |_\n | \n-' \n",
    '|': u'/\\\n||\n||\n\\/\n',
    '~': u'   \n/\\/\n   \n   \n'}

chunky_dic = {
    ' ': u' \n \n \n \n \n',
    '$': u" __,-,__ \n|  ' '__|\n|__     |\n|_______|\n   |_|   \n",
    '(': u"  ___ \n,'  _|\n|  |  \n|  |_ \n`.___|\n",
    ',': u'    \n    \n __ \n|  |\n |_|\n',
    '0': u' ______ \n|      |\n|  --  |\n|______|\n        \n',
    '4': u' _____  \n|  |  | \n|__    |\n   |__| \n        \n',
    '8': u' ______ \n|  __  |\n|  __  |\n|______|\n        \n',
    '<': u"   __ \n ,' _|\n/  /  \n\\  \\_ \n `.__|\n",
    '@': u' _________ \n|   ___   |\n|  |  _   |\n|  |______|\n|_________|\n',
    'D': u' _____  \n|     \\ \n|  --  |\n|_____/ \n        \n',
    'H': u' _______ \n|   |   |\n|       |\n|___|___|\n         \n',
    'L': u' _____   \n|     |_ \n|       |\n|_______|\n         \n',
    'P': u' ______ \n|   __ \\\n|    __/\n|___|   \n        \n',
    'T': u' _______ \n|_     _|\n  |   |  \n  |___|  \n         \n',
    'X': u' ___ ___ \n|   |   |\n|-     -|\n|___|___|\n         \n',
    '\\': u'___    \n\\  \\   \n `. `. \n   \\__\\\n       \n',
    '`': u' __ \n|  |\n|_| \n    \n    \n',
    'd': u'    __ \n.--|  |\n|  _  |\n|_____|\n       \n',
    'h': u' __    \n|  |--.\n|     |\n|__|__|\n       \n',
    'l': u' __ \n|  |\n|  |\n|__|\n    \n',
    'p': u'       \n.-----.\n|  _  |\n|   __|\n|__|   \n',
    't': u' __   \n|  |_ \n|   _|\n|____|\n      \n',
    'x': u'       \n.--.--.\n|_   _|\n|__.__|\n       \n',
    '|': u' __ \n|  |\n|  |\n|  |\n|__|\n',
    '#': u'   _____   \n _|  |  |_ \n|_       _|\n|_       _|\n  |__|__|  \n',
    "'": u' __ \n|  |\n |_|\n    \n    \n',
    '+': u'   __   \n _|  |_ \n|_    _|\n  |__|  \n        \n',
    '/': u"    ___\n   /  /\n ,' ,' \n/__/   \n       \n",
    '3': u' ______ \n|__    |\n|__    |\n|______|\n        \n',
    '7': u' ______ \n|      |\n|_     |\n  |____|\n        \n',
    ';': u' __ \n|__|\n __ \n|  |\n |_|\n',
    '?': u" _____ \n|__   |\n',  ,-'\n |--|  \n '--'  \n",
    'C': u' ______ \n|      |\n|   ---|\n|______|\n        \n',
    'G': u' _______ \n|     __|\n|    |  |\n|_______|\n         \n',
    'K': u' __  __ \n|  |/  |\n|     < \n|__|\\__|\n        \n',
    'O': u' _______ \n|       |\n|   -   |\n|_______|\n         \n',
    'S': u' _______ \n|     __|\n|__     |\n|_______|\n         \n',
    'W': u' ________ \n|  |  |  |\n|  |  |  |\n|________|\n          \n',
    '[': u' ____ \n|   _|\n|  |  \n|  |_ \n|____|\n',
    '_': u'        \n        \n        \n ______ \n|______|\n',
    'c': u'      \n.----.\n|  __|\n|____|\n      \n',
    'g': u'       \n.-----.\n|  _  |\n|___  |\n|_____|\n',
    'k': u' __    \n|  |--.\n|    < \n|__|__|\n       \n',
    'o': u'       \n.-----.\n|  _  |\n|_____|\n       \n',
    's': u'       \n.-----.\n|__ --|\n|_____|\n       \n',
    'w': u'          \n.--.--.--.\n|  |  |  |\n|________|\n          \n',
    '{': u'  ___ \n |  _|\n/  /  \n\\  \\_ \n |___|\n',
    '"': u' ____ \n| |  |\n |_|_|\n      \n      \n',
    '&': u" __,-,__ \n|  ' '__|\n|     __|\n|_______|\n   |_|   \n",
    '*': u' __ _ __ \n|  | |  |\n >     < \n|__|_|__|\n         \n',
    '.': u'    \n    \n __ \n|__|\n    \n',
    '2': u' ______ \n|__    |\n|    __|\n|______|\n        \n',
    '6': u' ______ \n|    __|\n|  __  |\n|______|\n        \n',
    ':': u' __ \n|__|\n __ \n|__|\n    \n',
    '>': u" __   \n|_ `. \n  \\  \\\n _/  /\n|__,' \n",
    'B': u' ______ \n|   __ \\\n|   __ <\n|______/\n        \n',
    'F': u' _______ \n|    ___|\n|    ___|\n|___|    \n         \n',
    'J': u'   _____ \n _|     |\n|       |\n|_______|\n         \n',
    'N': u' _______ \n|    |  |\n|       |\n|__|____|\n         \n',
    'R': u' ______ \n|   __ \\\n|      <\n|___|__|\n        \n',
    'V': u' ___ ___ \n|   |   |\n|   |   |\n \\_____/ \n         \n',
    'Z': u' _______ \n|__     |\n|     __|\n|_______|\n         \n',
    '^': u' ____ \n|    |\n|_/\\_|\n      \n      \n',
    'b': u' __    \n|  |--.\n|  _  |\n|_____|\n       \n',
    'f': u"  ___ \n.'  _|\n|   _|\n|__|  \n      \n",
    'j': u'  __ \n |__|\n |  |\n |  |\n|___|\n',
    'n': u'       \n.-----.\n|     |\n|__|__|\n       \n',
    'r': u'      \n.----.\n|   _|\n|__|  \n      \n',
    'v': u'       \n.--.--.\n|  |  |\n \\___/ \n       \n',
    'z': u'       \n.-----.\n|-- __|\n|_____|\n       \n',
    '~': u"  ___ \n | ' |\n|_,_| \n      \n      \n",
    '!': u' __ \n|  |\n|__|\n|__|\n    \n',
    '%': u' __ ___ \n|__|   |\n|    __|\n|___|__|\n        \n',
    ')': u" ___  \n|_  `.\n  |  |\n _|  |\n|___,'\n",
    '-': u'        \n ______ \n|______|\n        \n        \n',
    '1': u' ____   \n|_   |  \n _|  |_ \n|______|\n        \n',
    '5': u' ______ \n|    __|\n|__    |\n|______|\n        \n',
    '9': u' ______ \n|  __  |\n|__    |\n|______|\n        \n',
    '=': u'        \n ______ \n|______|\n|______|\n        \n',
    'A': u' _______ \n|   _   |\n|       |\n|___|___|\n         \n',
    'E': u' _______ \n|    ___|\n|    ___|\n|_______|\n         \n',
    'I': u' _______ \n|_     _|\n _|   |_ \n|_______|\n         \n',
    'M': u' _______ \n|   |   |\n|       |\n|__|_|__|\n         \n',
    'Q': u' _______ \n|       |\n|   -  _|\n|_______|\n         \n',
    'U': u' _______ \n|   |   |\n|   |   |\n|_______|\n         \n',
    'Y': u' ___ ___ \n|   |   |\n \\     / \n  |___|  \n         \n',
    ']': u' ____ \n|_   |\n  |  |\n _|  |\n|____|\n',
    'a': u'       \n.---.-.\n|  _  |\n|___._|\n       \n',
    'e': u'       \n.-----.\n|  -__|\n|_____|\n       \n',
    'i': u' __ \n|__|\n|  |\n|__|\n    \n',
    'm': u'          \n.--------.\n|        |\n|__|__|__|\n          \n',
    'q': u'       \n.-----.\n|  _  |\n|__   |\n   |__|\n',
    'u': u'       \n.--.--.\n|  |  |\n|_____|\n       \n',
    'y': u'       \n.--.--.\n|  |  |\n|___  |\n|_____|\n',
    '}': u' ___  \n|_  | \n  \\  \\\n _/  /\n|___| \n'}

coinstak_dic = {
    ' ': u' \n \n \n \n \n \n \n \n',
    '$': u'  O))  \n O) O))\nO))    \n O))   \n   O)) \nO)) O))\n  O))  \n       \n',
    '(': u'  O))\n O)) \nO))  \nO))  \nO))  \n O)) \n  O))\n     \n',
    ',': u'   \n   \n   \n   \n   \n   \nO))\n O)\n',
    '0': u'            \n    O))     \n  O))  O))  \nO))     O)) \nO))      O))\n O))    O)) \n   O)))     \n            \n',
    '4': u'            \n      O))   \n    O O))   \n   O) O))   \n O))  O))   \nO)))) O) O))\n      O))   \n            \n',
    '8': u'          \n    O)    \n O))  O)) \nO))     O)\n  O)) O)  \nO))     O)\n  O))))   \n          \n',
    '<': u'      O))\n    O))  \n  O))    \nO))      \n  O))    \n    O))  \n      O))\n         \n',
    '@': u'             \n    O)))     \n  O)    O))  \n O)  O))  O))\nO)) O))O  O))\n O))   ```   \n    O))      \n             \n',
    'D': u'O)))))    \nO))   O)) \nO))    O))\nO))    O))\nO))    O))\nO))   O)) \nO)))))    \n          \n',
    'H': u'O))     O))\nO))     O))\nO))     O))\nO)))))) O))\nO))     O))\nO))     O))\nO))     O))\n           \n',
    'L': u'O))      \nO))      \nO))      \nO))      \nO))      \nO))      \nO))))))))\n         \n',
    'P': u'O)))))))  \nO))    O))\nO))    O))\nO)))))))  \nO))       \nO))       \nO))       \n          \n',
    'T': u'O))) O))))))\n     O))    \n     O))    \n     O))    \n     O))    \n     O))    \n     O))    \n            \n',
    'X': u'O))      O))\n O))   O))  \n  O)) O))   \n    O))     \n  O)) O))   \n O))   O))  \nO))      O))\n            \n',
    '\\': u'O))      \n O))     \n  O))    \n   O))   \n    O))  \n     O)) \n      O))\n         \n',
    '`': u'O))\nO) \n   \n   \n   \n   \n   \n   \n',
    'd': u'     O))\n     O))\n     O))\n O)) O))\nO)   O))\nO)   O))\n O)) O))\n        \n',
    'h': u'        \nO))     \nO))     \nO) O)   \nO))  O))\nO)   O))\nO))  O))\n        \n',
    'l': u' O))\n O))\n O))\n O))\n O))\n O))\nO)))\n    \n',
    'p': u'        \n        \nO) O))  \nO)  O)) \nO)   O))\nO)) O)) \nO))     \nO))     \n',
    't': u'  O))  \n  O))  \nO)O) O)\n  O))  \n  O))  \n  O))  \n   O)) \n       \n',
    'x': u'         \n         \nO))   O))\n  O) O)) \n   O)    \n O)  O)) \nO))   O))\n         \n',
    '|': u'O)\nO)\nO)\n  \nO)\nO)\nO)\n  \n',
    '#': u'             \n  O))   O))  \nO)))))) O))))\n  O))   O))  \n  O))   O))  \nO)))))) O))))\n  O))   O))  \n             \n',
    "'": u'O))\n O)\n   \n   \n   \n   \n   \n   \n',
    '+': u'           \n     O))   \n     O))   \nO))) O)))))\n     O))   \n     O))   \n           \n           \n',
    '/': u'      O))\n     O)) \n    O))  \n   O))   \n  O))    \n O))     \nO))      \n         \n',
    '3': u'         \nO)) O))  \n   O))   \n O))     \n    O))  \n      O))\nO)))))   \n         \n',
    '7': u'          \nO))))) O))\n      O)) \n     O))  \n    O))   \n    O))   \n    O))   \n          \n',
    ';': u'   \n   \n   \n   \nO))\n   \nO))\n O)\n',
    '?': u'O)))    \n    O)) \n     O))\n    O)) \n O))    \n        \n O))    \n        \n',
    'C': u'    O))   \n O))   O))\nO))       \nO))       \nO))       \n O))   O))\n   O))))  \n          \n',
    'G': u'   O))))   \n O)    O)) \nO))        \nO))        \nO))   O))))\n O))    O) \n  O)))))   \n           \n',
    'K': u'O))   O))  \nO))  O))   \nO)) O))    \nO) O)      \nO))  O))   \nO))   O))  \nO))     O))\n           \n',
    'O': u'    O))))     \n  O))    O))  \nO))        O))\nO))        O))\nO))        O))\n  O))     O)) \n    O))))     \n              \n',
    'S': u'  O)) O)  \nO))    O))\n O))      \n   O))    \n      O)) \nO))    O))\n  O)) O)  \n          \n',
    'W': u'O))        O))\nO))        O))\nO))   O)   O))\nO))  O))   O))\nO)) O) O)) O))\nO) O)    O))))\nO))        O))\n              \n',
    '[': u'O))))\nO))  \nO))  \nO))  \nO))  \nO))  \nO))))\n     \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \nO)))))\n',
    'c': u'       \n       \n   O)))\n O))   \nO))    \n O))   \n   O)))\n       \n',
    'g': u'         \n         \n   O))   \n O))  O))\nO))   O))\n O))  O))\n     O)) \n  O))    \n',
    'k': u'O))     \nO))     \nO))  O))\nO)) O)) \nO)O))   \nO)) O)) \nO))  O))\n        \n',
    'o': u'          \n          \n   O))    \n O))  O)) \nO))    O))\n O))  O)) \n   O))    \n          \n',
    's': u'       \n       \n O)))) \nO))    \n  O))) \n    O))\nO)) O))\n       \n',
    'w': u'            \n            \nO))     O)))\n O))  )  O))\n O)) O)  O))\n O) O) O)O))\nO)))    O)))\n            \n',
    '{': u'    O))\n  O))  \n  O))  \nO))    \n  O))  \n  O))  \n    O))\n       \n',
    '"': u'O) O)\nO) O)\n     \n     \n     \n     \n     \n     \n',
    '&': u'   O)   \n O)) O))\nO))     \n O)))   \nO))     \n O)) O))\n   O)   \n        \n',
    '*': u'      O))     \n O))  O))  O))\n   O) O) O))  \nO)))) O)))))))\n   O) O) O))  \n O))  O))  O))\n      O))     \n              \n',
    '.': u'   \n   \n   \n   \n   \n   \nO))\n   \n',
    '2': u'         \n O) O))  \nO)    O))\n     O)) \n   O))   \n O))     \nO))))))))\n         \n',
    '6': u'           \n    O))    \n   O))     \n  O))      \nO)    O))  \nO))     O))\n  O)) O))  \n           \n',
    ':': u'   \n   \n   \n   \nO))\n   \nO))\n   \n',
    '>': u'O))      \n  O))    \n    O))  \n      O))\n    O))  \n  O))    \nO))      \n         \n',
    'B': u'O)) O))   \nO)    O)) \nO)     O))\nO))) O)   \nO)     O))\nO)      O)\nO)))) O)) \n          \n',
    'F': u'O))))))))\nO))      \nO))      \nO))))))  \nO))      \nO))      \nO))      \n         \n',
    'J': u'     O))\n     O))\n     O))\n     O))\n     O))\nO)   O))\n O))))  \n        \n',
    'N': u'O)))     O))\nO) O))   O))\nO)) O))  O))\nO))  O)) O))\nO))   O) O))\nO))    O) ))\nO))      O))\n            \n',
    'R': u'O)))))))    \nO))    O))  \nO))    O))  \nO) O))      \nO))  O))    \nO))    O))  \nO))      O))\n            \n',
    'V': u'O))         O))\n O))       O)) \n  O))     O))  \n   O))   O))   \n    O)) O))    \n     O))))     \n      O))      \n               \n',
    'Z': u'O))))))) O))\n       O))  \n      O))   \n    O))     \n   O))      \n O))        \nO)))))))))))\n            \n',
    '^': u'    O))    \n  O)) O))  \nO))     O))\n           \n           \n           \n           \n           \n',
    'b': u'O))      \nO))      \nO))      \nO)) O))  \nO))   O))\nO))   O))\nO)) O))  \n         \n',
    'f': u'    O))\n  O)   \nO)O) O)\n  O))  \n  O))  \n  O))  \n  O))  \n       \n',
    'j': u'      \n   O))\n      \n   O))\n   O))\n   O))\n   O))\nO)))  \n',
    'n': u'         \n         \nO)) O))  \n O))  O))\n O))  O))\n O))  O))\nO)))  O))\n         \n',
    'r': u'       \n       \nO) O)))\n O))   \n O))   \n O))   \nO)))   \n       \n',
    'v': u'           \n           \nO))     O))\n O))   O)) \n  O)) O))  \n   O)O))   \n    O))    \n           \n',
    'z': u'         \n         \nO)))) O))\n     O)) \n   O))   \n  O))    \nO))))))))\n         \n',
    '~': u'O))  O)   \n   O)  O))\n          \n          \n          \n          \n          \n          \n',
    '!': u'O))\nO))\nO))\nO) \nO) \n   \nO))\n   \n',
    '%': u'         \nO))  O)) \n    O))  \n   O))   \n  O))    \n O))     \nO))  O)) \n         \n',
    ')': u'O))  \n O)) \n  O))\n  O))\n  O))\n O)) \nO))  \n     \n',
    '-': u'      \n      \n      \nO)))))\n      \n      \n      \n      \n',
    '1': u'     \nO))  \n O)) \n O)) \n O)) \n O)) \nO))))\n     \n',
    '5': u'         \nO)) O))) \nO))      \nO)))     \n    O))  \n      O))\nO))) O)) \n         \n',
    '9': u'           \n   O) O))  \n O))    O))\nO)      O))\n  O)) O))  \n     O))   \n   O))     \n           \n',
    '=': u'       \n       \nO))))))\n       \nO))))))\n       \n       \n       \n',
    'A': u'      O)       \n     O) ))     \n    O)  O))    \n   O))   O))   \n  O)))))) O))  \n O))       O)) \nO))         O))\n               \n',
    'E': u'O))))))))\nO))      \nO))      \nO))))))  \nO))      \nO))      \nO))))))))\n         \n',
    'I': u'O))\nO))\nO))\nO))\nO))\nO))\nO))\n   \n',
    'M': u'O))       O))\nO) O))   O)))\nO)) O)) O O))\nO))  O))  O))\nO))   O)  O))\nO))       O))\nO))       O))\n             \n',
    'Q': u'    O))))    \n  O))    O)) \nO))       O))\nO))       O))\nO))       O))\n  O)) O) O)) \n    O)) ))   \n         O)  \n',
    'U': u'O))     O))\nO))     O))\nO))     O))\nO))     O))\nO))     O))\nO))     O))\n  O)))))   \n           \n',
    'Y': u'O))      O))\n O))    O)) \n  O)) O))   \n    O))     \n    O))     \n    O))     \n    O))     \n            \n',
    ']': u'O))))\n  O))\n  O))\n  O))\n  O))\n  O))\nO))))\n     \n',
    'a': u'          \n          \n   O))    \n O))  O)) \nO))   O)) \nO))   O)) \n  O)) O)))\n          \n',
    'e': u'          \n          \n   O))    \n O)   O)) \nO))))) O))\nO)        \n  O))))   \n          \n',
    'i': u'   \n O)\n   \nO))\nO))\nO))\nO))\n   \n',
    'm': u'             \n             \nO))) O)) O)) \n O))  O)  O))\n O))  O)  O))\n O))  O)  O))\nO)))  O)  O))\n             \n',
    'q': u'        \n        \n  O))   \nO)  O)) \nO)  O)) \n O))O)) \n    O)) \n    O)))\n',
    'u': u'        \n        \nO))  O))\nO))  O))\nO))  O))\nO))  O))\n  O))O))\n        \n',
    'y': u'         \n         \nO))   O))\n O)) O)) \n   O)))  \n    O))  \n   O))   \n O))     \n',
    '}': u'O))    \n  O))  \n  O))  \n    O))\n  O))  \n  O))  \nO))    \n       \n'}

contessa_dic = {
    ' ': u'  \n  \n  \n  \n',
    '$': u' _;_. \n(_|_  \n._|_) \n  `   \n',
    '(': u' / \n(  \n \\ \n   \n',
    ',': u"   \n   \n * \n ' \n",
    '0': u' _, \n|.| \n|_| \n    \n',
    '4': u'. , \n|_| \n  | \n    \n',
    '8': u' _, \n(_) \n(_) \n    \n',
    '<': u' / \n<  \n \\ \n   \n',
    '@': u' __  \n/(]| \n\\__/ \n     \n',
    'D': u'.__ \n|  \\\n|__/\n    \n',
    'H': u'.  .\n|__|\n|  |\n    \n',
    'L': u'.   \n|   \n|___\n    \n',
    'P': u'.__ \n[__)\n|   \n    \n',
    'T': u'.___.\n  |  \n  |  \n     \n',
    'X': u'\\  /\n >< \n/  \\\n    \n',
    '\\': u'\\   \n \\  \n  \\ \n    \n',
    '`': u'* \n` \n  \n  \n',
    'd': u'  .\n _|\n(_]\n   \n',
    'h': u'.  \n|_ \n[ )\n   \n',
    'l': u'.\n|\n|\n \n',
    'p': u'   \n._ \n[_)\n|  \n',
    't': u' , \n-+-\n | \n   \n',
    'x': u"   \n\\./\n/'\\\n   \n",
    '|': u'| \n| \n| \n  \n',
    '#': u'_|_|_ \n_|_|_ \n | |  \n      \n',
    "'": u" *\n '\n  \n  \n",
    '+': u" ,  \n-+- \n '  \n    \n",
    '/': u'  / \n /  \n/   \n    \n',
    '3': u" _, \n'_) \n._) \n    \n",
    '7': u'__, \n /  \n/   \n    \n',
    ';': u"   \n * \n * \n ' \n",
    '?': u" _ \n' )\n ; \n   \n",
    'C': u' __ \n/  `\n\\__.\n    \n',
    'G': u'.__ \n[ __\n[_./\n    \n',
    'K': u'.  .\n|_/ \n|  \\\n    \n',
    'O': u'.__.\n|  |\n|__|\n    \n',
    'S': u' __.\n(__ \n.__)\n    \n',
    'W': u'.  .\n|  |\n|/\\|\n    \n',
    '[': u'[~ \n[  \n[_ \n   \n',
    '_': u'    \n    \n____\n    \n',
    'c': u'   \n _.\n(_.\n   \n',
    'g': u'   \n _ \n(_]\n._|\n',
    'k': u'.  \n;_/\n| \\\n   \n',
    'o': u'   \n _ \n(_)\n   \n',
    's': u'   \n __\n_) \n   \n',
    'w': u'      \n.    ,\n \\/\\/ \n      \n',
    '{': u'/ \n> \n\\ \n  \n',
    '"': u'* * \n` ` \n    \n    \n',
    '&': u' _;_\n(_|_\n(_|_\n  ` \n',
    '*': u".|, \n-*- \n'|` \n    \n",
    '.': u'   \n   \n * \n   \n',
    '2': u" _, \n'_) \n/_. \n    \n",
    '6': u'._, \n(_  \n(_) \n    \n',
    ':': u'   \n * \n * \n   \n',
    '>': u' \\ \n  >\n / \n   \n',
    'B': u'.__ \n[__)\n[__)\n    \n',
    'F': u'.___\n[__ \n|   \n    \n',
    'J': u'   .\n   |\n\\__|\n    \n',
    'N': u'.  .\n|\\ |\n| \\|\n    \n',
    'R': u'.__ \n[__)\n|  \\\n    \n',
    'V': u'.  .\n\\  /\n \\/ \n    \n',
    'Z': u'.___.\n  _/ \n./__.\n     \n',
    '^': u'/\\ \n   \n   \n   \n',
    'b': u'.  \n|_ \n[_)\n   \n',
    'f': u'._\n|,\n| \n  \n',
    'j': u'   \n  *\n  |\n._|\n',
    'n': u'   \n._ \n[ )\n   \n',
    'r': u'   \n._.\n[  \n   \n',
    'v': u'    \n.  ,\n \\/ \n    \n',
    'z': u'   \n__.\n /_\n   \n',
    '~': u'/\\   \n  \\/ \n     \n     \n',
    '!': u' | \n | \n * \n   \n',
    '%': u'* / \n /  \n/ * \n    \n',
    ')': u' \\ \n  )\n / \n   \n',
    '-': u'     \n ___ \n     \n     \n',
    '1': u' ,  \n/|  \n.|. \n    \n',
    '5': u'._, \n|_  \n._) \n    \n',
    '9': u' _, \n(_) \n  | \n    \n',
    '=': u'     \n === \n === \n     \n',
    'A': u'.__.\n[__]\n|  |\n    \n',
    'E': u'.___\n[__ \n[___\n    \n',
    'I': u'._.\n | \n_|_\n   \n',
    'M': u'.  .\n|\\/|\n|  |\n    \n',
    'Q': u'.__.\n|  |\n|__\\\n    \n',
    'U': u'.  .\n|  |\n|__|\n    \n',
    'Y': u'.   ,\n \\./ \n  |  \n     \n',
    ']': u' ~]\n  ]\n _]\n   \n',
    'a': u'   \n _.\n(_]\n   \n',
    'e': u'   \n _ \n(/,\n   \n',
    'i': u' \n*\n|\n \n',
    'm': u'     \n._ _ \n[ | )\n     \n',
    'q': u'   \n _.\n(_]\n  |\n',
    'u': u'   \n. .\n(_|\n   \n',
    'y': u'   \n  .\n\\_|\n._|\n',
    '}': u'\\ \n< \n/ \n  \n'}

contrast_dic = {
    '!': u'...%%...\n...%%...\n...%%...\n........\n...%%...\n........\n',
    ' ': u'........\n........\n........\n........\n........\n........\n',
    '#': u'..%..%..\n.%%%%%%.\n..%..%..\n.%%%%%%.\n..%..%..\n........\n',
    '"': u'.%%..%%.\n.%%..%%.\n..%..%..\n........\n........\n........\n',
    '%': u'.%%..%%.\n.%..%%..\n...%%...\n..%%..%.\n.%%..%%.\n........\n',
    '$': u'..%%%%%.\n.%%.%...\n..%%%%..\n...%.%%.\n.%%%%%..\n........\n',
    "'": u'...%%...\n...%%...\n....%...\n........\n........\n........\n',
    '&': u'..%%%%%..\n.%%...%%.\n..%%.%%..\n.%%.%%.%.\n..%%%%%..\n.........\n',
    ')': u'.%%%....\n....%%..\n......%.\n....%%..\n.%%%....\n........\n',
    '(': u'....%%%.\n..%%....\n.%......\n..%%....\n....%%%.\n........\n',
    '+': u'...%%...\n...%%...\n.%%%%%%.\n...%%...\n...%%...\n........\n',
    '*': u'.%..%..%.\n..%.%.%..\n.%%%%%%%.\n..%.%.%..\n.%..%..%.\n.........\n',
    '-': u'........\n........\n.%%%%%%.\n........\n........\n........\n',
    ',': u'........\n........\n...%%...\n...%%...\n....%...\n........\n',
    '/': u'.....%%.\n....%%..\n...%%...\n..%%....\n.%%.....\n........\n',
    '.': u'........\n........\n........\n...%%...\n...%%...\n........\n',
    '1': u'...%%...\n..%%%...\n...%%...\n...%%...\n.%%%%%%.\n........\n',
    '0': u'..%%%%..\n.%%..%%.\n.%%%%%%.\n.%%..%%.\n..%%%%..\n........\n',
    '3': u'.%%%%%%.\n....%%..\n...%%%..\n.....%%.\n.%%%%%..\n........\n',
    '2': u'..%%%%..\n.....%%.\n..%%%%..\n.%%.....\n.%%%%%%.\n........\n',
    '5': u'.%%%%%%.\n.%%.....\n..%%%%..\n.....%%.\n.%%%%%..\n........\n',
    '4': u'.....%%.\n.%%..%%.\n.%%%%%%.\n.....%%.\n.....%%.\n........\n',
    '7': u'.%%%%%%.\n....%%..\n...%%...\n..%%....\n.%%.....\n........\n',
    '6': u'...%%...\n..%%....\n.%%%%%..\n.%%..%%.\n..%%%%..\n........\n',
    '9': u'..%%%%..\n.%%..%%.\n..%%%%..\n...%%...\n..%%....\n........\n',
    '8': u'..%%%%..\n.%%..%%.\n..%%%%..\n.%%..%%.\n..%%%%..\n........\n',
    ';': u'........\n...%%...\n........\n...%%...\n....%...\n........\n',
    ':': u'........\n...%%...\n........\n...%%...\n........\n........\n',
    '=': u'........\n.%%%%%%.\n........\n.%%%%%%.\n........\n........\n',
    '<': u'.....%%.\n...%%...\n.%%.....\n...%%...\n.....%%.\n........\n',
    '?': u'..%%%%..\n.%%..%%.\n....%%..\n...%%...\n...%%...\n........\n',
    '>': u'.%%.....\n...%%...\n.....%%.\n...%%...\n.%%.....\n........\n',
    '@': u'..%%%%..\n.%.%%.%.\n.%.%%.%.\n.%..%.%.\n..%%%%..\n........\n',
    '[': u'.%%%%%%.\n.%%.....\n.%%.....\n.%%.....\n.%%%%%%.\n........\n',
    ']': u'.%%%%%%.\n.....%%.\n.....%%.\n.....%%.\n.%%%%%%.\n........\n',
    '\\': u'.%%.....\n..%%....\n...%%...\n....%%..\n.....%%.\n........\n',
    '_': u'........\n........\n........\n........\n.%%%%%%.\n........\n',
    '^': u'...%%...\n..%%%%..\n.%%..%%.\n........\n........\n........\n',
    'a': u'..%%%%..\n.%%..%%.\n.%%%%%%.\n.%%..%%.\n.%%..%%.\n........\n',
    '`': u'...%%...\n...%%...\n...%....\n........\n........\n........\n',
    'c': u'..%%%%..\n.%%..%%.\n.%%.....\n.%%..%%.\n..%%%%..\n........\n',
    'b': u'.%%%%%..\n.%%..%%.\n.%%%%%..\n.%%..%%.\n.%%%%%..\n........\n',
    'e': u'.%%%%%%.\n.%%.....\n.%%%%...\n.%%.....\n.%%%%%%.\n........\n',
    'd': u'.%%%%%..\n.%%..%%.\n.%%..%%.\n.%%..%%.\n.%%%%%..\n........\n',
    'g': u'..%%%%..\n.%%.....\n.%%.%%%.\n.%%..%%.\n..%%%%..\n........\n',
    'f': u'.%%%%%%.\n.%%.....\n.%%%%...\n.%%.....\n.%%.....\n........\n',
    'i': u'.%%%%%%.\n...%%...\n...%%...\n...%%...\n.%%%%%%.\n........\n',
    'h': u'.%%..%%.\n.%%..%%.\n.%%%%%%.\n.%%..%%.\n.%%..%%.\n........\n',
    'k': u'.%%..%%.\n.%%.%%..\n.%%%%...\n.%%.%%..\n.%%..%%.\n........\n',
    'j': u'.%%%%%%.\n.....%%.\n.....%%.\n.%%..%%.\n..%%%%..\n........\n',
    'm': u'.%%...%%.\n.%%%.%%%.\n.%%.%.%%.\n.%%...%%.\n.%%...%%.\n.........\n',
    'l': u'.%%.....\n.%%.....\n.%%.....\n.%%.....\n.%%%%%%.\n........\n',
    'o': u'..%%%%..\n.%%..%%.\n.%%..%%.\n.%%..%%.\n..%%%%..\n........\n',
    'n': u'.%%..%%.\n.%%%.%%.\n.%%.%%%.\n.%%..%%.\n.%%..%%.\n........\n',
    'q': u'..%%%%..\n.%%..%%.\n.%%.%%%.\n.%%..%%.\n..%%%%%.\n........\n',
    'p': u'.%%%%%..\n.%%..%%.\n.%%%%%..\n.%%.....\n.%%.....\n........\n',
    's': u'..%%%%..\n.%%.....\n..%%%%..\n.....%%.\n..%%%%..\n........\n',
    'r': u'.%%%%%..\n.%%..%%.\n.%%%%%..\n.%%..%%.\n.%%..%%.\n........\n',
    'u': u'.%%..%%.\n.%%..%%.\n.%%..%%.\n.%%..%%.\n..%%%%..\n........\n',
    't': u'.%%%%%%.\n...%%...\n...%%...\n...%%...\n...%%...\n........\n',
    'w': u'.%%...%%.\n.%%...%%.\n.%%.%.%%.\n.%%%%%%%.\n..%%.%%..\n.........\n',
    'v': u'.%%..%%.\n.%%..%%.\n.%%..%%.\n..%%%%..\n...%%...\n........\n',
    'y': u'.%%..%%.\n..%%%%..\n...%%...\n...%%...\n...%%...\n........\n',
    'x': u'.%%..%%.\n..%%%%..\n...%%...\n..%%%%..\n.%%..%%.\n........\n',
    '{': u'...%%%%.\n...%%...\n.%%%....\n...%%...\n...%%%%.\n........\n',
    'z': u'.%%%%%%.\n....%%..\n...%%...\n..%%....\n.%%%%%%.\n........\n',
    '}': u'.%%%%...\n...%%...\n....%%%.\n...%%...\n.%%%%...\n........\n',
    '|': u'...%%...\n...%%...\n...%%...\n...%%...\n...%%...\n...%%...\n',
    '~': u'..%%%.%.\n.%.%%%..\n........\n........\n........\n........\n'}

cyberlarge_dic = {
    '!': u'   /\n  / \n .  \n    \n',
    ' ': u'     \n     \n     \n     \n',
    '#': u'',
    '"': u" ..\n ''\n   \n   \n",
    '%': u'',
    '$': u'',
    "'": u" .\n '\n  \n  \n",
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'    \n ___\n    \n    \n',
    ',': u"  \n  \n .\n '\n",
    '/': u'    /\n   / \n  /  \n /   \n',
    '.': u'  \n  \n .\n  \n',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u"  \n .\n .\n '\n",
    ':': u'  \n .\n .\n  \n',
    '=': u'',
    '<': u'',
    '?': u' ____ \n  ___|\n  \\   \n   `  \n',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u' \\   \n  \\  \n   \\ \n    \\\n',
    '_': u'      \n      \n _____\n      \n',
    '^': u'',
    'a': u' _______\n |_____|\n |     |\n        \n',
    '`': u' .\n `\n  \n  \n',
    'c': u' _______\n |      \n |_____ \n        \n',
    'b': u' ______ \n |_____]\n |_____]\n        \n',
    'e': u' _______\n |______\n |______\n        \n',
    'd': u' ______ \n |     \\\n |_____/\n        \n',
    'g': u'  ______\n |  ____\n |_____|\n        \n',
    'f': u' _______\n |______\n |      \n        \n',
    'i': u' _____\n   |  \n __|__\n      \n',
    'h': u' _     _\n |_____|\n |     |\n        \n',
    'k': u' _     _\n |____/ \n |    \\_\n        \n',
    'j': u' _____\n   |  \n __|  \n      \n',
    'm': u' _______\n |  |  |\n |  |  |\n        \n',
    'l': u'       \n |     \n |_____\n       \n',
    'o': u'  _____ \n |     |\n |_____|\n        \n',
    'n': u' __   _\n | \\  |\n |  \\_|\n       \n',
    'q': u'  _____ \n |   __|\n |____\\|\n        \n',
    'p': u'  _____ \n |_____]\n |      \n        \n',
    's': u' _______\n |______\n ______|\n        \n',
    'r': u'  ______\n |_____/\n |    \\_\n        \n',
    'u': u' _     _\n |     |\n |_____|\n        \n',
    't': u' _______\n    |   \n    |   \n        \n',
    'w': u' _  _  _\n |  |  |\n |__|__|\n        \n',
    'v': u' _    _\n  \\  / \n   \\/  \n       \n',
    'y': u' __   __\n   \\_/  \n    |   \n        \n',
    'x': u' _     _\n  \\___/ \n _/   \\_\n        \n',
    '{': u'',
    'z': u' ______\n  ____/\n /_____\n       \n',
    '}': u'',
    '|': u'  |\n  |\n  |\n  |\n',
    '~': u''}

cybermedium_dic = {
    '!': u'  /\n / \n.  \n   \n',
    ' ': u'   \n   \n   \n   \n',
    '#': u'',
    '"': u"..\n''\n  \n  \n",
    '%': u'',
    '$': u'',
    "'": u". \n' \n  \n  \n",
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'   \n__ \n   \n   \n',
    ',': u"  \n  \n. \n' \n",
    '/': u'  / \n /  \n/   \n    \n',
    '.': u' \n \n.\n \n',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u' \n.\n,\n \n',
    ':': u' \n.\n.\n \n',
    '=': u'',
    '<': u'',
    '?': u'__.\n _]\n . \n   \n',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'\\   \n \\  \n  \\ \n    \n',
    '_': u'    \n    \n___ \n    \n',
    '^': u'',
    'a': u'____ \n|__| \n|  | \n     \n',
    '`': u'. \n` \n  \n  \n',
    'c': u'____ \n|    \n|___ \n     \n',
    'b': u'___  \n|__] \n|__] \n     \n',
    'e': u'____ \n|___ \n|___ \n     \n',
    'd': u'___  \n|  \\ \n|__/ \n     \n',
    'g': u'____ \n| __ \n|__] \n     \n',
    'f': u'____ \n|___ \n|    \n     \n',
    'i': u'_ \n| \n| \n  \n',
    'h': u'_  _ \n|__| \n|  | \n     \n',
    'k': u'_  _ \n|_/  \n| \\_ \n     \n',
    'j': u' _ \n | \n_| \n   \n',
    'm': u'_  _ \n|\\/| \n|  | \n     \n',
    'l': u'_    \n|    \n|___ \n     \n',
    'o': u'____ \n|  | \n|__| \n     \n',
    'n': u'_  _ \n|\\ | \n| \\| \n     \n',
    'q': u'____ \n|  | \n|_\\| \n     \n',
    'p': u'___  \n|__] \n|    \n     \n',
    's': u'____ \n[__  \n___] \n     \n',
    'r': u'____ \n|__/ \n|  \\ \n     \n',
    'u': u'_  _ \n|  | \n|__| \n     \n',
    't': u'___ \n |  \n |  \n    \n',
    'w': u'_ _ _ \n| | | \n|_|_| \n      \n',
    'v': u'_  _ \n|  | \n \\/  \n     \n',
    'y': u'_   _ \n \\_/  \n  |   \n      \n',
    'x': u'_  _ \n \\/  \n_/\\_ \n     \n',
    '{': u'',
    'z': u'___  \n  /  \n /__ \n     \n',
    '}': u'',
    '|': u'| \n| \n| \n| \n',
    '~': u''}

doom_dic = {
    ' ': u' \n \n \n \n \n \n \n \n',
    '$': u'  _  \n | | \n/ __)\n\\__ \\\n(   /\n |_| \n     \n     \n',
    '(': u'  __\n / /\n| | \n| | \n| | \n| | \n \\_\\\n    \n',
    ',': u'   \n   \n   \n   \n _ \n( )\n|/ \n   \n',
    '0': u" _____ \n|  _  |\n| |/' |\n|  /| |\n\\ |_/ /\n \\___/ \n       \n       \n",
    '4': u'   ___ \n  /   |\n / /| |\n/ /_| |\n\\___  |\n    |_/\n       \n       \n',
    '8': u' _____ \n|  _  |\n \\ V / \n / _ \\ \n| |_| |\n\\_____/\n       \n       \n',
    '<': u'   __\n  / /\n / / \n< <  \n \\ \\ \n  \\_\\\n     \n     \n',
    '@': u'         \n   ____  \n  / __ \\ \n / / _` |\n| | (_| |\n \\ \\__,_|\n  \\____/ \n         \n',
    'D': u'______ \n|  _  \\\n| | | |\n| | | |\n| |/ / \n|___/  \n       \n       \n',
    'H': u' _   _ \n| | | |\n| |_| |\n|  _  |\n| | | |\n\\_| |_/\n       \n       \n',
    'L': u' _     \n| |    \n| |    \n| |    \n| |____\n\\_____/\n       \n       \n',
    'P': u'______ \n| ___ \\\n| |_/ /\n|  __/ \n| |    \n\\_|    \n       \n       \n',
    'T': u' _____ \n|_   _|\n  | |  \n  | |  \n  | |  \n  \\_/  \n       \n       \n',
    'X': u'__   __\n\\ \\ / /\n \\ V / \n /   \\ \n/ /^\\ \\\n\\/   \\/\n       \n       \n',
    '\\': u'__     \n\\ \\    \n \\ \\   \n  \\ \\  \n   \\ \\ \n    \\_\\\n       \n       \n',
    '`': u' _ \n( )\n \\|\n   \n   \n   \n   \n   \n',
    'd': u'     _ \n    | |\n  __| |\n / _` |\n| (_| |\n \\__,_|\n       \n       \n',
    'h': u" _     \n| |    \n| |__  \n| '_ \\ \n| | | |\n|_| |_|\n       \n       \n",
    'l': u' _ \n| |\n| |\n| |\n| |\n|_|\n   \n   \n',
    'p': u"       \n       \n _ __  \n| '_ \\ \n| |_) |\n| .__/ \n| |    \n|_|    \n",
    't': u' _   \n| |  \n| |_ \n| __|\n| |_ \n \\__|\n     \n     \n',
    'x': u'      \n      \n__  __\n\\ \\/ /\n >  < \n/_/\\_\\\n      \n      \n',
    '|': u' _ \n| |\n| |\n| |\n| |\n| |\n| |\n|_|\n',
    '#': u'   _  _   \n _| || |_ \n|_  __  _|\n _| || |_ \n|_  __  _|\n  |_||_|  \n          \n          \n',
    "'": u' _ \n( )\n|/ \n   \n   \n   \n   \n   \n',
    '+': u'       \n   _   \n _| |_ \n|_   _|\n  |_|  \n       \n       \n       \n',
    '/': u'     __\n    / /\n   / / \n  / /  \n / /   \n/_/    \n       \n       \n',
    '3': u' _____ \n|____ |\n    / /\n    \\ \\\n.___/ /\n\\____/ \n       \n       \n',
    '7': u' ______\n|___  /\n   / / \n  / /  \n./ /   \n\\_/    \n       \n       \n',
    ';': u'   \n _ \n(_)\n   \n _ \n( )\n|/ \n   \n',
    '?': u' ___  \n|__ \\ \n   ) |\n  / / \n |_|  \n (_)  \n      \n      \n',
    'C': u' _____ \n/  __ \\\n| /  \\/\n| |    \n| \\__/\\\n \\____/\n       \n       \n',
    'G': u' _____ \n|  __ \\\n| |  \\/\n| | __ \n| |_\\ \\\n \\____/\n       \n       \n',
    'K': u' _   __\n| | / /\n| |/ / \n|    \\ \n| |\\  \\\n\\_| \\_/\n       \n       \n',
    'O': u' _____ \n|  _  |\n| | | |\n| | | |\n\\ \\_/ /\n \\___/ \n       \n       \n',
    'S': u' _____ \n/  ___|\n\\ `--. \n `--. \\\n/\\__/ /\n\\____/ \n       \n       \n',
    'W': u' _    _ \n| |  | |\n| |  | |\n| |/\\| |\n\\  /\\  /\n \\/  \\/ \n        \n        \n',
    '[': u' ___ \n|  _|\n| |  \n| |  \n| |  \n| |_ \n|___|\n     \n',
    '_': u'        \n        \n        \n        \n        \n        \n ______ \n|______|\n',
    'c': u'      \n      \n  ___ \n / __|\n| (__ \n \\___|\n      \n      \n',
    'g': u'       \n       \n  __ _ \n / _` |\n| (_| |\n \\__, |\n  __/ |\n |___/ \n',
    'k': u' _    \n| |   \n| | __\n| |/ /\n|   < \n|_|\\_\\\n      \n      \n',
    'o': u'       \n       \n  ___  \n / _ \\ \n| (_) |\n \\___/ \n       \n       \n',
    's': u'     \n     \n ___ \n/ __|\n\\__ \\\n|___/\n     \n     \n',
    'w': u'          \n          \n__      __\n\\ \\ /\\ / /\n \\ V  V / \n  \\_/\\_/  \n          \n          \n',
    '{': u'   __\n  / /\n | | \n/ /  \n\\ \\  \n | | \n  \\_\\\n     \n',
    '"': u' _ _ \n( | )\n V V \n     \n     \n     \n     \n     \n',
    '&': u'        \n  ___   \n ( _ )  \n / _ \\/\\\n| (_>  <\n \\___/\\/\n        \n        \n',
    '*': u"    _    \n /\\| |/\\ \n \\ ` ' / \n|_     _|\n / , . \\ \n \\/|_|\\/ \n         \n         \n",
    '.': u'   \n   \n   \n   \n _ \n(_)\n   \n   \n',
    '2': u" _____ \n/ __  \\\n`' / /'\n  / /  \n./ /___\n\\_____/\n       \n       \n",
    '6': u'  ____ \n / ___|\n/ /___ \n| ___ \\\n| \\_/ |\n\\_____/\n       \n       \n',
    ':': u'   \n _ \n(_)\n   \n _ \n(_)\n   \n   \n',
    '>': u'__   \n\\ \\  \n \\ \\ \n  > >\n / / \n/_/  \n     \n     \n',
    'B': u'______ \n| ___ \\\n| |_/ /\n| ___ \\\n| |_/ /\n\\____/ \n       \n       \n',
    'F': u'______ \n|  ___|\n| |_   \n|  _|  \n| |    \n\\_|    \n       \n       \n',
    'J': u'   ___ \n  |_  |\n    | |\n    | |\n/\\__/ /\n\\____/ \n       \n       \n',
    'N': u' _   _ \n| \\ | |\n|  \\| |\n| . ` |\n| |\\  |\n\\_| \\_/\n       \n       \n',
    'R': u'______ \n| ___ \\\n| |_/ /\n|    / \n| |\\ \\ \n\\_| \\_|\n       \n       \n',
    'V': u' _   _ \n| | | |\n| | | |\n| | | |\n\\ \\_/ /\n \\___/ \n       \n       \n',
    'Z': u' ______\n|___  /\n   / / \n  / /  \n./ /___\n\\_____/\n       \n       \n',
    '^': u' /\\ \n|/\\|\n    \n    \n    \n    \n    \n    \n',
    'b': u" _     \n| |    \n| |__  \n| '_ \\ \n| |_) |\n|_.__/ \n       \n       \n",
    'f': u'  __ \n / _|\n| |_ \n|  _|\n| |  \n|_|  \n     \n     \n',
    'j': u'   _ \n  (_)\n   _ \n  | |\n  | |\n  | |\n _/ |\n|__/ \n',
    'n': u"       \n       \n _ __  \n| '_ \\ \n| | | |\n|_| |_|\n       \n       \n",
    'r': u"      \n      \n _ __ \n| '__|\n| |   \n|_|   \n      \n      \n",
    'v': u'       \n       \n__   __\n\\ \\ / /\n \\ V / \n  \\_/  \n       \n       \n',
    'z': u'     \n     \n ____\n|_  /\n / / \n/___|\n     \n     \n',
    '~': u' /\\/|\n|/\\/ \n     \n     \n     \n     \n     \n     \n',
    '!': u' _ \n| |\n| |\n| |\n|_|\n(_)\n   \n   \n',
    '%': u' _   __\n(_) / /\n   / / \n  / /  \n / / _ \n/_/ (_)\n       \n       \n',
    ')': u'__  \n\\ \\ \n | |\n | |\n | |\n | |\n/_/ \n    \n',
    '-': u'        \n        \n ______ \n|______|\n        \n        \n        \n        \n',
    '1': u' __  \n/  | \n`| | \n | | \n_| |_\n\\___/\n     \n     \n',
    '5': u' _____ \n|  ___|\n|___ \\ \n    \\ \\\n/\\__/ /\n\\____/ \n       \n       \n',
    '9': u' _____ \n|  _  |\n| |_| |\n\\____ |\n.___/ /\n\\____/ \n       \n       \n',
    '=': u'        \n ______ \n|______|\n ______ \n|______|\n        \n        \n        \n',
    'A': u'  ___  \n / _ \\ \n/ /_\\ \\\n|  _  |\n| | | |\n\\_| |_/\n       \n       \n',
    'E': u' _____ \n|  ___|\n| |__  \n|  __| \n| |___ \n\\____/ \n       \n       \n',
    'I': u' _____ \n|_   _|\n  | |  \n  | |  \n _| |_ \n \\___/ \n       \n       \n',
    'M': u'___  ___\n|  \\/  |\n| .  . |\n| |\\/| |\n| |  | |\n\\_|  |_/\n        \n        \n',
    'Q': u" _____ \n|  _  |\n| | | |\n| | | |\n\\ \\/' /\n \\_/\\_\\\n       \n       \n",
    'U': u' _   _ \n| | | |\n| | | |\n| | | |\n| |_| |\n \\___/ \n       \n       \n',
    'Y': u'__   __\n\\ \\ / /\n \\ V / \n  \\ /  \n  | |  \n  \\_/  \n       \n       \n',
    ']': u' ___ \n|_  |\n  | |\n  | |\n  | |\n _| |\n|___|\n     \n',
    'a': u'       \n       \n  __ _ \n / _` |\n| (_| |\n \\__,_|\n       \n       \n',
    'e': u'      \n      \n  ___ \n / _ \\\n|  __/\n \\___|\n      \n      \n',
    'i': u' _ \n(_)\n _ \n| |\n| |\n|_|\n   \n   \n',
    'm': u"           \n           \n _ __ ___  \n| '_ ` _ \\ \n| | | | | |\n|_| |_| |_|\n           \n           \n",
    'q': u'       \n       \n  __ _ \n / _` |\n| (_| |\n \\__, |\n    | |\n    |_|\n',
    'u': u'       \n       \n _   _ \n| | | |\n| |_| |\n \\__,_|\n       \n       \n',
    'y': u'       \n       \n _   _ \n| | | |\n| |_| |\n \\__, |\n  __/ |\n |___/ \n',
    '}': u'__   \n\\ \\  \n | | \n  \\ \\\n  / /\n | | \n/_/  \n     \n'}

dotmatrix_dic = {
    ' ': u'               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n',
    '$': u'       _           \n    _ (_) _  _     \n  _(_)(_)(_)(_)    \n (_)_ (_) _  _     \n   (_)(_)(_)(_)_   \n    _ (_) _  _(_)  \n   (_)(_)(_)(_)    \n      (_)          \n                   \n                   \n',
    '(': u'       _       \n    _ (_)      \n  _(_)         \n (_)           \n (_)           \n (_)_          \n   (_) _       \n      (_)      \n               \n               \n',
    ',': u'              \n              \n              \n              \n              \n  _  _        \n (_)(_)       \n (_)(_)       \n   (_)        \n  (_)         \n',
    '0': u'     _  _        \n  _ (_)(_) _     \n (_)      (_)    \n(_)        (_)   \n(_)        (_)   \n(_)        (_)   \n (_) _  _ (_)    \n    (_)(_)       \n                 \n                 \n',
    '4': u'          _       \n       _ (_)      \n    _ (_)(_)      \n _ (_)   (_)      \n(_) _  _ (_) _    \n(_)(_)(_)(_)(_)   \n         (_)      \n         (_)      \n                  \n                  \n',
    '8': u'   _  _  _  _     \n _(_)(_)(_)(_)_   \n(_)          (_)  \n(_)_  _  _  _(_)  \n _(_)(_)(_)(_)_   \n(_)          (_)  \n(_)_  _  _  _(_)  \n  (_)(_)(_)(_)    \n                  \n                  \n',
    '<': u'           _     \n        _ (_)    \n     _ (_)       \n  _ (_)          \n (_) _           \n    (_) _        \n       (_) _     \n          (_)    \n                 \n                 \n',
    '@': u'     _  _  _      \n   _(_)(_)(_)_    \n  (_)  _  _ (_)   \n (_)  (_)(_)(_)   \n (_) (_)  _ (_)   \n (_)  (_)(_)(_)   \n  (_)  _  _  _    \n   (_)(_)(_)(_)   \n                  \n                  \n',
    'D': u' _  _  _  _       \n(_)(_)(_)(_)      \n (_)      (_)_    \n (_)        (_)   \n (_)        (_)   \n (_)       _(_)   \n (_)_  _  (_)     \n(_)(_)(_)(_)      \n                  \n                  \n',
    'H': u' _           _    \n(_)         (_)   \n(_)         (_)   \n(_) _  _  _ (_)   \n(_)(_)(_)(_)(_)   \n(_)         (_)   \n(_)         (_)   \n(_)         (_)   \n                  \n                  \n',
    'L': u' _                \n(_)               \n(_)               \n(_)               \n(_)               \n(_)               \n(_) _  _  _  _    \n(_)(_)(_)(_)(_)   \n                  \n                  \n',
    'P': u' _  _  _  _      \n(_)(_)(_)(_)_    \n(_)        (_)   \n(_) _  _  _(_)   \n(_)(_)(_)(_)     \n(_)              \n(_)              \n(_)              \n                 \n                 \n',
    'T': u' _  _  _  _  _    \n(_)(_)(_)(_)(_)   \n      (_)         \n      (_)         \n      (_)         \n      (_)         \n      (_)         \n      (_)         \n                  \n                  \n',
    'X': u' _           _    \n(_)_       _(_)   \n  (_)_   _(_)     \n    (_)_(_)       \n     _(_)_        \n   _(_) (_)_      \n _(_)     (_)_    \n(_)         (_)   \n                  \n                  \n',
    '\\': u' _                \n(_)_              \n  (_)_            \n    (_)_          \n      (_)_        \n        (_)_      \n          (_)_    \n            (_)   \n                  \n                  \n',
    '`': u'   _  _          \n  (_)(_)         \n  (_)(_)         \n   (_)           \n    (_)          \n                 \n                 \n                 \n                 \n                 \n',
    'd': u'            _    \n           (_)   \n   _  _  _ (_)   \n _(_)(_)(_)(_)   \n(_)        (_)   \n(_)        (_)   \n(_)_  _  _ (_)   \n  (_)(_)(_)(_)   \n                 \n                 \n',
    'h': u' _               \n(_)              \n(_) _  _  _      \n(_)(_)(_)(_)_    \n(_)        (_)   \n(_)        (_)   \n(_)        (_)   \n(_)        (_)   \n                 \n                 \n',
    'l': u' _  _          \n(_)(_)         \n   (_)         \n   (_)         \n   (_)         \n   (_)         \n _ (_) _       \n(_)(_)(_)      \n               \n               \n',
    'p': u'                  \n                  \n _  _  _  _       \n(_)(_)(_)(_)_     \n(_)        (_)    \n(_)        (_)    \n(_) _  _  _(_)    \n(_)(_)(_)(_)      \n(_)               \n(_)               \n',
    't': u'    _            \n   (_)           \n _ (_) _  _      \n(_)(_)(_)(_)     \n   (_)           \n   (_)     _     \n   (_)_  _(_)    \n     (_)(_)      \n                 \n                 \n',
    'x': u'                 \n                 \n _         _     \n(_) _   _ (_)    \n   (_)_(_)       \n    _(_)_        \n _ (_) (_) _     \n(_)       (_)    \n                 \n                 \n',
    '|': u'   _          \n  (_)         \n  (_)         \n  (_)         \n   _          \n  (_)         \n  (_)         \n  (_)         \n              \n              \n',
    '#': u'     _     _       \n    (_)   (_)      \n  _ (_) _ (_) _    \n (_)(_)(_)(_)(_)   \n  _ (_) _ (_) _    \n (_)(_)(_)(_)(_)   \n    (_)   (_)      \n    (_)   (_)      \n                   \n                   \n',
    "'": u'   _  _        \n  (_)(_)       \n  (_)(_)       \n    (_)        \n   (_)         \n               \n               \n               \n               \n               \n',
    '+': u'                   \n        _          \n       (_)         \n  _  _ (_) _  _    \n (_)(_)(_)(_)(_)   \n       (_)         \n       (_)         \n                   \n                   \n                   \n',
    '/': u'             _    \n           _(_)   \n         _(_)     \n       _(_)       \n     _(_)         \n   _(_)           \n _(_)             \n(_)               \n                  \n                  \n',
    '3': u'   _  _  _  _     \n _(_)(_)(_)(_)_   \n(_)          (_)  \n         _  _(_)  \n        (_)(_)_   \n _           (_)  \n(_)_  _  _  _(_)  \n  (_)(_)(_)(_)    \n                  \n                  \n',
    '7': u' _  _  _  _  _    \n(_)(_)(_)(_)(_)   \n          _(_)    \n        _(_)      \n      _(_)        \n    _(_)          \n  _(_)            \n (_)              \n                  \n                  \n',
    ';': u'              \n              \n  _  _        \n (_)(_)       \n (_)(_)       \n  _  _        \n (_)(_)       \n (_)(_)       \n   (_)        \n  (_)         \n',
    '?': u'     _  _  _      \n  _ (_)(_)(_)_    \n (_)        (_)   \n          _ (_)   \n       _ (_)      \n      (_)         \n       _          \n      (_)         \n                  \n                  \n',
    'C': u'    _  _  _       \n _ (_)(_)(_) _    \n(_)         (_)   \n(_)               \n(_)               \n(_)          _    \n(_) _  _  _ (_)   \n   (_)(_)(_)      \n                  \n                  \n',
    'G': u'    _  _  _       \n _ (_)(_)(_) _    \n(_)         (_)   \n(_)    _  _  _    \n(_)   (_)(_)(_)   \n(_)         (_)   \n(_) _  _  _ (_)   \n   (_)(_)(_)(_)   \n                  \n                  \n',
    'K': u' _           _    \n(_)       _ (_)   \n(_)    _ (_)      \n(_) _ (_)         \n(_)(_) _          \n(_)   (_) _       \n(_)      (_) _    \n(_)         (_)   \n                  \n                  \n',
    'O': u'   _  _  _  _     \n _(_)(_)(_)(_)_   \n(_)          (_)  \n(_)          (_)  \n(_)          (_)  \n(_)          (_)  \n(_)_  _  _  _(_)  \n  (_)(_)(_)(_)    \n                  \n                  \n',
    'S': u'   _  _  _  _     \n _(_)(_)(_)(_)_   \n(_)          (_)  \n(_)_  _  _  _     \n  (_)(_)(_)(_)_   \n _           (_)  \n(_)_  _  _  _(_)  \n  (_)(_)(_)(_)    \n                  \n                  \n',
    'W': u' _             _   \n(_)           (_)  \n(_)           (_)  \n(_)     _     (_)  \n(_)   _(_)_   (_)  \n(_)  (_) (_)  (_)  \n(_)_(_)   (_)_(_)  \n  (_)       (_)    \n                   \n                   \n',
    '[': u'  _  _  _       \n (_)(_)(_)      \n (_)            \n (_)            \n (_)            \n (_)            \n (_) _  _       \n (_)(_)(_)      \n                \n                \n',
    '_': u'                     \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n _  _  _  _  _  _  _ \n(_)(_)(_)(_)(_)(_)(_)\n',
    'c': u'                 \n                 \n   _  _  _       \n _(_)(_)(_)      \n(_)              \n(_)              \n(_)_  _  _       \n  (_)(_)(_)      \n                 \n                 \n',
    'g': u'                 \n                 \n   _  _  _  _    \n _(_)(_)(_)(_)   \n(_)        (_)   \n(_)        (_)   \n(_)_  _  _ (_)   \n  (_)(_)(_)(_)   \n   _  _  _ (_)   \n  (_)(_)(_)      \n',
    'k': u' _               \n(_)              \n(_)     _        \n(_)   _(_)       \n(_) _(_)         \n(_)(_)_          \n(_)  (_)_        \n(_)    (_)       \n                 \n                 \n',
    'o': u'                  \n                  \n    _  _  _       \n _ (_)(_)(_) _    \n(_)         (_)   \n(_)         (_)   \n(_) _  _  _ (_)   \n   (_)(_)(_)      \n                  \n                  \n',
    's': u'                  \n                  \n   _  _  _  _     \n _(_)(_)(_)(_)    \n(_)_  _  _  _     \n  (_)(_)(_)(_)_   \n   _  _  _  _(_)  \n  (_)(_)(_)(_)    \n                  \n                  \n',
    'w': u'                   \n                   \n _             _   \n(_)           (_)  \n(_)     _     (_)  \n(_)_  _(_)_  _(_)  \n  (_)(_) (_)(_)    \n    (_)   (_)      \n                   \n                   \n',
    '{': u'       _  _      \n     _(_)(_)     \n    (_)          \n  _ (_)          \n (_) _           \n    (_)          \n    (_)_  _      \n      (_)(_)     \n                 \n                 \n',
    '"': u'   _   _        \n  (_) (_)       \n  (_) (_)       \n  (_) (_)       \n                \n                \n                \n                \n                \n                \n',
    '&': u'    _  _          \n  _(_)(_)_        \n (_)_  _(_)       \n   (_)(_)    _    \n  _ (_)_   _(_)   \n (_)  (_)_(_)     \n (_)_  _(_)_      \n   (_)(_) (_)     \n                  \n                  \n',
    '*': u'                   \n    _       _      \n   (_)_   _(_)     \n  _  (_)_(_)  _    \n (_)(_)(_)(_)(_)   \n    _(_) (_)_      \n   (_)     (_)     \n                   \n                   \n                   \n',
    '.': u'              \n              \n              \n              \n              \n  _  _        \n (_)(_)       \n (_)(_)       \n              \n              \n',
    '2': u'    _  _  _       \n _ (_)(_)(_) _    \n(_)         (_)   \n          _ (_)   \n       _ (_)      \n    _ (_)         \n _ (_) _  _  _    \n(_)(_)(_)(_)(_)   \n                  \n                  \n',
    '6': u'     _  _  _     \n   _(_)(_)(_)    \n _(_)            \n(_) _  _  _      \n(_)(_)(_)(_)_    \n(_)        (_)   \n(_)_  _  _ (_)   \n  (_)(_)(_)      \n                 \n                 \n',
    ':': u'              \n              \n  _  _        \n (_)(_)       \n (_)(_)       \n  _  _        \n (_)(_)       \n (_)(_)       \n              \n              \n',
    '>': u'  _              \n (_) _           \n    (_) _        \n       (_) _     \n        _ (_)    \n     _ (_)       \n  _ (_)          \n (_)             \n                 \n                 \n',
    'B': u' _  _  _  _       \n(_)(_)(_)(_) _    \n (_)        (_)   \n (_) _  _  _(_)   \n (_)(_)(_)(_)_    \n (_)        (_)   \n (_)_  _  _ (_)   \n(_)(_)(_)(_)      \n                  \n                  \n',
    'F': u' _  _  _  _  _    \n(_)(_)(_)(_)(_)   \n(_)               \n(_) _  _          \n(_)(_)(_)         \n(_)               \n(_)               \n(_)               \n                  \n                  \n',
    'J': u'      _  _  _    \n     (_)(_)(_)   \n        (_)      \n        (_)      \n        (_)      \n _      (_)      \n(_)  _  (_)      \n (_)(_)(_)       \n                 \n                 \n',
    'N': u' _           _    \n(_) _       (_)   \n(_)(_)_     (_)   \n(_)  (_)_   (_)   \n(_)    (_)_ (_)   \n(_)      (_)(_)   \n(_)         (_)   \n(_)         (_)   \n                  \n                  \n',
    'R': u' _  _  _  _       \n(_)(_)(_)(_) _    \n(_)         (_)   \n(_) _  _  _ (_)   \n(_)(_)(_)(_)      \n(_)   (_) _       \n(_)      (_) _    \n(_)         (_)   \n                  \n                  \n',
    'V': u' _           _    \n(_)         (_)   \n(_)         (_)   \n(_)_       _(_)   \n  (_)     (_)     \n   (_)   (_)      \n    (_)_(_)       \n      (_)         \n                  \n                  \n',
    'Z': u' _  _  _  _  _    \n(_)(_)(_)(_)(_)   \n          _(_)    \n        _(_)      \n      _(_)        \n    _(_)          \n _ (_) _  _  _    \n(_)(_)(_)(_)(_)   \n                  \n                  \n',
    '^': u'        _          \n     _ (_) _       \n  _ (_)   (_) _    \n (_)         (_)   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    'b': u' _               \n(_)              \n(_) _  _  _      \n(_)(_)(_)(_)_    \n(_)        (_)   \n(_)        (_)   \n(_) _  _  _(_)   \n(_)(_)(_)(_)     \n                 \n                 \n',
    'f': u'      _  _      \n    _(_)(_)     \n _ (_) _        \n(_)(_)(_)       \n   (_)          \n   (_)          \n   (_)          \n   (_)          \n                \n                \n',
    'j': u'          _      \n         (_)     \n       _  _      \n      (_)(_)     \n         (_)     \n         (_)     \n         (_)     \n _      _(_)     \n(_)_  _(_)       \n  (_)(_)         \n',
    'n': u'                 \n                 \n _  _  _  _      \n(_)(_)(_)(_)_    \n(_)        (_)   \n(_)        (_)   \n(_)        (_)   \n(_)        (_)   \n                 \n                 \n',
    'r': u'                  \n                  \n _       _  _     \n(_)_  _ (_)(_)    \n  (_)(_)          \n  (_)             \n  (_)             \n  (_)             \n                  \n                  \n',
    'v': u'                    \n                    \n _               _  \n(_)_           _(_) \n  (_)_       _(_)   \n    (_)_   _(_)     \n      (_)_(_)       \n        (_)         \n                    \n                    \n',
    'z': u'                \n                \n _  _  _  _     \n(_)(_)(_)(_)    \n      _ (_)     \n   _ (_)        \n _(_)  _  _     \n(_)(_)(_)(_)    \n                \n                \n',
    '~': u'                   \n    _  _      _    \n  _(_)(_)_  _(_)   \n (_)    (_)(_)     \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '!': u'  _          \n (_)         \n (_)         \n (_)         \n (_)         \n             \n  _          \n (_)         \n             \n             \n',
    '%': u'  _  _        _    \n (_)(_)     _(_)   \n (_)(_)   _(_)     \n        _(_)       \n      _(_)         \n    _(_)   _  _    \n  _(_)    (_)(_)   \n (_)      (_)(_)   \n                   \n                   \n',
    ')': u'  _            \n (_) _         \n    (_)_       \n      (_)      \n      (_)      \n     _(_)      \n  _ (_)        \n (_)           \n               \n               \n',
    '-': u'                   \n                   \n                   \n  _  _  _  _  _    \n (_)(_)(_)(_)(_)   \n                   \n                   \n                   \n                   \n                   \n',
    '1': u'    _          \n _ (_)         \n(_)(_)         \n   (_)         \n   (_)         \n   (_)         \n _ (_) _       \n(_)(_)(_)      \n               \n               \n',
    '5': u' _  _  _  _  _    \n(_)(_)(_)(_)(_)   \n(_) _  _  _       \n(_)(_)(_)(_) _    \n            (_)   \n _          (_)   \n(_) _  _  _ (_)   \n   (_)(_)(_)      \n                  \n                  \n',
    '9': u'    _  _  _       \n _ (_)(_)(_) _    \n(_)         (_)   \n(_) _  _  _ (_)   \n   (_)(_)(_)(_)   \n           _(_)   \n   _  _  _(_)     \n  (_)(_)(_)       \n                  \n                  \n',
    '=': u'                   \n                   \n  _  _  _  _  _    \n (_)(_)(_)(_)(_)   \n  _  _  _  _  _    \n (_)(_)(_)(_)(_)   \n                   \n                   \n                   \n                   \n',
    'A': u'       _          \n     _(_)_        \n   _(_) (_)_      \n _(_)     (_)_    \n(_) _  _  _ (_)   \n(_)(_)(_)(_)(_)   \n(_)         (_)   \n(_)         (_)   \n                  \n                  \n',
    'E': u' _  _  _  _  _    \n(_)(_)(_)(_)(_)   \n(_)               \n(_) _  _          \n(_)(_)(_)         \n(_)               \n(_) _  _  _  _    \n(_)(_)(_)(_)(_)   \n                  \n                  \n',
    'I': u' _  _  _       \n(_)(_)(_)      \n   (_)         \n   (_)         \n   (_)         \n   (_)         \n _ (_) _       \n(_)(_)(_)      \n               \n               \n',
    'M': u' _           _    \n(_) _     _ (_)   \n(_)(_)   (_)(_)   \n(_) (_)_(_) (_)   \n(_)   (_)   (_)   \n(_)         (_)   \n(_)         (_)   \n(_)         (_)   \n                  \n                  \n',
    'Q': u'   _  _  _  _     \n _(_)(_)(_)(_)_   \n(_)          (_)  \n(_)          (_)  \n(_)     _    (_)  \n(_)    (_) _ (_)  \n(_)_  _  _(_) _   \n  (_)(_)(_)  (_)  \n                  \n                  \n',
    'U': u' _            _   \n(_)          (_)  \n(_)          (_)  \n(_)          (_)  \n(_)          (_)  \n(_)          (_)  \n(_)_  _  _  _(_)  \n  (_)(_)(_)(_)    \n                  \n                  \n',
    'Y': u' _           _    \n(_)_       _(_)   \n  (_)_   _(_)     \n    (_)_(_)       \n      (_)         \n      (_)         \n      (_)         \n      (_)         \n                  \n                  \n',
    ']': u'  _  _  _       \n (_)(_)(_)      \n       (_)      \n       (_)      \n       (_)      \n       (_)      \n  _  _ (_)      \n (_)(_)(_)      \n                \n                \n',
    'a': u'                  \n                  \n   _  _  _        \n  (_)(_)(_) _     \n   _  _  _ (_)    \n _(_)(_)(_)(_)    \n(_)_  _  _ (_)_   \n  (_)(_)(_)  (_)  \n                  \n                  \n',
    'e': u'                  \n                  \n  _  _  _  _      \n (_)(_)(_)(_)_    \n(_) _  _  _ (_)   \n(_)(_)(_)(_)(_)   \n(_)_  _  _  _     \n  (_)(_)(_)(_)    \n                  \n                  \n',
    'i': u'    _          \n   (_)         \n _  _          \n(_)(_)         \n   (_)         \n   (_)         \n _ (_) _       \n(_)(_)(_)      \n               \n               \n',
    'm': u'                  \n                  \n  _  _   _  _     \n (_)(_)_(_)(_)    \n(_)   (_)   (_)   \n(_)   (_)   (_)   \n(_)   (_)   (_)   \n(_)   (_)   (_)   \n                  \n                  \n',
    'q': u'                  \n                  \n   _  _  _  _     \n _(_)(_)(_)(_)    \n(_)        (_)    \n(_)        (_)    \n(_)_  _  _ (_)    \n  (_)(_)(_)(_)    \n           (_)    \n           (_)    \n',
    'u': u'                  \n                  \n _         _      \n(_)       (_)     \n(_)       (_)     \n(_)       (_)     \n(_)_  _  _(_)_    \n  (_)(_)(_) (_)   \n                  \n                  \n',
    'y': u'                    \n                    \n _               _  \n(_)_           _(_) \n  (_)_       _(_)   \n    (_)_   _(_)     \n      (_)_(_)       \n       _(_)         \n  _  _(_)           \n (_)(_)             \n',
    '}': u'  _  _           \n (_)(_)_         \n      (_)        \n      (_) _      \n       _ (_)     \n      (_)        \n  _  _(_)        \n (_)(_)          \n                 \n                 \n'}

drpepper_dic = {
    ' ': u' \n \n \n \n \n',
    '$': u'    \n ||_\n<_-<\n/__/\n || \n',
    '(': u'  __\n / /\n| | \n| | \n \\_\\\n',
    ',': u'  \n  \n _\n|/\n  \n',
    '0': u" ___ \n|   |\n| / |\n`___'\n     \n",
    '4': u'  __  \n /. | \n/_  .|\n  |_| \n      \n',
    '8': u' ___ \n< . >\n/ . \\\n\\___/\n     \n',
    '<': u'  __\n / /\n< < \n \\_\\\n    \n',
    '@': u' ___ \n|  "|\n| \\_|\n`___/\n     \n',
    'D': u' ___ \n| . \\\n| | |\n|___/\n     \n',
    'H': u' _ _ \n| | |\n|   |\n|_|_|\n     \n',
    'L': u' _   \n| |  \n| |_ \n|___|\n     \n',
    'P': u' ___ \n| . \\\n|  _/\n|_|  \n     \n',
    'T': u' ___ \n|_ _|\n | | \n |_| \n     \n',
    'X': u'__  _ \n\\ \\/  \n \\ \\  \n_/\\_\\ \n      \n',
    '\\': u'__   \n\\ \\  \n \\ \\ \n  \\_\\\n     \n',
    '`': u'_ \n\\|\n  \n  \n  \n',
    'd': u'   _ \n _| |\n/ . |\n\\___|\n     \n',
    'h': u' _   \n| |_ \n| . |\n|_|_|\n     \n',
    'l': u' _ \n| |\n| |\n|_|\n   \n',
    'p': u'     \n ___ \n| . \\\n|  _/\n|_|  \n',
    't': u'   _   \n _| |_ \n  | |  \n  |_|  \n       \n',
    'x': u'    \n__  \n\\ \\/\n/\\_\\\n    \n',
    '|': u'||\n||\n||\n||\n  \n',
    '#': u'       \n _|_|_ \n _|_|_ \n  | |  \n       \n',
    "'": u' _\n|/\n  \n  \n  \n',
    '+': u'   _   \n _| |_ \n|_   _|\n  |_|  \n       \n',
    '/': u'   __\n  / /\n / / \n/_/  \n     \n',
    '3': u' ____\n<__ /\n <_ \\\n<___/\n     \n',
    '7': u' ___ \n|_  |\n / / \n/_/  \n     \n',
    ';': u' _ \n<_>\n _ \n|/ \n   \n',
    '?': u' ___ \n<_. >\n /_/ \n <_> \n     \n',
    'C': u' ___ \n|  _>\n| <__\n`___/\n     \n',
    'G': u' ___  \n/  _> \n| <_/\\\n`____/\n      \n',
    'K': u' _ __\n| / /\n|  \\ \n|_\\_\\\n     \n',
    'O': u" ___ \n| . |\n| | |\n`___'\n     \n",
    'S': u' ___ \n/ __>\n\\__ \\\n<___/\n     \n',
    'W': u' _ _ _ \n| | | |\n| | | |\n|__/_/ \n       \n',
    '[': u' ___ \n|  _|\n| |  \n| |_ \n|___|\n',
    '_': u'     \n     \n ___ \n|___|\n     \n',
    'c': u"     \n ___ \n/ | '\n\\_|_.\n     \n",
    'g': u"     \n ___ \n/ . |\n\\_. |\n<___'\n",
    'k': u' _   \n| |__\n| / /\n|_\\_\\\n     \n',
    'o': u'     \n ___ \n/ . \\\n\\___/\n     \n',
    's': u'    \n ___\n<_-<\n/__/\n    \n',
    'w': u'       \n _ _ _ \n| | | |\n|__/_/ \n       \n',
    '{': u'  __\n / /\n/ | \n\\ | \n \\_\\\n',
    '"': u' _ _\n|/|/\n    \n    \n    \n',
    '&': u' _   \n< >  \n/.\\/ \n\\_/\\ \n     \n',
    '*': u'    \n_/\\_\n>  <\n \\/ \n    \n',
    '.': u'   \n   \n _ \n<_>\n   \n',
    '2': u' ___ \n<_  >\n / / \n<___>\n     \n',
    '6': u' ___ \n| __>\n| . \\\n`___/\n     \n',
    ':': u' _ \n<_>\n _ \n<_>\n   \n',
    '>': u'__  \n\\ \\ \n > >\n/_/ \n    \n',
    'B': u' ___ \n| . >\n| . \\\n|___/\n     \n',
    'F': u' ___ \n| __>\n| _> \n|_|  \n     \n',
    'J': u'  _ \n | |\n_| |\n\\__/\n    \n',
    'N': u' _ _ \n| \\ |\n|   |\n|_\\_|\n     \n',
    'R': u' ___ \n| . \\\n|   /\n|_\\_\\\n     \n',
    'V': u" _ _ \n| | |\n| ' |\n|__/ \n     \n",
    'Z': u' ____\n|_  /\n / / \n/___|\n     \n',
    '^': u' /\\ \n</\\>\n    \n    \n    \n',
    'b': u' _   \n| |_ \n| . \\\n|___/\n     \n',
    'f': u" ___ \n| | '\n| |- \n|_|  \n     \n",
    'j': u"  _ \n <_>\n | |\n | |\n<__'\n",
    'n': u"     \n._ _ \n| ' |\n|_|_|\n     \n",
    'r': u"     \n _ _ \n| '_>\n|_|  \n     \n",
    'v': u'     \n _ _ \n| | |\n|__/ \n     \n',
    'z': u'    \n.___\n / /\n/___\n    \n',
    '~': u'     \n /\\/|\n|/\\/ \n     \n     \n',
    '!': u' _ \n| |\n|_/\n<_>\n   \n',
    '%': u'   __\n<>/ /\n / / \n/_/<>\n     \n',
    ')': u'__  \n\\ \\ \n | |\n | |\n/_/ \n',
    '-': u'     \n ___ \n|___|\n     \n     \n',
    '1': u' _ \n/ |\n| |\n|_|\n   \n',
    '5': u' ___ \n| __|\n`__ \\\n|___/\n     \n',
    '9': u' ___ \n| . |\n`_  /\n /_/ \n     \n',
    '=': u' ___ \n|___|\n ___ \n|___|\n     \n',
    'A': u' ___ \n| . |\n|   |\n|_|_|\n     \n',
    'E': u' ___ \n| __>\n| _> \n|___>\n     \n',
    'I': u' _ \n| |\n| |\n|_|\n   \n',
    'M': u' __ __ \n|  \\  \\\n|     |\n|_|_|_|\n       \n',
    'Q': u' ___ \n| . |\n| | |\n`___\\\n     \n',
    'U': u" _ _ \n| | |\n| ' |\n`___'\n     \n",
    'Y': u' _ _ \n| | |\n\\   /\n |_| \n     \n',
    ']': u' ___ \n|_  |\n  | |\n _| |\n|___|\n',
    'a': u'     \n ___ \n<_> |\n<___|\n     \n',
    'e': u'     \n ___ \n/ ._>\n\\___.\n     \n',
    'i': u' _ \n<_>\n| |\n|_|\n   \n',
    'm': u"       \n._ _ _ \n| ' ' |\n|_|_|_|\n       \n",
    'q': u'     \n ___ \n/ . |\n\\_  |\n  |_|\n',
    'u': u'     \n _ _ \n| | |\n`___|\n     \n',
    'y': u"     \n _ _ \n| | |\n`_. |\n<___'\n",
    '}': u'__  \n\\ \\ \n | \\\n | /\n/_/ \n'}

epic_dic = {
    '!': u' _ \n( )\n| |\n| |\n| |\n(_)\n _ \n(_)\n   \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'   _   _   \n  ( ) ( )  \n _| |_| |_ \n(_   _   _)\n _| (_) |_ \n(_   _   _)\n  | | | |  \n  (_) (_)  \n           \n',
    '"': u' _  _ \n( )( )\n \\||/ \n      \n      \n      \n      \n      \n      \n',
    '%': u'       \n     /\\\n()  / /\n   / / \n  / /  \n / /   \n/ /  ()\n\\/     \n       \n',
    '$': u'    _    \n __|_|___\n(  _____/\n| (|_|__ \n(_____  )\n/\\_|_|) |\n\\_______)\n   |_|   \n         \n',
    "'": u' _ \n( )\n|/ \n   \n   \n   \n   \n   \n   \n',
    '&': u'   __   \n  /__\\  \n ( \\/ ) \n  \\  /  \n  /  \\/\\\n / /\\  /\n(  \\/  \\\n \\___/\\/\n        \n',
    ')': u' _   \n( \\  \n \\ \\ \n  ) )\n  | |\n  ) )\n / / \n(_/  \n     \n',
    '(': u'   _ \n  / )\n / / \n( (  \n| |  \n( (  \n \\ \\ \n  \\_)\n     \n',
    '+': u'    _    \n   ( )   \n   | |   \n __| |__ \n(__   __)\n   | |   \n   | |   \n   (_)   \n         \n',
    '*': u'          \n /\\    /\\ \n \\ \\  / / \n _) () (_ \n(_      _)\n  ) () (  \n / /  \\ \\ \n \\/    \\/ \n          \n',
    '-': u'       \n       \n       \n _____ \n(_____)\n       \n       \n       \n       \n',
    ',': u'   \n   \n   \n   \n   \n   \n _ \n( )\n|/ \n',
    '/': u'       \n     /\\\n    / /\n   / / \n  / /  \n / /   \n/ /    \n\\/     \n       \n',
    '.': u'   \n   \n   \n   \n   \n   \n _ \n(_)\n   \n',
    '1': u' __   \n/  \\  \n\\/) ) \n  | | \n  | | \n  | | \n__) (_\n\\____/\n      \n',
    '0': u' _______ \n(  __   )\n| (  )  |\n| | /   |\n| (/ /) |\n|   / | |\n|  (__) |\n(_______)\n         \n',
    '3': u' ______  \n/ ___  \\ \n\\/   \\  \\\n   ___) /\n  (___ ( \n      ) \\\n/\\___/  /\n\\______/ \n         \n',
    '2': u' _______ \n/ ___   )\n\\/   )  |\n    /   )\n  _/   / \n /   _/  \n(   (__/\\\n\\_______/\n         \n',
    '5': u' _______ \n(  ____ \\\n| (    \\/\n| (____  \n(_____ \\ \n      ) )\n/\\____) )\n\\______/ \n         \n',
    '4': u'    ___   \n   /   )  \n  / /) |  \n / (_) (_ \n(____   _)\n     ) (  \n     | |  \n     (_)  \n          \n',
    '7': u' ______  \n/ ___  \\ \n\\/   )  )\n    /  / \n   /  /  \n  /  /   \n /  /    \n \\_/     \n         \n',
    '6': u'  ______ \n / ____ \\\n( (    \\/\n| (____  \n|  ___ \\ \n| (   ) )\n( (___) )\n \\_____/ \n         \n',
    '9': u'  _____  \n / ___ \\ \n( (   ) )\n( (___) |\n \\____  |\n      ) |\n/\\____) )\n\\______/ \n         \n',
    '8': u'  _____  \n / ___ \\ \n( (___) )\n \\     / \n / ___ \\ \n( (   ) )\n( (___) )\n \\_____/ \n         \n',
    ';': u'   \n   \n   \n _ \n(_)\n   \n _ \n( )\n|/ \n',
    ':': u'   \n   \n _ \n(_)\n   \n _ \n(_)\n   \n   \n',
    '=': u'     \n     \n ___ \n(___)\n ___ \n(___)\n     \n     \n     \n',
    '<': u'    _ \n   / )\n  / / \n / /  \n( (   \n \\ \\  \n  \\ \\ \n   \\_)\n      \n',
    '?': u'  _____  \n / ___ \\ \n( (   ) )\n \\/  / / \n    ( (  \n    | |  \n    (_)  \n     _   \n    (_)  \n',
    '>': u' _    \n( \\   \n \\ \\  \n  \\ \\ \n   ) )\n  / / \n / /  \n(_/   \n      \n',
    '@': u'   _____   \n  / ___ \\  \n / / _ \\ \\ \n( ( / \\ ) )\n| |(()// / \n( ( \\___/  \n \\ \\____/\\ \n  \\______/ \n           \n',
    '[': u' ____ \n(  __)\n| (   \n| |   \n| |   \n| |   \n| (__ \n(____)\n      \n',
    ']': u' ____ \n(__  )\n   ) |\n   | |\n   | |\n   | |\n __) |\n(____)\n      \n',
    '\\': u'       \n/\\     \n\\ \\    \n \\ \\   \n  \\ \\  \n   \\ \\ \n    \\ \\\n     \\/\n       \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n _____ \n(_____)\n',
    '^': u' /\\ \n(/\\)\n    \n    \n    \n    \n    \n    \n    \n',
    'a': u' _______ \n(  ___  )\n| (   ) |\n| (___) |\n|  ___  |\n| (   ) |\n| )   ( |\n|/     \\|\n         \n',
    '`': u' _ \n( )\n \\|\n   \n   \n   \n   \n   \n   \n',
    'c': u' _______ \n(  ____ \\\n| (    \\/\n| |      \n| |      \n| |      \n| (____/\\\n(_______/\n         \n',
    'b': u' ______  \n(  ___ \\ \n| (   ) )\n| (__/ / \n|  __ (  \n| (  \\ \\ \n| )___) )\n|/ \\___/ \n         \n',
    'e': u' _______ \n(  ____ \\\n| (    \\/\n| (__    \n|  __)   \n| (      \n| (____/\\\n(_______/\n         \n',
    'd': u' ______  \n(  __  \\ \n| (  \\  )\n| |   ) |\n| |   | |\n| |   ) |\n| (__/  )\n(______/ \n         \n',
    'g': u' _______ \n(  ____ \\\n| (    \\/\n| |      \n| | ____ \n| | \\_  )\n| (___) |\n(_______)\n         \n',
    'f': u' _______ \n(  ____ \\\n| (    \\/\n| (__    \n|  __)   \n| (      \n| )      \n|/       \n         \n',
    'i': u'_________\n\\__   __/\n   ) (   \n   | |   \n   | |   \n   | |   \n___) (___\n\\_______/\n         \n',
    'h': u'         \n|\\     /|\n| )   ( |\n| (___) |\n|  ___  |\n| (   ) |\n| )   ( |\n|/     \\|\n         \n',
    'k': u' _       \n| \\    /\\\n|  \\  / /\n|  (_/ / \n|   _ (  \n|  ( \\ \\ \n|  /  \\ \\\n|_/    \\/\n         \n',
    'j': u'_________\n\\__    _/\n   )  (  \n   |  |  \n   |  |  \n   |  |  \n|\\_)  )  \n(____/   \n         \n',
    'm': u' _______ \n(       )\n| () () |\n| || || |\n| |(_)| |\n| |   | |\n| )   ( |\n|/     \\|\n         \n',
    'l': u' _       \n( \\      \n| (      \n| |      \n| |      \n| |      \n| (____/\\\n(_______/\n         \n',
    'o': u' _______ \n(  ___  )\n| (   ) |\n| |   | |\n| |   | |\n| |   | |\n| (___) |\n(_______)\n         \n',
    'n': u' _       \n( (    /|\n|  \\  ( |\n|   \\ | |\n| (\\ \\) |\n| | \\   |\n| )  \\  |\n|/    )_)\n         \n',
    'q': u' _______ \n(  ___  )\n| (   ) |\n| |   | |\n| |   | |\n| | /\\| |\n| (_\\ \\ |\n(____\\/_)\n         \n',
    'p': u' _______ \n(  ____ )\n| (    )|\n| (____)|\n|  _____)\n| (      \n| )      \n|/       \n         \n',
    's': u' _______ \n(  ____ \\\n| (    \\/\n| (_____ \n(_____  )\n      ) |\n/\\____) |\n\\_______)\n         \n',
    'r': u' _______ \n(  ____ )\n| (    )|\n| (____)|\n|     __)\n| (\\ (   \n| ) \\ \\__\n|/   \\__/\n         \n',
    'u': u'         \n|\\     /|\n| )   ( |\n| |   | |\n| |   | |\n| |   | |\n| (___) |\n(_______)\n         \n',
    't': u'_________\n\\__   __/\n   ) (   \n   | |   \n   | |   \n   | |   \n   | |   \n   )_(   \n         \n',
    'w': u'         \n|\\     /|\n| )   ( |\n| | _ | |\n| |( )| |\n| || || |\n| () () |\n(_______)\n         \n',
    'v': u'         \n|\\     /|\n| )   ( |\n| |   | |\n( (   ) )\n \\ \\_/ / \n  \\   /  \n   \\_/   \n         \n',
    'y': u'         \n|\\     /|\n( \\   / )\n \\ (_) / \n  \\   /  \n   ) (   \n   | |   \n   \\_/   \n         \n',
    'x': u'         \n|\\     /|\n( \\   / )\n \\ (_) / \n  ) _ (  \n / ( ) \\ \n( /   \\ )\n|/     \\|\n         \n',
    '{': u'  __ \n ( _)\n )(  \n/ |  \n\\ |  \n )(_ \n (__)\n     \n     \n',
    'z': u' _______ \n/ ___   )\n\\/   )  |\n    /   )\n   /   / \n  /   /  \n /   (_/\\\n(_______/\n         \n',
    '}': u' __  \n(_ ) \n  )( \n  | \\\n  | /\n _)( \n(__) \n     \n     \n',
    '|': u' _ \n( )\n| |\n(_)\n _ \n( )\n| |\n(_)\n   \n',
    '~': u'  _    \n /_\\_/)\n(/ \\_/ \n       \n       \n       \n       \n       \n       \n'}

fuzzy_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u" ,::. \n: ::-'\n`.::. \n _:: :\n`.::,'\n  ::  \n      \n",
    '(': u"  ,-.\n.' ,'\n: :  \n` `. \n `._;\n     \n     \n",
    ',': u"   \n   \n   \n _ \n: ;\n;' \n   \n",
    '0': u" .--. \n: ,. :\n: :: :\n: :; :\n`.__.'\n      \n      \n",
    '4': u"  .-. \n .'.' \n.'.'_ \n:_ ` :\n  :_: \n      \n      \n",
    '8': u" .--. \n: .; :\n`.  .'\n: .; :\n`.__.'\n      \n      \n",
    '<': u"     \n   -.\n ,','\n`.`. \n  :_;\n     \n     \n",
    '@': u" .-----. \n: ,.--, :\n: : .; ,'\n: :.__,_;\n`.______;\n         \n         \n",
    'D': u".---. \n: .  :\n: :: :\n: :; :\n:___.'\n      \n      \n",
    'H': u'.-..-.\n: :; :\n:    :\n: :: :\n:_;:_;\n      \n      \n',
    'L': u".-.   \n: :   \n: :   \n: :__ \n:___.'\n      \n      \n",
    'P': u".---. \n: .; :\n:  _.'\n: :   \n:_;   \n      \n      \n",
    'T': u".-----.\n`-. .-'\n  : :  \n  : :  \n  :_;  \n       \n       \n",
    'X': u".-..-.\n: `' :\n `  ' \n.'  `.\n:_;:_;\n      \n      \n",
    '\\': u'.-.   \n` `   \n ` `  \n  ` ` \n   `_;\n      \n      \n',
    '`': u".-  \n` `.\n `-'\n    \n    \n    \n    \n",
    'd': u"   .-.\n   : :\n .-' :\n' .; :\n`.__.'\n      \n      \n",
    'h': u'.-.   \n: :   \n: `-. \n: .. :\n:_;:_;\n      \n      \n',
    'l': u'.-.  \n: :  \n: :  \n: :_ \n`.__;\n     \n     \n',
    'p': u"      \n      \n.---. \n: .; `\n: ._.'\n: :   \n:_;   \n",
    't': u" .-. \n.' `.\n`. .'\n : : \n :_; \n     \n     \n",
    'x': u"      \n      \n.-.,-.\n`.  .'\n:_,._;\n      \n      \n",
    '|': u'.-.\n: :\n: :\n: :\n:_;\n   \n   \n',
    '#': u'   _  _   \n _: :: :_ \n:_  ..  _:\n:_      _:\n  :_;:_;  \n          \n          \n',
    "'": u" .-.\n.'.'\n`-' \n    \n    \n    \n    \n",
    '+': u'       \n   _   \n _: :_ \n:_   _:\n  :_:  \n       \n       \n',
    '/': u"    .-.\n   .'.'\n  .'.' \n .'.'  \n:_:    \n       \n       \n",
    '3': u".----.\n`--  ;\n .' ' \n _`,`.\n`.__.'\n      \n      \n",
    '7': u".----.\n`--  ;\n ,',' \n : :  \n :_:  \n      \n      \n",
    ';': u"   \n _ \n:_:\n _ \n: ;\n;' \n   \n",
    '?': u" .--. \n:_,. :\n  ,','\n :_;  \n :_;  \n      \n      \n",
    'C': u" .--. \n: .--'\n: :   \n: :__ \n`.__.'\n      \n      \n",
    'G': u" .--. \n: .--'\n: : _ \n: :; :\n`.__.'\n      \n      \n",
    'K': u".-..-.\n: :' ;\n:   ' \n: :.`.\n:_;:_;\n      \n      \n",
    'O': u" .--. \n: ,. :\n: :: :\n: :; :\n`.__.'\n      \n      \n",
    'S': u" .--. \n: .--'\n`. `. \n _`, :\n`.__.'\n      \n      \n",
    'W': u".-.   .-.\n: :.-.: :\n: :: :: :\n: `' `' ;\n `.,`.,' \n         \n         \n",
    '[': u".----.\n: .--'\n: :   \n: :__ \n:____:\n      \n      \n",
    '_': u'       \n       \n       \n       \n _____ \n:_____:\n       \n',
    'c': u"      \n      \n .--. \n'  ..'\n`.__.'\n      \n      \n",
    'g': u"      \n      \n .--. \n' .; :\n`._. ;\n .-. :\n `._.'\n",
    'k': u".-.   \n: :.-.\n: `'.'\n: . `.\n:_;:_;\n      \n      \n",
    'o': u"      \n      \n .--. \n' .; :\n`.__.'\n      \n      \n",
    's': u"      \n      \n .--. \n`._-.'\n`.__.'\n      \n      \n",
    'w': u"         \n         \n.-..-..-.\n: `; `; :\n`.__.__.'\n         \n         \n",
    '{': u"  .--.\n : ,-'\n.' :  \n ; :_ \n `.__;\n      \n      \n",
    '"': u".-.-.\n: : :\n`-'-'\n     \n     \n     \n     \n",
    '&': u" .--.  \n: .; ; \n ;  '_ \n: :;` ;\n`.__._;\n       \n       \n",
    '*': u"       \n _.-._ \n: ` ' :\n,'   '.\n`-:_:-'\n       \n       \n",
    '.': u'   \n   \n   \n _ \n:_;\n   \n   \n',
    '2': u".---. \n`--. :\n  ,','\n.'.'_ \n:____;\n      \n      \n",
    '6': u"  .-. \n .'.' \n.' '. \n: .; :\n`.__.'\n      \n      \n",
    ':': u'   \n _ \n:_:\n _ \n:_;\n   \n   \n',
    '>': u"     \n.-   \n`.`. \n ,','\n:_,  \n     \n     \n",
    'B': u".---. \n: .; :\n:   .'\n: .; :\n:___.'\n      \n      \n",
    'F': u".---. \n: .--'\n: `;  \n: :   \n:_;   \n      \n      \n",
    'J': u"   .-.\n   : :\n _ : :\n: :; :\n`.__.'\n      \n      \n",
    'N': u'.-..-.\n: `: :\n: .` :\n: :. :\n:_;:_;\n      \n      \n',
    'R': u".---. \n: .; :\n:   .'\n: :.`.\n:_;:_;\n      \n      \n",
    'V': u".-..-.\n: :: :\n: :: :\n: `' ;\n `.,' \n      \n      \n",
    'Z': u".----.\n`--. :\n  ,','\n.'.'_ \n:____;\n      \n      \n",
    '^': u"  --  \n.'  `.\n`-'`-'\n      \n      \n      \n      \n",
    'b': u".-.   \n: :   \n: `-. \n' .; :\n`.__.'\n      \n      \n",
    'f': u" .--.\n: .-'\n: `; \n: :  \n:_;  \n     \n     \n",
    'j': u"   _ \n  :_;\n  .-.\n  : :\n  : :\n.-. :\n`._.'\n",
    'n': u'      \n      \n,-.,-.\n: ,. :\n:_;:_;\n      \n      \n',
    'r': u"     \n     \n.--. \n: ..'\n:_;  \n     \n     \n",
    'v': u"      \n      \n.-..-.\n: `; :\n`.__.'\n      \n      \n",
    'z': u"      \n      \n.---. \n`-'_.'\n`.___;\n      \n      \n",
    '~': u" .-.,-.\n.',  .'\n`-'`-' \n       \n       \n       \n       \n",
    '!': u'.-.\n: :\n: :\n:_;\n:_;\n   \n   \n',
    '%': u",-. .-.\n`-'.'.'\n  .'.' \n .'.'_ \n:_: :_;\n       \n       \n",
    ')': u".-.  \n`. `.\n  : :\n ,' '\n:_,' \n     \n     \n",
    '-': u'       \n       \n _____ \n:_____:\n       \n       \n       \n',
    '1': u"  ,-.\n.'  :\n `: :\n  : :\n  :_;\n     \n     \n",
    '5': u".----.\n: .--'\n`. `. \n.-`, :\n`.__.'\n      \n      \n",
    '9': u' .--. \n: .; :\n`._, :\n   : :\n   :_:\n      \n      \n',
    '=': u"       \n       \n,-----.\n:-----:\n`-----'\n       \n       \n",
    'A': u' .--. \n: .; :\n:    :\n: :: :\n:_;:_;\n      \n      \n',
    'E': u" .--. \n: .--'\n: `;  \n: :__ \n`.__.'\n      \n      \n",
    'I': u'.-.\n: :\n: :\n: :\n:_;\n   \n   \n',
    'M': u".-..-.\n: `' :\n: .. :\n: :; :\n:_;:_;\n      \n      \n",
    'Q': u' .--. \n: ,. :\n: :: :\n: :;_:\n`._:_;\n      \n      \n',
    'U': u".-..-.\n: :: :\n: :: :\n: :; :\n`.__.'\n      \n      \n",
    'Y': u".-..-.\n: :: :\n`.  .'\n .' ; \n:_,'  \n      \n      \n",
    ']': u'.----.\n`--. :\n   : :\n __: :\n:____:\n      \n      \n',
    'a': u"       \n       \n .--.  \n' .; ; \n`.__,_;\n       \n       \n",
    'e': u"      \n      \n .--. \n' '_.'\n`.__.'\n      \n      \n",
    'i': u' _ \n:_;\n.-.\n: :\n:_;\n   \n   \n',
    'm': u'         \n         \n,-.,-.,-.\n: ,. ,. :\n:_;:_;:_;\n         \n         \n',
    'q': u"      \n      \n .---.\n' .; :\n`._. ;\n   : :\n   :_:\n",
    'u': u"      \n      \n.-..-.\n: :; :\n`.__.'\n      \n      \n",
    'y': u"      \n      \n.-..-.\n: :; :\n`._. ;\n .-. :\n `._.'\n",
    '}': u".--.  \n`-. : \n  : `.\n _; : \n:__.' \n      \n      \n"}

isometric1_dic = {
    '!': u'',
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /::::\\  \\  \n  /::::::\\  \\ \n /:::LS:::\\__\\\n \\::1994::/  /\n  \\::::::/  / \n   \\::::/  /  \n    \\::/  /   \n     \\/__/    \n',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /::\\~\\:\\  \\ \n /:/\\:\\ \\:\\__\\\n \\/__\\:\\/:/  /\n      \\::/  / \n      /:/  /  \n     /:/  /   \n     \\/__/    \n',
    '`': u'',
    'c': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/  \\:\\  \\ \n /:/__/ \\:\\__\\\n \\:\\  \\  \\/__/\n  \\:\\  \\      \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    'b': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /::\\~\\:\\__\\ \n /:/\\:\\ \\:|__|\n \\:\\~\\:\\/:/  /\n  \\:\\ \\::/  / \n   \\:\\/:/  /  \n    \\::/__/   \n     ~~       \n',
    'e': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /::\\~\\:\\  \\ \n /:/\\:\\ \\:\\__\\\n \\:\\~\\:\\ \\/__/\n  \\:\\ \\:\\__\\  \n   \\:\\ \\/__/  \n    \\:\\__\\    \n     \\/__/    \n',
    'd': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/  \\:\\__\\ \n /:/__/ \\:|__|\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/__/   \n     ~~       \n',
    'g': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/  \\:\\  \\ \n /:/__/_\\:\\__\\\n \\:\\  /\\ \\/__/\n  \\:\\ \\:\\__\\  \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'f': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /::\\~\\:\\  \\ \n /:/\\:\\ \\:\\__\\\n \\/__\\:\\ \\/__/\n      \\:\\__\\  \n       \\/__/  \n              \n              \n',
    'i': u'            \n      ___   \n     /\\  \\  \n     \\:\\  \\ \n     /::\\__\\\n  __/:/\\/__/\n /\\/:/  /   \n \\::/__/    \n  \\:\\__\\    \n   \\/__/    \n            \n',
    'h': u'      ___     \n     /\\__\\    \n    /:/  /    \n   /:/__/     \n  /::\\  \\ ___ \n /:/\\:\\  /\\__\\\n \\/__\\:\\/:/  /\n      \\::/  / \n      /:/  /  \n     /:/  /   \n     \\/__/    \n',
    'k': u'      ___     \n     /\\__\\    \n    /:/  /    \n   /:/__/     \n  /::\\__\\____ \n /:/\\:::::\\__\\\n \\/_|:|~~|~   \n    |:|  |    \n    |:|  |    \n    |:|  |    \n     \\|__|    \n',
    'j': u'       ___   \n      /\\  \\  \n      \\:\\  \\ \n  ___ /::\\__\\\n /\\  /:/\\/__/\n \\:\\/:/  /   \n  \\::/  /    \n   \\/__/     \n             \n             \n             \n',
    'm': u'      ___     \n     /\\__\\    \n    /::|  |   \n   /:|:|  |   \n  /:/|:|__|__ \n /:/ |::::\\__\\\n \\/__/~~/:/  /\n       /:/  / \n      /:/  /  \n     /:/  /   \n     \\/__/    \n',
    'l': u'      ___ \n     /\\__\\\n    /:/  /\n   /:/  / \n  /:/  /  \n /:/__/   \n \\:\\  \\   \n  \\:\\  \\  \n   \\:\\  \\ \n    \\:\\__\\\n     \\/__/\n',
    'o': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/  \\:\\  \\ \n /:/__/ \\:\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'n': u'      ___     \n     /\\__\\    \n    /::|  |   \n   /:|:|  |   \n  /:/|:|  |__ \n /:/ |:| /\\__\\\n \\/__|:|/:/  /\n     |:/:/  / \n     |::/  /  \n     /:/  /   \n     \\/__/    \n',
    'q': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n   \\:\\~\\:\\  \\ \n    \\:\\ \\:\\__\\\n     \\:\\/:/  /\n      \\::/  / \n      /:/  /  \n     /:/  /   \n     \\/__/    \n',
    'p': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /::\\~\\:\\  \\ \n /:/\\:\\ \\:\\__\\\n \\/__\\:\\/:/  /\n      \\::/  / \n       \\/__/  \n              \n              \n',
    's': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\ \\  \\  \n  _\\:\\~\\ \\  \\ \n /\\ \\:\\ \\ \\__\\\n \\:\\ \\:\\ \\/__/\n  \\:\\ \\:\\__\\  \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'r': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /::\\~\\:\\  \\ \n /:/\\:\\ \\:\\__\\\n \\/_|::\\/:/  /\n    |:|::/  / \n    |:|\\/__/  \n    |:|  |    \n     \\|__|    \n',
    'u': u'      ___     \n     /\\__\\    \n    /:/  /    \n   /:/  /     \n  /:/  /  ___ \n /:/__/  /\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    't': u'      ___     \n     /\\  \\    \n     \\:\\  \\   \n      \\:\\  \\  \n      /::\\  \\ \n     /:/\\:\\__\\\n    /:/  \\/__/\n   /:/  /     \n   \\/__/      \n              \n              \n',
    'w': u'      ___     \n     /\\__\\    \n    /:/ _/_   \n   /:/ /\\__\\  \n  /:/ /:/ _/_ \n /:/_/:/ /\\__\\\n \\:\\/:/ /:/  /\n  \\::/_/:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'v': u'      ___     \n     /\\__\\    \n    /:/  /    \n   /:/  /     \n  /:/__/  ___ \n  |:|  | /\\__\\\n  |:|  |/:/  /\n  |:|__/:/  / \n   \\::::/__/  \n    ~~~~      \n              \n',
    'y': u'      ___     \n     |\\__\\    \n     |:|  |   \n     |:|  |   \n     |:|__|__ \n     /::::\\__\\\n    /:/~~/~   \n   /:/  /     \n   \\/__/      \n              \n              \n',
    'x': u'      ___     \n     |\\__\\    \n     |:|  |   \n     |:|  |   \n     |:|__|__ \n ____/::::\\__\\\n \\::::/~~/~   \n  ~~|:|~~|    \n    |:|  |    \n    |:|  |    \n     \\|__|    \n',
    '{': u'',
    'z': u'      ___     \n     /\\  \\    \n     \\:\\  \\   \n      \\:\\  \\  \n       \\:\\  \\ \n _______\\:\\__\\\n \\::::::::/__/\n  \\:\\~~\\~~    \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    '}': u'',
    '|': u'',
    '~': u''}

isometric2_dic = {
    '!': u'',
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /::::\\  \\  \n  /::::::\\  \\ \n /:::LS:::\\__\\\n \\::1994::/  /\n  \\::::::/  / \n   \\::::/  /  \n    \\::/  /   \n     \\/__/    \n',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/ /::\\  \\ \n /:/_/:/\\:\\__\\\n \\:\\/:/  \\/__/\n  \\::/__/     \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    '`': u'',
    'c': u'      ___     \n     /\\__\\    \n    /:/  /    \n   /:/  /     \n  /:/  /  ___ \n /:/__/  /\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'b': u'              \n     _____    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/ /::\\__\\ \n /:/_/:/\\:|__|\n \\:\\/:/ /:/  /\n  \\::/_/:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'e': u'      ___     \n     /\\__\\    \n    /:/ _/_   \n   /:/ /\\__\\  \n  /:/ /:/ _/_ \n /:/_/:/ /\\__\\\n \\:\\/:/ /:/  /\n  \\::/_/:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'd': u'              \n     _____    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/  \\:\\__\\ \n /:/__/ \\:|__|\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'g': u'      ___     \n     /\\__\\    \n    /:/ _/_   \n   /:/ /\\  \\  \n  /:/ /::\\  \\ \n /:/__\\/\\:\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'f': u'      ___     \n     /\\__\\    \n    /:/ _/_   \n   /:/ /\\__\\  \n  /:/ /:/  /  \n /:/_/:/  /   \n \\:\\/:/  /    \n  \\::/__/     \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    'i': u'            \n            \n    ___     \n   /\\__\\    \n  /:/__/    \n /::\\  \\    \n \\/\\:\\  \\__ \n  ~~\\:\\/\\__\\\n     \\::/  /\n     /:/  / \n     \\/__/  \n',
    'h': u'      ___     \n     /\\  \\    \n     \\:\\  \\   \n      \\:\\  \\  \n  ___ /::\\  \\ \n /\\  /:/\\:\\__\\\n \\:\\/:/  \\/__/\n  \\::/__/     \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    'k': u'      ___     \n     /|  |    \n    |:|  |    \n    |:|  |    \n  __|:|  |    \n /\\ |:|__|____\n \\:\\/:::::/__/\n  \\::/~~/~    \n   \\:\\~~\\     \n    \\:\\__\\    \n     \\/__/    \n',
    'j': u'           \n    ___    \n   /\\__\\   \n  /:/__/   \n /::\\  \\   \n \\/\\:\\  \\  \n  ~~\\:\\  \\ \n     \\:\\__\\\n     /:/  /\n    /:/  / \n    \\/__/  \n',
    'm': u'      ___     \n     /\\  \\    \n    |::\\  \\   \n    |:|:\\  \\  \n  __|:|\\:\\  \\ \n /::::|_\\:\\__\\\n \\:\\~~\\  \\/__/\n  \\:\\  \\      \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    'l': u'              \n              \n              \n              \n  ___     ___ \n /\\  \\   /\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'o': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/  \\:\\  \\ \n /:/__/ \\:\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'n': u'      ___     \n     /\\  \\    \n     \\:\\  \\   \n      \\:\\  \\  \n  _____\\:\\  \\ \n /::::::::\\__\\\n \\:\\~~\\~~\\/__/\n  \\:\\  \\      \n   \\:\\  \\     \n    \\:\\__\\    \n     \\/__/    \n',
    'q': u'              \n              \n      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\  \\  \n  /:/ /::\\  \\ \n /:/_/:/\\:\\__\\\n \\:\\/:/  \\/__/\n  \\::/  /     \n   \\/__/      \n',
    'p': u'      ___   \n     /\\  \\  \n    /::\\  \\ \n   /:/\\:\\__\\\n  /:/ /:/  /\n /:/_/:/  / \n \\:\\/:/  /  \n  \\::/__/   \n   \\:\\  \\   \n    \\:\\__\\  \n     \\/__/  \n',
    's': u'      ___     \n     /\\__\\    \n    /:/ _/_   \n   /:/ /\\  \\  \n  /:/ /::\\  \\ \n /:/_/:/\\:\\__\\\n \\:\\/:/ /:/  /\n  \\::/ /:/  / \n   \\/_/:/  /  \n     /:/  /   \n     \\/__/    \n',
    'r': u'      ___     \n     /\\  \\    \n    /::\\  \\   \n   /:/\\:\\__\\  \n  /:/ /:/  /  \n /:/_/:/__/___\n \\:\\/:::::/  /\n  \\::/~~/~~~~ \n   \\:\\~~\\     \n    \\:\\__\\    \n     \\/__/    \n',
    'u': u'      ___     \n     /\\  \\    \n     \\:\\  \\   \n      \\:\\  \\  \n  ___  \\:\\  \\ \n /\\  \\  \\:\\__\\\n \\:\\  \\ /:/  /\n  \\:\\  /:/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    't': u'              \n              \n      ___     \n     /\\__\\    \n    /:/  /    \n   /:/__/     \n  /::\\  \\     \n /:/\\:\\  \\    \n \\/__\\:\\  \\   \n      \\:\\__\\  \n       \\/__/  \n',
    'w': u'      ___     \n     /\\  \\    \n    _\\:\\  \\   \n   /\\ \\:\\  \\  \n  _\\:\\ \\:\\  \\ \n /\\ \\:\\ \\:\\__\\\n \\:\\ \\:\\/:/  /\n  \\:\\ \\::/  / \n   \\:\\/:/  /  \n    \\::/  /   \n     \\/__/    \n',
    'v': u'              \n      ___     \n     /\\  \\    \n     \\:\\  \\   \n      \\:\\  \\  \n  ___  \\:\\__\\ \n /\\  \\ |:|  | \n \\:\\  \\|:|  | \n  \\:\\__|:|__| \n   \\::::/__/  \n    ~~~~      \n',
    'y': u'            \n            \n      ___   \n     /|  |  \n    |:|  |  \n    |:|  |  \n  __|:|__|  \n /::::\\  \\  \n ~~~~\\:\\  \\ \n      \\:\\__\\\n       \\/__/\n',
    'x': u'      ___      \n     /|  |     \n    |:|  |     \n    |:|  |     \n  __|:|__|     \n /::::\\__\\_____\n ~~~~\\::::/___/\n     |:|~~|    \n     |:|  |    \n     |:|__|    \n     |/__/     \n',
    '{': u'',
    'z': u'      ___     \n     /\\__\\    \n    /::|  |   \n   /:/:|  |   \n  /:/|:|  |__ \n /:/ |:| /\\__\\\n \\/__|:|/:/  /\n     |:/:/  / \n     |::/  /  \n     |:/  /   \n     |/__/    \n',
    '}': u'',
    '|': u'',
    '~': u''}

isometric3_dic = {
    '!': u'',
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /::::\\  \n  /  /::::::\\ \n /__/:::LS:::\\\n \\  \\::1994::/\n  \\  \\::::::/ \n   \\  \\::::/  \n    \\  \\::/   \n     \\__\\/    \n',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/~/::\\ \n /__/:/ /:/\\:\\\n \\  \\:\\/:/__\\/\n  \\  \\::/     \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    '`': u'',
    'c': u'      ___     \n     /  /\\    \n    /  /:/    \n   /  /:/     \n  /  /:/  ___ \n /__/:/  /  /\\\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'b': u'              \n     _____    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/~/::\\ \n /__/:/ /:/\\:|\n \\  \\:\\/:/~/:/\n  \\  \\::/ /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'e': u'      ___     \n     /  /\\    \n    /  /:/_   \n   /  /:/ /\\  \n  /  /:/ /:/_ \n /__/:/ /:/ /\\\n \\  \\:\\/:/ /:/\n  \\  \\::/ /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'd': u'     _____    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/  \\:\\ \n /__/:/ \\__\\:|\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n              \n',
    'g': u'      ___     \n     /  /\\    \n    /  /:/_   \n   /  /:/ /\\  \n  /  /:/_/::\\ \n /__/:/__\\/\\:\\\n \\  \\:\\ /~~/:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'f': u'      ___   \n     /  /\\  \n    /  /:/_ \n   /  /:/ /\\\n  /  /:/ /:/\n /__/:/ /:/ \n \\  \\:\\/:/  \n  \\  \\::/   \n   \\  \\:\\   \n    \\  \\:\\  \n     \\__\\/  \n',
    'i': u'            \n    ___     \n   /  /\\    \n  /  /:/    \n /__/::\\    \n \\__\\/\\:\\__ \n    \\  \\:\\/\\\n     \\__\\::/\n     /__/:/ \n     \\__\\/  \n            \n',
    'h': u'      ___     \n     /__/\\    \n     \\  \\:\\   \n      \\__\\:\\  \n  ___ /  /::\\ \n /__/\\  /:/\\:\\\n \\  \\:\\/:/__\\/\n  \\  \\::/     \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    'k': u'      ___     \n     /__/|    \n    |  |:|    \n    |  |:|    \n  __|  |:|    \n /__/\\_|:|____\n \\  \\:\\/:::::/\n  \\  \\::/~~~~ \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    'j': u'    ___    \n   /  /\\   \n  /  /:/   \n /__/::\\   \n \\__\\/\\:\\  \n    \\  \\:\\ \n     \\__\\:\\\n     /  /:/\n    /__/:/ \n    \\__\\/  \n           \n',
    'm': u'      ___     \n     /__/\\    \n    |  |::\\   \n    |  |:|:\\  \n  __|__|:|\\:\\ \n /__/::::| \\:\\\n \\  \\:\\~~\\__\\/\n  \\  \\:\\      \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    'l': u'              \n              \n              \n  ___     ___ \n /__/\\   /  /\\\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n              \n',
    'o': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/  \\:\\ \n /__/:/ \\__\\:\\\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'n': u'      ___     \n     /__/\\    \n     \\  \\:\\   \n      \\  \\:\\  \n  _____\\__\\:\\ \n /__/::::::::\\\n \\  \\:\\~~\\~~\\/\n  \\  \\:\\  ~~~ \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    'q': u'              \n      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/~/::\\ \n /__/:/ /:/\\:\\\n \\  \\:\\/:/__\\/\n  \\  \\::/     \n   \\__\\/      \n              \n',
    'p': u'      ___   \n     /  /\\  \n    /  /::\\ \n   /  /:/\\:\\\n  /  /:/~/:/\n /__/:/ /:/ \n \\  \\:\\/:/  \n  \\  \\::/   \n   \\  \\:\\   \n    \\  \\:\\  \n     \\__\\/  \n',
    's': u'      ___     \n     /  /\\    \n    /  /:/_   \n   /  /:/ /\\  \n  /  /:/ /::\\ \n /__/:/ /:/\\:\\\n \\  \\:\\/:/~/:/\n  \\  \\::/ /:/ \n   \\__\\/ /:/  \n     /__/:/   \n     \\__\\/    \n',
    'r': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/~/:/  \n /__/:/ /:/___\n \\  \\:\\/:::::/\n  \\  \\::/~~~~ \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    'u': u'      ___     \n     /__/\\    \n     \\  \\:\\   \n      \\  \\:\\  \n  ___  \\  \\:\\ \n /__/\\  \\__\\:\\\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    't': u'            \n      ___   \n     /  /\\  \n    /  /:/  \n   /  /:/   \n  /  /::\\   \n /__/:/\\:\\  \n \\__\\/  \\:\\ \n      \\  \\:\\\n       \\__\\/\n            \n',
    'w': u'      ___     \n     /__/\\    \n    _\\_ \\:\\   \n   /__/\\ \\:\\  \n  _\\_ \\:\\ \\:\\ \n /__/\\ \\:\\ \\:\\\n \\  \\:\\ \\:\\/:/\n  \\  \\:\\ \\::/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'v': u'             \n      ___    \n     /__/\\   \n     \\  \\:\\  \n      \\  \\:\\ \n  ___  \\__\\:\\\n /__/\\ |  |:|\n \\  \\:\\|  |:|\n  \\  \\:\\__|:|\n   \\__\\::::/ \n       ~~~~  \n',
    'y': u'            \n      ___   \n     /__/|  \n    |  |:|  \n    |  |:|  \n  __|__|:|  \n /__/::::\\  \n    ~\\~~\\:\\ \n      \\  \\:\\\n       \\__\\/\n            \n',
    'x': u'      ___     \n     /__/|    \n    |  |:|    \n    |  |:|    \n  __|__|:|    \n /__/::::\\____\n    ~\\~~\\::::/\n     |~~|:|~~ \n     |  |:|   \n     |  |:|   \n     |__|/    \n',
    '{': u'',
    'z': u'      ___     \n     /  /\\    \n    /  /::|   \n   /  /:/:|   \n  /  /:/|:|__ \n /__/:/ |:| /\\\n \\__\\/  |:|/:/\n     |  |:/:/ \n     |  |::/  \n     |  |:/   \n     |__|/    \n',
    '}': u'',
    '|': u'',
    '~': u''}

isometric4_dic = {
    '!': u'',
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /::::\\  \n  /  /::::::\\ \n /__/:::LS:::\\\n \\  \\::1994::/\n  \\  \\::::::/ \n   \\  \\::::/  \n    \\  \\::/   \n     \\__\\/    \n',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /::\\ \\:\\ \n /__/:/\\:\\_\\:\\\n \\__\\/  \\:\\/:/\n      \\__\\::/ \n      /  /:/  \n     /__/:/   \n     \\__\\/    \n',
    '`': u'',
    'c': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/  \\:\\ \n /__/:/ \\  \\:\\\n \\  \\:\\  \\__\\/\n  \\  \\:\\      \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    'b': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /::\\ \\:\\ \n /__/:/\\:\\_\\:|\n \\  \\:\\ \\:\\/:/\n  \\  \\:\\_\\::/ \n   \\  \\:\\/:/  \n    \\__\\::/   \n        ~~    \n',
    'e': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /::\\ \\:\\ \n /__/:/\\:\\ \\:\\\n \\  \\:\\ \\:\\_\\/\n  \\  \\:\\ \\:\\  \n   \\  \\:\\_\\/  \n    \\  \\:\\    \n     \\__\\/    \n',
    'd': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/  \\:\\ \n /__/:/ \\__\\:|\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\__\\::/   \n        ~~    \n',
    'g': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/  \\:\\ \n /__/:/_\\_ \\:\\\n \\  \\:\\__/\\_\\/\n  \\  \\:\\ \\:\\  \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'f': u'              \n      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /::\\ \\:\\ \n /__/:/\\:\\ \\:\\\n \\__\\/  \\:\\_\\/\n      \\  \\:\\  \n       \\__\\/  \n              \n',
    'i': u'             \n       ___   \n      /__/\\  \n      \\__\\:\\ \n      /  /::\\\n   __/  /:/\\/\n  /__/\\/:/~~ \n  \\  \\::/    \n   \\  \\:\\    \n    \\__\\/    \n             \n',
    'h': u'      ___     \n     /  /\\    \n    /  /:/    \n   /  /:/     \n  /  /::\\ ___ \n /__/:/\\:\\  /\\\n \\__\\/  \\:\\/:/\n      \\__\\::/ \n      /  /:/  \n     /__/:/   \n     \\__\\/    \n',
    'k': u'      ___     \n     /  /\\    \n    /  /:/    \n   /  /:/     \n  /  /::\\____ \n /__/:/\\:::::\\\n \\__\\/~|:|~~~~\n    |  |:|    \n    |  |:|    \n    |__|:|    \n     \\__\\|    \n',
    'j': u'             \n       ___   \n      /__/\\  \n      \\__\\:\\ \n  ___ /  /::\\\n /__/\\  /:/\\/\n \\  \\:\\/:/~~ \n  \\  \\::/    \n   \\__\\/     \n             \n             \n',
    'm': u'      ___     \n     /  /\\    \n    /  /::|   \n   /  /:|:|   \n  /  /:/|:|__ \n /__/:/_|::::\\\n \\__\\/  /~~/:/\n       /  /:/ \n      /  /:/  \n     /__/:/   \n     \\__\\/    \n',
    'l': u'      ___ \n     /  /\\\n    /  /:/\n   /  /:/ \n  /  /:/  \n /__/:/   \n \\  \\:\\   \n  \\  \\:\\  \n   \\  \\:\\ \n    \\  \\:\\\n     \\__\\/\n',
    'o': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /:/  \\:\\ \n /__/:/ \\__\\:\\\n \\  \\:\\ /  /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'n': u'      ___     \n     /  /\\    \n    /  /::|   \n   /  /:|:|   \n  /  /:/|:|__ \n /__/:/ |:| /\\\n \\__\\/  |:|/:/\n     |  |:/:/ \n     |__|::/  \n     /__/:/   \n     \\__\\/    \n',
    'q': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /__/:/\\:\\  \n   \\  \\:\\ \\:\\ \n    \\  \\:\\ \\:\\\n     \\  \\:\\/:/\n      \\__\\::/ \n      /  /:/  \n     /__/:/   \n     \\__\\/    \n',
    'p': u'              \n      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /::\\ \\:\\ \n /__/:/\\:\\_\\:\\\n \\__\\/  \\:\\/:/\n      \\  \\::/ \n       \\__\\/  \n              \n',
    's': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /__/:/\\:\\  \n  _\\_ \\:\\ \\:\\ \n /__/\\ \\:\\ \\:\\\n \\  \\:\\ \\:\\_\\/\n  \\  \\:\\_\\:\\  \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'r': u'      ___     \n     /  /\\    \n    /  /::\\   \n   /  /:/\\:\\  \n  /  /::\\ \\:\\ \n /__/:/\\:\\_\\:\\\n \\__\\/~|::\\/:/\n    |  |:|::/ \n    |  |:|\\/  \n    |__|:|~   \n     \\__\\|    \n',
    'u': u'      ___     \n     /  /\\    \n    /  /:/    \n   /  /:/     \n  /  /:/      \n /__/:/     /\\\n \\  \\:\\    /:/\n  \\  \\:\\  /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    't': u'              \n      ___     \n     /__/\\    \n     \\  \\:\\   \n      \\__\\:\\  \n      /  /::\\ \n     /  /:/\\:\\\n    /  /:/__\\/\n   /__/:/     \n   \\__\\/      \n              \n',
    'w': u'      ___     \n     /  /\\    \n    /  /:/_   \n   /  /:/ /\\  \n  /  /:/ /:/_ \n /__/:/ /:/ /\\\n \\  \\:\\/:/ /:/\n  \\  \\::/ /:/ \n   \\  \\:\\/:/  \n    \\  \\::/   \n     \\__\\/    \n',
    'v': u'              \n      ___     \n     /  /\\    \n    /  /:/    \n   /  /:/     \n  /__/:/  ___ \n  |  |:| /  /\\\n  |  |:|/  /:/\n  |__|:|__/:/ \n   \\__\\::::/  \n       ~~~~   \n',
    'y': u'              \n      __      \n     |  |\\    \n     |  |:|   \n     |  |:|   \n     |__|:|__ \n     /  /::::\\\n    /  /:/~~~~\n   /__/:/     \n   \\__\\/      \n              \n',
    'x': u'      __      \n     |  |\\    \n     |  |:|   \n     |  |:|   \n     |__|:|__ \n ____/__/::::\\\n \\__\\::::/~~~~\n    |~~|:|    \n    |  |:|    \n    |__|:|    \n     \\__\\|    \n',
    '{': u'',
    'z': u'      ___     \n     /__/\\    \n     \\  \\:\\   \n      \\  \\:\\  \n       \\  \\:\\ \n  ______\\__\\:\\\n \\  \\::::::::/\n  \\  \\:\\~~~~~ \n   \\  \\:\\     \n    \\  \\:\\    \n     \\__\\/    \n',
    '}': u'',
    '|': u'',
    '~': u''}

larry3d_dic = {
    ' ': u'           \n           \n           \n           \n           \n           \n           \n           \n           \n',
    '$': u" __       \n/\\ \\_     \n\\/'__`\\   \n/\\ \\_\\_\\  \n\\ \\____ \\ \n \\/\\ \\_\\ \\\n  \\ `\\_ _/\n   `\\_/\\_\\\n      \\/_/\n",
    '(': u"   _     \n /' \\    \n/\\ ,/'   \n\\ \\ \\    \n \\ \\ `\\  \n  \\ `\\__\\\n   `\\/_/ \n         \n         \n",
    ',': u'    \n    \n    \n    \n __ \n/\\ \\\n\\ \\/\n \\/ \n    \n',
    '0': u"   __     \n /'__`\\   \n/\\ \\/\\ \\  \n\\ \\ \\ \\ \\ \n \\ \\ \\_\\ \\\n  \\ \\____/\n   \\/___/ \n          \n          \n",
    '4': u' __ __      \n/\\ \\\\ \\     \n\\ \\ \\\\ \\    \n \\ \\ \\\\ \\_  \n  \\ \\__ ,__\\\n   \\/_/\\_\\_/\n      \\/_/  \n            \n            \n',
    '8': u"   __     \n /'_ `\\   \n/\\ \\L\\ \\  \n\\/_> _ <_ \n  /\\ \\L\\ \\\n  \\ \\____/\n   \\/___/ \n          \n          \n",
    '<': u'    ___ \n   /  / \n  /  /  \n/<  <   \n\\ `\\ `\\ \n `\\ `\\_|\n   `\\// \n        \n        \n',
    '@': u"           \n   __      \n  /'_`\\_   \n /'/'_` \\  \n/\\ \\ \\L\\ \\ \n\\ \\ `\\__,_\\\n \\ `\\_____\\\n  `\\/_____/\n           \n",
    'D': u' ____      \n/\\  _`\\    \n\\ \\ \\/\\ \\  \n \\ \\ \\ \\ \\ \n  \\ \\ \\_\\ \\\n   \\ \\____/\n    \\/___/ \n           \n           \n',
    'H': u' __  __     \n/\\ \\/\\ \\    \n\\ \\ \\_\\ \\   \n \\ \\  _  \\  \n  \\ \\ \\ \\ \\ \n   \\ \\_\\ \\_\\\n    \\/_/\\/_/\n            \n            \n',
    'L': u' __        \n/\\ \\       \n\\ \\ \\      \n \\ \\ \\  __ \n  \\ \\ \\L\\ \\\n   \\ \\____/\n    \\/___/ \n           \n           \n',
    'P': u' ____    \n/\\  _`\\  \n\\ \\ \\L\\ \\\n \\ \\ ,__/\n  \\ \\ \\/ \n   \\ \\_\\ \n    \\/_/ \n         \n         \n',
    'T': u' ______   \n/\\__  _\\  \n\\/_/\\ \\/  \n   \\ \\ \\  \n    \\ \\ \\ \n     \\ \\_\\\n      \\/_/\n          \n          \n',
    'X': u" __   __     \n/\\ \\ /\\ \\    \n\\ `\\`\\/'/'   \n `\\/ > <     \n    \\/'/\\`\\  \n    /\\_\\\\ \\_\\\n    \\/_/ \\/_/\n             \n             \n",
    '\\': u' __      \n/\\ `\\    \n\\`\\ `\\   \n`\\`\\ `\\  \n `\\`\\ `\\ \n  `\\`\\__\\\n   `\\/__/\n         \n         \n',
    '`': u' __     \n/\\ \\    \n\\ \\\\    \n \\//    \n        \n        \n        \n        \n        \n',
    'd': u"  __     \n /\\ \\    \n \\_\\ \\   \n /'_` \\  \n/\\ \\L\\ \\ \n\\ \\___,_\\\n \\/__,_ /\n         \n         \n",
    'h': u' __         \n/\\ \\        \n\\ \\ \\___    \n \\ \\  _ `\\  \n  \\ \\ \\ \\ \\ \n   \\ \\_\\ \\_\\\n    \\/_/\\/_/\n            \n            \n',
    'l': u' ___      \n/\\_ \\     \n\\//\\ \\    \n  \\ \\ \\   \n   \\_\\ \\_ \n   /\\____\\\n   \\/____/\n          \n          \n',
    'p': u"         \n         \n _____   \n/\\ '__`\\ \n\\ \\ \\L\\ \\\n \\ \\ ,__/\n  \\ \\ \\/ \n   \\ \\_\\ \n    \\/_/ \n",
    't': u' __      \n/\\ \\__   \n\\ \\ ,_\\  \n \\ \\ \\/  \n  \\ \\ \\_ \n   \\ \\__\\\n    \\/__/\n         \n         \n',
    'x': u"        \n        \n __  _  \n/\\ \\/'\\ \n\\/>  </ \n /\\_/\\_\\\n \\//\\/_/\n        \n        \n",
    '|': u' __       \n/\\ \\      \n\\ \\ \\     \n \\ \\ \\    \n  \\ \\ \\   \n   \\ \\ \\  \n    \\ \\ \\ \n     \\ \\_\\\n      \\/_/\n',
    '#': u'  __ __      \n _\\ \\\\ \\__   \n/\\__  _  _\\  \n\\/_L\\ \\\\ \\L_ \n  /\\_   _  _\\\n  \\/_/\\_\\\\_\\/\n     \\/_//_/ \n             \n             \n',
    "'": u' __     \n/\\ \\    \n\\ \\/    \n \\/     \n        \n        \n        \n        \n        \n',
    '+': u'  __      \n /\\ \\     \n \\_\\ \\___ \n/\\___  __\\\n\\/__/\\ \\_/\n    \\ \\_\\ \n     \\/_/ \n          \n          \n',
    '/': u'      __\n     / /\n    / / \n   / /  \n  / /   \n /_/    \n/_/     \n        \n        \n',
    '3': u"   __     \n /'__`\\   \n/\\_\\L\\ \\  \n\\/_/_\\_<_ \n  /\\ \\L\\ \\\n  \\ \\____/\n   \\/___/ \n          \n          \n",
    '7': u" ________ \n/\\_____  \\\n\\/___//'/'\n    /' /' \n  /' /'   \n /\\_/     \n \\//      \n          \n          \n",
    ';': u'      \n      \n __   \n/\\_\\  \n\\/_/_ \n  /\\ \\\n  \\ \\/\n   \\/ \n      \n',
    '?': u"   _    \n /'_`\\  \n/\\_\\/\\`\\\n\\/_//'/'\n   /\\_\\ \n   \\/\\_\\\n    \\/_/\n        \n        \n",
    'C': u' ____      \n/\\  _`\\    \n\\ \\ \\/\\_\\  \n \\ \\ \\/_/_ \n  \\ \\ \\L\\ \\\n   \\ \\____/\n    \\/___/ \n           \n           \n',
    'G': u' ____      \n/\\  _`\\    \n\\ \\ \\L\\_\\  \n \\ \\ \\L_L  \n  \\ \\ \\/, \\\n   \\ \\____/\n    \\/___/ \n           \n           \n',
    'K': u" __  __     \n/\\ \\/\\ \\    \n\\ \\ \\/'/'   \n \\ \\ , <    \n  \\ \\ \\\\`\\  \n   \\ \\_\\ \\_\\\n    \\/_/\\/_/\n            \n            \n",
    'O': u' _____      \n/\\  __`\\    \n\\ \\ \\/\\ \\   \n \\ \\ \\ \\ \\  \n  \\ \\ \\_\\ \\ \n   \\ \\_____\\\n    \\/_____/\n            \n            \n',
    'S': u' ____       \n/\\  _`\\     \n\\ \\,\\L\\_\\   \n \\/_\\__ \\   \n   /\\ \\L\\ \\ \n   \\ `\\____\\\n    \\/_____/\n            \n            \n',
    'W': u" __      __    \n/\\ \\  __/\\ \\   \n\\ \\ \\/\\ \\ \\ \\  \n \\ \\ \\ \\ \\ \\ \\ \n  \\ \\ \\_/ \\_\\ \\\n   \\ `\\___x___/\n    '\\/__//__/ \n               \n               \n",
    '[': u' ____     \n/\\  _\\    \n\\ \\ \\/    \n \\ \\ \\    \n  \\ \\ \\_  \n   \\ \\___\\\n    \\/___/\n          \n          \n',
    '_': u'          \n          \n          \n          \n          \n          \n  _______ \n /\\______\\\n \\/______/\n',
    'c': u"        \n        \n  ___   \n /'___\\ \n/\\ \\__/ \n\\ \\____\\\n \\/____/\n        \n        \n",
    'g': u"          \n          \n   __     \n /'_ `\\   \n/\\ \\L\\ \\  \n\\ \\____ \\ \n \\/___L\\ \\\n   /\\____/\n   \\_/__/ \n",
    'k': u" __         \n/\\ \\        \n\\ \\ \\/'\\    \n \\ \\ , <    \n  \\ \\ \\\\`\\  \n   \\ \\_\\ \\_\\\n    \\/_/\\/_/\n            \n            \n",
    'o': u'        \n        \n  ___   \n / __`\\ \n/\\ \\L\\ \\\n\\ \\____/\n \\/___/ \n        \n        \n',
    's': u"        \n        \n  ____  \n /',__\\ \n/\\__, `\\\n\\/\\____/\n \\/___/ \n        \n        \n",
    'w': u"             \n             \n __  __  __  \n/\\ \\/\\ \\/\\ \\ \n\\ \\ \\_/ \\_/ \\\n \\ \\___x___/'\n  \\/__//__/  \n             \n             \n",
    '{': u"     _ \n   /' \\\n  \\ ,/'\n <' \\  \n< \\ `\\ \n \\`\\__\\\n  \\/__/\n       \n       \n",
    '"': u' __ __     \n/\\ \\\\ \\    \n\\ \\_\\\\_\\   \n \\/_//_/   \n           \n           \n           \n           \n           \n',
    '&': u'  ____      \n/|  _ \\     \n|/\\   |     \n \\// __`\\/\\ \n /|  \\L>  <_\n | \\_____/\\/\n  \\/____/\\/ \n            \n            \n',
    '*': u"  __      \n _\\ \\ _   \n/\\_` ' \\  \n\\/_>   <_ \n  /\\_, ,_\\\n  \\/_/\\_\\/\n     \\/_/ \n          \n          \n",
    '.': u'    \n    \n    \n    \n __ \n/\\_\\\n\\/_/\n    \n    \n',
    '2': u"   ___     \n /'___`\\   \n/\\_\\ /\\ \\  \n\\/_/// /__ \n   // /_\\ \\\n  /\\______/\n  \\/_____/ \n           \n           \n",
    '6': u"  ____    \n /'___\\   \n/\\ \\__/   \n\\ \\  _``\\ \n \\ \\ \\L\\ \\\n  \\ \\____/\n   \\/___/ \n          \n          \n",
    ':': u'      \n      \n __   \n/\\_\\  \n\\/_/_ \n  /\\_\\\n  \\/_/\n      \n      \n',
    '>': u' __     \n/\\ `\\   \n\\ `\\ `\\ \n `\\ >  >\n   /  / \n  /\\_/  \n  \\//   \n        \n        \n',
    'B': u" ____      \n/\\  _`\\    \n\\ \\ \\L\\ \\  \n \\ \\  _ <' \n  \\ \\ \\L\\ \\\n   \\ \\____/\n    \\/___/ \n           \n           \n",
    'F': u' ____    \n/\\  _`\\  \n\\ \\ \\L\\_\\\n \\ \\  _\\/\n  \\ \\ \\/ \n   \\ \\_\\ \n    \\/_/ \n         \n         \n',
    'J': u' _____    \n/\\___ \\   \n\\/__/\\ \\  \n   _\\ \\ \\ \n  /\\ \\_\\ \\\n  \\ \\____/\n   \\/___/ \n          \n          \n',
    'N': u' __  __     \n/\\ \\/\\ \\    \n\\ \\ `\\\\ \\   \n \\ \\ , ` \\  \n  \\ \\ \\`\\ \\ \n   \\ \\_\\ \\_\\\n    \\/_/\\/_/\n            \n            \n',
    'R': u' ____       \n/\\  _`\\     \n\\ \\ \\L\\ \\   \n \\ \\ ,  /   \n  \\ \\ \\\\ \\  \n   \\ \\_\\ \\_\\\n    \\/_/\\/ /\n            \n            \n',
    'V': u' __  __    \n/\\ \\/\\ \\   \n\\ \\ \\ \\ \\  \n \\ \\ \\ \\ \\ \n  \\ \\ \\_/ \\\n   \\ `\\___/\n    `\\/__/ \n           \n           \n',
    'Z': u" ________     \n/\\_____  \\    \n\\/____//'/'   \n     //'/'    \n    //'/'___  \n    /\\_______\\\n    \\/_______/\n              \n              \n",
    '^': u'  __      \n /  `\\    \n/\\_/\\_\\   \n\\//\\//    \n          \n          \n          \n          \n          \n',
    'b': u" __        \n/\\ \\       \n\\ \\ \\____  \n \\ \\ '__`\\ \n  \\ \\ \\L\\ \\\n   \\ \\_,__/\n    \\/___/ \n           \n           \n",
    'f': u"   ___  \n /'___\\ \n/\\ \\__/ \n\\ \\ ,__\\\n \\ \\ \\_/\n  \\ \\_\\ \n   \\/_/ \n        \n        \n",
    'j': u'        \n __     \n/\\_\\    \n\\/\\ \\   \n \\ \\ \\  \n _\\ \\ \\ \n/\\ \\_\\ \\\n\\ \\____/\n \\/___/ \n',
    'n': u"         \n         \n  ___    \n/' _ `\\  \n/\\ \\/\\ \\ \n\\ \\_\\ \\_\\\n \\/_/\\/_/\n         \n         \n",
    'r': u"       \n       \n _ __  \n/\\`'__\\\n\\ \\ \\/ \n \\ \\_\\ \n  \\/_/ \n       \n       \n",
    'v': u'         \n         \n __  __  \n/\\ \\/\\ \\ \n\\ \\ \\_/ |\n \\ \\___/ \n  \\/__/  \n         \n         \n',
    'z': u'         \n         \n ____    \n/\\_ ,`\\  \n\\/_/  /_ \n  /\\____\\\n  \\/____/\n         \n         \n',
    '~': u"   _   _    \n /' \\/' \\   \n/\\_/\\__//   \n\\//\\/__/    \n            \n            \n            \n            \n            \n",
    '!': u' __     \n/\\ \\    \n\\ \\ \\   \n \\ \\ \\  \n  \\ \\_\\ \n   \\/\\_\\\n    \\/_/\n        \n        \n',
    '%': u' __     __  \n/\\_\\   / /  \n\\/_/  / /   \n     / /    \n    / /  __ \n   /_/  /\\_\\\n  /_/   \\/_/\n            \n            \n',
    ')': u" __     \n/\\ `\\   \n\\`\\  \\  \n `\\`\\ \\ \n  `\\/' \\\n   /\\__/\n   \\/_/ \n        \n        \n",
    '-': u'         \n         \n         \n _______ \n/\\______\\\n\\/______/\n         \n         \n         \n',
    '1': u"   _     \n /' \\    \n/\\_, \\   \n\\/_/\\ \\  \n   \\ \\ \\ \n    \\ \\_\\\n     \\/_/\n         \n         \n",
    '5': u' ______    \n/\\  ___\\   \n\\ \\ \\__/   \n \\ \\___``\\ \n  \\/\\ \\L\\ \\\n   \\ \\____/\n    \\/___/ \n           \n           \n',
    '9': u"   __      \n /'_ `\\    \n/\\ \\L\\ \\   \n\\ \\___, \\  \n \\/__,/\\ \\ \n      \\ \\_\\\n       \\/_/\n           \n           \n",
    '=': u'           \n _______   \n/\\______\\  \n\\/______/_ \n  /\\______\\\n  \\/______/\n           \n           \n           \n',
    'A': u' ______     \n/\\  _  \\    \n\\ \\ \\L\\ \\   \n \\ \\  __ \\  \n  \\ \\ \\/\\ \\ \n   \\ \\_\\ \\_\\\n    \\/_/\\/_/\n            \n            \n',
    'E': u' ____      \n/\\  _`\\    \n\\ \\ \\L\\_\\  \n \\ \\  _\\L  \n  \\ \\ \\L\\ \\\n   \\ \\____/\n    \\/___/ \n           \n           \n',
    'I': u' ______     \n/\\__  _\\    \n\\/_/\\ \\/    \n   \\ \\ \\    \n    \\_\\ \\__ \n    /\\_____\\\n    \\/_____/\n            \n            \n',
    'M': u"            \n /'\\_/`\\    \n/\\      \\   \n\\ \\ \\__\\ \\  \n \\ \\ \\_/\\ \\ \n  \\ \\_\\\\ \\_\\\n   \\/_/ \\/_/\n            \n            \n",
    'Q': u" _____      \n/\\  __`\\    \n\\ \\ \\/\\ \\   \n \\ \\ \\ \\ \\  \n  \\ \\ \\\\'\\\\ \n   \\ \\___\\_\\\n    \\/__//_/\n            \n            \n",
    'U': u' __  __     \n/\\ \\/\\ \\    \n\\ \\ \\ \\ \\   \n \\ \\ \\ \\ \\  \n  \\ \\ \\_\\ \\ \n   \\ \\_____\\\n    \\/_____/\n            \n            \n',
    'Y': u" __    __ \n/\\ \\  /\\ \\\n\\ `\\`\\\\/'/\n `\\ `\\ /' \n   `\\ \\ \\ \n     \\ \\_\\\n      \\/_/\n          \n          \n",
    ']': u' ____     \n/\\__ \\    \n\\/_/\\ \\   \n   \\ \\ \\  \n    \\_\\ \\ \n    /\\___\\\n    \\/___/\n          \n          \n',
    'a': u"          \n          \n   __     \n /'__`\\   \n/\\ \\L\\.\\_ \n\\ \\__/.\\_\\\n \\/__/\\/_/\n          \n          \n",
    'e': u"        \n        \n   __   \n /'__`\\ \n/\\  __/ \n\\ \\____\\\n \\/____/\n        \n        \n",
    'i': u'       \n __    \n/\\_\\   \n\\/\\ \\  \n \\ \\ \\ \n  \\ \\_\\\n   \\/_/\n       \n       \n',
    'm': u"             \n             \n  ___ ___    \n/' __` __`\\  \n/\\ \\/\\ \\/\\ \\ \n\\ \\_\\ \\_\\ \\_\\\n \\/_/\\/_/\\/_/\n             \n             \n",
    'q': u"           \n           \n   __      \n /'__`\\    \n/\\ \\L\\ \\   \n\\ \\___, \\  \n \\/___/\\ \\ \n      \\ \\_\\\n       \\/_/\n",
    'u': u'         \n         \n __  __  \n/\\ \\/\\ \\ \n\\ \\ \\_\\ \\\n \\ \\____/\n  \\/___/ \n         \n         \n',
    'y': u'           \n           \n __  __    \n/\\ \\/\\ \\   \n\\ \\ \\_\\ \\  \n \\/`____ \\ \n  `/___/> \\\n     /\\___/\n     \\/__/ \n',
    '}': u" __    \n/\\ `\\  \n\\`\\  \\ \n \\ \\ `>\n //' \\ \n/\\__/' \n\\/_/   \n       \n       \n"}

nancyj_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n',
    '$': u"  #  #   \n.d8888P' \nY8#oo#o. \n  #  #88 \n`88888P' \n  #  #   \n         \n         \n",
    '(': u" a88P \nd8'   \n88    \n88    \nY8.   \n Y88b \n      \n      \n",
    ',': u'   \n   \n   \n   \ndP \n88 \n.P \n   \n',
    '0': u" a8888a  \nd8' ..8b \n88 .P 88 \n88 d' 88 \nY8'' .8P \n Y8888P  \n         \n         \n",
    '4': u'dP   dP \n88   88 \n88aaa88 \n     88 \n     88 \n     dP \n        \n        \n',
    '8': u".d888b. \nY8' `8P \nd8bad8b \n88` `88 \n8b. .88 \nY88888P \n        \n        \n",
    '<': u"   d8 \n  d8' \n d8'  \n Y8.  \n  Y8. \n   Y8 \n      \n      \n",
    '@': u" a88888b. \nd8'   `88 \n88 d8P 88 \n88 Yo8b88 \nY8.       \n Y88888P' \n          \n          \n",
    'D': u'888888ba  \n88    `8b \n88     88 \n88     88 \n88    .8P \n8888888P  \n          \n          \n',
    'H': u'dP     dP  \n88     88  \n88aaaaa88a \n88     88  \n88     88  \ndP     dP  \n           \n           \n',
    'L': u'dP        \n88        \n88        \n88        \n88        \n88888888P \n          \n          \n',
    'P': u" 888888ba  \n 88    `8b \na88aaaa8P' \n 88        \n 88        \n dP        \n           \n           \n",
    'T': u'd888888P \n   88    \n   88    \n   88    \n   88    \n   dP    \n         \n         \n',
    'X': u"dP    dP \nY8.  .8P \n Y8aa8P  \nd8'  `8b \n88    88 \ndP    dP \n         \n         \n",
    '\\': u'Yb      \n`Yb     \n `Yb    \n  `Yb   \n   `Yb  \n     88 \n        \n        \n',
    '`': u'dP \n88 \nY. \n   \n   \n   \n   \n   \n',
    'd': u"      dP \n      88 \n.d888b88 \n88'  `88 \n88.  .88 \n`88888P8 \n         \n         \n",
    'h': u"dP       \n88       \n88d888b. \n88'  `88 \n88    88 \ndP    dP \n         \n         \n",
    'l': u'dP \n88 \n88 \n88 \n88 \ndP \n   \n   \n',
    'p': u"         \n         \n88d888b. \n88'  `88 \n88.  .88 \n88Y888P' \n88       \ndP       \n",
    't': u'  dP   \n  88   \nd8888P \n  88   \n  88   \n  dP   \n       \n       \n',
    'x': u"         \n         \ndP.  .dP \n `8bd8'  \n .d88b.  \ndP'  `dP \n         \n         \n",
    '|': u'dP \n88 \n"\' \ndP \n88 \n"\' \n   \n   \n',
    '#': u'        \n dP dP  \n8888888 \n 88 88  \n8888888 \n dP dP  \n        \n        \n',
    "'": u'd8 \n88 \n.P \n   \n   \n   \n   \n   \n',
    '+': u'         \n   dP    \n   88    \n88888888 \n   88    \n   dP    \n         \n         \n',
    '/': u"     d8' \n    d8'  \n   d8'   \n  d8'    \n d8'     \n88       \n         \n         \n",
    '3': u"d8888b. \n    `88 \n aaad8' \n    `88 \n    .88 \nd88888P \n        \n        \n",
    '7': u"d88888P \n    d8' \n   d8'  \n  d8'   \n d8'    \nd8'     \n        \n        \n",
    ';': u'dP \n88 \n   \n   \ndP \n88 \n.P \n   \n',
    '?': u'.d8888ba  \n`8\'   `8b \n     .d8\' \n   d8P\'   \n   ""     \n   oo     \n          \n          \n',
    'C': u" a88888b. \nd8'   `88 \n88        \n88        \nY8.   .88 \n Y88888P' \n          \n          \n",
    'G': u" .88888.  \nd8'   `88 \n88        \n88   YP88 \nY8.   .88 \n `88888'  \n          \n          \n",
    'K': u"dP     dP \n88   .d8' \n88aaa8P'  \n88   `8b. \n88     88 \ndP     dP \n          \n          \n",
    'O': u" .88888.  \nd8'   `8b \n88     88 \n88     88 \nY8.   .8P \n `8888P'  \n          \n          \n",
    'S': u'.d88888b  \n88.    "\' \n`Y88888b. \n      `8b \nd8\'   .8P \n Y88888P  \n          \n          \n',
    'W': u"dP   dP   dP \n88   88   88 \n88  .8P  .8P \n88  d8'  d8' \n88.d8P8.d8P  \n8888' Y88'   \n             \n             \n",
    '[': u'8888P \n88    \n88    \n88    \n88    \n88888 \n      \n      \n',
    '_': u'             \n             \n             \n             \n             \n             \noooooooooooo \n             \n',
    'c': u'         \n         \n.d8888b. \n88\'  `"" \n88.  ... \n`88888P\' \n         \n         \n',
    'g': u"         \n         \n.d8888b. \n88'  `88 \n88.  .88 \n`8888P88 \n     .88 \n d8888P  \n",
    'k': u'dP       \n88       \n88  .dP  \n88888"   \n88  `8b. \ndP   `YP \n         \n         \n',
    'o': u"         \n         \n.d8888b. \n88'  `88 \n88.  .88 \n`88888P' \n         \n         \n",
    's': u"         \n         \n.d8888b. \nY8ooooo. \n      88 \n`88888P' \n         \n         \n",
    'w': u"           \n           \ndP  dP  dP \n88  88  88 \n88.88b.88' \n8888P Y8P  \n           \n           \n",
    '{': u'  .d88P \n  8:    \n.oY8.   \n  d8    \n  8:    \n  `Y88b \n        \n        \n',
    '"': u'dP dP \ndP dP \n      \n      \n      \n      \n      \n      \n',
    '&': u"   d88b    \n   8`'8    \n   d8b     \n d8P`8b    \n d8' `8bP  \n `888P'`YP \n           \n           \n",
    '*': u"    dP     \n8b. 88 .d8 \n `8b88d8'  \n .8P88Y8.  \n8P' 88 `Y8 \n    dP     \n           \n           \n",
    '.': u'   \n   \n   \n   \ndP \n88 \n   \n   \n',
    '2': u"d8888b. \n    `88 \n.aaadP' \n88'     \n88.     \nY88888P \n        \n        \n",
    '6': u".d8888P \n88'     \n88baaa. \n88` `88 \n8b. .d8 \n`Y888P' \n        \n        \n",
    ':': u'dP \n88 \n   \n   \ndP \n88 \n   \n   \n',
    '>': u'8b   \n`8b  \n `8b \n .8P \n.8P  \n8P   \n     \n     \n',
    'B': u" 888888ba  \n 88    `8b \na88aaaa8P' \n 88   `8b. \n 88    .88 \n 88888888P \n           \n           \n",
    'F': u' 88888888b \n 88        \na88aaaa    \n 88        \n 88        \n dP        \n           \n           \n',
    'J': u"       dP \n       88 \n       88 \n       88 \n88.  .d8P \n `Y8888'  \n          \n          \n",
    'N': u'888888ba  \n88    `8b \n88     88 \n88     88 \n88     88 \ndP     dP \n          \n          \n',
    'R': u" 888888ba  \n 88    `8b \na88aaaa8P' \n 88   `8b. \n 88     88 \n dP     dP \n           \n           \n",
    'V': u"dP     dP \n88     88 \n88    .8P \n88    d8' \n88  .d8P  \n888888'   \n          \n          \n",
    'Z': u"d8888888P \n     .d8' \n   .d8'   \n .d8'     \nd8'       \nY8888888P \n          \n          \n",
    '^': u'   db    \n d8\'`8b  \n`"    "\' \n         \n         \n         \n         \n         \n',
    'b': u"dP       \n88       \n88d888b. \n88'  `88 \n88.  .88 \n88Y8888' \n         \n         \n",
    'f': u'.8888b \n88   " \n88aaa  \n88     \n88     \ndP     \n       \n       \n',
    'j': u'oo \n   \ndP \n88 \n88 \n88 \n88 \ndP \n',
    'n': u"         \n         \n88d888b. \n88'  `88 \n88    88 \ndP    dP \n         \n         \n",
    'r': u"         \n         \n88d888b. \n88'  `88 \n88       \ndP       \n         \n         \n",
    'v': u"         \n         \ndP   .dP \n88   d8' \n88 .88'  \n8888P'   \n         \n         \n",
    'z': u"         \n         \nd888888b \n   .d8P' \n .Y8P    \nd888888P \n         \n         \n",
    '~': u' .oo.  .d \ndP" "d8P  \n          \n          \n          \n          \n          \n          \n',
    '!': u'dP \n88 \n88 \ndP \n   \noo \n   \n   \n',
    '%': u"d8P   dP   \n8 8  d8'   \nY8P d8'    \n   d8' d8P \n  d8'  8 8 \n 88    Y8P \n           \n           \n",
    ')': u'Y88o  \n  `8b \n   88 \n   88 \n  .8P \nd88Y  \n      \n      \n',
    '-': u'         \n         \n         \n88888888 \n         \n         \n         \n         \n',
    '1': u'd88  \n 88  \n 88  \n 88  \n 88  \nd88P \n     \n     \n',
    '5': u"888888P \n88'     \n88baaa. \n    `88 \n     88 \nd88888P \n        \n        \n",
    '9': u".d888b. \nY8' `88 \n`8bad88 \n    `88 \nd.  .88 \n`8888P  \n        \n        \n",
    '=': u'         \n         \naaaaaaaa \n         \n88888888 \n         \n         \n         \n',
    'A': u" .d888888  \nd8'    88  \n88aaaaa88a \n88     88  \n88     88  \n88     88  \n           \n           \n",
    'E': u' 88888888b \n 88        \na88aaaa    \n 88        \n 88        \n 88888888P \n           \n           \n',
    'I': u'dP \n88 \n88 \n88 \n88 \ndP \n   \n   \n',
    'M': u'8888ba.88ba  \n88  `8b  `8b \n88   88   88 \n88   88   88 \n88   88   88 \ndP   dP   dP \n             \n             \n',
    'Q': u" .88888.   \nd8'   `8b  \n88     88  \n88  db 88  \nY8.  Y88P  \n `8888PY8b \n           \n           \n",
    'U': u"dP     dP \n88     88 \n88     88 \n88     88 \nY8.   .8P \n`Y88888P' \n          \n          \n",
    'Y': u'dP    dP \nY8.  .8P \n Y8aa8P  \n   88    \n   88    \n   dP    \n         \n         \n',
    ']': u'd8888 \n   88 \n   88 \n   88 \n   88 \n88888 \n      \n      \n',
    'a': u"         \n         \n.d8888b. \n88'  `88 \n88.  .88 \n`88888P8 \n         \n         \n",
    'e': u"         \n         \n.d8888b. \n88ooood8 \n88.  ... \n`88888P' \n         \n         \n",
    'i': u'oo \n   \ndP \n88 \n88 \ndP \n   \n   \n',
    'm': u"           \n           \n88d8b.d8b. \n88'`88'`88 \n88  88  88 \ndP  dP  dP \n           \n           \n",
    'q': u"         \n         \n.d8888b. \n88'  `88 \n88.  .88 \n`8888P88 \n      88 \n      dP \n",
    'u': u"         \n         \ndP    dP \n88    88 \n88.  .88 \n`88888P' \n         \n         \n",
    'y': u'         \n         \ndP    dP \n88    88 \n88.  .88 \n`8888P88 \n     .88 \n d8888P  \n',
    '}': u"d88b.   \n   :8   \n  .8Yo. \n   8b   \n   :8   \nY88P'   \n        \n        \n"}

ogre_dic = {
    ' ': u' \n \n \n \n \n \n',
    '$': u'  _  \n | | \n/ __)\n\\__ \\\n(   /\n |_| \n',
    '(': u'  __\n / /\n| | \n| | \n| | \n \\_\\\n',
    ',': u'   \n   \n   \n _ \n( )\n|/ \n',
    '0': u'  ___  \n / _ \\ \n| | | |\n| |_| |\n \\___/ \n       \n',
    '4': u' _  _   \n| || |  \n| || |_ \n|__   _|\n   |_|  \n        \n',
    '8': u'  ___  \n ( _ ) \n / _ \\ \n| (_) |\n \\___/ \n       \n',
    '<': u'  __\n / /\n/ / \n\\ \\ \n \\_\\\n    \n',
    '@': u'   ____  \n  / __ \\ \n / / _` |\n| | (_| |\n \\ \\__,_|\n  \\____/ \n',
    'D': u"    ___ \n   /   \\\n  / /\\ /\n / /_// \n/___,'  \n        \n",
    'H': u'        \n  /\\  /\\\n / /_/ /\n/ __  / \n\\/ /_/  \n        \n',
    'L': u'   __  \n  / /  \n / /   \n/ /___ \n\\____/ \n       \n',
    'P': u'   ___ \n  / _ \\\n / /_)/\n/ ___/ \n\\/     \n       \n',
    'T': u' _____ \n/__   \\\n  / /\\/\n / /   \n \\/    \n       \n',
    'X': u'__  __\n\\ \\/ /\n \\  / \n /  \\ \n/_/\\_\\\n      \n',
    '\\': u'__    \n\\ \\   \n \\ \\  \n  \\ \\ \n   \\_\\\n      \n',
    '`': u' _ \n( )\n \\|\n   \n   \n   \n',
    'd': u'     _ \n  __| |\n / _` |\n| (_| |\n \\__,_|\n       \n',
    'h': u" _     \n| |__  \n| '_ \\ \n| | | |\n|_| |_|\n       \n",
    'l': u' _ \n| |\n| |\n| |\n|_|\n   \n',
    'p': u"       \n _ __  \n| '_ \\ \n| |_) |\n| .__/ \n|_|    \n",
    't': u' _   \n| |_ \n| __|\n| |_ \n \\__|\n     \n',
    'x': u'      \n__  __\n\\ \\/ /\n >  < \n/_/\\_\\\n      \n',
    '|': u' _ \n| |\n| |\n| |\n| |\n|_|\n',
    '#': u'   _  _   \n _| || |_ \n|_  ..  _|\n|_      _|\n  |_||_|  \n          \n',
    "'": u' _ \n( )\n|/ \n   \n   \n   \n',
    '+': u'       \n   _   \n _| |_ \n|_   _|\n  |_|  \n       \n',
    '/': u'    __\n   / /\n  / / \n / /  \n/_/   \n      \n',
    '3': u' _____ \n|___ / \n  |_ \\ \n ___) |\n|____/ \n       \n',
    '7': u' _____ \n|___  |\n   / / \n  / /  \n /_/   \n       \n',
    ';': u'   \n _ \n(_)\n _ \n( )\n|/ \n',
    '?': u' ___ \n/ _ \\\n\\// /\n  \\/ \n  () \n     \n',
    'C': u'   ___ \n  / __\\\n / /   \n/ /___ \n\\____/ \n       \n',
    'G': u'   ___ \n  / _ \\\n / /_\\/\n/ /_\\\\ \n\\____/ \n       \n',
    'K': u'       \n  /\\ /\\\n / //_/\n/ __ \\ \n\\/  \\/ \n       \n',
    'O': u'   ___ \n  /___\\\n //  //\n/ \\_// \n\\___/  \n       \n',
    'S': u' __    \n/ _\\   \n\\ \\    \n_\\ \\   \n\\__/   \n       \n',
    'W': u' __    __ \n/ / /\\ \\ \\\n\\ \\/  \\/ /\n \\  /\\  / \n  \\/  \\/  \n          \n',
    '[': u' __ \n| _|\n| | \n| | \n| | \n|__|\n',
    '_': u'       \n       \n       \n       \n _____ \n|_____|\n',
    'c': u'      \n  ___ \n / __|\n| (__ \n \\___|\n      \n',
    'g': u'       \n  __ _ \n / _` |\n| (_| |\n \\__, |\n |___/ \n',
    'k': u' _    \n| | __\n| |/ /\n|   < \n|_|\\_\\\n      \n',
    'o': u'       \n  ___  \n / _ \\ \n| (_) |\n \\___/ \n       \n',
    's': u'     \n ___ \n/ __|\n\\__ \\\n|___/\n     \n',
    'w': u'          \n__      __\n\\ \\ /\\ / /\n \\ V  V / \n  \\_/\\_/  \n          \n',
    '{': u'   __\n  / /\n | | \n< <  \n | | \n  \\_\\\n',
    '"': u' _ _ \n( | )\n V V \n     \n     \n     \n',
    '&': u'  ___   \n ( _ )  \n / _ \\/\\\n| (_>  <\n \\___/\\/\n        \n',
    '*': u'      \n__/\\__\n\\    /\n/_  _\\\n  \\/  \n      \n',
    '.': u'   \n   \n   \n _ \n(_)\n   \n',
    '2': u' ____  \n|___ \\ \n  __) |\n / __/ \n|_____|\n       \n',
    '6': u"  __   \n / /_  \n| '_ \\ \n| (_) |\n \\___/ \n       \n",
    ':': u'   \n _ \n(_)\n _ \n(_)\n   \n',
    '>': u'__  \n\\ \\ \n \\ \\\n / /\n/_/ \n    \n',
    'B': u'   ___ \n  / __\\\n /__\\//\n/ \\/  \\\n\\_____/\n       \n',
    'F': u'   ___ \n  / __\\\n / _\\  \n/ /    \n\\/     \n       \n',
    'J': u'  __  \n  \\ \\ \n   \\ \\\n/\\_/ /\n\\___/ \n      \n',
    'N': u'     __ \n  /\\ \\ \\\n /  \\/ /\n/ /\\  / \n\\_\\ \\/  \n        \n',
    'R': u'   __  \n  /__\\ \n / \\// \n/ _  \\ \n\\/ \\_/ \n       \n',
    'V': u'        \n/\\   /\\ \n\\ \\ / / \n \\ V /  \n  \\_/   \n        \n',
    'Z': u' _____\n/ _  /\n\\// / \n / //\\\n/____/\n      \n',
    '^': u'    \n /\\ \n|/\\|\n    \n    \n    \n',
    'b': u" _     \n| |__  \n| '_ \\ \n| |_) |\n|_.__/ \n       \n",
    'f': u'  __ \n / _|\n| |_ \n|  _|\n|_|  \n     \n',
    'j': u'   _ \n  (_)\n  | |\n  | |\n _/ |\n|__/ \n',
    'n': u"       \n _ __  \n| '_ \\ \n| | | |\n|_| |_|\n       \n",
    'r': u"      \n _ __ \n| '__|\n| |   \n|_|   \n      \n",
    'v': u'       \n__   __\n\\ \\ / /\n \\ V / \n  \\_/  \n       \n',
    'z': u'     \n ____\n|_  /\n / / \n/___|\n     \n',
    '~': u'     \n /\\/|\n|/\\/ \n     \n     \n     \n',
    '!': u'   _ \n  / \\\n /  /\n/\\_/ \n\\/   \n     \n',
    '%': u' _  __\n(_)/ /\n  / / \n / /_ \n/_/(_)\n      \n',
    ')': u'__  \n\\ \\ \n | |\n | |\n | |\n/_/ \n',
    '-': u'       \n       \n _____ \n|_____|\n       \n       \n',
    '1': u' _ \n/ |\n| |\n| |\n|_|\n   \n',
    '5': u' ____  \n| ___| \n|___ \\ \n ___) |\n|____/ \n       \n',
    '9': u'  ___  \n / _ \\ \n| (_) |\n \\__, |\n   /_/ \n       \n',
    '=': u'       \n _____ \n|_____|\n|_____|\n       \n       \n',
    'A': u'   _   \n  /_\\  \n //_\\\\ \n/  _  \\\n\\_/ \\_/\n       \n',
    'E': u'   __ \n  /__\\\n /_\\  \n//__  \n\\__/  \n      \n',
    'I': u'  _____ \n  \\_   \\\n   / /\\/\n/\\/ /_  \n\\____/  \n        \n',
    'M': u'        \n  /\\/\\  \n /    \\ \n/ /\\/\\ \\\n\\/    \\/\n        \n',
    'Q': u'   ____ \n  /___ \\\n //  / /\n/ \\_/ / \n\\___,_\\ \n        \n',
    'U': u'       \n /\\ /\\ \n/ / \\ \\\n\\ \\_/ /\n \\___/ \n       \n',
    'Y': u'     \n/\\_/\\\n\\_ _/\n / \\ \n \\_/ \n     \n',
    ']': u' __ \n|_ |\n | |\n | |\n | |\n|__|\n',
    'a': u'       \n  __ _ \n / _` |\n| (_| |\n \\__,_|\n       \n',
    'e': u'      \n  ___ \n / _ \\\n|  __/\n \\___|\n      \n',
    'i': u' _ \n(_)\n| |\n| |\n|_|\n   \n',
    'm': u"           \n _ __ ___  \n| '_ ` _ \\ \n| | | | | |\n|_| |_| |_|\n           \n",
    'q': u'       \n  __ _ \n / _` |\n| (_| |\n \\__, |\n    |_|\n',
    'u': u'       \n _   _ \n| | | |\n| |_| |\n \\__,_|\n       \n',
    'y': u'       \n _   _ \n| | | |\n| |_| |\n \\__, |\n |___/ \n',
    '}': u'__   \n\\ \\  \n | | \n  > >\n | | \n/_/  \n'}

rectangles_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n',
    '$': u'   _   \n _| |_ \n|   __|\n|__   |\n|_   _|\n  |_|  \n',
    '(': u'   _ \n _|_|\n| |  \n| |  \n|_|_ \n  |_|\n',
    ',': u'   \n   \n   \n _ \n| |\n|_|\n',
    '0': u'     \n ___ \n|   |\n| | |\n|___|\n     \n',
    '4': u'     \n ___ \n| | |\n|_  |\n  |_|\n     \n',
    '8': u'     \n ___ \n| . |\n| . |\n|___|\n     \n',
    '<': u'   __\n  / /\n / / \n< <  \n \\ \\ \n  \\_\\\n',
    '@': u'       \n _____ \n|  __ |\n| |___|\n|_____|\n       \n',
    'D': u'       \n ____  \n|    \\ \n|  |  |\n|____/ \n       \n',
    'H': u'       \n _____ \n|  |  |\n|     |\n|__|__|\n       \n',
    'L': u'       \n __    \n|  |   \n|  |__ \n|_____|\n       \n',
    'P': u'       \n _____ \n|  _  |\n|   __|\n|__|   \n       \n',
    'T': u'       \n _____ \n|_   _|\n  | |  \n  |_|  \n       \n',
    'X': u'       \n __ __ \n|  |  |\n|-   -|\n|__|__|\n       \n',
    '\\': u'     \n _   \n| \\  \n \\ \\ \n  \\_|\n     \n',
    '`': u' ___ \n|_  |\n  |_|\n     \n     \n     \n',
    'd': u'     \n   _ \n _| |\n| . |\n|___|\n     \n',
    'h': u'     \n _   \n| |_ \n|   |\n|_|_|\n     \n',
    'l': u'   \n _ \n| |\n| |\n|_|\n   \n',
    'p': u'     \n     \n ___ \n| . |\n|  _|\n|_|  \n',
    't': u'     \n _   \n| |_ \n|  _|\n|_|  \n     \n',
    'x': u"     \n     \n _ _ \n|_'_|\n|_,_|\n     \n",
    '|': u' _ \n| |\n| |\n| |\n| |\n|_|\n',
    '#': u'   _ _   \n _| | |_ \n|_     _|\n|_     _|\n  |_|_|  \n         \n',
    "'": u' _ \n| |\n|_|\n   \n   \n   \n',
    '+': u'       \n   _   \n _| |_ \n|_   _|\n  |_|  \n       \n',
    '/': u'     \n   _ \n  / |\n / / \n|_/  \n     \n',
    '3': u'     \n ___ \n|_  |\n|_  |\n|___|\n     \n',
    '7': u'     \n ___ \n|_  |\n  | |\n  |_|\n     \n',
    ';': u'   \n _ \n|_|\n _ \n| |\n|_|\n',
    '?': u' _____ \n|___  |\n  |  _|\n  |_|  \n  |_|  \n       \n',
    'C': u'       \n _____ \n|     |\n|   --|\n|_____|\n       \n',
    'G': u'       \n _____ \n|   __|\n|  |  |\n|_____|\n       \n',
    'K': u'       \n _____ \n|  |  |\n|    -|\n|__|__|\n       \n',
    'O': u'       \n _____ \n|     |\n|  |  |\n|_____|\n       \n',
    'S': u'       \n _____ \n|   __|\n|__   |\n|_____|\n       \n',
    'W': u'       \n _ _ _ \n| | | |\n| | | |\n|_____|\n       \n',
    '[': u' ___ \n|  _|\n| |  \n| |  \n| |_ \n|___|\n',
    '_': u'       \n       \n       \n       \n _____ \n|_____|\n',
    'c': u'     \n     \n ___ \n|  _|\n|___|\n     \n',
    'g': u'     \n     \n ___ \n| . |\n|_  |\n|___|\n',
    'k': u"     \n _   \n| |_ \n| '_|\n|_,_|\n     \n",
    'o': u'     \n     \n ___ \n| . |\n|___|\n     \n',
    's': u'     \n     \n ___ \n|_ -|\n|___|\n     \n',
    'w': u'       \n       \n _ _ _ \n| | | |\n|_____|\n       \n',
    '{': u'   ___ \n  |  _|\n _| |  \n|_  |  \n  | |_ \n  |___|\n',
    '"': u' _ _ \n| | |\n|_|_|\n     \n     \n     \n',
    '&': u'   _   \n _| |_ \n|   __|\n|   __|\n|_   _|\n  |_|  \n',
    '*': u'       \n _____ \n| | | |\n|-   -|\n|_|_|_|\n       \n',
    '.': u'   \n   \n   \n _ \n|_|\n   \n',
    '2': u'     \n ___ \n|_  |\n|  _|\n|___|\n     \n',
    '6': u'     \n ___ \n|  _|\n| . |\n|___|\n     \n',
    ':': u'   \n _ \n|_|\n _ \n|_|\n   \n',
    '>': u'__   \n\\ \\  \n \\ \\ \n  > >\n / / \n/_/  \n',
    'B': u'       \n _____ \n| __  |\n| __ -|\n|_____|\n       \n',
    'F': u'       \n _____ \n|   __|\n|   __|\n|__|   \n       \n',
    'J': u'       \n    __ \n __|  |\n|  |  |\n|_____|\n       \n',
    'N': u'       \n _____ \n|   | |\n| | | |\n|_|___|\n       \n',
    'R': u'       \n _____ \n| __  |\n|    -|\n|__|__|\n       \n',
    'V': u'       \n _____ \n|  |  |\n|  |  |\n \\___/ \n       \n',
    'Z': u'       \n _____ \n|__   |\n|   __|\n|_____|\n       \n',
    '^': u' _____ \n|  _  |\n|_| |_|\n       \n       \n       \n',
    'b': u'     \n _   \n| |_ \n| . |\n|___|\n     \n',
    'f': u'     \n ___ \n|  _|\n|  _|\n|_|  \n     \n',
    'j': u'     \n   _ \n  |_|\n  | |\n _| |\n|___|\n',
    'n': u'     \n     \n ___ \n|   |\n|_|_|\n     \n',
    'r': u'     \n     \n ___ \n|  _|\n|_|  \n     \n',
    'v': u'     \n     \n _ _ \n| | |\n \\_/ \n     \n',
    'z': u'     \n     \n ___ \n|- _|\n|___|\n     \n',
    '~': u' _____ \n|   | |\n|_|___|\n       \n       \n       \n',
    '!': u' __ \n|  |\n|  |\n|__|\n|__|\n    \n',
    '%': u'       \n __ __ \n|__|  |\n|   __|\n|__|__|\n       \n',
    ')': u' _   \n|_|_ \n  | |\n  | |\n _|_|\n|_|  \n',
    '-': u'     \n     \n ___ \n|___|\n     \n     \n',
    '1': u'       \n ___   \n|_  |  \n _| |_ \n|_____|\n       \n',
    '5': u'     \n ___ \n|  _|\n|_  |\n|___|\n     \n',
    '9': u'     \n ___ \n| . |\n|_  |\n|___|\n     \n',
    '=': u'       \n       \n _____ \n|_____|\n|_____|\n       \n',
    'A': u'       \n _____ \n|  _  |\n|     |\n|__|__|\n       \n',
    'E': u'       \n _____ \n|   __|\n|   __|\n|_____|\n       \n',
    'I': u'       \n _____ \n|     |\n|-   -|\n|_____|\n       \n',
    'M': u'       \n _____ \n|     |\n| | | |\n|_|_|_|\n       \n',
    'Q': u'       \n _____ \n|     |\n|  |  |\n|__  _|\n   |__|\n',
    'U': u'       \n _____ \n|  |  |\n|  |  |\n|_____|\n       \n',
    'Y': u'       \n __ __ \n|  |  |\n|_   _|\n  |_|  \n       \n',
    ']': u' ___ \n|_  |\n  | |\n  | |\n _| |\n|___|\n',
    'a': u"     \n     \n ___ \n| .'|\n|__,|\n     \n",
    'e': u'     \n     \n ___ \n| -_|\n|___|\n     \n',
    'i': u'   \n _ \n|_|\n| |\n|_|\n   \n',
    'm': u'       \n       \n _____ \n|     |\n|_|_|_|\n       \n',
    'q': u'     \n     \n ___ \n| . |\n|_  |\n  |_|\n',
    'u': u'     \n     \n _ _ \n| | |\n|___|\n     \n',
    'y': u'     \n     \n _ _ \n| | |\n|_  |\n|___|\n',
    '}': u' ___   \n|_  |  \n  | |_ \n  |  _|\n _| |  \n|___|  \n'}

roman_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n',
    '$': u"   o    \n.d88888 \n8[ 8    \n`Y888B. \n   8 ]8 \n88888P' \n   8    \n        \n        \n        \n",
    '(': u'  .o \n .8\' \n.8\'  \n88   \n88   \n`8.  \n `8. \n  `" \n     \n     \n',
    ',': u"    \n    \n    \n    \n    \n.o. \nY8P \n '  \n    \n    \n",
    '0': u"  .oooo.   \n d8P'`Y8b  \n888    888 \n888    888 \n888    888 \n`88b  d88' \n `Y8bd8P'  \n           \n           \n           \n",
    '4': u"      .o   \n    .d88   \n  .d'888   \n.d'  888   \n88ooo888oo \n     888   \n    o888o  \n           \n           \n           \n",
    '8': u" .ooooo.   \nd88'   `8. \nY88..  .8' \n `88888b.  \n.8'  ``88b \n`8.   .88P \n `boood8'  \n           \n           \n           \n",
    '<': u'       \n   .dP \n .dP   \ndP     \nYb     \n `Yb   \n   `Yb \n       \n       \n       \n',
    '@': u'  .oooooo.  \n d\'     `b  \nd\' .d"bd  8 \n8  8. 8  .d \nY.  YoP"b\'  \n 8.      .8 \n  YooooooP  \n            \n            \n            \n',
    'D': u"oooooooooo.   \n`888'   `Y8b  \n 888      888 \n 888      888 \n 888      888 \n 888     d88' \no888bood8P'   \n              \n              \n              \n",
    'H': u"ooooo   ooooo \n`888'   `888' \n 888     888  \n 888ooooo888  \n 888     888  \n 888     888  \no888o   o888o \n              \n              \n              \n",
    'L': u"ooooo        \n`888'        \n 888         \n 888         \n 888         \n 888       o \no888ooooood8 \n             \n             \n             \n",
    'P': u"ooooooooo.   \n`888   `Y88. \n 888   .d88' \n 888ooo88P'  \n 888         \n 888         \no888o        \n             \n             \n             \n",
    'T': u"ooooooooooooo \n8'   888   `8 \n     888      \n     888      \n     888      \n     888      \n    o888o     \n              \n              \n              \n",
    'X': u"ooooooo  ooooo \n `8888    d8'  \n   Y888..8P    \n    `8888'     \n   .8PY888.    \n  d8'  `888b   \no888o  o88888o \n               \n               \n               \n",
    '\\': u'88      \n`8.     \n `8.    \n  `8.   \n   `8.  \n    `8. \n     88 \n        \n        \n        \n',
    '`': u"o8o \nYP' \n `  \n    \n    \n    \n    \n    \n    \n    \n",
    'd': u'      .o8  \n     "888  \n .oooo888  \nd88\' `888  \n888   888  \n888   888  \n`Y8bod88P" \n           \n           \n           \n',
    'h': u'oooo        \n`888        \n 888 .oo.   \n 888P"Y88b  \n 888   888  \n 888   888  \no888o o888o \n            \n            \n            \n',
    'l': u'oooo  \n`888  \n 888  \n 888  \n 888  \n 888  \no888o \n      \n      \n      \n',
    'p': u"           \n           \noo.ooooo.  \n 888' `88b \n 888   888 \n 888   888 \n 888bod8P' \n 888       \no888o      \n           \n",
    't': u'    .   \n  .o8   \n.o888oo \n  888   \n  888   \n  888 . \n  "888" \n        \n        \n        \n',
    'x': u'            \n            \noooo    ooo \n `88b..8P\'  \n   Y888\'    \n .o8"\'88b   \no88\'   888o \n            \n            \n            \n',
    '|': u'8 \n8 \n8 \n  \n8 \n8 \n8 \n  \n  \n  \n',
    '#': u"       .o   .o   \n      .8'  .8'   \n  .888888888888' \n    .8'  .8'     \n.888888888888'   \n  .8'  .8'       \n .8'  .8'        \n                 \n                 \n                 \n",
    "'": u"o8o \n`YP \n '  \n    \n    \n    \n    \n    \n    \n    \n",
    '+': u'           \n           \n    88     \n    88     \n8888888888 \n    88     \n    88     \n           \n           \n           \n',
    '/': u"     88 \n    .8' \n   .8'  \n  .8'   \n .8'    \n.8'     \n88      \n        \n        \n        \n",
    '3': u'  .oooo.   \n.dP""Y88b  \n      ]8P\' \n    <88b.  \n     `88b. \no.   .88P  \n`8bd88P\'   \n           \n           \n           \n',
    '7': u' ooooooooo \nd"""""""8\' \n      .8\'  \n     .8\'   \n    .8\'    \n   .8\'     \n  .8\'      \n           \n           \n           \n',
    ';': u'    \n    \n    \n    \no8o \n`"\' \no8o \n`]P \n \'  \n    \n',
    '?': u' .oooooo.  \ndP\'   `Y8b \n88o   .d8P \n`"\' .d8P\'  \n   `88\'    \n   .o.     \n   Y8P     \n           \n           \n           \n',
    'C': u"  .oooooo.   \n d8P'  `Y8b  \n888          \n888          \n888          \n`88b    ooo  \n `Y8bood8P'  \n             \n             \n             \n",
    'G': u"  .oooooo.    \n d8P'  `Y8b   \n888           \n888           \n888     ooooo \n`88.    .88'  \n `Y8bood8P'   \n              \n              \n              \n",
    'K': u"oooo    oooo \n`888   .8P'  \n 888  d8'    \n 88888[      \n 888`88b.    \n 888  `88b.  \no888o  o888o \n             \n             \n             \n",
    'O': u"  .oooooo.   \n d8P'  `Y8b  \n888      888 \n888      888 \n888      888 \n`88b    d88' \n `Y8bood8P'  \n             \n             \n             \n",
    'S': u' .oooooo..o \nd8P\'    `Y8 \nY88bo.      \n `"Y8888o.  \n     `"Y88b \noo     .d8P \n8""88888P\'  \n            \n            \n            \n',
    'W': u"oooooo   oooooo     oooo \n `888.    `888.     .8'  \n  `888.   .8888.   .8'   \n   `888  .8'`888. .8'    \n    `888.8'  `888.8'     \n     `888'    `888'      \n      `8'      `8'       \n                         \n                         \n                         \n",
    '[': u'oooo \n8    \n8    \n8    \n8    \n8    \n8ooo \n     \n     \n     \n',
    '_': u'            \n            \n            \n            \n            \n            \nooooooooooo \n            \n            \n            \n',
    'c': u'          \n          \n .ooooo.  \nd88\' `"Y8 \n888       \n888   .o8 \n`Y8bod8P\' \n          \n          \n          \n',
    'g': u'           \n           \n .oooooooo \n888\' `88b  \n888   888  \n`88bod8P\'  \n`8oooooo.  \nd"     YD  \n"Y88888P\'  \n           \n',
    'k': u"oooo        \n`888        \n 888  oooo  \n 888 .8P'   \n 888888.    \n 888 `88b.  \no888o o888o \n            \n            \n            \n",
    'o': u"          \n          \n .ooooo.  \nd88' `88b \n888   888 \n888   888 \n`Y8bod8P' \n          \n          \n          \n",
    's': u'         \n         \n .oooo.o \nd88(  "8 \n`"Y88b.  \no.  )88b \n8""888P\' \n         \n         \n         \n',
    'w': u"                 \n                 \noooo oooo    ooo \n `88. `88.  .8'  \n  `88..]88..8'   \n   `888'`888'    \n    `8'  `8'     \n                 \n                 \n                 \n",
    '{': u"  d88' \n d88'  \n 888   \n<88    \n 888   \n Y88.  \n  Y88. \n       \n       \n       \n",
    '"': u"o8o o8o \n`V' `V' \n        \n        \n        \n        \n        \n        \n        \n        \n",
    '&': u"  .oo.     \n.88' `8.   \n88.  .8'   \n`88.8P     \n d888[.8'  \n88' `88.   \n`bodP'`88. \n           \n           \n           \n",
    '*': u'   o    \n`8.8.8\' \n.8\'8`8. \n   "    \n        \n        \n        \n        \n        \n        \n',
    '.': u'    \n    \n    \n    \n    \n.o. \nY8P \n    \n    \n    \n',
    '2': u'  .oooo.   \n.dP""Y88b  \n      ]8P\' \n    .d8P\'  \n  .dP\'     \n.oP     .o \n8888888888 \n           \n           \n           \n',
    '6': u'    .ooo   \n  .88\'     \n d88\'      \nd888P"Ybo. \nY88[   ]88 \n`Y88   88P \n `88bod8\'  \n           \n           \n           \n',
    ':': u'    \n    \n    \n    \no8o \n`"\' \no8o \n`"\' \n    \n    \n',
    '>': u'       \nYb     \n `Yb   \n   `Yb \n   .dP \n .dP   \ndP     \n       \n       \n       \n',
    'B': u"oooooooooo.  \n`888'   `Y8b \n 888     888 \n 888oooo888' \n 888    `88b \n 888    .88P \no888bood8P'  \n             \n             \n             \n",
    'F': u'oooooooooooo \n`888\'     `8 \n 888         \n 888oooo8    \n 888    "    \n 888         \no888o        \n             \n             \n             \n',
    'J': u'   oooo \n   `888 \n    888 \n    888 \n    888 \n    888 \n.o. 88P \n`Y888P  \n        \n        \n',
    'N': u"ooooo      ooo \n`888b.     `8' \n 8 `88b.    8  \n 8   `88b.  8  \n 8     `88b.8  \n 8       `888  \no8o        `8  \n               \n               \n               \n",
    'R': u"ooooooooo.   \n`888   `Y88. \n 888   .d88' \n 888ooo88P'  \n 888`88b.    \n 888  `88b.  \no888o  o888o \n             \n             \n             \n",
    'V': u"oooooo     oooo \n `888.     .8'  \n  `888.   .8'   \n   `888. .8'    \n    `888.8'     \n     `888'      \n      `8'       \n                \n                \n                \n",
    'Z': u' oooooooooooo \nd\'""""""d888\' \n      .888P   \n     d888\'    \n   .888P      \n  d888\'    .P \n.8888888888P  \n              \n              \n              \n',
    '^': u' .o"o.  \n"\'   `" \n        \n        \n        \n        \n        \n        \n        \n        \n',
    'b': u' .o8       \n"888       \n 888oooo.  \n d88\' `88b \n 888   888 \n 888   888 \n `Y8bod8P\' \n           \n           \n           \n',
    'f': u' .o88o. \n 888 `" \no888oo  \n 888    \n 888    \n 888    \no888o   \n        \n        \n        \n',
    'j': u'    o8o \n    `"\' \n   oooo \n   `888 \n    888 \n    888 \n    888 \n    888 \n.o. 88P \n`Y888P  \n',
    'n': u'            \n            \nooo. .oo.   \n`888P"Y88b  \n 888   888  \n 888   888  \no888o o888o \n            \n            \n            \n',
    'r': u'         \n         \noooo d8b \n`888""8P \n 888     \n 888     \nd888b    \n         \n         \n         \n',
    'v': u"            \n            \noooo    ooo \n `88.  .8'  \n  `88..8'   \n   `888'    \n    `8'     \n            \n            \n            \n",
    'z': u'           \n           \n  oooooooo \n d\'""7d8P  \n   .d8P\'   \n .d8P\'  .P \nd8888888P  \n           \n           \n           \n',
    '~': u" .oo.  .oo \nP'  `YP'   \n           \n           \n           \n           \n           \n           \n           \n           \n",
    '!': u".o. \n888 \n888 \nY8P \n`8' \n.o. \nY8P \n    \n    \n    \n",
    '%': u'o8o   88  \n`"\'  .8\'  \n    .8\'   \n   .8\'    \n  .8\'     \n .8\'  .o. \n 88   Y8P \n          \n          \n          \n',
    ')': u'o.   \n`8.  \n `8. \n  88 \n  88 \n .8\' \n.8\'  \n"\'   \n     \n     \n',
    '-': u'        \n        \n        \n        \n8888888 \n        \n        \n        \n        \n        \n',
    '1': u'  .o  \no888  \n 888  \n 888  \n 888  \n 888  \no888o \n      \n      \n      \n',
    '5': u'  oooooooo \n dP""""""" \nd88888b.   \n    `Y88b  \n      ]88  \no.   .88P  \n`8bd88P\'   \n           \n           \n           \n',
    '9': u" .ooooo.   \n888' `Y88. \n888    888 \n `Vbood888 \n      888' \n    .88P'  \n  .oP'     \n           \n           \n           \n",
    '=': u'        \n        \n        \n8888888 \n        \n8888888 \n        \n        \n        \n        \n',
    'A': u'      .o.       \n     .888.      \n    .8"888.     \n   .8\' `888.    \n  .88ooo8888.   \n .8\'     `888.  \no88o     o8888o \n                \n                \n                \n',
    'E': u'oooooooooooo \n`888\'     `8 \n 888         \n 888oooo8    \n 888    "    \n 888       o \no888ooooood8 \n             \n             \n             \n',
    'I': u"ooooo \n`888' \n 888  \n 888  \n 888  \n 888  \no888o \n      \n      \n      \n",
    'M': u"ooo        ooooo \n`88.       .888' \n 888b     d'888  \n 8 Y88. .P  888  \n 8  `888'   888  \n 8    Y     888  \no8o        o888o \n                 \n                 \n                 \n",
    'Q': u"  .oooooo.      \n d8P'  `Y8b     \n888      888    \n888      888    \n888      888    \n`88b    d88b    \n `Y8bood8P'Ybd' \n                \n                \n                \n",
    'U': u"ooooo     ooo \n`888'     `8' \n 888       8  \n 888       8  \n 888       8  \n `88.    .8'  \n   `YbodP'    \n              \n              \n              \n",
    'Y': u"oooooo   oooo \n `888.   .8'  \n  `888. .8'   \n   `888.8'    \n    `888'     \n     888      \n    o888o     \n              \n              \n              \n",
    ']': u'oooo \n   8 \n   8 \n   8 \n   8 \n   8 \nooo8 \n     \n     \n     \n',
    'a': u'          \n          \n .oooo.   \n`P  )88b  \n .oP"888  \nd8(  888  \n`Y888""8o \n          \n          \n          \n',
    'e': u"          \n          \n .ooooo.  \nd88' `88b \n888ooo888 \n888    .o \n`Y8bod8P' \n          \n          \n          \n",
    'i': u' o8o  \n `"\'  \noooo  \n`888  \n 888  \n 888  \no888o \n      \n      \n      \n',
    'm': u'                  \n                  \nooo. .oo.  .oo.   \n`888P"Y88bP"Y88b  \n 888   888   888  \n 888   888   888  \no888o o888o o888o \n                  \n                  \n                  \n',
    'q': u'           \n           \n .ooooo oo \nd88\' `888  \n888   888  \n888   888  \n`V8bod888  \n      888. \n      8P\'  \n      "    \n',
    'u': u'            \n            \noooo  oooo  \n`888  `888  \n 888   888  \n 888   888  \n `V88V"V8P\' \n            \n            \n            \n',
    'y': u"            \n            \noooo    ooo \n `88.  .8'  \n  `88..8'   \n   `888'    \n    .8'     \n.o..P'      \n`Y8P'       \n            \n",
    '}': u'`88b   \n `88b  \n  888  \n   88> \n  888  \n .88P  \n.88P   \n       \n       \n       \n'}

rounded_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u'   _   \n _| |_ \n|  ___)\n|___  |\n(_   _|\n  |_|  \n       \n',
    '(': u'  _ \n / )\n| | \n| | \n| | \n \\_)\n    \n',
    ',': u'   \n   \n   \n   \n _ \n( )\n|/ \n',
    '0': u'  _____  \n (_____) \n _  __ _ \n| |/ /| |\n|   /_| |\n \\_____/ \n         \n',
    '4': u' _     _ \n| |   (_)\n| |_____ \n|_____  |\n      | |\n      |_|\n         \n',
    '8': u'  _____  \n (_____) \n  _____  \n / ___ \\ \n( (___) )\n \\_____/ \n         \n',
    '<': u'    \n  _ \n / )\n( ( \n \\_)\n    \n    \n',
    '@': u'  _____  \n / __  \\ \n| | /   )\n| | \\__/ \n| |____  \n \\_____) \n         \n',
    'D': u' ______  \n(______) \n _     _ \n| |   | |\n| |__/ / \n|_____/  \n         \n',
    'H': u' _     _ \n(_)   (_)\n _______ \n|  ___  |\n| |   | |\n|_|   |_|\n         \n',
    'L': u' _       \n(_)      \n _       \n| |      \n| |_____ \n|_______)\n         \n',
    'P': u' ______  \n(_____ \\ \n _____) )\n|  ____/ \n| |      \n|_|      \n         \n',
    'T': u' _______ \n(_______)\n    _    \n   | |   \n   | |   \n   |_|   \n         \n',
    'X': u' _     _ \n(_)   (_)\n   ___   \n  |   |  \n / / \\ \\ \n|_|   |_|\n         \n',
    '\\': u' _     \n| |    \n \\ \\   \n  \\ \\  \n   \\ \\ \n    |_|\n       \n',
    '`': u' _ \n( )\n \\|\n   \n   \n   \n   \n',
    'd': u'     _ \n    | |\n  __| |\n / _  |\n( (_| |\n \\____|\n       \n',
    'h': u' _     \n| |    \n| |__  \n|  _ \\ \n| | | |\n|_| |_|\n       \n',
    'l': u' _  \n| | \n| | \n| | \n| | \n \\_)\n    \n',
    'p': u'       \n       \n ____  \n|  _ \\ \n| |_| |\n|  __/ \n|_|    \n',
    't': u'       \n   _   \n _| |_ \n(_   _)\n  | |_ \n   \\__)\n       \n',
    'x': u'       \n       \n _   _ \n( \\ / )\n ) X ( \n(_/ \\_)\n       \n',
    '|': u' _ \n| |\n|_|\n _ \n| |\n|_|\n   \n',
    '#': u'   _ _   \n _| U |_ \n(_     _)\n _| O |_ \n(_     _)\n  |_n_|  \n         \n',
    "'": u' _ \n( )\n|/ \n   \n   \n   \n   \n',
    '+': u'       \n   _   \n _| |_ \n(_   _)\n  |_|  \n       \n       \n',
    '/': u'     _ \n    | |\n   / / \n  / /  \n / /   \n|_|    \n       \n',
    '3': u' ______  \n(_____ \\ \n _____) )\n(_____ ( \n _____) )\n(______/ \n         \n',
    '7': u' _______ \n(_______)\n      _  \n     / ) \n    / /  \n   (_/   \n         \n',
    ';': u'   \n   \n _ \n(_)\n _ \n( )\n|/ \n',
    '?': u'  ___  \n / _ \\ \n(_( ) )\n   (_/ \n   _   \n  (_)  \n       \n',
    'C': u' _______ \n(_______)\n _       \n| |      \n| |_____ \n \\______)\n         \n',
    'G': u' _______ \n(_______)\n _   ___ \n| | (_  |\n| |___) |\n \\_____/ \n         \n',
    'K': u' _     _ \n(_)   | |\n _____| |\n|  _   _)\n| |  \\ \\ \n|_|   \\_)\n         \n',
    'O': u' _______ \n(_______)\n _     _ \n| |   | |\n| |___| |\n \\_____/ \n         \n',
    'S': u'  ______ \n / _____)\n( (____  \n \\____ \\ \n _____) )\n(______/ \n         \n',
    'W': u' _  _  _ \n(_)(_)(_)\n _  _  _ \n| || || |\n| || || |\n \\_____/ \n         \n',
    '[': u' ___ \n|  _)\n| |  \n| |  \n| |_ \n|___)\n     \n',
    '_': u'         \n         \n         \n         \n _______ \n(_______)\n         \n',
    'c': u'       \n       \n  ____ \n / ___)\n( (___ \n \\____)\n       \n',
    'g': u'       \n       \n  ____ \n / _  |\n( (_| |\n \\___ |\n(_____|\n',
    'k': u' _     \n| |    \n| |  _ \n| |_/ )\n|  _ ( \n|_| \\_)\n       \n',
    'o': u'       \n       \n  ___  \n / _ \\ \n| |_| |\n \\___/ \n       \n',
    's': u'      \n      \n  ___ \n /___)\n|___ |\n(___/ \n      \n',
    'w': u'       \n       \n _ _ _ \n| | | |\n| | | |\n \\___/ \n       \n',
    '{': u'   __ \n  / _)\n | |  \n( (   \n | |_ \n  \\__)\n      \n',
    '"': u' _  _ \n( )( )\n|/  \\|\n      \n      \n      \n      \n',
    '&': u'  ___   \n / _ \\  \n( (_) ) \n ) _ (  \n( (/  \\ \n \\__/\\_)\n        \n',
    '*': u'    _    \n _ | | _ \n( \\| |/ )\n )     ( \n(_/| |\\_)\n   |_|   \n         \n',
    '.': u'   \n   \n   \n   \n _ \n(_)\n   \n',
    '2': u' ______  \n(_____ \\ \n  ____) )\n / ____/ \n| (_____ \n|_______)\n         \n',
    '6': u' _______ \n(_______)\n ______  \n|  ___ \\ \n| |___) )\n|______/ \n         \n',
    ':': u'   \n   \n _ \n(_)\n _ \n(_)\n   \n',
    '>': u'    \n _  \n( \\ \n ) )\n(_/ \n    \n    \n',
    'B': u' ______  \n(____  \\ \n ____)  )\n|  __  ( \n| |__)  )\n|______/ \n         \n',
    'F': u' _______ \n(_______)\n _____   \n|  ___)  \n| |      \n|_|      \n         \n',
    'J': u' _______ \n(_______)\n     _   \n _  | |  \n| |_| |  \n \\___/   \n         \n',
    'N': u' _______ \n(_______)\n _     _ \n| |   | |\n| |   | |\n|_|   |_|\n         \n',
    'R': u' ______  \n(_____ \\ \n _____) )\n|  __  / \n| |  \\ \\ \n|_|   |_|\n         \n',
    'V': u' _     _ \n(_)   (_)\n _     _ \n| |   | |\n \\ \\ / / \n  \\___/  \n         \n',
    'Z': u' _______ \n(_______)\n   __    \n  / /    \n / /____ \n(_______)\n         \n',
    '^': u'  __  \n /  \\ \n(_/\\_)\n      \n      \n      \n      \n',
    'b': u' _     \n| |    \n| |__  \n|  _ \\ \n| |_) )\n|____/ \n       \n',
    'f': u'    ___ \n   / __)\n _| |__ \n(_   __)\n  | |   \n  |_|   \n        \n',
    'j': u'   _ \n  (_)\n   _ \n  | |\n  | |\n _| |\n(__/ \n',
    'n': u'       \n       \n ____  \n|  _ \\ \n| | | |\n|_| |_|\n       \n',
    'r': u'       \n       \n  ____ \n / ___)\n| |    \n|_|    \n       \n',
    'v': u'       \n       \n _   _ \n| | | |\n \\ V / \n  \\_/  \n       \n',
    'z': u'       \n       \n _____ \n(___  )\n / __/ \n(_____)\n       \n',
    '~': u'  __  _ \n /  \\/ )\n(_/\\__/ \n        \n        \n        \n        \n',
    '!': u' _ \n| |\n| |\n|_|\n _ \n|_|\n   \n',
    '%': u' _   _ \n(_) | |\n   / / \n  / /  \n / / _ \n|_| (_)\n       \n',
    ')': u' _  \n( \\ \n | |\n | |\n | |\n(_/ \n    \n',
    '-': u'       \n       \n _____ \n(_____)\n       \n       \n       \n',
    '1': u' ___   \n(___)  \n   _   \n  | |  \n _| |_ \n(_____)\n       \n',
    '5': u' _______ \n(_______)\n ______  \n(_____ \\ \n _____) )\n(______/ \n         \n',
    '9': u' _______ \n(_______)\n _______ \n(_____  |\n      | |\n      |_|\n         \n',
    '=': u'       \n _____ \n(_____)\n _____ \n(_____)\n       \n       \n',
    'A': u' _______ \n(_______)\n _______ \n|  ___  |\n| |   | |\n|_|   |_|\n         \n',
    'E': u' _______ \n(_______)\n _____   \n|  ___)  \n| |_____ \n|_______)\n         \n',
    'I': u' _ \n| |\n| |\n| |\n| |\n|_|\n   \n',
    'M': u' _______ \n(_______)\n _  _  _ \n| ||_|| |\n| |   | |\n|_|   |_|\n         \n',
    'Q': u' _______ \n(_______)\n _    _  \n| |  | | \n| |__| | \n \\______)\n         \n',
    'U': u' _     _ \n(_)   (_)\n _     _ \n| |   | |\n| |___| |\n \\_____/ \n         \n',
    'Y': u' _     _ \n| |   | |\n| |___| |\n|_____  |\n _____| |\n(_______|\n         \n',
    ']': u' ___ \n(_  |\n  | |\n  | |\n _| |\n(___|\n     \n',
    'a': u'       \n       \n _____ \n(____ |\n/ ___ |\n\\_____|\n       \n',
    'e': u'       \n       \n _____ \n| ___ |\n| ____|\n|_____)\n       \n',
    'i': u' _ \n(_)\n _ \n| |\n| |\n|_|\n   \n',
    'm': u'       \n       \n ____  \n|    \\ \n| | | |\n|_|_|_|\n       \n',
    'q': u'       \n       \n  ____ \n / _  |\n| |_| |\n \\__  |\n    |_|\n',
    'u': u'       \n       \n _   _ \n| | | |\n| |_| |\n|____/ \n       \n',
    'y': u'       \n       \n _   _ \n| | | |\n| |_| |\n \\__  |\n(____/ \n',
    '}': u' __   \n(_ \\  \n  | | \n   ) )\n _| | \n(__/  \n      \n'}

rowancap_dic = {
    '!': u'',
    ' ': u'    \n    \n    \n    \n    \n    \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'      \n      \n      \n  amr \n dMP  \n      \n',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'    .aMMMb \n   dMP"dMP \n  dMMMMMP  \n dMP dMP   \ndMP dMP    \n           \n',
    '`': u'',
    'c': u'   .aMMMb \n  dMP"VMP \n dMP      \ndMP.aMP   \nVMMMP"    \n          \n',
    'b': u'    dMMMMb \n   dMP"dMP \n  dMMMMK"  \n dMP.aMF   \ndMMMMP"    \n           \n',
    'e': u'    dMMMMMP \n   dMP      \n  dMMMP     \n dMP        \ndMMMMMP     \n            \n',
    'd': u'    dMMMMb \n   dMP VMP \n  dMP dMP  \n dMP.aMP   \ndMMMMP"    \n           \n',
    'g': u'   .aMMMMP \n  dMP"     \n dMP MMP"  \ndMP.dMP    \nVMMMP"     \n           \n',
    'f': u'    dMMMMMP \n   dMP      \n  dMMMP     \n dMP        \ndMP         \n            \n',
    'i': u'    dMP \n   amr  \n  dMP   \n dMP    \ndMP     \n        \n',
    'h': u'    dMP dMP \n   dMP dMP  \n  dMMMMMP   \n dMP dMP    \ndMP dMP     \n            \n',
    'k': u'    dMP dMP \n   dMP.dMP  \n  dMMMMK"   \n dMP"AMF    \ndMP dMP     \n            \n',
    'j': u'   dMMMMMP \n      dMP  \n     dMP   \ndK .dMP    \nVMMMP"     \n           \n',
    'm': u'    dMMMMMMMMb \n   dMP"dMP"dMP \n  dMP dMP dMP  \n dMP dMP dMP   \ndMP dMP dMP    \n               \n',
    'l': u'    dMP \n   dMP  \n  dMP   \n dMP    \ndMMMMMP \n        \n',
    'o': u'   .aMMMb \n  dMP"dMP \n dMP dMP  \ndMP.aMP   \nVMMMP"    \n          \n',
    'n': u'    dMMMMb \n   dMP dMP \n  dMP dMP  \n dMP dMP   \ndMP dMP    \n           \n',
    'q': u'   .aMMMb \n  dMP"dMP \n dMP.dMP  \ndMP.MMP   \nVMMP"MP   \n          \n',
    'p': u'    dMMMMb \n   dMP.dMP \n  dMMMMP"  \n dMP       \ndMP        \n           \n',
    's': u'   .dMMMb \n  dMP" VP \n  VMMMb   \ndP .dMP   \nVMMMP"    \n          \n',
    'r': u'    dMMMMb \n   dMP.dMP \n  dMMMMK"  \n dMP"AMF   \ndMP dMP    \n           \n',
    'u': u'   dMP dMP \n  dMP dMP  \n dMP dMP   \ndMP.aMP    \nVMMMP"     \n           \n',
    't': u' dMMMMMMP \n   dMP    \n  dMP     \n dMP      \ndMP       \n          \n',
    'w': u'   dMP dMP dMP \n  dMP dMP dMP  \n dMP dMP dMP   \ndMP.dMP.dMP    \nVMMMPVMMP"     \n               \n',
    'v': u'  dMP dMP \n dMP dMP  \ndMP dMP   \nYMvAP"    \n VP"      \n          \n',
    'y': u'   dMP dMP \n  dMP.dMP  \n  VMMMMP   \ndA .dMP    \nVMMMP"     \n           \n',
    'x': u'    dMP dMP \n   dMK.dMP  \n  .dMMMK"   \n dMP"AMF    \ndMP dMP     \n            \n',
    '{': u'',
    'z': u'    dMMMMMP \n     .dMP"  \n   .dMP"    \n .dMP"      \ndMMMMMP     \n            \n',
    '}': u'',
    '|': u'',
    '~': u''}

script_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n |_|_\n(|_| \n_|_|)\n | | \n     \n     \n',
    '(': u'  \n /\n| \n| \n| \n \\\n  \n',
    ',': u' \n \n \n \no\n/\n \n',
    '0': u'  __  \n /  \\ \n|    |\n|    |\n \\__/ \n      \n      \n',
    '4': u'     \n|  | \n|__|_\n   | \n   | \n     \n     \n',
    '8': u' __ \n/  \\\n\\__/\n/  \\\n\\__/\n    \n    \n',
    '<': u'  \n /\n/ \n\\ \n \\\n  \n  \n',
    '@': u'        \n  ____  \n / __,\\ \n| /  | |\n| \\_/|/ \n \\____/ \n        \n',
    'D': u'  ____  \n (|   \\ \n  |    |\n _|    |\n(/\\___/ \n        \n        \n',
    'H': u' ,     \n/|   | \n |___| \n |   |\\\n |   |/\n       \n       \n',
    'L': u'   _   \n\\_|_)  \n  |    \n _|    \n(/\\___/\n       \n       \n',
    'P': u' , __ \n/|/  \\\n |___/\n |    \n |    \n      \n      \n',
    'T': u' ______\n(_) |  \n    |  \n  _ |  \n (_/   \n       \n       \n',
    'X': u' _      \n(_\\  /  \n   \\/   \n   /\\   \n _/  \\_/\n        \n        \n',
    '\\': u'    \n\\   \n \\  \n  \\ \n   \\\n    \n    \n',
    '`': u'o\n\\\n \n \n \n \n \n',
    'd': u'      \n   |  \n __|  \n/  |  \n\\_/|_/\n      \n      \n',
    'h': u' _     \n| |    \n| |    \n|/ \\   \n|   |_/\n       \n       \n',
    'l': u' _  \n| | \n| | \n|/  \n|__/\n    \n    \n',
    'p': u'      \n      \n   _  \n |/ \\_\n |__/ \n/|    \n\\|    \n',
    't': u'    \n    \n_|_ \n |  \n |_/\n    \n    \n',
    'x': u'     \n     \n     \n/\\/  \n /\\_/\n     \n     \n',
    '|': u'|\n|\n|\n|\n|\n|\n|\n',
    '#': u'        \n  |  |  \n--+--+--\n--+--+--\n  |  |  \n        \n        \n',
    "'": u'o\n/\n \n \n \n \n \n',
    '+': u'     \n     \n  |  \n--+--\n  |  \n     \n     \n',
    '/': u'    \n   /\n  / \n /  \n/   \n    \n    \n',
    '3': u' ___ \n/   \\\n  __/\n    \\\n\\___/\n     \n     \n',
    '7': u'_____\n    /\n   / \n  /  \n /   \n     \n     \n',
    ';': u' \no\n \n \no\n/\n \n',
    '?': u' __ \n/  \\\n  _/\n |  \n o  \n    \n    \n',
    'C': u'  ___ \n / (_)\n|     \n|     \n \\___/\n      \n      \n',
    'G': u'      \n  () |\n  /\\/|\n /   |\n/(__/ \n      \n      \n',
    'K': u' ,     \n/|   / \n |__/  \n | \\   \n |  \\_/\n       \n       \n',
    'O': u'  __  \n /\\_\\/\n|    |\n|    |\n \\__/ \n      \n      \n',
    'S': u'     \n  () \n  /\\ \n /  \\\n/(__/\n     \n     \n',
    'W': u' _           \n(_|   |   |_/\n  |   |   |  \n  |   |   |  \n   \\_/ \\_/   \n             \n             \n',
    '[': u' _\n| \n| \n| \n| \n|_\n  \n',
    '_': u'     \n     \n     \n     \n     \n     \n_____\n',
    'c': u'     \n     \n __  \n/    \n\\___/\n     \n     \n',
    'g': u'     \n     \n __, \n/  | \n\\_/|/\n  /| \n  \\| \n',
    'k': u' _   \n| |  \n| |  \n|/_) \n| \\_/\n     \n     \n',
    'o': u'     \n     \n __  \n/  \\_\n\\__/ \n     \n     \n',
    's': u'    \n    \n ,  \n/ \\_\n \\/ \n    \n    \n',
    'w': u'        \n        \n        \n|  |  |_\n \\/ \\/  \n        \n        \n',
    '{': u'   \n  /\n | \n<  \n | \n  \\\n   \n',
    '"': u'oo\n||\n  \n  \n  \n  \n  \n',
    '&': u'     \n ()  \n /\\  \n/  \\/\n\\__/\\\n     \n     \n',
    '*': u'     \n     \n \\|/ \n--*--\n /|\\ \n     \n     \n',
    '.': u' \n \n \n \no\n \n \n',
    '2': u' __ \n/  )\n  / \n /  \n/___\n    \n    \n',
    '6': u'  __ \n /   \n| __ \n|/  \\\n \\__/\n     \n     \n',
    ':': u' \no\n \n \no\n \n \n',
    '>': u'  \n\\ \n \\\n /\n/ \n  \n  \n',
    'B': u' , __ \n/|/  \\\n | __/\n |   \\\n |(__/\n      \n      \n',
    'F': u' ______\n(_) |  \n   _|_ \n  / | |\n (_/   \n       \n       \n',
    'J': u'     \n /\\  \n|  | \n|  | \n \\_|/\n  /| \n  \\| \n',
    'N': u' , _    \n/|/ \\   \n |   |  \n |   |  \n |   |_/\n        \n        \n',
    'R': u' , __  \n/|/  \\ \n |___/ \n | \\   \n |  \\_/\n       \n       \n',
    'V': u' _       \n(_|   |_/\n  |   |  \n  |   |  \n   \\_/   \n         \n         \n',
    'Z': u' __  \n(_ \\ \n   / \n  /  \n /__/\n  /| \n  \\| \n',
    '^': u'/\\\n  \n  \n  \n  \n  \n  \n',
    'b': u' _   \n| |  \n| |  \n|/ \\_\n \\_/ \n     \n     \n',
    'f': u' _  \n| | \n| | \n|/  \n|__/\n|\\  \n|/  \n',
    'j': u'   \n o \n   \n | \n |/\n/| \n\\| \n',
    'n': u'        \n        \n _  _   \n/ |/ |  \n  |  |_/\n        \n        \n',
    'r': u'      \n      \n ,_   \n/  |  \n   |_/\n      \n      \n',
    'v': u'     \n     \n     \n|  |_\n \\/  \n     \n     \n',
    'z': u'     \n     \n __  \n/ / _\n /_/ \n  /| \n  \\| \n',
    '~': u'/\\/\n   \n   \n   \n   \n   \n   \n',
    '!': u' \n|\n|\n|\no\n \n \n',
    '%': u'    \n() /\n  / \n /  \n/ ()\n    \n    \n',
    ')': u'  \n\\ \n |\n |\n |\n/ \n  \n',
    '-': u'     \n     \n     \n-----\n     \n     \n     \n',
    '1': u' ,\n/|\n |\n |\n |\n  \n  \n',
    '5': u' ____\n|    \n|___ \n    \\\n\\___/\n     \n     \n',
    '9': u' __ \n/  |\n\\_/|\n   |\n   |\n    \n    \n',
    '=': u'     \n     \n-----\n-----\n     \n     \n     \n',
    'A': u'  ___,  \n /   |  \n|    |  \n|    |  \n \\__/\\_/\n        \n        \n',
    'E': u' ___ \n/ (_)\n\\__  \n/    \n\\___/\n     \n     \n',
    'I': u'   _ \n  | |\n  | |\n_ |/ \n\\_/\\/\n     \n     \n',
    'M': u' ,__ __   \n/|  |  |  \n |  |  |  \n |  |  |  \n |  |  |_/\n          \n          \n',
    'Q': u'  __    \n /  \\   \n| __ |  \n|/  \\|  \n \\__/\\_/\n        \n        \n',
    'U': u' _        \n(_|    |  \n  |    |  \n  |    |  \n   \\__/\\_/\n          \n          \n',
    'Y': u' _      \n(_|   | \n  |   | \n  |   | \n   \\_/|/\n     /| \n     \\| \n',
    ']': u'_ \n |\n |\n |\n |\n_|\n  \n',
    'a': u'      \n      \n __,  \n/  |  \n\\_/|_/\n      \n      \n',
    'e': u'    \n    \n _  \n|/  \n|__/\n    \n    \n',
    'i': u'   \no  \n   \n|  \n|_/\n   \n   \n',
    'm': u'           \n           \n _  _  _   \n/ |/ |/ |  \n  |  |  |_/\n           \n           \n',
    'q': u'      \n      \n __,  \n/  |  \n\\_/|_/\n   |\\ \n   |/ \n',
    'u': u'       \n       \n       \n|   |  \n \\_/|_/\n       \n       \n',
    'y': u'      \n      \n      \n|   | \n \\_/|/\n   /| \n   \\| \n',
    '}': u'   \n\\  \n | \n  >\n | \n/  \n   \n'}

serifcap_dic = {
    '!': u' _ \n/ \\\n\\_/\n(_)\n',
    ' ': u'  \n  \n  \n  \n',
    '#': u'',
    '"': u' _ _ \n(_(_)\n     \n     \n',
    '%': u' _  _  \n(_)/ ) \n  / /_ \n (_/(_)\n',
    '$': u'',
    "'": u' _ \n/_)\n   \n   \n',
    '&': u' ___  \n( __) \n/ _) )\n\\___/ \n',
    ')': u' _  \n( \\ \n ) )\n(_/ \n',
    '(': u'  _ \n / )\n( ( \n \\_)\n',
    '+': u'   _   \n _( )_ \n(_   _)\n  (_)  \n',
    '*': u'',
    '-': u'     \n ___ \n(___)\n     \n',
    ',': u'   \n   \n _ \n/_)\n',
    '/': u'   _ \n  / )\n / / \n(_/  \n',
    '.': u'   \n   \n _ \n(_)\n',
    '1': u' __ \n(  )\n )( \n(__)\n',
    '0': u'  __  \n /  \\ \n( () )\n \\__/ \n',
    '3': u' ___ \n(__ )\n (_ \\\n(___/\n',
    '2': u' ___ \n(__ \\\n/ __/\n\\___)\n',
    '5': u' ___ \n/ __)\n\\__ \\\n(___/\n',
    '4': u'  __  \n / ,) \n(_  _)\n  (_) \n',
    '7': u' ___ \n(__ )\n / / \n(_/  \n',
    '6': u'  _  \n / ) \n/ , \\\n\\___/\n',
    '9': u' ___ \n/ , \\\n\\   /\n (_/ \n',
    '8': u' ___ \n( , )\n/ , \\\n\\___/\n',
    ';': u' _ \n(_)\n _ \n/_)\n',
    ':': u' _ \n(_)\n _ \n(_)\n',
    '=': u' ___ \n(___)\n ___ \n(___)\n',
    '<': u'  _ \n / )\n( ( \n \\_)\n',
    '?': u' ___ \n(__ )\n (_/ \n (_) \n',
    '>': u' _  \n( \\ \n ) )\n(_/ \n',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u' _   \n( \\  \n \\ \\ \n  \\_)\n',
    '_': u'     \n     \n ___ \n(___)\n',
    '^': u'  __  \n /  \\ \n(_/\\_)\n      \n',
    'a': u'  __  \n (  ) \n /__\\ \n(_)(_)\n',
    '`': u' _ \n(_\\\n   \n   \n',
    'c': u'  __ \n / _)\n( (_ \n \\__)\n',
    'b': u' ___ \n(  ,)\n ) ,\\\n(___/\n',
    'e': u' ___ \n(  _)\n ) _)\n(___)\n',
    'd': u' ___  \n(   \\ \n ) ) )\n(___/ \n',
    'g': u'  __ \n / _)\n( (/\\\n \\__/\n',
    'f': u' ___ \n(  _)\n ) _)\n(_)  \n',
    'i': u' __ \n(  )\n )( \n(__)\n',
    'h': u' _  _ \n( )( )\n )__( \n(_)(_)\n',
    'k': u' _ _  \n( ) ) \n )  \\ \n(_)\\_)\n',
    'j': u'   __ \n  (  )\n __)( \n(___/ \n',
    'm': u' __  __ \n(  \\/  )\n )    ( \n(_/\\/\\_)\n',
    'l': u' __   \n(  )  \n )(__ \n(____)\n',
    'o': u'  __  \n /  \\ \n( () )\n \\__/ \n',
    'n': u' _  _ \n( \\( )\n )  ( \n(_)\\_)\n',
    'q': u'  __  \n /  \\ \n( () )\n \\___\\\n',
    'p': u' ___ \n(  ,\\\n ) _/\n(_)  \n',
    's': u' ___ \n/ __)\n\\__ \\\n(___/\n',
    'r': u' ___  \n(  ,) \n )  \\ \n(_)\\_)\n',
    'u': u' _  _ \n( )( )\n )()( \n \\__/ \n',
    't': u' ____ \n(_  _)\n  )(  \n (__) \n',
    'w': u' _    _ \n( \\/\\/ )\n \\    / \n  \\/\\/  \n',
    'v': u' _  _ \n( )( )\n \\\\// \n (__) \n',
    'y': u' _  _ \n( \\/ )\n \\  / \n(__/  \n',
    'x': u' _  _ \n( \\/ )\n )  ( \n(_/\\_)\n',
    '{': u'',
    'z': u' ___ \n(_  )\n / / \n(___)\n',
    '}': u'',
    '|': u'',
    '~': u''}

shadow_dic = {
    ' ': u'  \n  \n  \n  \n  \n',
    '$': u'   |  \n  __) \n\\__ \\ \n(   / \n  _|  \n',
    '(': u'  / \n |  \n |  \n |  \n\\_\\ \n',
    ',': u'   \n   \n   \n ) \n/  \n',
    '0': u'  _ \\  \n |   | \n |   | \n\\___/  \n       \n',
    '4': u' |  |   \n |  |   \n___ __| \n   _|   \n        \n',
    '8': u'  _ )  \n  _ \\  \n (   | \n\\___/  \n       \n',
    '<': u'   / \n  /  \n\\ \\  \n \\_\\ \n     \n',
    '@': u'   __ \\  \n  / _` | \n | (   | \n\\ \\__,_| \n \\____/  \n',
    'D': u' __ \\  \n |   | \n |   | \n____/  \n       \n',
    'H': u' |   | \n |   | \n ___ | \n_|  _| \n       \n',
    'L': u' |     \n |     \n |     \n_____| \n       \n',
    'P': u'  _ \\  \n |   | \n ___/  \n_|     \n       \n',
    'T': u'__ __| \n   |   \n   |   \n  _|   \n       \n',
    'X': u'\\ \\  / \n \\  /  \n    \\  \n _/\\_\\ \n       \n',
    '\\': u'\\ \\    \n \\ \\   \n  \\ \\  \n   \\_\\ \n       \n',
    '`': u' ) \n\\| \n   \n   \n   \n',
    'd': u'     | \n  _` | \n (   | \n\\__,_| \n       \n',
    'h': u' |     \n __ \\  \n | | | \n_| |_| \n       \n',
    'l': u' | \n | \n | \n_| \n   \n',
    'p': u'       \n __ \\  \n |   | \n .__/  \n_|     \n',
    't': u' |   \n __| \n |   \n\\__| \n     \n',
    'x': u'       \n\\ \\  / \n `  <  \n _/\\_\\ \n       \n',
    '|': u' | \n | \n | \n | \n_| \n',
    '#': u'   |  |   \n_  |_ |_| \n_  |_ |_| \n  _| _|   \n          \n',
    "'": u' ) \n/  \n   \n   \n   \n',
    '+': u'       \n   |   \n_   _| \n  _|   \n       \n',
    '/': u'    / \n   /  \n  /   \n_/    \n      \n',
    '3': u'___ /  \n  _ \\  \n   ) | \n____/  \n       \n',
    '7': u'___  | \n    /  \n   /   \n _/    \n       \n',
    ';': u'   \n_) \n   \n ) \n/  \n',
    '?': u'__ \\ \n   / \n _|  \n _)  \n     \n',
    'C': u'  ___| \n |     \n |     \n\\____| \n       \n',
    'G': u'  ___| \n |     \n |   | \n\\____| \n       \n',
    'K': u" |  / \n ' /  \n . \\  \n_|\\_\\ \n      \n",
    'O': u'  _ \\  \n |   | \n |   | \n\\___/  \n       \n',
    'S': u'  ___|  \n\\___ \\  \n      | \n_____/  \n        \n',
    'W': u'\\ \\        / \n \\ \\  \\   /  \n  \\ \\  \\ /   \n   \\_/\\_/    \n             \n',
    '[': u' _| \n |  \n |  \n |  \n__| \n',
    '_': u'       \n       \n       \n       \n_____| \n',
    'c': u'      \n  __| \n (    \n\\___| \n      \n',
    'g': u'       \n  _` | \n (   | \n\\__, | \n|___/  \n',
    'k': u' |    \n |  / \n   <  \n_|\\_\\ \n      \n',
    'o': u'       \n  _ \\  \n (   | \n\\___/  \n       \n',
    's': u'      \n  __| \n\\__ \\ \n____/ \n      \n',
    'w': u'           \n\\ \\  \\   / \n \\ \\  \\ /  \n  \\_/\\_/   \n           \n',
    '{': u'    / \n   |  \n< <   \n   |  \n  \\_\\ \n',
    '"': u' | ) \nV V  \n     \n     \n     \n',
    '&': u'  _ )   \n  _ \\ \\ \n ( `  < \n\\___/\\/ \n        \n',
    '*': u'   \\   \n\\    / \n _  _\\ \n  \\/   \n       \n',
    '.': u'   \n   \n   \n_) \n   \n',
    '2': u'___ \\  \n   ) | \n  __/  \n_____| \n       \n',
    '6': u'  /    \n  _ \\  \n (   | \n\\___/  \n       \n',
    ':': u'   \n_) \n   \n_) \n   \n',
    '>': u'\\ \\  \n \\ \\ \n   / \n _/  \n     \n',
    'B': u' __ )  \n __ \\  \n |   | \n____/  \n       \n',
    'F': u' ____| \n |     \n __|   \n_|     \n       \n',
    'J': u'     | \n     | \n \\   | \n\\___/  \n       \n',
    'N': u'  \\  | \n   \\ | \n |\\  | \n_| \\_| \n       \n',
    'R': u'  _ \\  \n |   | \n __ <  \n_| \\_\\ \n       \n',
    'V': u'\\ \\     / \n \\ \\   /  \n  \\ \\ /   \n   \\_/    \n          \n',
    'Z': u'__  / \n   /  \n  /   \n____| \n      \n',
    '^': u'/\\\\ \n    \n    \n    \n    \n',
    'b': u' |     \n __ \\  \n |   | \n_.__/  \n       \n',
    'f': u'  _| \n |   \n __| \n_|   \n     \n',
    'j': u'   _) \n    | \n    | \n    | \n___/  \n',
    'n': u'       \n __ \\  \n |   | \n_|  _| \n       \n',
    'r': u'      \n  __| \n |    \n_|    \n      \n',
    'v': u'        \n\\ \\   / \n \\ \\ /  \n  \\_/   \n        \n',
    'z': u'     \n_  / \n  /  \n___| \n     \n',
    '~': u'/ _/ \n     \n     \n     \n     \n',
    '!': u' | \n | \n_| \n_) \n   \n',
    '%': u'_)  / \n   /  \n  /   \n_/ _) \n      \n',
    ')': u'\\ \\  \n   | \n   | \n   | \n _/  \n',
    '-': u'       \n       \n_____| \n       \n       \n',
    '1': u'_ | \n  | \n  | \n _| \n    \n',
    '5': u' ___|  \n __ \\  \n   ) | \n____/  \n       \n',
    '9': u'  _ \\  \n (   | \n\\__  | \n  __/  \n       \n',
    '=': u'       \n_____| \n_____| \n       \n       \n',
    'A': u'    \\    \n   _ \\   \n  ___ \\  \n_/    _\\ \n         \n',
    'E': u' ____| \n __|   \n |     \n_____| \n       \n',
    'I': u'_ _| \n  |  \n  |  \n___| \n     \n',
    'M': u'  \\  | \n |\\/ | \n |   | \n_|  _| \n       \n',
    'Q': u'  _ \\  \n |   | \n |   | \n\\__\\_\\ \n       \n',
    'U': u' |   | \n |   | \n |   | \n\\___/  \n       \n',
    'Y': u'\\ \\   / \n \\   /  \n    |   \n   _|   \n        \n',
    ']': u'_ | \n  | \n  | \n  | \n__| \n',
    'a': u'       \n  _` | \n (   | \n\\__,_| \n       \n',
    'e': u'      \n  _ \\ \n  __/ \n\\___| \n      \n',
    'i': u'_) \n | \n | \n_| \n   \n',
    'm': u'           \n __ `__ \\  \n |   |   | \n_|  _|  _| \n           \n',
    'q': u'       \n  _` | \n (   | \n\\__, | \n    _| \n',
    'u': u'       \n |   | \n |   | \n\\__,_| \n       \n',
    'y': u'       \n |   | \n |   | \n\\__, | \n____/  \n',
    '}': u'\\ \\   \n   |  \n  ` > \n   |  \n _/   \n'}

slant_dic = {
    ' ': u'       \n       \n       \n       \n       \n       \n',
    '$': u'     __\n   _/ /\n  / __/\n (_  ) \n/  _/  \n/_/    \n',
    '(': u'     __\n   _/_/\n  / /  \n / /   \n/ /    \n|_|    \n',
    ',': u'   \n   \n   \n _ \n( )\n|/ \n',
    '0': u'   ____ \n  / __ \\\n / / / /\n/ /_/ / \n\\____/  \n        \n',
    '4': u'   __ __\n  / // /\n / // /_\n/__  __/\n  /_/   \n        \n',
    '8': u'   ____ \n  ( __ )\n / __  |\n/ /_/ / \n\\____/  \n        \n',
    '<': u'  __\n / /\n/ / \n\\ \\ \n \\_\\\n    \n',
    '@': u'   ______ \n  / ____ \\\n / / __ `/\n/ / /_/ / \n\\ \\__,_/  \n \\____/   \n',
    'D': u'    ____ \n   / __ \\\n  / / / /\n / /_/ / \n/_____/  \n         \n',
    'H': u'    __  __\n   / / / /\n  / /_/ / \n / __  /  \n/_/ /_/   \n          \n',
    'L': u'    __ \n   / / \n  / /  \n / /___\n/_____/\n       \n',
    'P': u'    ____ \n   / __ \\\n  / /_/ /\n / ____/ \n/_/      \n         \n',
    'T': u'  ______\n /_  __/\n  / /   \n / /    \n/_/     \n        \n',
    'X': u'   _  __\n  | |/ /\n  |   / \n /   |  \n/_/|_|  \n        \n',
    '\\': u'__    \n\\ \\   \n \\ \\  \n  \\ \\ \n   \\_\\\n      \n',
    '`': u'  _ \n ( )\n  V \n    \n    \n    \n',
    'd': u'       __\n  ____/ /\n / __  / \n/ /_/ /  \n\\__,_/   \n         \n',
    'h': u'    __  \n   / /_ \n  / __ \\\n / / / /\n/_/ /_/ \n        \n',
    'l': u'    __\n   / /\n  / / \n / /  \n/_/   \n      \n',
    'p': u'         \n    ____ \n   / __ \\\n  / /_/ /\n / .___/ \n/_/      \n',
    't': u'   __ \n  / /_\n / __/\n/ /_  \n\\__/  \n      \n',
    'x': u'        \n   _  __\n  | |/_/\n _>  <  \n/_/|_|  \n        \n',
    '|': u'     __\n    / /\n   / / \n  / /  \n / /   \n/_/    \n',
    '#': u'     __ __ \n  __/ // /_\n /_  _  __/\n/_  _  __/ \n /_//_/    \n           \n',
    "'": u'  _ \n ( )\n |/ \n    \n    \n    \n',
    '+': u'       \n    __ \n __/ /_\n/_  __/\n /_/   \n       \n',
    '/': u'       __\n     _/_/\n   _/_/  \n _/_/    \n/_/      \n         \n',
    '3': u'   _____\n  |__  /\n   /_ < \n ___/ / \n/____/  \n        \n',
    '7': u' _____\n/__  /\n  / / \n / /  \n/_/   \n      \n',
    ';': u'     \n   _ \n  (_)\n _   \n( )  \n|/   \n',
    '?': u'  ___ \n /__ \\\n  / _/\n /_/  \n(_)   \n      \n',
    'C': u'   ______\n  / ____/\n / /     \n/ /___   \n\\____/   \n         \n',
    'G': u'   ______\n  / ____/\n / / __  \n/ /_/ /  \n\\____/   \n         \n',
    'K': u'    __ __\n   / //_/\n  / ,<   \n / /| |  \n/_/ |_|  \n         \n',
    'O': u'   ____ \n  / __ \\\n / / / /\n/ /_/ / \n\\____/  \n        \n',
    'S': u'   _____\n  / ___/\n  \\__ \\ \n ___/ / \n/____/  \n        \n',
    'W': u' _       __\n| |     / /\n| | /| / / \n| |/ |/ /  \n|__/|__/   \n           \n',
    '[': u'     ___\n    / _/\n   / /  \n  / /   \n / /    \n/__/    \n',
    '_': u'       \n       \n       \n       \n ______\n/_____/\n',
    'c': u'       \n  _____\n / ___/\n/ /__  \n\\___/  \n       \n',
    'g': u'         \n   ____ _\n  / __ `/\n / /_/ / \n \\__, /  \n/____/   \n',
    'k': u'    __  \n   / /__\n  / //_/\n / ,<   \n/_/|_|  \n        \n',
    'o': u'       \n  ____ \n / __ \\\n/ /_/ /\n\\____/ \n       \n',
    's': u'        \n   _____\n  / ___/\n (__  ) \n/____/  \n        \n',
    'w': u'          \n _      __\n| | /| / /\n| |/ |/ / \n|__/|__/  \n          \n',
    '{': u'     __\n   _/_/\n _/_/  \n< <    \n/ /    \n\\_\\    \n',
    '"': u' _ _ \n( | )\n|/|/ \n     \n     \n     \n',
    '&': u'   ___   \n  ( _ )  \n / __ \\/|\n/ /_/  < \n\\____/\\/ \n         \n',
    '*': u'       \n  __/|_\n |    /\n/_ __| \n |/    \n       \n',
    '.': u'   \n   \n   \n _ \n(_)\n   \n',
    '2': u'   ___ \n  |__ \\\n  __/ /\n / __/ \n/____/ \n       \n',
    '6': u'   _____\n  / ___/\n / __ \\ \n/ /_/ / \n\\____/  \n        \n',
    ':': u'     \n   _ \n  (_)\n _   \n(_)  \n     \n',
    '>': u'__  \n\\ \\ \n \\ \\\n / /\n/_/ \n    \n',
    'B': u'    ____ \n   / __ )\n  / __  |\n / /_/ / \n/_____/  \n         \n',
    'F': u'    ______\n   / ____/\n  / /_    \n / __/    \n/_/       \n          \n',
    'J': u'       __\n      / /\n __  / / \n/ /_/ /  \n\\____/   \n         \n',
    'N': u'    _   __\n   / | / /\n  /  |/ / \n / /|  /  \n/_/ |_/   \n          \n',
    'R': u'    ____ \n   / __ \\\n  / /_/ /\n / _, _/ \n/_/ |_|  \n         \n',
    'V': u' _    __\n| |  / /\n| | / / \n| |/ /  \n|___/   \n        \n',
    'Z': u' _____\n/__  /\n  / / \n / /__\n/____/\n      \n',
    '^': u'  //|\n |/||\n     \n     \n     \n     \n',
    'b': u'    __  \n   / /_ \n  / __ \\\n / /_/ /\n/_.___/ \n        \n',
    'f': u'    ____\n   / __/\n  / /_  \n / __/  \n/_/     \n        \n',
    'j': u'       _ \n      (_)\n     / / \n    / /  \n __/ /   \n/___/    \n',
    'n': u'        \n   ____ \n  / __ \\\n / / / /\n/_/ /_/ \n        \n',
    'r': u'        \n   _____\n  / ___/\n / /    \n/_/     \n        \n',
    'v': u'       \n _   __\n| | / /\n| |/ / \n|___/  \n       \n',
    'z': u'     \n ____\n/_  /\n / /_\n/___/\n     \n',
    '~': u'  /\\//\n //\\/ \n      \n      \n      \n      \n',
    '!': u'    __\n   / /\n  / / \n /_/  \n(_)   \n      \n',
    '%': u'   _   __\n  (_)_/_/\n   _/_/  \n _/_/_   \n/_/ (_)  \n         \n',
    ')': u'     _ \n    | |\n    / /\n   / / \n _/_/  \n/_/    \n',
    '-': u'       \n       \n ______\n/_____/\n       \n       \n',
    '1': u'   ___\n  <  /\n  / / \n / /  \n/_/   \n      \n',
    '5': u'    ______\n   / ____/\n  /___ \\  \n ____/ /  \n/_____/   \n          \n',
    '9': u'   ____ \n  / __ \\\n / /_/ /\n \\__, / \n/____/  \n        \n',
    '=': u'       \n  _____\n /____/\n/____/ \n       \n       \n',
    'A': u'    ___ \n   /   |\n  / /| |\n / ___ |\n/_/  |_|\n        \n',
    'E': u'    ______\n   / ____/\n  / __/   \n / /___   \n/_____/   \n          \n',
    'I': u'    ____\n   /  _/\n   / /  \n _/ /   \n/___/   \n        \n',
    'M': u'    __  ___\n   /  |/  /\n  / /|_/ / \n / /  / /  \n/_/  /_/   \n           \n',
    'Q': u'   ____ \n  / __ \\\n / / / /\n/ /_/ / \n\\___\\_\\ \n        \n',
    'U': u'   __  __\n  / / / /\n / / / / \n/ /_/ /  \n\\____/   \n         \n',
    'Y': u'__  __\n\\ \\/ /\n \\  / \n / /  \n/_/   \n      \n',
    ']': u'     ___\n    /  /\n    / / \n   / /  \n _/ /   \n/__/    \n',
    'a': u'        \n  ____ _\n / __ `/\n/ /_/ / \n\\__,_/  \n        \n',
    'e': u'      \n  ___ \n / _ \\\n/  __/\n\\___/ \n      \n',
    'i': u'    _ \n   (_)\n  / / \n / /  \n/_/   \n      \n',
    'm': u'            \n   ____ ___ \n  / __ `__ \\\n / / / / / /\n/_/ /_/ /_/ \n            \n',
    'q': u'        \n  ____ _\n / __ `/\n/ /_/ / \n\\__, /  \n  /_/   \n',
    'u': u'        \n  __  __\n / / / /\n/ /_/ / \n\\__,_/  \n        \n',
    'y': u'         \n   __  __\n  / / / /\n / /_/ / \n \\__, /  \n/____/   \n',
    '}': u'     _ \n    | |\n    / /\n   _>_>\n _/_/  \n/_/    \n'}

speed_dic = {
    ' ': u'       \n       \n       \n       \n       \n       \n',
    '$': u'_______\n____/ /\n__  __/\n_(_  ) \n/  _/  \n/_/    \n',
    '(': u'_______\n____/_/\n__  /  \n_  /   \n/ /    \n|_|    \n',
    ',': u'    \n    \n    \n___ \n_( )\n_|/ \n',
    '0': u'_______ \n__  __ \\\n_  / / /\n/ /_/ / \n\\____/  \n        \n',
    '4': u'_____ __\n__  // /\n_  // /_\n/__  __/\n  /_/   \n        \n',
    '8': u'_______ \n__( __ )\n_  __  |\n/ /_/ / \n\\____/  \n        \n',
    '<': u'____\n_  /\n/ / \n\\ \\ \n \\_\\\n    \n',
    '@': u'_________ \n__  ____ \\\n_  / __ `/\n/ / /_/ / \n\\ \\__,_/  \n \\____/   \n',
    'D': u'________ \n___  __ \\\n__  / / /\n_  /_/ / \n/_____/  \n         \n',
    'H': u'______  __\n___  / / /\n__  /_/ / \n_  __  /  \n/_/ /_/   \n          \n',
    'L': u'______ \n___  / \n__  /  \n_  /___\n/_____/\n       \n',
    'P': u'________ \n___  __ \\\n__  /_/ /\n_  ____/ \n/_/      \n         \n',
    'T': u'________\n___  __/\n__  /   \n_  /    \n/_/     \n        \n',
    'X': u'____  __\n__  |/ /\n__    / \n_    |  \n/_/|_|  \n        \n',
    '\\': u'___    \n__ \\   \n___ \\  \n____ \\ \n______\\\n       \n',
    '`': u'___ \n_( )\n__V \n    \n    \n    \n',
    'd': u'_________\n______  /\n_  __  / \n/ /_/ /  \n\\__,_/   \n         \n',
    'h': u'______  \n___  /_ \n__  __ \\\n_  / / /\n/_/ /_/ \n        \n',
    'l': u'______\n___  /\n__  / \n_  /  \n/_/   \n      \n',
    'p': u'         \n________ \n___  __ \\\n__  /_/ /\n_  .___/ \n/_/      \n',
    't': u'_____ \n__  /_\n_  __/\n/ /_  \n\\__/  \n      \n',
    'x': u'        \n____  __\n__  |/_/\n__>  <  \n/_/|_|  \n        \n',
    '|': u'_______\n____  /\n___  / \n__  /  \n_  /   \n/_/    \n',
    '#': u'_______ __ \n____/ // /_\n_ _  _  __/\n/_  _  __/ \n /_//_/    \n           \n',
    "'": u'___ \n_( )\n_|/ \n    \n    \n    \n',
    '+': u'       \n______ \n___/ /_\n/_  __/\n /_/   \n       \n',
    '/': u'_________\n______/_/\n____/_/  \n__/_/    \n/_/      \n         \n',
    '3': u'________\n__|__  /\n___/_ < \n____/ / \n/____/  \n        \n',
    '7': u'______\n/__  /\n__  / \n_  /  \n/_/   \n      \n',
    ';': u'      \n_____ \n___(_)\n___   \n_( )  \n_|/   \n',
    '?': u'_____ \n_ __ \\\n__/ _/\n_/_/  \n(_)   \n      \n',
    'C': u'_________\n__  ____/\n_  /     \n/ /___   \n\\____/   \n         \n',
    'G': u'_________\n__  ____/\n_  / __  \n/ /_/ /  \n\\____/   \n         \n',
    'K': u'______ __\n___  //_/\n__  ,<   \n_  /| |  \n/_/ |_|  \n         \n',
    'O': u'_______ \n__  __ \\\n_  / / /\n/ /_/ / \n\\____/  \n        \n',
    'S': u'________\n__  ___/\n_____ \\ \n____/ / \n/____/  \n        \n',
    'W': u'___       __\n__ |     / /\n__ | /| / / \n__ |/ |/ /  \n____/|__/   \n            \n',
    '[': u'________\n____  _/\n___  /  \n__  /   \n_  /    \n/__/    \n',
    '_': u'        \n        \n        \n        \n________\n_/_____/\n',
    'c': u'       \n_______\n_  ___/\n/ /__  \n\\___/  \n       \n',
    'g': u'         \n_______ _\n__  __ `/\n_  /_/ / \n_\\__, /  \n/____/   \n',
    'k': u'______  \n___  /__\n__  //_/\n_  ,<   \n/_/|_|  \n        \n',
    'o': u'       \n______ \n_  __ \\\n/ /_/ /\n\\____/ \n       \n',
    's': u'        \n________\n__  ___/\n_(__  ) \n/____/  \n        \n',
    'w': u'           \n___      __\n__ | /| / /\n__ |/ |/ / \n____/|__/  \n           \n',
    '{': u'_______\n____/_/\n__/_/  \n< <    \n/ /    \n\\_\\    \n',
    '"': u'___ _ \n_( | )\n_|/|/ \n      \n      \n      \n',
    '&': u'______   \n__( _ )  \n_  __ \\/|\n/ /_/  < \n\\____/\\/ \n         \n',
    '*': u'_____  \n____/|_\n_|    /\n/_ __| \n |/    \n       \n',
    '.': u'    \n    \n    \n___ \n_(_)\n    \n',
    '2': u'______ \n__|__ \\\n____/ /\n_  __/ \n/____/ \n       \n',
    '6': u'________\n__  ___/\n_  __ \\ \n/ /_/ / \n\\____/  \n        \n',
    ':': u'      \n_____ \n___(_)\n___   \n_(_)  \n      \n',
    '>': u'___  \n__ \\ \n___ \\\n__  /\n_/_/ \n     \n',
    'B': u'________ \n___  __ )\n__  __  |\n_  /_/ / \n/_____/  \n         \n',
    'F': u'__________\n___  ____/\n__  /_    \n_  __/    \n/_/       \n          \n',
    'J': u'_________\n______  /\n___ _  / \n/ /_/ /  \n\\____/   \n         \n',
    'N': u'_____   __\n___  | / /\n__   |/ / \n_  /|  /  \n/_/ |_/   \n          \n',
    'R': u'________ \n___  __ \\\n__  /_/ /\n_  _, _/ \n/_/ |_|  \n         \n',
    'V': u'___    __\n__ |  / /\n__ | / / \n__ |/ /  \n_____/   \n         \n',
    'Z': u'______\n___  /\n__  / \n_  /__\n/____/\n      \n',
    '^': u'_ //|\n_|/||\n     \n     \n     \n     \n',
    'b': u'______  \n___  /_ \n__  __ \\\n_  /_/ /\n/_.___/ \n        \n',
    'f': u'________\n___  __/\n__  /_  \n_  __/  \n/_/     \n        \n',
    'j': u'________ \n______(_)\n_____  / \n____  /  \n___  /   \n/___/    \n',
    'n': u'        \n_______ \n__  __ \\\n_  / / /\n/_/ /_/ \n        \n',
    'r': u'        \n________\n__  ___/\n_  /    \n/_/     \n        \n',
    'v': u'        \n___   __\n__ | / /\n__ |/ / \n_____/  \n        \n',
    'z': u'      \n______\n___  /\n__  /_\n_____/\n      \n',
    '~': u'__/\\//\n_//\\/ \n      \n      \n      \n      \n',
    '!': u'______\n___  /\n__  / \n /_/  \n(_)   \n      \n',
    '%': u'____   __\n__(_)_/_/\n____/_/  \n__/_/_   \n/_/ (_)  \n         \n',
    ')': u'______ \n____| |\n____  /\n___  / \n__/_/  \n/_/    \n',
    '-': u'        \n        \n________\n_/_____/\n        \n        \n',
    '1': u'______\n__<  /\n__  / \n_  /  \n/_/   \n      \n',
    '5': u'__________\n___  ____/\n______ \\  \n ____/ /  \n/_____/   \n          \n',
    '9': u'_______ \n__  __ \\\n_  /_/ /\n_\\__, / \n/____/  \n        \n',
    '=': u'       \n_______\n_ ____/\n/____/ \n       \n       \n',
    'A': u'_______ \n___    |\n__  /| |\n_  ___ |\n/_/  |_|\n        \n',
    'E': u'__________\n___  ____/\n__  __/   \n_  /___   \n/_____/   \n          \n',
    'I': u'________\n____  _/\n __  /  \n__/ /   \n/___/   \n        \n',
    'M': u'______  ___\n___   |/  /\n__  /|_/ / \n_  /  / /  \n/_/  /_/   \n           \n',
    'Q': u'_______ \n__  __ \\\n_  / / /\n/ /_/ / \n\\___\\_\\ \n        \n',
    'U': u'_____  __\n__  / / /\n_  / / / \n/ /_/ /  \n\\____/   \n         \n',
    'Y': u'__  __\n_ \\/ /\n__  / \n_  /  \n/_/   \n      \n',
    ']': u'________\n____/  /\n____  / \n___  /  \n__/ /   \n/__/    \n',
    'a': u'        \n______ _\n_  __ `/\n/ /_/ / \n\\__,_/  \n        \n',
    'e': u'      \n_____ \n_  _ \\\n/  __/\n\\___/ \n      \n',
    'i': u'_____ \n___(_)\n__  / \n_  /  \n/_/   \n      \n',
    'm': u'            \n_______ ___ \n__  __ `__ \\\n_  / / / / /\n/_/ /_/ /_/ \n            \n',
    'q': u'        \n______ _\n_  __ `/\n/ /_/ / \n\\__, /  \n  /_/   \n',
    'u': u'        \n____  __\n_  / / /\n/ /_/ / \n\\__,_/  \n        \n',
    'y': u'         \n_____  __\n__  / / /\n_  /_/ / \n_\\__, /  \n/____/   \n',
    '}': u'____ _ \n____| |\n____/ /\n____>_>\n__/_/  \n/_/    \n'}

starwars_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n',
    '$': u"     __,--,_.\n    /       |\n   |   (----`\n    \\   \\    \n.----)   |   \n|_    __/    \n  '--'       \n",
    '(': u'  ___\n /  /\n|  | \n|  | \n|  | \n|  | \n \\__\\\n',
    ',': u'    \n    \n    \n    \n __ \n(_ )\n |/ \n',
    '0': u'  ___   \n / _ \\  \n| | | | \n| | | | \n| |_| | \n \\___/  \n        \n',
    '4': u' _  _    \n| || |   \n| || |_  \n|__   _| \n   | |   \n   |_|   \n         \n',
    '8': u'  ___   \n / _ \\  \n| (_) | \n > _ <  \n| (_) | \n \\___/  \n        \n',
    '<': u'   ___\n  /  /\n /  / \n<  <  \n \\  \\ \n  \\__\\\n      \n',
    '@': u'   ____  \n  / __ \\ \n / / _` |\n| | (_| |\n \\ \\__,_|\n  \\____/ \n         \n',
    'D': u" _______  \n|       \\ \n|  .--.  |\n|  |  |  |\n|  '--'  |\n|_______/ \n          \n",
    'H': u' __    __  \n|  |  |  | \n|  |__|  | \n|   __   | \n|  |  |  | \n|__|  |__| \n           \n',
    'L': u' __      \n|  |     \n|  |     \n|  |     \n|  `----.\n|_______|\n         \n',
    'P': u'.______   \n|   _  \\  \n|  |_)  | \n|   ___/  \n|  |      \n| _|      \n          \n',
    'T': u'.___________.\n|           |\n`---|  |----`\n    |  |     \n    |  |     \n    |__|     \n             \n',
    'X': u'___   ___ \n\\  \\ /  / \n \\  V  /  \n  >   <   \n /  .  \\  \n/__/ \\__\\ \n          \n',
    '\\': u'___     \n\\  \\    \n \\  \\   \n  \\  \\  \n   \\  \\ \n    \\__\\\n        \n',
    '`': u' __ \n( _)\n \\| \n    \n    \n    \n    \n',
    'd': u" _______  \n|       \\ \n|  .--.  |\n|  |  |  |\n|  '--'  |\n|_______/ \n          \n",
    'h': u' __    __  \n|  |  |  | \n|  |__|  | \n|   __   | \n|  |  |  | \n|__|  |__| \n           \n',
    'l': u' __      \n|  |     \n|  |     \n|  |     \n|  `----.\n|_______|\n         \n',
    'p': u'.______   \n|   _  \\  \n|  |_)  | \n|   ___/  \n|  |      \n| _|      \n          \n',
    't': u'.___________.\n|           |\n`---|  |----`\n    |  |     \n    |  |     \n    |__|     \n             \n',
    'x': u'___   ___ \n\\  \\ /  / \n \\  V  /  \n  >   <   \n /  .  \\  \n/__/ \\__\\ \n          \n',
    '|': u' __  \n|  | \n|  | \n|  | \n|  | \n|  | \n|__| \n',
    '#': u'   _  _   \n _| || |_ \n|_  __  _|\n _| || |_ \n|_  __  _|\n  |_||_|  \n          \n',
    "'": u' __ \n(_ )\n |/ \n    \n    \n    \n    \n',
    '+': u'       \n   _   \n _| |_ \n|_   _|\n  |_|  \n       \n       \n',
    '/': u'     ___\n    /  /\n   /  / \n  /  /  \n /  /   \n/__/    \n        \n',
    '3': u' ____   \n|___ \\  \n  __) | \n |__ <  \n ___) | \n|____/  \n        \n',
    '7': u' ______  \n|____  | \n    / /  \n   / /   \n  / /    \n /_/     \n         \n',
    ';': u'   \n _ \n(_)\n   \n _ \n( )\n|/ \n',
    '?': u' ______   \n|      \\  \n`----)  | \n    /  /  \n   |__|   \n    __    \n   (__)   \n',
    'C': u"  ______ \n /      |\n|  ,----'\n|  |     \n|  `----.\n \\______|\n         \n",
    'G': u'  _______ \n /  _____|\n|  |  __  \n|  | |_ | \n|  |__| | \n \\______| \n          \n',
    'K': u" __  ___ \n|  |/  / \n|  '  /  \n|    <   \n|  .  \\  \n|__|\\__\\ \n         \n",
    'O': u"  ______   \n /  __  \\  \n|  |  |  | \n|  |  |  | \n|  `--'  | \n \\______/  \n           \n",
    'S': u'     _______.\n    /       |\n   |   (----`\n    \\   \\    \n.----)   |   \n|_______/    \n             \n',
    'W': u'____    __    ____ \n\\   \\  /  \\  /   / \n \\   \\/    \\/   /  \n  \\            /   \n   \\    /\\    /    \n    \\__/  \\__/     \n                   \n',
    '[': u' ____ \n|    |\n|  |-`\n|  |  \n|  |  \n|  |-.\n|____|\n',
    '_': u'        \n        \n        \n        \n        \n ______ \n|______|\n',
    'c': u"  ______ \n /      |\n|  ,----'\n|  |     \n|  `----.\n \\______|\n         \n",
    'g': u'  _______ \n /  _____|\n|  |  __  \n|  | |_ | \n|  |__| | \n \\______| \n          \n',
    'k': u" __  ___ \n|  |/  / \n|  '  /  \n|    <   \n|  .  \\  \n|__|\\__\\ \n         \n",
    'o': u"  ______   \n /  __  \\  \n|  |  |  | \n|  |  |  | \n|  `--'  | \n \\______/  \n           \n",
    's': u'     _______.\n    /       |\n   |   (----`\n    \\   \\    \n.----)   |   \n|_______/    \n             \n',
    'w': u'____    __    ____ \n\\   \\  /  \\  /   / \n \\   \\/    \\/   /  \n  \\            /   \n   \\    /\\    /    \n    \\__/  \\__/     \n                   \n',
    '{': u'   ___\n  /  /\n |  | \n/  /  \n\\  \\  \n |  | \n  \\__\\\n',
    '"': u' _ _ \n( | )\n V V \n     \n     \n     \n     \n',
    '&': u'        \n  ___   \n ( _ )  \n / _ \\/\\\n| (_>  <\n \\___/\\/\n        \n',
    '*': u"    _    \n /\\| |/\\ \n \\ ` ' / \n|_     _|\n / , . \\ \n \\/|_|\\/ \n         \n",
    '.': u'    \n    \n    \n    \n __ \n(__)\n    \n',
    '2': u' ___   \n|__ \\  \n   ) | \n  / /  \n / /_  \n|____| \n       \n',
    '6': u"   __   \n  / /   \n / /_   \n| '_ \\  \n| (_) | \n \\___/  \n        \n",
    ':': u'   \n _ \n(_)\n   \n _ \n(_)\n   \n',
    '>': u'___   \n\\  \\  \n \\  \\ \n  >  >\n /  / \n/__/  \n      \n',
    'B': u'.______   \n|   _  \\  \n|  |_)  | \n|   _  <  \n|  |_)  | \n|______/  \n          \n',
    'F': u' _______ \n|   ____|\n|  |__   \n|   __|  \n|  |     \n|__|     \n         \n',
    'J': u"       __  \n      |  | \n      |  | \n.--.  |  | \n|  `--'  | \n \\______/  \n           \n",
    'N': u'.__   __. \n|  \\ |  | \n|   \\|  | \n|  . `  | \n|  |\\   | \n|__| \\__| \n          \n',
    'R': u'.______      \n|   _  \\     \n|  |_)  |    \n|      /     \n|  |\\  \\----.\n| _| `._____|\n             \n',
    'V': u'____    ____ \n\\   \\  /   / \n \\   \\/   /  \n  \\      /   \n   \\    /    \n    \\__/     \n             \n',
    'Z': u' ________  \n|       /  \n`---/  /   \n   /  /    \n  /  /----.\n /________|\n           \n',
    '^': u'  ___  \n /   \\ \n/--^--\\\n       \n       \n       \n       \n',
    'b': u'.______   \n|   _  \\  \n|  |_)  | \n|   _  <  \n|  |_)  | \n|______/  \n          \n',
    'f': u' _______ \n|   ____|\n|  |__   \n|   __|  \n|  |     \n|__|     \n         \n',
    'j': u"       __  \n      |  | \n      |  | \n.--.  |  | \n|  `--'  | \n \\______/  \n           \n",
    'n': u'.__   __. \n|  \\ |  | \n|   \\|  | \n|  . `  | \n|  |\\   | \n|__| \\__| \n          \n',
    'r': u'.______      \n|   _  \\     \n|  |_)  |    \n|      /     \n|  |\\  \\----.\n| _| `._____|\n             \n',
    'v': u'____    ____ \n\\   \\  /   / \n \\   \\/   /  \n  \\      /   \n   \\    /    \n    \\__/     \n             \n',
    'z': u' ________  \n|       /  \n`---/  /   \n   /  /    \n  /  /----.\n /________|\n           \n',
    '~': u'  __  _ \n /  \\/ |\n|_/\\__/ \n        \n        \n        \n        \n',
    '!': u' __  \n|  | \n|  | \n|  | \n|__| \n(__) \n     \n',
    '%': u'  _     ___  \n / \\   /  /  \n( o ) /  /   \n \\_/ /  / _  \n    /  / / \\ \n   /  / ( o )\n  /__/   \\_/ \n',
    ')': u'___  \n\\  \\ \n |  |\n |  |\n |  |\n |  |\n/__/ \n',
    '-': u'        \n        \n ______ \n|______|\n        \n        \n        \n',
    '1': u' __  \n/_ | \n | | \n | | \n | | \n |_| \n     \n',
    '5': u' _____  \n| ____| \n| |__   \n|___ \\  \n ___) | \n|____/  \n        \n',
    '9': u'  ___   \n / _ \\  \n| (_) | \n \\__, | \n   / /  \n  /_/   \n        \n',
    '=': u'        \n ______ \n|______|\n ______ \n|______|\n        \n        \n',
    'A': u'     ___      \n    /   \\     \n   /  ^  \\    \n  /  /_\\  \\   \n /  _____  \\  \n/__/     \\__\\ \n              \n',
    'E': u' _______ \n|   ____|\n|  |__   \n|   __|  \n|  |____ \n|_______|\n         \n',
    'I': u' __  \n|  | \n|  | \n|  | \n|  | \n|__| \n     \n',
    'M': u'.___  ___. \n|   \\/   | \n|  \\  /  | \n|  |\\/|  | \n|  |  |  | \n|__|  |__| \n           \n',
    'Q': u"  ______      \n /  __  \\     \n|  |  |  |    \n|  |  |  |    \n|  `--'  '--. \n \\_____\\_____\\\n              \n",
    'U': u" __    __  \n|  |  |  | \n|  |  |  | \n|  |  |  | \n|  `--'  | \n \\______/  \n           \n",
    'Y': u'____    ____ \n\\   \\  /   / \n \\   \\/   /  \n  \\_    _/   \n    |  |     \n    |__|     \n             \n',
    ']': u' ____ \n|    |\n`-|  |\n  |  |\n  |  |\n.-|  |\n|____|\n',
    'a': u'     ___      \n    /   \\     \n   /  ^  \\    \n  /  /_\\  \\   \n /  _____  \\  \n/__/     \\__\\ \n              \n',
    'e': u' _______ \n|   ____|\n|  |__   \n|   __|  \n|  |____ \n|_______|\n         \n',
    'i': u' __  \n|  | \n|  | \n|  | \n|  | \n|__| \n     \n',
    'm': u'.___  ___. \n|   \\/   | \n|  \\  /  | \n|  |\\/|  | \n|  |  |  | \n|__|  |__| \n           \n',
    'q': u"  ______      \n /  __  \\     \n|  |  |  |    \n|  |  |  |    \n|  `--'  '--. \n \\_____\\_____\\\n              \n",
    'u': u" __    __  \n|  |  |  | \n|  |  |  | \n|  |  |  | \n|  `--'  | \n \\______/  \n           \n",
    'y': u'____    ____ \n\\   \\  /   / \n \\   \\/   /  \n  \\_    _/   \n    |  |     \n    |__|     \n             \n',
    '}': u'___   \n\\  \\  \n |  | \n  \\  \\\n  /  /\n |  | \n/__/  \n'}

stop_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u'   _   \n _| |_ \n|  ___)\n|___  |\n(_   _|\n  |_|  \n       \n',
    '(': u'   __ \n  / _)\n / /  \n( (   \n \\ \\_ \n  \\__)\n      \n',
    ',': u'   \n   \n   \n   \n _ \n( )\n|/ \n',
    '0': u'  ______ \n / __   |\n| | //| |\n| |// | |\n|  /__| |\n \\_____/ \n         \n',
    '4': u'   __    \n  / /    \n / /____ \n|___   _)\n    | |  \n    |_|  \n         \n',
    '8': u'  _____  \n / ___ \\ \n( (   ) )\n > > < < \n( (___) )\n \\_____/ \n         \n',
    '<': u'       \n  _  _ \n / )/ )\n( (( ( \n \\_)\\_)\n       \n       \n',
    '@': u'           \n           \n           \n      _|_  \n  __   |   \n (_/|_/|_/ \n           \n',
    'D': u' _____   \n(____ \\  \n _   \\ \\ \n| |   | |\n| |__/ / \n|_____/  \n         \n',
    'H': u' _     _ \n| |   | |\n| |__ | |\n|  __)| |\n| |   | |\n|_|   |_|\n         \n',
    'L': u' _       \n| |      \n| |      \n| |      \n| |_____ \n|_______)\n         \n',
    'P': u' ______  \n(_____ \\ \n _____) )\n|  ____/ \n| |      \n|_|      \n         \n',
    'T': u' _______ \n(_______)\n _       \n| |      \n| |_____ \n \\______)\n         \n',
    'X': u' _    _ \n\\ \\  / /\n \\ \\/ / \n  )  (  \n / /\\ \\ \n/_/  \\_\\\n        \n',
    '\\': u' _     \n| |    \n \\ \\   \n  \\ \\  \n   \\ \\ \n    |_|\n       \n',
    '`': u' _ \n( )\n \\|\n   \n   \n   \n   \n',
    'd': u'     _ \n    | |\n  _ | |\n / || |\n( (_| |\n \\____|\n       \n',
    'h': u' _     \n| |    \n| | _  \n| || \\ \n| | | |\n|_| |_|\n       \n',
    'l': u' _ \n| |\n| |\n| |\n| |\n|_|\n   \n',
    'p': u'       \n       \n ____  \n|  _ \\ \n| | | |\n| ||_/ \n|_|    \n',
    't': u'      \n _    \n| |_  \n|  _) \n| |__ \n \\___)\n      \n',
    'x': u'       \n       \n _   _ \n( \\ / )\n ) X ( \n(_/ \\_)\n       \n',
    '|': u' _ \n| |\n|_|\n _ \n| |\n|_|\n   \n',
    '#': u'   __  _   \n _|  || |_ \n(_   ||  _)\n _|  || |_ \n(_   ||  _)\n  |__||_|  \n           \n',
    "'": u' _ \n( )\n|/ \n   \n   \n   \n   \n',
    '+': u'       \n   _   \n _| |_ \n(_   _)\n  |_|  \n       \n       \n',
    '/': u'     _ \n    | |\n   / / \n  / /  \n / /   \n|_|    \n       \n',
    '3': u' ________\n(_______/\n   ____  \n  (___ \\ \n _____) )\n(______/ \n         \n',
    '7': u' _______ \n(_______)\n      _  \n     / ) \n    / /  \n   (_/   \n         \n',
    ';': u'   \n   \n _ \n(_)\n _ \n( )\n|/ \n',
    '?': u' ____  \n(___ \\ \n    ) )\n   /_/ \n   _   \n  (_)  \n       \n',
    'C': u'  ______ \n / _____)\n| /      \n| |      \n| \\_____ \n \\______)\n         \n',
    'G': u'  ______ \n / _____)\n| /  ___ \n| | (___)\n| \\____/|\n \\_____/ \n         \n',
    'K': u' _    _ \n| |  / )\n| | / / \n| |< <  \n| | \\ \\ \n|_|  \\_)\n        \n',
    'O': u'  _____  \n / ___ \\ \n| |   | |\n| |   | |\n| |___| |\n \\_____/ \n         \n',
    'S': u'    _    \n   | |   \n    \\ \\  \n     \\ \\ \n _____) )\n(______/ \n         \n',
    'W': u' _  _  _ \n| || || |\n| || || |\n| ||_|| |\n| |___| |\n \\______|\n         \n',
    '[': u' ___ \n|  _)\n| |  \n| |  \n| |_ \n|___)\n     \n',
    '_': u'         \n         \n         \n         \n _______ \n(_______)\n         \n',
    'c': u'       \n       \n  ____ \n / ___)\n( (___ \n \\____)\n       \n',
    'g': u'       \n       \n  ____ \n / _  |\n( ( | |\n \\_|| |\n(_____|\n',
    'k': u' _     \n| |    \n| |  _ \n| | / )\n| |< ( \n|_| \\_)\n       \n',
    'o': u'       \n       \n  ___  \n / _ \\ \n| |_| |\n \\___/ \n       \n',
    's': u'      \n      \n  ___ \n /___)\n|___ |\n(___/ \n      \n',
    'w': u'       \n       \n _ _ _ \n| | | |\n| | | |\n \\____|\n       \n',
    '{': u'   __ \n  / _)\n | |  \n( (   \n | |_ \n  \\__)\n      \n',
    '"': u' _  _ \n( )( )\n|/ |/ \n      \n      \n      \n      \n',
    '&': u'  ___   \n / _ \\  \n( (_) ) \n ) _ (  \n( (/  \\ \n \\__/\\_)\n        \n',
    '*': u' _  _  _ \n( \\| |/ )\n \\  _  / \n(_ (_) _)\n /     \\ \n(_/|_|\\_)\n         \n',
    '.': u'   \n   \n   \n   \n _ \n(_)\n   \n',
    '2': u' ______  \n(_____ \\ \n  ____) )\n /_____/ \n _______ \n(_______)\n         \n',
    '6': u'    __  \n   / /  \n  / /_  \n / __ \\ \n( (__) )\n \\____/ \n        \n',
    ':': u'   \n   \n _ \n(_)\n _ \n(_)\n   \n',
    '>': u'       \n _  _  \n( \\( \\ \n ) )) )\n(_/(_/ \n       \n       \n',
    'B': u' ______  \n(____  \\ \n ____)  )\n|  __  ( \n| |__)  )\n|______/ \n         \n',
    'F': u' _______ \n(_______)\n _____   \n|  ___)  \n| |      \n|_|      \n         \n',
    'J': u'   _____ \n  (_____)\n     _   \n    | |  \n ___| |  \n(____/   \n         \n',
    'N': u' ______  \n|  ___ \\ \n| |   | |\n| |   | |\n| |   | |\n|_|   |_|\n         \n',
    'R': u' ______  \n(_____ \\ \n _____) )\n(_____ ( \n      | |\n      |_|\n         \n',
    'V': u' _    _ \n| |  | |\n| |  | |\n \\ \\/ / \n  \\  /  \n   \\/   \n        \n',
    'Z': u' _______ \n(_______)\n   __    \n  / /    \n / /____ \n(_______)\n         \n',
    '^': u'  /\\  \n //\\\\ \n(____)\n      \n      \n      \n      \n',
    'b': u' _     \n| |    \n| | _  \n| || \\ \n| |_) )\n|____/ \n       \n',
    'f': u'  ___ \n / __)\n| |__ \n|  __)\n| |   \n|_|   \n      \n',
    'j': u'   _ \n  (_)\n   _ \n  | |\n  | |\n _| |\n(__/ \n',
    'n': u'       \n       \n ____  \n|  _ \\ \n| | | |\n|_| |_|\n       \n',
    'r': u'       \n       \n  ____ \n / ___)\n| |    \n|_|    \n       \n',
    'v': u'       \n       \n _   _ \n| | | |\n \\ V / \n  \\_/  \n       \n',
    'z': u'       \n       \n _____ \n(___  )\n / __/ \n(_____)\n       \n',
    '~': u'  __  _ \n /  \\/ )\n(_/\\__/ \n        \n        \n        \n        \n',
    '!': u' _ \n| |\n| |\n|_|\n _ \n|_|\n   \n',
    '%': u' _   _ \n(_) | |\n   / / \n  / /  \n / / _ \n|_| (_)\n       \n',
    ')': u' __   \n(_ \\  \n  \\ \\ \n   ) )\n _/ / \n(__/  \n      \n',
    '-': u'     \n     \n ___ \n(___)\n     \n     \n     \n',
    '1': u'  __ \n /  |\n/_/ |\n  | |\n  | |\n  |_|\n     \n',
    '5': u' _______ \n(_______)\n ______  \n(_____ \\ \n _____) )\n(______/ \n         \n',
    '9': u'  ____  \n / __ \\ \n( (__) )\n \\__  / \n   / /  \n  /_/   \n        \n',
    '=': u'     \n ___ \n(___)\n ___ \n(___)\n     \n     \n',
    'A': u'        \n   /\\   \n  /  \\  \n / /\\ \\ \n| |__| |\n|______|\n        \n',
    'E': u' _______ \n(_______)\n _____   \n|  ___)  \n| |_____ \n|_______)\n         \n',
    'I': u' _____ \n(_____)\n   _   \n  | |  \n _| |_ \n(_____)\n       \n',
    'M': u' ______  \n|  ___ \\ \n| | _ | |\n| || || |\n| || || |\n|_||_||_|\n         \n',
    'Q': u'  _____  \n / ___ \\ \n| |   | |\n| |   |_|\n \\ \\____ \n  \\_____)\n         \n',
    'U': u' _     _ \n| |   | |\n| |   | |\n| |   | |\n| |___| |\n \\______|\n         \n',
    'Y': u' _     _ \n| |   | |\n| |___| |\n \\_____/ \n   ___   \n  (___)  \n         \n',
    ']': u' ___ \n(_  |\n  | |\n  | |\n _| |\n(___|\n     \n',
    'a': u'       \n       \n  ____ \n / _  |\n( ( | |\n \\_||_|\n       \n',
    'e': u'       \n       \n  ____ \n / _  )\n( (/ / \n \\____)\n       \n',
    'i': u' _ \n(_)\n _ \n| |\n| |\n|_|\n   \n',
    'm': u'       \n       \n ____  \n|    \\ \n| | | |\n|_|_|_|\n       \n',
    'q': u'       \n       \n  ____ \n / _  |\n| | | |\n \\_|| |\n    |_|\n',
    'u': u'       \n       \n _   _ \n| | | |\n| |_| |\n \\____|\n       \n',
    'y': u'       \n       \n _   _ \n| | | |\n| |_| |\n \\__  |\n(____/ \n',
    '}': u' __   \n(_ \\  \n  | | \n   ) )\n _| | \n(__/  \n      \n'}

thin_dic = {
    ' ': u'    \n    \n    \n    \n    \n    \n',
    '$': u"  ,  \n,-|-.\n`-|-.\n  | |\n`-|-'\n  `  \n",
    '(': u'  \n /\n| \n| \n| \n \\\n',
    ',': u"    \n    \n    \n    \n |  \n'   \n",
    '0': u"    \n,--.\n|  |\n|  |\n`--'\n    \n",
    '4': u'    \n|  |\n`--|\n   |\n   `\n    \n',
    '8': u"    \n,--.\n,--.\n|  |\n`--'\n    \n",
    '<': u'  \n /\n/ \n\\ \n \\\n  \n',
    '@': u"     \n,---.\n| o_/\n|    \n`---'\n     \n",
    'D': u"     \n,--. \n|   |\n|   |\n`--' \n     \n",
    'H': u"     \n|   |\n|---|\n|   |\n`   '\n     \n",
    'L': u"     \n|    \n|    \n|    \n`---'\n     \n",
    'P': u"     \n,---.\n|---'\n|    \n`    \n     \n",
    'T': u'     \n--.--\n  |  \n  |  \n  `  \n     \n',
    'X': u"    \n.  ,\n >< \n|  |\n'  `\n    \n",
    '\\': u'    \n\\   \n \\  \n  \\ \n   \\\n    \n',
    '`': u'  \n| \n `\n  \n  \n  \n',
    'd': u"     \n    |\n,---|\n|   |\n`---'\n     \n",
    'h': u"     \n|    \n|---.\n|   |\n`   '\n     \n",
    'l': u"     \n|    \n|    \n|    \n`---'\n     \n",
    'p': u"     \n     \n,---.\n|   |\n|---'\n|    \n",
    't': u"     \n|    \n|--- \n|    \n`---'\n     \n",
    'x': u"    \n    \n.  ,\n >< \n'  `\n    \n",
    '|': u' \n|\n|\n|\n|\n \n',
    '#': u'     \n . . \n-+-+-\n-+-+-\n ` ` \n     \n',
    "'": u"  \n |\n' \n  \n  \n  \n",
    '+': u'    \n    \n |  \n-+- \n |  \n    \n',
    '/': u'    \n   /\n  / \n /  \n/   \n    \n',
    '3': u"    \n,--.\n  -|\n   |\n`--'\n    \n",
    '7': u'    \n---.\n   /\n  | \n  | \n    \n',
    ';': u"  \n  \n o\n  \n |\n' \n",
    '?': u"     \n,---.\n  ,-'\n  |  \n  o  \n     \n",
    'C': u"     \n,---.\n|    \n|    \n`---'\n     \n",
    'G': u"     \n,---.\n|  _.\n|   |\n`---'\n     \n",
    'K': u'     \n|   /\n|__/ \n|  \\ \n`   `\n     \n',
    'O': u"     \n,---.\n|   |\n|   |\n`---'\n     \n",
    'S': u"     \n,---.\n`---.\n    |\n`---'\n     \n",
    'W': u"     \n. . .\n| | |\n| | |\n`-'-'\n     \n",
    '[': u'  \n,-\n| \n: \n| \n`-\n',
    '_': u'   \n   \n   \n   \n   \n---\n',
    'c': u"     \n     \n,---.\n|    \n`---'\n     \n",
    'g': u"     \n     \n,---.\n|   |\n`---|\n`---'\n",
    'k': u'     \n|    \n|__/ \n|  \\ \n`   `\n     \n',
    'o': u"     \n     \n,---.\n|   |\n`---'\n     \n",
    's': u"     \n     \n,---.\n`---.\n`---'\n     \n",
    'w': u"     \n     \n. . .\n| | |\n`-'-'\n     \n",
    '{': u'   \n ,-\n | \n-: \n | \n `-\n',
    '"': u'   \n| |\n` `\n   \n   \n   \n',
    '&': u'     \n     \n ,-. \n |_|_\n   | \n     \n',
    '*': u"   \n   \n.|.\n-*-\n'|`\n   \n",
    '.': u' \n \n \n \no\n \n',
    '2': u"    \n,--.\n,--'\n|   \n`--'\n    \n",
    '6': u"    \n,--.\n|--.\n|  |\n`--'\n    \n",
    ':': u' \n \no\n \no\n \n',
    '>': u'  \n\\ \n \\\n /\n/ \n  \n',
    'B': u"     \n,---.\n|---.\n|   |\n`---'\n     \n",
    'F': u'     \n,---.\n|__. \n|    \n`    \n     \n',
    'J': u"     \n    |\n    |\n    |\n`---'\n     \n",
    'N': u"     \n,   .\n|\\  |\n| \\ |\n`  `'\n     \n",
    'R': u"     \n,---.\n|---'\n|  \\ \n`   `\n     \n",
    'V': u"      \n.    ,\n|    |\n \\  / \n  `'  \n      \n",
    'Z': u"     \n,---,\n .-' \n|    \n`---'\n     \n",
    '^': u'   \n . \n/ \\\n   \n   \n   \n',
    'b': u"     \n|    \n|---.\n|   |\n`---'\n     \n",
    'f': u'     \n,---.\n|__. \n|    \n`    \n     \n',
    'j': u"     \n    o\n    .\n    |\n    |\n`---'\n",
    'n': u"     \n     \n,---.\n|   |\n`   '\n     \n",
    'r': u'     \n     \n,---.\n|    \n`    \n     \n',
    'v': u"      \n      \n.    ,\n \\  / \n  `'  \n      \n",
    'z': u"     \n     \n,---,\n .-' \n'---'\n     \n",
    '~': u'     \n _   \n/ \\_/\n     \n     \n     \n',
    '!': u' \n|\n|\n \no\n \n',
    '%': u'    \no  /\n  / \n /  \n/  o\n    \n',
    ')': u'  \n\\ \n |\n |\n |\n/ \n',
    '-': u'   \n   \n   \n---\n   \n   \n',
    '1': u"   \n '|\n  |\n  |\n  `\n   \n",
    '5': u"    \n---.\n`--.\n   |\n`--'\n    \n",
    '9': u"    \n,--.\n`__|\n   |\n   '\n    \n",
    '=': u'   \n   \n---\n---\n   \n   \n',
    'A': u"     \n,---.\n|---|\n|   |\n`   '\n     \n",
    'E': u"     \n,---.\n|--- \n|    \n`---'\n     \n",
    'I': u' \n|\n|\n|\n`\n \n',
    'M': u"     \n,-.-.\n| | |\n| | |\n` ' '\n     \n",
    'Q': u'     \n,---.\n|   |\n|   |\n`---\\\n     \n',
    'U': u"     \n.   .\n|   |\n|   |\n`---'\n     \n",
    'Y': u"     \n,   .\n|   |\n`---'\n  |  \n  `  \n",
    ']': u"  \n-.\n |\n :\n |\n-'\n",
    'a': u'     \n     \n,---.\n,---|\n`---^\n     \n',
    'e': u"     \n     \n,---.\n|---'\n`---'\n     \n",
    'i': u' \no\n.\n|\n`\n \n',
    'm': u"     \n     \n,-.-.\n| | |\n` ' '\n     \n",
    'q': u'     \n     \n,---.\n|   |\n`---|\n    |\n',
    'u': u"     \n     \n.   .\n|   |\n`---'\n     \n",
    'y': u"     \n     \n,   .\n|   |\n`---|\n`---'\n",
    '}': u"   \n-. \n | \n :-\n | \n-' \n"}

usaflag_dic = {
    ' ': u'     \n     \n     \n     \n     \n     \n',
    '$': u'  =H=H= \n ==H H  \n  ===== \n   H H==\n  =H=H= \n        \n',
    '(': u'  ===\n === \n === \n === \n  ===\n     \n',
    ',': u'    \n    \n    \n  ==\n  ==\n == \n',
    '0': u' :::==== \n :::  ===\n ===  ===\n ===  ===\n  ====== \n         \n',
    '4': u' :::  ===\n :::  ===\n ========\n      ===\n      ===\n         \n',
    '8': u' :::==== \n :::  ===\n  ====== \n ===  ===\n  ====== \n         \n',
    '<': u'     ===\n   ===  \n ===    \n   ===  \n     ===\n        \n',
    '@': u'  ======= \n ===   ===\n === =====\n ===      \n  ======= \n          \n',
    'D': u' :::==== \n :::  ===\n ===  ===\n ===  ===\n ======= \n         \n',
    'H': u' :::  ===\n :::  ===\n ========\n ===  ===\n ===  ===\n         \n',
    'L': u' :::     \n :::     \n ===     \n ===     \n ========\n         \n',
    'P': u' :::==== \n :::  ===\n ======= \n ===     \n ===     \n         \n',
    'T': u' :::====\n :::====\n   ===  \n   ===  \n   ===  \n        \n',
    'X': u' :::  ===\n :::  ===\n  ====== \n  ====== \n ===  ===\n         \n',
    '\\': u' ===    \n  ===   \n   ===  \n    === \n     ===\n        \n',
    '`': u' == \n  ==\n    \n    \n    \n    \n',
    'd': u' :::==== \n :::  ===\n ===  ===\n ===  ===\n ======= \n         \n',
    'h': u' :::  ===\n :::  ===\n ========\n ===  ===\n ===  ===\n         \n',
    'l': u' :::     \n :::     \n ===     \n ===     \n ========\n         \n',
    'p': u' :::==== \n :::  ===\n ======= \n ===     \n ===     \n         \n',
    't': u' :::====\n :::====\n   ===  \n   ===  \n   ===  \n        \n',
    'x': u' :::  ===\n :::  ===\n  ====== \n  ====== \n ===  ===\n         \n',
    '|': u' ===\n ===\n ===\n ===\n ===\n    \n',
    '#': u'  === === \n =========\n  === === \n =========\n  === === \n          \n',
    "'": u'  ==\n == \n    \n    \n    \n    \n',
    '+': u'   ===  \n   ===  \n =======\n   ===  \n   ===  \n        \n',
    '/': u'     ===\n    === \n   ===  \n  ===   \n ===    \n        \n',
    '3': u' :::=== \n     ===\n  ===== \n     ===\n ====== \n        \n',
    '7': u' :::=====\n      ===\n     === \n  ====   \n ===     \n         \n',
    ';': u'    \n  ==\n    \n  ==\n  ==\n == \n',
    '?': u'  ====== \n ==   ===\n    ==== \n    ""   \n    ==   \n         \n',
    'C': u' :::=====\n :::     \n ===     \n ===     \n  =======\n         \n',
    'G': u' :::===== \n :::      \n === =====\n ===   ===\n  ======= \n          \n',
    'K': u' :::  ===\n ::: === \n ======  \n === === \n ===  ===\n         \n',
    'O': u' :::==== \n :::  ===\n ===  ===\n ===  ===\n  ====== \n         \n',
    'S': u' :::=== \n :::    \n  ===== \n     ===\n ====== \n        \n',
    'W': u' :::  ===  ===\n :::  ===  ===\n ===  ===  ===\n  =========== \n   ==== ====  \n              \n',
    '[': u' =====\n ===  \n ===  \n ===  \n =====\n      \n',
    '_': u'         \n         \n         \n         \n         \n ========\n',
    'c': u' :::=====\n :::     \n ===     \n ===     \n  =======\n         \n',
    'g': u' :::===== \n :::      \n === =====\n ===   ===\n  ======= \n          \n',
    'k': u' :::  ===\n ::: === \n ======  \n === === \n ===  ===\n         \n',
    'o': u' :::==== \n :::  ===\n ===  ===\n ===  ===\n  ====== \n         \n',
    's': u' :::=== \n :::    \n  ===== \n     ===\n ====== \n        \n',
    'w': u' :::  ===  ===\n :::  ===  ===\n ===  ===  ===\n  =========== \n   ==== ====  \n              \n',
    '{': u'  ===\n  ===\n === \n  ===\n  ===\n     \n',
    '"': u' == == \n  == ==\n       \n       \n       \n       \n',
    '&': u' :::==    \n ::: ==   \n  ===== ==\n === ===  \n  ===== ==\n          \n',
    '*': u'  :::  === \n   ::====  \n ==========\n   ======  \n  ===  === \n           \n',
    '.': u'   \n   \n   \n   \n ==\n   \n',
    '2': u' :::==== \n ::   ===\n    ==== \n  ===    \n ========\n         \n',
    '6': u' :::==== \n :::     \n ======= \n ===  ===\n  ====== \n         \n',
    ':': u'   \n ==\n   \n ==\n   \n   \n',
    '>': u' ===    \n   ===  \n     ===\n   ===  \n ===    \n        \n',
    'B': u' :::==== \n :::  ===\n ======= \n ===  ===\n ======= \n         \n',
    'F': u' :::=====\n :::     \n ======  \n ===     \n ===     \n         \n',
    'J': u'     :::\n     :::\n     ===\n ==  ===\n ====== \n        \n',
    'N': u' :::= ===\n :::=====\n ========\n === ====\n ===  ===\n         \n',
    'R': u' :::==== \n :::  ===\n ======= \n === === \n ===  ===\n         \n',
    'V': u' :::  ===\n :::  ===\n ===  ===\n  ====== \n    ==   \n         \n',
    'Z': u' :::=====\n      ===\n    ===  \n  ===    \n ========\n         \n',
    '^': u'   ====  \n ===  ===\n         \n         \n         \n         \n',
    'b': u' :::==== \n :::  ===\n ======= \n ===  ===\n ======= \n         \n',
    'f': u' :::=====\n :::     \n ======  \n ===     \n ===     \n         \n',
    'j': u'     :::\n     :::\n     ===\n ==  ===\n ====== \n        \n',
    'n': u' :::= ===\n :::=====\n ========\n === ====\n ===  ===\n         \n',
    'r': u' :::==== \n :::  ===\n ======= \n === === \n ===  ===\n         \n',
    'v': u' :::  ===\n :::  ===\n ===  ===\n  ====== \n    ==   \n         \n',
    'z': u' :::=====\n      ===\n    ===  \n  ===    \n ========\n         \n',
    '~': u' === ==\n = === \n       \n       \n       \n       \n',
    '!': u' ===\n ===\n ===\n    \n ===\n    \n',
    '%': u'  ==  ==\n     ===\n   ===  \n ===    \n ==  == \n        \n',
    ')': u' === \n  ===\n  ===\n  ===\n === \n     \n',
    '-': u'         \n         \n ========\n         \n         \n         \n',
    '1': u' :::\n :::\n ===\n ===\n ===\n    \n',
    '5': u' :::====\n :::    \n ====== \n     ===\n ====== \n        \n',
    '9': u' :::==== \n :::  ===\n  =======\n      ===\n  =====  \n         \n',
    '=': u'         \n ========\n         \n ========\n         \n         \n',
    'A': u' :::==== \n :::  ===\n ========\n ===  ===\n ===  ===\n         \n',
    'E': u' :::=====\n :::     \n ======  \n ===     \n ========\n         \n',
    'I': u' :::\n :::\n ===\n ===\n ===\n    \n',
    'M': u' :::======= \n ::: === ===\n === === ===\n ===     ===\n ===     ===\n            \n',
    'Q': u' :::====  \n :::  === \n === ==== \n ======== \n  ==== ===\n          \n',
    'U': u' :::  ===\n :::  ===\n ===  ===\n ===  ===\n  ====== \n         \n',
    'Y': u' ::: ===\n ::: ===\n  ===== \n   ===  \n   ===  \n        \n',
    ']': u' =====\n   ===\n   ===\n   ===\n =====\n      \n',
    'a': u' :::==== \n :::  ===\n ========\n ===  ===\n ===  ===\n         \n',
    'e': u' :::=====\n :::     \n ======  \n ===     \n ========\n         \n',
    'i': u' :::\n :::\n ===\n ===\n ===\n    \n',
    'm': u' :::======= \n ::: === ===\n === === ===\n ===     ===\n ===     ===\n            \n',
    'q': u' :::====  \n :::  === \n === ==== \n ======== \n  ==== ===\n          \n',
    'u': u' :::  ===\n :::  ===\n ===  ===\n ===  ===\n  ====== \n         \n',
    'y': u' ::: ===\n ::: ===\n  ===== \n   ===  \n   ===  \n        \n',
    '}': u' === \n === \n  ===\n === \n === \n     \n'}

dic_3d = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'   *  \n *****\n/*/*/ \n/*****\n///*/*\n *****\n///*/ \n  /   \n',
    '(': u'   **\n  ** \n **  \n/**  \n/**  \n//** \n //**\n  // \n',
    ',': u'   \n   \n   \n   \n   \n **\n//*\n / \n',
    '0': u'  **** \n *///**\n/*  */*\n/* * /*\n/**  /*\n/*   /*\n/ **** \n ////  \n',
    '4': u'    ** \n   */* \n  * /* \n ******\n/////* \n    /* \n    /* \n    /  \n',
    '8': u'  **** \n */// *\n/*   /*\n/ **** \n */// *\n/*   /*\n/ **** \n ////  \n',
    '<': u'       **\n     **/ \n   **/   \n **/     \n// **    \n  // **  \n    // **\n      // \n',
    '@': u'  **** \n */// *\n/* **/*\n/*/* /*\n/*/ ** \n/* //  \n/ *****\n ///// \n',
    'D': u' *******  \n/**////** \n/**    /**\n/**    /**\n/**    /**\n/**    ** \n/*******  \n///////   \n',
    'H': u' **      **\n/**     /**\n/**     /**\n/**********\n/**//////**\n/**     /**\n/**     /**\n//      // \n',
    'L': u' **      \n/**      \n/**      \n/**      \n/**      \n/**      \n/********\n//////// \n',
    'P': u' ******* \n/**////**\n/**   /**\n/******* \n/**////  \n/**      \n/**      \n//       \n',
    'T': u' **********\n/////**/// \n    /**    \n    /**    \n    /**    \n    /**    \n    /**    \n    //     \n',
    'X': u' **     **\n//**   ** \n //** **  \n  //***   \n   **/**  \n  ** //** \n **   //**\n//     // \n',
    '\\': u' **      \n//**     \n //**    \n  //**   \n   //**  \n    //** \n     //**\n      // \n',
    '`': u' **\n/* \n/  \n   \n   \n   \n   \n   \n',
    'd': u'      **\n     /**\n     /**\n  ******\n **///**\n/**  /**\n//******\n ////// \n',
    'h': u' **     \n/**     \n/**     \n/****** \n/**///**\n/**  /**\n/**  /**\n//   // \n',
    'l': u'  **\n /**\n /**\n /**\n /**\n /**\n ***\n/// \n',
    'p': u'        \n ****** \n/**///**\n/**  /**\n/****** \n/**///  \n/**     \n//      \n',
    't': u'   **  \n  /**  \n ******\n///**/ \n  /**  \n  /**  \n  //** \n   //  \n',
    'x': u'        \n        \n **   **\n//** ** \n //***  \n  **/** \n ** //**\n//   // \n',
    '|': u' *\n/*\n/*\n/ \n *\n/*\n/*\n/ \n',
    '#': u'             \n   **    **  \n ************\n///**////**/ \n  /**   /**  \n ************\n///**////**/ \n  //    //   \n',
    "'": u' **\n//*\n / \n   \n   \n   \n   \n   \n',
    '+': u'           \n      *    \n     /*    \n  *********\n /////*/// \n     /*    \n     /     \n           \n',
    '/': u'       **\n      ** \n     **  \n    **   \n   **    \n  **     \n **      \n//       \n',
    '3': u'  **** \n */// *\n/    /*\n   *** \n  /// *\n *   /*\n/ **** \n ////  \n',
    '7': u' ******\n//////*\n     /*\n     * \n    *  \n   *   \n  *    \n /     \n',
    ';': u'   \n   \n   \n **\n// \n **\n//*\n / \n',
    '?': u'  **** \n **//**\n/** /**\n//  ** \n   **  \n  //   \n   **  \n  //   \n',
    'C': u'   ****** \n  **////**\n **    // \n/**       \n/**       \n//**    **\n //****** \n  //////  \n',
    'G': u'   ******** \n  **//////**\n **      // \n/**         \n/**    *****\n//**  ////**\n //******** \n  ////////  \n',
    'K': u' **   **\n/**  ** \n/** **  \n/****   \n/**/**  \n/**//** \n/** //**\n//   // \n',
    'O': u'   *******  \n  **/////** \n **     //**\n/**      /**\n/**      /**\n//**     ** \n //*******  \n  ///////   \n',
    'S': u'  ********\n **////// \n/**       \n/*********\n////////**\n       /**\n ******** \n////////  \n',
    'W': u' **       **\n/**      /**\n/**   *  /**\n/**  *** /**\n/** **/**/**\n/**** //****\n/**/   ///**\n//       // \n',
    '[': u' *****\n/**// \n/**   \n/**   \n/**   \n/**   \n/*****\n///// \n',
    '_': u'      \n      \n      \n      \n      \n      \n *****\n///// \n',
    'c': u'        \n        \n  ***** \n **///**\n/**  // \n/**   **\n//***** \n /////  \n',
    'g': u'        \n  ***** \n **///**\n/**  /**\n//******\n /////**\n  ***** \n /////  \n',
    'k': u' **    \n/**    \n/**  **\n/** ** \n/****  \n/**/** \n/**//**\n//  // \n',
    'o': u'         \n         \n  ****** \n **////**\n/**   /**\n/**   /**\n//****** \n //////  \n',
    's': u'        \n        \n  ******\n **//// \n//***** \n /////**\n ****** \n//////  \n',
    'w': u'           \n           \n ***     **\n//**  * /**\n /** ***/**\n /****/****\n ***/ ///**\n///    /// \n',
    '{': u'    ***\n   **/ \n  /**  \n ***   \n///**  \n  /**  \n  //***\n   /// \n',
    '"': u' *  *\n/* /*\n/  / \n     \n     \n     \n     \n     \n',
    '&': u'   **   \n  */ *  \n / **   \n  */ * *\n *  / * \n/*   /* \n/ **** *\n //// / \n',
    '*': u'       **      \n  **  /**   ** \n //** /**  **  \n **************\n///**//**//**/ \n  **  /** //** \n //   /**  //  \n      //       \n',
    '.': u'   \n   \n   \n   \n   \n **\n/**\n// \n',
    '2': u'  **** \n */// *\n/    /*\n   *** \n  *//  \n *     \n/******\n////// \n',
    '6': u'  **** \n */// *\n/*   / \n/***** \n/*/// *\n/*   /*\n/ **** \n ////  \n',
    ':': u'   \n   \n   \n   \n **\n// \n **\n// \n',
    '>': u' **      \n// **    \n  // **  \n    // **\n     **/ \n   **/   \n **/     \n//       \n',
    'B': u' ******  \n/*////** \n/*   /** \n/******  \n/*//// **\n/*    /**\n/******* \n///////  \n',
    'F': u' ********\n/**///// \n/**      \n/******* \n/**////  \n/**      \n/**      \n//       \n',
    'J': u'      **\n     /**\n     /**\n     /**\n     /**\n **  /**\n//***** \n /////  \n',
    'N': u' ****     **\n/**/**   /**\n/**//**  /**\n/** //** /**\n/**  //**/**\n/**   //****\n/**    //***\n//      /// \n',
    'R': u' *******  \n/**////** \n/**   /** \n/*******  \n/**///**  \n/**  //** \n/**   //**\n//     // \n',
    'V': u' **      **\n/**     /**\n/**     /**\n//**    ** \n //**  **  \n  //****   \n   //**    \n    //     \n',
    'Z': u' ********\n//////** \n     **  \n    **   \n   **    \n  **     \n ********\n//////// \n',
    '^': u'     **    \n   **/ **  \n **   // **\n//      // \n           \n           \n           \n           \n',
    'b': u' **     \n/**     \n/**     \n/****** \n/**///**\n/**  /**\n/****** \n/////   \n',
    'f': u'   ****\n  /**/ \n ******\n///**/ \n  /**  \n  /**  \n  /**  \n  //   \n',
    'j': u'    **\n   // \n    **\n   /**\n   /**\n **/**\n//*** \n ///  \n',
    'n': u'         \n         \n ******* \n//**///**\n /**  /**\n /**  /**\n ***  /**\n///   // \n',
    'r': u'       \n       \n ******\n//**//*\n /** / \n /**   \n/***   \n///    \n',
    'v': u'         \n         \n **    **\n/**   /**\n//** /** \n //****  \n  //**   \n   //    \n',
    'z': u'       \n       \n ******\n////** \n   **  \n  **   \n ******\n////// \n',
    '~': u' **  *** \n//***//**\n ///  // \n         \n         \n         \n         \n         \n',
    '!': u' **\n/**\n/**\n/**\n/**\n// \n **\n// \n',
    '%': u'         \n **   ** \n//   **  \n    **   \n   **    \n  **     \n **   ** \n//   //  \n',
    ')': u' **  \n//** \n //**\n  /**\n  /**\n  ** \n **  \n//   \n',
    '-': u'      \n      \n      \n *****\n///// \n      \n      \n      \n',
    '1': u'  ** \n *** \n//** \n /** \n /** \n /** \n ****\n//// \n',
    '5': u' ******\n/*//// \n/***** \n///// *\n     /*\n *   /*\n/ **** \n ////  \n',
    '9': u'  **** \n */// *\n/*   /*\n/ **** \n ///*  \n   *   \n  *    \n /     \n',
    '=': u'       \n       \n ******\n////// \n ******\n////// \n       \n       \n',
    'A': u'     **    \n    ****   \n   **//**  \n  **  //** \n **********\n/**//////**\n/**     /**\n//      // \n',
    'E': u' ********\n/**///// \n/**      \n/******* \n/**////  \n/**      \n/********\n//////// \n',
    'I': u' **\n/**\n/**\n/**\n/**\n/**\n/**\n// \n',
    'M': u' ****     ****\n/**/**   **/**\n/**//** ** /**\n/** //***  /**\n/**  //*   /**\n/**   /    /**\n/**        /**\n//         // \n',
    'Q': u'   *******   \n  **/////**  \n **     //** \n/**      /** \n/**    **/** \n//**  // **  \n //******* **\n  /////// // \n',
    'U': u' **     **\n/**    /**\n/**    /**\n/**    /**\n/**    /**\n/**    /**\n//******* \n ///////  \n',
    'Y': u' **    **\n//**  ** \n //****  \n  //**   \n   /**   \n   /**   \n   /**   \n   //    \n',
    ']': u' *****\n////**\n   /**\n   /**\n   /**\n   /**\n *****\n///// \n',
    'a': u'          \n          \n  ******  \n //////** \n  ******* \n **////** \n//********\n //////// \n',
    'e': u'        \n        \n  ***** \n **///**\n/*******\n/**//// \n//******\n ////// \n',
    'i': u' **\n// \n **\n/**\n/**\n/**\n/**\n// \n',
    'm': u'            \n            \n ********** \n//**//**//**\n /** /** /**\n /** /** /**\n *** /** /**\n///  //  // \n',
    'q': u'        \n  ****  \n **//** \n/** /** \n//***** \n ////** \n    /***\n    /// \n',
    'u': u'        \n        \n **   **\n/**  /**\n/**  /**\n/**  /**\n//******\n ////// \n',
    'y': u'         \n  **   **\n //** ** \n  //***  \n   /**   \n   **    \n  **     \n //      \n',
    '}': u' ***   \n///**  \n  /**  \n  //***\n   **/ \n  /**  \n ***   \n///    \n'}

dic_3x5 = {
    ' ': u'    \n    \n    \n    \n    \n    \n',
    '$': u'    \n ## \n##  \n### \n ## \n##  \n',
    '(': u'    \n  # \n #  \n #  \n #  \n  # \n',
    ',': u'    \n    \n    \n    \n #  \n#   \n',
    '0': u'    \n### \n# # \n# # \n# # \n### \n',
    '4': u'    \n# # \n# # \n### \n  # \n  # \n',
    '8': u'    \n### \n# # \n### \n# # \n### \n',
    '<': u'    \n  # \n #  \n#   \n #  \n  # \n',
    '@': u'    \n### \n# # \n#   \n### \n    \n',
    'D': u'    \n##  \n# # \n# # \n# # \n##  \n',
    'H': u'    \n# # \n# # \n### \n# # \n# # \n',
    'L': u'    \n#   \n#   \n#   \n#   \n### \n',
    'P': u'    \n##  \n# # \n##  \n#   \n#   \n',
    'T': u'    \n### \n #  \n #  \n #  \n #  \n',
    'X': u'    \n# # \n# # \n #  \n# # \n# # \n',
    '\\': u'    \n#   \n#   \n #  \n  # \n  # \n',
    '`': u'    \n#   \n #  \n  # \n    \n    \n',
    'd': u'    \n  # \n### \n# # \n### \n    \n',
    'h': u'    \n#   \n### \n# # \n# # \n    \n',
    'l': u'    \n #  \n #  \n #  \n ## \n    \n',
    'p': u'    \n    \n### \n# # \n### \n#   \n',
    't': u'    \n #  \n### \n #  \n ## \n    \n',
    'x': u'    \n    \n# # \n #  \n# # \n    \n',
    '|': u'    \n #  \n #  \n #  \n #  \n #  \n',
    '#': u'    \n# # \n### \n# # \n### \n# # \n',
    "'": u'    \n  # \n #  \n#   \n    \n    \n',
    '+': u'    \n    \n #  \n### \n #  \n    \n',
    '/': u'    \n  # \n  # \n #  \n#   \n#   \n',
    '3': u'    \n### \n  # \n ## \n  # \n### \n',
    '7': u'    \n### \n  # \n  # \n  # \n  # \n',
    ';': u'    \n    \n #  \n    \n #  \n#   \n',
    '?': u'    \n### \n  # \n ## \n    \n #  \n',
    'C': u'    \n ## \n#   \n#   \n#   \n ## \n',
    'G': u'    \n ## \n#   \n# # \n# # \n ## \n',
    'K': u'    \n# # \n# # \n##  \n# # \n# # \n',
    'O': u'    \n #  \n# # \n# # \n# # \n #  \n',
    'S': u'    \n ## \n#   \n #  \n  # \n##  \n',
    'W': u'    \n# # \n# # \n### \n### \n# # \n',
    '[': u'    \n ## \n #  \n #  \n #  \n ## \n',
    '_': u'    \n    \n    \n    \n    \n### \n',
    'c': u'    \n    \n### \n#   \n### \n    \n',
    'g': u'    \n    \n### \n# # \n ## \n### \n',
    'k': u'    \n#   \n# # \n##  \n# # \n    \n',
    'o': u'    \n    \n### \n# # \n### \n    \n',
    's': u'    \n    \n ## \n #  \n##  \n    \n',
    'w': u'    \n    \n# # \n### \n### \n    \n',
    '{': u'    \n ## \n #  \n##  \n #  \n ## \n',
    '"': u'    \n# # \n# # \n    \n    \n    \n',
    '&': u'    \n #  \n#   \n ## \n# # \n### \n',
    '*': u'    \n #  \n### \n #  \n### \n #  \n',
    '.': u'    \n    \n    \n    \n    \n #  \n',
    '2': u'    \n### \n  # \n### \n#   \n### \n',
    '6': u'    \n### \n#   \n### \n# # \n### \n',
    ':': u'    \n    \n #  \n    \n #  \n    \n',
    '>': u'    \n#   \n #  \n  # \n #  \n#   \n',
    'B': u'    \n##  \n# # \n##  \n# # \n##  \n',
    'F': u'    \n### \n#   \n##  \n#   \n#   \n',
    'J': u'    \n ## \n  # \n  # \n# # \n #  \n',
    'N': u'    \n### \n# # \n# # \n# # \n# # \n',
    'R': u'    \n##  \n# # \n##  \n# # \n# # \n',
    'V': u'    \n# # \n# # \n# # \n# # \n #  \n',
    'Z': u'    \n### \n  # \n #  \n#   \n### \n',
    '^': u'    \n #  \n# # \n    \n    \n    \n',
    'b': u'    \n#   \n### \n# # \n### \n    \n',
    'f': u'    \n ## \n #  \n### \n #  \n##  \n',
    'j': u'    \n #  \n    \n #  \n #  \n#   \n',
    'n': u'    \n    \n##  \n# # \n# # \n    \n',
    'r': u'    \n    \n### \n#   \n#   \n    \n',
    'v': u'    \n    \n# # \n# # \n #  \n    \n',
    'z': u'    \n    \n##  \n #  \n ## \n    \n',
    '~': u'    \n  # \n### \n#   \n    \n    \n',
    '!': u'    \n #  \n #  \n #  \n    \n #  \n',
    '%': u'    \n# # \n  # \n #  \n#   \n# # \n',
    ')': u'    \n#   \n #  \n #  \n #  \n#   \n',
    '-': u'    \n    \n    \n### \n    \n    \n',
    '1': u'    \n #  \n##  \n #  \n #  \n### \n',
    '5': u'    \n### \n#   \n### \n  # \n### \n',
    '9': u'    \n### \n# # \n### \n  # \n### \n',
    '=': u'    \n    \n### \n    \n### \n    \n',
    'A': u'    \n #  \n# # \n### \n# # \n# # \n',
    'E': u'    \n### \n#   \n##  \n#   \n### \n',
    'I': u'    \n### \n #  \n #  \n #  \n### \n',
    'M': u'    \n# # \n### \n### \n# # \n# # \n',
    'Q': u'    \n #  \n# # \n# # \n ## \n  # \n',
    'U': u'    \n# # \n# # \n# # \n# # \n### \n',
    'Y': u'    \n# # \n# # \n #  \n #  \n #  \n',
    ']': u'    \n##  \n #  \n #  \n #  \n##  \n',
    'a': u'    \n    \n ## \n# # \n### \n    \n',
    'e': u'    \n    \n### \n##  \n### \n    \n',
    'i': u'    \n #  \n    \n #  \n ## \n    \n',
    'm': u'    \n    \n### \n### \n# # \n    \n',
    'q': u'    \n    \n### \n# # \n### \n  # \n',
    'u': u'    \n    \n# # \n# # \n### \n    \n',
    'y': u'    \n    \n# # \n### \n  # \n### \n',
    '}': u'    \n##  \n #  \n ## \n #  \n##  \n'}


dic_5lineoblique = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u'           \n           \n    __//_  \n   ( //  ) \n    \\\\     \n(__//_)    \n  //       \n',
    '(': u'        \n        \n     _  \n   //   \n  //    \n //     \n((      \n',
    ',': u'    \n    \n    \n    \n    \n    \n // \n',
    '0': u'            \n            \n     ___    \n   //   ) ) \n  //   / /  \n //   / /   \n((___/ /    \n',
    '4': u'           \n           \n           \n //___/ /  \n/____  /   \n    / /    \n   / /     \n',
    '8': u'           \n           \n     __    \n   //  ) ) \n  ((_ / /  \n //  ) )   \n((__/ /    \n',
    '<': u'    \n    \n    \n // \n<<  \n \\\\ \n    \n',
    '@': u'          \n          \n   __     \n //  ) )  \n//  / /   \n\\\\ () ) ) \n \\\\__/ /  \n',
    'D': u'              \n              \n    //    ) ) \n   //    / /  \n  //    / /   \n //    / /    \n//____/ /     \n',
    'H': u'              \n              \n    //    / / \n   //___ / /  \n  / ___   /   \n //    / /    \n//    / /     \n',
    'L': u'           \n           \n    / /    \n   / /     \n  / /      \n / /       \n/ /____/ / \n',
    'P': u'             \n             \n    //   ) ) \n   //___/ /  \n  / ____ /   \n //          \n//           \n',
    'T': u'           \n           \n /__  ___/ \n   / /     \n  / /      \n / /       \n/ /        \n',
    'X': u'        \n        \n \\\\ / / \n  \\  /  \n  / /   \n / /\\\\  \n/ /  \\\\ \n',
    '\\': u'      \n      \n      \n\\\\    \n \\\\   \n  \\\\  \n   \\\\ \n',
    '`': u'   \n   \n   \n\\\\ \n   \n   \n   \n',
    'd': u'             \n             \n             \n    ___   /  \n  //   ) /   \n //   / /    \n((___/ /     \n',
    'h': u'           \n           \n           \n   / __    \n  //   ) ) \n //   / /  \n//   / /   \n',
    'l': u'       \n       \n       \n   //  \n  //   \n //    \n//     \n',
    'p': u'           \n           \n           \n    ___    \n  //   ) ) \n //___/ /  \n//         \n',
    't': u'         \n         \n         \n __  ___ \n  / /    \n / /     \n/ /      \n',
    'x': u'       \n       \n       \n       \n\\\\ / / \n \\/ /  \n / /\\  \n',
    '|': u'   \n   \n   \n|| \n|| \n|| \n|| \n',
    '#': u'          \n          \n  __/__/_ \n __/__/_  \n  /  /    \n          \n          \n',
    "'": u'    \n    \n // \n    \n    \n    \n    \n',
    '+': u'      \n      \n      \n      \n _||_ \n  ||  \n      \n',
    '/': u'      \n      \n      \n   // \n  //  \n //   \n//    \n',
    '3': u'           \n           \n    ___    \n  //   ) ) \n   __ / /  \n      ) )  \n((___/ /   \n',
    '7': u'          \n          \n  ___     \n//   / /  \n    / /   \n   / /    \n  / /     \n',
    ';': u'    \n    \n    \n    \n () \n    \n//  \n',
    '?': u'        \n        \n  __    \n((  ) ) \n   / /  \n  ( /   \n  ()    \n',
    'C': u'             \n             \n    //   ) ) \n   //        \n  //         \n //          \n((____/ /    \n',
    'G': u'             \n             \n    //   ) ) \n   //        \n  //  ____   \n //    / /   \n((____/ /    \n',
    'K': u'             \n             \n    //   / / \n   //__ / /  \n  //__  /    \n //   \\ \\    \n//     \\ \\   \n',
    'O': u'             \n             \n    //   ) ) \n   //   / /  \n  //   / /   \n //   / /    \n((___/ /     \n',
    'S': u'             \n             \n    //   ) ) \n   ((        \n     \\\\      \n       ) )   \n((___ / /    \n',
    'W': u'              \n              \n||   / |  / / \n||  /  | / /  \n|| / /||/ /   \n||/ / |  /    \n|  /  | /     \n',
    '[': u'         \n         \n      __ \n   / /   \n  / /    \n / /     \n/ /__    \n',
    '_': u'      \n      \n      \n      \n      \n      \n_____ \n',
    'c': u'           \n           \n           \n    ___    \n  //   ) ) \n //        \n((____     \n',
    'g': u'          \n          \n          \n   ___    \n //   ) ) \n((___/ /  \n //__     \n',
    'k': u'          \n          \n          \n   / ___  \n  //\\ \\   \n //  \\ \\  \n//    \\ \\ \n',
    'o': u'           \n           \n           \n    ___    \n  //   ) ) \n //   / /  \n((___/ /   \n',
    's': u'           \n           \n           \n    ___    \n  ((   ) ) \n   \\ \\     \n//   ) )   \n',
    'w': u'               \n               \n               \n               \n  //  / /  / / \n //  / /  / /  \n((__( (__/ /   \n',
    '{': u'       \n       \n     _ \n   //  \n <<    \n //    \n((_    \n',
    '"': u'     \n     \n | | \n     \n     \n     \n     \n',
    '&': u'         \n         \n ((   )) \n  \\\\ //  \n  /\\\\/   \n // \\\\   \n((___\\\\  \n',
    '*': u'       \n       \n       \n       \n _\\\\/_ \n  //\\  \n       \n',
    '.': u'   \n   \n   \n   \n   \n   \n() \n',
    '2': u'           \n           \n    ___    \n  //   ) ) \n   ___/ /  \n / ____/   \n/ /____    \n',
    '6': u'           \n           \n     ____  \n   //      \n  //__     \n //   ) )  \n((___/ /   \n',
    ':': u'    \n    \n    \n    \n () \n()  \n    \n',
    '>': u'    \n    \n    \n\\\\  \n >> \n//  \n    \n',
    'B': u'             \n             \n    //   ) ) \n   //___/ /  \n  / __  (    \n //    ) )   \n//____/ /    \n',
    'F': u'             \n             \n    //   / / \n   //___     \n  / ___      \n //          \n//           \n',
    'J': u'              \n              \n          / / \n         / /  \n        / /   \n       / /    \n ((___/ /     \n',
    'N': u'              \n              \n    /|    / / \n   //|   / /  \n  // |  / /   \n //  | / /    \n//   |/ /     \n',
    'R': u'             \n             \n    //   ) ) \n   //___/ /  \n  / ___ (    \n //   | |    \n//    | |    \n',
    'V': u'         \n         \n||   / / \n||  / /  \n|| / /   \n||/ /    \n|  /     \n',
    'Z': u'        \n ___    \n    / / \n   / /  \n  / /   \n / /    \n/ /___  \n',
    '^': u'      \n      \n /  | \n//| | \n      \n      \n      \n',
    'b': u'           \n           \n           \n   / __    \n  //   ) ) \n //   / /  \n((___/ /   \n',
    'f': u'            \n            \n    //  ) ) \n __//__     \n  //        \n //         \n//          \n',
    'j': u'            \n            \n            \n       ( )  \n      / /   \n     / /    \n((  / /     \n',
    'n': u'           \n           \n           \n     __    \n  //   ) ) \n //   / /  \n//   / /   \n',
    'r': u'          \n          \n          \n    __    \n  //  ) ) \n //       \n//        \n',
    'v': u'        \n        \n        \n        \n||  / / \n|| / /  \n||/ /   \n',
    'z': u'        \n        \n        \n ___    \n   / /  \n  / /   \n / /__  \n',
    '~': u'           \n           \n  _      _ \n// \\ \\_//  \n           \n           \n           \n',
    '!': u'       \n       \n    // \n   //  \n  //   \n       \n//     \n',
    '%': u'      \n      \n() // \n  //  \n //   \n// () \n      \n',
    ')': u'       \n       \n    )) \n   //  \n  //   \n //    \n//     \n',
    '-': u'      \n      \n      \n      \n____  \n      \n      \n',
    '1': u'          \n          \n          \n /_  /    \n  / /     \n / /      \n/ /       \n',
    '5': u'           \n           \n     ____  \n   //      \n  //__     \n      ) )  \n((___/ /   \n',
    '9': u'           \n           \n   ___     \n //   / /  \n((___/ /   \n    / /    \n   / /     \n',
    '=': u'      \n      \n      \n  ___ \n /__/ \n /__/ \n      \n',
    'A': u'           \n           \n    // | | \n   //__| | \n  / ___  | \n //    | | \n//     | | \n',
    'E': u'             \n             \n    //   / / \n   //____    \n  / ____     \n //          \n//____/ /    \n',
    'I': u'             \n   ___   ___ \n      / /    \n     / /     \n    / /      \n   / /       \n__/ /___     \n',
    'M': u'                \n                \n    /|    //| | \n   //|   // | | \n  // |  //  | | \n //  | //   | | \n//   |//    | | \n',
    'Q': u'              \n              \n    //    ) ) \n   //    / /  \n  //    / /   \n //  \\ \\ /    \n((____\\ \\     \n',
    'U': u'             \n             \n    //   / / \n   //   / /  \n  //   / /   \n //   / /    \n((___/ /     \n',
    'Y': u'          \n          \n\\\\    / / \n \\\\  / /  \n  \\\\/ /   \n   / /    \n  / /     \n',
    ']': u'         \n         \n   ___   \n     / / \n    / /  \n   / /   \n__/ /    \n',
    'a': u'           \n           \n           \n    ___    \n  //   ) ) \n //   / /  \n((___( (   \n',
    'e': u'           \n           \n           \n    ___    \n  //___) ) \n //        \n((____     \n',
    'i': u'        \n        \n        \n   ( )  \n  / /   \n / /    \n/ /     \n',
    'm': u'              \n              \n              \n    _   __    \n  // ) )  ) ) \n // / /  / /  \n// / /  / /   \n',
    'q': u'          \n          \n          \n   ___    \n //   ) ) \n((___/ /  \n    ( (   \n',
    'u': u'           \n           \n           \n           \n  //   / / \n //   / /  \n((___( (   \n',
    'y': u'          \n          \n          \n          \n //   / / \n((___/ /  \n    / /   \n',
    '}': u'      \n      \n  _   \n   )) \n  //  \n  >>  \n//    \n'}

alphabet_dic = {
    ' ': u' \n \n \n \n \n \n \n',
    '$': u'  $ $   \n $$$$$  \n$ $ $   \n $$$$$  \n  $ $ $ \n $$$$$  \n  $ $   \n',
    '(': u' (( \n((  \n((  \n((  \n (( \n    \n    \n',
    ',': u'   \n   \n   \n   \n,, \n , \n   \n',
    '0': u' 000  \n0  00 \n0 0 0 \n00  0 \n 000  \n      \n      \n',
    '4': u'4  4 \n4  4 \n4444 \n   4 \n   4 \n     \n     \n',
    '8': u' 888  \n8   8 \n 888  \n8   8 \n 888  \n      \n      \n',
    '<': u'  << \n <<  \n<<   \n <<  \n  << \n     \n     \n',
    '@': u' @@@  \n@   @ \n@  @@ \n@     \n @@@  \n      \n      \n',
    'D': u'DDD  \nD  D \nD  D \nD  D \nDDD  \n     \n     \n',
    'H': u'H  H \nH  H \nHHHH \nH  H \nH  H \n     \n     \n',
    'L': u'L    \nL    \nL    \nL    \nLLLL \n     \n     \n',
    'P': u'PPPP  \nP   P \nPPPP  \nP     \nP     \n      \n      \n',
    'T': u'TTTTTT \n  TT   \n  TT   \n  TT   \n  TT   \n       \n       \n',
    'X': u'X   X \n X X  \n  X   \n X X  \nX   X \n      \n      \n',
    '\\': u'\\\\    \n \\\\   \n  \\\\  \n   \\\\ \n    \\\\\n      \n      \n',
    '`': u'`` \n   \n   \n   \n   \n   \n   \n',
    'd': u'   d \n   d \n ddd \nd  d \n ddd \n     \n     \n',
    'h': u'h    \nh    \nhhh  \nh  h \nh  h \n     \n     \n',
    'l': u'l \nl \nl \nl \nl \n  \n  \n',
    'p': u'     \n     \nppp  \np  p \nppp  \np    \np    \n',
    't': u' t  \n t  \nttt \n t  \n tt \n    \n    \n',
    'x': u'    \n    \nx x \n x  \nx x \n    \n    \n',
    '|': u'||\n||\n||\n||\n||\n||\n  \n',
    '#': u' # #  \n##### \n # #  \n##### \n # #  \n      \n      \n',
    "'": u"'' \n'' \n   \n   \n   \n   \n   \n",
    '+': u'    \n +  \n+++ \n +  \n    \n    \n    \n',
    '/': u'    //\n   // \n  //  \n //   \n//    \n      \n      \n',
    '3': u'333  \n   3 \n 33  \n   3 \n333  \n     \n     \n',
    '7': u'77777 \n   7  \n  7   \n  7   \n  7   \n      \n      \n',
    ';': u'   \n;; \n   \n;; \n ; \n   \n   \n',
    '?': u' ???  \n?   ? \n   ?  \n  ?   \n  ?   \n      \n      \n',
    'C': u' CCC \nC    \nC    \nC    \n CCC \n     \n     \n',
    'G': u' GGG  \nG     \nG  GG \nG   G \n GGG  \n      \n      \n',
    'K': u'K  K \nK K  \nKK   \nK K  \nK  K \n     \n     \n',
    'O': u' OOO  \nO   O \nO   O \nO   O \n OOO  \n      \n      \n',
    'S': u' SSS  \nS     \n SSS  \n    S \nSSSS  \n      \n      \n',
    'W': u'W     W \nW     W \nW  W  W \n W W W  \n  W W   \n        \n        \n',
    '[': u'[[[[ \n[[   \n[[   \n[[   \n[[[[ \n     \n     \n',
    '_': u'    \n    \n    \n    \n____\n____\n    \n',
    'c': u'     \n     \n ccc \nc    \n ccc \n     \n     \n',
    'g': u'    \n    \nggg \ng g \nggg \n  g \nggg \n',
    'k': u'k    \nk k  \nkk   \nk k  \nk  k \n     \n     \n',
    'o': u'    \n    \nooo \no o \nooo \n    \n    \n',
    's': u'    \n    \n ss \n s  \nss  \n    \n    \n',
    'w': u'      \n      \nw   w \nw w w \n w w  \n      \n      \n',
    '{': u'  {{ \n {{  \n{{   \n {{  \n  {{ \n     \n     \n',
    '"': u"'' '' \n'' '' \n      \n      \n      \n      \n      \n",
    '&': u' &&   \n&  &  \n &&& &\n& & & \n &&&& \n      \n      \n',
    '*': u'      \n* * * \n ***  \n***** \n ***  \n* * * \n      \n',
    '.': u'   \n   \n   \n.. \n.. \n   \n   \n',
    '2': u' 22  \n2  2 \n  2  \n 2   \n2222 \n     \n     \n',
    '6': u'  6   \n 6    \n6666  \n6   6 \n 666  \n      \n      \n',
    ':': u'   \n:: \n   \n:: \n   \n   \n   \n',
    '>': u'>>   \n >>  \n  >> \n >>  \n>>   \n     \n     \n',
    'B': u'BBBB  \nB   B \nBBBB  \nB   B \nBBBB  \n      \n      \n',
    'F': u'FFFF \nF    \nFFF  \nF    \nF    \n     \n     \n',
    'J': u'    J \n    J \n    J \nJ   J \n JJJ  \n      \n      \n',
    'N': u'N   N \nNN  N \nN N N \nN  NN \nN   N \n      \n      \n',
    'R': u'RRRR  \nR   R \nRRRR  \nR R   \nR  RR \n      \n      \n',
    'V': u'V     V \nV     V \n V   V  \n  V V   \n   V    \n        \n        \n',
    'Z': u'ZZZZZ \n   Z  \n  Z   \n Z    \nZZZZZ \n      \n      \n',
    '^': u' ^^  \n^  ^ \n     \n     \n     \n     \n     \n',
    'b': u'b    \nb    \nbbb  \nb  b \nbbb  \n     \n     \n',
    'f': u' ff \n f  \nfff \n f  \n f  \n    \n    \n',
    'j': u'     \n   j \n     \n   j \n   j \nj  j \n jj  \n',
    'n': u'     \n     \nnnn  \nn  n \nn  n \n     \n     \n',
    'r': u'    \n    \nrrr \nr   \nr   \n    \n    \n',
    'v': u'    \n    \nv v \nv v \n v  \n    \n    \n',
    'z': u'    \n    \nzz  \n z  \n zz \n    \n    \n',
    '~': u'     \n ~ ~ \n~ ~  \n     \n     \n     \n     \n',
    '!': u'!!! \n!!! \n!!! \n    \n!!! \n    \n    \n',
    '%': u'%   %% \n   %%  \n  %%   \n %%    \n%%   % \n       \n       \n',
    ')': u'))  \n )) \n )) \n )) \n))  \n    \n    \n',
    '-': u'    \n    \n--- \n    \n    \n    \n    \n',
    '1': u' 11  \n111  \n 11  \n 11  \n11l1 \n     \n     \n',
    '5': u'5555 \n5    \n555  \n   5 \n555  \n     \n     \n',
    '9': u' 9999 \n9   9 \n 9999 \n   9  \n  9   \n      \n      \n',
    '=': u'    \n=== \n    \n=== \n    \n    \n    \n',
    'A': u' AA  \nA  A \nAAAA \nA  A \nA  A \n     \n     \n',
    'E': u'EEEE \nE    \nEEE  \nE    \nEEEE \n     \n     \n',
    'I': u'III \n I  \n I  \n I  \nIII \n    \n    \n',
    'M': u'M   M \nMM MM \nM M M \nM   M \nM   M \n      \n      \n',
    'Q': u' QQQ   \nQ   Q  \nQ   Q  \nQ  QQ  \n QQQQ  \n     Q \n       \n',
    'U': u'U   U \nU   U \nU   U \nU   U \n UUU  \n      \n      \n',
    'Y': u'Y   Y \n Y Y  \n  Y   \n  Y   \n  Y   \n      \n      \n',
    ']': u']]]] \n  ]] \n  ]] \n  ]] \n]]]] \n     \n     \n',
    'a': u'    \n    \n aa \na a \naaa \n    \n    \n',
    'e': u'    \n    \neee \ne e \nee  \n    \n    \n',
    'i': u'   \nii \n   \nii \nii \n   \n   \n',
    'm': u'      \n      \nmmmm  \nm m m \nm m m \n      \n      \n',
    'q': u'      \n      \n qqq  \nq  q  \n qqq  \n   q  \n   qq \n',
    'u': u'     \n     \nu  u \nu  u \n uuu \n     \n     \n',
    'y': u'     \n     \ny  y \ny  y \n yyy \n   y \nyyy  \n',
    '}': u'}}   \n }}  \n  }} \n }}  \n}}   \n     \n     \n'}


banner3_dic = {
    '!': u'#### \n#### \n#### \n ##  \n     \n#### \n#### \n',
    ' ': u'   \n   \n   \n   \n   \n   \n   \n',
    '#': u'  ## ##   \n  ## ##   \n######### \n  ## ##   \n######### \n  ## ##   \n  ## ##   \n',
    '"': u'#### #### \n#### #### \n ##   ##  \n          \n          \n          \n          \n',
    '%': u'#####   ##   \n## ##  ##    \n##### ##     \n     ##      \n    ## ##### \n   ##  ## ## \n  ##   ##### \n',
    '$': u' ########  \n##  ##  ## \n##  ##     \n ########  \n    ##  ## \n##  ##  ## \n ########  \n',
    "'": u'#### \n#### \n ##  \n##   \n     \n     \n     \n',
    '&': u'  ####    \n ##  ##   \n  ####    \n ####     \n##  ## ## \n##   ##   \n ####  ## \n',
    ')': u'###   \n  ##  \n   ## \n   ## \n   ## \n  ##  \n###   \n',
    '(': u'  ### \n ##   \n##    \n##    \n##    \n ##   \n  ### \n',
    '+': u'       \n  ##   \n  ##   \n###### \n  ##   \n  ##   \n       \n',
    '*': u'          \n ##   ##  \n  ## ##   \n######### \n  ## ##   \n ##   ##  \n          \n',
    '-': u'        \n        \n        \n####### \n        \n        \n        \n',
    ',': u'     \n     \n     \n#### \n#### \n ##  \n##   \n',
    '/': u'      ## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n##       \n',
    '.': u'    \n    \n    \n    \n    \n### \n### \n',
    '1': u'   ##   \n ####   \n   ##   \n   ##   \n   ##   \n   ##   \n ###### \n',
    '0': u'  #####   \n ##   ##  \n##     ## \n##     ## \n##     ## \n ##   ##  \n  #####   \n',
    '3': u' #######  \n##     ## \n       ## \n #######  \n       ## \n##     ## \n #######  \n',
    '2': u' #######  \n##     ## \n       ## \n #######  \n##        \n##        \n######### \n',
    '5': u'######## \n##       \n##       \n#######  \n      ## \n##    ## \n ######  \n',
    '4': u'##        \n##    ##  \n##    ##  \n##    ##  \n######### \n      ##  \n      ##  \n',
    '7': u'######## \n##    ## \n    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n',
    '6': u' #######  \n##     ## \n##        \n########  \n##     ## \n##     ## \n #######  \n',
    '9': u' #######  \n##     ## \n##     ## \n ######## \n       ## \n##     ## \n #######  \n',
    '8': u' #######  \n##     ## \n##     ## \n #######  \n##     ## \n##     ## \n #######  \n',
    ';': u'#### \n#### \n     \n#### \n#### \n ##  \n##   \n',
    ':': u' ##  \n#### \n ##  \n     \n ##  \n#### \n ##  \n',
    '=': u'      \n      \n##### \n      \n##### \n      \n      \n',
    '<': u'   ## \n  ##  \n ##   \n##    \n ##   \n  ##  \n   ## \n',
    '?': u' #######  \n##     ## \n      ##  \n    ###   \n   ##     \n          \n   ##     \n',
    '>': u'##    \n ##   \n  ##  \n   ## \n  ##  \n ##   \n##    \n',
    '@': u' #######  \n##     ## \n## ### ## \n## ### ## \n## #####  \n##        \n #######  \n',
    '[': u'###### \n##     \n##     \n##     \n##     \n##     \n###### \n',
    ']': u'###### \n    ## \n    ## \n    ## \n    ## \n    ## \n###### \n',
    '\\': u'##       \n ##      \n  ##     \n   ##    \n    ##   \n     ##  \n      ## \n',
    '_': u'        \n        \n        \n        \n        \n        \n####### \n',
    '^': u'  ###   \n ## ##  \n##   ## \n        \n        \n        \n        \n',
    'a': u'   ###    \n  ## ##   \n ##   ##  \n##     ## \n######### \n##     ## \n##     ## \n',
    '`': u'#### \n#### \n ##  \n  ## \n     \n     \n     \n',
    'c': u' ######  \n##    ## \n##       \n##       \n##       \n##    ## \n ######  \n',
    'b': u'########  \n##     ## \n##     ## \n########  \n##     ## \n##     ## \n########  \n',
    'e': u'######## \n##       \n##       \n######   \n##       \n##       \n######## \n',
    'd': u'########  \n##     ## \n##     ## \n##     ## \n##     ## \n##     ## \n########  \n',
    'g': u' ######   \n##    ##  \n##        \n##   #### \n##    ##  \n##    ##  \n ######   \n',
    'f': u'######## \n##       \n##       \n######   \n##       \n##       \n##       \n',
    'i': u'#### \n ##  \n ##  \n ##  \n ##  \n ##  \n#### \n',
    'h': u'##     ## \n##     ## \n##     ## \n######### \n##     ## \n##     ## \n##     ## \n',
    'k': u'##    ## \n##   ##  \n##  ##   \n#####    \n##  ##   \n##   ##  \n##    ## \n',
    'j': u'      ## \n      ## \n      ## \n      ## \n##    ## \n##    ## \n ######  \n',
    'm': u'##     ## \n###   ### \n#### #### \n## ### ## \n##     ## \n##     ## \n##     ## \n',
    'l': u'##       \n##       \n##       \n##       \n##       \n##       \n######## \n',
    'o': u' #######  \n##     ## \n##     ## \n##     ## \n##     ## \n##     ## \n #######  \n',
    'n': u'##    ## \n###   ## \n####  ## \n## ## ## \n##  #### \n##   ### \n##    ## \n',
    'q': u' #######  \n##     ## \n##     ## \n##     ## \n##  ## ## \n##    ##  \n ##### ## \n',
    'p': u'########  \n##     ## \n##     ## \n########  \n##        \n##        \n##        \n',
    's': u' ######  \n##    ## \n##       \n ######  \n      ## \n##    ## \n ######  \n',
    'r': u'########  \n##     ## \n##     ## \n########  \n##   ##   \n##    ##  \n##     ## \n',
    'u': u'##     ## \n##     ## \n##     ## \n##     ## \n##     ## \n##     ## \n #######  \n',
    't': u'######## \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n',
    'w': u'##      ## \n##  ##  ## \n##  ##  ## \n##  ##  ## \n##  ##  ## \n##  ##  ## \n ###  ###  \n',
    'v': u'##     ## \n##     ## \n##     ## \n##     ## \n ##   ##  \n  ## ##   \n   ###    \n',
    'y': u'##    ## \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n   ##    \n',
    'x': u'##     ## \n ##   ##  \n  ## ##   \n   ###    \n  ## ##   \n ##   ##  \n##     ## \n',
    '{': u'  #### \n ##    \n ##    \n###    \n ##    \n ##    \n  #### \n',
    'z': u'######## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n######## \n',
    '}': u'####   \n   ##  \n   ##  \n   ### \n   ##  \n   ##  \n####   \n',
    '|': u'## \n## \n## \n   \n## \n## \n## \n',
    '~': u' ####      \n##  ##  ## \n     ####  \n           \n           \n           \n           \n'}

banner4_dic = {
    '!': u'.####\n.####\n.####\n..##.\n.....\n.####\n.####\n',
    ' ': u'...\n...\n...\n...\n...\n...\n...\n',
    '#': u'...##.##..\n...##.##..\n.#########\n...##.##..\n.#########\n...##.##..\n...##.##..\n',
    '"': u'.####.####\n.####.####\n..##...##.\n..........\n..........\n..........\n..........\n',
    '%': u'.#####...##..\n.##.##..##...\n.#####.##....\n......##.....\n.....##.#####\n....##..##.##\n...##...#####\n',
    '$': u'..########.\n.##..##..##\n.##..##....\n..########.\n.....##..##\n.##..##..##\n..########.\n',
    "'": u'.####\n.####\n..##.\n.##..\n.....\n.....\n.....\n',
    '&': u'...####...\n..##..##..\n...####...\n..####....\n.##..##.##\n.##...##..\n..####..##\n',
    ')': u'.###..\n...##.\n....##\n....##\n....##\n...##.\n.###..\n',
    '(': u'...###\n..##..\n.##...\n.##...\n.##...\n..##..\n...###\n',
    '+': u'.......\n...##..\n...##..\n.######\n...##..\n...##..\n.......\n',
    '*': u'..........\n..##...##.\n...##.##..\n.#########\n...##.##..\n..##...##.\n..........\n',
    '-': u'........\n........\n........\n.#######\n........\n........\n........\n',
    ',': u'.....\n.....\n.....\n.####\n.####\n..##.\n.##..\n',
    '/': u'.......##\n......##.\n.....##..\n....##...\n...##....\n..##.....\n.##......\n',
    '.': u'....\n....\n....\n....\n....\n.###\n.###\n',
    '1': u'....##..\n..####..\n....##..\n....##..\n....##..\n....##..\n..######\n',
    '0': u'...#####..\n..##...##.\n.##.....##\n.##.....##\n.##.....##\n..##...##.\n...#####..\n',
    '3': u'..#######.\n.##.....##\n........##\n..#######.\n........##\n.##.....##\n..#######.\n',
    '2': u'..#######.\n.##.....##\n........##\n..#######.\n.##.......\n.##.......\n.#########\n',
    '5': u'.########\n.##......\n.##......\n.#######.\n.......##\n.##....##\n..######.\n',
    '4': u'.##.......\n.##....##.\n.##....##.\n.##....##.\n.#########\n.......##.\n.......##.\n',
    '7': u'.########\n.##....##\n.....##..\n....##...\n...##....\n...##....\n...##....\n',
    '6': u'..#######.\n.##.....##\n.##.......\n.########.\n.##.....##\n.##.....##\n..#######.\n',
    '9': u'..#######.\n.##.....##\n.##.....##\n..########\n........##\n.##.....##\n..#######.\n',
    '8': u'..#######.\n.##.....##\n.##.....##\n..#######.\n.##.....##\n.##.....##\n..#######.\n',
    ';': u'.####\n.####\n.....\n.####\n.####\n..##.\n.##..\n',
    ':': u'..##.\n.####\n..##.\n.....\n..##.\n.####\n..##.\n',
    '=': u'......\n......\n.#####\n......\n.#####\n......\n......\n',
    '<': u'....##\n...##.\n..##..\n.##...\n..##..\n...##.\n....##\n',
    '?': u'..#######.\n.##.....##\n.......##.\n.....###..\n....##....\n..........\n....##....\n',
    '>': u'.##...\n..##..\n...##.\n....##\n...##.\n..##..\n.##...\n',
    '@': u'..#######.\n.##.....##\n.##.###.##\n.##.###.##\n.##.#####.\n.##.......\n..#######.\n',
    '[': u'.######\n.##....\n.##....\n.##....\n.##....\n.##....\n.######\n',
    ']': u'.######\n.....##\n.....##\n.....##\n.....##\n.....##\n.######\n',
    '\\': u'.##......\n..##.....\n...##....\n....##...\n.....##..\n......##.\n.......##\n',
    '_': u'........\n........\n........\n........\n........\n........\n.#######\n',
    '^': u'...###..\n..##.##.\n.##...##\n........\n........\n........\n........\n',
    'a': u'....###...\n...##.##..\n..##...##.\n.##.....##\n.#########\n.##.....##\n.##.....##\n',
    '`': u'.####\n.####\n..##.\n...##\n.....\n.....\n.....\n',
    'c': u'..######.\n.##....##\n.##......\n.##......\n.##......\n.##....##\n..######.\n',
    'b': u'.########.\n.##.....##\n.##.....##\n.########.\n.##.....##\n.##.....##\n.########.\n',
    'e': u'.########\n.##......\n.##......\n.######..\n.##......\n.##......\n.########\n',
    'd': u'.########.\n.##.....##\n.##.....##\n.##.....##\n.##.....##\n.##.....##\n.########.\n',
    'g': u'..######..\n.##....##.\n.##.......\n.##...####\n.##....##.\n.##....##.\n..######..\n',
    'f': u'.########\n.##......\n.##......\n.######..\n.##......\n.##......\n.##......\n',
    'i': u'.####\n..##.\n..##.\n..##.\n..##.\n..##.\n.####\n',
    'h': u'.##.....##\n.##.....##\n.##.....##\n.#########\n.##.....##\n.##.....##\n.##.....##\n',
    'k': u'.##....##\n.##...##.\n.##..##..\n.#####...\n.##..##..\n.##...##.\n.##....##\n',
    'j': u'.......##\n.......##\n.......##\n.......##\n.##....##\n.##....##\n..######.\n',
    'm': u'.##.....##\n.###...###\n.####.####\n.##.###.##\n.##.....##\n.##.....##\n.##.....##\n',
    'l': u'.##......\n.##......\n.##......\n.##......\n.##......\n.##......\n.########\n',
    'o': u'..#######.\n.##.....##\n.##.....##\n.##.....##\n.##.....##\n.##.....##\n..#######.\n',
    'n': u'.##....##\n.###...##\n.####..##\n.##.##.##\n.##..####\n.##...###\n.##....##\n',
    'q': u'..#######.\n.##.....##\n.##.....##\n.##.....##\n.##..##.##\n.##....##.\n..#####.##\n',
    'p': u'.########.\n.##.....##\n.##.....##\n.########.\n.##.......\n.##.......\n.##.......\n',
    's': u'..######.\n.##....##\n.##......\n..######.\n.......##\n.##....##\n..######.\n',
    'r': u'.########.\n.##.....##\n.##.....##\n.########.\n.##...##..\n.##....##.\n.##.....##\n',
    'u': u'.##.....##\n.##.....##\n.##.....##\n.##.....##\n.##.....##\n.##.....##\n..#######.\n',
    't': u'.########\n....##...\n....##...\n....##...\n....##...\n....##...\n....##...\n',
    'w': u'.##......##\n.##..##..##\n.##..##..##\n.##..##..##\n.##..##..##\n.##..##..##\n..###..###.\n',
    'v': u'.##.....##\n.##.....##\n.##.....##\n.##.....##\n..##...##.\n...##.##..\n....###...\n',
    'y': u'.##....##\n..##..##.\n...####..\n....##...\n....##...\n....##...\n....##...\n',
    'x': u'.##.....##\n..##...##.\n...##.##..\n....###...\n...##.##..\n..##...##.\n.##.....##\n',
    '{': u'...####\n..##...\n..##...\n.###...\n..##...\n..##...\n...####\n',
    'z': u'.########\n......##.\n.....##..\n....##...\n...##....\n..##.....\n.########\n',
    '}': u'.####..\n....##.\n....##.\n....###\n....##.\n....##.\n.####..\n',
    '|': u'.##\n.##\n.##\n...\n.##\n.##\n.##\n',
    '~': u'..####.....\n.##..##..##\n......####.\n...........\n...........\n...........\n...........\n'}

banner3d_dic = {
    '!': u"'####:\n ####:\n ####:\n: ##::\n:..:::\n'####:\n ####:\n....::\n",
    ' ': u':::\n:::\n:::\n:::\n:::\n:::\n:::\n:::\n',
    '#': u"::'##'##:::\n:: ## ##:::\n'#########:\n.. ## ##.::\n'#########:\n.. ## ##.::\n:: ## ##:::\n::..:..::::\n",
    '"': u"'####'####:\n #### ####:\n. ##:. ##::\n:..:::..:::\n:::::::::::\n:::::::::::\n:::::::::::\n:::::::::::\n",
    '%': u"'#####::'##:::\n ## ##:'##::::\n #####'##:::::\n.....'##::::::\n::::'##'#####:\n:::'##: ## ##:\n::'##:: #####:\n::..:::.....::\n",
    '$': u":'########::\n'##. ##. ##:\n ##: ##:..::\n. ########::\n:... ##. ##:\n'##: ##: ##:\n. ########::\n:........:::\n",
    "'": u"'####:\n ####:\n. ##::\n'##:::\n..::::\n::::::\n::::::\n::::::\n",
    '&': u"::'####::::\n:'##. ##:::\n:. ####::::\n:'####:::::\n'##. ##'##:\n ##:. ##:::\n. ####. ##:\n:....::..::\n",
    ')': u"'###:::\n.. ##::\n::: ##:\n::: ##:\n::: ##:\n:: ##::\n ###:::\n...::::\n",
    '(': u"::'###:\n:'##:::\n'##::::\n ##::::\n ##::::\n. ##:::\n:. ###:\n::...::\n",
    '+': u"::::::::\n::'##:::\n:: ##:::\n'######:\n.. ##.::\n:: ##:::\n::..::::\n::::::::\n",
    '*': u":::::::::::\n:'##::'##::\n:. ##'##:::\n'#########:\n.. ## ##.::\n: ##:. ##::\n:..:::..:::\n:::::::::::\n",
    '-': u":::::::::\n:::::::::\n:::::::::\n'#######:\n........:\n:::::::::\n:::::::::\n:::::::::\n",
    ',': u"::::::\n::::::\n::::::\n'####:\n ####:\n. ##::\n'##:::\n..::::\n",
    '/': u"::::::'##:\n:::::'##::\n::::'##:::\n:::'##::::\n::'##:::::\n:'##::::::\n'##:::::::\n..::::::::\n",
    '.': u":::::\n:::::\n:::::\n:::::\n:::::\n'###:\n ###:\n...::\n",
    '1': u":::'##:::\n:'####:::\n:.. ##:::\n::: ##:::\n::: ##:::\n::: ##:::\n:'######:\n:......::\n",
    '0': u"::'#####:::\n:'##.. ##::\n'##:::: ##:\n ##:::: ##:\n ##:::: ##:\n. ##:: ##::\n:. #####:::\n::.....::::\n",
    '3': u":'#######::\n'##.... ##:\n..::::: ##:\n:'#######::\n:...... ##:\n'##:::: ##:\n. #######::\n:.......:::\n",
    '2': u":'#######::\n'##.... ##:\n..::::: ##:\n:'#######::\n'##::::::::\n ##::::::::\n #########:\n.........::\n",
    '5': u"'########:\n ##.....::\n ##:::::::\n #######::\n...... ##:\n'##::: ##:\n. ######::\n:......:::\n",
    '4': u"'##::::::::\n ##:::'##::\n ##::: ##::\n ##::: ##::\n #########:\n...... ##::\n:::::: ##::\n::::::..:::\n",
    '7': u"'########:\n ##..  ##:\n..:: ##:::\n::: ##::::\n:: ##:::::\n:: ##:::::\n:: ##:::::\n::..::::::\n",
    '6': u":'#######::\n'##.... ##:\n ##::::..::\n ########::\n ##.... ##:\n ##:::: ##:\n. #######::\n:.......:::\n",
    '9': u":'#######::\n'##.... ##:\n ##:::: ##:\n: ########:\n:...... ##:\n'##:::: ##:\n. #######::\n:.......:::\n",
    '8': u":'#######::\n'##.... ##:\n ##:::: ##:\n: #######::\n'##.... ##:\n ##:::: ##:\n. #######::\n:.......:::\n",
    ';': u"'####:\n ####:\n....::\n'####:\n ####:\n. ##::\n ##:::\n.:::::\n",
    ':': u":'##::\n'####:\n. ##::\n:..:::\n:'##::\n'####:\n. ##::\n:..:::\n",
    '=': u":::::::\n:::::::\n'#####:\n.....::\n'#####:\n.....::\n:::::::\n:::::::\n",
    '<': u":::'##:\n::'##::\n:'##:::\n'##::::\n. ##:::\n:. ##::\n::. ##:\n:::..::\n",
    '?': u":'#######::\n'##.... ##:\n..:::: ##::\n:::: ###:::\n::: ##.::::\n:::..::::::\n:::'##:::::\n:::..::::::\n",
    '>': u"'##::::\n. ##:::\n:. ##::\n::. ##:\n:: ##::\n: ##:::\n ##::::\n..:::::\n",
    '@': u":'#######::\n'##.... ##:\n ##'### ##:\n ## ### ##:\n ## #####::\n ##.....:::\n. #######::\n:.......:::\n",
    '[': u"'######:\n ##...::\n ##:::::\n ##:::::\n ##:::::\n ##:::::\n ######:\n......::\n",
    ']': u"'######:\n.... ##:\n:::: ##:\n:::: ##:\n:::: ##:\n:::: ##:\n'######:\n......::\n",
    '\\': u"'##:::::::\n. ##::::::\n:. ##:::::\n::. ##::::\n:::. ##:::\n::::. ##::\n:::::. ##:\n::::::..::\n",
    '_': u":::::::::\n:::::::::\n:::::::::\n:::::::::\n:::::::::\n:::::::::\n'#######:\n.......::\n",
    '^': u"::'###:::\n:'## ##::\n'##:. ##:\n..:::..::\n:::::::::\n:::::::::\n:::::::::\n:::::::::\n",
    'a': u":::'###::::\n::'## ##:::\n:'##:. ##::\n'##:::. ##:\n #########:\n ##.... ##:\n ##:::: ##:\n..:::::..::\n",
    '`': u"'####:\n ####:\n. ##::\n:. ##:\n::..::\n::::::\n::::::\n::::::\n",
    'c': u":'######::\n'##... ##:\n ##:::..::\n ##:::::::\n ##:::::::\n ##::: ##:\n. ######::\n:......:::\n",
    'b': u"'########::\n ##.... ##:\n ##:::: ##:\n ########::\n ##.... ##:\n ##:::: ##:\n ########::\n........:::\n",
    'e': u"'########:\n ##.....::\n ##:::::::\n ######:::\n ##...::::\n ##:::::::\n ########:\n........::\n",
    'd': u"'########::\n ##.... ##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n ########::\n........:::\n",
    'g': u":'######:::\n'##... ##::\n ##:::..:::\n ##::'####:\n ##::: ##::\n ##::: ##::\n. ######:::\n:......::::\n",
    'f': u"'########:\n ##.....::\n ##:::::::\n ######:::\n ##...::::\n ##:::::::\n ##:::::::\n..::::::::\n",
    'i': u"'####:\n. ##::\n: ##::\n: ##::\n: ##::\n: ##::\n'####:\n....::\n",
    'h': u"'##::::'##:\n ##:::: ##:\n ##:::: ##:\n #########:\n ##.... ##:\n ##:::: ##:\n ##:::: ##:\n..:::::..::\n",
    'k': u"'##:::'##:\n ##::'##::\n ##:'##:::\n #####::::\n ##. ##:::\n ##:. ##::\n ##::. ##:\n..::::..::\n",
    'j': u"::::::'##:\n:::::: ##:\n:::::: ##:\n:::::: ##:\n'##::: ##:\n ##::: ##:\n. ######::\n:......:::\n",
    'm': u"'##::::'##:\n ###::'###:\n ####'####:\n ## ### ##:\n ##. #: ##:\n ##:.:: ##:\n ##:::: ##:\n..:::::..::\n",
    'l': u"'##:::::::\n ##:::::::\n ##:::::::\n ##:::::::\n ##:::::::\n ##:::::::\n ########:\n........::\n",
    'o': u":'#######::\n'##.... ##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n. #######::\n:.......:::\n",
    'n': u"'##::: ##:\n ###:: ##:\n ####: ##:\n ## ## ##:\n ##. ####:\n ##:. ###:\n ##::. ##:\n..::::..::\n",
    'q': u":'#######::\n'##.... ##:\n ##:::: ##:\n ##:::: ##:\n ##:'## ##:\n ##:.. ##::\n. ##### ##:\n:.....:..::\n",
    'p': u"'########::\n ##.... ##:\n ##:::: ##:\n ########::\n ##.....:::\n ##::::::::\n ##::::::::\n..:::::::::\n",
    's': u":'######::\n'##... ##:\n ##:::..::\n. ######::\n:..... ##:\n'##::: ##:\n. ######::\n:......:::\n",
    'r': u"'########::\n ##.... ##:\n ##:::: ##:\n ########::\n ##.. ##:::\n ##::. ##::\n ##:::. ##:\n..:::::..::\n",
    'u': u"'##::::'##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n. #######::\n:.......:::\n",
    't': u"'########:\n... ##..::\n::: ##::::\n::: ##::::\n::: ##::::\n::: ##::::\n::: ##::::\n:::..:::::\n",
    'w': u"'##:::::'##:\n ##:'##: ##:\n ##: ##: ##:\n ##: ##: ##:\n ##: ##: ##:\n ##: ##: ##:\n. ###. ###::\n:...::...:::\n",
    'v': u"'##::::'##:\n ##:::: ##:\n ##:::: ##:\n ##:::: ##:\n. ##:: ##::\n:. ## ##:::\n::. ###::::\n:::...:::::\n",
    'y': u"'##:::'##:\n. ##:'##::\n:. ####:::\n::. ##::::\n::: ##::::\n::: ##::::\n::: ##::::\n:::..:::::\n",
    'x': u"'##::::'##:\n. ##::'##::\n:. ##'##:::\n::. ###::::\n:: ## ##:::\n: ##:. ##::\n ##:::. ##:\n..:::::..::\n",
    '{': u"::'####:\n:'##..::\n: ##::::\n'###::::\n. ##::::\n: ##::::\n:. ####:\n:::...::\n",
    'z': u"'########:\n..... ##::\n:::: ##:::\n::: ##::::\n:: ##:::::\n: ##::::::\n ########:\n........::\n",
    '}': u"'####:::\n... ##::\n::: ##::\n::: ###:\n::: ##::\n::: ##::\n'####:::\n....::::\n",
    '|': u"'##:\n ##:\n ##:\n..::\n'##:\n ##:\n ##:\n..::\n",
    '~': u":'####::::::\n'##  ##:'##:\n..::. ####::\n:::::....:::\n::::::::::::\n::::::::::::\n::::::::::::\n::::::::::::\n"}

bell_dic = {
    ' ': u'     \n     \n     \n     \n     \n     \n',
    '$': u'',
    '(': u'  ,\n / \n | \n | \n . \n  `\n',
    ',': u'  \n  \n  \n  \n ,\n /\n',
    '0': u"   ___/\n .'  /\\\n |  / |\n |,'  |\n /`---'\n       \n",
    '4': u'       \n |   | \n `.__| \n     | \n     | \n       \n',
    '8': u"  ___ \n /   \\\n >---<\n '   `\n `---'\n      \n",
    '<': u'',
    '@': u"  _____ \n / __. \\\n| /  | |\n| \\__| |\n|    `-'\n `----- \n",
    'D': u' .___  \n /   ` \n |    |\n |    |\n /---/ \n       \n',
    'H': u' __  __\n |   | \n |___| \n |   | \n /   / \n       \n',
    'L': u' .    \n /    \n |    \n |    \n /---/\n      \n',
    'P': u" .___ \n /   \\\n |,_-'\n |    \n /    \n      \n",
    'T': u"  _______\n '   /   \n     |   \n     |   \n     /   \n         \n",
    'X': u" _     _\n `.   / \n   \\,'  \n  ,'\\   \n /   \\  \n        \n",
    '\\': u'     \n \\   \n  \\  \n  `. \n   `.\n     \n',
    '`': u' ,\n \\\n  \n  \n  \n  \n',
    'd': u"      _\n   ___/\n  /   |\n ,'   |\n `___,'\n      `\n",
    'h': u" _     \n /     \n |,---.\n |'   `\n /    |\n       \n",
    'l': u'  .  \n  |  \n  |  \n  |  \n /\\__\n     \n',
    'p': u"       \n \\,___,\n |    \\\n |    |\n |`---'\n \\     \n",
    't': u'  .   \n _/_  \n  |   \n  |   \n  \\__/\n      \n',
    'x': u"      \n _  .-\n  \\,' \n  /\\  \n /  \\ \n      \n",
    '|': u' .\n |\n |\n |\n |\n `\n',
    '#': u"   .  .  \n  -|--|--\n   |  |  \n --|--|- \n   '  '  \n         \n",
    "'": u' ,\n /\n  \n  \n  \n  \n',
    '+': u"   ,   \n   |   \n .----'\n   |   \n   `   \n       \n",
    '/': u"     \n    /\n   / \n  ,' \n ,   \n     \n",
    '3': u"  ___ \n /   \\\n   _-'\n    \\ \n \\___)\n      \n",
    '7': u"  ___ \n '   \\\n   __/\n    /`\n   /  \n      \n",
    ';': u'  \n  \n /\n  \n ,\n /\n',
    '?': u"  __  \n /  `.\n `   '\n    / \n   ,  \n   '  \n",
    'C': u"   ___ \n .'   \\\n |     \n |     \n  `.__,\n       \n",
    'G': u"   ___  \n .'   \\ \n |      \n |    _ \n  `.___|\n        \n",
    'K': u" .    \n /   /\n |_-' \n |  \\ \n /   \\\n      \n",
    'O': u"   ___  \n .'   `.\n |     |\n |     |\n  `.__.'\n        \n",
    'S': u"   _____\n  (     \n   `--. \n      | \n \\___.' \n        \n",
    'W': u" .       __\n /       | \n |       | \n |  /\\   / \n |,'  \\,'  \n           \n",
    '[': u' __\n | \n | \n | \n | \n --\n',
    '_': u"        \n        \n        \n        \n ______,\n '      \n",
    'c': u"       \n   ___ \n .'   `\n |     \n  `._.'\n       \n",
    'g': u"       \n   ___.\n .'   `\n |    |\n  `---|\n  \\___/\n",
    'k': u' \\    \n |   ,\n |  / \n |-<  \n /  \\_\n      \n',
    'o': u"       \n   __. \n .'   \\\n |    |\n  `._.'\n       \n",
    's': u"       \n   ____\n  (    \n  `--. \n \\___.'\n       \n",
    'w': u"        \n ,  _  /\n |  |  |\n `  ^  '\n  \\/ \\/ \n        \n",
    '{': u'  _\n / \n_| \n | \n \\_\n   \n',
    '"': u' ,,\n //\n   \n   \n   \n   \n',
    '&': u'',
    '*': u"    .  \n `. | /\n   \\-' \n  ,|\\  \n / | \\ \n       \n",
    '.': u'  \n  \n  \n  \n /\n  \n',
    '2': u"  ___ \n /   \\\n   _-'\n  /   \n /___,\n      \n",
    '6': u"   __ \n .'   \n |---.\n |   |\n `._.'\n      \n",
    ':': u'  \n  \n /\n  \n /\n  \n',
    '>': u'',
    'B': u" ____  \n /   \\ \n |,_-< \n |    `\n `----'\n       \n",
    'F': u' .____\n /    \n |__. \n |    \n /    \n      \n',
    'J': u"  _______\n '   /   \n     |   \n     |   \n  `--/   \n         \n",
    'N': u' __    _\n |\\   | \n | \\  | \n |  \\ | \n |   \\| \n        \n',
    'R': u" .___ \n /   \\\n |__-'\n |  \\ \n /   \\\n      \n",
    'V': u' __    __\n |     | \n  \\    / \n   \\  /  \n    \\/   \n         \n',
    'Z': u"  _______ \n '      / \n    .--'  \n   /      \n ,'______/\n          \n",
    '^': u'',
    'b': u" _     \n \\ ___ \n |/   \\\n |    `\n `___,'\n       \n",
    'f': u' ,__ \n /  `\n |__ \n |   \n |   \n /   \n',
    'j': u'       \n     . \n     \\ \n     | \n /`  | \n \\___/`\n',
    'n': u"       \n , __  \n |'  `.\n |    |\n /    |\n       \n",
    'r': u"      \n .___ \n /   \\\n |   '\n /    \n      \n",
    'v': u'       \n _   __\n |   / \n `  /  \n  \\/   \n       \n',
    'z': u"      \n ____ \n    / \n  ,/  \n /__.'\n `    \n",
    '~': u' \n \n \n \n \n~\n',
    '!': u" /\n |\n |\n |\n `\n '\n",
    '%': u"  _   , \n / \\ /  \n \\_// _ \n   / / \\\n  /  \\_/\n '      \n",
    ')': u" . \n  \\\n  |\n  |\n  ,\n ' \n",
    '-': u"      \n      \n .---'\n      \n      \n      \n",
    '1': u'  . \n /| \n  | \n  | \n _|_\n    \n',
    '5': u"  ____\n |    \n `---.\n     |\n \\__.'\n      \n",
    '9': u"  ___ \n /   \\\n `---|\n     |\n `---'\n      \n",
    '=': u"        \n        \n ,-----'\n        \n ,-----'\n        \n",
    'A': u"     .   \n    /|   \n   /  \\  \n  /---'\\ \n,'      \\\n         \n",
    'E': u' .____ \n /     \n |__.  \n |     \n /----/\n       \n',
    'I': u' _\n |\n |\n |\n /\n  \n',
    'M': u' __   __\n |    | \n |\\  /| \n | \\/ | \n /    / \n        \n',
    'Q': u"   ___   \n .'   `. \n |     | \n |  ,_ | \n  `._.`-.\n         \n",
    'U': u" .     .\n /     /\n |     |\n |     |\n  `._.' \n        \n",
    'Y': u" _      _\n  `.   / \n    `./  \n    ,'   \n _-'     \n         \n",
    ']': u' __\n  |\n  |\n  |\n  |\n --\n',
    'a': u'       \n   ___ \n  /   `\n |    |\n `.__/|\n       \n',
    'e': u"       \n   ___ \n .'   `\n |----'\n `.___,\n       \n",
    'i': u'  \n `\n |\n |\n /\n  \n',
    'm': u"          \n , _ , _  \n |' `|' `.\n |   |   |\n /   '   /\n          \n",
    'q': u"        \n   ___. \n .'   ` \n |    | \n  `---|.\n      |/\n",
    'u': u'      \n ,   .\n |   |\n |   |\n `._/|\n      \n',
    'y': u'        \n ,    . \n |    ` \n |    | \n  `---|.\n  \\___/ \n',
    '}': u'_  \n \\ \n |_\n | \n_/ \n   \n'}

catwalk_dic = {
    ' ': u' \n \n \n \n \n \n \n \n',
    '$': u'   _//  \n _// _//\n_//     \n  _//   \n     _//\n_// _// \n  _//   \n        \n',
    '(': u'  _//\n _// \n_//  \n_//  \n_//  \n _// \n  _//\n     \n',
    ',': u'   \n   \n   \n   \n   \n   \n_//\n _/\n',
    '0': u'            \n    _//     \n  _//  _//  \n_//     _// \n_//      _//\n _//    _// \n   _///     \n            \n',
    '4': u'            \n      _//   \n    _ _//   \n   _/ _//   \n _//  _//   \n_//// _/ _//\n      _//   \n            \n',
    '8': u'           \n    _/     \n _//  _//  \n_//     _/ \n  _// _/   \n_//     _//\n  _////    \n           \n',
    '<': u'      _//\n    _//  \n  _//    \n_//      \n  _//    \n    _//  \n      _//\n         \n',
    '@': u'             \n    _///     \n  _/    _//  \n _/  _//  _//\n_// _//_  _//\n _//   ```   \n    _//      \n             \n',
    'D': u'_/////    \n_//   _// \n_//    _//\n_//    _//\n_//    _//\n_//   _// \n_/////    \n          \n',
    'H': u'_//     _//\n_//     _//\n_//     _//\n_////// _//\n_//     _//\n_//     _//\n_//     _//\n           \n',
    'L': u'_//      \n_//      \n_//      \n_//      \n_//      \n_//      \n_////////\n         \n',
    'P': u'_///////  \n_//    _//\n_//    _//\n_///////  \n_//       \n_//       \n_//       \n          \n',
    'T': u'_/// _//////\n     _//    \n     _//    \n     _//    \n     _//    \n     _//    \n     _//    \n            \n',
    'X': u'_//      _//\n _//   _//  \n  _// _//   \n    _//     \n  _// _//   \n _//   _//  \n_//      _//\n            \n',
    '\\': u'_//      \n _//     \n  _//    \n   _//   \n    _//  \n     _// \n      _//\n         \n',
    '`': u'_//\n_/ \n   \n   \n   \n   \n   \n   \n',
    'd': u'     _//\n     _//\n     _//\n _// _//\n_/   _//\n_/   _//\n _// _//\n        \n',
    'h': u'        \n_//     \n_//     \n_/ _/   \n_//  _//\n_/   _//\n_//  _//\n        \n',
    'l': u' _//\n _//\n _//\n _//\n _//\n _//\n_///\n    \n',
    'p': u'        \n        \n_/ _//  \n_/  _// \n_/   _//\n_// _// \n_//     \n_//     \n',
    't': u'  _//  \n  _//  \n_/_/ _/\n  _//  \n  _//  \n  _//  \n   _// \n       \n',
    'x': u'         \n         \n_//   _//\n  _/ _// \n   _/    \n _/  _// \n_//   _//\n         \n',
    '|': u'_/\n_/\n_/\n  \n_/\n_/\n_/\n  \n',
    '#': u'             \n  _//   _//  \n_////// _////\n  _//   _//  \n  _//   _//  \n_////// _////\n  _//   _//  \n             \n',
    "'": u'_//\n _/\n   \n   \n   \n   \n   \n   \n',
    '+': u'           \n     _//   \n     _//   \n_/// _/////\n     _//   \n     _//   \n           \n           \n',
    '/': u'       _//\n      _// \n     _//  \n    _//   \n   _//    \n  _//     \n _//      \n          \n',
    '3': u'         \n_// _//  \n   _//   \n _//     \n    _//  \n      _//\n_/////   \n         \n',
    '7': u'          \n_///// _//\n      _// \n     _//  \n    _//   \n    _//   \n    _//   \n          \n',
    ';': u'   \n   \n   \n   \n_//\n   \n_//\n _/\n',
    '?': u'_///    \n    _// \n     _//\n    _// \n _//    \n        \n _//    \n        \n',
    'C': u'    _//   \n _//   _//\n_//       \n_//       \n_//       \n _//   _//\n   _////  \n          \n',
    'G': u'   _////   \n _/    _// \n_//        \n_//        \n_//   _////\n _//    _/ \n  _/////   \n           \n',
    'K': u'_//   _//  \n_//  _//   \n_// _//    \n_/ _/      \n_//  _//   \n_//   _//  \n_//     _//\n           \n',
    'O': u'    _////     \n  _//    _//  \n_//        _//\n_//        _//\n_//        _//\n  _//     _// \n    _////     \n              \n',
    'S': u'  _// //  \n_//    _//\n _//      \n   _//    \n      _// \n_//    _//\n  _// //  \n          \n',
    'W': u'_//        _//\n_//        _//\n_//   _/   _//\n_//  _//   _//\n_// _/ _// _//\n_/ _/    _////\n_//        _//\n              \n',
    '[': u'_////\n_//  \n_//  \n_//  \n_//  \n_//  \n_////\n     \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n_/////\n',
    'c': u'       \n       \n   _///\n _//   \n_//    \n _//   \n   _///\n       \n',
    'g': u'         \n         \n   _//   \n _//  _//\n_//   _//\n _//  _//\n     _// \n  _//    \n',
    'k': u'_//     \n_//     \n_//  _//\n_// _// \n_/_//   \n_// _// \n_//  _//\n        \n',
    'o': u'          \n          \n   _//    \n _//  _// \n_//    _//\n _//  _// \n   _//    \n          \n',
    's': u'       \n       \n _//// \n_//    \n  _/// \n    _//\n_// _//\n       \n',
    'w': u'            \n            \n_//     _///\n _//  /  _//\n _// _/  _//\n _/ _/ _/_//\n_///    _///\n            \n',
    '{': u'     _//\n  _//   \n  _//   \n_///    \n  _//   \n  _//   \n     _//\n        \n',
    '"': u'_/ _/\n_/ _/\n     \n     \n     \n     \n     \n     \n',
    '&': u'   _/   \n _// _//\n_//     \n _///   \n_//     \n _// _//\n   _/   \n        \n',
    '*': u'      _//     \n _//  _//  _//\n   _/ _/ _//  \n_//// _///////\n   _/ _/ _//  \n _//  _//  _//\n      _//     \n              \n',
    '.': u'   \n   \n   \n   \n   \n   \n_//\n   \n',
    '2': u'           \n  _// _/   \n _/     _//\n      _//  \n    _//    \n  _//      \n _//////// \n           \n',
    '6': u'           \n    _//    \n   _//     \n  _//      \n_/    _//  \n_//     _//\n  _// _//  \n           \n',
    ':': u'   \n   \n   \n   \n_//\n   \n_//\n   \n',
    '>': u'_//      \n  _//    \n    _//  \n      _//\n    _//  \n  _//    \n_//      \n         \n',
    'B': u'_// _//   \n_/    _// \n_/     _//\n_/// _/   \n_/     _//\n_/      _/\n_//// _// \n          \n',
    'F': u'_////////\n_//      \n_//      \n_//////  \n_//      \n_//      \n_//      \n         \n',
    'J': u'     _//\n     _//\n     _//\n     _//\n     _//\n_/   _//\n _////  \n        \n',
    'N': u'_///     _//\n_/ _//   _//\n_// _//  _//\n_//  _// _//\n_//   _/ _//\n_//    _/ //\n_//      _//\n            \n',
    'R': u'_///////    \n_//    _//  \n_//    _//  \n_/ _//      \n_//  _//    \n_//    _//  \n_//      _//\n            \n',
    'V': u'_//         _//\n _//       _// \n  _//     _//  \n   _//   _//   \n    _// _//    \n     _////     \n      _//      \n               \n',
    'Z': u'_/////// _//\n       _//  \n      _//   \n    _//     \n   _//      \n _//        \n_///////////\n            \n',
    '^': u'    _//    \n  _// _//  \n_//     _//\n           \n           \n           \n           \n           \n',
    'b': u'_//      \n_//      \n_//      \n_// _//  \n_//   _//\n_//   _//\n_// _//  \n         \n',
    'f': u'    _//\n  _/   \n_/_/ _/\n  _//  \n  _//  \n  _//  \n  _//  \n       \n',
    'j': u'      \n   _//\n      \n   _//\n   _//\n   _//\n   _//\n_///  \n',
    'n': u'         \n         \n_// _//  \n _//  _//\n _//  _//\n _//  _//\n_///  _//\n         \n',
    'r': u'       \n       \n_/ _///\n _//   \n _//   \n _//   \n_///   \n       \n',
    'v': u'           \n           \n_//     _//\n _//   _// \n  _// _//  \n   _/_//   \n    _//    \n           \n',
    'z': u'         \n         \n_//// _//\n     _// \n   _//   \n  _//    \n_////////\n         \n',
    '~': u'_//  _/   \n   _/  _//\n          \n          \n          \n          \n          \n          \n',
    '!': u'_//\n_//\n_//\n_/ \n_/ \n   \n_//\n   \n',
    '%': u'          \n _//  _// \n     _//  \n    _//   \n   _//    \n  _//     \n _//  _// \n          \n',
    ')': u' _//  \n  _// \n   _//\n   _//\n   _//\n  _// \n _//  \n      \n',
    '-': u'      \n      \n      \n_/////\n      \n      \n      \n      \n',
    '1': u'      \n _//  \n  _// \n  _// \n  _// \n  _// \n_/////\n      \n',
    '5': u'         \n_// _/// \n_//      \n_///     \n    _//  \n      _//\n_/// _// \n         \n',
    '9': u'            \n   _/ _//   \n _//     _//\n_/      _// \n  _/  _//   \n     _//    \n   _//      \n            \n',
    '=': u'       \n       \n_//////\n       \n_//////\n       \n       \n       \n',
    'A': u'      _/       \n     _/ //     \n    _/  _//    \n   _//   _//   \n  _////// _//  \n _//       _// \n_//         _//\n               \n',
    'E': u'_////////\n_//      \n_//      \n_//////  \n_//      \n_//      \n_////////\n         \n',
    'I': u'_//\n_//\n_//\n_//\n_//\n_//\n_//\n   \n',
    'M': u'_//       _//\n_/ _//   _///\n_// _// _ _//\n_//  _//  _//\n_//   _/  _//\n_//       _//\n_//       _//\n             \n',
    'Q': u'    _////    \n  _//    _// \n_//       _//\n_//       _//\n_//       _//\n  _// _/ _// \n    _// //   \n         _/  \n',
    'U': u'_//     _//\n_//     _//\n_//     _//\n_//     _//\n_//     _//\n_//     _//\n  _/////   \n           \n',
    'Y': u'_//      _//\n _//    _// \n  _// _//   \n    _//     \n    _//     \n    _//     \n    _//     \n            \n',
    ']': u'_////\n  _//\n  _//\n  _//\n  _//\n  _//\n_////\n     \n',
    'a': u'          \n          \n   _//    \n _//  _// \n_//   _// \n_//   _// \n  _// _///\n          \n',
    'e': u'          \n          \n   _//    \n _/   _// \n_///// _//\n_/        \n  _////   \n          \n',
    'i': u'   \n _/\n   \n_//\n_//\n_//\n_//\n   \n',
    'm': u'             \n             \n_/// _// _// \n _//  _/  _//\n _//  _/  _//\n _//  _/  _//\n_///  _/  _//\n             \n',
    'q': u'        \n        \n  _//   \n_/  _// \n_/  _// \n _//_// \n    _// \n    _///\n',
    'u': u'        \n        \n_//  _//\n_//  _//\n_//  _//\n_//  _//\n  _//_//\n        \n',
    'y': u'         \n         \n_//   _//\n _// _// \n   _///  \n    _//  \n   _//   \n _//     \n',
    '}': u'_//     \n  _//   \n  _//   \n    _///\n  _//   \n  _//   \n_//     \n        \n'}

colossal_dic = {
    ' ': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '$': u'     88     \n .d88888b.  \nd88P 88"88b \nY88b.88     \n "Y88888b.  \n     88"88b \nY88b 88.88P \n "Y88888P"  \n     88     \n            \n            \n',
    '(': u'  .d88 \n d88P" \nd88P   \n888    \n888    \nY88b   \n Y88b. \n  "Y88 \n       \n       \n       \n',
    ',': u'    \n    \n    \n    \n    \n    \nd8b \n88P \n8P  \n"   \n    \n',
    '0': u' .d8888b.  \nd88P  Y88b \n888    888 \n888    888 \n888    888 \n888    888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    '4': u'    d8888  \n   d8P888  \n  d8P 888  \n d8P  888  \nd88   888  \n8888888888 \n      888  \n      888  \n           \n           \n           \n',
    '8': u' .d8888b.  \nd88P  Y88b \nY88b. d88P \n "Y88888"  \n.d8P""Y8b. \n888    888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    '<': u'   d88P \n  d88P  \n d88P   \nd88P    \nY88b    \n Y88b   \n  Y88b  \n   Y88b \n        \n        \n        \n',
    '@': u' .d8888888b.  \nd88P"   "Y88b \n888  d8b  888 \n888  888  888 \n888  888bd88P \n888  Y8888P"  \nY88b.     .d8 \n "Y88888888P" \n              \n              \n              \n',
    'D': u'8888888b.  \n888  "Y88b \n888    888 \n888    888 \n888    888 \n888    888 \n888  .d88P \n8888888P"  \n           \n           \n           \n',
    'H': u'888    888 \n888    888 \n888    888 \n8888888888 \n888    888 \n888    888 \n888    888 \n888    888 \n           \n           \n           \n',
    'L': u'888      \n888      \n888      \n888      \n888      \n888      \n888      \n88888888 \n         \n         \n         \n',
    'P': u'8888888b.  \n888   Y88b \n888    888 \n888   d88P \n8888888P"  \n888        \n888        \n888        \n           \n           \n           \n',
    'T': u'88888888888 \n    888     \n    888     \n    888     \n    888     \n    888     \n    888     \n    888     \n            \n            \n            \n',
    'X': u'Y88b   d88P \n Y88b d88P  \n  Y88o88P   \n   Y888P    \n   d888b    \n  d88888b   \n d88P Y88b  \nd88P   Y88b \n            \n            \n            \n',
    '\\': u'Y88b        \n Y88b       \n  Y88b      \n   Y88b     \n    Y88b    \n     Y88b   \n      Y88b  \n       Y88b \n            \n            \n            \n',
    '`': u'd8b \nY88 \n Y8 \n  Y \n    \n    \n    \n    \n    \n    \n    \n',
    'd': u'     888 \n     888 \n     888 \n .d88888 \nd88" 888 \n888  888 \nY88b 888 \n "Y88888 \n         \n         \n         \n',
    'h': u'888      \n888      \n888      \n88888b.  \n888 "88b \n888  888 \n888  888 \n888  888 \n         \n         \n         \n',
    'l': u'888 \n888 \n888 \n888 \n888 \n888 \n888 \n888 \n    \n    \n    \n',
    'p': u'         \n         \n         \n88888b.  \n888 "88b \n888  888 \n888 d88P \n88888P"  \n888      \n888      \n888      \n',
    't': u'888    \n888    \n888    \n888888 \n888    \n888    \nY88b.  \n "Y888 \n       \n       \n       \n',
    'x': u'         \n         \n         \n888  888 \n`Y8bd8P\' \n  X88K   \n.d8""8b. \n888  888 \n         \n         \n         \n',
    '|': u'  888  \n  888  \n  888  \n  888  \n       \n  888  \n  888  \n  888  \n  888  \n       \n       \n',
    '#': u'  888  888   \n  888  888   \n888888888888 \n  888  888   \n  888  888   \n888888888888 \n  888  888   \n  888  888   \n             \n             \n             \n',
    "'": u'd8b \n88P \n8P  \n"   \n    \n    \n    \n    \n    \n    \n    \n',
    '+': u'        \n        \n        \n  888   \n8888888 \n  888   \n        \n        \n        \n        \n        \n',
    '/': u'       d88P \n      d88P  \n     d88P   \n    d88P    \n   d88P     \n  d88P      \n d88P       \nd88P        \n            \n            \n            \n',
    '3': u' .d8888b.  \nd88P  Y88b \n     .d88P \n    8888"  \n     "Y8b. \n888    888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    '7': u'8888888888 \n      d88P \n     d88P  \n    d88P   \n 88888888  \n  d88P     \n d88P      \nd88P       \n           \n           \n           \n',
    ';': u'    \n    \n    \nd8b \nY8P \n    \nd8b \n88P \n8P  \n"   \n    \n',
    '?': u' .d8888b.  \nd88P  Y88b \n     .d88P \n   .d88P"  \n   888"    \n   888     \n           \n   888     \n           \n           \n           \n',
    'C': u' .d8888b.  \nd88P  Y88b \n888    888 \n888        \n888        \n888    888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    'G': u' .d8888b.  \nd88P  Y88b \n888    888 \n888        \n888  88888 \n888    888 \nY88b  d88P \n "Y8888P88 \n           \n           \n           \n',
    'K': u'888    d8P  \n888   d8P   \n888  d8P    \n888d88K     \n8888888b    \n888  Y88b   \n888   Y88b  \n888    Y88b \n            \n            \n            \n',
    'O': u' .d88888b.  \nd88P" "Y88b \n888     888 \n888     888 \n888     888 \n888     888 \nY88b. .d88P \n "Y88888P"  \n            \n            \n            \n',
    'S': u' .d8888b.  \nd88P  Y88b \nY88b.      \n "Y888b.   \n    "Y88b. \n      "888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    'W': u'888       888 \n888   o   888 \n888  d8b  888 \n888 d888b 888 \n888d88888b888 \n88888P Y88888 \n8888P   Y8888 \n888P     Y888 \n              \n              \n              \n',
    '[': u'8888888 \n888     \n888     \n888     \n888     \n888     \n888     \n8888888 \n        \n        \n        \n',
    '_': u'         \n         \n         \n         \n         \n         \n         \n88888888 \n         \n         \n         \n',
    'c': u'         \n         \n         \n .d8888b \nd88P"    \n888      \nY88b.    \n "Y8888P \n         \n         \n         \n',
    'g': u'         \n         \n         \n .d88b.  \nd88P"88b \n888  888 \nY88b 888 \n "Y88888 \n     888 \nY8b d88P \n "Y88P"  \n',
    'k': u'888      \n888      \n888      \n888  888 \n888 .88P \n888888K  \n888 "88b \n888  888 \n         \n         \n         \n',
    'o': u'         \n         \n         \n .d88b.  \nd88""88b \n888  888 \nY88..88P \n "Y88P"  \n         \n         \n         \n',
    's': u'         \n         \n         \n.d8888b  \n88K      \n"Y8888b. \n     X88 \n 88888P\' \n         \n         \n         \n',
    'w': u'              \n              \n              \n888  888  888 \n888  888  888 \n888  888  888 \nY88b 888 d88P \n "Y8888888P"  \n              \n              \n              \n',
    '{': u'  .d888 \n d88P"  \n 888    \n.888    \n888(    \n"888    \n 888    \n Y88b.  \n  "Y888 \n        \n        \n',
    '"': u'88 88 \n8P 8P \n"  "  \n      \n      \n      \n      \n      \n      \n      \n      \n',
    '&': u' .d8888b.     \nd88P  "88b    \nY88b. d88P    \n "Y8888P"     \n.d88P88K.d88P \n888"  Y888P"  \nY88b .d8888b  \n "Y8888P" Y88b\n              \n              \n              \n',
    '*': u'             \n      o      \n     d8b     \n    d888b    \n"Y888888888P"\n  "Y88888P"  \n  d88P"Y88b  \n dP"     "Yb \n             \n             \n             \n',
    '.': u'    \n    \n    \n    \n    \n    \nd8b \nY8P \n    \n    \n    \n',
    '2': u' .d8888b.  \nd88P  Y88b \n       888 \n     .d88P \n .od888P"  \nd88P"      \n888"       \n888888888  \n           \n           \n           \n',
    '6': u' .d8888b.  \nd88P  Y88b \n888        \n888d888b.  \n888P "Y88b \n888    888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    ':': u'    \n    \n    \nd8b \nY8P \n    \nd8b \nY8P \n    \n    \n    \n',
    '>': u'Y88b    \n Y88b   \n  Y88b  \n   Y88b \n   d88P \n  d88P  \n d88P   \nd88P    \n        \n        \n        \n',
    'B': u'888888b.   \n888  "88b  \n888  .88P  \n8888888K.  \n888  "Y88b \n888    888 \n888   d88P \n8888888P"  \n           \n           \n           \n',
    'F': u'8888888888 \n888        \n888        \n8888888    \n888        \n888        \n888        \n888        \n           \n           \n           \n',
    'J': u'  888888 \n    "88b \n     888 \n     888 \n     888 \n     888 \n     88P \n     888 \n   .d88P \n .d88P"  \n888P"    \n',
    'N': u'888b    888 \n8888b   888 \n88888b  888 \n888Y88b 888 \n888 Y88b888 \n888  Y88888 \n888   Y8888 \n888    Y888 \n            \n            \n            \n',
    'R': u'8888888b.  \n888   Y88b \n888    888 \n888   d88P \n8888888P"  \n888 T88b   \n888  T88b  \n888   T88b \n           \n           \n           \n',
    'V': u'888     888 \n888     888 \n888     888 \nY88b   d88P \n Y88b d88P  \n  Y88o88P   \n   Y888P    \n    Y8P     \n            \n            \n            \n',
    'Z': u'8888888888P \n      d88P  \n     d88P   \n    d88P    \n   d88P     \n  d88P      \n d88P       \nd8888888888 \n            \n            \n            \n',
    '^': u'   o    \n  d8b   \n d888b  \nd8P"Y8b \n        \n        \n        \n        \n        \n        \n        \n',
    'b': u'888      \n888      \n888      \n88888b.  \n888 "88b \n888  888 \n888 d88P \n88888P"  \n         \n         \n         \n',
    'f': u' .d888 \nd88P"  \n888    \n888888 \n888    \n888    \n888    \n888    \n       \n       \n       \n',
    'j': u'   d8b \n   Y8P \n       \n  8888 \n  "888 \n   888 \n   888 \n   888 \n   888 \n  d88P \n888P"  \n',
    'n': u'         \n         \n         \n88888b.  \n888 "88b \n888  888 \n888  888 \n888  888 \n         \n         \n         \n',
    'r': u'        \n        \n        \n888d888 \n888P"   \n888     \n888     \n888     \n        \n        \n        \n',
    'v': u'         \n         \n         \n888  888 \n888  888 \nY88  88P \n Y8bd8P  \n  Y88P   \n         \n         \n         \n',
    'z': u'         \n         \n         \n88888888 \n   d88P  \n  d88P   \n d88P    \n88888888 \n         \n         \n         \n',
    '~': u'            \n            \n d888b  d88 \nd888888888P \n88P  Y888P  \n            \n            \n            \n            \n            \n            \n',
    '!': u'888 \n888 \n888 \n888 \n888 \nY8P \n "  \n888 \n    \n    \n    \n',
    '%': u'd88b   d88P \nY88P  d88P  \n     d88P   \n    d88P    \n   d88P     \n  d88P      \n d88P  d88b \nd88P   Y88P \n            \n            \n            \n',
    ')': u'88b.   \n"Y88b  \n  Y88b \n   888 \n   888 \n  d88P \n.d88P  \n88P"   \n       \n       \n       \n',
    '-': u'       \n       \n       \n       \n       \n888888 \n       \n       \n       \n       \n       \n',
    '1': u' d888   \nd8888   \n  888   \n  888   \n  888   \n  888   \n  888   \n8888888 \n        \n        \n        \n',
    '5': u'888888888  \n888        \n888        \n8888888b.  \n     "Y88b \n       888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    '9': u' .d8888b.  \nd88P  Y88b \n888    888 \nY88b. d888 \n "Y888P888 \n       888 \nY88b  d88P \n "Y8888P"  \n           \n           \n           \n',
    '=': u'       \n       \n       \n888888 \n       \n888888 \n       \n       \n       \n       \n       \n',
    'A': u'       d8888 \n      d88888 \n     d88P888 \n    d88P 888 \n   d88P  888 \n  d88P   888 \n d8888888888 \nd88P     888 \n             \n             \n             \n',
    'E': u'8888888888 \n888        \n888        \n8888888    \n888        \n888        \n888        \n8888888888 \n           \n           \n           \n',
    'I': u'8888888 \n  888   \n  888   \n  888   \n  888   \n  888   \n  888   \n8888888 \n        \n        \n        \n',
    'M': u'888b     d888 \n8888b   d8888 \n88888b.d88888 \n888Y88888P888 \n888 Y888P 888 \n888  Y8P  888 \n888   "   888 \n888       888 \n              \n              \n              \n',
    'Q': u' .d88888b.  \nd88P" "Y88b \n888     888 \n888     888 \n888     888 \n888 Y8b 888 \nY88b.Y8b88P \n "Y888888"  \n       Y8b  \n            \n            \n',
    'U': u'888     888 \n888     888 \n888     888 \n888     888 \n888     888 \n888     888 \nY88b. .d88P \n "Y88888P"  \n            \n            \n            \n',
    'Y': u'Y88b   d88P \n Y88b d88P  \n  Y88o88P   \n   Y888P    \n    888     \n    888     \n    888     \n    888     \n            \n            \n            \n',
    ']': u'8888888 \n    888 \n    888 \n    888 \n    888 \n    888 \n    888 \n8888888 \n        \n        \n        \n',
    'a': u'         \n         \n         \n 8888b.  \n    "88b \n.d888888 \n888  888 \n"Y888888 \n         \n         \n         \n',
    'e': u'         \n         \n         \n .d88b.  \nd8P  Y8b \n88888888 \nY8b.     \n "Y8888  \n         \n         \n         \n',
    'i': u'd8b \nY8P \n    \n888 \n888 \n888 \n888 \n888 \n    \n    \n    \n',
    'm': u'              \n              \n              \n88888b.d88b.  \n888 "888 "88b \n888  888  888 \n888  888  888 \n888  888  888 \n              \n              \n              \n',
    'q': u'         \n         \n         \n .d88888 \nd88" 888 \n888  888 \nY88b 888 \n "Y88888 \n     888 \n     888 \n     888 \n',
    'u': u'         \n         \n         \n888  888 \n888  888 \n888  888 \nY88b 888 \n "Y88888 \n         \n         \n         \n',
    'y': u'         \n         \n         \n888  888 \n888  888 \n888  888 \nY88b 888 \n "Y88888 \n     888 \nY8b d88P \n "Y88P"  \n',
    '}': u'888b.   \n "Y88b  \n   888  \n   888. \n   )888 \n   888" \n   888  \n .d88P  \n888P"   \n        \n        \n'}

acrobatic_dic = {
    '!': u'   o   \n  <|>  \n  / \\  \n  \\o/  \n   |   \n  < >  \n       \n   o   \n _<|>_ \n       \n       \n       \n',
    ' ': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '#': u'   |     |   \n   o     o   \n __|>_ _<|__ \n   |     |   \n   o     o   \n __|>_ _<|__ \n  <o>   <o>  \n   |     |   \n  / \\   / \\  \n             \n             \n             \n',
    '"': u'  o   o  \n <|> <|> \n < > < > \n         \n         \n         \n         \n         \n         \n         \n         \n         \n',
    '%': u'  o        o/ \n <|>      /v  \n < >     />   \n       o/     \n      /v      \n     />       \n   o/      o  \n  /v      <|> \n />       < > \n              \n              \n              \n',
    '$': u'          \n          \n          \n    |_o__ \n   /   \\  \n   \\o     \n    v\\    \n     <\\   \n _\\o__/   \n     |    \n          \n          \n',
    "'": u'   o/ \n  /v  \n />   \n      \n      \n      \n      \n      \n      \n      \n      \n      \n',
    '&': u'    o/ \\o        \n   <|   |>       \n    \\\\ //        \n   o/_ _\\o    o/ \n  /       \\  /v  \n />       <\\/>   \n \\         /\\o   \n  o       o  v\\  \n  <\\__ __/>   <\\ \n                 \n                 \n                 \n',
    ')': u' __o      \n   v\\     \n    <\\    \n      \\o  \n       |> \n      //  \n     /    \n    o     \n __/>     \n          \n          \n          \n',
    '(': u'      o__ \n     /v   \n    />    \n  o/      \n <|       \n  \\\\      \n    \\     \n     o    \n     <\\__ \n          \n          \n          \n',
    '+': u'       o       \n      <|>      \n      < >      \n      / \\      \n _\\__o   o__/_ \n      \\ /      \n      <o>      \n       |       \n      < >      \n               \n               \n               \n',
    '*': u'  \\o       o/  \n   v\\     /v   \n    <\\   />    \n     |\\o/|     \n _\\__o | o__/_ \n     |/ \\|     \n    o/   \\o    \n   /v     v\\   \n  />       <\\  \n               \n               \n               \n',
    '-': u'         \n         \n         \n         \n _\\__o__ \n      \\  \n         \n         \n         \n         \n         \n         \n',
    ',': u'       \n       \n       \n       \n       \n       \n    o  \n   <|> \n   < > \n   o/  \n  /v   \n />    \n',
    '/': u'           o/ \n          /v  \n         />   \n       o/     \n      /v      \n     />       \n   o/         \n  /v          \n />           \n              \n              \n              \n',
    '.': u'     \n     \n     \n     \n     \n     \n  o  \n <|> \n < > \n     \n     \n     \n',
    '1': u' __o   \n __|>  \n   |   \n  <o>  \n   |   \n  < >  \n   |   \n   o   \n __|>_ \n       \n       \n       \n',
    '0': u'      o__ __o      \n     /v     v\\     \n    />       <\\    \n  o/           \\o  \n <|             |> \n  \\\\           //  \n    \\         /    \n     o       o     \n     <\\__ __/>     \n                   \n                   \n                   \n',
    '3': u'    o__ __o    \n   /v     v\\   \n  />       <\\  \n           o/  \n         _<|   \n            \\  \n \\          /  \n   o       o   \n   <\\__ __/>   \n               \n               \n               \n',
    '2': u'    __o     \n  o/  v\\    \n /|    <\\   \n //    o/   \n      /v    \n     />     \n   o/       \n  /v        \n /> __o__/_ \n            \n            \n            \n',
    '5': u'  o__ __o__/_  \n <|    v       \n < >           \n _\\o____       \n      \\_\\__o__ \n            \\  \n  \\         /  \n   o       o   \n   <\\__ __/>   \n               \n               \n               \n',
    '4': u'  o     o  \n <|>   <|> \n / >   < \\ \n \\o__ __o/ \n \\|__ __|  \n        |  \n       <o> \n        |  \n       / \\ \n           \n           \n           \n',
    '7': u' _\\__o__ __o/ \n      v    |/ \n          /   \n        o/    \n       /v     \n      />      \n    o/        \n   /v         \n  />          \n              \n              \n              \n',
    '6': u'    o__ __o    \n   /v     v\\   \n  />       <\\  \n <o>           \n  |__  _\\__o__ \n  |         \\  \n  \\         /  \n   o       o   \n   <\\__ __/>   \n               \n               \n               \n',
    '9': u'    o__ __o    \n   /v     v\\   \n  />       <\\  \n  \\o        |  \n  \\|>_  _\\__o  \n            |  \n  \\         /  \n   o       o   \n   <\\__ __/>   \n               \n               \n               \n',
    '8': u'    o__ __o    \n   /v     v\\   \n  />       <\\  \n  \\o       o/  \n   |>_   _<|   \n  /         \\  \n  \\         /  \n   o       o   \n   <\\__ __/>   \n               \n               \n               \n',
    ';': u'    o  \n   <|> \n   < > \n       \n       \n       \n    o  \n   <|> \n   < > \n   o/  \n  /v   \n />    \n',
    ':': u'  o  \n <|> \n < > \n     \n     \n     \n  o  \n <|> \n < > \n     \n     \n     \n',
    '=': u'         \n         \n         \n _\\__o__ \n      \\  \n _\\__o__ \n      \\  \n         \n         \n         \n         \n         \n',
    '<': u'      o/ \n     /v  \n    />   \n  o/     \n <|      \n  \\\\     \n    \\o   \n     v\\  \n      <\\ \n         \n         \n         \n',
    '?': u'   o__ __o   \n  /v     v\\  \n />       <\\ \n          o/ \n         /v  \n        />   \n             \n      o/     \n    _<|__    \n             \n             \n             \n',
    '>': u' \\o      \n  v\\     \n   <\\    \n     \\o  \n      |> \n     //  \n   o/    \n  /v     \n />      \n         \n         \n         \n',
    '@': u'      o__ __o    \n     /v     v\\   \n    />       <\\  \n  o/    o__ __o> \n <|    <|__ __|/ \n  \\\\   <         \n    \\         /  \n     o       o   \n     <\\__ __/>   \n                 \n                 \n                 \n',
    '[': u'   o__ \n  <|   \n  / \\  \n  \\o/  \n   |   \n  < >  \n   |   \n   o   \n _<|__ \n       \n       \n       \n',
    ']': u' __o   \n   |>  \n  / \\  \n  \\o/  \n   |   \n  < >  \n   |   \n   o   \n __|>_ \n       \n       \n       \n',
    '\\': u' \\o           \n  v\\          \n   <\\         \n     \\o       \n      v\\      \n       <\\     \n         \\o   \n          v\\  \n           <\\ \n              \n              \n              \n',
    '_': u'         \n         \n         \n         \n         \n         \n         \n         \n ____o__ \n  /   \\  \n         \n         \n',
    '^': u'   o/\\o   \n  /v  v\\  \n />    <\\ \n          \n          \n          \n          \n          \n          \n          \n          \n          \n',
    'a': u'             \n             \n             \n    o__ __o/ \n   /v     |  \n  />     / \\ \n  \\      \\o/ \n   o      |  \n   <\\__  / \\ \n             \n             \n             \n',
    '`': u' \\o   \n  v\\  \n   <\\ \n      \n      \n      \n      \n      \n      \n      \n      \n      \n',
    'c': u'           \n           \n           \n     __o__ \n    />  \\  \n  o/       \n <|        \n  \\\\       \n   _\\o__</ \n           \n           \n           \n',
    'b': u'  o          \n <|>         \n / >         \n \\o__ __o    \n  |     v\\   \n / \\     <\\  \n \\o/      /  \n  |      o   \n / \\  __/>   \n             \n             \n             \n',
    'e': u'             \n             \n             \n   o__  __o  \n  /v      |> \n />      //  \n \\o    o/    \n  v\\  /v __o \n   <\\/> __/> \n             \n             \n             \n',
    'd': u'         o  \n        <|> \n        < \\ \n   o__ __o/ \n  /v     |  \n />     / \\ \n \\      \\o/ \n  o      |  \n  <\\__  / \\ \n            \n            \n            \n',
    'g': u'            \n            \n            \n   o__ __o/ \n  /v     |  \n />     / \\ \n \\      \\o/ \n  o      |  \n  <\\__  < > \n         |  \n o__     o  \n <\\__ __/>  \n',
    'f': u'   o__ __o   \n  /v     v\\  \n />       <\\ \n \\o          \n  |>_        \n  |          \n <o>         \n  |          \n / \\         \n             \n             \n             \n',
    'i': u'   o   \n _<|>_ \n       \n   o   \n  <|>  \n  / \\  \n  \\o/  \n   |   \n  / \\  \n       \n       \n       \n',
    'h': u'  o         \n <|>        \n / >        \n \\o__ __o   \n  |     v\\  \n / \\     <\\ \n \\o/     o/ \n  |     <|  \n / \\    / \\ \n            \n            \n            \n',
    'k': u'  o      \n <|>     \n / \\     \n \\o/  o/ \n  |  /v  \n / \\/>   \n \\o/\\o   \n  |  v\\  \n / \\  <\\ \n         \n         \n         \n',
    'j': u'         o   \n       _<|>_ \n             \n         o   \n        <|>  \n        / \\  \n        \\o/  \n         |   \n        < >  \n         |   \n o__     o   \n <\\__ __/>   \n',
    'm': u'                 \n                 \n                 \n \\o__ __o__ __o  \n  |     |     |> \n / \\   / \\   / \\ \n \\o/   \\o/   \\o/ \n  |     |     |  \n / \\   / \\   / \\ \n                 \n                 \n                 \n',
    'l': u'  o  \n <|> \n / \\ \n \\o/ \n  |  \n / \\ \n \\o/ \n  |  \n / \\ \n     \n     \n     \n',
    'o': u'             \n             \n             \n   o__ __o   \n  /v     v\\  \n />       <\\ \n \\         / \n  o       o  \n  <\\__ __/>  \n             \n             \n             \n',
    'n': u'           \n           \n           \n \\o__ __o  \n  |     |> \n / \\   / \\ \n \\o/   \\o/ \n  |     |  \n / \\   / \\ \n           \n           \n           \n',
    'q': u'              \n              \n              \n   o__ __o/   \n  /v     |    \n />     / \\   \n \\      \\o/   \n  o      |    \n  <\\__  < >   \n         |    \n         o    \n         <\\__ \n',
    'p': u'           \n           \n           \n \\o_ __o   \n  |    v\\  \n / \\    <\\ \n \\o/     / \n  |     o  \n / \\ __/>  \n \\o/       \n  |        \n / \\       \n',
    's': u'           \n           \n           \n     __o__ \n    />  \\  \n    \\o     \n     v\\    \n      <\\   \n _\\o__</   \n           \n           \n           \n',
    'r': u'           \n           \n           \n \\o__ __o  \n  |     |> \n / \\   < > \n \\o/       \n  |        \n / \\       \n           \n           \n           \n',
    'u': u'             \n             \n             \n  o       o  \n <|>     <|> \n < >     < > \n  |       |  \n  o       o  \n  <\\__ __/>  \n             \n             \n             \n',
    't': u'  o     \n <|>    \n < >    \n  |     \n  o__/_ \n  |     \n  |     \n  o     \n  <\\__  \n        \n        \n        \n',
    'w': u'                    \n                    \n                    \n  o              o  \n <|>            <|> \n < >            < > \n  \\o    o/\\o    o/  \n   v\\  /v  v\\  /v   \n    <\\/>    <\\/>    \n                    \n                    \n                    \n',
    'v': u'            \n            \n            \n  o      o  \n <|>    <|> \n < >    < > \n  \\o    o/  \n   v\\  /v   \n    <\\/>    \n            \n            \n            \n',
    'y': u'            \n            \n            \n  o      o  \n <|>    <|> \n < >    < > \n  \\o    o/  \n   v\\  /v   \n    <\\/>    \n     /      \n    o       \n __/>       \n',
    'x': u'          \n          \n          \n \\o    o/ \n  v\\  /v  \n   <\\/>   \n   o/\\o   \n  /v  v\\  \n />    <\\ \n          \n          \n          \n',
    '{': u'    o__ \n   <|   \n   <|   \n  o/    \n <|     \n  \\\\    \n    |   \n    o   \n  _<|__ \n        \n        \n        \n',
    'z': u'         \n         \n         \n _\\o____ \n     /   \n   o/    \n  /v     \n />      \n \\>__o__ \n      \\  \n         \n         \n',
    '}': u' __o    \n   |>   \n   |>   \n    \\o  \n     |> \n    //  \n   |    \n   o    \n __|>_  \n        \n        \n        \n',
    '|': u' \\o/ \n  |  \n / \\ \n \\o/ \n  |  \n / \\ \n \\o/ \n  |  \n / \\ \n \\o/ \n  |  \n / \\ \n',
    '~': u'  __o__       \n />  \\_\\o__/_ \n              \n              \n              \n              \n              \n              \n              \n              \n              \n              \n'}

alligator_dic = {
    ' ': u' \n \n \n \n \n \n \n',
    '$': u'        :::   \n    :+:+:+:+: \n  +:+ +:+     \n  +#++:++#+   \n    +#+ +#+   \n#+#+#+#+#     \n  ###         \n',
    '(': u'      ::: \n    :+:   \n  +:+     \n +#+      \n+#+       \n#+#       \n###       \n',
    ',': u'         \n         \n         \n         \n         \n #+#     \n##       \n',
    '0': u'      ::::::: \n    :+:   :+: \n   +:+   +:+  \n  +#+   +:+   \n +#+   +#+    \n#+#   #+#     \n#######       \n',
    '4': u'        ::: \n      :+:   \n    +:+ +:+ \n  +#+  +:+  \n+#+#+#+#+#+ \n     #+#    \n    ###     \n',
    '8': u'      :::::::: \n    :+:    :+: \n   +:+    +:+  \n   +#++:++#    \n +#+    +#+    \n#+#    #+#     \n########       \n',
    '<': u'      ::: \n    :+:   \n  +:+     \n+#+       \n+#+       \n#+#       \n###       \n',
    '@': u'       :::::::::::  \n    :+: :+:+:+:+:+: \n  +:+ +:+   +:+ +:+ \n +#+ +:+   +#+ +:+  \n+#+ +#+   +#+ +#+   \n#+# #+#+#+#+#+      \n #####              \n',
    'D': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#+    +:+   \n  +#+    +#+    \n #+#    #+#     \n#########       \n',
    'H': u'      :::    ::: \n     :+:    :+:  \n    +:+    +:+   \n   +#++:++#++    \n  +#+    +#+     \n #+#    #+#      \n###    ###       \n',
    'L': u'      :::  \n     :+:   \n    +:+    \n   +#+     \n  +#+      \n #+#       \n########## \n',
    'P': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#++:++#+    \n  +#+           \n #+#            \n###             \n',
    'T': u'  ::::::::::: \n     :+:      \n    +:+       \n   +#+        \n  +#+         \n #+#          \n###           \n',
    'X': u'      :::    ::: \n     :+:    :+:  \n     +:+  +:+    \n     +#++:+      \n   +#+  +#+      \n #+#    #+#      \n###    ###       \n',
    '\\': u'::: \n:+: \n+:+ \n+#+ \n+#+ \n#+# \n### \n',
    '`': u'     ::: \n     :+  \n         \n         \n         \n         \n         \n',
    'd': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#+    +:+   \n  +#+    +#+    \n #+#    #+#     \n#########       \n',
    'h': u'      :::    ::: \n     :+:    :+:  \n    +:+    +:+   \n   +#++:++#++    \n  +#+    +#+     \n #+#    #+#      \n###    ###       \n',
    'l': u'      :::  \n     :+:   \n    +:+    \n   +#+     \n  +#+      \n #+#       \n########## \n',
    'p': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#++:++#+    \n  +#+           \n #+#            \n###             \n',
    't': u'  ::::::::::: \n     :+:      \n    +:+       \n   +#+        \n  +#+         \n #+#          \n###           \n',
    'x': u'      :::    ::: \n     :+:    :+:  \n     +:+  +:+    \n     +#++:+      \n   +#+  +#+      \n #+#    #+#      \n###    ###       \n',
    '|': u'      ::: \n     :+:  \n    +:+   \n          \n  +#+     \n #+#      \n###       \n',
    '#': u'       :::   :::  \n      :+:   :+:   \n  +:+:+:+:+:+:+:+ \n    +#+   +:+     \n+#+#+#+#+#+#+#+   \n  #+#   #+#       \n ###   ###        \n',
    "'": u'      ::: \n     :+   \n          \n          \n          \n          \n          \n',
    '+': u'              \n       :+:    \n      +:+     \n+#++:++#++:++ \n    +#+       \n   #+#        \n              \n',
    '/': u'            ::: \n          :+:   \n        +:+     \n      +#+       \n    +#+         \n  #+#           \n###             \n',
    '3': u'      :::::::: \n    :+:    :+: \n          +:+  \n      +#++:    \n        +#+    \n#+#    #+#     \n########       \n',
    '7': u'  ::::::::::: \n :+:     :+:  \n       +:+    \n     +#+      \n   +#+        \n #+#          \n###           \n',
    ';': u'         \n     :+: \n         \n         \n         \n #+#     \n##       \n',
    '?': u'   ::::::::: \n :+:     :+: \n       +:+   \n     +#+     \n  +#+        \n             \n###          \n',
    'C': u'      :::::::: \n    :+:    :+: \n   +:+         \n  +#+          \n +#+           \n#+#    #+#     \n########       \n',
    'G': u'      :::::::: \n    :+:    :+: \n   +:+         \n  :#:          \n +#+   +#+#    \n#+#    #+#     \n########       \n',
    'K': u'      :::    ::: \n     :+:   :+:   \n    +:+  +:+     \n   +#++:++       \n  +#+  +#+       \n #+#   #+#       \n###    ###       \n',
    'O': u'      :::::::: \n    :+:    :+: \n   +:+    +:+  \n  +#+    +:+   \n +#+    +#+    \n#+#    #+#     \n########       \n',
    'S': u'      :::::::: \n    :+:    :+: \n   +:+         \n  +#++:++#++   \n        +#+    \n#+#    #+#     \n########       \n',
    'W': u'    :::       ::: \n   :+:       :+:  \n  +:+       +:+   \n +#+  +:+  +#+    \n+#+ +#+#+ +#+     \n#+#+# #+#+#       \n###   ###         \n',
    '[': u'      :::::: \n     :+:     \n    +:+      \n   +#+       \n  +#+        \n #+#         \n######       \n',
    '_': u'                \n                \n                \n                \n                \n                \n##########      \n',
    'c': u'      :::::::: \n    :+:    :+: \n   +:+         \n  +#+          \n +#+           \n#+#    #+#     \n########       \n',
    'g': u'      :::::::: \n    :+:    :+: \n   +:+         \n  :#:          \n +#+   +#+#    \n#+#    #+#     \n########       \n',
    'k': u'      :::    ::: \n     :+:   :+:   \n    +:+  +:+     \n   +#++:++       \n  +#+  +#+       \n #+#   #+#       \n###    ###       \n',
    'o': u'      :::::::: \n    :+:    :+: \n   +:+    +:+  \n  +#+    +:+   \n +#+    +#+    \n#+#    #+#     \n########       \n',
    's': u'      :::::::: \n    :+:    :+: \n   +:+         \n  +#++:++#++   \n        +#+    \n#+#    #+#     \n########       \n',
    'w': u'    :::       ::: \n   :+:       :+:  \n  +:+       +:+   \n +#+  +:+  +#+    \n+#+ +#+#+ +#+     \n#+#+# #+#+#       \n###   ###         \n',
    '{': u'      :::: \n    :+:    \n   +:+     \n+#+        \n +#+       \n#+#        \n####       \n',
    '"': u'      ::: ::: \n     :+: :+:  \n              \n              \n              \n              \n              \n',
    '&': u'      :::::::  \n    :+:   :+:  \n    +:+ +:+    \n    +#++:  ++# \n  +#+ +#+#+#   \n#+#   #+#+     \n##########     \n',
    '*': u'                 \n     :+:     :+: \n      +:+ +:+    \n  +#++:++#++:++  \n    +#+ +#+      \n #+#     #+#     \n                 \n',
    '.': u'         \n         \n         \n         \n         \n #+#     \n###      \n',
    '2': u'       :::::::: \n     :+:    :+: \n          +:+   \n       +#+      \n    +#+         \n  #+#           \n##########      \n',
    '6': u'      :::::::: \n    :+:    :+: \n   +:+         \n  +#++:++#+    \n +#+    +#+    \n#+#    #+#     \n########       \n',
    ':': u'         \n     :+: \n         \n         \n         \n #+#     \n         \n',
    '>': u'      ::: \n      :+: \n      +:+ \n      +#+ \n    +#+   \n  #+#     \n###       \n',
    'B': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#++:++#+    \n  +#+    +#+    \n #+#    #+#     \n#########       \n',
    'F': u'      :::::::::: \n     :+:         \n    +:+          \n   :#::+::#      \n  +#+            \n #+#             \n###              \n',
    'J': u'     ::::::::::: \n        :+:      \n       +:+       \n      +#+        \n     +#+         \n#+# #+#          \n#####            \n',
    'N': u'      ::::    ::: \n     :+:+:   :+:  \n    :+:+:+  +:+   \n   +#+ +:+ +#+    \n  +#+  +#+#+#     \n #+#   #+#+#      \n###    ####       \n',
    'R': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#++:++#:    \n  +#+    +#+    \n #+#    #+#     \n###    ###      \n',
    'V': u'   :::     ::: \n  :+:     :+:  \n +:+     +:+   \n+#+     +:+    \n+#+   +#+      \n#+#+#+#        \n ###           \n',
    'Z': u'      ::::::::: \n          :+:   \n        +:+     \n      +#+       \n    +#+         \n  #+#           \n#########       \n',
    '^': u'          :::   \n       :+: :+:  \n    +:+     +:+ \n                \n                \n                \n                \n',
    'b': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#++:++#+    \n  +#+    +#+    \n #+#    #+#     \n#########       \n',
    'f': u'      :::::::::: \n     :+:         \n    +:+          \n   :#::+::#      \n  +#+            \n #+#             \n###              \n',
    'j': u'     ::::::::::: \n        :+:      \n       +:+       \n      +#+        \n     +#+         \n#+# #+#          \n#####            \n',
    'n': u'      ::::    ::: \n     :+:+:   :+:  \n    :+:+:+  +:+   \n   +#+ +:+ +#+    \n  +#+  +#+#+#     \n #+#   #+#+#      \n###    ####       \n',
    'r': u'      ::::::::: \n     :+:    :+: \n    +:+    +:+  \n   +#++:++#:    \n  +#+    +#+    \n #+#    #+#     \n###    ###      \n',
    'v': u'   :::     ::: \n  :+:     :+:  \n +:+     +:+   \n+#+     +:+    \n+#+   +#+      \n#+#+#+#        \n ###           \n',
    'z': u'      ::::::::: \n          :+:   \n        +:+     \n      +#+       \n    +#+         \n  #+#           \n#########       \n',
    '~': u'        :::::   ::: \n     :+:   :+:+:    \n                    \n                    \n                    \n                    \n                    \n',
    '!': u'      ::: \n     :+:  \n    +:+   \n   +#+    \n  +#+     \n          \n###       \n',
    '%': u' :::   :::  \n:+:   :+:   \n     +:+    \n    +#+     \n   +#+      \n  #+#   #+# \n ###   ###  \n',
    ')': u'      ::: \n      :+: \n      +:+ \n     +#+  \n    +#+   \n  #+#     \n###       \n',
    '-': u'                   \n                   \n                   \n   +#++:++#++:++   \n                   \n                   \n                   \n',
    '1': u'        ::: \n     :+:+:  \n      +:+   \n     +#+    \n    +#+     \n   #+#      \n#######     \n',
    '5': u'     :::::::::: \n    :+:    :+:  \n   +:+          \n  +#++:++#+     \n        +#+     \n#+#    #+#      \n########        \n',
    '9': u'      :::::::: \n    :+:    :+: \n   +:+    +:+  \n   +#++:++#+   \n        +#+    \n#+#    #+#     \n########       \n',
    '=': u'                   \n                   \n    +:+:+:+:+:+:+  \n                   \n  +#+#+#+#+#+#+    \n                   \n                   \n',
    'A': u'          :::  \n       :+: :+: \n     +:+   +:+ \n   +#++:++#++: \n  +#+     +#+  \n #+#     #+#   \n###     ###    \n',
    'E': u'      :::::::::: \n     :+:         \n    +:+          \n   +#++:++#      \n  +#+            \n #+#             \n##########       \n',
    'I': u'      ::::::::::: \n         :+:      \n        +:+       \n       +#+        \n      +#+         \n     #+#          \n###########       \n',
    'M': u'        :::   ::: \n      :+:+: :+:+: \n    +:+ +:+:+ +:+ \n   +#+  +:+  +#+  \n  +#+       +#+   \n #+#       #+#    \n###       ###     \n',
    'Q': u'      :::::::: \n    :+:    :+: \n   +:+    +:+  \n  +#+    +:+   \n +#+    +#+    \n#+#    #+#     \n###########    \n',
    'U': u'     :::    ::: \n    :+:    :+:  \n   +:+    +:+   \n  +#+    +:+    \n +#+    +#+     \n#+#    #+#      \n########        \n',
    'Y': u'   :::   ::: \n  :+:   :+:  \n  +:+ +:+    \n  +#++:      \n  +#+        \n #+#         \n###          \n',
    ']': u'      :::::: \n        :+:  \n       +:+   \n      +#+    \n     +#+     \n    #+#      \n######       \n',
    'a': u'          :::  \n       :+: :+: \n     +:+   +:+ \n   +#++:++#++: \n  +#+     +#+  \n #+#     #+#   \n###     ###    \n',
    'e': u'      :::::::::: \n     :+:         \n    +:+          \n   +#++:++#      \n  +#+            \n #+#             \n##########       \n',
    'i': u'      ::::::::::: \n         :+:      \n        +:+       \n       +#+        \n      +#+         \n     #+#          \n###########       \n',
    'm': u'        :::   ::: \n      :+:+: :+:+: \n    +:+ +:+:+ +:+ \n   +#+  +:+  +#+  \n  +#+       +#+   \n #+#       #+#    \n###       ###     \n',
    'q': u'      :::::::: \n    :+:    :+: \n   +:+    +:+  \n  +#+    +:+   \n +#+    +#+    \n#+#    #+#     \n###########    \n',
    'u': u'     :::    ::: \n    :+:    :+:  \n   +:+    +:+   \n  +#+    +:+    \n +#+    +#+     \n#+#    #+#      \n########        \n',
    'y': u'   :::   ::: \n  :+:   :+:  \n  +:+ +:+    \n  +#++:      \n  +#+        \n #+#         \n###          \n',
    '}': u'      :::: \n       :+: \n      +:+  \n       +#+ \n    +#+    \n   #+#     \n####       \n'}

alligator2_dic = {
    ' ': u' \n \n \n \n \n \n \n',
    '$': u'     :::     \n  :+:+:+:+:  \n+:+  +:+     \n  +#++:++#+  \n     +#+ +#+ \n  #+#+#+#+#  \n     ###     \n',
    '(': u'  ::: \n :+:  \n+:+   \n+#+   \n+#+   \n #+#  \n  ### \n',
    ',': u'    \n    \n    \n    \n    \n#+# \n##  \n',
    '0': u' :::::::  \n:+:   :+: \n+:+  :+:+ \n+#+ + +:+ \n+#+#  +#+ \n#+#   #+# \n #######  \n',
    '4': u'    :::     \n   :+:      \n  +:+ +:+   \n +#+  +:+   \n+#+#+#+#+#+ \n      #+#   \n      ###   \n',
    '8': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n +#++:++#  \n+#+    +#+ \n#+#    #+# \n ########  \n',
    '<': u'   ::: \n  :+:  \n +:+   \n+#+    \n +#+   \n  #+#  \n   ### \n',
    '@': u'   :::::::::::    \n :+: :+:+:+:+:+:  \n+:+ +:+   +:+ +:+ \n+#+ +:+   +#+ +:+ \n+#+ +#+   +#+ +#+ \n #+# #+#+#+#+#+   \n   #####          \n',
    'D': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n#########  \n',
    'H': u':::    ::: \n:+:    :+: \n+:+    +:+ \n+#++:++#++ \n+#+    +#+ \n#+#    #+# \n###    ### \n',
    'L': u':::        \n:+:        \n+:+        \n+#+        \n+#+        \n#+#        \n########## \n',
    'P': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#+  \n+#+        \n#+#        \n###        \n',
    'T': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n    #+#     \n    ###     \n',
    'X': u':::    ::: \n:+:    :+: \n +:+  +:+  \n  +#++:+   \n +#+  +#+  \n#+#    #+# \n###    ### \n',
    '\\': u':::       \n :+:      \n  +:+     \n   +#+    \n    +#+   \n     #+#  \n      ### \n',
    '`': u'::: \n :+ \n    \n    \n    \n    \n    \n',
    'd': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n#########  \n',
    'h': u':::    ::: \n:+:    :+: \n+:+    +:+ \n+#++:++#++ \n+#+    +#+ \n#+#    #+# \n###    ### \n',
    'l': u':::        \n:+:        \n+:+        \n+#+        \n+#+        \n#+#        \n########## \n',
    'p': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#+  \n+#+        \n#+#        \n###        \n',
    't': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n    #+#     \n    ###     \n',
    'x': u':::    ::: \n:+:    :+: \n +:+  +:+  \n  +#++:+   \n +#+  +#+  \n#+#    #+# \n###    ### \n',
    '|': u'::: \n:+: \n+:+ \n    \n+#+ \n#+# \n### \n',
    '#': u'   :::   :::    \n   :+:   :+:    \n+:+:+:+:+:+:+:+ \n   +#+   +:+    \n+#+#+#+#+#+#+#+ \n   #+#   #+#    \n   ###   ###    \n',
    "'": u'::: \n:+  \n    \n    \n    \n    \n    \n',
    '+': u'              \n     :+:      \n     +:+      \n+#++:++#++:++ \n     +#+      \n     #+#      \n              \n',
    '/': u'      ::: \n     :+:  \n    +:+   \n   +#+    \n  +#+     \n #+#      \n###       \n',
    '3': u' ::::::::  \n:+:    :+: \n       +:+ \n    +#++:  \n       +#+ \n#+#    #+# \n ########  \n',
    '7': u'::::::::::: \n:+:     :+: \n       +:+  \n      +#+   \n     +#+    \n    #+#     \n    ###     \n',
    ';': u'    \n:+: \n    \n    \n    \n#+# \n##  \n',
    '?': u' :::::::::  \n:+:     :+: \n       +:+  \n      +#+   \n    +#+     \n            \n    ###     \n',
    'C': u' ::::::::  \n:+:    :+: \n+:+        \n+#+        \n+#+        \n#+#    #+# \n ########  \n',
    'G': u' ::::::::  \n:+:    :+: \n+:+        \n:#:        \n+#+   +#+# \n#+#    #+# \n ########  \n',
    'K': u':::    ::: \n:+:   :+:  \n+:+  +:+   \n+#++:++    \n+#+  +#+   \n#+#   #+#  \n###    ### \n',
    'O': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n ########  \n',
    'S': u' ::::::::  \n:+:    :+: \n+:+        \n+#++:++#++ \n       +#+ \n#+#    #+# \n ########  \n',
    'W': u':::       ::: \n:+:       :+: \n+:+       +:+ \n+#+  +:+  +#+ \n+#+ +#+#+ +#+ \n #+#+# #+#+#  \n  ###   ###   \n',
    '[': u':::::: \n:+:    \n+:+    \n+#+    \n+#+    \n#+#    \n###### \n',
    '_': u'           \n           \n           \n           \n           \n           \n########## \n',
    'c': u' ::::::::  \n:+:    :+: \n+:+        \n+#+        \n+#+        \n#+#    #+# \n ########  \n',
    'g': u' ::::::::  \n:+:    :+: \n+:+        \n:#:        \n+#+   +#+# \n#+#    #+# \n ########  \n',
    'k': u':::    ::: \n:+:   :+:  \n+:+  +:+   \n+#++:++    \n+#+  +#+   \n#+#   #+#  \n###    ### \n',
    'o': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n ########  \n',
    's': u' ::::::::  \n:+:    :+: \n+:+        \n+#++:++#++ \n       +#+ \n#+#    #+# \n ########  \n',
    'w': u':::       ::: \n:+:       :+: \n+:+       +:+ \n+#+  +:+  +#+ \n+#+ +#+#+ +#+ \n #+#+# #+#+#  \n  ###   ###   \n',
    '{': u'   :::: \n  :+:   \n  +:+   \n+#+     \n  +#+   \n  #+#   \n   #### \n',
    '"': u'::: ::: \n:+: :+: \n        \n        \n        \n        \n        \n',
    '&': u' :::::::     \n:+:   :+:    \n +:+ +:+     \n  +#++:  ++# \n +#+ +#+#+#  \n#+#   #+#+   \n ##########  \n',
    '*': u'              \n :+:     :+:  \n   +:+ +:+    \n+#++:++#++:++ \n   +#+ +#+    \n #+#     #+#  \n              \n',
    '.': u'    \n    \n    \n    \n    \n#+# \n### \n',
    '2': u' ::::::::  \n:+:    :+: \n      +:+  \n    +#+    \n  +#+      \n #+#       \n########## \n',
    '6': u' ::::::::  \n:+:    :+: \n+:+        \n+#++:++#+  \n+#+    +#+ \n#+#    #+# \n ########  \n',
    ':': u'    \n:+: \n    \n    \n    \n#+# \n    \n',
    '>': u' :::    \n  :+:   \n   +:+  \n    +#+ \n   +#+  \n  #+#   \n###     \n',
    'B': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#+  \n+#+    +#+ \n#+#    #+# \n#########  \n',
    'F': u':::::::::: \n:+:        \n+:+        \n:#::+::#   \n+#+        \n#+#        \n###        \n',
    'J': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n#+# #+#     \n #####      \n',
    'N': u'::::    ::: \n:+:+:   :+: \n:+:+:+  +:+ \n+#+ +:+ +#+ \n+#+  +#+#+# \n#+#   #+#+# \n###    #### \n',
    'R': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#:  \n+#+    +#+ \n#+#    #+# \n###    ### \n',
    'V': u':::     ::: \n:+:     :+: \n+:+     +:+ \n+#+     +:+ \n +#+   +#+  \n  #+#+#+#   \n    ###     \n',
    'Z': u'::::::::: \n     :+:  \n    +:+   \n   +#+    \n  +#+     \n #+#      \n######### \n',
    '^': u'    :::     \n  :+: :+:   \n+:+     +:+ \n            \n            \n            \n            \n',
    'b': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#+  \n+#+    +#+ \n#+#    #+# \n#########  \n',
    'f': u':::::::::: \n:+:        \n+:+        \n:#::+::#   \n+#+        \n#+#        \n###        \n',
    'j': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n#+# #+#     \n #####      \n',
    'n': u'::::    ::: \n:+:+:   :+: \n:+:+:+  +:+ \n+#+ +:+ +#+ \n+#+  +#+#+# \n#+#   #+#+# \n###    #### \n',
    'r': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#:  \n+#+    +#+ \n#+#    #+# \n###    ### \n',
    'v': u':::     ::: \n:+:     :+: \n+:+     +:+ \n+#+     +:+ \n +#+   +#+  \n  #+#+#+#   \n    ###     \n',
    'z': u'::::::::: \n     :+:  \n    +:+   \n   +#+    \n  +#+     \n #+#      \n######### \n',
    '~': u'  :::::   ::: \n:+:   :+:+:   \n              \n              \n              \n              \n              \n',
    '!': u'::: \n:+: \n+:+ \n+#+ \n+#+ \n    \n### \n',
    '%': u':::   :::       \n:+:   :+:       \n      +:+       \n      +#+       \n      +#+       \n      #+#   #+# \n      ###   ### \n',
    ')': u':::   \n :+:  \n  +:+ \n  +#+ \n  +#+ \n #+#  \n###   \n',
    '-': u'              \n              \n              \n+#++:++#++:++ \n              \n              \n              \n',
    '1': u'  :::   \n:+:+:   \n  +:+   \n  +#+   \n  +#+   \n  #+#   \n####### \n',
    '5': u':::::::::: \n:+:    :+: \n+:+        \n+#++:++#+  \n       +#+ \n#+#    #+# \n ########  \n',
    '9': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n +#++:++#+ \n       +#+ \n#+#    #+# \n ########  \n',
    '=': u'              \n              \n+:+:+:+:+:+:+ \n              \n+#+#+#+#+#+#+ \n              \n              \n',
    'A': u'    :::     \n  :+: :+:   \n +:+   +:+  \n+#++:++#++: \n+#+     +#+ \n#+#     #+# \n###     ### \n',
    'E': u':::::::::: \n:+:        \n+:+        \n+#++:++#   \n+#+        \n#+#        \n########## \n',
    'I': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n    #+#     \n########### \n',
    'M': u'::::    ::::  \n+:+:+: :+:+:+ \n+:+ +:+:+ +:+ \n+#+  +:+  +#+ \n+#+       +#+ \n#+#       #+# \n###       ### \n',
    'Q': u' ::::::::   \n:+:    :+:  \n+:+    +:+  \n+#+    +:+  \n+#+  # +#+  \n#+#   +#+   \n ###### ### \n',
    'U': u':::    ::: \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n ########  \n',
    'Y': u':::   ::: \n:+:   :+: \n +:+ +:+  \n  +#++:   \n   +#+    \n   #+#    \n   ###    \n',
    ']': u':::::: \n   :+: \n   +:+ \n   +#+ \n   +#+ \n   #+# \n###### \n',
    'a': u'    :::     \n  :+: :+:   \n +:+   +:+  \n+#++:++#++: \n+#+     +#+ \n#+#     #+# \n###     ### \n',
    'e': u':::::::::: \n:+:        \n+:+        \n+#++:++#   \n+#+        \n#+#        \n########## \n',
    'i': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n    #+#     \n########### \n',
    'm': u'::::    ::::  \n+:+:+: :+:+:+ \n+:+ +:+:+ +:+ \n+#+  +:+  +#+ \n+#+       +#+ \n#+#       #+# \n###       ### \n',
    'q': u' ::::::::   \n:+:    :+:  \n+:+    +:+  \n+#+    +:+  \n+#+  # +#+  \n#+#   +#+   \n ###### ### \n',
    'u': u':::    ::: \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n ########  \n',
    'y': u':::   ::: \n:+:   :+: \n +:+ +:+  \n  +#++:   \n   +#+    \n   #+#    \n   ###    \n',
    '}': u'::::    \n  :+:   \n  +:+   \n    +#+ \n  +#+   \n  #+#   \n####    \n'}

block2_dic = {
    '!': u'    \n_|  \n_|  \n_|  \n    \n_|  \n    \n    \n',
    ' ': u'    \n    \n    \n    \n    \n    \n    \n    \n',
    '#': u'            \n  _|  _|    \n_|_|_|_|_|  \n  _|  _|    \n_|_|_|_|_|  \n  _|  _|    \n            \n            \n',
    '"': u'_|  _|  \n_|  _|  \n        \n        \n        \n        \n        \n        \n',
    '%': u'            \n_|_|    _|  \n_|_|  _|    \n    _|      \n  _|  _|_|  \n_|    _|_|  \n            \n            \n',
    '$': u'        \n  _|    \n_|_|_|  \n_|_|    \n  _|_|  \n_|_|_|  \n  _|    \n        \n',
    "'": u'  _|  \n_|    \n      \n      \n      \n      \n      \n      \n',
    '&': u'            \n  _|        \n_|  _|      \n  _|_|  _|  \n_|    _|    \n  _|_|  _|  \n            \n            \n',
    ')': u'_|    \n  _|  \n  _|  \n  _|  \n  _|  \n  _|  \n_|    \n      \n',
    '(': u'  _|  \n_|    \n_|    \n_|    \n_|    \n_|    \n  _|  \n      \n',
    '+': u'            \n    _|      \n    _|      \n_|_|_|_|_|  \n    _|      \n    _|      \n            \n            \n',
    '*': u'            \n_|  _|  _|  \n  _|_|_|    \n_|_|_|_|_|  \n  _|_|_|    \n_|  _|  _|  \n            \n            \n',
    '-': u'            \n            \n            \n_|_|_|_|_|  \n            \n            \n            \n            \n',
    ',': u'      \n      \n      \n      \n      \n  _|  \n_|    \n      \n',
    '/': u'            \n        _|  \n      _|    \n    _|      \n  _|        \n_|          \n            \n            \n',
    '.': u'    \n    \n    \n    \n    \n_|  \n    \n    \n',
    '1': u'      \n  _|  \n_|_|  \n  _|  \n  _|  \n  _|  \n      \n      \n',
    '0': u'        \n  _|    \n_|  _|  \n_|  _|  \n_|  _|  \n  _|    \n        \n        \n',
    '3': u'          \n_|_|_|    \n      _|  \n  _|_|    \n      _|  \n_|_|_|    \n          \n          \n',
    '2': u'          \n  _|_|    \n_|    _|  \n    _|    \n  _|      \n_|_|_|_|  \n          \n          \n',
    '5': u'          \n_|_|_|_|  \n_|        \n_|_|_|    \n      _|  \n_|_|_|    \n          \n          \n',
    '4': u'          \n_|  _|    \n_|  _|    \n_|_|_|_|  \n    _|    \n    _|    \n          \n          \n',
    '7': u'            \n_|_|_|_|_|  \n        _|  \n      _|    \n    _|      \n  _|        \n            \n            \n',
    '6': u'          \n  _|_|_|  \n_|        \n_|_|_|    \n_|    _|  \n  _|_|    \n          \n          \n',
    '9': u'          \n  _|_|    \n_|    _|  \n  _|_|_|  \n      _|  \n_|_|_|    \n          \n          \n',
    '8': u'          \n  _|_|    \n_|    _|  \n  _|_|    \n_|    _|  \n  _|_|    \n          \n          \n',
    ';': u'      \n      \n  _|  \n      \n      \n  _|  \n_|    \n      \n',
    ':': u'    \n    \n_|  \n    \n    \n_|  \n    \n    \n',
    '=': u'            \n            \n_|_|_|_|_|  \n            \n_|_|_|_|_|  \n            \n            \n            \n',
    '<': u'        \n    _|  \n  _|    \n_|      \n  _|    \n    _|  \n        \n        \n',
    '?': u'        \n_|_|    \n    _|  \n_|_|    \n        \n_|      \n        \n        \n',
    '>': u'        \n_|      \n  _|    \n    _|  \n  _|    \n_|      \n        \n        \n',
    '@': u'                  \n    _|_|_|_|_|    \n  _|          _|  \n_|    _|_|_|  _|  \n_|  _|    _|  _|  \n_|    _|_|_|_|    \n  _|              \n    _|_|_|_|_|_|  \n',
    '[': u'_|_|  \n_|    \n_|    \n_|    \n_|    \n_|    \n_|_|  \n      \n',
    ']': u'_|_|  \n  _|  \n  _|  \n  _|  \n  _|  \n  _|  \n_|_|  \n      \n',
    '\\': u'            \n_|          \n  _|        \n    _|      \n      _|    \n        _|  \n            \n            \n',
    '_': u'            \n            \n            \n            \n            \n            \n            \n_|_|_|_|_|  \n',
    '^': u'  _|    \n_|  _|  \n        \n        \n        \n        \n        \n        \n',
    'a': u'          \n          \n  _|_|_|  \n_|    _|  \n_|    _|  \n  _|_|_|  \n          \n          \n',
    '`': u'_|    \n  _|  \n      \n      \n      \n      \n      \n      \n',
    'c': u'          \n          \n  _|_|_|  \n_|        \n_|        \n  _|_|_|  \n          \n          \n',
    'b': u'          \n_|        \n_|_|_|    \n_|    _|  \n_|    _|  \n_|_|_|    \n          \n          \n',
    'e': u'          \n          \n  _|_|    \n_|_|_|_|  \n_|        \n  _|_|_|  \n          \n          \n',
    'd': u'          \n      _|  \n  _|_|_|  \n_|    _|  \n_|    _|  \n  _|_|_|  \n          \n          \n',
    'g': u'          \n          \n  _|_|_|  \n_|    _|  \n_|    _|  \n  _|_|_|  \n      _|  \n  _|_|    \n',
    'f': u'          \n    _|_|  \n  _|      \n_|_|_|_|  \n  _|      \n  _|      \n          \n          \n',
    'i': u'    \n_|  \n    \n_|  \n_|  \n_|  \n    \n    \n',
    'h': u'          \n_|        \n_|_|_|    \n_|    _|  \n_|    _|  \n_|    _|  \n          \n          \n',
    'k': u'          \n_|        \n_|  _|    \n_|_|      \n_|  _|    \n_|    _|  \n          \n          \n',
    'j': u'      \n  _|  \n      \n  _|  \n  _|  \n  _|  \n  _|  \n_|    \n',
    'm': u'                \n                \n_|_|_|  _|_|    \n_|    _|    _|  \n_|    _|    _|  \n_|    _|    _|  \n                \n                \n',
    'l': u'    \n_|  \n_|  \n_|  \n_|  \n_|  \n    \n    \n',
    'o': u'          \n          \n  _|_|    \n_|    _|  \n_|    _|  \n  _|_|    \n          \n          \n',
    'n': u'          \n          \n_|_|_|    \n_|    _|  \n_|    _|  \n_|    _|  \n          \n          \n',
    'q': u'          \n          \n  _|_|_|  \n_|    _|  \n_|    _|  \n  _|_|_|  \n      _|  \n      _|  \n',
    'p': u'          \n          \n_|_|_|    \n_|    _|  \n_|    _|  \n_|_|_|    \n_|        \n_|        \n',
    's': u'          \n          \n  _|_|_|  \n_|_|      \n    _|_|  \n_|_|_|    \n          \n          \n',
    'r': u'          \n          \n_|  _|_|  \n_|_|      \n_|        \n_|        \n          \n          \n',
    'u': u'          \n          \n_|    _|  \n_|    _|  \n_|    _|  \n  _|_|_|  \n          \n          \n',
    't': u'          \n  _|      \n_|_|_|_|  \n  _|      \n  _|      \n    _|_|  \n          \n          \n',
    'w': u'                    \n                    \n_|      _|      _|  \n_|      _|      _|  \n  _|  _|  _|  _|    \n    _|      _|      \n                    \n                    \n',
    'v': u'            \n            \n_|      _|  \n_|      _|  \n  _|  _|    \n    _|      \n            \n            \n',
    'y': u'          \n          \n_|    _|  \n_|    _|  \n_|    _|  \n  _|_|_|  \n      _|  \n  _|_|    \n',
    'x': u'          \n          \n_|    _|  \n  _|_|    \n_|    _|  \n_|    _|  \n          \n          \n',
    '{': u'    _|  \n  _|    \n  _|    \n_|      \n  _|    \n  _|    \n    _|  \n        \n',
    'z': u'          \n          \n_|_|_|_|  \n    _|    \n  _|      \n_|_|_|_|  \n          \n          \n',
    '}': u'_|      \n  _|    \n  _|    \n    _|  \n  _|    \n  _|    \n_|      \n        \n',
    '|': u'_|  \n_|  \n_|  \n_|  \n_|  \n_|  \n_|  \n_|  \n',
    '~': u'  _|  _|  \n_|  _|    \n          \n          \n          \n          \n          \n          \n'}

caligraphy_dic = {
    '!': u'  \n  \n  \n  \n  \n  \n  \n  \n  \ne \nx \nc \nl \na \nm \na \nt \ni \no \nn \n  \n',
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n',
    '#': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \np \no \nu \nn \nd \n  \n',
    '"': u'  \n  \n  \n  \n  \n  \n  \n  \n  \nd \no \nu \nb \nl \ne \nq \nu \no \nt \ne \n  \n',
    '%': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \np \ne \nr \nc \ne \nn \nt \n  \n',
    '$': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nd \no \nl \nl \na \nr \n  \n',
    "'": u'  \n  \n  \n  \n  \n  \n  \n  \n  \ns \ni \nn \ng \nl \ne \nq \nu \no \nt \ne \n  \n',
    '&': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \na \nm \np \ne \nr \ns \na \nn \nd \n  \n',
    ')': u'  \n  \n  \n  \n  \nc \nl \no \ns \ne \np \na \nr \ne \nn \nt \nh \ne \ns \ny \n  \n',
    '(': u'  \n  \n  \n  \n  \n  \no \np \ne \nn \np \na \nr \ne \nn \nt \nh \ne \ns \ny \n  \n',
    '+': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \np \nl \nu \ns \n  \n',
    '*': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \na \ns \nt \ne \nr \ni \ns \nt \n  \n',
    '-': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nm \ni \nn \nu \ns \n  \n',
    ',': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nc \no \nm \nm \na \n  \n',
    '/': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \ns \nl \na \ns \nh \n  \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \np \ne \nr \ni \no \nd \n  \n',
    '1': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n1 \n  \n',
    '0': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n0 \n  \n',
    '3': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n3 \n  \n',
    '2': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n2 \n  \n',
    '5': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n5 \n  \n',
    '4': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n4 \n  \n',
    '7': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n7 \n  \n',
    '6': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n6 \n  \n',
    '9': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n9 \n  \n',
    '8': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nn \nu \nm \nb \ne \nr \n8 \n  \n',
    ';': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \ns \ne \nm \ni \nc \no \nl \no \nn \n  \n',
    ':': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nc \no \nl \no \nn \n  \n',
    '=': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \ne \nq \nu \na \nl \n  \n',
    '<': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nl \ne \ns \ns \ne \nr \n  \n',
    '?': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nq \nu \ne \ns \nt \ni \no \nn \n  \n',
    '>': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \ng \nr \ne \na \nt \ne \nr \n  \n',
    '@': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \na \nt \n  \n',
    '[': u'  \n  \n  \n  \n  \n  \n  \n  \n  \nl \ne \nf \nt \nb \nr \na \nc \nk \ne \nt \n  \n',
    ']': u'  \n  \n  \n  \n  \n  \n  \n  \nr \ni \ng \nh \nt \nb \nr \na \nc \nk \ne \nt \n  \n',
    '\\': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nb \na \nc \nk \ns \nl \na \ns \nh \n  \n',
    '_': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nu \nn \nd \ne \nr \ns \nc \no \nr \ne \n  \n',
    '^': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nc \na \nr \ne \nt \n  \n',
    'a': u'           \n           \n           \n           \n           \n           \n   ****    \n  * ***  * \n *   ****  \n**    **   \n**    **   \n**    **   \n**    **   \n**    **   \n ***** **  \n  ***   ** \n           \n           \n           \n           \n           \n',
    '`': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nl \ne \nf \nt \nq \nu \no \nt \ne \n  \n',
    'c': u'           \n           \n           \n           \n           \n           \n   ****    \n  * ***  * \n *   ****  \n**         \n**         \n**         \n**         \n***     *  \n *******   \n  *****    \n           \n           \n           \n           \n           \n',
    'b': u'           \n  *        \n**         \n**         \n**         \n**         \n** ****    \n*** ***  * \n**   ****  \n**    **   \n**    **   \n**    **   \n**    **   \n**    **   \n *****     \n  ***      \n           \n           \n           \n           \n           \n',
    'e': u'          \n          \n          \n          \n          \n          \n   ***    \n  * ***   \n *   ***  \n**    *** \n********  \n*******   \n**        \n****    * \n *******  \n  *****   \n          \n          \n          \n          \n          \n',
    'd': u'           \n     **    \n      **   \n      **   \n      **   \n      **   \n  *** **   \n ********* \n**   ****  \n**    **   \n**    **   \n**    **   \n**    **   \n**    **   \n *****     \n  ***      \n           \n           \n           \n           \n           \n',
    'g': u'              \n              \n              \n              \n              \n              \n    ****      \n   *  ***  *  \n  *    ****   \n **     **    \n **     **    \n **     **    \n **     **    \n **     **    \n  ********    \n    *** ***   \n         ***  \n   ****   *** \n *******  **  \n*     ****    \n              \n',
    'f': u'         \n   ***   \n ** ***  \n**   *** \n**       \n**       \n******   \n*****    \n**       \n**       \n**       \n**       \n**       \n**       \n**       \n **      \n         \n         \n         \n         \n         \n',
    'i': u'        \n        \n  *     \n ***    \n  *     \n        \n***     \n ***    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  *** * \n   ***  \n        \n        \n        \n        \n        \n',
    'h': u'          \n  *       \n**        \n**        \n**        \n**        \n**  ***   \n** * ***  \n***   *** \n**     ** \n**     ** \n**     ** \n**     ** \n**     ** \n**     ** \n **    ** \n       *  \n      *   \n     *    \n    *     \n          \n',
    'k': u'           \n  *        \n**         \n**         \n**         \n**         \n**  ***    \n** * ***   \n***   *    \n**   *     \n**  *      \n** **      \n******     \n**  ***    \n**   *** * \n **   ***  \n           \n           \n           \n           \n           \n',
    'j': u'       \n       \n  *    \n ***   \n  *    \n       \n***    \n ***   \n  **   \n  *    \n *     \n***    \n ***   \n  ***  \n   *** \n    ** \n    ** \n    *  \n   *   \n  *    \n       \n',
    'm': u'                 \n                 \n                 \n                 \n                 \n                 \n*** **** ****    \n *** **** ***  * \n  **  **** ****  \n  **   **   **   \n  **   **   **   \n  **   **   **   \n  **   **   **   \n  **   **   **   \n  ***  ***  ***  \n   ***  ***  *** \n                 \n                 \n                 \n                 \n                 \n',
    'l': u'        \n***     \n ***    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  **    \n  *** * \n   ***  \n        \n        \n        \n        \n        \n',
    'o': u'           \n           \n           \n           \n           \n   ****    \n  * ***  * \n *   ****  \n**    **   \n**    **   \n**    **   \n**    **   \n**    **   \n ******    \n  ****     \n           \n           \n           \n           \n           \n           \n',
    'n': u'             \n             \n             \n             \n             \n             \n***  ****    \n **** **** * \n  **   ****  \n  **    **   \n  **    **   \n  **    **   \n  **    **   \n  **    **   \n  ***   ***  \n   ***   *** \n             \n             \n             \n             \n             \n',
    'q': u'           \n           \n           \n           \n           \n   ****    \n  * ***  * \n *   ****  \n**    **   \n**    **   \n**    **   \n**    **   \n**    **   \n *******   \n  ******   \n      **   \n      **   \n      **   \n       **  \n           \n           \n',
    'p': u'           \n           \n           \n           \n           \n   ****    \n  * ***  * \n *   ****  \n**    **   \n**    **   \n**    **   \n**    **   \n**    **   \n*******    \n******     \n**         \n**         \n**         \n **        \n           \n           \n',
    's': u'           \n           \n           \n           \n           \n   ****    \n  * **** * \n **  ****  \n****       \n  ***      \n    ***    \n      ***  \n ****  **  \n* **** *   \n   ****    \n           \n           \n           \n           \n           \n           \n',
    'r': u'             \n             \n             \n             \n             \n***  ****    \n **** **** * \n  **   ****  \n  **         \n  **         \n  **         \n  **         \n  **         \n  ***        \n   ***       \n             \n             \n             \n             \n             \n             \n',
    'u': u'              \n              \n              \n              \n              \n**   ****     \n **    ***  * \n **     ****  \n **      **   \n **      **   \n **      **   \n **      **   \n **      **   \n  ******* **  \n   *****   ** \n              \n              \n              \n              \n              \n              \n',
    't': u'          \n          \n    *     \n   **     \n   **     \n ******** \n********  \n   **     \n   **     \n   **     \n   **     \n   **     \n   **     \n   **     \n    **    \n          \n          \n          \n          \n          \n          \n',
    'w': u'                       \n                       \n                       \n**                     \n**                     \n **    ***    ****     \n  **    ***     ***  * \n  **     ***     ****  \n  **      **      **   \n  **      **      **   \n  **      **      **   \n  **      **      **   \n  **      **      *    \n   ******* *******     \n    *****   *****      \n                       \n                       \n                       \n                       \n                       \n                       \n',
    'v': u'             \n             \n             \n**           \n**           \n **    ***   \n  **    ***  \n  **     *** \n  **      ** \n  **      ** \n  **      ** \n  **      ** \n  **      *  \n   *******   \n    *****    \n             \n             \n             \n             \n             \n             \n',
    'y': u'               \n               \n               \n               \n               \n**   ****      \n **    ***  *  \n **     ****   \n **      **    \n **      **    \n **      **    \n **      **    \n **      **    \n  *********    \n    **** ***   \n          ***  \n   *****   *** \n ********  **  \n*      ****    \n               \n               \n',
    'x': u'               \n               \n               \n               \n               \n ***    ***    \n* ***  **** *  \n   *** *****   \n    ***  **    \n     ***       \n    * ***      \n   *   ***     \n  *     ***    \n *       *** * \n*         ***  \n               \n               \n               \n               \n               \n               \n',
    '{': u'  \n  \n  \n  \nl \ne \nf \nt \nc \nu \nr \nl \ny \nb \nr \na \nc \nk \ne \nt \n  \n',
    'z': u'           \n           \n           \n           \n           \n  ******   \n ********  \n*      **  \n       *   \n      *    \n     ***   \n      ***  \n       *** \n        ** \n        ** \n        *  \n       *   \n      *    \n     *     \n           \n           \n',
    '}': u'  \n  \n  \nr \ni \ng \nh \nt \nc \nr \nu \nl \ny \nb \nr \na \nc \nk \ne \nt \n  \n',
    '|': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \np \ni \np \ne \n  \n',
    '~': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \nt \ni \nd \nl \ne \n  \n'}

computer_dic = {
    '!': u'8  \n88 \n88 \n88 \n   \n88 \n   \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '#': u'     dP dP  \n  888888888 \n   dP dP    \n888888888   \n dP dP      \n            \n            \n',
    '"': u'8 8 \n" " \n    \n    \n    \n    \n    \n',
    '%': u'8"8  dP \n8e8 dP  \n   dP   \n  dP    \n dP 8"8 \ndP  8e8 \n        \n',
    '$': u'ee8ee \n8   8 \n8eeee \n   88 \ne  88 \n8ee88 \n  8   \n',
    "'": u'88 \n 8 \n   \n   \n   \n   \n   \n',
    '&': u' 888888 \n 8   ,  \n88eee8e \n88   8  \n88   8  \n88eee8  \n        \n',
    ')': u'"8 \n 8 \n 8 \n 8 \n 8 \ne8 \n   \n',
    '(': u'8" \n8  \n8  \n8  \n8  \n8e \n   \n',
    '+': u'      \n      \n  8   \nee8ee \n  8   \n      \n      \n',
    '*': u'\\|/ \n/|\\ \n    \n    \n    \n    \n    \n',
    '-': u'     \n     \n     \neeee \n     \n     \n     \n',
    ',': u'   \n   \n   \n   \n   \n88 \n 8 \n',
    '/': u'     / \n    /  \n   /   \n  /    \n /     \n/      \n       \n',
    '.': u'   \n   \n   \n   \n   \n88 \n   \n',
    '1': u'88   \n 8   \n 8   \n 8   \n8888 \n8888 \n     \n',
    '0': u'eeeeee \n8    8 \n8    8 \n8    8 \n8    8 \n8eeee8 \n       \n',
    '3': u'eeee  \n   8  \n   8  \neee8  \n   88 \neee88 \n      \n',
    '2': u'eeee \n   8 \n   8 \neee8 \n8    \n8eee \n     \n',
    '5': u'eeeee \n8     \n8eeee \n    8 \n    8 \neeee8 \n      \n',
    '4': u'88     \n88     \n88  88 \n88ee88 \n    88 \n    88 \n       \n',
    '7': u"eeeee \n8   8 \n   e' \n  e'  \n  8   \n  8   \n      \n",
    '6': u'eeee  \n8  8  \n8     \n8eeee \n8   8 \n8eee8 \n      \n',
    '9': u'eeeee \n8   8 \n8eee8 \n   88 \n   88 \n   88 \n      \n',
    '8': u' eeeee  \n 8   8  \n 8eee8  \n88   88 \n88   88 \n88eee88 \n        \n',
    ';': u'   \n   \n   \n88 \n   \n88 \n 8 \n',
    ':': u'   \n   \n   \n88 \n   \n88 \n   \n',
    '=': u'      \n      \n      \neeeee \neeeee \n      \n      \n',
    '<': u'    e8" \n  e8"   \ne8"     \n"8e     \n  "8e   \n    "8e \n        \n',
    '?': u'8""""8 \n     8 \neeeee8 \n88     \n""     \n88     \n       \n',
    '>': u'"8e     \n  "8e   \n    "8e \n    e8" \n  e8"   \ne8"     \n        \n',
    '@': u"    __     \n  .'  `.   \n / eeee \\  \n|  8ee8  | \n \\ 88 8 /  \n  `.__.'   \n           \n",
    '[': u'8" \n8  \n8  \n8  \n8  \n8e \n   \n',
    ']': u'"8 \n 8 \n 8 \n 8 \n 8 \ne8 \n   \n',
    '\\': u'\\      \n \\     \n  \\    \n   \\   \n    \\  \n     \\ \n       \n',
    '_': u'      \n      \n      \n      \n      \n      \neeeee \n',
    '^': u'/\\ \n   \n   \n   \n   \n   \n   \n',
    'a': u'      \neeeee \n8   8 \n8eee8 \n88  8 \n88  8 \n      \n',
    '`': u'\\  \n \\ \n   \n   \n   \n   \n   \n',
    'c': u'     \neeee \n8  8 \n8e   \n88   \n88e8 \n     \n',
    'b': u'       \neeeee  \n8   8  \n8eee8e \n88   8 \n88eee8 \n       \n',
    'e': u'     \neeee \n8    \n8eee \n88   \n88ee \n     \n',
    'd': u'      \neeeee \n8   8 \n8e  8 \n88  8 \n88ee8 \n      \n',
    'g': u'      \neeeee \n8   8 \n8e    \n88 "8 \n88ee8 \n      \n',
    'f': u'     \neeee \n8    \n8eee \n88   \n88   \n     \n',
    'i': u'   \ne  \n8  \n8e \n88 \n88 \n   \n',
    'h': u'      \ne   e \n8   8 \n8eee8 \n88  8 \n88  8 \n      \n',
    'k': u'       \ne   e  \n8   8  \n8eee8e \n88   8 \n88   8 \n       \n',
    'j': u'      \n   e  \n   8  \n   8e \ne  88 \n8ee88 \n      \n',
    'm': u'        \neeeeeee \n8  8  8 \n8e 8  8 \n88 8  8 \n88 8  8 \n        \n',
    'l': u'      \ne     \n8     \n8e    \n88    \n88eee \n      \n',
    'o': u'      \neeeee \n8  88 \n8   8 \n8   8 \n8eee8 \n      \n',
    'n': u'      \neeeee \n8   8 \n8e  8 \n88  8 \n88  8 \n      \n',
    'q': u'      \neeeee \n8   8 \n8   8 \n8 __8 \n8e888 \n      \n',
    'p': u'      \neeeee \n8   8 \n8eee8 \n88    \n88    \n      \n',
    's': u'      \neeeee \n8   " \n8eeee \n   88 \n8ee88 \n      \n',
    'r': u'       \neeeee  \n8   8  \n8eee8e \n88   8 \n88   8 \n       \n',
    'u': u'      \ne   e \n8   8 \n8e  8 \n88  8 \n88ee8 \n      \n',
    't': u'      \neeeee \n  8   \n  8e  \n  88  \n  88  \n      \n',
    'w': u'         \ne   e  e \n8   8  8 \n8e  8  8 \n88  8  8 \n88ee8ee8 \n         \n',
    'v': u'       \nee   e \n88   8 \n88  e8 \n 8  8  \n 8ee8  \n       \n',
    'y': u'       \ne    e \n8    8 \n8eeee8 \n  88   \n  88   \n       \n',
    'x': u'       \ne    e \n8    8 \neeeeee \n88   8 \n88   8 \n       \n',
    '{': u'  /" \n |   \n |   \n<    \n |   \n |   \n  \\_ \n',
    'z': u'      \neeeee \n"   8 \neeee8 \n88    \n88ee8 \n      \n',
    '}': u'"\\   \n  |  \n  |  \n   > \n  |  \n  |  \n_/   \n',
    '|': u'8 \n8 \n8 \n8 \n8 \n8 \n  \n',
    '~': u'/\\/ \n    \n    \n    \n    \n    \n    \n'}

digital_dic = {
    '!': u'+-+\n|!|\n+-+\n',
    ' ': u' \n \n \n',
    '#': u'+-+\n|#|\n+-+\n',
    '"': u'+-+\n|"|\n+-+\n',
    '%': u'+-+\n|%|\n+-+\n',
    '$': u'+-+\n|$|\n+-+\n',
    "'": u"+-+\n|'|\n+-+\n",
    '&': u'+-+\n|&|\n+-+\n',
    ')': u'+-+\n|)|\n+-+\n',
    '(': u'+-+\n|(|\n+-+\n',
    '+': u'+-+\n|+|\n+-+\n',
    '*': u'+-+\n|*|\n+-+\n',
    '-': u'+-+\n|-|\n+-+\n',
    ',': u'+-+\n|,|\n+-+\n',
    '/': u'+-+\n|/|\n+-+\n',
    '.': u'+-+\n|.|\n+-+\n',
    '1': u'+-+\n|1|\n+-+\n',
    '0': u'+-+\n|0|\n+-+\n',
    '3': u'+-+\n|3|\n+-+\n',
    '2': u'+-+\n|2|\n+-+\n',
    '5': u'+-+\n|5|\n+-+\n',
    '4': u'+-+\n|4|\n+-+\n',
    '7': u'+-+\n|7|\n+-+\n',
    '6': u'+-+\n|6|\n+-+\n',
    '9': u'+-+\n|9|\n+-+\n',
    '8': u'+-+\n|8|\n+-+\n',
    ';': u'+-+\n|;|\n+-+\n',
    ':': u'+-+\n|:|\n+-+\n',
    '=': u'+-+\n|=|\n+-+\n',
    '<': u'+-+\n|<|\n+-+\n',
    '?': u'+-+\n|?|\n+-+\n',
    '>': u'+-+\n|>|\n+-+\n',
    '@': u'+-+\n|@|\n+-+\n',
    '[': u'+-+\n|[|\n+-+\n',
    ']': u'+-+\n|]|\n+-+\n',
    '\\': u'+-+\n|\\|\n+-+\n',
    '_': u'+-+\n|_|\n+-+\n',
    '^': u'+-+\n|^|\n+-+\n',
    'a': u'+-+\n|a|\n+-+\n',
    '`': u'+-+\n|`|\n+-+\n',
    'c': u'+-+\n|c|\n+-+\n',
    'b': u'+-+\n|b|\n+-+\n',
    'e': u'+-+\n|e|\n+-+\n',
    'd': u'+-+\n|d|\n+-+\n',
    'g': u'+-+\n|g|\n+-+\n',
    'f': u'+-+\n|f|\n+-+\n',
    'i': u'+-+\n|i|\n+-+\n',
    'h': u'+-+\n|h|\n+-+\n',
    'k': u'+-+\n|k|\n+-+\n',
    'j': u'+-+\n|j|\n+-+\n',
    'm': u'+-+\n|m|\n+-+\n',
    'l': u'+-+\n|l|\n+-+\n',
    'o': u'+-+\n|o|\n+-+\n',
    'n': u'+-+\n|n|\n+-+\n',
    'q': u'+-+\n|q|\n+-+\n',
    'p': u'+-+\n|p|\n+-+\n',
    's': u'+-+\n|s|\n+-+\n',
    'r': u'+-+\n|r|\n+-+\n',
    'u': u'+-+\n|u|\n+-+\n',
    't': u'+-+\n|t|\n+-+\n',
    'w': u'+-+\n|w|\n+-+\n',
    'v': u'+-+\n|v|\n+-+\n',
    'y': u'+-+\n|y|\n+-+\n',
    'x': u'+-+\n|x|\n+-+\n',
    '{': u'+-+\n|{|\n+-+\n',
    'z': u'+-+\n|z|\n+-+\n',
    '}': u'+-+\n|}|\n+-+\n',
    '|': u'+-+\n|||\n+-+\n',
    '~': u'+-+\n|~|\n+-+\n'}

doh_dic = {
    '!': u'     \n     \n !!! \n!!:!!\n!:::!\n!:::!\n!:::!\n!:::!\n!:::!\n!:::!\n!:::!\n!:::!\n!!:!!\n !!! \n     \n !!! \n!!:!!\n !!! \n     \n     \n     \n     \n     \n     \n     \n',
    ' ': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n',
    '#': u'                          \n                          \n                          \n     ######    ######     \n     #::::#    #::::#     \n     #::::#    #::::#     \n######::::######::::######\n#::::::::::::::::::::::::#\n######::::######::::######\n     #::::#    #::::#     \n     #::::#    #::::#     \n######::::######::::######\n#::::::::::::::::::::::::#\n######::::######::::######\n     #::::#    #::::#     \n     #::::#    #::::#     \n     ######    ######     \n                          \n                          \n                          \n                          \n                          \n                          \n                          \n                          \n',
    '"': u'""""""   """"""\n"::::"   "::::"\n"::::"   "::::"\n ":::"   ":::" \n  "::"   "::"  \n   """   """   \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n               \n',
    '%': u'                      \n                      \n %%%%%         %%%%%%%\n%:::::%       %:::::% \n%:::::%      %:::::%  \n %%%%%      %:::::%   \n           %:::::%    \n          %:::::%     \n         %:::::%      \n        %:::::%       \n       %:::::%        \n      %:::::%         \n     %:::::%          \n    %:::::%           \n   %:::::%      %%%%% \n  %:::::%      %:::::%\n %:::::%       %:::::%\n%%%%%%%         %%%%% \n                      \n                      \n                      \n                      \n                      \n                      \n                      \n',
    '$': u'       $$$$$      \n       $:::$      \n   $$$$$:::$$$$$$ \n $$::::::::::::::$\n$:::::$$$$$$$::::$\n$::::$       $$$$$\n$::::$            \n$::::$            \n$:::::$$$$$$$$$   \n $$::::::::::::$$ \n   $$$$$$$$$:::::$\n            $::::$\n            $::::$\n$$$$$       $::::$\n$::::$$$$$$$:::::$\n$::::::::::::::$$ \n $$$$$$:::$$$$$   \n      $:::$       \n      $$$$$       \n                  \n                  \n                  \n                  \n                  \n                  \n',
    "'": u"       \n ''''''\n '::::'\n '::::'\n ':::''\n':::'  \n''''   \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n",
    '&': u'                   \n                   \n     &&&&&&&&&&    \n    &::::::::::&   \n   &::::&&&:::::&  \n  &::::&   &::::&  \n  &::::&   &::::&  \n   &::::&&&::::&   \n   &::::::::::&    \n    &:::::::&&     \n  &::::::::&   &&&&\n &:::::&&::&  &:::&\n&:::::&  &::&&:::&&\n&:::::&   &:::::&  \n&:::::&    &::::&  \n&::::::&&&&::::::&&\n &&::::::::&&&::::&\n   &&&&&&&&   &&&&&\n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    ')': u'            \n            \n ))))))     \n)::::::))   \n ):::::::)) \n  )):::::::)\n    )::::::)\n     ):::::)\n     ):::::)\n     ):::::)\n     ):::::)\n     ):::::)\n     ):::::)\n    )::::::)\n  )):::::::)\n ):::::::)) \n)::::::)    \n ))))))     \n            \n            \n            \n            \n            \n            \n            \n',
    '(': u'            \n            \n     (((((( \n   ((::::::(\n ((:::::::( \n(:::::::((  \n(::::::(    \n(:::::(     \n(:::::(     \n(:::::(     \n(:::::(     \n(:::::(     \n(:::::(     \n(::::::(    \n(:::::::((  \n ((:::::::( \n   ((::::::(\n     (((((( \n            \n            \n            \n            \n            \n            \n            \n',
    '+': u'                     \n                     \n                     \n                     \n                     \n       +++++++       \n       +:::::+       \n       +:::::+       \n +++++++:::::+++++++ \n +:::::::::::::::::+ \n +:::::::::::::::::+ \n +++++++:::::+++++++ \n       +:::::+       \n       +:::::+       \n       +++++++       \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n',
    '*': u'                     \n                     \n                     \n                     \n                     \n******         ******\n*:::::*       *:::::*\n***::::*******::::***\n   **:::::::::::**   \n******:::::::::******\n*:::::::::::::::::::*\n******:::::::::******\n   **:::::::::::**   \n***::::*******::::***\n*:::::*       *:::::*\n******         ******\n                     \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n',
    '-': u'                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n --------------- \n -:::::::::::::- \n --------------- \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n',
    ',': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n ,,,,,,\n ,::::,\n ,::::,\n ,:::,,\n,:::,  \n,,,,   \n       \n       \n       \n       \n       \n',
    '/': u'                      \n                      \n               ///////\n              /:::::/ \n             /:::::/  \n            /:::::/   \n           /:::::/    \n          /:::::/     \n         /:::::/      \n        /:::::/       \n       /:::::/        \n      /:::::/         \n     /:::::/          \n    /:::::/           \n   /:::::/            \n  /:::::/             \n /:::::/              \n///////               \n                      \n                      \n                      \n                      \n                      \n                      \n                      \n',
    '.': u'        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n ...... \n .::::. \n ...... \n        \n        \n        \n        \n        \n        \n        \n',
    '1': u'            \n            \n  1111111   \n 1::::::1   \n1:::::::1   \n111:::::1   \n   1::::1   \n   1::::1   \n   1::::1   \n   1::::l   \n   1::::l   \n   1::::l   \n   1::::l   \n   1::::l   \n111::::::111\n1::::::::::1\n1::::::::::1\n111111111111\n            \n            \n            \n            \n            \n            \n            \n',
    '0': u'                   \n                   \n     000000000     \n   00:::::::::00   \n 00:::::::::::::00 \n0:::::::000:::::::0\n0::::::0   0::::::0\n0:::::0     0:::::0\n0:::::0     0:::::0\n0:::::0 000 0:::::0\n0:::::0 000 0:::::0\n0:::::0     0:::::0\n0:::::0     0:::::0\n0::::::0   0::::::0\n0:::::::000:::::::0\n 00:::::::::::::00 \n   00:::::::::00   \n     000000000     \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '3': u'                   \n                   \n 333333333333333   \n3:::::::::::::::33 \n3::::::33333::::::3\n3333333     3:::::3\n            3:::::3\n            3:::::3\n    33333333:::::3 \n    3:::::::::::3  \n    33333333:::::3 \n            3:::::3\n            3:::::3\n            3:::::3\n3333333     3:::::3\n3::::::33333::::::3\n3:::::::::::::::33 \n 333333333333333   \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '2': u'                    \n                    \n 222222222222222    \n2:::::::::::::::22  \n2::::::222222:::::2 \n2222222     2:::::2 \n            2:::::2 \n            2:::::2 \n         2222::::2  \n    22222::::::22   \n  22::::::::222     \n 2:::::22222        \n2:::::2             \n2:::::2             \n2:::::2       222222\n2::::::2222222:::::2\n2::::::::::::::::::2\n22222222222222222222\n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    '5': u'                   \n                   \n555555555555555555 \n5::::::::::::::::5 \n5::::::::::::::::5 \n5:::::555555555555 \n5:::::5            \n5:::::5            \n5:::::5555555555   \n5:::::::::::::::5  \n555555555555:::::5 \n            5:::::5\n            5:::::5\n5555555     5:::::5\n5::::::55555::::::5\n 55:::::::::::::55 \n   55:::::::::55   \n     555555555     \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '4': u'                  \n                  \n       444444444  \n      4::::::::4  \n     4:::::::::4  \n    4::::44::::4  \n   4::::4 4::::4  \n  4::::4  4::::4  \n 4::::4   4::::4  \n4::::444444::::444\n4::::::::::::::::4\n4444444444:::::444\n          4::::4  \n          4::::4  \n          4::::4  \n        44::::::44\n        4::::::::4\n        4444444444\n                  \n                  \n                  \n                  \n                  \n                  \n                  \n',
    '7': u'                    \n                    \n77777777777777777777\n7::::::::::::::::::7\n7::::::::::::::::::7\n777777777777:::::::7\n           7::::::7 \n          7::::::7  \n         7::::::7   \n        7::::::7    \n       7::::::7     \n      7::::::7      \n     7::::::7       \n    7::::::7        \n   7::::::7         \n  7::::::7          \n 7::::::7           \n77777777            \n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    '6': u'                   \n                   \n        66666666   \n       6::::::6    \n      6::::::6     \n     6::::::6      \n    6::::::6       \n   6::::::6        \n  6::::::6         \n 6::::::::66666    \n6::::::::::::::66  \n6::::::66666:::::6 \n6:::::6     6:::::6\n6:::::6     6:::::6\n6::::::66666::::::6\n 66:::::::::::::66 \n   66:::::::::66   \n     666666666     \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '9': u'                   \n                   \n     999999999     \n   99:::::::::99   \n 99:::::::::::::99 \n9::::::99999::::::9\n9:::::9     9:::::9\n9:::::9     9:::::9\n 9:::::99999::::::9\n  99::::::::::::::9\n    99999::::::::9 \n         9::::::9  \n        9::::::9   \n       9::::::9    \n      9::::::9     \n     9::::::9      \n    9::::::9       \n   99999999        \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '8': u'                   \n                   \n     888888888     \n   88:::::::::88   \n 88:::::::::::::88 \n8::::::88888::::::8\n8:::::8     8:::::8\n8:::::8     8:::::8\n 8:::::88888:::::8 \n  8:::::::::::::8  \n 8:::::88888:::::8 \n8:::::8     8:::::8\n8:::::8     8:::::8\n8:::::8     8:::::8\n8::::::88888::::::8\n 88:::::::::::::88 \n   88:::::::::88   \n     888888888     \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    ';': u'         \n         \n         \n         \n         \n         \n         \n  ;;;;;; \n  ;::::; \n  ;;;;;; \n         \n         \n         \n  ;;;;;; \n  ;::::; \n  ;:::;; \n ;:::;   \n ;;;;    \n         \n         \n         \n         \n         \n         \n         \n',
    ':': u'        \n        \n        \n        \n        \n        \n        \n :::::: \n :::::: \n :::::: \n        \n        \n        \n :::::: \n :::::: \n :::::: \n        \n        \n        \n        \n        \n        \n        \n        \n        \n',
    '=': u'                 \n                 \n                 \n                 \n                 \n                 \n =============== \n =:::::::::::::= \n =============== \n                 \n =============== \n =:::::::::::::= \n =============== \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n',
    '<': u'             \n             \n             \n      <<<<<<<\n     <:::::< \n    <:::::<  \n   <:::::<   \n  <:::::<    \n <:::::<     \n<:::::<      \n <:::::<     \n  <:::::<    \n   <:::::<   \n    <:::::<  \n     <:::::< \n      <<<<<<<\n             \n             \n             \n             \n             \n             \n             \n             \n             \n',
    '?': u'     ???????     \n   ??:::::::??   \n ??:::::::::::?  \n?:::::????:::::? \n?::::?    ?::::? \n?::::?     ?::::?\n??????     ?::::?\n          ?::::? \n         ?::::?  \n        ?::::?   \n       ?::::?    \n      ?::::?     \n      ?::::?     \n      ??::??     \n       ????      \n                 \n       ???       \n      ??:??      \n       ???       \n                 \n                 \n                 \n                 \n                 \n                 \n',
    '>': u'             \n             \n             \n>>>>>>>      \n >:::::>     \n  >:::::>    \n   >:::::>   \n    >:::::>  \n     >:::::> \n      >:::::>\n     >:::::> \n    >:::::>  \n   >:::::>   \n  >:::::>    \n >:::::>     \n>>>>>>>      \n             \n             \n             \n             \n             \n             \n             \n             \n             \n',
    '@': u'                   \n                   \n                   \n     @@@@@@@@@     \n   @@:::::::::@@   \n @@:::::::::::::@@ \n@:::::::@@@:::::::@\n@::::::@   @::::::@\n@:::::@  @@@@:::::@\n@:::::@  @::::::::@\n@:::::@  @::::::::@\n@:::::@  @:::::::@@\n@:::::@  @@@@@@@@  \n@::::::@           \n@:::::::@@@@@@@@   \n @@:::::::::::::@  \n   @@:::::::::::@  \n     @@@@@@@@@@@   \n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    '[': u'         \n         \n[[[[[[[[[\n[:::::::[\n[:::::::[\n[:::::[[[\n[::::[   \n[::::[   \n[::::[   \n[::::[   \n[::::[   \n[::::[   \n[::::[   \n[::::[   \n[:::::[[[\n[:::::::[\n[:::::::[\n[[[[[[[[[\n         \n         \n         \n         \n         \n         \n         \n',
    ']': u'         \n         \n]]]]]]]]]\n]:::::::]\n]:::::::]\n]]]:::::]\n   ]::::]\n   ]::::]\n   ]::::]\n   ]::::]\n   ]::::]\n   ]::::]\n   ]::::]\n   ]::::]\n]]]:::::]\n]:::::::]\n]:::::::]\n]]]]]]]]]\n         \n         \n         \n         \n         \n         \n         \n',
    '\\': u'                      \n                      \n\\\\\\\\\\\\\\               \n \\:::::\\              \n  \\:::::\\             \n   \\:::::\\            \n    \\:::::\\           \n     \\:::::\\          \n      \\:::::\\         \n       \\:::::\\        \n        \\:::::\\       \n         \\:::::\\      \n          \\:::::\\     \n           \\:::::\\    \n            \\:::::\\   \n             \\:::::\\  \n              \\:::::\\ \n               \\\\\\\\\\\\\\\n                      \n                      \n                      \n                      \n                      \n                      \n                      \n',
    '_': u'                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n                        \n________________________\n_::::::::::::::::::::::_\n________________________\n                        \n                        \n                        \n                        \n',
    '^': u'                 \n                 \n       ^^^       \n      ^:::^      \n     ^:::::^     \n    ^:::::::^    \n   ^:::::::::^   \n  ^:::::^:::::^  \n ^:::::^ ^:::::^ \n^^^^^^^   ^^^^^^^\n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n',
    'a': u'                  \n                  \n                  \n                  \n                  \n                  \n  aaaaaaaaaaaaa   \n  a::::::::::::a  \n  aaaaaaaaa:::::a \n           a::::a \n    aaaaaaa:::::a \n  aa::::::::::::a \n a::::aaaa::::::a \na::::a    a:::::a \na::::a    a:::::a \na:::::aaaa::::::a \n a::::::::::aa:::a\n  aaaaaaaaaa  aaaa\n                  \n                  \n                  \n                  \n                  \n                  \n                  \n',
    '`': u'       \n       \n`````` \n`::::` \n`::::` \n``:::` \n  `:::`\n   ````\n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n',
    'c': u'                    \n                    \n                    \n                    \n                    \n                    \n    cccccccccccccccc\n  cc:::::::::::::::c\n c:::::::::::::::::c\nc:::::::cccccc:::::c\nc::::::c     ccccccc\nc:::::c             \nc:::::c             \nc::::::c     ccccccc\nc:::::::cccccc:::::c\n c:::::::::::::::::c\n  cc:::::::::::::::c\n    cccccccccccccccc\n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    'b': u'                    \nbbbbbbbb            \nb::::::b            \nb::::::b            \nb::::::b            \n b:::::b            \n b:::::bbbbbbbbb    \n b::::::::::::::bb  \n b::::::::::::::::b \n b:::::bbbbb:::::::b\n b:::::b    b::::::b\n b:::::b     b:::::b\n b:::::b     b:::::b\n b:::::b     b:::::b\n b:::::bbbbbb::::::b\n b::::::::::::::::b \n b:::::::::::::::b  \n bbbbbbbbbbbbbbbb   \n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    'e': u'                    \n                    \n                    \n                    \n                    \n                    \n    eeeeeeeeeeee    \n  ee::::::::::::ee  \n e::::::eeeee:::::ee\ne::::::e     e:::::e\ne:::::::eeeee::::::e\ne:::::::::::::::::e \ne::::::eeeeeeeeeee  \ne:::::::e           \ne::::::::e          \n e::::::::eeeeeeee  \n  ee:::::::::::::e  \n    eeeeeeeeeeeeee  \n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    'd': u'                    \n            dddddddd\n            d::::::d\n            d::::::d\n            d::::::d\n            d:::::d \n    ddddddddd:::::d \n  dd::::::::::::::d \n d::::::::::::::::d \nd:::::::ddddd:::::d \nd::::::d    d:::::d \nd:::::d     d:::::d \nd:::::d     d:::::d \nd:::::d     d:::::d \nd::::::ddddd::::::dd\n d:::::::::::::::::d\n  d:::::::::ddd::::d\n   ddddddddd   ddddd\n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    'g': u'                    \n                    \n                    \n                    \n                    \n                    \n   ggggggggg   ggggg\n  g:::::::::ggg::::g\n g:::::::::::::::::g\ng::::::ggggg::::::gg\ng:::::g     g:::::g \ng:::::g     g:::::g \ng:::::g     g:::::g \ng::::::g    g:::::g \ng:::::::ggggg:::::g \n g::::::::::::::::g \n  gg::::::::::::::g \n    gggggggg::::::g \n            g:::::g \ngggggg      g:::::g \ng:::::gg   gg:::::g \n g::::::ggg:::::::g \n  gg:::::::::::::g  \n    ggg::::::ggg    \n       gggggg       \n',
    'f': u'                     \n                     \n   ffffffffffffffff  \n  f::::::::::::::::f \n f::::::::::::::::::f\n f::::::fffffff:::::f\n f:::::f       ffffff\n f:::::f             \nf:::::::ffffff       \nf::::::::::::f       \nf::::::::::::f       \nf:::::::ffffff       \n f:::::f             \n f:::::f             \nf:::::::f            \nf:::::::f            \nf:::::::f            \nfffffffff            \n                     \n                     \n                     \n                     \n                     \n                     \n                     \n',
    'i': u'        \n        \n  iiii  \n i::::i \n  iiii  \n        \niiiiiii \ni:::::i \n i::::i \n i::::i \n i::::i \n i::::i \n i::::i \n i::::i \ni::::::i\ni::::::i\ni::::::i\niiiiiiii\n        \n        \n        \n        \n        \n        \n        \n',
    'h': u'                    \n                    \nhhhhhhh             \nh:::::h             \nh:::::h             \nh:::::h             \n h::::h hhhhh       \n h::::hh:::::hhh    \n h::::::::::::::hh  \n h:::::::hhh::::::h \n h::::::h   h::::::h\n h:::::h     h:::::h\n h:::::h     h:::::h\n h:::::h     h:::::h\n h:::::h     h:::::h\n h:::::h     h:::::h\n h:::::h     h:::::h\n hhhhhhh     hhhhhhh\n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    'k': u'                   \n                   \nkkkkkkkk           \nk::::::k           \nk::::::k           \nk::::::k           \n k:::::k    kkkkkkk\n k:::::k   k:::::k \n k:::::k  k:::::k  \n k:::::k k:::::k   \n k::::::k:::::k    \n k:::::::::::k     \n k:::::::::::k     \n k::::::k:::::k    \nk::::::k k:::::k   \nk::::::k  k:::::k  \nk::::::k   k:::::k \nkkkkkkkk    kkkkkkk\n                   \n                   \n                   \n                   \n                   \n                   \n                   \n',
    'j': u'                 \n                 \n            jjjj \n           j::::j\n            jjjj \n                 \n          jjjjjjj\n          j:::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n           j::::j\n jjjj      j::::j\nj::::jj   j:::::j\nj::::::jjj::::::j\n jj::::::::::::j \n   jjj::::::jjj  \n      jjjjjj     \n',
    'm': u'                        \n                        \n                        \n                        \n                        \n                        \n   mmmmmmm    mmmmmmm   \n mm:::::::m  m:::::::mm \nm::::::::::mm::::::::::m\nm::::::::::::::::::::::m\nm:::::mmm::::::mmm:::::m\nm::::m   m::::m   m::::m\nm::::m   m::::m   m::::m\nm::::m   m::::m   m::::m\nm::::m   m::::m   m::::m\nm::::m   m::::m   m::::m\nm::::m   m::::m   m::::m\nmmmmmm   mmmmmm   mmmmmm\n                        \n                        \n                        \n                        \n                        \n                        \n                        \n',
    'l': u'        \n        \nlllllll \nl:::::l \nl:::::l \nl:::::l \n l::::l \n l::::l \n l::::l \n l::::l \n l::::l \n l::::l \n l::::l \n l::::l \nl::::::l\nl::::::l\nl::::::l\nllllllll\n        \n        \n        \n        \n        \n        \n        \n',
    'o': u'                 \n                 \n                 \n                 \n                 \n                 \n   ooooooooooo   \n oo:::::::::::oo \no:::::::::::::::o\no:::::ooooo:::::o\no::::o     o::::o\no::::o     o::::o\no::::o     o::::o\no::::o     o::::o\no:::::ooooo:::::o\no:::::::::::::::o\n oo:::::::::::oo \n   ooooooooooo   \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n',
    'n': u'                  \n                  \n                  \n                  \n                  \n                  \nnnnn  nnnnnnnn    \nn:::nn::::::::nn  \nn::::::::::::::nn \nnn:::::::::::::::n\n  n:::::nnnn:::::n\n  n::::n    n::::n\n  n::::n    n::::n\n  n::::n    n::::n\n  n::::n    n::::n\n  n::::n    n::::n\n  n::::n    n::::n\n  nnnnnn    nnnnnn\n                  \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'q': u'                    \n                    \n                    \n                    \n                    \n                    \n   qqqqqqqqq   qqqqq\n  q:::::::::qqq::::q\n q:::::::::::::::::q\nq::::::qqqqq::::::qq\nq:::::q     q:::::q \nq:::::q     q:::::q \nq:::::q     q:::::q \nq::::::q    q:::::q \nq:::::::qqqqq:::::q \n q::::::::::::::::q \n  qq::::::::::::::q \n    qqqqqqqq::::::q \n            q:::::q \n            q:::::q \n           q:::::::q\n           q:::::::q\n           q:::::::q\n           qqqqqqqqq\n                    \n',
    'p': u'                    \n                    \n                    \n                    \n                    \n                    \nppppp   ppppppppp   \np::::ppp:::::::::p  \np:::::::::::::::::p \npp::::::ppppp::::::p\n p:::::p     p:::::p\n p:::::p     p:::::p\n p:::::p     p:::::p\n p:::::p    p::::::p\n p:::::ppppp:::::::p\n p::::::::::::::::p \n p::::::::::::::pp  \n p::::::pppppppp    \n p:::::p            \n p:::::p            \np:::::::p           \np:::::::p           \np:::::::p           \nppppppppp           \n                    \n',
    's': u'                 \n                 \n                 \n                 \n                 \n                 \n    ssssssssss   \n  ss::::::::::s  \nss:::::::::::::s \ns::::::ssss:::::s\n s:::::s  ssssss \n   s::::::s      \n      s::::::s   \nssssss   s:::::s \ns:::::ssss::::::s\ns::::::::::::::s \n s:::::::::::ss  \n  sssssssssss    \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n',
    'r': u'                    \n                    \n                    \n                    \n                    \n                    \nrrrrr   rrrrrrrrr   \nr::::rrr:::::::::r  \nr:::::::::::::::::r \nrr::::::rrrrr::::::r\n r:::::r     r:::::r\n r:::::r     rrrrrrr\n r:::::r            \n r:::::r            \n r:::::r            \n r:::::r            \n r:::::r            \n rrrrrrr            \n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    'u': u'                  \n                  \n                  \n                  \n                  \n                  \nuuuuuu    uuuuuu  \nu::::u    u::::u  \nu::::u    u::::u  \nu::::u    u::::u  \nu::::u    u::::u  \nu::::u    u::::u  \nu::::u    u::::u  \nu:::::uuuu:::::u  \nu:::::::::::::::uu\n u:::::::::::::::u\n  uu::::::::uu:::u\n    uuuuuuuu  uuuu\n                  \n                  \n                  \n                  \n                  \n                  \n                  \n',
    't': u'                       \n                       \n         tttt          \n      ttt:::t          \n      t:::::t          \n      t:::::t          \nttttttt:::::ttttttt    \nt:::::::::::::::::t    \nt:::::::::::::::::t    \ntttttt:::::::tttttt    \n      t:::::t          \n      t:::::t          \n      t:::::t          \n      t:::::t    tttttt\n      t::::::tttt:::::t\n      tt::::::::::::::t\n        tt:::::::::::tt\n          ttttttttttt  \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n',
    'w': u'                                         \n                                         \n                                         \n                                         \n                                         \n                                         \nwwwwwww           wwwww           wwwwwww\n w:::::w         w:::::w         w:::::w \n  w:::::w       w:::::::w       w:::::w  \n   w:::::w     w:::::::::w     w:::::w   \n    w:::::w   w:::::w:::::w   w:::::w    \n     w:::::w w:::::w w:::::w w:::::w     \n      w:::::w:::::w   w:::::w:::::w      \n       w:::::::::w     w:::::::::w       \n        w:::::::w       w:::::::w        \n         w:::::w         w:::::w         \n          w:::w           w:::w          \n           www             www           \n                                         \n                                         \n                                         \n                                         \n                                         \n                                         \n                                         \n',
    'v': u'                         \n                         \n                         \n                         \n                         \n                         \nvvvvvvv           vvvvvvv\n v:::::v         v:::::v \n  v:::::v       v:::::v  \n   v:::::v     v:::::v   \n    v:::::v   v:::::v    \n     v:::::v v:::::v     \n      v:::::v:::::v      \n       v:::::::::v       \n        v:::::::v        \n         v:::::v         \n          v:::v          \n           vvv           \n                         \n                         \n                         \n                         \n                         \n                         \n                         \n',
    'y': u'                         \n                         \n                         \n                         \n                         \n                         \nyyyyyyy           yyyyyyy\n y:::::y         y:::::y \n  y:::::y       y:::::y  \n   y:::::y     y:::::y   \n    y:::::y   y:::::y    \n     y:::::y y:::::y     \n      y:::::y:::::y      \n       y:::::::::y       \n        y:::::::y        \n         y:::::y         \n        y:::::y          \n       y:::::y           \n      y:::::y            \n     y:::::y             \n    y:::::y              \n   y:::::y               \n  yyyyyyy                \n                         \n                         \n',
    'x': u'                    \n                    \n                    \n                    \n                    \n                    \nxxxxxxx      xxxxxxx\n x:::::x    x:::::x \n  x:::::x  x:::::x  \n   x:::::xx:::::x   \n    x::::::::::x    \n     x::::::::x     \n     x::::::::x     \n    x::::::::::x    \n   x:::::xx:::::x   \n  x:::::x  x:::::x  \n x:::::x    x:::::x \nxxxxxxx      xxxxxxx\n                    \n                    \n                    \n                    \n                    \n                    \n                    \n',
    '{': u'           \n      {{{{{\n     {::::{\n    {:::::{\n    {::::{{\n   {::::{  \n   {::::{  \n  {:::::{  \n {:::::{   \n{:::::{    \n {:::::{   \n  {:::::{  \n   {::::{  \n   {::::{  \n   {:::::{{\n    {:::::{\n     {::::{\n      {{{{{\n           \n           \n           \n           \n           \n           \n           \n',
    'z': u'                 \n                 \n                 \n                 \n                 \n                 \nzzzzzzzzzzzzzzzzz\nz:::::::::::::::z\nz::::::::::::::z \nzzzzzzzz::::::z  \n      z::::::z   \n     z::::::z    \n    z::::::z     \n   z::::::z      \n  z::::::zzzzzzzz\n z::::::::::::::z\nz:::::::::::::::z\nzzzzzzzzzzzzzzzzz\n                 \n                 \n                 \n                 \n                 \n                 \n                 \n',
    '}': u'           \n}}}}}      \n}::::}     \n}:::::}    \n}}::::}    \n  }::::}   \n  }::::}   \n  }:::::}  \n   }:::::} \n    }:::::}\n   }:::::} \n  }:::::}  \n  }::::}   \n  }::::}   \n}}:::::}   \n}:::::}    \n}::::}     \n}}}}}      \n           \n           \n           \n           \n           \n           \n           \n',
    '|': u'         \n         \n ||||||| \n |:::::| \n |:::::| \n |:::::| \n |:::::| \n |:::::| \n ||||||| \n         \n         \n ||||||| \n |:::::| \n |:::::| \n |:::::| \n |:::::| \n |:::::| \n ||||||| \n         \n         \n         \n         \n         \n         \n         \n',
    '~': u'                       \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n    ~~~~~~~~~    ~~~~~~\n  ~~:::::::::~  ~:::::~\n ~:::::~~:::::~~:::::~ \n~:::::~  ~::::::::::~  \n~~~~~~    ~~~~~~~~~~   \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n                       \n'}


eftirobot_dic = {
    '!': u' _ \n( )\n|_|\n _ \n/_\\\n   \n',
    ' ': u' \n \n \n \n \n \n',
    '#': u'         \n  _   _  \n_| |_| |_\n ( ) ( ) \n-/_|-|_\\-\n         \n',
    '"': u'    \n()()\n    \n    \n    \n    \n',
    '%': u' _  _ \n(_)/ )\n  / / \n ( /_ \n/_/(_)\n      \n',
    '$': u'  _  \n ( ) \n/ __|\n\\_  \\\n(___/\n |_| \n',
    "'": u' __\n/_/\n   \n   \n   \n   \n',
    '&': u" __   \n( o)  \n )(   \n/ o`')\n\\__/\\\\\n      \n",
    ')': u' _  \n( \\ \n | |\n ( )\n / |\n/_/ \n',
    '(': u'  _ \n / )\n| | \n( ) \n| \\ \n \\_\\\n',
    '+': u'       \n   _   \n _| |_ \n(_   _)\n  /_\\  \n       \n',
    '*': u" .  . \n_\\`'/_\n)_  _(\n /'`\\ \n      \n      \n",
    '-': u'     \n     \n ___ \n(___)\n     \n     \n',
    ',': u"   \n   \n   \n _ \n(_)\n/' \n",
    '/': u'    _ \n   / )\n  / / \n ( /  \n/_/   \n      \n',
    '.': u'   \n   \n   \n _ \n(_)\n   \n',
    '1': u'    \n __ \n/_ |\n ( )\n /_\\\n    \n',
    '0': u'     \n  _  \n / \\ \n( 0 )\n \\_/ \n     \n',
    '3': u'    \n ___\n|_ /\n__))\n\\__/\n    \n',
    '2': u'     \n __  \n|_ | \n /(_ \n/___\\\n     \n',
    '5': u'    \n ___\n| _/\n ) \\\n/__/\n    \n',
    '4': u'     \n   . \n  /| \n /o) \n/___\\\n     \n',
    '7': u'     \n ____\n|_  /\n  )) \n /_\\ \n     \n',
    '6': u'    \n  _ \n // \n(o \\\n\\__/\n    \n',
    '9': u'    \n __ \n/o \\\n\\_ )\n /_/\n    \n',
    '8': u'    \n __ \n(o )\n/o \\\n\\__/\n    \n',
    ';': u"   \n   \n _ \n(_)\n(_)\n/' \n",
    ':': u'   \n   \n _ \n(_)\n(_)\n   \n',
    '=': u'      \n      \n ____ \n(____)\n(____)\n      \n',
    '<': u'  _ \n / )\n/ / \n( \\ \n \\_\\\n    \n',
    '?': u' ___ \n(_, )\n  // \n (_) \n  _  \n (_) \n',
    '>': u' _  \n( \\ \n \\ \\\n / )\n/_/ \n    \n',
    '@': u'      \n  __  \n /_ \\ \n((O)_)\n \\___/\n      \n',
    '[': u' ___ \n( __)\n| |  \n( )  \n| \\_ \n|___|\n',
    ']': u' ___ \n(__ )\n  | |\n  ( )\n _/ |\n|___|\n',
    '\\': u' _    \n( \\   \n \\ \\  \n  \\ ) \n   \\_\\\n      \n',
    '_': u'      \n      \n      \n      \n ____ \n|____|\n',
    '^': u'  ___  \n,;`;;;,\n;; o o|\n(; _" |\n |\\__/ \n       \n',
    'a': u'     \n     \n ___ \n( o )\n/_^_\\\n     \n',
    '`': u'__ \n\\_\\\n   \n   \n   \n   \n',
    'c': u'   \n   \n __\n/ /\n\\_\\\n   \n',
    'b': u' _   \n( )  \n| |_ \n( o \\\n/___/\n     \n',
    'e': u'     \n     \n ___ \n( o_)\n \\(  \n     \n',
    'd': u'   _ \n  ( )\n _| |\n/ o )\n\\___\\\n     \n',
    'g': u'    \n    \n __ \n/o )\n\\__\\\n _|/\n',
    'f': u"  _ \n,'_)\n| | \n( _)\n/_\\ \n    \n",
    'i': u' _ \n(_)\n _ \n( )\n/_\\\n   \n',
    'h': u' _   \n( )  \n| |_ \n( _ )\n/_\\||\n     \n',
    'k': u" _    \n( )   \n| | _ \n( _'( \n/_\\\\_|\n      \n",
    'j': u' _ \n(_)\n _ \n( )\n| |\n/_/\n',
    'm': u"        \n        \n __  __ \n( _`'_ )\n/_\\`'/_\\\n        \n",
    'l': u' _ \n( )\n| |\n( )\n/_\\\n   \n',
    'o': u'     \n     \n ___ \n( o )\n \\_/ \n     \n',
    'n': u'      \n      \n ____ \n( __ )\n/_\\/_\\\n      \n',
    'q': u'     \n     \n ___ \n/ o )\n\\__ \\\n  |_|\n',
    'p': u'     \n     \n ___ \n( o \\\n/ __/\n|_|  \n',
    's': u"    \n    \n __ \n(_' \n/__)\n    \n",
    'r': u'    \n    \n __ \n( _)\n/_\\ \n    \n',
    'u': u'     \n     \n _ _ \n( U )\n/___\\\n     \n',
    't': u' _  \n( ) \n| | \n( _)\n/_\\ \n    \n',
    'w': u'       \n       \n _ _ _ \n( V V )\n \\_^_/ \n       \n',
    'v': u'     \n     \n _ _ \n( V )\n \\_/ \n     \n',
    'y': u'     \n     \n _ _ \n( V )\n ) / \n/_/  \n',
    'x': u'     \n     \n__ __\n\\ V /\n/_^_\\\n     \n',
    '{': u'   _ \n  / )\n _) )\n(_ ( \n  ) )\n  \\_\\\n',
    'z': u'     \n     \n __  \n(_ ) \n /__\\\n     \n',
    '}': u' _   \n( \\  \n( (_ \n ) _)\n( (  \n/_/  \n',
    '|': u' _ \n( )\n| |\n( )\n| \\\n|_|\n',
    '~': u' __ __ \n(_(\\)_)\n       \n       \n       \n       \n'}

graffiti_dic = {
    '!': u'._.\n| |\n| |\n \\|\n __\n \\/\n',
    ' ': u' \n \n \n \n \n \n',
    '#': u'   _  _   \n__| || |__\n\\   __   /\n |  ||  | \n/_  ~~  _\\\n  |_||_|  \n',
    '"': u'/\\/\\\n)/)/\n    \n    \n    \n    \n',
    '%': u' _   /\\ \n/ \\ / / \n\\_// /_ \n  / // \\\n / / \\_/\n \\/     \n',
    '$': u'  ____/\\__\n /   / /_/\n \\__/ / \\ \n / / /   \\\n/_/ /__  /\n  \\/   \\/ \n',
    "'": u'/\\\n)/\n  \n  \n  \n  \n',
    '&': u'  ____   \n /  _ \\  \n >  _ </\\\n/  <_\\ \\/\n\\_____\\ \\\n       \\/\n',
    ')': u' ___    \n \\  \\   \n  \\  \\  \n   )  ) \n  /  /  \n /__/   \n',
    '(': u'    ___ \n   /  / \n  /  /  \n (  (   \n  \\  \\  \n   \\__\\ \n',
    '+': u'            \n    .__     \n  __|  |___ \n /__    __/ \n    |__|    \n            \n',
    '*': u'           \n  /\\|\\/\\   \n _)    (__ \n \\_     _/ \n   )    \\  \n   \\/\\|\\/  \n',
    '-': u'         \n         \n  ______ \n /_____/ \n         \n         \n',
    ',': u'   \n   \n   \n   \n /\\\n )/\n',
    '/': u'     /\\ \n    / / \n   / /  \n  / /   \n / /    \n \\/     \n',
    '.': u'   \n   \n   \n   \n /\\\n \\/\n',
    '1': u' ____ \n/_   |\n |   |\n |   |\n |___|\n      \n',
    '0': u'_______   \n\\   _  \\  \n/  /_\\  \\ \n\\  \\_/   \\\n \\_____  /\n       \\/ \n',
    '3': u'________  \n\\_____  \\ \n  _(__  < \n /       \\\n/______  /\n       \\/ \n',
    '2': u'________  \n\\_____  \\ \n /  ____/ \n/       \\ \n\\_______ \\\n        \\/\n',
    '5': u' .________\n |   ____/\n |____  \\ \n /       \\\n/______  /\n       \\/ \n',
    '4': u'   _____  \n  /  |  | \n /   |  |_\n/    ^   /\n\\____   | \n     |__| \n',
    '7': u'_________ \n\\______  \\\n    /    /\n   /    / \n  /____/  \n          \n',
    '6': u'  ________\n /  _____/\n/   __  \\ \n\\  |__\\  \\\n \\_____  /\n       \\/ \n',
    '9': u' ________ \n/   __   \\\n\\____    /\n   /    / \n  /____/  \n          \n',
    '8': u'  ______  \n /  __  \\ \n >      < \n/   --   \\\n\\______  /\n       \\/ \n',
    ';': u'    \n /\\ \n \\/ \n /\\ \n )/ \n    \n',
    ':': u'    \n /\\ \n \\/ \n /\\ \n \\/ \n    \n',
    '=': u'         \n  ______ \n /_____/ \n /_____/ \n         \n         \n',
    '<': u'   __ \n  / / \n / /  \n \\ \\  \n  \\_\\ \n      \n',
    '?': u'_________ \n\\_____   \\\n   /   __/\n  |   |   \n  |___|   \n  <___>   \n',
    '>': u' __   \n \\ \\  \n  \\ \\ \n  / / \n /_/  \n      \n',
    '@': u'   _____  \n  / ___ \\ \n / / ._\\ \\\n<  \\_____/\n \\_____\\  \n          \n',
    '[': u' .____  \n |   _| \n |  |   \n |  |   \n |  |_  \n |____| \n',
    ']': u'  ____. \n |_   | \n   |  | \n   |  | \n  _|  | \n |____| \n',
    '\\': u'/\\    \n\\ \\   \n \\ \\  \n  \\ \\ \n   \\ \\\n    \\/\n',
    '_': u'       \n       \n       \n       \n ______\n/_____/\n',
    '^': u'  /\\  \n /  \\ \n \\/\\/ \n      \n      \n      \n',
    'a': u'        \n_____   \n\\__  \\  \n / __ \\_\n(____  /\n     \\/ \n',
    '`': u'/\\\n\\(\n  \n  \n  \n  \n',
    'c': u'        \n  ____  \n_/ ___\\ \n\\  \\___ \n \\___  >\n     \\/ \n',
    'b': u'___.    \n\\_ |__  \n | __ \\ \n | \\_\\ \\\n |___  /\n     \\/ \n',
    'e': u'        \n  ____  \n_/ __ \\ \n\\  ___/ \n \\___  >\n     \\/ \n',
    'd': u'    .___\n  __| _/\n / __ | \n/ /_/ | \n\\____ | \n     \\/ \n',
    'g': u'         \n   ____  \n  / ___\\ \n / /_/  >\n \\___  / \n/_____/  \n',
    'f': u'  _____ \n_/ ____\\\n\\   __\\ \n |  |   \n |__|   \n        \n',
    'i': u'.__ \n|__|\n|  |\n|  |\n|__|\n    \n',
    'h': u'.__     \n|  |__  \n|  |  \\ \n|   Y  \\\n|___|  /\n     \\/ \n',
    'k': u' __    \n|  | __\n|  |/ /\n|    < \n|__|_ \\\n     \\/\n',
    'j': u'     __ \n    |__|\n    |  |\n    |  |\n/\\__|  |\n\\______|\n',
    'm': u'         \n  _____  \n /     \\ \n|  Y Y  \\\n|__|_|  /\n      \\/ \n',
    'l': u'.__   \n|  |  \n|  |  \n|  |__\n|____/\n      \n',
    'o': u'        \n  ____  \n /  _ \\ \n(  <_> )\n \\____/ \n        \n',
    'n': u'        \n  ____  \n /    \\ \n|   |  \\\n|___|  /\n     \\/ \n',
    'q': u'        \n  ______\n / ____/\n< <_|  |\n \\__   |\n    |__|\n',
    'p': u'        \n______  \n\\____ \\ \n|  |_> >\n|   __/ \n|__|    \n',
    's': u'        \n  ______\n /  ___/\n \\___ \\ \n/____  >\n     \\/ \n',
    'r': u'        \n_______ \n\\_  __ \\\n |  | \\/\n |__|   \n        \n',
    'u': u'       \n __ __ \n|  |  \\\n|  |  /\n|____/ \n       \n',
    't': u'  __   \n_/  |_ \n\\   __\\\n |  |  \n |__|  \n       \n',
    'w': u'         \n__  _  __\n\\ \\/ \\/ /\n \\     / \n  \\/\\_/  \n         \n',
    'v': u'       \n___  __\n\\  \\/ /\n \\   / \n  \\_/  \n       \n',
    'y': u'        \n ___.__.\n<   |  |\n \\___  |\n / ____|\n \\/     \n',
    'x': u'        \n___  ___\n\\  \\/  /\n >    < \n/__/\\_ \\\n      \\/\n',
    '{': u'  ___ \n / /  \n \\ \\  \n < <  \n / /  \n \\_\\_ \n',
    'z': u'        \n________\n\\___   /\n /    / \n/_____ \\\n      \\/\n',
    '}': u' ___  \n  \\ \\ \n  / / \n  > > \n  \\ \\ \n _/_/ \n',
    '|': u' ._. \n | | \n |_| \n |-| \n | | \n |_| \n',
    '~': u'  ___     \n / _ \\_/\\ \n \\/ \\___/ \n          \n          \n          \n'}

stellar_dic = {' ': u' \n \n \n \n \n \n \n \n', '$': u'   `..  \n `. `.. '
                                                    u'\n`..     \n  `..   \n     `..\n`.. `.. \n   `..  \n        \n', '(': u'  `..\n `.. \n`..  \n`..  \n`..  \n `.. \n  `..\n     \n', ',': u'   \n   \n   \n   \n   \n   \n`..\n `.\n', '0': u'            \n    `..     \n  `..  `..  \n`..     `.. \n`..      `..\n `..    `.. \n   `...     \n            \n', '4': u'            \n      `..   \n    ` `..   \n   `. `..   \n `..  `..   \n`.... `. `..\n      `..   \n            \n', '8': u'           \n    `.     \n `..  `..  \n`..     `. \n  `.. `.   \n`..     `..\n  `....    \n           \n', '<': u'      `..\n    `..  \n  `..    \n`..      \n  `..    \n    `..  \n      `..\n         \n', '@': u'             \n    `...     \n  `.    `..  \n `.  `..  `..\n`.. `..`  `..\n `..   ```   \n    `..      \n             \n', 'D': u'`.....    \n`..   `.. \n`..    `..\n`..    `..\n`..    `..\n`..   `.. \n`.....    \n          \n', 'H': u'`..     `..\n`..     `..\n`..     `..\n`...... `..\n`..     `..\n`..     `..\n`..     `..\n           \n', 'L': u'`..      \n`..      \n`..      \n`..      \n`..      \n`..      \n`........\n         \n', 'P': u'`.......  \n`..    `..\n`..    `..\n`.......  \n`..       \n`..       \n`..       \n          \n', 'T': u'`... `......\n     `..    \n     `..    \n     `..    \n     `..    \n     `..    \n     `..    \n            \n', 'X': u'`..      `..\n `..   `..  \n  `.. `..   \n    `..     \n  `.. `..   \n `..   `..  \n`..      `..\n            \n', '\\': u'`..      \n `..     \n  `..    \n   `..   \n    `..  \n     `.. \n      `..\n         \n', '`': u'`..\n`. \n   \n   \n   \n   \n   \n   \n', 'd': u'     `..\n     `..\n     `..\n `.. `..\n`.   `..\n`.   `..\n `.. `..\n        \n', 'h': u'        \n`..     \n`..     \n`. `.   \n`..  `..\n`.   `..\n`..  `..\n        \n', 'l': u' `..\n `..\n `..\n `..\n `..\n `..\n`...\n    \n', 'p': u'        \n        \n`. `..  \n`.  `.. \n`.   `..\n`.. `.. \n`..     \n`..     \n', 't': u'  `..  \n  `..  \n`.`. `.\n  `..  \n  `..  \n  `..  \n   `.. \n       \n', 'x': u'         \n         \n`..   `..\n  `. `.. \n   `.    \n `.  `.. \n`..   `..\n         \n', '|': u'`.\n`.\n`.\n  \n`.\n`.\n`.\n  \n', '#': u'             \n  `..   `..  \n`...... `....\n  `..   `..  \n  `..   `..  \n`...... `....\n  `..   `..  \n             \n', "'": u'`..\n `.\n   \n   \n   \n   \n   \n   \n', '+': u'           \n     `..   \n     `..   \n`... `.....\n     `..   \n     `..   \n           \n           \n', '/': u'      `..\n     `.. \n    `..  \n   `..   \n  `..    \n `..     \n`..      \n         \n', '3': u'         \n`.. `..  \n   `..   \n `..     \n    `..  \n      `..\n`.....   \n         \n', '7': u'          \n`..... `..\n      `.. \n     `..  \n    `..   \n    `..   \n    `..   \n          \n', ';': u'   \n   \n   \n   \n`..\n   \n`..\n `.\n', '?': u'`...    \n    `.. \n     `..\n    `.. \n `..    \n        \n `..    \n        \n', 'C': u'    `..   \n `..   `..\n`..       \n`..       \n`..       \n `..   `..\n   `....  \n          \n', 'G': u'   `....   \n `.    `.. \n`..        \n`..        \n`..   `....\n `..    `. \n  `.....   \n           \n', 'K': u'`..   `..  \n`..  `..   \n`.. `..    \n`. `.      \n`..  `..   \n`..   `..  \n`..     `..\n           \n', 'O': u'    `....     \n  `..    `..  \n`..        `..\n`..        `..\n`..        `..\n  `..     `.. \n    `....     \n              \n', 'S': u'  `.. ..  \n`..    `..\n `..      \n   `..    \n      `.. \n`..    `..\n  `.. ..  \n          \n', 'W': u'`..        `..\n`..        `..\n`..   `.   `..\n`..  `..   `..\n`.. `. `.. `..\n`. `.    `....\n`..        `..\n              \n', '[': u'`....\n`..  \n`..  \n`..  \n`..  \n`..  \n`....\n     \n', '_': u'      \n      \n      \n      \n      \n      \n      \n`.....\n', 'c': u'       \n       \n   `...\n `..   \n`..    \n `..   \n   `...\n       \n', 'g': u'         \n         \n   `..   \n `..  `..\n`..   `..\n `..  `..\n     `.. \n  `..    \n', 'k': u'`..     \n`..     \n`..  `..\n`.. `.. \n`.`..   \n`.. `.. \n`..  `..\n        \n', 'o': u'          \n          \n   `..    \n `..  `.. \n`..    `..\n `..  `.. \n   `..    \n          \n', 's': u'       \n       \n `.... \n`..    \n  `... \n    `..\n`.. `..\n       \n', 'w': u'            \n            \n`..     `...\n `..  .  `..\n `.. `.  `..\n `. `. `.`..\n`...    `...\n            \n', '{': u'    `..\n  `..  \n  `..  \n`...   \n  `..  \n  `..  \n    `..\n       \n', '"': u'`. `.\n`. `.\n     \n     \n     \n     \n     \n     \n', '&': u'   `.   \n `.. `..\n`..     \n `...   \n`..     \n `.. `..\n   `.   \n        \n', '*': u'      `..     \n `..  `..  `..\n   `. `. `..  \n`.... `.......\n   `. `. `..  \n `..  `..  `..\n      `..     \n              \n', '.': u'   \n   \n   \n   \n   \n   \n`..\n   \n', '2': u'          \n `.. `..  \n`.     `..\n     `..  \n   `..    \n `..      \n`........ \n          \n', '6': u'           \n    `..    \n   `..     \n  `..      \n`.    `..  \n`..     `..\n  `.. `..  \n           \n', ':': u'   \n   \n   \n   \n`..\n   \n`..\n   \n', '>': u'`..      \n  `..    \n    `..  \n      `..\n    `..  \n  `..    \n`..      \n         \n', 'B': u'`.. `..   \n`.    `.. \n`.     `..\n`... `.   \n`.     `..\n`.      `.\n`.... `.. \n          \n', 'F': u'`........\n`..      \n`..      \n`......  \n`..      \n`..      \n`..      \n         \n', 'J': u'     `..\n     `..\n     `..\n     `..\n     `..\n`.   `..\n `....  \n        \n', 'N': u'`...     `..\n`. `..   `..\n`.. `..  `..\n`..  `.. `..\n`..   `. `..\n`..    `. ..\n`..      `..\n            \n', 'R': u'`.......    \n`..    `..  \n`..    `..  \n`. `..      \n`..  `..    \n`..    `..  \n`..      `..\n            \n', 'V': u'`..         `..\n `..       `.. \n  `..     `..  \n   `..   `..   \n    `.. `..    \n     `....     \n      `..      \n               \n', 'Z': u'`....... `..\n       `..  \n      `..   \n    `..     \n   `..      \n `..        \n`...........\n            \n', '^': u'    `..    \n  `.. `..  \n`..     `..\n           \n           \n           \n           \n           \n', 'b': u'`..      \n`..      \n`..      \n`.. `..  \n`..   `..\n`..   `..\n`.. `..  \n         \n', 'f': u'    `..\n  `.   \n`.`. `.\n  `..  \n  `..  \n  `..  \n  `..  \n       \n', 'j': u'      \n   `..\n      \n   `..\n   `..\n   `..\n   `..\n`...  \n', 'n': u'         \n         \n`.. `..  \n `..  `..\n `..  `..\n `..  `..\n`...  `..\n         \n', 'r': u'       \n       \n`. `...\n `..   \n `..   \n `..   \n`...   \n       \n', 'v': u'           \n           \n`..     `..\n `..   `.. \n  `.. `..  \n   `.`..   \n    `..    \n           \n', 'z': u'         \n         \n`.... `..\n     `.. \n   `..   \n  `..    \n`........\n         \n', '~': u'`..  `.   \n   `.  `..\n          \n          \n          \n          \n          \n          \n', '!': u'`..\n`..\n`..\n`. \n`. \n   \n`..\n   \n', '%': u'         \n`..  `.. \n    `..  \n   `..   \n  `..    \n `..     \n`..  `.. \n         \n', ')': u'`..  \n `.. \n  `..\n  `..\n  `..\n `.. \n`..  \n     \n', '-': u'      \n      \n      \n`.....\n      \n      \n      \n      \n', '1': u'     \n`..  \n `.. \n `.. \n `.. \n `.. \n`....\n     \n', '5': u'         \n`.. `... \n`..      \n`...     \n    `..  \n      `..\n`... `.. \n         \n', '9': u'            \n   `. `..   \n `..     `..\n`.      `.. \n  `.  `..   \n     `..    \n   `..      \n            \n', '=': u'       \n       \n`......\n       \n`......\n       \n       \n       \n', 'A': u'      `.       \n     `. ..     \n    `.  `..    \n   `..   `..   \n  `...... `..  \n `..       `.. \n`..         `..\n               \n', 'E': u'`........\n`..      \n`..      \n`......  \n`..      \n`..      \n`........\n         \n', 'I': u'`..\n`..\n`..\n`..\n`..\n`..\n`..\n   \n', 'M': u'`..       `..\n`. `..   `...\n`.. `.. ` `..\n`..  `..  `..\n`..   `.  `..\n`..       `..\n`..       `..\n             \n', 'Q': u'    `....    \n  `..    `.. \n`..       `..\n`..       `..\n`..       `..\n  `.. `. `.. \n    `.. ..   \n         `.  \n', 'U': u'`..     `..\n`..     `..\n`..     `..\n`..     `..\n`..     `..\n`..     `..\n  `.....   \n           \n', 'Y': u'`..      `..\n `..    `.. \n  `.. `..   \n    `..     \n    `..     \n    `..     \n    `..     \n            \n', ']': u'`....\n  `..\n  `..\n  `..\n  `..\n  `..\n`....\n     \n', 'a': u'          \n          \n   `..    \n `..  `.. \n`..   `.. \n`..   `.. \n  `.. `...\n          \n', 'e': u'          \n          \n   `..    \n `.   `.. \n`..... `..\n`.        \n  `....   \n          \n', 'i': u'   \n `.\n   \n`..\n`..\n`..\n`..\n   \n', 'm': u'             \n             \n`... `.. `.. \n `..  `.  `..\n `..  `.  `..\n `..  `.  `..\n`...  `.  `..\n             \n', 'q': u'        \n        \n  `..   \n`.  `.. \n`.  `.. \n `..`.. \n    `.. \n    `...\n', 'u': u'        \n        \n`..  `..\n`..  `..\n`..  `..\n`..  `..\n  `..`..\n        \n', 'y': u'         \n         \n`..   `..\n `.. `.. \n   `...  \n    `..  \n   `..   \n `..     \n', '}': u'`..    \n  `..  \n  `..  \n    `..\n  `..  \n  `..  \n`..    \n       \n'}

swan_dic = {' ': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n', '$': u"    "
                                                                     u"\n    \n .. \n.|-.\n`-|.\n`|-'\n '' \n    \n    \n", '(': u'   \n   \n ,-\n:  \n|  \n:  \n`._\n   \n   \n', ',': u"  \n  \n  \n  \n  \n  \n o\n-'\n  \n", '0': u"     \n     \n .-. \n:   :\n|   |\n:   ;\n `-' \n     \n     \n", '4': u"     \n     \n.  . \n|  | \n'--|-\n   | \n   ' \n     \n     \n", '8': u"     \n     \n .-. \n(   )\n >-< \n(   )\n `-' \n     \n     \n", '<': u"     \n     \n     \n   .'\n .'  \n`.   \n  `. \n    `\n     \n", '@': u"         \n         \n         \n  .-`-.  \n.' .-. `.\n| (   ) ;\n`. `-'`' \n  `---   \n         \n", 'D': u"     \n     \n.--. \n|   :\n|   |\n|   ;\n'--' \n     \n     \n", 'H': u"     \n     \n.   .\n|   |\n|---|\n|   |\n'   '\n     \n     \n", 'L': u"     \n     \n.    \n|    \n|    \n|    \n'---'\n     \n     \n", 'P': u"     \n     \n.--. \n|   )\n|--' \n|    \n'    \n     \n     \n", 'T': u"     \n     \n.---.\n  |  \n  |  \n  |  \n  '  \n     \n     \n", 'X': u"     \n     \n.   .\n \\ / \n  /  \n / \\ \n'   '\n     \n     \n", '\\': u'     \n     \n.    \n \\   \n  \\  \n   \\ \n    `\n     \n     \n', '`': u'  \n  \no \n \\\n  \n  \n  \n  \n  \n', 'd': u"      \n      \n    . \n    | \n .-.| \n(   | \n `-'`-\n      \n      \n", 'h': u"     \n     \n.    \n|    \n|--. \n|  | \n'  `-\n     \n     \n", 'l': u'  \n  \n. \n| \n| \n| \n`-\n  \n  \n', 'p': u"     \n     \n     \n     \n.,-. \n|   )\n|`-' \n|    \n'    \n", 't': u"    \n    \n .  \n_|_ \n |  \n |  \n `-'\n    \n    \n", 'x': u"     \n     \n     \n     \n-. ,-\n  :  \n-' `-\n     \n     \n", '|': u" \n \n.\n|\n|\n|\n|\n|\n'\n", '#': u"      \n      \n .  . \n_|__|_\n |  | \n-|--|-\n '  ' \n      \n      \n", "'": u' \n \n.\n|\n \n \n \n \n \n', '+': u"       \n       \n       \n   .   \n __|__ \n   |   \n   '   \n       \n       \n", '/': u"     \n     \n    ,\n   / \n  /  \n /   \n'    \n     \n     \n", '3': u"     \n     \n.--. \n    )\n --: \n    )\n`--' \n     \n     \n", '7': u"     \n     \n.---.\n    /\n   / \n  /  \n '   \n     \n     \n", ';': u"   \n   \n   \n   \n o \n   \n o \n-' \n   \n", '?': u"     \n     \n .-. \n'   )\n   / \n  '  \n  o  \n     \n     \n", 'C': u"     \n     \n .--.\n:    \n|    \n:    \n `--'\n     \n     \n", 'G': u"     \n     \n .--.\n:    \n| --.\n:   |\n `--'\n     \n     \n", 'K': u"     \n     \n.   .\n|  / \n|-'  \n|  \\ \n'   `\n     \n     \n", 'O': u"      \n      \n .--. \n:    :\n|    |\n:    ;\n `--' \n      \n      \n", 'S': u"     \n     \n .-. \n(   )\n `-. \n(   )\n `-' \n     \n     \n", 'W': u"           \n           \n.  .   .  .\n \\  \\ /  / \n  \\  \\  /  \n   \\/ \\/   \n    ' '    \n           \n           \n", '[': u"   \n   \n.--\n|  \n|  \n|  \n'--\n   \n   \n", '_': u'    \n    \n    \n    \n    \n    \n____\n    \n    \n', 'c': u"    \n    \n    \n    \n .-.\n(   \n `-'\n    \n    \n", 'g': u"     \n     \n     \n     \n .-..\n(   |\n `-`|\n ._.'\n     \n", 'k': u"     \n     \n.    \n|    \n|.-. \n|-.' \n'  `-\n     \n     \n", 'o': u"     \n     \n     \n     \n .-. \n(   )\n `-' \n     \n     \n", 's': u"    \n    \n    \n    \n.--.\n`--.\n`--'\n    \n    \n", 'w': u"          \n          \n          \n          \n.  .    ._\n \\  \\  /  \n  `' `'   \n          \n          \n", '{': u'    \n    \n .- \n |  \n<   \n |  \n `- \n    \n    \n', '"': u'   \n   \n. .\n| |\n   \n   \n   \n   \n   \n', '&': u"       \n       \n  .-.  \n (   ) \n .--'  \n(   `.)\n `---'`\n       \n       \n", '*': u"       \n       \n   .   \n_  |  _\n `-:-' \n  / \\  \n '   ` \n       \n       \n", '.': u' \n \n \n \n \n \no\n \n \n', '2': u"     \n     \n .-. \n(   )\n  .' \n /   \n'---'\n     \n     \n", '6': u"     \n     \n   , \n  /  \n /-. \n(   )\n `-' \n     \n     \n", ':': u'  \n  \n  \n  \no \n  \no \n  \n  \n', '>': u"     \n     \n`.   \n  `. \n   .`\n .'  \n'    \n     \n     \n", 'B': u"     \n     \n.--. \n|   )\n|--: \n|   )\n'--' \n     \n     \n", 'F': u"     \n     \n.---.\n|    \n|--- \n|    \n'    \n     \n     \n", 'J': u"     \n     \n.---.\n    |\n    |\n    ;\n`--' \n     \n     \n", 'N': u"     \n     \n.   .\n|\\  |\n| \\ |\n|  \\|\n'   '\n     \n     \n", 'R': u"     \n     \n.--. \n|   )\n|--' \n|  \\ \n'   `\n     \n     \n", 'V': u"         \n         \n.       .\n \\     / \n  \\   /  \n   \\ /   \n    '    \n         \n         \n", 'Z': u"     \n     \n.---.\n   / \n  /  \n /   \n'---'\n     \n     \n", '^': u"     \n     \n  .  \n.' `.\n     \n     \n     \n     \n     \n", 'b': u"     \n     \n.    \n|    \n|.-. \n|   )\n'`-' \n     \n     \n", 'f': u"    \n    \n .-.\n |  \n-|- \n |  \n '  \n    \n    \n", 'j': u"    \n    \n    \n   o\n   .\n   |\n   |\n   ;\n`-' \n", 'n': u"     \n     \n     \n     \n.--. \n|  | \n'  `-\n     \n     \n", 'r': u"    \n    \n    \n    \n.--.\n|   \n'   \n    \n    \n", 'v': u"       \n       \n       \n       \n.    ._\n \\  /  \n  `'   \n       \n       \n", 'z': u"    \n    \n    \n    \n---.\n .' \n'---\n    \n    \n", '~': u"        \n        \n        \n        \n .-.   .\n'   `-' \n        \n        \n        \n", '!': u" \n \n.\n|\n|\n'\no\n \n \n", '%': u"      \n      \n      \n _    \n(_) ,'\n  ,'_ \n,' (_)\n      \n      \n", ')': u"   \n   \n-. \n  :\n  |\n  :\n_.'\n   \n   \n", '-': u'      \n      \n      \n      \n ____ \n      \n      \n      \n      \n', '1': u"     \n     \n  .  \n.'|  \n  |  \n  |  \n'---'\n     \n     \n", '5': u"     \n     \n.---.\n|    \n'--. \n.   )\n `-' \n     \n     \n", '9': u"     \n     \n .-. \n(   )\n `-/ \n  /  \n '   \n     \n     \n", '=': u'      \n      \n      \n      \n ---- \n ---- \n      \n      \n      \n', 'A': u"         \n         \n    .    \n   / \\   \n  /___\\  \n /     \\ \n'       `\n         \n         \n", 'E': u"     \n     \n.---.\n|    \n|--- \n|    \n'---'\n     \n     \n", 'I': u"     \n     \n--.--\n  |  \n  |  \n  |  \n--'--\n     \n     \n", 'M': u"      \n      \n.    .\n|\\  /|\n| \\/ |\n|    |\n'    '\n      \n      \n", 'Q': u'      \n      \n .--. \n:    :\n|    |\n:  ( ;\n `--`-\n      \n      \n', 'U': u"     \n     \n.   .\n|   |\n|   |\n:   ;\n `-' \n     \n     \n", 'Y': u"     \n     \n.   .\n \\ / \n  :  \n  |  \n  '  \n     \n     \n", ']': u"   \n   \n--.\n  |\n  |\n  |\n--'\n   \n   \n", 'a': u"      \n      \n      \n      \n .-.  \n(   ) \n `-'`-\n      \n      \n", 'e': u"     \n     \n     \n     \n .-. \n(.-' \n `--'\n     \n     \n", 'i': u"     \n     \n     \n  o  \n  .  \n  |  \n-' `-\n     \n     \n", 'm': u"        \n        \n        \n        \n.--.--. \n|  |  | \n'  '  `-\n        \n        \n", 'q': u"      \n      \n      \n      \n .-., \n(   | \n `-'| \n   -|-\n    ' \n", 'u': u'     \n     \n     \n     \n.  . \n|  | \n`--`-\n     \n     \n', 'y': u"    \n    \n    \n    \n.  .\n|  |\n`--|\n   ;\n`-' \n", '}': u"   \n   \n-. \n | \n  >\n | \n_' \n   \n   \n"}

tanja_dic = {' ': u'   \n   \n   \n   \n   \n   \n   \n   \n', '$': u'   S)    \n S)4444  \nS) 44    \n S)4444  \n   S) 44 \nS)44444  \n   S)    \n         \n', '(': u'   () \n ()   \n()    \n()    \n ()   \n   () \n      \n      \n', ',': u'    \n    \n    \n    \n*** \n ## \n##  \n    \n', '0': u' 0))))  \n0)  ))) \n0) ) )) \n0) ) )) \n0))  )) \n 0))))  \n        \n        \n', '4': u'4)   SS \n4)   SS \n4)SSSSS \n     4) \n     4) \n     4) \n        \n        \n', '8': u' 8)***  \n8)   ** \n 8)***  \n8)   ** \n8)   ** \n 8)***  \n        \n        \n', '<': u'   <) \n  <)  \n <)   \n<)    \n <)   \n  <)  \n   <) \n      \n', '@': u' A)222  \nA)    2 \nA) 2222 \nA) 2  2 \nA)  222 \n A)     \n        \n        \n', 'D': u'D)dddd   \nD)   dd  \nD)    dd \nD)    dd \nD)    dd \nD)ddddd  \n         \n         \n', 'H': u'H)    hh \nH)    hh \nH)hhhhhh \nH)    hh \nH)    hh \nH)    hh \n         \n         \n', 'L': u'L)       \nL)       \nL)       \nL)       \nL)       \nL)llllll \n         \n         \n', 'P': u'P)ppppp  \nP)    pp \nP)ppppp  \nP)       \nP)       \nP)       \n         \n         \n', 'T': u'T)tttttt \n   T)    \n   T)    \n   T)    \n   T)    \n   T)    \n         \n         \n', 'X': u'X)    xx \n X)  xx  \n  X)xx   \n  X)xx   \n X)  xx  \nX)    xx \n         \n         \n', '\\': u'\\)|      \n \\)|     \n  \\)|    \n   \\)|   \n    \\)|  \n     \\)| \n         \n         \n', '`': u'*** \n##  \n ## \n    \n    \n    \n    \n    \n', 'd': u'     d) \n     d) \n d)DDDD \nd)   DD \nd)   DD \n d)DDDD \n        \n        \n', 'h': u'h)      \nh)      \nh)HHHH  \nh)   HH \nh)   HH \nh)   HH \n        \n        \n', 'l': u'l)L  \n l)  \n l)  \n l)  \n l)  \nl)LL \n     \n     \n', 'p': u'        \n        \np)PPPP  \np)   PP \np)   PP \np)PPPP  \np)      \np)      \n', 't': u'  t)   \nt)tTTT \n  t)   \n  t)   \n  t)   \n  t)T  \n       \n       \n', 'x': u'        \n        \nx)   XX \n  x)X   \n  x)X   \nx)   XX \n        \n        \n', '|': u'|)\\ \n|)\\ \n|)\\ \n|)\\ \n|)\\ \n|)\\ \n    \n    \n', '#': u'  #) 33   \n#)3333333 \n  #) 33   \n  #) 33   \n#)3333333 \n  #) 33   \n          \n          \n', "'": u'*** \n ## \n##  \n    \n    \n    \n    \n    \n', '+': u'       \n       \n  ##   \n###### \n  ##   \n       \n       \n       \n', '/': u'     /)? \n    /)?  \n   /)?   \n  /)?    \n /)?     \n/)?      \n         \n         \n', '3': u' 3)###  \n3)   ## \n   3)#  \n     3) \n3)   ## \n 3)###  \n        \n        \n', '7': u'7)&&&&& \n    7)  \n   7)   \n  7)    \n 7)     \n7)      \n        \n        \n', ';': u'    \n    \n ## \n    \n*** \n ## \n##  \n    \n', '?': u' ?)////  \n?)    // \n    ?)   \n   ?)    \n         \n   ?)    \n         \n         \n', 'C': u'  C)ccc  \n C)   cc \nC)       \nC)       \n C)   cc \n  C)ccc  \n         \n         \n', 'G': u'  G)gggg \n G)      \nG)  ggg  \nG)    gg \n G)   gg \n  G)ggg  \n         \n         \n', 'K': u'K)   kk  \nK)  kk   \nK)kkk    \nK)  kk   \nK)   kk  \nK)    kk \n         \n         \n', 'O': u' O)oooo  \nO)    oo \nO)    oo \nO)    oo \nO)    oo \n O)oooo  \n         \n         \n', 'S': u' S)ssss  \nS)    ss \n S)ss    \n     S)  \nS)    ss \n S)ssss  \n         \n         \n', 'W': u'W)      ww \nW)      ww \nW)  ww  ww \nW)  ww  ww \nW)  ww  ww \n W)ww www  \n           \n           \n', '[': u'[){{ \n[)   \n[)   \n[)   \n[)   \n[){{ \n     \n     \n', '_': u'        \n        \n        \n        \n        \n####### \n        \n        \n', 'c': u'        \n        \n c)CCCC \nc)      \nc)      \n c)CCCC \n        \n        \n', 'g': u'        \n        \n g)GGG  \ng)   GG \ng)   GG \n g)GGGG \n     GG \ng)GGGG  \n', 'k': u'k)     \nk)     \nk)  KK \nk)KK   \nk) KK  \nk)  KK \n       \n       \n', 'o': u'        \n        \n o)OOO  \no)   OO \no)   OO \n o)OOO  \n        \n        \n', 's': u'        \n        \n s)SSSS \ns)SSSS  \n     s) \ns)SSSS  \n        \n        \n', 'w': u'           \n           \nw)      WW \nw)  WW  WW \nw)  WW  WW \n w)WW WWW  \n           \n           \n', '{': u' {)[[[ \n  {)   \n[{)    \n  {)   \n {)    \n {)[[[ \n       \n       \n', '"': u'*** *** \n##  ##  \n##  ##  \n        \n        \n        \n        \n        \n', '&': u' &)77    \n&)  77   \n &)77    \n&)  77   \n&)   77  \n &)77777 \n         \n         \n', '*': u'    *)    \n*)  8  88 \n  *)8 8   \n*)8888888 \n  *)8 8   \n*)  8  88 \n   *)     \n          \n', '.': u'   \n   \n   \n   \n** \n## \n   \n   \n', '2': u' 2)AAA  \n2)   AA \n    2)  \n   2)   \n  2)    \n2)AAAAA \n        \n        \n', '6': u' 6)NNN  \n6)      \n6)NNNN  \n6)   NN \n6)   NN \n 6)NNN  \n        \n        \n', ':': u'   \n   \n## \n   \n## \n   \n   \n   \n', '>': u'>)    \n >)   \n  >)  \n   >) \n  >)  \n >)   \n>)    \n      \n', 'B': u'B)bbbb   \nB)   bb  \nB)bbbb   \nB)   bb  \nB)    bb \nB)bbbbb  \n         \n         \n', 'F': u'F)ffffff \nF)       \nF)fffff  \nF)       \nF)       \nF)       \n         \n         \n', 'J': u'J)jjjjjj \n    J)   \n    J)   \nJ)  jj   \nJ)  jj   \n J)jj    \n         \n         \n', 'N': u'N)n   nn \nN)nn  nn \nN) nn nn \nN)  nnnn \nN)   nnn \nN)    nn \n         \n         \n', 'R': u'R)rrrrr  \nR)    rr \nR)  rrr  \nR) rr    \nR)   rr  \nR)    rr \n         \n         \n', 'V': u'V)    vv \nV)    vv \nV)    vv \n V)  vv  \n  V)vv   \n   V)    \n         \n         \n', 'Z': u'Z)zzzzzz \n      Z) \n    Z)   \n   Z)    \n Z)      \nZ)zzzzzz \n         \n         \n', '^': u'  **   \n##  ## \n       \n       \n       \n       \n       \n       \n', 'b': u'b)      \nb)      \nb)BBBB  \nb)   BB \nb)   BB \nb)BBBB  \n        \n        \n', 'f': u' f)FFF \nf)     \nf)FFF  \nf)     \nf)     \nf)     \n       \n       \n', 'j': u'     ## \n        \n     j) \n     j) \n     j) \n     j) \nj)   JJ \n j)JJJ  \n', 'n': u'        \n        \nn)NNNN  \nn)   NN \nn)   NN \nn)   NN \n        \n        \n', 'r': u'        \n        \n r)RRR  \nr)   RR \nr)      \nr)      \n        \n        \n', 'v': u'         \n         \nv)    VV \n v)  VV  \n  v)VV   \n   v)    \n         \n         \n', 'z': u'        \n        \nz)ZZZZZ \n    z)  \n  z)    \nz)ZZZZZ \n        \n        \n', '~': u'        \n_-`-_-` \n        \n        \n        \n        \n        \n        \n', '!': u' !)  \n!)11 \n!)11 \n !)  \n     \n !)  \n     \n     \n', '%': u' %)   555 \n%)   555  \n    %)5   \n  %)5     \n %)5   55 \n%)5   55  \n          \n          \n', ')': u'))    \n  ))  \n   )) \n   )) \n  ))  \n))    \n      \n      \n', '-': u'        \n        \n        \n####### \n        \n        \n        \n        \n', '1': u'  1)!   \n 1)!!   \n   1)   \n   1)   \n   1)   \n1)!!!!! \n        \n        \n', '5': u'5)%%%%  \n5)      \n5)%%%%  \n     5) \n     5) \n5)%%%%  \n        \n        \n', '9': u' 9)(((  \n9)   (( \n 9)(((( \n     9) \n9)   (( \n 9)(((  \n        \n        \n', '=': u'        \n        \n####### \n        \n####### \n        \n        \n        \n', 'A': u'  A)aa   \n A)  aa  \nA)    aa \nA)aaaaaa \nA)    aa \nA)    aa \n         \n         \n', 'E': u'E)eeeeee \nE)       \nE)eeeee  \nE)       \nE)       \nE)eeeeee \n         \n         \n', 'I': u'I)iiii \n  I)   \n  I)   \n  I)   \n  I)   \nI)iiii \n       \n       \n', 'M': u' M)mm mmm  \nM)  mm  mm \nM)  mm  mm \nM)  mm  mm \nM)      mm \nM)      mm \n           \n           \n', 'Q': u' Q)qqqq  \nQ)    qq \nQ)    qq \nQ)  qq q \nQ)   qq  \n Q)qqq q \n         \n         \n', 'U': u'U)    uu \nU)    uu \nU)    uu \nU)    uu \nU)    uu \n U)uuuu  \n         \n         \n', 'Y': u'Y)    yy \n Y)  yy  \n  Y)yy   \n   Y)    \n   Y)    \n   Y)    \n         \n         \n', ']': u'])}} \n  ]) \n  ]) \n  ]) \n  ]) \n])}} \n     \n     \n', 'a': u'        \n        \na)AAAA  \n a)AAA  \na)   A  \n a)AAAA \n        \n        \n', 'e': u'        \n        \ne)EEEEE \ne)EEEE  \ne)      \n e)EEEE \n        \n        \n', 'i': u'## \n   \ni) \ni) \ni) \ni) \n   \n   \n', 'm': u'           \n           \n m)MM MMM  \nm)  MM  MM \nm)  MM  MM \nm)      MM \n           \n           \n', 'q': u'        \n        \n q)QQQ  \nq)   QQ \nq)   QQ \n q)QQQQ \n     q) \n     q) \n', 'u': u'        \n        \nu)   UU \nu)   UU \nu)   UU \n u)UUU  \n        \n        \n', 'y': u'        \n        \ny)   YY \ny)   YY \ny)   YY \n y)YYYY \n     y) \ny)YYYY  \n', '}': u'})]]]  \n  })   \n   })] \n  })   \n   })  \n})]]]  \n       \n       \n'}

thick_dic = {' ': u'   \n   \n   \n   \n   \n', '$': u'.w8w. \n"w8 " \n  8w  '
                                                  u'\n"w8w" \n  "   \n', '(': u".dP \n8P  \n8   \n8b  \n'Yb \n", ',': u'   \n   \n   \n w \n." \n', '0': u".d88b. \n8P  Y8 \n8b  d8 \n`Y88P' \n       \n", '4': u'  d8 \n dP8 \ndPw8 \n   8 \n     \n', '8': u'.dPYb. \nYbwwdP \ndP""Yb \n`YbdP\' \n       \n', '<': u'  dP \n dP  \ndb   \n Yb  \n  Yb \n', '@': u'd""""b \nP PY 8 \nb bdwP \nYbwww\' \n       \n', 'D': u"888b. \n8   8 \n8   8 \n888P' \n      \n", 'H': u'8   8 \n8www8 \n8   8 \n8   8 \n      \n', 'L': u'8    \n8    \n8    \n8888 \n     \n', 'P': u"888b. \n8  .8 \n8wwP' \n8     \n      \n", 'T': u'88888 \n  8   \n  8   \n  8   \n      \n', 'X': u'Yb  dP \n YbdP  \n dPYb  \ndP  Yb \n       \n', '\\': u'Yb    \n Yb   \n  Yb  \n   Yb \n      \n', '`': u'w  \n". \n   \n   \n   \n', 'd': u'   8 \n.d88 \n8  8 \n`Y88 \n     \n', 'h': u'8     \n8d8b. \n8P Y8 \n8   8 \n      \n', 'l': u'8 \n8 \n8 \n8 \n  \n', 'p': u"     \n88b. \n8  8 \n88P' \n8    \n", 't': u' w   \nw8ww \n 8   \n Y8P \n     \n', 'x': u'      \nYb dP \n `8.  \ndP Yb \n      \n', '|': u'8 \n8 \n8 \n8 \n8 \n', '#': u' 8  8  \nw8ww8w \nw8ww8w \n 8  8  \n       \n', "'": u' w \n." \n   \n   \n   \n', '+': u'      \n  8   \nww8ww \n  8   \n      \n', '/': u'   dP \n  dP  \n dP   \ndP    \n      \n', '3': u'd88b \n wwP \n   8 \nY88P \n     \n', '7': u'8888P \n  dP  \n dP   \ndP    \n      \n', ';': u'   \n w \n   \n w \n." \n', '?': u'dP"Yb \n"  d8 \n  dP  \n  w   \n      \n', 'C': u'.d88b \n8P    \n8b    \n`Y88P \n      \n', 'G': u".d88b  \n8P www \n8b  d8 \n`Y88P' \n       \n", 'K': u'8  dP \n8wdP  \n88Yb  \n8  Yb \n      \n', 'O': u".d88b. \n8P  Y8 \n8b  d8 \n`Y88P' \n       \n", 'S': u".d88b. \nYPwww. \n    d8 \n`Y88P' \n       \n", 'W': u'Yb        dP \n Yb  db  dP  \n  YbdPYbdP   \n   YP  YP    \n             \n', '[': u'88 \n8  \n8  \n8  \n88 \n', '_': u'     \n     \n     \nwwww \n     \n', 'c': u'     \n.d8b \n8    \n`Y8P \n     \n', 'g': u'     \n.d88 \n8  8 \n`Y88 \nwwdP \n', 'k': u'8    \n8.dP \n88b  \n8 Yb \n     \n', 'o': u"      \n.d8b. \n8' .8 \n`Y8P' \n      \n", 's': u'     \nd88b \n`Yb. \nY88P \n     \n', 'w': u'           \nYb  db  dP \n YbdPYbdP  \n  YP  YP   \n           \n', '{': u" .dP \n 8P  \nw'   \n 8b  \n 'Yb \n", '"': u'w w \n" " \n    \n    \n    \n', '&': u'dP8P \nYbww \ndP   \nYb8b \n  "  \n', '*': u'Yb  dP \nwYbdPw \n dPYb  \ndP  Yb \n       \n', '.': u'  \n  \n  \nw \n  \n', '2': u'd88b \n" dP \n dP  \nd888 \n     \n', '6': u" d88b  \n8Pwww. \n8b  d8 \n`Y88P' \n       \n", ':': u'  \nw \n  \nw \n  \n', '>': u'Yb   \n Yb  \n  db \n dP  \ndP   \n', 'B': u"888b. \n8wwwP \n8   b \n888P' \n      \n", 'F': u'8888 \n8www \n8    \n8    \n     \n', 'J': u' 8888 \n   8  \nw  8  \n`Yw"  \n      \n', 'N': u'8b  8 \n8Ybm8 \n8  "8 \n8   8 \n      \n', 'R': u"888b. \n8  .8 \n8wwK' \n8  Yb \n      \n", 'V': u'Yb    dP \n Yb  dP  \n  YbdP   \n   YP    \n         \n', 'Z': u'8888P \n  dP  \n dP   \nd8888 \n      \n', '^': u' dPYb  \ndP  Yb \n       \n       \n       \n', 'b': u"8    \n88b. \n8  8 \n88P' \n     \n", 'f': u" d8b \n 8'  \nw8ww \n 8   \n     \n", 'j': u'  w \n  w \n  8 \n  8 \nwdP \n', 'n': u'      \n8d8b. \n8P Y8 \n8   8 \n      \n', 'r': u'     \n8d8b \n8P   \n8    \n     \n', 'v': u'       \nYb  dP \n YbdP  \n  YP   \n       \n', 'z': u'     \n888P \n dP  \nd888 \n     \n', '~': u' dPYb  dP \ndP  YbdP  \n          \n          \n          \n', '!': u'8 \n8 \n" \nw \n  \n', '%': u'o  dP \n  dP  \n dP   \ndP  o \n      \n', ')': u"Yb. \n Y8 \n  8 \n d8 \ndP' \n", '-': u'     \n     \nwwww \n     \n     \n', '1': u'd8 \n 8 \n 8 \n 8 \n   \n', '5': u'8888 \n8ww. \n  `8 \nY88P \n     \n', '9': u'.d88b \n8   8 \n`8w88 \n    8 \n      \n', '=': u'     \nwwww \nwwww \n     \n     \n', 'A': u'   db    \n  dPYb   \n dPwwYb  \ndP    Yb \n         \n', 'E': u'8888 \n8www \n8    \n8888 \n     \n', 'I': u'888 \n 8  \n 8  \n888 \n    \n', 'M': u'8b   d8 \n8YbmdP8 \n8  "  8 \n8     8 \n        \n', 'Q': u'.d88b. \n8P  Y8 \n8b wd8 \n`Y88Pw \n       \n', 'U': u"8    8 \n8    8 \n8b..d8 \n`Y88P' \n       \n", 'Y': u'Yb  dP \n YbdP  \n  YP   \n  88   \n       \n', ']': u'88 \n 8 \n 8 \n 8 \n88 \n', 'a': u'     \n.d88 \n8  8 \n`Y88 \n     \n', 'e': u"      \n.d88b \n8.dP' \n`Y88P \n      \n", 'i': u'w \nw \n8 \n8 \n  \n', 'm': u'          \n8d8b.d8b. \n8P Y8P Y8 \n8   8   8 \n          \n', 'q': u'      \n.d88  \n8  8  \n`Y88  \n   8P \n', 'u': u'      \n8   8 \n8b d8 \n`Y8P8 \n      \n', 'y': u'       \nYb  dP \n YbdP  \n  dP   \n dP    \n', '}': u"Yb.  \n Y8  \n  `w \n d8  \ndP'  \n"}

threepoint_dic = {' ': u'  \n  \n  \n', '$': u'(|~\n_|)\n   \n', '(': u' /\n| '
                                                                   u'\n \\\n', ',': u' \n,\n \n', '0': u'/X\nX/\n  \n', '4': u'|_|\n  |\n   \n', '8': u'(~)\n(_)\n   \n', '<': u' /\n( \n \\\n', '@': u' /~~\\\n| (|/\n \\__ \n', 'D': u'|~\\\n|_/\n   \n', 'H': u'|_|\n| |\n   \n', 'L': u'| \n|_\n  \n', 'P': u'|~)\n|~ \n   \n', 'T': u'~|~\n | \n   \n', 'X': u'\\/\n/\\\n  \n', '\\': u'\\ \n \\\n  \n', '`': u'`\n \n \n', 'd': u' _|\n(_|\n   \n', 'h': u'|_ \n| |\n   \n', 'l': u'|\n|\n \n', 'p': u' _ \n|_)\n|  \n', 't': u'_|_\n | \n   \n', 'x': u'  \n><\n  \n', '|': u'|\n|\n|\n', '#': u'++\n++\n  \n', "'": u"'\n \n \n", '+': u'_|_\n ! \n   \n', '/': u' /\n/ \n  \n', '3': u"'~)\n._)\n   \n", '7': u'~/\n/ \n  \n', ';': u'.\n,\n \n', '?': u"'~)\n ! \n   \n", 'C': u'/~`\n\\_,\n   \n', 'G': u'/~_\n\\_/\n   \n', 'K': u'|/\n|\\\n  \n', 'O': u'/~\\\n\\_/\n   \n', 'S': u'(~\n_)\n  \n', 'W': u'\\    /\n \\/\\/ \n      \n', '[': u'|~\n| \n|_\n', '_': u'  \n__\n  \n', 'c': u' _\n(_\n  \n', 'g': u' _ \n(_|\n _|\n', 'k': u'| \n|<\n  \n', 'o': u' _ \n(_)\n   \n', 's': u' _\n_\\\n  \n', 'w': u'  \nVV\n  \n', '{': u' |~\n<  \n |_\n', '"': u"''\n  \n  \n", '&': u'() \n(_X\n   \n', '*': u". ,\n-X-\n' `\n", '.': u' \n.\n \n', '2': u"'~)\n /_\n   \n", '6': u' / \n(_)\n   \n', ':': u'.\n.\n \n', '>': u'\\ \n )\n/ \n', 'B': u'|~)\n|_)\n   \n', 'F': u'|~\n|~\n  \n', 'J': u'~|~\nL| \n   \n', 'N': u'|\\ |\n| \\|\n    \n', 'R': u'|~)\n|~\\\n   \n', 'V': u'\\  /\n \\/ \n    \n', 'Z': u'~/\n/_\n  \n', '^': u"'`\n  \n  \n", 'b': u'|_ \n|_)\n   \n', 'f': u' |`\n~|~\n   \n', 'j': u' .\n |\nL|\n', 'n': u' _ \n| |\n   \n', 'r': u' _\n| \n  \n', 'v': u'  \n\\/\n  \n', 'z': u'_ \n/_\n  \n', '~': u"'`'\n   \n   \n", '!': u'|\n.\n \n', '%': u"'/\n/,\n  \n", ')': u'\\ \n |\n/ \n', '-': u'__\n  \n  \n', '1': u"'| \n.|.\n   \n", '5': u'L~\n_)\n  \n', '9': u'(~)\n / \n   \n', '=': u'--\n--\n  \n', 'A': u' /\\ \n/~~\\\n    \n', 'E': u'(~\n(_\n  \n', 'I': u'~|~\n_|_\n   \n', 'M': u'|\\/|\n|  |\n    \n', 'Q': u'/~\\\n\\_X\n   \n', 'U': u'| |\n|_|\n   \n', 'Y': u'\\ /\n | \n   \n', ']': u'~|\n |\n_|\n', 'a': u' _ \n(_|\n   \n', 'e': u' _ \n(/_\n   \n', 'i': u'.\n|\n \n', 'm': u' _ _ \n| | |\n     \n', 'q': u' _  \n(_| \n  |/\n', 'u': u'   \n|_|\n   \n', 'y': u'  \n\\/\n/ \n', '}': u'~| \n  >\n_| \n'}

tombstone_dic = {'!': u' ,\n |\n |\n .\n  \n', ' ': u'  \n  \n  \n  \n  \n',
              '#': u'', '"': u" ,,\n ''\n   \n   \n   \n", '%': u'', '$': u'', "'": u" ,\n '\n  \n  \n  \n", '&': u'', ')': u' \\\n |\n |\n /\n  \n', '(': u' /\n |\n |\n \\\n  \n', '+': u'', '*': u'', '-': u'   \n   \n ~~\n   \n   \n', ',': u"  \n  \n ,\n '\n  \n", '/': u'   \n  /\n / \n   \n   \n', '.': u' \n \n,\n~\n \n', '1': u' ,\n |\n |\n ~\n  \n', '0': u' _ \n/ \\\n\\ /\n ~ \n   \n', '3': u'  _,\n ~_)\n   )\n ~~ \n    \n', '2': u'  _,\n ~ )\n  / \n ~~~\n    \n', '5': u'  _,\n |_ \n   )\n ~~ \n    \n', '4': u'   ,\n / |\n ~~|\n   ~\n    \n', '7': u' __,\n _/ \n /~ \n    \n    \n', '6': u'  _,\n /_ \n \\ )\n  ~ \n    \n', '9': u"  _,\n (_/\n  / \n  ' \n    \n", '8': u'  _,\n (_)\n ( )\n  ~ \n    \n', ';': u"  \n .\n ,\n '\n  \n", ':': u'  \n .\n .\n  \n  \n', '=': u'   \n ~~\n ~~\n   \n   \n', '<': u'  /\n / \n \\ \n  \\\n   \n', '?': u'  _ \n ( )\n  / \n  . \n    \n', '>': u' \\ \n  \\\n  /\n / \n   \n', '@': u"  _,\n /,)\n \\`'\n  ~~\n    \n", '[': u' .-\n | \n | \n `-\n   \n', ']': u" -.\n  |\n  |\n -'\n   \n", '\\': u'    \n  \\ \n   \\\n    \n    \n', '_': u'     \n     \n     \n ~~~~\n     \n', '^': u' /\\\n   \n   \n   \n   \n', 'a': u'  _,\n /_\\\n | |\n ~ ~\n    \n', '`': u'  .\n  `\n   \n   \n   \n', 'c': u'  _,\n / `\n \\ ,\n  ~ \n    \n', 'b': u' __,\n |_)\n |_)\n ~  \n    \n', 'e': u' __,\n |_ \n |  \n ~~~\n    \n', 'd': u' __,\n | \\\n |_/\n ~  \n    \n', 'g': u'  _,\n / _\n \\ /\n  ~ \n    \n', 'f': u' __,\n |_ \n |  \n ~  \n    \n', 'i': u' _\n |\n |\n ~\n  \n', 'h': u' _,_\n |_|\n | |\n ~ ~\n    \n', 'k': u' _,_\n |_/\n | \\\n ~ ~\n    \n', 'j': u'  __,\n , | \n ( | \n  ~~ \n     \n', 'm': u' _, _\n |\\/|\n |  |\n ~  ~\n     \n', 'l': u' _, \n |  \n | ,\n ~~~\n    \n', 'o': u'  _,\n / \\\n \\ /\n  ~ \n    \n', 'n': u' _, _\n |\\ |\n | \\|\n ~  ~\n     \n', 'q': u'  _,\n / \\\n \\\\/\n  ~`\n    \n', 'p': u' __,\n |_)\n |  \n ~  \n    \n', 's': u'  _,\n (_ \n , )\n  ~ \n    \n', 'r': u' __,\n |_)\n | \\\n ~ ~\n    \n', 'u': u" _,_\n | |\n | |\n `~'\n    \n", 't': u' ___\n  | \n  | \n  ~ \n    \n', 'w': u' _  _\n |  |\n |/\\|\n ~  ~\n     \n', 'v': u' _,_\n | /\n |/ \n ~  \n    \n', 'y': u" , _\n \\ |\n  \\|\n   )\n  ~'\n", 'x': u" _  ,\n '\\/ \n  /\\ \n ~  ~\n     \n", '{': u'', 'z': u' ___,\n ` / \n  /  \n ~~~ \n     \n', '}': u'', '|': u' .\n |\n |\n |\n  \n', '~': u''}

trek_dic = {'!': u'      dBP\n     dBP \n    dBP  \n   dBP   \n         \n '
                u'dBP     \n', ' ': u'        \n        \n        \n        \n        \n        \n', '#': u'      d88P  \n  d88888888P\n d8B88888BP \n   d88P     \n            \n     _      \n', '"': u'       \n  dP dP\n dP dP \n       \n       \n       \n', '%': u' dP  dP\n    dP \n   dP  \n  dP   \n dP  dP\n       \n', '$': u' .===.\n : |  \n `===.\n   | :\n `===\'\n   "  \n', "'": u'    \n dBP\n BP \n    \n    \n    \n', '&': u"  .BBb'  \n  B..    \n  >BP    \n .B      \n..`BB'   \n         \n", ')': u"      dBB.\n       dBP\n      dBP \n     dBP  \n    dBP   \n `BBB'    \n", '(': u'     .BBb.\n    dBP   \n   dBP    \n  dBP     \n dBP      \n `BBb     \n', '+': u'        \n        \n    dBP \n dBBBBBP\n  dBP   \n        \n', '*': u"     .. \n   .::dP\n   dBBP:\n   :dBBb\n   dP::'\n        \n", '-': u'        \n        \n        \n dBBBBBP\n        \n        \n', ',': u'     \n     \n     \n     \n  dBP\n  BP \n', '/': u'        __\n      _dBP\n    _dBP  \n  _dBP    \n dBP      \n          \n', '.': u'    \n    \n    \n    \n dBP\n    \n', '1': u'  dBBBb \n        \n   dBP  \n  dBP   \n dBP    \n        \n', '0': u"     dBBBBP\n    dB'.BP \n   dB:.BP  \n  dB'.BP   \n dBBBBP    \n           \n", '3': u'   dBBBBb\n         \n    dBBBP\n     dBP \n dBBBBP  \n         \n', '2': u'  dBBBBb\n        \n   dBBP \n  dBP__ \n dBBBBP \n        \n', '5': u'     dBBBBBP\n            \n   dBBBBBP  \n      dBP   \n dBBBBBP    \n            \n', '4': u'   dBP dBP\n      dBP \n dBBBBBP  \n    dBP   \n   dBP    \n          \n', '7': u' dBBBBb \n        \n   dBP  \n  dBP   \n dBP    \n        \n', '6': u'    dBBBBP\n   dP     \n  dP dBP  \n dP  dP   \n VBBBP    \n          \n', '9': u'    dBBBBb\n   dP  dBP\n   VBBBBP \n      dP  \n  dBBBP   \n          \n', '8': u'     dBBBb\n    dP  dP\n   dPBBBP \n  dP  dP  \n  VBBBP   \n          \n', ';': u'      \n      \n   dBP\n      \n  dBP \n dBP  \n', ':': u'      \n      \n   dBP\n      \n dBP  \n      \n', '=': u'        \n   dBBBP\n        \n dBBBP  \n        \n        \n', '<': u'     \n  dP \n dP  \n Vb  \n  Vb \n     \n', '?': u' dBBBBb\n Vb dBP\n   dBP \n       \n dBP   \n       \n', '>': u'     \n Vb  \n `Bb \n  dP \n dP  \n     \n', '@': u'           \n   dBBBBBBb\n  dBP _  dB\n dBP  " dB\'\n VBBBBBBB\' \n           \n', '[': u'      dBBb  \n     dBP    \n    dBP     \n   dBP      \n  dBP       \n dBBBP      \n', ']': u'      dBBP \n      dBP  \n     dBP   \n    dBP    \n   dBP     \n VBBP      \n', '\\': u'       \n`Bb    \n `Bb   \n  `Bb  \n   `Bb \n       \n', '_': u'        \n        \n        \n        \n        \n dBBBBBP\n', '^': u'  dBb \n dP`Bb\n      \n      \n      \n      \n', 'a': u'  dBBBBBb\n       BB\n   dBP BB\n  dBP  BB\n dBBBBBBB\n         \n', '`': u"    \n dBb\n `BP\n  ' \n    \n    \n", 'c': u'     dBBBP\n          \n   dBP    \n  dBP     \n dBBBBP   \n          \n', 'b': u"    dBBBBb\n       dBP\n   dBBBK' \n  dB' db  \n dBBBBP'  \n          \n", 'e': u'     dBBBP \n           \n   dBBP    \n  dBP      \n dBBBBP    \n           \n', 'd': u'     dBBBBb\n        dBP\n   dBP dBP \n  dBP dBP  \n dBBBBBP   \n           \n', 'g': u"     dBBBBb\n           \n   dBBBB   \n  dB' BB   \n dBBBBBB   \n           \n", 'f': u'     dBBBBP\n           \n   dBBBP   \n  dBP      \n dBP       \n           \n', 'i': u'     dBP\n        \n   dBP  \n  dBP   \n dBP    \n        \n', 'h': u'     dBP dBP\n            \n   dBBBBBP  \n  dBP dBP   \n dBP dBP    \n            \n', 'k': u'     dBP dBP\n    d8P.dBP \n   dBBBBP   \n  dBP BB    \n dBP dBP    \n            \n', 'j': u"        dBP\n           \n      dBP  \n  dB'dBP   \n dBBBBP    \n           \n", 'm': u'     dBBBBBBb\n          dBP\n   dBPdBPdBP \n  dBPdBPdBP  \n dBPdBPdBP   \n             \n', 'l': u'     dBP\n        \n   dBP  \n  dBP   \n dBBBBP \n        \n', 'o': u'     dBBBBP\n    dBP.BP \n   dBP.BP  \n  dBP.BP   \n dBBBBP    \n           \n', 'n': u'     dBBBBb\n        dBP\n   dBP dBP \n  dBP dBP  \n dBP dBP   \n           \n', 'q': u"     dBBBBP\n    dBP.BP \n   dBP.BP  \n  dBP.BB   \n dBBBB'B   \n           \n", 'p': u"   dBBBBBb\n       dB'\n   dBBBP' \n  dBP     \n dBP      \n          \n", 's': u"  .dBBBBP\n  BP     \n  `BBBBb \n     dBP \ndBBBBP'  \n         \n", 'r': u"   dBBBBBb\n       dBP\n   dBBBBK \n  dBP  BB \n dBP  dB' \n          \n", 'u': u'     dBP dBP\n            \n   dBP dBP  \n  dBP_dBP   \n dBBBBBP    \n            \n', 't': u'  dBBBBBBP\n          \n   dBP    \n  dBP     \n dBP      \n          \n', 'w': u'     dBPdBPdBP\n              \n   dBPdBPdBP  \n  dBPdBPdBP   \n dBBBBBBBP    \n              \n', 'v': u'   dBP dP\n         \n dB .BP  \n BB.BP   \n BBBP    \n         \n', 'y': u' dBP dBP\n    dBP \n   dBP  \n  dBP   \n dBP    \n        \n', 'x': u"`Bb  .BP\n    .BP \n  dBBK  \n dB'    \ndB' dBP \n        \n", '{': u'', 'z': u' dBBBBBP\n        \n   dBP  \n  dBP   \n dBBBBP \n        \n', '}': u'', '|': u'', '~': u''}

twopoint_dic = {' ': u'  \n  \n', '$': u'(|~\n_|)\n', '(': u'/~\n\\_\n', ','
                                                                      '': u' \n)\n', '0': u'/\\\n\\/\n', '4': u'/| \n~|~\n', '8': u'(~)\n(_)\n', '<': u'/\n\\\n', '@': u' _ \n(a)\n', 'D': u'|~\\\n|_/\n', 'H': u'|_|\n| |\n', 'L': u'| \n|_\n', 'P': u'|~)\n|~ \n', 'T': u'~|~\n | \n', 'X': u'\\/\n/\\\n', '\\': u'\\ \n \\\n', '`': u'(\n \n', 'd': u' _|\n(_|\n', 'h': u'|_ \n| |\n', 'l': u'|\n|\n', 'p': u'|)\n| \n', 't': u'_|_\n | \n', 'x': u'  \n><\n', '|': u'|\n|\n', '#': u'++\n++\n', "'": u')\n \n', '+': u' | \n~|~\n', '/': u' /\n/ \n', '3': u'~/\n_)\n', '7': u'~/\n/ \n', ';': u'o\n)\n', '?': u'~)\no \n', 'C': u'|~\n|_\n', 'G': u'|~_\n|_|\n', 'K': u'|/\n|\\\n', 'O': u'/~\\\n\\_/\n', 'S': u'(~\n_)\n', 'W': u'|    |\n \\/\\/ \n', '[': u'|~\n|_\n', '_': u'  \n__\n', 'c': u' _\n(_\n', 'g': u'(~|\n _|\n', 'k': u'| \n|<\n', 'o': u' _ \n(_)\n', 's': u' _\n_\\\n', 'w': u'    \n\\/\\/\n', '{': u' |~\n~|_\n', '"': u"''\n  \n", '&': u' o \n(_X\n', '*': u'\\|/\n/|\\\n', '.': u' \no\n', '2': u'~)\n/_\n', '6': u' / \n(_)\n', ':': u'o\no\n', '>': u'\\\n/\n', 'B': u'|~)\n|_)\n', 'F': u'|~\n|~\n', 'J': u' |\n_|\n', 'N': u'|\\ |\n| \\|\n', 'R': u'|~)\n|~\\\n', 'V': u'\\  /\n \\/ \n', 'Z': u'~/\n/_\n', '^': u'/\\\n  \n', 'b': u'|_ \n|_)\n', 'f': u' |~\n~|~\n', 'j': u' o\n_|\n', 'n': u'._ \n| |\n', 'r': u'._\n| \n', 'v': u'  \n\\/\n', 'z': u'_ \n/_\n', '~': u'/\\/\n   \n', '!': u'|\no\n', '%': u'o/\n/o\n', ')': u'~\\\n_/\n', '-': u'  \n~~\n', '1': u"'|\n |\n", '5': u'|~\n_)\n', '9': u'(~|\n / \n', '=': u'--\n--\n', 'A': u'|~|\n|~|\n', 'E': u'[~\n[_\n', 'I': u'|\n|\n', 'M': u'|\\/|\n|  |\n', 'Q': u'/~\\\n\\_X\n', 'U': u'| |\n|_|\n', 'Y': u'\\/\n/ \n', ']': u'~|\n_|\n', 'a': u' _ \n(_|\n', 'e': u' _\n}_\n', 'i': u'o\n|\n', 'm': u'._ _ \n| | |\n', 'q': u'(|\n |\n', 'u': u'   \n|_|\n', 'y': u'|_|\n _|\n', '}': u'~| \n_|~\n'}

univers_dic = {' ': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n', '$': u'    8 8      \n ad88888ba   \nd8" 8 8 "8b  \nY8, 8 8      \n`Y8a8a8a,    \n  `"8"8"8b,  \n    8 8 `8b  \nY8a 8 8 a8P  \n "Y88888P"   \n    8 8      \n             \n', '(': u'   a8  \n  d8\'  \n d8\'   \nd8\'    \n88     \n88     \nY8,    \n Y8,   \n  Y8,  \n   "8  \n       \n', ',': u'      \n      \n      \n      \n      \n      \n aaa  \n "88  \n d8\'  \n8"    \n      \n', '0': u'                \n   ,a8888a,     \n ,8P"\'  `"Y8,   \n,8P        Y8,  \n88          88  \n88          88  \n`8b        d8\'  \n `8ba,  ,ad8\'   \n   "Y8888P"     \n                \n                \n', '4': u'               \n        ,d8    \n      ,d888    \n    ,d8" 88    \n  ,d8"   88    \n,d8"     88    \n8888888888888  \n         88    \n         88    \n               \n               \n', '8': u'             \n ad88888ba   \nd8"     "8b  \nY8a     a8P  \n "Y8aaa8P"   \n ,d8"""8b,   \nd8"     "8b  \nY8a     a8P  \n "Y88888P"   \n             \n             \n', '<': u'           \n      a8"  \n    a8"    \n  a8"      \na8"        \n"8a        \n  "8a      \n    "8a    \n      "8a  \n           \n           \n', '@': u'                  \n  ,ad88PPP88ba,   \n d8"  .ama.a "8a  \nd8\'  ,8P"88"  88  \n88  .8P  8P   88  \n88  88   8\'   8P  \n88  8B ,d8 ,ad8\'  \n"8a "88P"888P"    \n `Y8aaaaaaaad8P   \n    """""""""     \n                  \n', 'D': u'               \n88888888ba,    \n88      `"8b   \n88        `8b  \n88         88  \n88         88  \n88         8P  \n88      .a8P   \n88888888Y"\'    \n               \n               \n', 'H': u'              \n88        88  \n88        88  \n88        88  \n88aaaaaaaa88  \n88""""""""88  \n88        88  \n88        88  \n88        88  \n              \n              \n', 'L': u'             \n88           \n88           \n88           \n88           \n88           \n88           \n88           \n88888888888  \n             \n             \n', 'P': u'             \n88888888ba   \n88      "8b  \n88      ,8P  \n88aaaaaa8P\'  \n88""""""\'    \n88           \n88           \n88           \n             \n             \n', 'T': u'              \n888888888888  \n     88       \n     88       \n     88       \n     88       \n     88       \n     88       \n     88       \n              \n              \n', 'X': u"              \n8b        d8  \n Y8,    ,8P   \n  `8b  d8'    \n    Y88P      \n    d88b      \n  ,8P  Y8,    \n d8'    `8b   \n8P        Y8  \n              \n              \n", '\\': u'              \n8b            \n`Y8,          \n  "8b         \n   `P8,       \n     "8b      \n      `Y8,    \n        "8b   \n         `Y8  \n              \n              \n', '`': u'       \n`8b    \n `8b   \n   ""  \n       \n       \n       \n       \n       \n       \n       \n', 'd': u'             \n         88  \n         88  \n         88  \n ,adPPYb,88  \na8"    `Y88  \n8b       88  \n"8a,   ,d88  \n `"8bbdP"Y8  \n             \n             \n', 'h': u'             \n88           \n88           \n88           \n88,dPPYba,   \n88P\'    "8a  \n88       88  \n88       88  \n88       88  \n             \n             \n', 'l': u'    \n88  \n88  \n88  \n88  \n88  \n88  \n88  \n88  \n    \n    \n', 'p': u'             \n             \n             \n             \n8b,dPPYba,   \n88P\'    "8a  \n88       d8  \n88b,   ,a8"  \n88`YbbdP"\'   \n88           \n88           \n', 't': u'         \n         \n  ,d     \n  88     \nMM88MMM  \n  88     \n  88     \n  88,    \n  "Y888  \n         \n         \n', 'x': u'             \n             \n             \n             \n8b,     ,d8  \n `Y8, ,8P\'   \n   )888(     \n ,d8" "8b,   \n8P\'     `Y8  \n             \n             \n', '|': u'    \n88  \n88  \n88  \n88  \n    \n88  \n88  \n88  \n88  \n    \n', '#': u'             \n  88   88    \n  88   88    \naa88aaa88aa  \n""88"""88""  \naa88aaa88aa  \n""88"""88""  \n  88   88    \n  88   88    \n             \n             \n', "'": u'       \n  d8\'  \n d8\'   \n""     \n       \n       \n       \n       \n       \n       \n       \n', '+': u'            \n            \n    aa      \n    88      \naaaa88aaaa  \n""""88""""  \n    88      \n    ""      \n            \n            \n            \n', '/': u'              \n          d8  \n        ,8P\'  \n       d8"    \n     ,8P\'     \n    d8"       \n  ,8P\'        \n d8"          \n8P\'           \n              \n              \n', '3': u'             \n ad888888b,  \nd8"     "88  \n        a8P  \n     aad8"   \n     ""Y8,   \n        "8b  \nY8,     a88  \n "Y888888P\'  \n             \n             \n', '7': u'              \n888888888888  \n        ,8P\'  \n       d8"    \n     ,8P\'     \n    d8"       \n  ,8P\'        \n d8"          \n8P\'           \n              \n              \n', ';': u'      \n      \n      \n      \n 888  \n """  \n aaa  \n "88  \n d8\'  \n8"    \n      \n', '?': u'             \n ad88888ba   \nd8"     "8b  \n""      a8P  \n     ,a8P"   \n    d8"      \n    ""       \n    aa       \n    88       \n             \n             \n', 'C': u'               \n  ,ad8888ba,   \n d8"\'    `"8b  \nd8\'            \n88             \n88             \nY8,            \n Y8a.    .a8P  \n  `"Y8888Y"\'   \n               \n               \n', 'G': u'               \n  ,ad8888ba,   \n d8"\'    `"8b  \nd8\'            \n88             \n88      88888  \nY8,        88  \n Y8a.    .a88  \n  `"Y88888P"   \n               \n               \n', 'K': u'              \n88      a8P   \n88    ,88\'    \n88  ,88"      \n88,d88\'       \n8888"88,      \n88P   Y8b     \n88     "88,   \n88       Y8b  \n              \n              \n', 'O': u'                \n  ,ad8888ba,    \n d8"\'    `"8b   \nd8\'        `8b  \n88          88  \n88          88  \nY8,        ,8P  \n Y8a.    .a8P   \n  `"Y8888Y"\'    \n                \n                \n', 'S': u'             \n ad88888ba   \nd8"     "8b  \nY8,          \n`Y8aaaaa,    \n  `"""""8b,  \n        `8b  \nY8a     a8P  \n "Y88888P"   \n             \n             \n', 'W': u'                         \nI8,        8        ,8I  \n`8b       d8b       d8\'  \n "8,     ,8"8,     ,8"   \n  Y8     8P Y8     8P    \n  `8b   d8\' `8b   d8\'    \n   `8a a8\'   `8a a8\'     \n    `8a8\'     `8a8\'      \n     `8\'       `8\'       \n                         \n                         \n', '[': u'88888  \n88     \n88     \n88     \n88     \n88     \n88     \n88     \n88     \n88888  \n       \n', '_': u'              \n              \n              \n              \n              \n              \n              \n              \n              \n              \n888888888888  \n', 'c': u'            \n            \n            \n            \n ,adPPYba,  \na8"     ""  \n8b          \n"8a,   ,aa  \n `"Ybbd8"\'  \n            \n            \n', 'g': u'             \n             \n             \n             \n ,adPPYb,d8  \na8"    `Y88  \n8b       88  \n"8a,   ,d88  \n `"YbbdP"Y8  \n aa,    ,88  \n  "Y8bbdP"   \n', 'k': u'           \n88         \n88         \n88         \n88   ,d8   \n88 ,a8"    \n8888[      \n88`"Yba,   \n88   `Y8a  \n           \n           \n', 'o': u'             \n             \n             \n             \n ,adPPYba,   \na8"     "8a  \n8b       d8  \n"8a,   ,a8"  \n `"YbbdP"\'   \n             \n             \n', 's': u'           \n           \n           \n           \n,adPPYba,  \nI8[    ""  \n `"Y8ba,   \naa    ]8I  \n`"YbbdP"\'  \n           \n           \n', 'w': u"                    \n                    \n                    \n                    \n8b      db      d8  \n`8b    d88b    d8'  \n `8b  d8'`8b  d8'   \n  `8bd8'  `8bd8'    \n    YP      YP      \n                    \n                    \n", '{': u'  ad888  \n  88\'    \n  88     \n  88     \n ,8P     \n88(      \n "8b     \n  88     \n  88     \n  88,    \n  "Y888  \n', '"': u'       \n88 88  \n88 88  \n"" ""  \n       \n       \n       \n       \n       \n       \n       \n', '&': u'              \n   ,adba,     \n   8I  I8     \n   "8bdP\'     \n  ,d8"8b  88  \n.dP\'   Yb,8I  \n8P      888\'  \n8b,   ,dP8b   \n`Y8888P"  Yb  \n              \n              \n', '*': u'              \n              \n I8a    a8I   \n  "Yb,,dP"    \naaaa8888aaaa  \n""""8888""""  \n  ,dP\'`Yb,    \n I8"    "8I   \n              \n              \n              \n', '.': u'     \n     \n     \n     \n     \n     \n     \n888  \n888  \n     \n     \n', '2': u'             \n ad888888b,  \nd8"     "88  \n        a8P  \n     ,d8P"   \n   a8P"      \n a8P\'        \nd8"          \n88888888888  \n             \n             \n', '6': u'             \n  ad8888ba,  \n 8P\'    "Y8  \nd8           \n88,dd888bb,  \n88P\'    `8b  \n88       d8  \n88a     a8P  \n "Y88888P"   \n             \n             \n', ':': u'     \n     \n     \n     \n888  \n888  \n     \n888  \n888  \n     \n     \n', '>': u'           \n"8a        \n  "8a      \n    "8a    \n      "8a  \n      a8"  \n    a8"    \n  a8"      \na8"        \n           \n           \n', 'B': u'             \n88888888ba   \n88      "8b  \n88      ,8P  \n88aaaaaa8P\'  \n88""""""8b,  \n88      `8b  \n88      a8P  \n88888888P"   \n             \n             \n', 'F': u'             \n88888888888  \n88           \n88           \n88aaaaa      \n88"""""      \n88           \n88           \n88           \n             \n             \n', 'J': u'            \n        88  \n        88  \n        88  \n        88  \n        88  \n        88  \n88,   ,d88  \n "Y8888P"   \n            \n            \n', 'N': u'              \n888b      88  \n8888b     88  \n88 `8b    88  \n88  `8b   88  \n88   `8b  88  \n88    `8b 88  \n88     `8888  \n88      `888  \n              \n              \n', 'R': u'             \n88888888ba   \n88      "8b  \n88      ,8P  \n88aaaaaa8P\'  \n88""""88\'    \n88    `8b    \n88     `8b   \n88      `8b  \n             \n             \n', 'V': u"                 \n8b           d8  \n`8b         d8'  \n `8b       d8'   \n  `8b     d8'    \n   `8b   d8'     \n    `8b d8'      \n     `888'       \n      `8'        \n                 \n                 \n", 'Z': u'              \n888888888888  \n         ,88  \n       ,88"   \n     ,88"     \n   ,88"       \n ,88"         \n88"           \n888888888888  \n              \n              \n', '^': u'     a       \n   ,888,     \n ,d8P"Y8b,   \nI8"     "8I  \n             \n             \n             \n             \n             \n             \n             \n', 'b': u'             \n88           \n88           \n88           \n88,dPPYba,   \n88P\'    "8a  \n88       d8  \n88b,   ,a8"  \n8Y"Ybbd8"\'   \n             \n             \n', 'f': u'         \n   ad88  \n  d8"    \n  88     \nMM88MMM  \n  88     \n  88     \n  88     \n  88     \n         \n         \n', 'j': u'       \n   88  \n   ""  \n       \n   88  \n   88  \n   88  \n   88  \n   88  \n  ,88  \n888P"  \n', 'n': u'             \n             \n             \n             \n8b,dPPYba,   \n88P\'   `"8a  \n88       88  \n88       88  \n88       88  \n             \n             \n', 'r': u'            \n            \n            \n            \n8b,dPPYba,  \n88P\'   "Y8  \n88          \n88          \n88          \n            \n            \n', 'v': u'             \n             \n             \n             \n8b       d8  \n`8b     d8\'  \n `8b   d8\'   \n  `8b,d8\'    \n    "8"      \n             \n             \n', 'z': u'           \n           \n           \n           \n888888888  \n     a8P"  \n  ,d8P\'    \n,d8"       \n888888888  \n           \n           \n', '~': u'               \n               \n               \n               \n ad8bba,  ,aa  \n""    ""Y8P"   \n               \n               \n               \n               \n               \n', '!': u'    \n88  \n88  \n88  \n88  \n88  \n""  \naa  \n88  \n    \n    \n', '%': u'                 \n,adba,      ,d8  \n8I  I8    ,d8"   \n"fbdP\'  ,d8"     \n      ,d8"       \n    ,d8"         \n  ,d8"   ,adba,  \n,d8"     8I  I8  \n8"       "fbdP\'  \n                 \n                 \n', ')': u'8a     \n`8b    \n `8b   \n  `8b  \n   88  \n   88  \n  ,8P  \n ,8P   \n,8P    \n8"     \n       \n', '-': u'          \n          \n          \n          \n          \naaaaaaaa  \n""""""""  \n          \n          \n          \n          \n', '1': u'        \n    88  \n  ,d88  \n888888  \n    88  \n    88  \n    88  \n    88  \n    88  \n        \n        \n', '5': u'             \n8888888888   \n88           \n88  ____     \n88a8PPPP8b,  \nPP"     `8b  \n         d8  \nY8a     a8P  \n "Y88888P"   \n             \n             \n', '9': u'             \n ad88888ba   \nd8"     "88  \n8P       88  \nY8,    ,d88  \n "PPPPPP"88  \n         8P  \n8b,    a8P   \n`"Y8888P\'    \n             \n             \n', '=': u'            \n            \n            \n8888888888  \n            \n8888888888  \n            \n            \n            \n            \n            \n', 'A': u'                  \n       db         \n      d88b        \n     d8\'`8b       \n    d8\'  `8b      \n   d8YaaaaY8b     \n  d8""""""""8b    \n d8\'        `8b   \nd8\'          `8b  \n                  \n                  \n', 'E': u'             \n88888888888  \n88           \n88           \n88aaaaa      \n88"""""      \n88           \n88           \n88888888888  \n             \n             \n', 'I': u'    \n88  \n88  \n88  \n88  \n88  \n88  \n88  \n88  \n    \n    \n', 'M': u"                   \n88b           d88  \n888b         d888  \n88`8b       d8'88  \n88 `8b     d8' 88  \n88  `8b   d8'  88  \n88   `8b d8'   88  \n88    `888'    88  \n88     `8'     88  \n                   \n                   \n", 'Q': u'                \n  ,ad8888ba,    \n d8"\'    `"8b   \nd8\'        `8b  \n88          88  \n88          88  \nY8,    "88,,8P  \n Y8a.    Y88P   \n  `"Y8888Y"Y8a  \n                \n                \n', 'U': u'              \n88        88  \n88        88  \n88        88  \n88        88  \n88        88  \n88        88  \nY8a.    .a8P  \n `"Y8888Y"\'   \n              \n              \n', 'Y': u'              \n8b        d8  \n Y8,    ,8P   \n  Y8,  ,8P    \n   "8aa8"     \n    `88\'      \n     88       \n     88       \n     88       \n              \n              \n', ']': u'88888  \n   88  \n   88  \n   88  \n   88  \n   88  \n   88  \n   88  \n   88  \n88888  \n       \n', 'a': u'            \n            \n            \n            \n,adPPYYba,  \n""     `Y8  \n,adPPPPP88  \n88,    ,88  \n`"8bbdP"Y8  \n            \n            \n', 'e': u'            \n            \n            \n            \n ,adPPYba,  \na8P_____88  \n8PP"""""""  \n"8b,   ,aa  \n `"Ybbd8"\'  \n            \n            \n', 'i': u'    \n88  \n""  \n    \n88  \n88  \n88  \n88  \n88  \n    \n    \n', 'm': u'                    \n                    \n                    \n                    \n88,dPYba,,adPYba,   \n88P\'   "88"    "8a  \n88      88      88  \n88      88      88  \n88      88      88  \n                    \n                    \n', 'q': u'             \n             \n             \n             \n ,adPPYb,d8  \na8"    `Y88  \n8b       88  \n"8a    ,d88  \n `"YbbdP\'88  \n         88  \n         88  \n', 'u': u'             \n             \n             \n             \n88       88  \n88       88  \n88       88  \n"8a,   ,a88  \n `"YbbdP\'Y8  \n             \n             \n', 'y': u"             \n             \n             \n             \n8b       d8  \n`8b     d8'  \n `8b   d8'   \n  `8b,d8'    \n    Y88'     \n    d8'      \n   d8'       \n", '}': u'888ba    \n  `88    \n   88    \n   88    \n   Y8,   \n    )88  \n   d8"   \n   88    \n   88    \n  ,88    \n888P"    \n'}

weird_dic = {' ': u'     \n     \n     \n     \n     \n     \n', '$': u'  ,'
                                                                   u'_ \n /| |\n(_|_ \n  | )\n|_|/ \n  `  \n', '(': u'  \n /\n| \n| \n| \n \\\n', ',': u'    \n    \n    \n    \n    \n/   \n', '0': u'  __ \n /  |\n(   |\n|   )\n|__/ \n     \n', '4': u'     \n /  |\n(___|\n    )\n   / \n     \n', '8': u'  __ \n /  |\n(___|\n|   )\n|__/ \n     \n', '<': u'  \n /\n/ \n\\ \n \\\n  \n', '@': u'  __ \n /  |\n( O_/\n|    \n|__/ \n     \n', 'D': u'  __ \n|/  |\n|   |\n|   )\n|__/ \n     \n', 'H': u'     \n /  |\n(___|\n|   )\n|  / \n     \n', 'L': u'     \n /   \n(    \n|   )\n|__/ \n     \n', 'P': u'  __ \n /  |\n(___|\n|    \n|    \n     \n', 'T': u'  __\n /| \n( | \n  | \n  | \n    \n', 'X': u'     \n / / \n(_/_ \n /  )\n/  / \n     \n', '\\': u'    \n\\   \n \\  \n  \\ \n   \\\n    \n', '`': u'   \n \\ \n   \n   \n   \n   \n', 'd': u'     \n    |\n ___|\n|   )\n|__/ \n     \n', 'h': u'     \n /   \n(___ \n|   )\n|  / \n     \n', 'l': u'  \n /\n( \n| \n| \n  \n', 'p': u'     \n     \n ___ \n|   )\n|__/ \n|    \n', 't': u'     \n /   \n(___ \n|    \n|__  \n     \n', 'x': u'     \n     \n     \n(_/_ \n / / \n     \n', '|': u'  \n| \n( \n| \n| \n  \n', '#': u'     \n . . \n-+-+-\n-+-+-\n ` ` \n     \n', "'": u'   \n / \n   \n   \n   \n   \n', '+': u'    \n    \n |  \n-+- \n |  \n    \n', '/': u'    \n   /\n  / \n /  \n/   \n    \n', '3': u'  __ \n    |\n ___|\n    )\n __/ \n     \n', '7': u'  __ \n /  |\n(   |\n    )\n   / \n     \n', ';': u'    \n    \n _  \n    \n /  \n    \n', '?': u'  __ \n /  |\n(  _|\n  /  \n _   \n     \n', 'C': u'  __ \n /   \n(    \n|   )\n|__/ \n     \n', 'G': u'  __ \n /   \n( __ \n|   )\n|__/ \n     \n', 'K': u'     \n /  |\n(___|\n|\\   \n| \\  \n     \n', 'O': u'  __ \n /  |\n(   |\n|   )\n|__/ \n     \n', 'S': u'  __ \n /   \n(___ \n    )\n __/ \n     \n', 'W': u'     \n /  |\n(   |\n| / )\n|/|/ \n     \n', '[': u' _\n| \n| \n: \n| \n`-\n', '_': u'     \n     \n     \n     \n     \n --- \n', 'c': u'     \n     \n ___ \n|    \n|__  \n     \n', 'g': u'     \n     \n ___ \n|   )\n|__/ \n__/  \n', 'k': u'     \n /   \n(    \n|___)\n| \\  \n     \n', 'o': u'     \n     \n ___ \n|   )\n|__/ \n     \n', 's': u'     \n     \n ___ \n|___ \n __/ \n     \n', 'w': u'     \n     \n     \n|   )\n|/\\/ \n     \n', '{': u'  _\n | \n_| \n : \n | \n `-\n', '"': u'    \n // \n    \n    \n    \n    \n', '&': u'  _  \n / | \n(__/ \n / \\)\n|__/\\\n     \n', '*': u"   \n   \n.|.\n-*-\n'|`\n   \n", '.': u'    \n    \n    \n    \n    \n-   \n', '2': u'  __ \n /  )\n(  / \n  / )\n /_/ \n     \n', '6': u'  __ \n /   \n(___ \n|   )\n|__/ \n     \n', ':': u'    \n    \n _  \n    \n -  \n    \n', '>': u'  \n\\ \n \\\n /\n/ \n  \n', 'B': u'  __ \n|/  |\n|___|\n|   )\n|__/ \n     \n', 'F': u'  ___\n /   \n(___ \n|    \n|    \n     \n', 'J': u'   \n  |\n  |\n  )\n_/ \n   \n', 'N': u'     \n /| |\n( | |\n| | )\n| |/ \n     \n', 'R': u'  __ \n /  |\n(___|\n|\\   \n| \\  \n     \n', 'V': u'     \n /  |\n(   |\n \\  )\n  \\/ \n     \n', 'Z': u'  __ \n / / \n( /  \n /  )\n/__/ \n     \n', '^': u' _ \n/ \\\n   \n   \n   \n   \n', 'b': u'     \n /   \n(___ \n|   )\n|__/ \n     \n', 'f': u'  __ \n /   \n(    \n|___ \n|    \n     \n', 'j': u'     \n    |\n     \n    )\n   / \n__/  \n', 'n': u'     \n     \n ___ \n|   )\n|  / \n     \n', 'r': u'     \n     \n ___ \n|   )\n|    \n     \n', 'v': u'     \n     \n     \n \\  )\n  \\/ \n     \n', 'z': u'     \n     \n ___ \n __/ \n/__  \n     \n', '~': u' _   \n/ \\_/\n     \n     \n     \n     \n', '!': u'     \n  /  \n (   \n |   \n _   \n     \n', '%': u'    \no  /\n  / \n /  \n/  o\n    \n', ')': u'  \n\\ \n |\n |\n |\n/ \n', '-': u'     \n     \n ___ \n     \n     \n     \n', '1': u'  _  \n /|  \n( |  \n  | )\n _|/ \n     \n', '5': u'  __ \n /   \n|___ \n    )\n __/ \n     \n', '9': u'  __ \n /  |\n(___|\n    )\n __/ \n     \n', '=': u'    \n    \n___ \n___ \n    \n    \n', 'A': u'  __ \n /  |\n(___|\n|   )\n|  / \n     \n', 'E': u'  __ \n /   \n(___ \n|    \n|__  \n     \n', 'I': u'  \n /\n( \n| \n| \n  \n', 'M': u'     \n /|/|\n( / |\n|   )\n|  / \n     \n', 'Q': u'  __ \n /  |\n(   |\n|  \\)\n|__/\\\n     \n', 'U': u'     \n /  |\n(   |\n|   )\n|__/ \n     \n', 'Y': u'     \n /  |\n(___|\n    )\n __/ \n     \n', ']': u"_ \n |\n |\n :\n |\n-'\n", 'a': u'     \n     \n ___ \n|   )\n|__/|\n     \n', 'e': u'     \n     \n ___ \n|___)\n|__  \n     \n', 'i': u'  \n /\n  \n| \n| \n  \n', 'm': u'     \n     \n _ _ \n| | )\n|  / \n     \n', 'q': u'     \n     \n ___ \n|   )\n|__/|\n    |\n', 'u': u'     \n     \n     \n|   )\n|__/ \n     \n', 'y': u'     \n     \n     \n\\   )\n \\_/ \n  /  \n', '}': u"_  \n | \n |_\n : \n | \n-' \n"}


