"""
Patches :class:`~intents.model.entity.Sys.Language`

Sources:

* https://en.wikipedia.org/wiki/List_of_languages_by_number_of_native_speakers
* https://it.wikipedia.org/wiki/Lingue_per_numero_di_parlanti_madrelingua
* https://de.wikipedia.org/wiki/Liste_der_ISO-639-1-Codes

"""
from typing import List, Union

from intents import Entity, LanguageCode
from intents.language.entity_language import make_language_data

# TODO: only german is complete of all ISO language codes. Spanish and Chinese have fewer
# elements than others

class I_IntentsLanguage(Entity):
    __intents_internal__ = True
    __entity_language_data__ = {
        LanguageCode.ENGLISH: make_language_data([["Chinese", "Mandarin"], "Spanish", "English", "Hindi", "Arabic", "Portuguese", "Bengali", "Russian", "Japanese", "Punjabi", "German", "Javanese", ["Wu", "Shanghainese"], ["Malay", "Indonesian and Malaysian"], "Telugu", "Vietnamese", "Korean", "French", "Marathi", "Tamil", "Urdu", "Turkish", "Italian", ["Yue", "Cantonese"], "Thai", "Gujarati", "Jin", ["Southern Min", "Hokkien and Teochew"], "Persian", "Polish", "Pashto", "Kannada", "Xiang", "Malayalam", "Sundanese", "Hausa", ["Odia", "Oriya"], "Burmese", "Hakka", "Ukrainian", "Bhojpuri", ["Tagalog", "Filipino"], "Yoruba", "Maithili", "Uzbek", "Sindhi", "Amharic", "Fula", "Romanian", "Oromo", "Igbo", "Azerbaijani", "Awadhi", "Gan", ["Cebuano", "Visayan"], "Dutch", "Kurdish", "Serbo-Croatian", "Malagasy", "Saraiki", "Nepali", "Sinhala", "Chittagonian", "Zhuang", "Khmer", "Turkmen", "Assamese", "Madurese", "Somali", "Marwari", "Magahi", "Haryanvi", "Hungarian", "Chhattisgarhi", "Greek", "Chewa", "Deccan", "Akan", "Kazakh", "Northern Min", "Sylheti", "Zulu", "Czech", "Kinyarwanda", "Dhundhari", "Haitian Creole", ["Eastern Min", "Fuzhou dialect"], "Ilocano", "Quechua", "Kirundi", "Swedish", "Hmong", "Shona", "Uyghur", ["Hiligaynon", "Ilonggo", "Visayan"], "Mossi", "Xhosa", "Belarusian", "Balochi", "Konkani"]),
        LanguageCode.ITALIAN: make_language_data([["Cinese", "Mandarino", "cinese mandarino"], "Spagnolo", "Inglese", "Hindi", "Arabo", "Portoghese", ["Bengali", "Bengalese"], "Russo", ["Giapponese", "Nihongo"], ["Cantonese", "Yue"], "Marathi", ["Punjabi", "Punjabi occidentale", "lahnda"], "Telugu", "Turco", ["Coreano", "Hangugo"], "Wu", "Francese", "Tamil", "Tedesco", "Vietnamita", "Urdu", ["Giavanese", "Basa Jawa"], "Lingua araba egiziana", "Italiano", "Gujarati", ["Persiano", "Farsi"], "Bhojpuri", "Yoruba", "Hausa", "Min Nan", "Hakka", ["Indonesiano", "Bahasa Indonesia"], "Kannada", ["Pashto", "lingua pashtun"], "Polacco", "Amarico", ["Xiang", "Hunanese"], ["Malayalam", "Malayāḷaṁ", "Malay", "Malese"], "Oromo", "Maithili", ["Oriya", "Odia"], "Sondanese", "Birmano", "Sindhi", "Curdo", "Ucraino", "Igbo", "Uzbeco", "Rumeno", "Azero", ["Filippino", "Tagalog", "Filipino"], "Olandese", ["Fula", "Fulani"], "Gan", "Thailandese", "Malgascio", ["Serbo-croato", "serbo", "croato", "bosniaco", "montenegrino"], "Magahi", "Rajasthani standard", "Swahili", ["Khmer", "Cambogiano"], "Chhattisgarhi", "Somalo", "Cebuano", "Haryanvi", ["Nepalese", "Nepali"], "Singalese", "Assamese", ["Rangpuri", "Rajbashi"], "Zhuang", "Chittagonian", "Greco", "Kazako", "Deccan", "Ungherese", ["Kinyarwanda", "Orunyarwanda"], "Zulu", "Min Bei", "Shona", "Sylheti", "Ceco", "Uiguro", "Min Dong", ["Chichewa", "Nyanja"], "Kanauji", "Quechua", "Svedese", "Akan", "Bulgaro", ["Xhosa", "isiXhosa"], "Marwari", "Turkmeno", "Creolo haitiano", "Madurese", "Baluchi", "Ilocano", "Varhadi-nagpuri", "Gikuyu", "Konkani", "Armeno", "Danese", "Finlandese", "Ebraico", "Tataro", "Slovacco", "Catalano"]),
        LanguageCode.DUTCH: make_language_data([["Chinees", "Mandarijn"], "Spaans", "Engels", "Hindi", "Arabisch", "Bengaals", "Portugees", "Russisch", "Japans", ["Lahnda", "West-Punjabi"], "Marathi", "Telugu", "Wuyu", "Maleis", "Turks", "Koreaans", "Frans", "Duits", "Vietnamees", "Tamil", "Kantonees", "Urdu", "Javaans", "Italiaans", "Egyptisch-Arabisch", ["Perzisch", "Iraans Perzisch"], "Gujarati", "Bhojpuri", "Minnanyu", "Hakka", "Jinyu", "Hausa", "Kannada", "Indonesisch", "Pools", "Pasjtoe", "Yoruba", "Xiangyu", "Malayalam", "Odia", "Maithili", "Birmaans", "Oost-Punjabi", "Soendanees", "Soedanees Arabisch", "Fula", "Oezbeeks", "Algerijns-Arabisch", "Marokkaans-Arabisch", "Oekraïens", "Igbo", "Noord-Oezbeeks", "Sindhi", "Noord-Levantijns Arabisch", "Roemeens", "Tagalog", "Nederlands", "Azerbeidzjaans", "Saʽidi Arabisch", "Koerdisch", "Ganyu", "Amhaars", "Noord-Pasjtoe", "Magahi", "Thai", "Marwari", "Saraiki"]),
        LanguageCode.FRENCH: make_language_data([["Chinois", "Mandarin", "langues chinoises"], "Espagnol", "Anglais", "Arabe", "Bengali", "Hindi", "Portugais", "Russe", "Japonais", "Français", ["Lahnda", "Pendjabi"], "Javanais", "Allemand", "Vietnamien", "Télougou", "Coréen", "Turc", "Tamoul", "Marathi", "Ourdou", "Italien"]),
        LanguageCode.GERMAN: make_language_data(["Abchasisch", "Afar", "Afrikaans", "Akan", "Albanisch", "Amharisch", "Arabisch", "Aragonesisch", "Armenisch", "Assamesisch", "Avarisch", "Avestisch", "Aymara", "Aserbaidschanisch", "Bambara", "Baschkirisch", "Baskisch", "Weißrussisch", "Bengalisch", "Bihari", "Bislama", "Bosnisch", "Bretonisch", "Bulgarisch", "Birmanisch", ["Katalanisch", "Valencianisch"], "Chamorro", "Tschetschenisch", "Chichewa", "Chinesisch", "Tschuwaschisch", "Kornisch", "Korsisch", "Cree", "Kroatisch", "Tschechisch", "Dänisch", "Dhivehi", ["Niederländisch", "Belgisches Niederländisch"], "Dzongkha", "Englisch", "Esperanto", "Estnisch", "Ewe", "Färöisch", "Fidschi", "Finnisch", "Französisch", "Fulfulde", ["Galicisch", "Galegisch"], "Georgisch", "Deutsch", "Griechisch", "Guaraní", "Gujarati", "Haitianisch", "Hausa", "Hebräisch", "Otjiherero", "Hindi", "Hiri Motu", "Ungarisch", "Interlingua", "Indonesisch", "Interlingue", "Irisch", "Igbo", "Inupiaq", "Ido", "Isländisch", "Italienisch", "Inuktitut", "Japanisch", "Javanisch", ["Grönländisch", "Kalaallisut"], "Kannada", "Kanuri", "Kashmiri", "Kasachisch", "Khmer", "Kikuyu", ["Kinyarwanda", "Ruandisch"], "Kirgisisch", "Komi", "Kikongo", "Koreanisch", "Kurdisch", "oshiKwanyama", "Latein", "Luxemburgisch", "Luganda", ["Limburgisch", "Südniederfränkisch"], "Lingála", "Laotisch", "Litauisch", "Kiluba", "Lettisch", "Manx,", "Manx-Gälisch", "Mazedonisch", ["Malagasy", "Malagassi"], ["Malaiisch", "Malayalam"], "Maltesisch", "Maori", "Marathi", "Marshallesisch", "Mongolisch", "Nauruisch", "Navajo", "Nord-Ndebele", "Nepali", "Ndonga", "Bokmål", "Nynorsk", "Norwegisch", "Yi", "Süd-Ndebele", "Okzitanisch", "Ojibwe", ["Kirchenslawisch", "Altkirchenslawisch"], "Oromo", "Oriya", "Ossetisch", ["Panjabi", "Pandschabi"], "Pali", "Persisch", "Polnisch", "Paschtunisch", "Portugiesisch", "Quechua", ["Bündnerromanisch", "Romanisch"], "Kirundi", "Rumänisch", "Russisch", "Sanskrit", "Sardisch", "Sindhi", "Nordsamisch", "Samoanisch", "Sango", "Serbisch", "Schottisch-gälisch", "Shona", "Singhalesisch", "Slowakisch", "Slowenisch", "Somali", ["Sesotho", "Süd-Sotho"], ["Spanisch", "Kastilisch"], "Sundanesisch", "Swahili", "Siswati", "Schwedisch", "Tamil", "Telugu", "Tadschikisch", "Thai", "Tigrinya", "Tibetisch", "Turkmenisch", "Tagalog", "Setswana", "Tongaisch", "Türkisch", "Xitsonga", "Tatarisch", "Twi", ["Tahitianisch", "Tahitisch"], "Uigurisch", "Ukrainisch", "Urdu", "Usbekisch", "Tshivenda", "Vietnamesisch", "Volapük", "Wallonisch", "Walisisch", "Wolof", "Westfriesisch", "isiXhosa", "Jiddisch", "Yoruba", "Zhuang", "isiZulu"]),
        LanguageCode.SPANISH: make_language_data(["Inglés​", ["Chino", "Chino mandarín​"], "Hindi​", "Español​", "Francés​", "Árabe​", "Bengalí​", "Ruso​", "Portugués​", "Indonesio​", "Urdu​", "Alemán​", "Japonés​", "Suajili​", "Maratí​", "Telugú​", "Turco​", "Chino cantonés​", "Tamil​", "Panyabí occidental​", "Chino Wu​", "Coreano​", "Vietnamita​", "Hausa​", "Javanés​", "Árabe egipcio​", "Italiano​", "Guyarati​", "Tailandés​", "Amárico​", "Canarés​", "Persa iraní​", "Chino Mǐn Nán​"]),
        LanguageCode.CHINESE: make_language_data(["英语", "官話", "印地語", "西班牙语", "法语", "阿拉伯语", "孟加拉语", "俄语", "葡萄牙語", "印尼语", "乌尔都语", "德语", "日语", "斯瓦希里语", "马拉地语", "泰卢固语", "土耳其语", "粤语", "泰米尔语", "旁遮普語", "吴语", "朝鮮語", "越南语", "豪萨语", "爪哇語", "埃及阿拉伯語", "意大利语", "泰语", "古吉拉特语", "康納達語", "波斯语", "博杰普爾語", "閩南語", "菲律賓語"]),
    }
