/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import junit.framework.Assert;
import no.priv.garshol.duke.comparators.Levenshtein;
import org.junit.Before;
import org.junit.Test;

public class LevenshteinTest {
    private Levenshtein comp;

    @Before
    public void setup() {
        this.comp = new Levenshtein();
    }

    @Test
    public void testComparatorEqual() {
        Assert.assertEquals((Object)1.0, (Object)this.comp.compare("foo", "foo"));
    }

    @Test
    public void testComparatorTotallyDifferent() {
        Assert.assertTrue((this.comp.compare("foo", "bar") < 0.5 ? 1 : 0) != 0);
    }

    @Test
    public void testComparatorOneInFour() {
        Assert.assertEquals((Object)0.75, (Object)this.comp.compare("fooz", "foos"));
    }

    @Test
    public void testEmpty() {
        Assert.assertEquals((int)0, (int)Levenshtein.distance((String)"", (String)""));
    }

    @Test
    public void testEmpty1() {
        Assert.assertEquals((int)1, (int)Levenshtein.distance((String)"", (String)"1"));
    }

    @Test
    public void testEmpty2() {
        Assert.assertEquals((int)1, (int)Levenshtein.distance((String)"1", (String)""));
    }

    @Test
    public void testKitten() {
        Assert.assertEquals((int)3, (int)Levenshtein.distance((String)"kitten", (String)"sitting"));
        Assert.assertEquals((int)3, (int)Levenshtein.distance((String)"sitting", (String)"kitten"));
    }

    @Test
    public void testDays() {
        Assert.assertEquals((int)3, (int)Levenshtein.distance((String)"saturday", (String)"sunday"));
        Assert.assertEquals((int)3, (int)Levenshtein.distance((String)"sunday", (String)"saturday"));
    }

    @Test
    public void testGambol() {
        Assert.assertEquals((int)2, (int)Levenshtein.distance((String)"gambol", (String)"gumbo"));
        Assert.assertEquals((int)2, (int)Levenshtein.distance((String)"gumbo", (String)"gambol"));
    }

    @Test
    public void testTotallyUnlike() {
        Assert.assertEquals((int)4, (int)Levenshtein.distance((String)"abcd", (String)"efgh"));
    }

    @Test
    public void testCEmpty() {
        Assert.assertEquals((int)0, (int)Levenshtein.compactDistance((String)"", (String)""));
    }

    @Test
    public void testCEmpty1() {
        Assert.assertEquals((int)1, (int)Levenshtein.compactDistance((String)"", (String)"1"));
    }

    @Test
    public void testCEmpty2() {
        Assert.assertEquals((int)1, (int)Levenshtein.compactDistance((String)"1", (String)""));
    }

    @Test
    public void testCKitten() {
        Assert.assertEquals((int)3, (int)Levenshtein.compactDistance((String)"kitten", (String)"sitting"));
        Assert.assertEquals((int)3, (int)Levenshtein.compactDistance((String)"sitting", (String)"kitten"));
    }

    @Test
    public void testCDays() {
        Assert.assertEquals((int)3, (int)Levenshtein.compactDistance((String)"saturday", (String)"sunday"));
        Assert.assertEquals((int)3, (int)Levenshtein.compactDistance((String)"sunday", (String)"saturday"));
    }

    @Test
    public void testCGambol() {
        Assert.assertEquals((int)2, (int)Levenshtein.compactDistance((String)"gambol", (String)"gumbo"));
        Assert.assertEquals((int)2, (int)Levenshtein.compactDistance((String)"gumbo", (String)"gambol"));
    }

    @Test
    public void testCTotallyUnlike() {
        Assert.assertEquals((int)3, (int)Levenshtein.compactDistance((String)"abcd", (String)"efgh"));
    }
}

