/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.test;

import java.util.Collection;
import junit.framework.Assert;
import no.priv.garshol.duke.InMemoryLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import org.junit.Before;
import org.junit.Test;

public class InMemoryLinkDatabaseTest {
    private LinkDatabase linkdb;

    @Before
    public void setUp() {
        this.linkdb = new InMemoryLinkDatabase();
    }

    @Test
    public void emptyTest() {
        Assert.assertEquals((int)this.linkdb.getAllLinks().size(), (int)0);
        Assert.assertEquals((int)this.linkdb.getAllLinksFor("1").size(), (int)0);
    }

    @Test
    public void testGetAllLinksForEmpty() {
        Assert.assertTrue((boolean)this.linkdb.getAllLinksFor("nonexistentid").isEmpty());
    }

    @Test
    public void testAddOne() {
        Link link = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)links.size(), (int)1);
        Assert.assertTrue((boolean)links.contains(link));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)links.size(), (int)1);
        Assert.assertTrue((boolean)links.contains(link));
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)links.size(), (int)1);
        Assert.assertTrue((boolean)links.contains(link));
    }

    @Test
    public void testAddIdempotent() {
        Link link = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link);
        link = new Link("2", "1", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)links.size(), (int)1);
        Assert.assertTrue((boolean)links.contains(link));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)links.size(), (int)1);
        Assert.assertTrue((boolean)links.contains(link));
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)links.size(), (int)1);
        Assert.assertTrue((boolean)links.contains(link));
    }

    @Test
    public void testInference() {
        ((InMemoryLinkDatabase)this.linkdb).setDoInference(true);
        Link link1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link1);
        Link link2 = new Link("1", "3", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link2);
        Link link3 = new Link("2", "3", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)3, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link3));
        links = this.linkdb.getAllLinksFor("3");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
    }

    @Test
    public void testInferenceDifferent() {
        ((InMemoryLinkDatabase)this.linkdb).setDoInference(true);
        Link link1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        this.linkdb.assertLink(link1);
        Link link2 = new Link("1", "3", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        this.linkdb.assertLink(link2);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)1, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        links = this.linkdb.getAllLinksFor("3");
        Assert.assertEquals((int)1, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link2));
    }

    @Test
    public void testInferenceDifferent2() {
        ((InMemoryLinkDatabase)this.linkdb).setDoInference(true);
        Link link2 = new Link("1", "3", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link2);
        Link link1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        this.linkdb.assertLink(link1);
        Link link3 = new Link("2", "3", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)3, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link3));
        links = this.linkdb.getAllLinksFor("3");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
    }

    @Test
    public void testInferenceDifferent2b() {
        ((InMemoryLinkDatabase)this.linkdb).setDoInference(true);
        Link link1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        this.linkdb.assertLink(link1);
        Link link2 = new Link("1", "3", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link2);
        Link link3 = new Link("2", "3", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)3, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link3));
        links = this.linkdb.getAllLinksFor("3");
        Assert.assertEquals((int)2, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
    }

    @Test
    public void testInference2() {
        ((InMemoryLinkDatabase)this.linkdb).setDoInference(true);
        Link link1 = new Link("1", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link1);
        Link link2 = new Link("3", "4", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link2);
        Link link3 = new Link("3", "5", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link3);
        Link link4 = new Link("4", "5", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        Link link5 = new Link("4", "2", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        this.linkdb.assertLink(link5);
        Collection links = this.linkdb.getAllLinks();
        Assert.assertEquals((int)10, (int)links.size());
        Assert.assertTrue((boolean)links.contains(link1));
        Assert.assertTrue((boolean)links.contains(link2));
        Assert.assertTrue((boolean)links.contains(link3));
        Assert.assertTrue((boolean)links.contains(link4));
        Assert.assertTrue((boolean)links.contains(link5));
        links = this.linkdb.getAllLinksFor("1");
        Assert.assertEquals((int)4, (int)links.size());
        links = this.linkdb.getAllLinksFor("2");
        Assert.assertEquals((int)4, (int)links.size());
        links = this.linkdb.getAllLinksFor("3");
        Assert.assertEquals((int)4, (int)links.size());
        links = this.linkdb.getAllLinksFor("4");
        Assert.assertEquals((int)4, (int)links.size());
        links = this.linkdb.getAllLinksFor("5");
        Assert.assertEquals((int)4, (int)links.size());
    }

    @Test
    public void testInferenceDifferentBig() {
        ((InMemoryLinkDatabase)this.linkdb).setDoInference(true);
        Link link1 = this.same("1", "3");
        Link link2 = this.different("1", "2");
        Link link3 = new Link("2", "3", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Link link4 = this.same("4", "6");
        Link link5 = this.different("4", "5");
        Link link6 = new Link("5", "6", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Link link7 = this.same("3", "4");
        Link link8 = new Link("2", "4", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Link link9 = new Link("2", "6", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Link link10 = new Link("1", "4", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        Link link11 = new Link("1", "6", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        Link link12 = new Link("3", "5", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Link link13 = new Link("1", "5", LinkStatus.ASSERTED, LinkKind.DIFFERENT, 1.0);
        Link link14 = new Link("3", "6", LinkStatus.ASSERTED, LinkKind.SAME, 1.0);
        Collection links = this.linkdb.getAllLinks();
        this.verifyContained(links, new Link[]{link1, link2, link3, link4, link5, link6, link7, link8, link9, link10, link11, link12, link13, link14});
    }

    private Link same(String id1, String id2) {
        return this.link(id1, id2, LinkKind.SAME);
    }

    private Link different(String id1, String id2) {
        return this.link(id1, id2, LinkKind.DIFFERENT);
    }

    private Link link(String id1, String id2, LinkKind kind) {
        Link link = new Link(id1, id2, LinkStatus.ASSERTED, kind, 1.0);
        this.linkdb.assertLink(link);
        return link;
    }

    private void verifyContained(Collection<Link> coll, Link[] links) {
        Assert.assertEquals((String)"wrong number of links", (int)links.length, (int)coll.size());
        for (int ix = 0; ix < links.length; ++ix) {
            Assert.assertTrue((String)("correct link not inferred: " + links[ix]), (boolean)coll.contains(links[ix]));
        }
    }
}

