/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.comparators.QGramComparator;
import no.priv.garshol.duke.utils.ObjectUtils;
import org.junit.Before;
import org.junit.Test;

public class ObjectUtilsTest {
    private TestBean bean;
    private Map<String, Object> objects;

    @Before
    public void setup() {
        this.bean = new TestBean();
        this.objects = new HashMap<String, Object>();
    }

    @Test
    public void testOneWord() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"property", (String)"value", this.objects);
        Assert.assertEquals((String)"property not set correctly", (String)"value", (String)this.bean.getProperty());
    }

    @Test
    public void testTwoWords() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"property-name", (String)"value", this.objects);
        Assert.assertEquals((String)"property not set correctly", (String)"value", (String)this.bean.getPropertyName());
    }

    @Test
    public void testThreeWords() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"long-property-name", (String)"value", this.objects);
        Assert.assertEquals((String)"property not set correctly", (String)"value", (String)this.bean.getLongPropertyName());
    }

    @Test
    public void testIntProperty() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"int-property", (String)"25", this.objects);
        Assert.assertEquals((String)"property not set correctly", (int)25, (int)this.bean.getIntProperty());
    }

    @Test
    public void testBoolProperty() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"bool-property", (String)"true", this.objects);
        Assert.assertEquals((String)"property not set correctly", (boolean)true, (boolean)this.bean.getBoolProperty());
    }

    @Test
    public void testDoubleProperty() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"double-property", (String)"0.25", this.objects);
        Assert.assertEquals((String)"property not set correctly", (Object)0.25, (Object)this.bean.getDoubleProperty());
    }

    @Test
    public void testFloatProperty() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"float-property", (String)"0.25", this.objects);
        Assert.assertEquals((String)"property not set correctly", (Object)Float.valueOf(0.25f), (Object)Float.valueOf(this.bean.getFloatProperty()));
    }

    @Test
    public void testNamedObject() {
        this.objects.put("thetest", this);
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"test", (String)"thetest", this.objects);
        Assert.assertEquals((String)"property not set correctly", (Object)this, (Object)this.bean.getTest());
    }

    @Test
    public void testEnumConstant() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"enum", (String)"JACCARD", this.objects);
        Assert.assertEquals((String)"property not set correctly", (Object)QGramComparator.Formula.JACCARD, (Object)this.bean.getEnum());
    }

    @Test
    public void testCharProperty() {
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"char-property", (String)"g", this.objects);
        Assert.assertEquals((String)"property not set correctly", (char)'g', (char)this.bean.getCharProperty());
    }

    @Test
    public void testCharPropertyError() {
        try {
            ObjectUtils.setBeanProperty((Object)this.bean, (String)"char-property", (String)"goo", this.objects);
            Assert.fail((String)"shouldn't accept three-character string as value of character prop");
        }
        catch (DukeConfigException dukeConfigException) {
            // empty catch block
        }
    }

    @Test
    public void testCollection() {
        this.objects.put("foo", "gurgle");
        this.objects.put("bar", "gargle");
        ObjectUtils.setBeanProperty((Object)this.bean, (String)"collection", (String)"foo bar", this.objects);
        Collection<String> coll = this.bean.getCollection();
        Assert.assertEquals((int)2, (int)coll.size());
        Assert.assertTrue((boolean)coll.contains("gurgle"));
        Assert.assertTrue((boolean)coll.contains("gargle"));
    }

    public static class TestBean {
        private String value;
        private int theint;
        private boolean thebool;
        private double thedouble;
        private float thefloat;
        private char thechar;
        private ObjectUtilsTest thetest;
        private QGramComparator.Formula theenum;
        private Collection<String> collection;

        public void setProperty(String value) {
            this.value = value;
        }

        public String getProperty() {
            return this.value;
        }

        public void setPropertyName(String value) {
            this.value = value;
        }

        public String getPropertyName() {
            return this.value;
        }

        public void setLongPropertyName(String value) {
            this.value = value;
        }

        public String getLongPropertyName() {
            return this.value;
        }

        public void setIntProperty(int value) {
            this.theint = value;
        }

        public int getIntProperty() {
            return this.theint;
        }

        public void setBoolProperty(boolean value) {
            this.thebool = value;
        }

        public boolean getBoolProperty() {
            return this.thebool;
        }

        public void setDoubleProperty(double value) {
            this.thedouble = value;
        }

        public double getDoubleProperty() {
            return this.thedouble;
        }

        public void setFloatProperty(float value) {
            this.thefloat = value;
        }

        public float getFloatProperty() {
            return this.thefloat;
        }

        public void setTest(ObjectUtilsTest test) {
            this.thetest = test;
        }

        public ObjectUtilsTest getTest() {
            return this.thetest;
        }

        public void setCharProperty(char ch) {
            this.thechar = ch;
        }

        public char getCharProperty() {
            return this.thechar;
        }

        public void setEnum(QGramComparator.Formula theenum) {
            this.theenum = theenum;
        }

        public QGramComparator.Formula getEnum() {
            return this.theenum;
        }

        public Collection<String> getCollection() {
            return this.collection;
        }

        public void setCollection(Collection<String> collection) {
            this.collection = collection;
        }
    }
}

