/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import no.priv.garshol.duke.ConfigLoader;
import no.priv.garshol.duke.Configuration;
import no.priv.garshol.duke.DataSource;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.InMemoryLinkDatabase;
import no.priv.garshol.duke.Link;
import no.priv.garshol.duke.LinkDatabase;
import no.priv.garshol.duke.LinkKind;
import no.priv.garshol.duke.LinkStatus;
import no.priv.garshol.duke.Logger;
import no.priv.garshol.duke.Processor;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.matchers.AbstractMatchListener;
import no.priv.garshol.duke.matchers.PrintMatchListener;
import no.priv.garshol.duke.matchers.TestFileListener;
import no.priv.garshol.duke.utils.CommandLineParser;
import no.priv.garshol.duke.utils.LinkDatabaseUtils;
import no.priv.garshol.duke.utils.LinkFileWriter;
import no.priv.garshol.duke.utils.NTriplesWriter;
import no.priv.garshol.duke.utils.YesNoConsole;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Duke {
    private static Properties properties;

    public static void main(String[] argv) throws IOException {
        try {
            Duke.main_(argv);
        }
        catch (DukeConfigException e) {
            System.err.println("ERROR: " + e.getMessage());
        }
    }

    public static void main_(String[] argv) throws IOException {
        Configuration config;
        CommandLineParser parser = Duke.setupParser();
        try {
            argv = parser.parse(argv);
        }
        catch (CommandLineParser.CommandLineParserException e) {
            System.err.println("ERROR: " + e.getMessage());
            Duke.usage();
            System.exit(1);
        }
        boolean datadebug = parser.getOptionState("showdata");
        CommandLineLogger logger = new CommandLineLogger(parser.getOptionState("verbose") ? 1 : 0);
        boolean progress = parser.getOptionState("progress");
        boolean count = false;
        int batch_size = parser.getOptionInteger("batchsize", 40000);
        int threads = parser.getOptionInteger("threads", 1);
        try {
            config = ConfigLoader.load(argv[0]);
        }
        catch (FileNotFoundException e) {
            System.err.println("ERROR: Config file '" + argv[0] + "' not found!");
            return;
        }
        catch (SAXParseException e) {
            System.err.println("ERROR: Couldn't parse config file: " + e.getMessage());
            System.err.println("Error in " + e.getSystemId() + ":" + e.getLineNumber() + ":" + e.getColumnNumber());
            return;
        }
        catch (SAXException e) {
            System.err.println("ERROR: Couldn't parse config file: " + e.getMessage());
            return;
        }
        if (!datadebug) {
            config.validate();
        }
        if (datadebug) {
            Duke.showdata(config);
            return;
        }
        boolean noreindex = parser.getOptionState("noreindex");
        Processor processor = new Processor(config, !noreindex);
        processor.setLogger(logger);
        processor.setThreads(threads);
        if (noreindex && processor.getDatabase().isInMemory()) {
            System.out.println("Option --noreindex not available with in-memory database");
            return;
        }
        if (parser.getOptionState("lookups")) {
            System.out.println("Lookup properties:");
            for (Property p : config.getLookupProperties()) {
                System.out.println("  " + p.getName());
            }
            System.out.println();
        }
        boolean interactive = parser.getOptionState("interactive");
        boolean pretty = parser.getOptionState("pretty") || interactive;
        boolean showmatches = parser.getOptionState("showmatches") || interactive;
        PrintMatchListener listener = new PrintMatchListener(showmatches, parser.getOptionState("showmaybe"), progress, !config.isDeduplicationMode(), config.getProperties(), pretty);
        processor.addMatchListener(listener);
        TestFileListener testfile = null;
        if (parser.getOptionValue("testfile") != null) {
            testfile = new TestFileListener(parser.getOptionValue("testfile"), config, parser.getOptionState("testdebug"), processor, showmatches, pretty);
            testfile.setPessimistic(true);
            processor.addMatchListener(testfile);
            if (testfile.isEmpty()) {
                System.out.println("WARN: Test file is empty. Did you mean --linkfile?");
            }
        }
        AbstractLinkFileListener linkfile = null;
        if (parser.getOptionValue("linkfile") != null) {
            String fname = parser.getOptionValue("linkfile");
            linkfile = fname.endsWith(".ntriples") ? new NTriplesLinkFileListener(fname, config.getIdentityProperties()) : new LinkFileListener(fname, config.getIdentityProperties(), interactive, parser.getOptionValue("testfile"));
            processor.addMatchListener(linkfile);
        }
        if (parser.getOptionState("profile")) {
            processor.setPerformanceProfiling(true);
        }
        boolean matchall = true;
        if (parser.getOptionState("singlematch")) {
            if (config.isDeduplicationMode()) {
                throw new DukeConfigException("--singlematch only works in record linkage mode");
            }
            matchall = false;
        }
        if (config.isDeduplicationMode()) {
            processor.deduplicate(config.getDataSources(), batch_size);
        } else if (noreindex) {
            processor.linkRecords(config.getDataSources(2), matchall);
        } else {
            processor.link(config.getDataSources(1), config.getDataSources(2), matchall, batch_size);
        }
        if (parser.getOptionValue("linkfile") != null) {
            linkfile.close();
        }
        processor.close();
    }

    private static void showdata(Configuration config) {
        List<Property> props = config.getProperties();
        ArrayList<DataSource> sources = new ArrayList<DataSource>();
        sources.addAll(config.getDataSources());
        sources.addAll(config.getDataSources(1));
        sources.addAll(config.getDataSources(2));
        for (DataSource src : sources) {
            RecordIterator it = src.getRecords();
            while (it.hasNext()) {
                Record r = (Record)it.next();
                PrintMatchListener.prettyPrint(r, props);
                System.out.println("");
            }
            it.close();
        }
    }

    private static void usage() {
        System.out.println("");
        System.out.println("java no.priv.garshol.duke.Duke [options] <cfgfile>");
        System.out.println("");
        System.out.println("  --progress            show progress report while running");
        System.out.println("  --showmatches         show matches while running");
        System.out.println("  --linkfile=<file>     output matches to link file");
        System.out.println("  --interactive         query user before outputting link file matches");
        System.out.println("  --testfile=<file>     test matches against known correct results in file");
        System.out.println("  --testdebug           display failures");
        System.out.println("  --verbose             display diagnostics");
        System.out.println("  --noreindex           reuse existing Lucene index");
        System.out.println("  --batchsize=n         set size of Lucene indexing batches");
        System.out.println("  --showdata            show all cleaned data (data debug mode)");
        System.out.println("  --profile             display performance statistics");
        System.out.println("  --threads=N           run processing in N parallell threads");
        System.out.println("  --pretty              pretty display when comparing records");
        System.out.println("  --singlematch         (in record linkage mode) only accept");
        System.out.println("                        the best match for each record");
        System.out.println("  --lookups             display lookup properties");
        System.out.println("");
        System.out.println("Duke version " + Duke.getVersionString());
    }

    private static CommandLineParser setupParser() {
        CommandLineParser parser = new CommandLineParser();
        parser.setMinimumArguments(1);
        parser.setMaximumArguments(1);
        parser.addBooleanOption("progress", 'p');
        parser.addStringOption("linkfile", 'l');
        parser.addStringOption("linkendpoint", 'e');
        parser.addBooleanOption("showmatches", 's');
        parser.addBooleanOption("showmaybe", 'm');
        parser.addStringOption("testfile", 'T');
        parser.addBooleanOption("testdebug", 't');
        parser.addStringOption("batchsize", 'b');
        parser.addBooleanOption("verbose", 'v');
        parser.addStringOption("threads", 'P');
        parser.addBooleanOption("noreindex", 'N');
        parser.addBooleanOption("interactive", 'I');
        parser.addBooleanOption("showdata", 'D');
        parser.addBooleanOption("profile", 'o');
        parser.addStringOption("threads", 'n');
        parser.addBooleanOption("pretty", 'n');
        parser.addBooleanOption("singlematch", 'n');
        parser.addBooleanOption("lookups", 'L');
        return parser;
    }

    public static String getVersionString() {
        Properties props = Duke.getProperties();
        return props.getProperty("duke.version") + ", build " + props.getProperty("duke.build") + ", built by " + props.getProperty("duke.builder");
    }

    public static String getVersion() {
        return Duke.getProperties().getProperty("duke.version");
    }

    private static Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            try {
                InputStream in = Duke.class.getClassLoader().getResourceAsStream("no/priv/garshol/duke/duke.properties");
                properties.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new DukeException("Couldn't load duke.properties", e);
            }
        }
        return properties;
    }

    static class CommandLineLogger
    implements Logger {
        private int loglevel;

        private CommandLineLogger(int loglevel) {
            this.loglevel = loglevel;
        }

        @Override
        public void trace(String msg) {
            if (this.isTraceEnabled()) {
                System.out.println(msg);
            }
        }

        @Override
        public void debug(String msg) {
            if (this.isDebugEnabled()) {
                System.out.println(msg);
            }
        }

        @Override
        public void info(String msg) {
            if (this.isInfoEnabled()) {
                System.out.println(msg);
            }
        }

        @Override
        public void warn(String msg) {
            this.warn(msg, null);
        }

        @Override
        public void warn(String msg, Throwable e) {
            if (!this.isWarnEnabled()) {
                return;
            }
            System.out.println(msg + " " + e);
            e.printStackTrace();
        }

        @Override
        public void error(String msg) {
            this.error(msg, null);
        }

        @Override
        public void error(String msg, Throwable e) {
            if (!this.isErrorEnabled()) {
                return;
            }
            System.out.println(msg + " " + e);
            e.printStackTrace();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.loglevel == 1;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.loglevel != 0 && this.loglevel < 3;
        }

        @Override
        public boolean isInfoEnabled() {
            return this.loglevel != 0 && this.loglevel < 4;
        }

        @Override
        public boolean isWarnEnabled() {
            return this.loglevel != 0 && this.loglevel < 5;
        }

        @Override
        public boolean isErrorEnabled() {
            return this.loglevel != 0 && this.loglevel < 6;
        }
    }

    static class NTriplesLinkFileListener
    extends AbstractLinkFileListener {
        private FileOutputStream fos;
        private NTriplesWriter out;

        public NTriplesLinkFileListener(String linkfile, Collection<Property> idprops) throws IOException {
            super(idprops);
            this.fos = new FileOutputStream(linkfile);
            this.out = new NTriplesWriter(this.fos);
        }

        @Override
        public void link(String id1, String id2, double confidence) throws IOException {
            this.out.statement(id1, "http://www.w3.org/2002/07/owl#sameAs", id2, false);
        }

        @Override
        public void close() throws IOException {
            this.out.done();
            this.fos.close();
        }
    }

    static class LinkFileListener
    extends AbstractLinkFileListener {
        private Writer out;
        private LinkFileWriter writer;
        private LinkDatabase linkdb;
        private YesNoConsole console;

        public LinkFileListener(String linkfile, Collection<Property> idprops, boolean interactive, String testfile) throws IOException {
            super(idprops);
            if (interactive) {
                this.console = new YesNoConsole();
                this.linkdb = new InMemoryLinkDatabase();
                if (testfile != null) {
                    this.linkdb = LinkDatabaseUtils.loadTestFile(testfile);
                }
            }
            this.out = new FileWriter(linkfile, testfile != null);
            this.writer = new LinkFileWriter(this.out);
        }

        @Override
        public void link(String id1, String id2, double confidence) throws IOException {
            boolean correct = true;
            Link inferredlink = null;
            if (this.linkdb != null) {
                inferredlink = this.linkdb.inferLink(id1, id2);
            }
            if (this.console != null) {
                if (inferredlink == null) {
                    correct = this.console.yesorno();
                    confidence = 1.0;
                } else {
                    correct = inferredlink.getKind() == LinkKind.SAME;
                    confidence = inferredlink.getConfidence();
                }
            }
            this.writer.write(id1, id2, correct, confidence);
            this.out.flush();
            if (this.linkdb != null && inferredlink == null) {
                Link link = new Link(id1, id2, LinkStatus.ASSERTED, correct ? LinkKind.SAME : LinkKind.DIFFERENT, 1.0);
                this.linkdb.assertLink(link);
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    static abstract class AbstractLinkFileListener
    extends AbstractMatchListener {
        private Collection<Property> idprops;

        public AbstractLinkFileListener(Collection<Property> idprops) {
            this.idprops = idprops;
        }

        public void close() throws IOException {
        }

        public abstract void link(String var1, String var2, double var3) throws IOException;

        @Override
        public void matches(Record r1, Record r2, double confidence) {
            try {
                for (Property p : this.idprops) {
                    for (String id1 : r1.getValues(p.getName())) {
                        for (String id2 : r2.getValues(p.getName())) {
                            this.link(id1, id2, confidence);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new DukeException(e);
            }
        }
    }
}

