/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.comparators;

import no.priv.garshol.duke.Comparator;

public class WeightedLevenshtein
implements Comparator {
    private WeightEstimator estimator = new DefaultWeightEstimator();

    @Override
    public double compare(String s1, String s2) {
        if (s1.equals(s2)) {
            return 1.0;
        }
        int len = Math.min(s1.length(), s2.length());
        double dist = WeightedLevenshtein.distance(s1, s2, this.estimator);
        if (dist > (double)len) {
            return 0.0;
        }
        return 1.0 - dist / (double)len;
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    public void setEstimator(WeightEstimator estimator) {
        this.estimator = estimator;
    }

    public WeightEstimator getEstimator() {
        return this.estimator;
    }

    public static double distance(String s1, String s2, WeightEstimator weight) {
        int s1len = s1.length();
        if (s1len == 0) {
            return WeightedLevenshtein.estimateCharacters(s2, weight);
        }
        if (s2.length() == 0) {
            return WeightedLevenshtein.estimateCharacters(s1, weight);
        }
        double[] matrix = new double[(s1len + 1) * (s2.length() + 1)];
        for (int col = 0; col <= s2.length(); ++col) {
            matrix[col * s1len] = col;
        }
        for (int row = 0; row <= s1len; ++row) {
            matrix[row] = row;
        }
        for (int ix1 = 0; ix1 < s1len; ++ix1) {
            char ch1 = s1.charAt(ix1);
            for (int ix2 = 0; ix2 < s2.length(); ++ix2) {
                char ch2 = s2.charAt(ix2);
                double cost = ch1 == ch2 ? 0.0 : weight.substitute(ix1, ch1, s2.charAt(ix2));
                double left = matrix[ix1 + (ix2 + 1) * s1len] + weight.delete(ix1, ch1);
                double above = matrix[ix1 + 1 + ix2 * s1len] + weight.insert(ix1, ch2);
                double aboveleft = matrix[ix1 + ix2 * s1len] + cost;
                matrix[ix1 + 1 + (ix2 + 1) * s1len] = Math.min(left, Math.min(above, aboveleft));
            }
        }
        return matrix[s1len + s2.length() * s1len];
    }

    private static double estimateCharacters(String s, WeightEstimator e) {
        double sum = 0.0;
        for (int ix = 0; ix < s.length(); ++ix) {
            sum += Math.min(e.insert(ix, s.charAt(ix)), e.delete(ix, s.charAt(ix)));
        }
        return sum;
    }

    public static class DefaultWeightEstimator
    implements WeightEstimator {
        private double[] charweight;
        private double digits = 2.0;
        private double letters = 1.0;
        private double punctuation = 0.1;
        private double other = 1.0;

        public DefaultWeightEstimator() {
            this.recompute();
        }

        @Override
        public double substitute(int pos, char ch1, char ch2) {
            return Math.max(this.insert(pos, ch1), this.insert(pos, ch2));
        }

        @Override
        public double delete(int pos, char ch) {
            return this.insert(pos, ch);
        }

        @Override
        public double insert(int pos, char ch) {
            if (ch > this.charweight.length) {
                return this.other;
            }
            return this.charweight[ch];
        }

        public void setDigitWeight(double digits) {
            this.digits = digits;
            this.recompute();
        }

        public double getDigitWeight() {
            return this.digits;
        }

        public void setLetterWeight(double letters) {
            this.letters = letters;
            this.recompute();
        }

        public void setOtherWeight(double other) {
            this.other = other;
            this.recompute();
        }

        public void setPunctuationWeight(double punctuation) {
            this.punctuation = punctuation;
            this.recompute();
        }

        private void recompute() {
            this.charweight = new double[255];
            for (int ix = 0; ix < this.charweight.length; ++ix) {
                char ch = (char)ix;
                double weight = this.other;
                if (Character.isLetter(ch)) {
                    weight = this.letters;
                } else if (Character.isDigit(ch)) {
                    weight = this.digits;
                } else {
                    int type = Character.getType(ch);
                    if (Character.isSpace(ch) || type >= 20 && type <= 27) {
                        weight = this.punctuation;
                    }
                }
                this.charweight[ix] = weight;
            }
        }
    }

    public static interface WeightEstimator {
        public double substitute(int var1, char var2, char var3);

        public double delete(int var1, char var2);

        public double insert(int var1, char var2);
    }
}

