/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.datasources;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import no.priv.garshol.duke.ConfigWriter;
import no.priv.garshol.duke.DukeConfigException;
import no.priv.garshol.duke.DukeException;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.RecordIterator;
import no.priv.garshol.duke.datasources.Column;
import no.priv.garshol.duke.datasources.ColumnarDataSource;
import no.priv.garshol.duke.datasources.RecordBuilder;
import no.priv.garshol.duke.utils.CSVReader;

public class CSVDataSource
extends ColumnarDataSource {
    private String file;
    private String encoding;
    private Reader directreader;
    private int skiplines;
    private boolean hasheader = true;
    private char separator;
    private int buffer_size = 65386;

    public String getInputFile() {
        return this.file;
    }

    public void setInputFile(String file) {
        this.file = file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int getSkipLines() {
        return this.skiplines;
    }

    public void setSkipLines(int skiplines) {
        this.skiplines = skiplines;
    }

    public boolean getHeaderLine() {
        return this.hasheader;
    }

    public void setHeaderLine(boolean hasheader) {
        this.hasheader = hasheader;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public int getBufferSize() {
        return this.buffer_size;
    }

    public void setBufferSize(int buffer_size) {
        this.buffer_size = buffer_size;
    }

    public void setReader(Reader reader) {
        this.directreader = reader;
    }

    @Override
    public RecordIterator getRecords() {
        if (this.directreader == null) {
            this.verifyProperty(this.file, "input-file");
        }
        try {
            Reader in = this.directreader != null ? this.directreader : (this.encoding == null ? new FileReader(this.file) : new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
            CSVReader csv = new CSVReader(in, this.buffer_size, this.file);
            if (this.separator != '\u0000') {
                csv.setSeparator(this.separator);
            }
            return new CSVRecordIterator(csv);
        }
        catch (FileNotFoundException e) {
            throw new DukeConfigException("Couldn't find CSV file '" + this.file + "'");
        }
        catch (IOException e) {
            throw new DukeException(e);
        }
    }

    @Override
    public void writeConfig(ConfigWriter cw) {
        String name = "csv";
        cw.writeStartElement("csv", null);
        cw.writeParam("input-file", this.getInputFile());
        cw.writeParam("encoding", this.getEncoding());
        cw.writeParam("skip-lines", this.getSkipLines());
        cw.writeParam("header-line", this.getHeaderLine());
        if (this.getSeparator() != '\u0000') {
            cw.writeParam("separator", this.getSeparator());
        }
        if (this.getBufferSize() != 65386) {
            cw.writeParam("buffer-size", this.getBufferSize());
        }
        this.writeColumnsConfig(cw);
        cw.writeEndElement("csv");
    }

    @Override
    protected String getSourceName() {
        return "CSV";
    }

    public class CSVRecordIterator
    extends RecordIterator {
        private CSVReader reader;
        private int[] index;
        private Column[] column;
        private RecordBuilder builder;
        private Record nextrecord;

        public CSVRecordIterator(CSVReader reader) throws IOException {
            this.reader = reader;
            this.builder = new RecordBuilder(CSVDataSource.this);
            Collection<Column> allcolumns = CSVDataSource.this.getColumns();
            this.index = new int[allcolumns.size()];
            this.column = new Column[allcolumns.size()];
            for (int ix = 0; ix < CSVDataSource.this.skiplines; ++ix) {
                reader.next();
            }
            String[] header = null;
            if (CSVDataSource.this.hasheader) {
                header = reader.next();
            } else {
                int high = 0;
                for (Column c : CSVDataSource.this.getColumns()) {
                    high = Math.max(high, Integer.parseInt(c.getName()));
                }
                header = new String[high];
                for (int ix = 0; ix < high; ++ix) {
                    header[ix] = "" + (ix + 1);
                }
            }
            if (CSVDataSource.this.hasheader && !CSVDataSource.this.getColumns().isEmpty() && header == null) {
                throw new DukeException("CSV file contained no header");
            }
            int count = 0;
            for (Column c : allcolumns) {
                boolean found = false;
                for (int ix = 0; ix < header.length; ++ix) {
                    if (!header[ix].equals(c.getName())) continue;
                    this.index[count] = ix;
                    this.column[count++] = c;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new DukeConfigException("Column " + c.getName() + " not found in CSV file");
            }
            this.findNextRecord();
        }

        private void findNextRecord() {
            String[] row;
            try {
                row = this.reader.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (row == null) {
                this.nextrecord = null;
                return;
            }
            this.builder.newRecord();
            for (int ix = 0; ix < this.column.length; ++ix) {
                if (this.index[ix] >= row.length) continue;
                this.builder.addValue(this.column[ix], row[this.index[ix]]);
            }
            this.nextrecord = this.builder.getRecord();
        }

        @Override
        public boolean hasNext() {
            return this.nextrecord != null;
        }

        @Override
        public Record next() {
            Record thenext = this.nextrecord;
            this.findNextRecord();
            return thenext;
        }
    }
}

