/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.matchers;

import java.util.Collection;
import java.util.List;
import no.priv.garshol.duke.Property;
import no.priv.garshol.duke.Record;
import no.priv.garshol.duke.matchers.AbstractMatchListener;

public class PrintMatchListener
extends AbstractMatchListener {
    private int matches = 0;
    private int records = 0;
    private int nonmatches;
    private boolean showmaybe;
    private boolean showmatches;
    private boolean progress;
    private boolean linkage;
    private boolean pretty;
    private List<Property> properties;

    public PrintMatchListener(boolean showmatches, boolean showmaybe, boolean progress, boolean linkage, List<Property> properties, boolean pretty) {
        this.showmatches = showmatches;
        this.showmaybe = showmaybe;
        this.progress = progress;
        this.linkage = linkage;
        this.properties = properties;
        this.pretty = pretty;
    }

    public int getMatchCount() {
        return this.matches;
    }

    @Override
    public void batchReady(int size) {
        if (this.progress) {
            System.out.println("Records: " + this.records);
        }
        this.records += size;
    }

    @Override
    public void matches(Record r1, Record r2, double confidence) {
        ++this.matches;
        if (this.showmatches) {
            if (this.pretty) {
                PrintMatchListener.prettyCompare(r1, r2, confidence, "\nMATCH", this.properties);
            } else {
                PrintMatchListener.show(r1, r2, confidence, "\nMATCH", this.properties);
            }
        }
        if (this.matches % 1000 == 0 && this.progress) {
            System.out.println("" + this.matches + "  matches");
        }
    }

    @Override
    public void matchesPerhaps(Record r1, Record r2, double confidence) {
        if (this.showmaybe) {
            if (this.pretty) {
                PrintMatchListener.prettyCompare(r1, r2, confidence, "\nMAYBE MATCH", this.properties);
            } else {
                PrintMatchListener.show(r1, r2, confidence, "\nMAYBE MATCH", this.properties);
            }
        }
    }

    @Override
    public void endProcessing() {
        if (this.progress) {
            System.out.println("");
            System.out.println("Total records: " + this.records);
            System.out.println("Total matches: " + this.matches);
            System.out.println("Total non-matches: " + this.nonmatches);
        }
    }

    @Override
    public void noMatchFor(Record record) {
        ++this.nonmatches;
        if (this.showmatches && this.linkage) {
            System.out.println("\nNO MATCH FOR:\n" + PrintMatchListener.toString(record, this.properties));
        }
    }

    public static void show(Record r1, Record r2, double confidence, String heading, List<Property> props) {
        System.out.println(heading + " " + confidence);
        System.out.println(PrintMatchListener.toString(r1, props));
        System.out.println(PrintMatchListener.toString(r2, props));
    }

    public static void show(Record r1, Record r2, double confidence, String heading, List<Property> props, boolean pretty) {
        if (pretty) {
            PrintMatchListener.prettyCompare(r1, r2, confidence, heading, props);
        } else {
            PrintMatchListener.show(r1, r2, confidence, heading, props);
        }
    }

    public static String toString(Record r) {
        StringBuffer buf = new StringBuffer();
        for (String p : r.getProperties()) {
            Collection<String> vs = r.getValues(p);
            if (vs == null || vs.isEmpty()) continue;
            buf.append(p + ": ");
            for (String v : vs) {
                buf.append("'" + v + "', ");
            }
        }
        return buf.toString();
    }

    public static String toString(Record r, List<Property> props) {
        StringBuffer buf = new StringBuffer();
        for (Property p : props) {
            Collection<String> vs = r.getValues(p.getName());
            if (vs == null || vs.isEmpty()) continue;
            buf.append(p.getName() + ": ");
            for (String v : vs) {
                buf.append("'" + v + "', ");
            }
        }
        return buf.toString();
    }

    public static void prettyCompare(Record r1, Record r2, double confidence, String heading, List<Property> props) {
        System.out.println(heading + " " + confidence);
        for (Property p : props) {
            String prop = p.getName();
            if (!(r1.getValues(prop) != null && !r1.getValues(prop).isEmpty() || r2.getValues(prop) != null && !r2.getValues(prop).isEmpty())) continue;
            System.out.println(prop);
            System.out.println("  " + PrintMatchListener.value(r1, prop));
            System.out.println("  " + PrintMatchListener.value(r2, prop));
        }
    }

    public static void prettyPrint(Record r, List<Property> props) {
        for (Property p : props) {
            String prop = p.getName();
            if (r.getValues(prop) == null || r.getValues(prop).isEmpty()) continue;
            System.out.println(prop + ": " + PrintMatchListener.value(r, prop));
        }
    }

    public static void htmlCompare(Record r1, Record r2, double confidence, String heading, List<Property> props) {
        System.out.println("<p>" + heading + " " + confidence + "</p>");
        System.out.println("<table>");
        for (Property p : props) {
            String prop = p.getName();
            if (!(r1.getValues(prop) != null && !r1.getValues(prop).isEmpty() || r2.getValues(prop) != null && !r2.getValues(prop).isEmpty())) continue;
            System.out.println("<tr><td>" + prop);
            System.out.println("<td>" + PrintMatchListener.value(r1, prop));
            System.out.println("<td>" + PrintMatchListener.value(r2, prop));
        }
        System.out.println("</table>");
    }

    private static String value(Record r, String p) {
        Collection<String> vs = r.getValues(p);
        if (vs == null) {
            return "<null>";
        }
        if (vs.isEmpty()) {
            return "<null>";
        }
        StringBuffer buf = new StringBuffer();
        for (String v : vs) {
            buf.append("'");
            buf.append(v);
            buf.append("', ");
        }
        return buf.toString();
    }
}

