from setuptools import setup

name = "types-contextvars"
description = "Typing stubs for contextvars"
long_description = '''
## Typing stubs for contextvars

This is a PEP 561 type stub package for the `contextvars` package.
It can be used by type-checking tools like mypy, PyCharm, pytype etc. to check code
that uses `contextvars`. The source for this package can be found at
https://github.com/python/typeshed/tree/master/stubs/contextvars. All fixes for
types and metadata should be contributed there.

See https://github.com/python/typeshed/blob/master/README.md for more details.
This package was generated from typeshed commit `61361ce059bf5b6e1f19a3404590ca2b52267bd1`.
'''.lstrip()

setup(name=name,
      version="2.4.3",
      description=description,
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="https://github.com/python/typeshed",
      project_urls={
          "GitHub": "https://github.com/python/typeshed",
          "Changes": "https://github.com/typeshed-internal/stub_uploader/blob/main/data/changelogs/contextvars.md",
          "Issue tracker": "https://github.com/python/typeshed/issues",
          "Chat": "https://gitter.im/python/typing",
      },
      install_requires=[],
      packages=['contextvars-stubs'],
      package_data={'contextvars-stubs': ['__init__.pyi', 'METADATA.toml']},
      license="Apache-2.0 license",
      classifiers=[
          "License :: OSI Approved :: Apache Software License",
          "Typing :: Stubs Only",
      ]
)
