# -----------------
# GENERAL
# -----------------
NUMBER_OF_PROBLEMS = 1

# -----------------
# INPUT
# -----------------
INPUT_POSITION_DIM = 2
INPUT_MOTOR_DIM = 4
INPUT_SENSOR_DIM = 16        # 16
INPUT_ACCELERATION_DIM = 2
INPUT_DIM = INPUT_POSITION_DIM + INPUT_MOTOR_DIM + INPUT_SENSOR_DIM + INPUT_ACCELERATION_DIM

POSITION_DIM_START = 0
POSITION_DIM_END = POSITION_DIM_START + INPUT_POSITION_DIM
MOTOR_DIM_START = POSITION_DIM_END
MOTOR_DIM_END = MOTOR_DIM_START + INPUT_MOTOR_DIM
SENSOR_DIM_START = MOTOR_DIM_END
SENSOR_DIM_END = SENSOR_DIM_START + INPUT_SENSOR_DIM
ACCELERATION_DIM_START = SENSOR_DIM_END
ACCELERATION_DIM_END = ACCELERATION_DIM_START + INPUT_ACCELERATION_DIM
MIN_MOTOR_VALUE = 0
MAX_MOTOR_VALUE = 1

# -----------------
# OUTPUT
# -----------------
OUTPUT_POSITION_DIM = 2
OUTPUT_SENSOR_DIM = INPUT_SENSOR_DIM                # INPUT_SENSOR_DIM or 0
OUTPUT_ACCELERATION_DIM = INPUT_ACCELERATION_DIM     # 0 if acceleration should not be predicted
OUTPUT_DIM = OUTPUT_POSITION_DIM + OUTPUT_SENSOR_DIM + OUTPUT_ACCELERATION_DIM

OUTPUT_POSITION_DIM_START = 0
OUTPUT_POSITION_DIM_END = OUTPUT_POSITION_DIM_START + OUTPUT_POSITION_DIM
OUTPUT_SENSOR_DIM_START = OUTPUT_POSITION_DIM_END
OUTPUT_SENSOR_DIM_END = OUTPUT_SENSOR_DIM_START + OUTPUT_SENSOR_DIM
OUTPUT_ACCELERATION_DIM_START = OUTPUT_SENSOR_DIM_END
OUTPUT_ACCELERATION_DIM_END = OUTPUT_ACCELERATION_DIM_START + OUTPUT_ACCELERATION_DIM

#------------------
# PLOT
#------------------
SHOW_SENSOR_PLOT = False


# -----------------
# PROXIMITY SENSORS
# -----------------
MAX_DISTANCE = 10        # times the radius

# Point spread function
POINT_SPREAD = True
POINT_SPREAD_TYPE = 'gauss' # or linear
SPREADSIZE = 0.1  # 0.2 means the signal decreases by 0.2 times the number of sensors per sensor
SIGMA = 1.0  # Sigma for Gaussian distribution

BORDER_PROXIMITY_WEIGHT = 0.5   # 0.5

USE_SENSOR_SENSITIVITY = False
LEARN_SENSOR_SENSITIVITY = False
