Ansible documentation
=====================

This project hosts the source behind the general pages of [docs.ansible.com](https://docs.ansible.com/). Module-specific documentation is hosted in the various collections repositories. See [Ansible Galaxy](https://galaxy.ansible.com/), the list of [Ansible-maintained collections](https://docs.ansible.com/ansible/devel/community/contributing_maintained_collections.html), and the [ansible-collections organization](https://github.com/ansible-collections) for collections sources.

To create clear, concise, and consistent contributions to Ansible documentation, please refer to the following information.

Contributions
=============
Contributions to the documentation are welcome.

The Ansible community produces guidance on contributions, building documentation, and submitting pull requests, which you can find in [Contributing to the Ansible Documentation](https://docs.ansible.com/ansible/latest/community/documentation_contributions.html).

You can also join the [Docs Working Group](https://github.com/ansible/community/wiki/Docs) and/or the ``#ansible-docs`` channel on freenode IRC.

Ansible style guide
===================
Ansible documentation is written in ReStructuredText(RST). The [Ansible style guide](https://docs.ansible.com/ansible/latest/dev_guide/style_guide/index.html#linguistic-guidelines) provides linguistic direction and technical guidelines for working with reStructuredText, in addition to other resources.

Tools
=====
The Ansible community uses a range of tools and programs for working with Ansible documentation. Learn more about [Other Tools and Programs](https://docs.ansible.com/ansible/latest/community/other_tools_and_programs.html#popular-editors) in the Ansible Community Guide.

GitHub
======
[Ansible documentation](https://github.com/ansible/ansible/tree/devel/docs/docsite) is hosted on the Ansible GitHub project and various collection repositories, especially those in the [ansible-collections organization](https://github.com/ansible-collections). For general GitHub workflows and other information, see the [GitHub Guides](https://guides.github.com/).
