#!/usr/bin/python

# Copyright: (c) 2021, Ansible Project
# GNU General Public License v3.0+ (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import sys

from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.common.respawn import respawn_module, has_respawned


def main():
    mod = AnsibleModule(argument_spec=dict(
        mode=dict(required=True, choices=['multi_respawn', 'no_respawn', 'respawn'])
    ))

    # just return info about what interpreter we're currently running under
    if mod.params['mode'] == 'no_respawn':
        mod.exit_json(interpreter_path=sys.executable)
    elif mod.params['mode'] == 'respawn':
        if not has_respawned():
            new_interpreter = os.path.join(mod.tmpdir, 'anotherpython')
            os.symlink(sys.executable, new_interpreter)
            respawn_module(interpreter_path=new_interpreter)

            # respawn should always exit internally- if we continue executing here, it's a bug
            raise Exception('FAIL, should never reach this line')
        else:
            # return the current interpreter, as well as a signal that we created a different one
            mod.exit_json(created_interpreter=sys.executable, interpreter_path=sys.executable)
    elif mod.params['mode'] == 'multi_respawn':
        # blindly respawn with the current interpreter, the second time should bomb
        respawn_module(sys.executable)

    # shouldn't be any way for us to fall through, but just in case, that's also a bug
    raise Exception('FAIL, should never reach this code')


if __name__ == '__main__':
    main()
