<a id="mypy-boto3-shield"></a>

# mypy-boto3-shield

[![PyPI - mypy-boto3-shield](https://img.shields.io/pypi/v/mypy-boto3-shield.svg?color=blue)](https://pypi.org/project/mypy-boto3-shield)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-shield.svg?color=blue)](https://pypi.org/project/mypy-boto3-shield)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-shield?color=blue)](https://pypistats.org/packages/mypy-boto3-shield)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Shield 1.19.1](https://boto3.amazonaws.com/v1/documentation/api/1.19.1/reference/services/shield.html#Shield)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-shield docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_shield/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-shield](#mypy-boto3-shield)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Shield` service.

```bash
python -m pip install boto3-stubs[shield]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[shield]` in your environment:
  `python -m pip install 'boto3-stubs[shield]'`

Both type checking and auto-complete should work for `Shield` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[shield]` in your environment:
  `python -m pip install 'boto3-stubs[shield]'`

Both type checking and auto-complete should work for `Shield` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[shield]` in your environment:
  `python -m pip install 'boto3-stubs[shield]'`
- Run `mypy` as usual

Type checking should work for `Shield` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[shield]` in your environment:
  `python -m pip install 'boto3-stubs[shield]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Shield` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ShieldClient` provides annotations for `boto3.client("shield")`.

```python
import boto3

from mypy_boto3_shield import ShieldClient

client: ShieldClient = boto3.client("shield")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ShieldClient = session.client("shield")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_shield.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_shield import ShieldClient
from mypy_boto3_shield.paginator import (
    ListAttacksPaginator,
    ListProtectionsPaginator,
)

client: ShieldClient = boto3.client("shield")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_attacks_paginator: ListAttacksPaginator = client.get_paginator("list_attacks")
list_protections_paginator: ListProtectionsPaginator = client.get_paginator("list_protections")
```

<a id="literals"></a>

### Literals

`mypy_boto3_shield.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_shield.literals import (
    AttackLayerType,
    AttackPropertyIdentifierType,
    AutoRenewType,
    ListAttacksPaginatorName,
    ListProtectionsPaginatorName,
    ProactiveEngagementStatusType,
    ProtectedResourceTypeType,
    ProtectionGroupAggregationType,
    ProtectionGroupPatternType,
    SubResourceTypeType,
    SubscriptionStateType,
    UnitType,
    ServiceName,
    PaginatorName,
)

def check_value(value: AttackLayerType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_shield.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_shield.type_defs import (
    AssociateDRTLogBucketRequestRequestTypeDef,
    AssociateDRTRoleRequestRequestTypeDef,
    AssociateHealthCheckRequestRequestTypeDef,
    AssociateProactiveEngagementDetailsRequestRequestTypeDef,
    AttackDetailTypeDef,
    AttackPropertyTypeDef,
    AttackStatisticsDataItemTypeDef,
    AttackSummaryTypeDef,
    AttackVectorDescriptionTypeDef,
    AttackVolumeStatisticsTypeDef,
    AttackVolumeTypeDef,
    ContributorTypeDef,
    CreateProtectionGroupRequestRequestTypeDef,
    CreateProtectionRequestRequestTypeDef,
    CreateProtectionResponseTypeDef,
    DeleteProtectionGroupRequestRequestTypeDef,
    DeleteProtectionRequestRequestTypeDef,
    DescribeAttackRequestRequestTypeDef,
    DescribeAttackResponseTypeDef,
    DescribeAttackStatisticsResponseTypeDef,
    DescribeDRTAccessResponseTypeDef,
    DescribeEmergencyContactSettingsResponseTypeDef,
    DescribeProtectionGroupRequestRequestTypeDef,
    DescribeProtectionGroupResponseTypeDef,
    DescribeProtectionRequestRequestTypeDef,
    DescribeProtectionResponseTypeDef,
    DescribeSubscriptionResponseTypeDef,
    DisassociateDRTLogBucketRequestRequestTypeDef,
    DisassociateHealthCheckRequestRequestTypeDef,
    EmergencyContactTypeDef,
    GetSubscriptionStateResponseTypeDef,
    LimitTypeDef,
    ListAttacksRequestRequestTypeDef,
    ListAttacksResponseTypeDef,
    ListProtectionGroupsRequestRequestTypeDef,
    ListProtectionGroupsResponseTypeDef,
    ListProtectionsRequestRequestTypeDef,
    ListProtectionsResponseTypeDef,
    ListResourcesInProtectionGroupRequestRequestTypeDef,
    ListResourcesInProtectionGroupResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MitigationTypeDef,
    PaginatorConfigTypeDef,
    ProtectionGroupArbitraryPatternLimitsTypeDef,
    ProtectionGroupLimitsTypeDef,
    ProtectionGroupPatternTypeLimitsTypeDef,
    ProtectionGroupTypeDef,
    ProtectionLimitsTypeDef,
    ProtectionTypeDef,
    ResponseMetadataTypeDef,
    SubResourceSummaryTypeDef,
    SubscriptionLimitsTypeDef,
    SubscriptionTypeDef,
    SummarizedAttackVectorTypeDef,
    SummarizedCounterTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TimeRangeTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateEmergencyContactSettingsRequestRequestTypeDef,
    UpdateProtectionGroupRequestRequestTypeDef,
    UpdateSubscriptionRequestRequestTypeDef,
)

def get_structure() -> AssociateDRTLogBucketRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-shield` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-shield docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_shield/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
