import unittest
import tkinter
import yaml

from tksugar.generator import Generator
from tksugar.widgets import GeneratorSupport

class TestChildObject(object):
  def __init__(self, a):
    self.a = a

class TestOwner(GeneratorSupport):
  def __init__(self):
    self.children = []

  def append_child(self, child, **params):
    self.children.append({
      "obj": child,
      "param": params
    })

class Test_GeneratorSupport(unittest.TestCase):
  """
  Tests the `GeneratorSupport` Class

  Note: We're using a test class here to test the behavior, but we're using the
  Because of the import, the class name of the object generated by the Generator and the class name of the test class that can be referenced internally are different.
  Therefore, this test class cannot match the value of `type(actual) is expected`.
  """

  def test_append_child(self):
    """
    When the `Generator#generate()` method is called with the following conditions
    Make sure that the child object calls the `GeneratorSupport#append_child()` of the owner object.
    * The owner object implements `GeneratorSupport#append_child()`.
    """
    obj = Generator(file="tests/definition/generator_test/support_haschild.yml", modules=["tests.test_generatorsupport"]).generate()
    self.assertEqual(obj.__class__.__name__, "TestOwner")
    self.assertEqual(obj.children[0]["obj"].__class__.__name__, "TestChildObject")
    self.assertEqual(obj.children[0]["obj"].a, 1)
    self.assertEqual(obj.children[0]["param"]["a"], 1)
    self.assertEqual(obj.children[0]["param"]["b"], "a")

if __name__ == "__main__":
  unittest.main()