# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sib_api_v3_sdk.api_client import ApiClient


class AttributesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_attribute(self, attribute_category, attribute_name, create_attribute, **kwargs):  # noqa: E501
        """Create contact attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_attribute(attribute_category, attribute_name, create_attribute, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attribute_category: Category of the attribute (required)
        :param str attribute_name: Name of the attribute (required)
        :param CreateAttribute create_attribute: Values to create an attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_attribute_with_http_info(attribute_category, attribute_name, create_attribute, **kwargs)  # noqa: E501
        else:
            (data) = self.create_attribute_with_http_info(attribute_category, attribute_name, create_attribute, **kwargs)  # noqa: E501
            return data

    def create_attribute_with_http_info(self, attribute_category, attribute_name, create_attribute, **kwargs):  # noqa: E501
        """Create contact attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_attribute_with_http_info(attribute_category, attribute_name, create_attribute, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attribute_category: Category of the attribute (required)
        :param str attribute_name: Name of the attribute (required)
        :param CreateAttribute create_attribute: Values to create an attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attribute_category', 'attribute_name', 'create_attribute']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attribute_category' is set
        if ('attribute_category' not in params or
                params['attribute_category'] is None):
            raise ValueError("Missing the required parameter `attribute_category` when calling `create_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_name' is set
        if ('attribute_name' not in params or
                params['attribute_name'] is None):
            raise ValueError("Missing the required parameter `attribute_name` when calling `create_attribute`")  # noqa: E501
        # verify the required parameter 'create_attribute' is set
        if ('create_attribute' not in params or
                params['create_attribute'] is None):
            raise ValueError("Missing the required parameter `create_attribute` when calling `create_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attribute_category' in params:
            path_params['attributeCategory'] = params['attribute_category']  # noqa: E501
        if 'attribute_name' in params:
            path_params['attributeName'] = params['attribute_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_attribute' in params:
            body_params = params['create_attribute']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/contacts/attributes/{attributeCategory}/{attributeName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_attribute(self, attribute_category, attribute_name, **kwargs):  # noqa: E501
        """Delete an attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_attribute(attribute_category, attribute_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attribute_category: Category of the attribute (required)
        :param str attribute_name: Name of the existing attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_attribute_with_http_info(attribute_category, attribute_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_attribute_with_http_info(attribute_category, attribute_name, **kwargs)  # noqa: E501
            return data

    def delete_attribute_with_http_info(self, attribute_category, attribute_name, **kwargs):  # noqa: E501
        """Delete an attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_attribute_with_http_info(attribute_category, attribute_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attribute_category: Category of the attribute (required)
        :param str attribute_name: Name of the existing attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attribute_category', 'attribute_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attribute_category' is set
        if ('attribute_category' not in params or
                params['attribute_category'] is None):
            raise ValueError("Missing the required parameter `attribute_category` when calling `delete_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_name' is set
        if ('attribute_name' not in params or
                params['attribute_name'] is None):
            raise ValueError("Missing the required parameter `attribute_name` when calling `delete_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attribute_category' in params:
            path_params['attributeCategory'] = params['attribute_category']  # noqa: E501
        if 'attribute_name' in params:
            path_params['attributeName'] = params['attribute_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/contacts/attributes/{attributeCategory}/{attributeName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_attributes(self, **kwargs):  # noqa: E501
        """List all attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attributes(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetAttributes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_attributes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_attributes_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_attributes_with_http_info(self, **kwargs):  # noqa: E501
        """List all attributes  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_attributes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: GetAttributes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_attributes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/contacts/attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAttributes',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_attribute(self, attribute_category, attribute_name, update_attribute, **kwargs):  # noqa: E501
        """Update contact attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_attribute(attribute_category, attribute_name, update_attribute, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attribute_category: Category of the attribute (required)
        :param str attribute_name: Name of the existing attribute (required)
        :param UpdateAttribute update_attribute: Values to update an attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_attribute_with_http_info(attribute_category, attribute_name, update_attribute, **kwargs)  # noqa: E501
        else:
            (data) = self.update_attribute_with_http_info(attribute_category, attribute_name, update_attribute, **kwargs)  # noqa: E501
            return data

    def update_attribute_with_http_info(self, attribute_category, attribute_name, update_attribute, **kwargs):  # noqa: E501
        """Update contact attribute  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_attribute_with_http_info(attribute_category, attribute_name, update_attribute, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str attribute_category: Category of the attribute (required)
        :param str attribute_name: Name of the existing attribute (required)
        :param UpdateAttribute update_attribute: Values to update an attribute (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attribute_category', 'attribute_name', 'update_attribute']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'attribute_category' is set
        if ('attribute_category' not in params or
                params['attribute_category'] is None):
            raise ValueError("Missing the required parameter `attribute_category` when calling `update_attribute`")  # noqa: E501
        # verify the required parameter 'attribute_name' is set
        if ('attribute_name' not in params or
                params['attribute_name'] is None):
            raise ValueError("Missing the required parameter `attribute_name` when calling `update_attribute`")  # noqa: E501
        # verify the required parameter 'update_attribute' is set
        if ('update_attribute' not in params or
                params['update_attribute'] is None):
            raise ValueError("Missing the required parameter `update_attribute` when calling `update_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'attribute_category' in params:
            path_params['attributeCategory'] = params['attribute_category']  # noqa: E501
        if 'attribute_name' in params:
            path_params['attributeName'] = params['attribute_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_attribute' in params:
            body_params = params['update_attribute']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/contacts/attributes/{attributeCategory}/{attributeName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
