# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sib_api_v3_sdk.api_client import ApiClient


class ResellerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_credits(self, child_identifier, add_credits, **kwargs):  # noqa: E501
        """Add Email and/or SMS credits to a specific child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_credits(child_identifier, add_credits, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param AddCredits add_credits: Values to post to add credit to a specific child account (required)
        :return: RemainingCreditModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_credits_with_http_info(child_identifier, add_credits, **kwargs)  # noqa: E501
        else:
            (data) = self.add_credits_with_http_info(child_identifier, add_credits, **kwargs)  # noqa: E501
            return data

    def add_credits_with_http_info(self, child_identifier, add_credits, **kwargs):  # noqa: E501
        """Add Email and/or SMS credits to a specific child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_credits_with_http_info(child_identifier, add_credits, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param AddCredits add_credits: Values to post to add credit to a specific child account (required)
        :return: RemainingCreditModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'add_credits']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_credits" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `add_credits`")  # noqa: E501
        # verify the required parameter 'add_credits' is set
        if ('add_credits' not in params or
                params['add_credits'] is None):
            raise ValueError("Missing the required parameter `add_credits` when calling `add_credits`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_credits' in params:
            body_params = params['add_credits']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/credits/add', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemainingCreditModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def associate_ip_to_child(self, child_identifier, ip, **kwargs):  # noqa: E501
        """Associate a dedicated IP to the child  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.associate_ip_to_child(child_identifier, ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param ManageIp ip: IP to associate (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.associate_ip_to_child_with_http_info(child_identifier, ip, **kwargs)  # noqa: E501
        else:
            (data) = self.associate_ip_to_child_with_http_info(child_identifier, ip, **kwargs)  # noqa: E501
            return data

    def associate_ip_to_child_with_http_info(self, child_identifier, ip, **kwargs):  # noqa: E501
        """Associate a dedicated IP to the child  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.associate_ip_to_child_with_http_info(child_identifier, ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param ManageIp ip: IP to associate (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method associate_ip_to_child" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `associate_ip_to_child`")  # noqa: E501
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `associate_ip_to_child`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ip' in params:
            body_params = params['ip']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/ips/associate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_child_domain(self, child_identifier, add_child_domain, **kwargs):  # noqa: E501
        """Create a domain for a child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_child_domain(child_identifier, add_child_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param AddChildDomain add_child_domain: Sender domain to add for a specific child account. This will not be displayed to the parent account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_child_domain_with_http_info(child_identifier, add_child_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.create_child_domain_with_http_info(child_identifier, add_child_domain, **kwargs)  # noqa: E501
            return data

    def create_child_domain_with_http_info(self, child_identifier, add_child_domain, **kwargs):  # noqa: E501
        """Create a domain for a child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_child_domain_with_http_info(child_identifier, add_child_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param AddChildDomain add_child_domain: Sender domain to add for a specific child account. This will not be displayed to the parent account. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'add_child_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_child_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `create_child_domain`")  # noqa: E501
        # verify the required parameter 'add_child_domain' is set
        if ('add_child_domain' not in params or
                params['add_child_domain'] is None):
            raise ValueError("Missing the required parameter `add_child_domain` when calling `create_child_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_child_domain' in params:
            body_params = params['add_child_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/domains', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_reseller_child(self, **kwargs):  # noqa: E501
        """Creates a reseller child  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_reseller_child(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateChild reseller_child: reseller child to add
        :return: CreateReseller
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_reseller_child_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.create_reseller_child_with_http_info(**kwargs)  # noqa: E501
            return data

    def create_reseller_child_with_http_info(self, **kwargs):  # noqa: E501
        """Creates a reseller child  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_reseller_child_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateChild reseller_child: reseller child to add
        :return: CreateReseller
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['reseller_child']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_reseller_child" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reseller_child' in params:
            body_params = params['reseller_child']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateReseller',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_child_domain(self, child_identifier, domain_name, **kwargs):  # noqa: E501
        """Delete the sender domain of the reseller child based on the childIdentifier and domainName passed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_child_domain(child_identifier, domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param str domain_name: Pass the existing domain that needs to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_child_domain_with_http_info(child_identifier, domain_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_child_domain_with_http_info(child_identifier, domain_name, **kwargs)  # noqa: E501
            return data

    def delete_child_domain_with_http_info(self, child_identifier, domain_name, **kwargs):  # noqa: E501
        """Delete the sender domain of the reseller child based on the childIdentifier and domainName passed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_child_domain_with_http_info(child_identifier, domain_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param str domain_name: Pass the existing domain that needs to be deleted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'domain_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_child_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `delete_child_domain`")  # noqa: E501
        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params or
                params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `delete_child_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/domains/{domainName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_reseller_child(self, child_identifier, **kwargs):  # noqa: E501
        """Delete a single reseller child based on the child identifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reseller_child(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or child id of reseller's child (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_reseller_child_with_http_info(child_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_reseller_child_with_http_info(child_identifier, **kwargs)  # noqa: E501
            return data

    def delete_reseller_child_with_http_info(self, child_identifier, **kwargs):  # noqa: E501
        """Delete a single reseller child based on the child identifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_reseller_child_with_http_info(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or child id of reseller's child (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_reseller_child" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `delete_reseller_child`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def dissociate_ip_from_child(self, child_identifier, ip, **kwargs):  # noqa: E501
        """Dissociate a dedicated IP to the child  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dissociate_ip_from_child(child_identifier, ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param ManageIp ip: IP to dissociate (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.dissociate_ip_from_child_with_http_info(child_identifier, ip, **kwargs)  # noqa: E501
        else:
            (data) = self.dissociate_ip_from_child_with_http_info(child_identifier, ip, **kwargs)  # noqa: E501
            return data

    def dissociate_ip_from_child_with_http_info(self, child_identifier, ip, **kwargs):  # noqa: E501
        """Dissociate a dedicated IP to the child  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dissociate_ip_from_child_with_http_info(child_identifier, ip, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param ManageIp ip: IP to dissociate (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'ip']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dissociate_ip_from_child" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `dissociate_ip_from_child`")  # noqa: E501
        # verify the required parameter 'ip' is set
        if ('ip' not in params or
                params['ip'] is None):
            raise ValueError("Missing the required parameter `ip` when calling `dissociate_ip_from_child`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'ip' in params:
            body_params = params['ip']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/ips/dissociate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_child_account_creation_status(self, child_identifier, **kwargs):  # noqa: E501
        """Get the status of a reseller's child account creation, whether it is successfully created (exists) or not based on the identifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_child_account_creation_status(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetChildAccountCreationStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_child_account_creation_status_with_http_info(child_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_child_account_creation_status_with_http_info(child_identifier, **kwargs)  # noqa: E501
            return data

    def get_child_account_creation_status_with_http_info(self, child_identifier, **kwargs):  # noqa: E501
        """Get the status of a reseller's child account creation, whether it is successfully created (exists) or not based on the identifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_child_account_creation_status_with_http_info(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetChildAccountCreationStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_child_account_creation_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `get_child_account_creation_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/accountCreationStatus', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetChildAccountCreationStatus',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_child_domains(self, child_identifier, **kwargs):  # noqa: E501
        """Get all sender domains for a specific child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_child_domains(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetChildDomains
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_child_domains_with_http_info(child_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_child_domains_with_http_info(child_identifier, **kwargs)  # noqa: E501
            return data

    def get_child_domains_with_http_info(self, child_identifier, **kwargs):  # noqa: E501
        """Get all sender domains for a specific child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_child_domains_with_http_info(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetChildDomains
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_child_domains" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `get_child_domains`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/domains', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetChildDomains',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_child_info(self, child_identifier, **kwargs):  # noqa: E501
        """Get a child account's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_child_info(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetChildInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_child_info_with_http_info(child_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_child_info_with_http_info(child_identifier, **kwargs)  # noqa: E501
            return data

    def get_child_info_with_http_info(self, child_identifier, **kwargs):  # noqa: E501
        """Get a child account's details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_child_info_with_http_info(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetChildInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_child_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `get_child_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetChildInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_reseller_childs(self, **kwargs):  # noqa: E501
        """Get the list of all children accounts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reseller_childs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents for child accounts information per page
        :param int offset: Index of the first document in the page
        :return: GetChildrenList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_reseller_childs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_reseller_childs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_reseller_childs_with_http_info(self, **kwargs):  # noqa: E501
        """Get the list of all children accounts  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_reseller_childs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Number of documents for child accounts information per page
        :param int offset: Index of the first document in the page
        :return: GetChildrenList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_reseller_childs" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 20:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_reseller_childs`, must be a value less than or equal to `20`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetChildrenList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sso_token(self, child_identifier, **kwargs):  # noqa: E501
        """Get session token to access Sendinblue (SSO)  # noqa: E501

        It returns a session [token] which will remain valid for a short period of time. A child account will be able to access a white-labeled section by using the following url pattern => https:/email.mydomain.com/login/sso?token=[token]  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sso_token(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetSsoToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sso_token_with_http_info(child_identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sso_token_with_http_info(child_identifier, **kwargs)  # noqa: E501
            return data

    def get_sso_token_with_http_info(self, child_identifier, **kwargs):  # noqa: E501
        """Get session token to access Sendinblue (SSO)  # noqa: E501

        It returns a session [token] which will remain valid for a short period of time. A child account will be able to access a white-labeled section by using the following url pattern => https:/email.mydomain.com/login/sso?token=[token]  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sso_token_with_http_info(child_identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :return: GetSsoToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sso_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `get_sso_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/auth', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSsoToken',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_credits(self, child_identifier, remove_credits, **kwargs):  # noqa: E501
        """Remove Email and/or SMS credits from a specific child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_credits(child_identifier, remove_credits, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param RemoveCredits remove_credits: Values to post to remove email or SMS credits from a specific child account (required)
        :return: RemainingCreditModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_credits_with_http_info(child_identifier, remove_credits, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_credits_with_http_info(child_identifier, remove_credits, **kwargs)  # noqa: E501
            return data

    def remove_credits_with_http_info(self, child_identifier, remove_credits, **kwargs):  # noqa: E501
        """Remove Email and/or SMS credits from a specific child account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_credits_with_http_info(child_identifier, remove_credits, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param RemoveCredits remove_credits: Values to post to remove email or SMS credits from a specific child account (required)
        :return: RemainingCreditModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'remove_credits']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_credits" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `remove_credits`")  # noqa: E501
        # verify the required parameter 'remove_credits' is set
        if ('remove_credits' not in params or
                params['remove_credits'] is None):
            raise ValueError("Missing the required parameter `remove_credits` when calling `remove_credits`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'remove_credits' in params:
            body_params = params['remove_credits']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/credits/remove', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RemainingCreditModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_child_account_status(self, child_identifier, update_child_account_status, **kwargs):  # noqa: E501
        """Update info of reseller's child account status based on the childIdentifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_child_account_status(child_identifier, update_child_account_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param UpdateChildAccountStatus update_child_account_status: values to update in child account status (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_child_account_status_with_http_info(child_identifier, update_child_account_status, **kwargs)  # noqa: E501
        else:
            (data) = self.update_child_account_status_with_http_info(child_identifier, update_child_account_status, **kwargs)  # noqa: E501
            return data

    def update_child_account_status_with_http_info(self, child_identifier, update_child_account_status, **kwargs):  # noqa: E501
        """Update info of reseller's child account status based on the childIdentifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_child_account_status_with_http_info(child_identifier, update_child_account_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param UpdateChildAccountStatus update_child_account_status: values to update in child account status (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'update_child_account_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_child_account_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `update_child_account_status`")  # noqa: E501
        # verify the required parameter 'update_child_account_status' is set
        if ('update_child_account_status' not in params or
                params['update_child_account_status'] is None):
            raise ValueError("Missing the required parameter `update_child_account_status` when calling `update_child_account_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_child_account_status' in params:
            body_params = params['update_child_account_status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/accountStatus', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_child_domain(self, child_identifier, domain_name, update_child_domain, **kwargs):  # noqa: E501
        """Update the sender domain of reseller's child based on the childIdentifier and domainName passed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_child_domain(child_identifier, domain_name, update_child_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param str domain_name: Pass the existing domain that needs to be updated (required)
        :param UpdateChildDomain update_child_domain: value to update for sender domain (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_child_domain_with_http_info(child_identifier, domain_name, update_child_domain, **kwargs)  # noqa: E501
        else:
            (data) = self.update_child_domain_with_http_info(child_identifier, domain_name, update_child_domain, **kwargs)  # noqa: E501
            return data

    def update_child_domain_with_http_info(self, child_identifier, domain_name, update_child_domain, **kwargs):  # noqa: E501
        """Update the sender domain of reseller's child based on the childIdentifier and domainName passed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_child_domain_with_http_info(child_identifier, domain_name, update_child_domain, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param str domain_name: Pass the existing domain that needs to be updated (required)
        :param UpdateChildDomain update_child_domain: value to update for sender domain (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'domain_name', 'update_child_domain']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_child_domain" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `update_child_domain`")  # noqa: E501
        # verify the required parameter 'domain_name' is set
        if ('domain_name' not in params or
                params['domain_name'] is None):
            raise ValueError("Missing the required parameter `domain_name` when calling `update_child_domain`")  # noqa: E501
        # verify the required parameter 'update_child_domain' is set
        if ('update_child_domain' not in params or
                params['update_child_domain'] is None):
            raise ValueError("Missing the required parameter `update_child_domain` when calling `update_child_domain`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501
        if 'domain_name' in params:
            path_params['domainName'] = params['domain_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_child_domain' in params:
            body_params = params['update_child_domain']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}/domains/{domainName}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_reseller_child(self, child_identifier, reseller_child, **kwargs):  # noqa: E501
        """Update info of reseller's child based on the child identifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reseller_child(child_identifier, reseller_child, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param UpdateChild reseller_child: values to update in child profile (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_reseller_child_with_http_info(child_identifier, reseller_child, **kwargs)  # noqa: E501
        else:
            (data) = self.update_reseller_child_with_http_info(child_identifier, reseller_child, **kwargs)  # noqa: E501
            return data

    def update_reseller_child_with_http_info(self, child_identifier, reseller_child, **kwargs):  # noqa: E501
        """Update info of reseller's child based on the child identifier supplied  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_reseller_child_with_http_info(child_identifier, reseller_child, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str child_identifier: Either auth key or id of reseller's child (required)
        :param UpdateChild reseller_child: values to update in child profile (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['child_identifier', 'reseller_child']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_reseller_child" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'child_identifier' is set
        if ('child_identifier' not in params or
                params['child_identifier'] is None):
            raise ValueError("Missing the required parameter `child_identifier` when calling `update_reseller_child`")  # noqa: E501
        # verify the required parameter 'reseller_child' is set
        if ('reseller_child' not in params or
                params['reseller_child'] is None):
            raise ValueError("Missing the required parameter `reseller_child` when calling `update_reseller_child`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'child_identifier' in params:
            path_params['childIdentifier'] = params['child_identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'reseller_child' in params:
            body_params = params['reseller_child']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/reseller/children/{childIdentifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
