# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sib_api_v3_sdk.api_client import ApiClient


class SMSCampaignsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_sms_campaign(self, create_sms_campaign, **kwargs):  # noqa: E501
        """Creates an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sms_campaign(create_sms_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSmsCampaign create_sms_campaign: Values to create an SMS Campaign (required)
        :return: CreateModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_sms_campaign_with_http_info(create_sms_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.create_sms_campaign_with_http_info(create_sms_campaign, **kwargs)  # noqa: E501
            return data

    def create_sms_campaign_with_http_info(self, create_sms_campaign, **kwargs):  # noqa: E501
        """Creates an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_sms_campaign_with_http_info(create_sms_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateSmsCampaign create_sms_campaign: Values to create an SMS Campaign (required)
        :return: CreateModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_sms_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_sms_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_sms_campaign' is set
        if ('create_sms_campaign' not in params or
                params['create_sms_campaign'] is None):
            raise ValueError("Missing the required parameter `create_sms_campaign` when calling `create_sms_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_sms_campaign' in params:
            body_params = params['create_sms_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sms_campaign(self, campaign_id, **kwargs):  # noqa: E501
        """Delete an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sms_campaign(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the SMS campaign (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_sms_campaign_with_http_info(campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sms_campaign_with_http_info(campaign_id, **kwargs)  # noqa: E501
            return data

    def delete_sms_campaign_with_http_info(self, campaign_id, **kwargs):  # noqa: E501
        """Delete an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_sms_campaign_with_http_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the SMS campaign (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sms_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_sms_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sms_campaign(self, campaign_id, **kwargs):  # noqa: E501
        """Get an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sms_campaign(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the SMS campaign (required)
        :return: GetSmsCampaign
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sms_campaign_with_http_info(campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sms_campaign_with_http_info(campaign_id, **kwargs)  # noqa: E501
            return data

    def get_sms_campaign_with_http_info(self, campaign_id, **kwargs):  # noqa: E501
        """Get an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sms_campaign_with_http_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the SMS campaign (required)
        :return: GetSmsCampaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sms_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_sms_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSmsCampaign',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sms_campaigns(self, **kwargs):  # noqa: E501
        """Returns the information for all your created SMS campaigns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sms_campaigns(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status: Status of campaign.
        :param datetime start_date: Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either 'status' not passed and if passed is set to 'sent' )
        :param datetime end_date: Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either 'status' not passed and if passed is set to 'sent' )
        :param int limit: Number limitation for the result returned
        :param int offset: Beginning point in the list to retrieve from.
        :return: GetSmsCampaigns
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sms_campaigns_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sms_campaigns_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sms_campaigns_with_http_info(self, **kwargs):  # noqa: E501
        """Returns the information for all your created SMS campaigns  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sms_campaigns_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str status: Status of campaign.
        :param datetime start_date: Mandatory if endDate is used. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either 'status' not passed and if passed is set to 'sent' )
        :param datetime end_date: Mandatory if startDate is used. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. Prefer to pass your timezone in date-time format for accurate result ( only available if either 'status' not passed and if passed is set to 'sent' )
        :param int limit: Number limitation for the result returned
        :param int offset: Beginning point in the list to retrieve from.
        :return: GetSmsCampaigns
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status', 'start_date', 'end_date', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sms_campaigns" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 1000:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_sms_campaigns`, must be a value less than or equal to `1000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetSmsCampaigns',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_sms_recipient_export(self, campaign_id, **kwargs):  # noqa: E501
        """Export an SMS campaign's recipients  # noqa: E501

        It returns the background process ID which on completion calls the notify URL that you have set in the input.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_sms_recipient_export(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :param RequestSmsRecipientExport recipient_export: Values to send for a recipient export request
        :return: CreatedProcessId
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_sms_recipient_export_with_http_info(campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.request_sms_recipient_export_with_http_info(campaign_id, **kwargs)  # noqa: E501
            return data

    def request_sms_recipient_export_with_http_info(self, campaign_id, **kwargs):  # noqa: E501
        """Export an SMS campaign's recipients  # noqa: E501

        It returns the background process ID which on completion calls the notify URL that you have set in the input.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_sms_recipient_export_with_http_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :param RequestSmsRecipientExport recipient_export: Values to send for a recipient export request
        :return: CreatedProcessId
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'recipient_export']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_sms_recipient_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `request_sms_recipient_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'recipient_export' in params:
            body_params = params['recipient_export']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}/exportRecipients', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreatedProcessId',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_sms_campaign_now(self, campaign_id, **kwargs):  # noqa: E501
        """Send your SMS campaign immediately  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_sms_campaign_now(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_sms_campaign_now_with_http_info(campaign_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_sms_campaign_now_with_http_info(campaign_id, **kwargs)  # noqa: E501
            return data

    def send_sms_campaign_now_with_http_info(self, campaign_id, **kwargs):  # noqa: E501
        """Send your SMS campaign immediately  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_sms_campaign_now_with_http_info(campaign_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_sms_campaign_now" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `send_sms_campaign_now`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}/sendNow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_sms_report(self, campaign_id, send_report, **kwargs):  # noqa: E501
        """Send an SMS campaign's report  # noqa: E501

        Send report of Sent and Archived campaign, to the specified email addresses, with respective data and a pdf attachment in detail.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_sms_report(campaign_id, send_report, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :param SendReport send_report: Values for send a report (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_sms_report_with_http_info(campaign_id, send_report, **kwargs)  # noqa: E501
        else:
            (data) = self.send_sms_report_with_http_info(campaign_id, send_report, **kwargs)  # noqa: E501
            return data

    def send_sms_report_with_http_info(self, campaign_id, send_report, **kwargs):  # noqa: E501
        """Send an SMS campaign's report  # noqa: E501

        Send report of Sent and Archived campaign, to the specified email addresses, with respective data and a pdf attachment in detail.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_sms_report_with_http_info(campaign_id, send_report, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :param SendReport send_report: Values for send a report (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'send_report']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_sms_report" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `send_sms_report`")  # noqa: E501
        # verify the required parameter 'send_report' is set
        if ('send_report' not in params or
                params['send_report'] is None):
            raise ValueError("Missing the required parameter `send_report` when calling `send_sms_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'send_report' in params:
            body_params = params['send_report']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}/sendReport', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_test_sms(self, campaign_id, phone_number, **kwargs):  # noqa: E501
        """Send a test SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_test_sms(campaign_id, phone_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: Id of the SMS campaign (required)
        :param SendTestSms phone_number: Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_test_sms_with_http_info(campaign_id, phone_number, **kwargs)  # noqa: E501
        else:
            (data) = self.send_test_sms_with_http_info(campaign_id, phone_number, **kwargs)  # noqa: E501
            return data

    def send_test_sms_with_http_info(self, campaign_id, phone_number, **kwargs):  # noqa: E501
        """Send a test SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_test_sms_with_http_info(campaign_id, phone_number, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: Id of the SMS campaign (required)
        :param SendTestSms phone_number: Mobile number of the recipient with the country code. This number must belong to one of your contacts in SendinBlue account and must not be blacklisted (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'phone_number']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_test_sms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `send_test_sms`")  # noqa: E501
        # verify the required parameter 'phone_number' is set
        if ('phone_number' not in params or
                params['phone_number'] is None):
            raise ValueError("Missing the required parameter `phone_number` when calling `send_test_sms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'phone_number' in params:
            body_params = params['phone_number']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}/sendTest', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sms_campaign(self, campaign_id, update_sms_campaign, **kwargs):  # noqa: E501
        """Update an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sms_campaign(campaign_id, update_sms_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the SMS campaign (required)
        :param UpdateSmsCampaign update_sms_campaign: Values to update an SMS Campaign (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sms_campaign_with_http_info(campaign_id, update_sms_campaign, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sms_campaign_with_http_info(campaign_id, update_sms_campaign, **kwargs)  # noqa: E501
            return data

    def update_sms_campaign_with_http_info(self, campaign_id, update_sms_campaign, **kwargs):  # noqa: E501
        """Update an SMS campaign  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sms_campaign_with_http_info(campaign_id, update_sms_campaign, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the SMS campaign (required)
        :param UpdateSmsCampaign update_sms_campaign: Values to update an SMS Campaign (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'update_sms_campaign']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sms_campaign" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `update_sms_campaign`")  # noqa: E501
        # verify the required parameter 'update_sms_campaign' is set
        if ('update_sms_campaign' not in params or
                params['update_sms_campaign'] is None):
            raise ValueError("Missing the required parameter `update_sms_campaign` when calling `update_sms_campaign`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_sms_campaign' in params:
            body_params = params['update_sms_campaign']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_sms_campaign_status(self, campaign_id, status, **kwargs):  # noqa: E501
        """Update a campaign's status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sms_campaign_status(campaign_id, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :param UpdateCampaignStatus status: Status of the campaign. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_sms_campaign_status_with_http_info(campaign_id, status, **kwargs)  # noqa: E501
        else:
            (data) = self.update_sms_campaign_status_with_http_info(campaign_id, status, **kwargs)  # noqa: E501
            return data

    def update_sms_campaign_status_with_http_info(self, campaign_id, status, **kwargs):  # noqa: E501
        """Update a campaign's status  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_sms_campaign_status_with_http_info(campaign_id, status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int campaign_id: id of the campaign (required)
        :param UpdateCampaignStatus status: Status of the campaign. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_sms_campaign_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params or
                params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `update_sms_campaign_status`")  # noqa: E501
        # verify the required parameter 'status' is set
        if ('status' not in params or
                params['status'] is None):
            raise ValueError("Missing the required parameter `status` when calling `update_sms_campaign_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'status' in params:
            body_params = params['status']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/smsCampaigns/{campaignId}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
