# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetAccountPlan(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'credits_type': 'str',
        'credits': 'float',
        'start_date': 'date',
        'end_date': 'date',
        'user_limit': 'int'
    }

    attribute_map = {
        'type': 'type',
        'credits_type': 'creditsType',
        'credits': 'credits',
        'start_date': 'startDate',
        'end_date': 'endDate',
        'user_limit': 'userLimit'
    }

    def __init__(self, type=None, credits_type=None, credits=None, start_date=None, end_date=None, user_limit=None):  # noqa: E501
        """GetAccountPlan - a model defined in Swagger"""  # noqa: E501

        self._type = None
        self._credits_type = None
        self._credits = None
        self._start_date = None
        self._end_date = None
        self._user_limit = None
        self.discriminator = None

        self.type = type
        self.credits_type = credits_type
        self.credits = credits
        if start_date is not None:
            self.start_date = start_date
        if end_date is not None:
            self.end_date = end_date
        if user_limit is not None:
            self.user_limit = user_limit

    @property
    def type(self):
        """Gets the type of this GetAccountPlan.  # noqa: E501

        Displays the plan type of the user  # noqa: E501

        :return: The type of this GetAccountPlan.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this GetAccountPlan.

        Displays the plan type of the user  # noqa: E501

        :param type: The type of this GetAccountPlan.  # noqa: E501
        :type: str
        """
        if type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["payAsYouGo", "free", "subscription", "sms", "reseller"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def credits_type(self):
        """Gets the credits_type of this GetAccountPlan.  # noqa: E501

        This is the type of the credit, \"Send Limit\" is one of the possible types of credit of a user. \"Send Limit\" implies the total number of emails you can send to the subscribers in your account.  # noqa: E501

        :return: The credits_type of this GetAccountPlan.  # noqa: E501
        :rtype: str
        """
        return self._credits_type

    @credits_type.setter
    def credits_type(self, credits_type):
        """Sets the credits_type of this GetAccountPlan.

        This is the type of the credit, \"Send Limit\" is one of the possible types of credit of a user. \"Send Limit\" implies the total number of emails you can send to the subscribers in your account.  # noqa: E501

        :param credits_type: The credits_type of this GetAccountPlan.  # noqa: E501
        :type: str
        """
        if credits_type is None:
            raise ValueError("Invalid value for `credits_type`, must not be `None`")  # noqa: E501
        allowed_values = ["sendLimit"]  # noqa: E501
        if credits_type not in allowed_values:
            raise ValueError(
                "Invalid value for `credits_type` ({0}), must be one of {1}"  # noqa: E501
                .format(credits_type, allowed_values)
            )

        self._credits_type = credits_type

    @property
    def credits(self):
        """Gets the credits of this GetAccountPlan.  # noqa: E501

        Remaining credits of the user  # noqa: E501

        :return: The credits of this GetAccountPlan.  # noqa: E501
        :rtype: float
        """
        return self._credits

    @credits.setter
    def credits(self, credits):
        """Sets the credits of this GetAccountPlan.

        Remaining credits of the user  # noqa: E501

        :param credits: The credits of this GetAccountPlan.  # noqa: E501
        :type: float
        """
        if credits is None:
            raise ValueError("Invalid value for `credits`, must not be `None`")  # noqa: E501

        self._credits = credits

    @property
    def start_date(self):
        """Gets the start_date of this GetAccountPlan.  # noqa: E501

        Date of the period from which the plan will start (only available for \"subscription\" and \"reseller\" plan type)  # noqa: E501

        :return: The start_date of this GetAccountPlan.  # noqa: E501
        :rtype: date
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this GetAccountPlan.

        Date of the period from which the plan will start (only available for \"subscription\" and \"reseller\" plan type)  # noqa: E501

        :param start_date: The start_date of this GetAccountPlan.  # noqa: E501
        :type: date
        """

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this GetAccountPlan.  # noqa: E501

        Date of the period from which the plan will end (only available for \"subscription\" and \"reseller\" plan type)  # noqa: E501

        :return: The end_date of this GetAccountPlan.  # noqa: E501
        :rtype: date
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this GetAccountPlan.

        Date of the period from which the plan will end (only available for \"subscription\" and \"reseller\" plan type)  # noqa: E501

        :param end_date: The end_date of this GetAccountPlan.  # noqa: E501
        :type: date
        """

        self._end_date = end_date

    @property
    def user_limit(self):
        """Gets the user_limit of this GetAccountPlan.  # noqa: E501

        Only in case of reseller account. It implies the total number of child accounts you can add to your account.  # noqa: E501

        :return: The user_limit of this GetAccountPlan.  # noqa: E501
        :rtype: int
        """
        return self._user_limit

    @user_limit.setter
    def user_limit(self, user_limit):
        """Sets the user_limit of this GetAccountPlan.

        Only in case of reseller account. It implies the total number of child accounts you can add to your account.  # noqa: E501

        :param user_limit: The user_limit of this GetAccountPlan.  # noqa: E501
        :type: int
        """

        self._user_limit = user_limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetAccountPlan, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetAccountPlan):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
