# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetAccountRelayData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'user_name': 'str',
        'relay': 'str',
        'port': 'int'
    }

    attribute_map = {
        'user_name': 'userName',
        'relay': 'relay',
        'port': 'port'
    }

    def __init__(self, user_name=None, relay=None, port=None):  # noqa: E501
        """GetAccountRelayData - a model defined in Swagger"""  # noqa: E501

        self._user_name = None
        self._relay = None
        self._port = None
        self.discriminator = None

        self.user_name = user_name
        self.relay = relay
        self.port = port

    @property
    def user_name(self):
        """Gets the user_name of this GetAccountRelayData.  # noqa: E501

        Email to use as login on transactional platform  # noqa: E501

        :return: The user_name of this GetAccountRelayData.  # noqa: E501
        :rtype: str
        """
        return self._user_name

    @user_name.setter
    def user_name(self, user_name):
        """Sets the user_name of this GetAccountRelayData.

        Email to use as login on transactional platform  # noqa: E501

        :param user_name: The user_name of this GetAccountRelayData.  # noqa: E501
        :type: str
        """
        if user_name is None:
            raise ValueError("Invalid value for `user_name`, must not be `None`")  # noqa: E501

        self._user_name = user_name

    @property
    def relay(self):
        """Gets the relay of this GetAccountRelayData.  # noqa: E501

        URL of the SMTP Relay  # noqa: E501

        :return: The relay of this GetAccountRelayData.  # noqa: E501
        :rtype: str
        """
        return self._relay

    @relay.setter
    def relay(self, relay):
        """Sets the relay of this GetAccountRelayData.

        URL of the SMTP Relay  # noqa: E501

        :param relay: The relay of this GetAccountRelayData.  # noqa: E501
        :type: str
        """
        if relay is None:
            raise ValueError("Invalid value for `relay`, must not be `None`")  # noqa: E501

        self._relay = relay

    @property
    def port(self):
        """Gets the port of this GetAccountRelayData.  # noqa: E501

        Port used for SMTP Relay  # noqa: E501

        :return: The port of this GetAccountRelayData.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this GetAccountRelayData.

        Port used for SMTP Relay  # noqa: E501

        :param port: The port of this GetAccountRelayData.  # noqa: E501
        :type: int
        """
        if port is None:
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetAccountRelayData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetAccountRelayData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
