# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class GetChildInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'email': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'company_name': 'str',
        'credits': 'GetChildInfoCredits',
        'statistics': 'GetChildInfoStatistics',
        'password': 'str',
        'ips': 'list[str]',
        'api_keys': 'GetChildInfoApiKeys'
    }

    attribute_map = {
        'email': 'email',
        'first_name': 'firstName',
        'last_name': 'lastName',
        'company_name': 'companyName',
        'credits': 'credits',
        'statistics': 'statistics',
        'password': 'password',
        'ips': 'ips',
        'api_keys': 'apiKeys'
    }

    def __init__(self, email=None, first_name=None, last_name=None, company_name=None, credits=None, statistics=None, password=None, ips=None, api_keys=None):  # noqa: E501
        """GetChildInfo - a model defined in Swagger"""  # noqa: E501

        self._email = None
        self._first_name = None
        self._last_name = None
        self._company_name = None
        self._credits = None
        self._statistics = None
        self._password = None
        self._ips = None
        self._api_keys = None
        self.discriminator = None

        self.email = email
        self.first_name = first_name
        self.last_name = last_name
        self.company_name = company_name
        if credits is not None:
            self.credits = credits
        if statistics is not None:
            self.statistics = statistics
        self.password = password
        if ips is not None:
            self.ips = ips
        if api_keys is not None:
            self.api_keys = api_keys

    @property
    def email(self):
        """Gets the email of this GetChildInfo.  # noqa: E501

        Login Email  # noqa: E501

        :return: The email of this GetChildInfo.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this GetChildInfo.

        Login Email  # noqa: E501

        :param email: The email of this GetChildInfo.  # noqa: E501
        :type: str
        """
        if email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def first_name(self):
        """Gets the first_name of this GetChildInfo.  # noqa: E501

        First Name  # noqa: E501

        :return: The first_name of this GetChildInfo.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this GetChildInfo.

        First Name  # noqa: E501

        :param first_name: The first_name of this GetChildInfo.  # noqa: E501
        :type: str
        """
        if first_name is None:
            raise ValueError("Invalid value for `first_name`, must not be `None`")  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this GetChildInfo.  # noqa: E501

        Last Name  # noqa: E501

        :return: The last_name of this GetChildInfo.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this GetChildInfo.

        Last Name  # noqa: E501

        :param last_name: The last_name of this GetChildInfo.  # noqa: E501
        :type: str
        """
        if last_name is None:
            raise ValueError("Invalid value for `last_name`, must not be `None`")  # noqa: E501

        self._last_name = last_name

    @property
    def company_name(self):
        """Gets the company_name of this GetChildInfo.  # noqa: E501

        Name of the company  # noqa: E501

        :return: The company_name of this GetChildInfo.  # noqa: E501
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this GetChildInfo.

        Name of the company  # noqa: E501

        :param company_name: The company_name of this GetChildInfo.  # noqa: E501
        :type: str
        """
        if company_name is None:
            raise ValueError("Invalid value for `company_name`, must not be `None`")  # noqa: E501

        self._company_name = company_name

    @property
    def credits(self):
        """Gets the credits of this GetChildInfo.  # noqa: E501


        :return: The credits of this GetChildInfo.  # noqa: E501
        :rtype: GetChildInfoCredits
        """
        return self._credits

    @credits.setter
    def credits(self, credits):
        """Sets the credits of this GetChildInfo.


        :param credits: The credits of this GetChildInfo.  # noqa: E501
        :type: GetChildInfoCredits
        """

        self._credits = credits

    @property
    def statistics(self):
        """Gets the statistics of this GetChildInfo.  # noqa: E501


        :return: The statistics of this GetChildInfo.  # noqa: E501
        :rtype: GetChildInfoStatistics
        """
        return self._statistics

    @statistics.setter
    def statistics(self, statistics):
        """Sets the statistics of this GetChildInfo.


        :param statistics: The statistics of this GetChildInfo.  # noqa: E501
        :type: GetChildInfoStatistics
        """

        self._statistics = statistics

    @property
    def password(self):
        """Gets the password of this GetChildInfo.  # noqa: E501

        The encrypted password of child account  # noqa: E501

        :return: The password of this GetChildInfo.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this GetChildInfo.

        The encrypted password of child account  # noqa: E501

        :param password: The password of this GetChildInfo.  # noqa: E501
        :type: str
        """
        if password is None:
            raise ValueError("Invalid value for `password`, must not be `None`")  # noqa: E501

        self._password = password

    @property
    def ips(self):
        """Gets the ips of this GetChildInfo.  # noqa: E501

        IP(s) associated to a child account user  # noqa: E501

        :return: The ips of this GetChildInfo.  # noqa: E501
        :rtype: list[str]
        """
        return self._ips

    @ips.setter
    def ips(self, ips):
        """Sets the ips of this GetChildInfo.

        IP(s) associated to a child account user  # noqa: E501

        :param ips: The ips of this GetChildInfo.  # noqa: E501
        :type: list[str]
        """

        self._ips = ips

    @property
    def api_keys(self):
        """Gets the api_keys of this GetChildInfo.  # noqa: E501


        :return: The api_keys of this GetChildInfo.  # noqa: E501
        :rtype: GetChildInfoApiKeys
        """
        return self._api_keys

    @api_keys.setter
    def api_keys(self, api_keys):
        """Sets the api_keys of this GetChildInfo.


        :param api_keys: The api_keys of this GetChildInfo.  # noqa: E501
        :type: GetChildInfoApiKeys
        """

        self._api_keys = api_keys

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetChildInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetChildInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
