import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvgroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Hostnames of the environment group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#hostnames ApigeeEnvgroup#hostnames}
    */
    readonly hostnames?: string[];
    /**
    * The resource ID of the environment group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#name ApigeeEnvgroup#name}
    */
    readonly name: string;
    /**
    * The Apigee Organization associated with the Apigee environment group,
  in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#org_id ApigeeEnvgroup#org_id}
    */
    readonly orgId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#timeouts ApigeeEnvgroup#timeouts}
    */
    readonly timeouts?: ApigeeEnvgroupTimeouts;
}
export interface ApigeeEnvgroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#create ApigeeEnvgroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#delete ApigeeEnvgroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup#update ApigeeEnvgroup#update}
    */
    readonly update?: string;
}
export declare function apigeeEnvgroupTimeoutsToTerraform(struct?: ApigeeEnvgroupTimeoutsOutputReference | ApigeeEnvgroupTimeouts | cdktf.IResolvable): any;
export declare class ApigeeEnvgroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApigeeEnvgroupTimeouts | undefined;
    set internalValue(value: ApigeeEnvgroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup google_apigee_envgroup}
*/
export declare class ApigeeEnvgroup extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup google_apigee_envgroup} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEnvgroupConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEnvgroupConfig);
    private _hostnames?;
    get hostnames(): string[];
    set hostnames(value: string[]);
    resetHostnames(): void;
    get hostnamesInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeEnvgroupTimeoutsOutputReference;
    putTimeouts(value: ApigeeEnvgroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeEnvgroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
