import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeInstanceAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment#environment ApigeeInstanceAttachment#environment}
    */
    readonly environment: string;
    /**
    * The Apigee instance associated with the Apigee environment,
  in the format 'organisations/{{org_name}}/instances/{{instance_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment#instance_id ApigeeInstanceAttachment#instance_id}
    */
    readonly instanceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment#timeouts ApigeeInstanceAttachment#timeouts}
    */
    readonly timeouts?: ApigeeInstanceAttachmentTimeouts;
}
export interface ApigeeInstanceAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment#create ApigeeInstanceAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment#delete ApigeeInstanceAttachment#delete}
    */
    readonly delete?: string;
}
export declare function apigeeInstanceAttachmentTimeoutsToTerraform(struct?: ApigeeInstanceAttachmentTimeoutsOutputReference | ApigeeInstanceAttachmentTimeouts | cdktf.IResolvable): any;
export declare class ApigeeInstanceAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApigeeInstanceAttachmentTimeouts | undefined;
    set internalValue(value: ApigeeInstanceAttachmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment google_apigee_instance_attachment}
*/
export declare class ApigeeInstanceAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_instance_attachment google_apigee_instance_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeInstanceAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeInstanceAttachmentConfig);
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    get id(): string;
    private _instanceId?;
    get instanceId(): string;
    set instanceId(value: string);
    get instanceIdInput(): string | undefined;
    get name(): string;
    private _timeouts;
    get timeouts(): ApigeeInstanceAttachmentTimeoutsOutputReference;
    putTimeouts(value: ApigeeInstanceAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeInstanceAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
