import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AssuredWorkloadsWorkloadConfig extends cdktf.TerraformMetaArguments {
    /**
    * Required. Input only. The billing account used for the resources which are direct children of workload. This billing account is initially associated with the resources created as part of Workload creation. After the initial creation of these resources, the customer can change the assigned billing account. The resource name has the form `billingAccounts/{billing_account_id}`. For example, 'billingAccounts/012345-567890-ABCDEF`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#billing_account AssuredWorkloadsWorkload#billing_account}
    */
    readonly billingAccount: string;
    /**
    * Required. Immutable. Compliance Regime associated with this workload. Possible values: COMPLIANCE_REGIME_UNSPECIFIED, IL4, CJIS, FEDRAMP_HIGH, FEDRAMP_MODERATE, US_REGIONAL_ACCESS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#compliance_regime AssuredWorkloadsWorkload#compliance_regime}
    */
    readonly complianceRegime: string;
    /**
    * Required. The user-assigned display name of the Workload. When present it must be between 4 to 30 characters. Allowed characters are: lowercase and uppercase letters, numbers, hyphen, and spaces. Example: My Workload
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#display_name AssuredWorkloadsWorkload#display_name}
    */
    readonly displayName: string;
    /**
    * Optional. Labels applied to the workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#labels AssuredWorkloadsWorkload#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#location AssuredWorkloadsWorkload#location}
    */
    readonly location: string;
    /**
    * The organization for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#organization AssuredWorkloadsWorkload#organization}
    */
    readonly organization: string;
    /**
    * Input only. The parent resource for the resources managed by this Assured Workload. May be either an organization or a folder. Must be the same or a child of the Workload parent. If not specified all resources are created under the Workload parent. Formats: folders/{folder_id}, organizations/{organization_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#provisioned_resources_parent AssuredWorkloadsWorkload#provisioned_resources_parent}
    */
    readonly provisionedResourcesParent?: string;
    /**
    * kms_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#kms_settings AssuredWorkloadsWorkload#kms_settings}
    */
    readonly kmsSettings?: AssuredWorkloadsWorkloadKmsSettings;
    /**
    * resource_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#resource_settings AssuredWorkloadsWorkload#resource_settings}
    */
    readonly resourceSettings?: AssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#timeouts AssuredWorkloadsWorkload#timeouts}
    */
    readonly timeouts?: AssuredWorkloadsWorkloadTimeouts;
}
export declare class AssuredWorkloadsWorkloadResources extends cdktf.ComplexComputedList {
    get resourceId(): number;
    get resourceType(): string;
}
export interface AssuredWorkloadsWorkloadKmsSettings {
    /**
    * Required. Input only. Immutable. The time at which the Key Management Service will automatically create a new version of the crypto key and mark it as the primary.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#next_rotation_time AssuredWorkloadsWorkload#next_rotation_time}
    */
    readonly nextRotationTime: string;
    /**
    * Required. Input only. Immutable. will be advanced by this period when the Key Management Service automatically rotates a key. Must be at least 24 hours and at most 876,000 hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#rotation_period AssuredWorkloadsWorkload#rotation_period}
    */
    readonly rotationPeriod: string;
}
export declare function assuredWorkloadsWorkloadKmsSettingsToTerraform(struct?: AssuredWorkloadsWorkloadKmsSettingsOutputReference | AssuredWorkloadsWorkloadKmsSettings): any;
export declare class AssuredWorkloadsWorkloadKmsSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AssuredWorkloadsWorkloadKmsSettings | undefined;
    set internalValue(value: AssuredWorkloadsWorkloadKmsSettings | undefined);
    private _nextRotationTime?;
    get nextRotationTime(): string;
    set nextRotationTime(value: string);
    get nextRotationTimeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string;
    set rotationPeriod(value: string);
    get rotationPeriodInput(): string | undefined;
}
export interface AssuredWorkloadsWorkloadResourceSettings {
    /**
    * Resource identifier. For a project this represents project_number. If the project is already taken, the workload creation will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#resource_id AssuredWorkloadsWorkload#resource_id}
    */
    readonly resourceId?: string;
    /**
    * Indicates the type of resource. This field should be specified to correspond the id to the right project type (CONSUMER_PROJECT or ENCRYPTION_KEYS_PROJECT) Possible values: RESOURCE_TYPE_UNSPECIFIED, CONSUMER_PROJECT, ENCRYPTION_KEYS_PROJECT, KEYRING, CONSUMER_FOLDER
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#resource_type AssuredWorkloadsWorkload#resource_type}
    */
    readonly resourceType?: string;
}
export declare function assuredWorkloadsWorkloadResourceSettingsToTerraform(struct?: AssuredWorkloadsWorkloadResourceSettings | cdktf.IResolvable): any;
export interface AssuredWorkloadsWorkloadTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#create AssuredWorkloadsWorkload#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#delete AssuredWorkloadsWorkload#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload#update AssuredWorkloadsWorkload#update}
    */
    readonly update?: string;
}
export declare function assuredWorkloadsWorkloadTimeoutsToTerraform(struct?: AssuredWorkloadsWorkloadTimeoutsOutputReference | AssuredWorkloadsWorkloadTimeouts | cdktf.IResolvable): any;
export declare class AssuredWorkloadsWorkloadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AssuredWorkloadsWorkloadTimeouts | undefined;
    set internalValue(value: AssuredWorkloadsWorkloadTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload google_assured_workloads_workload}
*/
export declare class AssuredWorkloadsWorkload extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/assured_workloads_workload google_assured_workloads_workload} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AssuredWorkloadsWorkloadConfig
    */
    constructor(scope: Construct, id: string, config: AssuredWorkloadsWorkloadConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _complianceRegime?;
    get complianceRegime(): string;
    set complianceRegime(value: string);
    get complianceRegimeInput(): string | undefined;
    get createTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _provisionedResourcesParent?;
    get provisionedResourcesParent(): string;
    set provisionedResourcesParent(value: string);
    resetProvisionedResourcesParent(): void;
    get provisionedResourcesParentInput(): string | undefined;
    resources(index: string): AssuredWorkloadsWorkloadResources;
    private _kmsSettings;
    get kmsSettings(): AssuredWorkloadsWorkloadKmsSettingsOutputReference;
    putKmsSettings(value: AssuredWorkloadsWorkloadKmsSettings): void;
    resetKmsSettings(): void;
    get kmsSettingsInput(): AssuredWorkloadsWorkloadKmsSettings | undefined;
    private _resourceSettings?;
    get resourceSettings(): AssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable;
    set resourceSettings(value: AssuredWorkloadsWorkloadResourceSettings[] | cdktf.IResolvable);
    resetResourceSettings(): void;
    get resourceSettingsInput(): cdktf.IResolvable | AssuredWorkloadsWorkloadResourceSettings[] | undefined;
    private _timeouts;
    get timeouts(): AssuredWorkloadsWorkloadTimeoutsOutputReference;
    putTimeouts(value: AssuredWorkloadsWorkloadTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AssuredWorkloadsWorkloadTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
