import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableGcPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the column family.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#column_family BigtableGcPolicy#column_family}
    */
    readonly columnFamily: string;
    /**
    * The name of the Bigtable instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#instance_name BigtableGcPolicy#instance_name}
    */
    readonly instanceName: string;
    /**
    * If multiple policies are set, you should choose between UNION OR INTERSECTION.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#mode BigtableGcPolicy#mode}
    */
    readonly mode?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#project BigtableGcPolicy#project}
    */
    readonly project?: string;
    /**
    * The name of the table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#table BigtableGcPolicy#table}
    */
    readonly table: string;
    /**
    * max_age block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#max_age BigtableGcPolicy#max_age}
    */
    readonly maxAge?: BigtableGcPolicyMaxAge;
    /**
    * max_version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#max_version BigtableGcPolicy#max_version}
    */
    readonly maxVersion?: BigtableGcPolicyMaxVersion[] | cdktf.IResolvable;
}
export interface BigtableGcPolicyMaxAge {
    /**
    * Number of days before applying GC policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#days BigtableGcPolicy#days}
    */
    readonly days?: number;
    /**
    * Duration before applying GC policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#duration BigtableGcPolicy#duration}
    */
    readonly duration?: string;
}
export declare function bigtableGcPolicyMaxAgeToTerraform(struct?: BigtableGcPolicyMaxAgeOutputReference | BigtableGcPolicyMaxAge): any;
export declare class BigtableGcPolicyMaxAgeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BigtableGcPolicyMaxAge | undefined;
    set internalValue(value: BigtableGcPolicyMaxAge | undefined);
    private _days?;
    get days(): number;
    set days(value: number);
    resetDays(): void;
    get daysInput(): number | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
}
export interface BigtableGcPolicyMaxVersion {
    /**
    * Number of version before applying the GC policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy#number BigtableGcPolicy#number}
    */
    readonly number: number;
}
export declare function bigtableGcPolicyMaxVersionToTerraform(struct?: BigtableGcPolicyMaxVersion | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy google_bigtable_gc_policy}
*/
export declare class BigtableGcPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_gc_policy google_bigtable_gc_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigtableGcPolicyConfig
    */
    constructor(scope: Construct, id: string, config: BigtableGcPolicyConfig);
    private _columnFamily?;
    get columnFamily(): string;
    set columnFamily(value: string);
    get columnFamilyInput(): string | undefined;
    get id(): string;
    private _instanceName?;
    get instanceName(): string;
    set instanceName(value: string);
    get instanceNameInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _maxAge;
    get maxAge(): BigtableGcPolicyMaxAgeOutputReference;
    putMaxAge(value: BigtableGcPolicyMaxAge): void;
    resetMaxAge(): void;
    get maxAgeInput(): BigtableGcPolicyMaxAge | undefined;
    private _maxVersion?;
    get maxVersion(): BigtableGcPolicyMaxVersion[] | cdktf.IResolvable;
    set maxVersion(value: BigtableGcPolicyMaxVersion[] | cdktf.IResolvable);
    resetMaxVersion(): void;
    get maxVersionInput(): cdktf.IResolvable | BigtableGcPolicyMaxVersion[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
