import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BillingBudgetConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the billing account to set a budget on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#billing_account BillingBudget#billing_account}
    */
    readonly billingAccount: string;
    /**
    * User data for display name in UI. Must be <= 60 chars.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#display_name BillingBudget#display_name}
    */
    readonly displayName?: string;
    /**
    * all_updates_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#all_updates_rule BillingBudget#all_updates_rule}
    */
    readonly allUpdatesRule?: BillingBudgetAllUpdatesRule;
    /**
    * amount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#amount BillingBudget#amount}
    */
    readonly amount: BillingBudgetAmount;
    /**
    * budget_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#budget_filter BillingBudget#budget_filter}
    */
    readonly budgetFilter?: BillingBudgetBudgetFilter;
    /**
    * threshold_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#threshold_rules BillingBudget#threshold_rules}
    */
    readonly thresholdRules: BillingBudgetThresholdRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#timeouts BillingBudget#timeouts}
    */
    readonly timeouts?: BillingBudgetTimeouts;
}
export interface BillingBudgetAllUpdatesRule {
    /**
    * Boolean. When set to true, disables default notifications sent
  when a threshold is exceeded. Default recipients are
  those with Billing Account Administrators and Billing
  Account Users IAM roles for the target account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#disable_default_iam_recipients BillingBudget#disable_default_iam_recipients}
    */
    readonly disableDefaultIamRecipients?: boolean | cdktf.IResolvable;
    /**
    * The full resource name of a monitoring notification
  channel in the form
  projects/{project_id}/notificationChannels/{channel_id}.
  A maximum of 5 channels are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#monitoring_notification_channels BillingBudget#monitoring_notification_channels}
    */
    readonly monitoringNotificationChannels?: string[];
    /**
    * The name of the Cloud Pub/Sub topic where budget related
  messages will be published, in the form
  projects/{project_id}/topics/{topic_id}. Updates are sent
  at regular intervals to the topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#pubsub_topic BillingBudget#pubsub_topic}
    */
    readonly pubsubTopic?: string;
    /**
    * The schema version of the notification. Only "1.0" is
  accepted. It represents the JSON schema as defined in
  https://cloud.google.com/billing/docs/how-to/budgets#notification_format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#schema_version BillingBudget#schema_version}
    */
    readonly schemaVersion?: string;
}
export declare function billingBudgetAllUpdatesRuleToTerraform(struct?: BillingBudgetAllUpdatesRuleOutputReference | BillingBudgetAllUpdatesRule): any;
export declare class BillingBudgetAllUpdatesRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BillingBudgetAllUpdatesRule | undefined;
    set internalValue(value: BillingBudgetAllUpdatesRule | undefined);
    private _disableDefaultIamRecipients?;
    get disableDefaultIamRecipients(): boolean | cdktf.IResolvable;
    set disableDefaultIamRecipients(value: boolean | cdktf.IResolvable);
    resetDisableDefaultIamRecipients(): void;
    get disableDefaultIamRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoringNotificationChannels?;
    get monitoringNotificationChannels(): string[];
    set monitoringNotificationChannels(value: string[]);
    resetMonitoringNotificationChannels(): void;
    get monitoringNotificationChannelsInput(): string[] | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    resetPubsubTopic(): void;
    get pubsubTopicInput(): string | undefined;
    private _schemaVersion?;
    get schemaVersion(): string;
    set schemaVersion(value: string);
    resetSchemaVersion(): void;
    get schemaVersionInput(): string | undefined;
}
export interface BillingBudgetAmountSpecifiedAmount {
    /**
    * The 3-letter currency code defined in ISO 4217.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#currency_code BillingBudget#currency_code}
    */
    readonly currencyCode?: string;
    /**
    * Number of nano (10^-9) units of the amount.
  The value must be between -999,999,999 and +999,999,999
  inclusive. If units is positive, nanos must be positive or
  zero. If units is zero, nanos can be positive, zero, or
  negative. If units is negative, nanos must be negative or
  zero. For example $-1.75 is represented as units=-1 and
  nanos=-750,000,000.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#nanos BillingBudget#nanos}
    */
    readonly nanos?: number;
    /**
    * The whole units of the amount. For example if currencyCode
  is "USD", then 1 unit is one US dollar.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#units BillingBudget#units}
    */
    readonly units?: string;
}
export declare function billingBudgetAmountSpecifiedAmountToTerraform(struct?: BillingBudgetAmountSpecifiedAmountOutputReference | BillingBudgetAmountSpecifiedAmount): any;
export declare class BillingBudgetAmountSpecifiedAmountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BillingBudgetAmountSpecifiedAmount | undefined;
    set internalValue(value: BillingBudgetAmountSpecifiedAmount | undefined);
    private _currencyCode?;
    get currencyCode(): string;
    set currencyCode(value: string);
    resetCurrencyCode(): void;
    get currencyCodeInput(): string | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _units?;
    get units(): string;
    set units(value: string);
    resetUnits(): void;
    get unitsInput(): string | undefined;
}
export interface BillingBudgetAmount {
    /**
    * Configures a budget amount that is automatically set to 100% of
  last period's spend.
  Boolean. Set value to true to use. Do not set to false, instead
  use the 'specified_amount' block.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#last_period_amount BillingBudget#last_period_amount}
    */
    readonly lastPeriodAmount?: boolean | cdktf.IResolvable;
    /**
    * specified_amount block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#specified_amount BillingBudget#specified_amount}
    */
    readonly specifiedAmount?: BillingBudgetAmountSpecifiedAmount;
}
export declare function billingBudgetAmountToTerraform(struct?: BillingBudgetAmountOutputReference | BillingBudgetAmount): any;
export declare class BillingBudgetAmountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BillingBudgetAmount | undefined;
    set internalValue(value: BillingBudgetAmount | undefined);
    private _lastPeriodAmount?;
    get lastPeriodAmount(): boolean | cdktf.IResolvable;
    set lastPeriodAmount(value: boolean | cdktf.IResolvable);
    resetLastPeriodAmount(): void;
    get lastPeriodAmountInput(): boolean | cdktf.IResolvable | undefined;
    private _specifiedAmount;
    get specifiedAmount(): BillingBudgetAmountSpecifiedAmountOutputReference;
    putSpecifiedAmount(value: BillingBudgetAmountSpecifiedAmount): void;
    resetSpecifiedAmount(): void;
    get specifiedAmountInput(): BillingBudgetAmountSpecifiedAmount | undefined;
}
export interface BillingBudgetBudgetFilter {
    /**
    * A set of subaccounts of the form billingAccounts/{account_id},
  specifying that usage from only this set of subaccounts should
  be included in the budget. If a subaccount is set to the name of
  the parent account, usage from the parent account will be included.
  If the field is omitted, the report will include usage from the parent
  account and all subaccounts, if they exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#credit_types BillingBudget#credit_types}
    */
    readonly creditTypes?: string[];
    /**
    * Specifies how credits should be treated when determining spend
  for threshold calculations. Default value: "INCLUDE_ALL_CREDITS" Possible values: ["INCLUDE_ALL_CREDITS", "EXCLUDE_ALL_CREDITS", "INCLUDE_SPECIFIED_CREDITS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#credit_types_treatment BillingBudget#credit_types_treatment}
    */
    readonly creditTypesTreatment?: string;
    /**
    * A single label and value pair specifying that usage from only
  this set of labeled resources should be included in the budget.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#labels BillingBudget#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A set of projects of the form projects/{project_number},
  specifying that usage from only this set of projects should be
  included in the budget. If omitted, the report will include
  all usage for the billing account, regardless of which project
  the usage occurred on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#projects BillingBudget#projects}
    */
    readonly projects?: string[];
    /**
    * A set of services of the form services/{service_id},
  specifying that usage from only this set of services should be
  included in the budget. If omitted, the report will include
  usage for all the services. The service names are available
  through the Catalog API:
  https://cloud.google.com/billing/v1/how-tos/catalog-api.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#services BillingBudget#services}
    */
    readonly services?: string[];
    /**
    * A set of subaccounts of the form billingAccounts/{account_id},
  specifying that usage from only this set of subaccounts should
  be included in the budget. If a subaccount is set to the name of
  the parent account, usage from the parent account will be included.
  If the field is omitted, the report will include usage from the parent
  account and all subaccounts, if they exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#subaccounts BillingBudget#subaccounts}
    */
    readonly subaccounts?: string[];
}
export declare function billingBudgetBudgetFilterToTerraform(struct?: BillingBudgetBudgetFilterOutputReference | BillingBudgetBudgetFilter): any;
export declare class BillingBudgetBudgetFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BillingBudgetBudgetFilter | undefined;
    set internalValue(value: BillingBudgetBudgetFilter | undefined);
    private _creditTypes?;
    get creditTypes(): string[];
    set creditTypes(value: string[]);
    resetCreditTypes(): void;
    get creditTypesInput(): string[] | undefined;
    private _creditTypesTreatment?;
    get creditTypesTreatment(): string;
    set creditTypesTreatment(value: string);
    resetCreditTypesTreatment(): void;
    get creditTypesTreatmentInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _projects?;
    get projects(): string[];
    set projects(value: string[]);
    resetProjects(): void;
    get projectsInput(): string[] | undefined;
    private _services?;
    get services(): string[];
    set services(value: string[]);
    resetServices(): void;
    get servicesInput(): string[] | undefined;
    private _subaccounts?;
    get subaccounts(): string[];
    set subaccounts(value: string[]);
    resetSubaccounts(): void;
    get subaccountsInput(): string[] | undefined;
}
export interface BillingBudgetThresholdRules {
    /**
    * The type of basis used to determine if spend has passed
  the threshold. Default value: "CURRENT_SPEND" Possible values: ["CURRENT_SPEND", "FORECASTED_SPEND"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#spend_basis BillingBudget#spend_basis}
    */
    readonly spendBasis?: string;
    /**
    * Send an alert when this threshold is exceeded. This is a
  1.0-based percentage, so 0.5 = 50%. Must be >= 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#threshold_percent BillingBudget#threshold_percent}
    */
    readonly thresholdPercent: number;
}
export declare function billingBudgetThresholdRulesToTerraform(struct?: BillingBudgetThresholdRules | cdktf.IResolvable): any;
export interface BillingBudgetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#create BillingBudget#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#delete BillingBudget#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget#update BillingBudget#update}
    */
    readonly update?: string;
}
export declare function billingBudgetTimeoutsToTerraform(struct?: BillingBudgetTimeoutsOutputReference | BillingBudgetTimeouts | cdktf.IResolvable): any;
export declare class BillingBudgetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BillingBudgetTimeouts | undefined;
    set internalValue(value: BillingBudgetTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_budget google_billing_budget}
*/
export declare class BillingBudget extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_budget google_billing_budget} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BillingBudgetConfig
    */
    constructor(scope: Construct, id: string, config: BillingBudgetConfig);
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    get billingAccountInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _allUpdatesRule;
    get allUpdatesRule(): BillingBudgetAllUpdatesRuleOutputReference;
    putAllUpdatesRule(value: BillingBudgetAllUpdatesRule): void;
    resetAllUpdatesRule(): void;
    get allUpdatesRuleInput(): BillingBudgetAllUpdatesRule | undefined;
    private _amount;
    get amount(): BillingBudgetAmountOutputReference;
    putAmount(value: BillingBudgetAmount): void;
    get amountInput(): BillingBudgetAmount | undefined;
    private _budgetFilter;
    get budgetFilter(): BillingBudgetBudgetFilterOutputReference;
    putBudgetFilter(value: BillingBudgetBudgetFilter): void;
    resetBudgetFilter(): void;
    get budgetFilterInput(): BillingBudgetBudgetFilter | undefined;
    private _thresholdRules?;
    get thresholdRules(): BillingBudgetThresholdRules[] | cdktf.IResolvable;
    set thresholdRules(value: BillingBudgetThresholdRules[] | cdktf.IResolvable);
    get thresholdRulesInput(): cdktf.IResolvable | BillingBudgetThresholdRules[] | undefined;
    private _timeouts;
    get timeouts(): BillingBudgetTimeoutsOutputReference;
    putTimeouts(value: BillingBudgetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BillingBudgetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
