import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BinaryAuthorizationAttestorConfig extends cdktf.TerraformMetaArguments {
    /**
    * A descriptive comment. This field may be updated. The field may be
  displayed in chooser dialogs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#description BinaryAuthorizationAttestor#description}
    */
    readonly description?: string;
    /**
    * The resource name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#name BinaryAuthorizationAttestor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#project BinaryAuthorizationAttestor#project}
    */
    readonly project?: string;
    /**
    * attestation_authority_note block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#attestation_authority_note BinaryAuthorizationAttestor#attestation_authority_note}
    */
    readonly attestationAuthorityNote: BinaryAuthorizationAttestorAttestationAuthorityNote;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#timeouts BinaryAuthorizationAttestor#timeouts}
    */
    readonly timeouts?: BinaryAuthorizationAttestorTimeouts;
}
export interface BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey {
    /**
    * A PEM-encoded public key, as described in
  'https://tools.ietf.org/html/rfc7468#section-13'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#public_key_pem BinaryAuthorizationAttestor#public_key_pem}
    */
    readonly publicKeyPem?: string;
    /**
    * The signature algorithm used to verify a message against
  a signature using this key. These signature algorithm must
  match the structure and any object identifiers encoded in
  publicKeyPem (i.e. this algorithm must match that of the
  public key).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#signature_algorithm BinaryAuthorizationAttestor#signature_algorithm}
    */
    readonly signatureAlgorithm?: string;
}
export declare function binaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyToTerraform(struct?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference | BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey): any;
export declare class BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined;
    set internalValue(value: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey | undefined);
    private _publicKeyPem?;
    get publicKeyPem(): string;
    set publicKeyPem(value: string);
    resetPublicKeyPem(): void;
    get publicKeyPemInput(): string | undefined;
    private _signatureAlgorithm?;
    get signatureAlgorithm(): string;
    set signatureAlgorithm(value: string);
    resetSignatureAlgorithm(): void;
    get signatureAlgorithmInput(): string | undefined;
}
export interface BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys {
    /**
    * ASCII-armored representation of a PGP public key, as the
  entire output by the command
  'gpg --export --armor foo@example.com' (either LF or CRLF
  line endings). When using this field, id should be left
  blank. The BinAuthz API handlers will calculate the ID
  and fill it in automatically. BinAuthz computes this ID
  as the OpenPGP RFC4880 V4 fingerprint, represented as
  upper-case hex. If id is provided by the caller, it will
  be overwritten by the API-calculated ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#ascii_armored_pgp_public_key BinaryAuthorizationAttestor#ascii_armored_pgp_public_key}
    */
    readonly asciiArmoredPgpPublicKey?: string;
    /**
    * A descriptive comment. This field may be updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#comment BinaryAuthorizationAttestor#comment}
    */
    readonly comment?: string;
    /**
    * The ID of this public key. Signatures verified by BinAuthz
  must include the ID of the public key that can be used to
  verify them, and that ID must match the contents of this
  field exactly. Additional restrictions on this field can
  be imposed based on which public key type is encapsulated.
  See the documentation on publicKey cases below for details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#id BinaryAuthorizationAttestor#id}
    */
    readonly id?: string;
    /**
    * pkix_public_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#pkix_public_key BinaryAuthorizationAttestor#pkix_public_key}
    */
    readonly pkixPublicKey?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeysPkixPublicKey;
}
export declare function binaryAuthorizationAttestorAttestationAuthorityNotePublicKeysToTerraform(struct?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys | cdktf.IResolvable): any;
export interface BinaryAuthorizationAttestorAttestationAuthorityNote {
    /**
    * The resource name of a ATTESTATION_AUTHORITY Note, created by the
  user. If the Note is in a different project from the Attestor, it
  should be specified in the format 'projects/*\/notes/*' (or the legacy
  'providers/*\/notes/*'). This field may not be updated.
  An attestation by this attestor is stored as a Container Analysis
  ATTESTATION_AUTHORITY Occurrence that names a container image
  and that links to this Note.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#note_reference BinaryAuthorizationAttestor#note_reference}
    */
    readonly noteReference: string;
    /**
    * public_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#public_keys BinaryAuthorizationAttestor#public_keys}
    */
    readonly publicKeys?: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable;
}
export declare function binaryAuthorizationAttestorAttestationAuthorityNoteToTerraform(struct?: BinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference | BinaryAuthorizationAttestorAttestationAuthorityNote): any;
export declare class BinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BinaryAuthorizationAttestorAttestationAuthorityNote | undefined;
    set internalValue(value: BinaryAuthorizationAttestorAttestationAuthorityNote | undefined);
    get delegationServiceAccountEmail(): string;
    private _noteReference?;
    get noteReference(): string;
    set noteReference(value: string);
    get noteReferenceInput(): string | undefined;
    private _publicKeys?;
    get publicKeys(): BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable;
    set publicKeys(value: BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | cdktf.IResolvable);
    resetPublicKeys(): void;
    get publicKeysInput(): cdktf.IResolvable | BinaryAuthorizationAttestorAttestationAuthorityNotePublicKeys[] | undefined;
}
export interface BinaryAuthorizationAttestorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#create BinaryAuthorizationAttestor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#delete BinaryAuthorizationAttestor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor#update BinaryAuthorizationAttestor#update}
    */
    readonly update?: string;
}
export declare function binaryAuthorizationAttestorTimeoutsToTerraform(struct?: BinaryAuthorizationAttestorTimeoutsOutputReference | BinaryAuthorizationAttestorTimeouts | cdktf.IResolvable): any;
export declare class BinaryAuthorizationAttestorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BinaryAuthorizationAttestorTimeouts | undefined;
    set internalValue(value: BinaryAuthorizationAttestorTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor google_binary_authorization_attestor}
*/
export declare class BinaryAuthorizationAttestor extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/binary_authorization_attestor google_binary_authorization_attestor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BinaryAuthorizationAttestorConfig
    */
    constructor(scope: Construct, id: string, config: BinaryAuthorizationAttestorConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _attestationAuthorityNote;
    get attestationAuthorityNote(): BinaryAuthorizationAttestorAttestationAuthorityNoteOutputReference;
    putAttestationAuthorityNote(value: BinaryAuthorizationAttestorAttestationAuthorityNote): void;
    get attestationAuthorityNoteInput(): BinaryAuthorizationAttestorAttestationAuthorityNote | undefined;
    private _timeouts;
    get timeouts(): BinaryAuthorizationAttestorTimeoutsOutputReference;
    putTimeouts(value: BinaryAuthorizationAttestorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BinaryAuthorizationAttestorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
