import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudiotRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Activate or deactivate HTTP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#http_config CloudiotRegistry#http_config}
    */
    readonly httpConfig?: {
        [key: string]: string;
    };
    /**
    * The default logging verbosity for activity from devices in this
  registry. Specifies which events should be written to logs. For
  example, if the LogLevel is ERROR, only events that terminate in
  errors will be logged. LogLevel is inclusive; enabling INFO logging
  will also enable ERROR logging. Default value: "NONE" Possible values: ["NONE", "ERROR", "INFO", "DEBUG"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#log_level CloudiotRegistry#log_level}
    */
    readonly logLevel?: string;
    /**
    * Activate or deactivate MQTT.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#mqtt_config CloudiotRegistry#mqtt_config}
    */
    readonly mqttConfig?: {
        [key: string]: string;
    };
    /**
    * A unique name for the resource, required by device registry.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#name CloudiotRegistry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#project CloudiotRegistry#project}
    */
    readonly project?: string;
    /**
    * The region in which the created registry should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#region CloudiotRegistry#region}
    */
    readonly region?: string;
    /**
    * A PubSub topic to publish device state updates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#state_notification_config CloudiotRegistry#state_notification_config}
    */
    readonly stateNotificationConfig?: {
        [key: string]: string;
    };
    /**
    * credentials block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#credentials CloudiotRegistry#credentials}
    */
    readonly credentials?: CloudiotRegistryCredentials[] | cdktf.IResolvable;
    /**
    * event_notification_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#event_notification_configs CloudiotRegistry#event_notification_configs}
    */
    readonly eventNotificationConfigs?: CloudiotRegistryEventNotificationConfigs[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#timeouts CloudiotRegistry#timeouts}
    */
    readonly timeouts?: CloudiotRegistryTimeouts;
}
export interface CloudiotRegistryCredentials {
    /**
    * A public key certificate format and data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#public_key_certificate CloudiotRegistry#public_key_certificate}
    */
    readonly publicKeyCertificate: {
        [key: string]: string;
    };
}
export declare function cloudiotRegistryCredentialsToTerraform(struct?: CloudiotRegistryCredentials | cdktf.IResolvable): any;
export interface CloudiotRegistryEventNotificationConfigs {
    /**
    * PubSub topic name to publish device events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#pubsub_topic_name CloudiotRegistry#pubsub_topic_name}
    */
    readonly pubsubTopicName: string;
    /**
    * If the subfolder name matches this string exactly, this
  configuration will be used. The string must not include the
  leading '/' character. If empty, all strings are matched. Empty
  value can only be used for the last 'event_notification_configs'
  item.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#subfolder_matches CloudiotRegistry#subfolder_matches}
    */
    readonly subfolderMatches?: string;
}
export declare function cloudiotRegistryEventNotificationConfigsToTerraform(struct?: CloudiotRegistryEventNotificationConfigs | cdktf.IResolvable): any;
export interface CloudiotRegistryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#create CloudiotRegistry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#delete CloudiotRegistry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry#update CloudiotRegistry#update}
    */
    readonly update?: string;
}
export declare function cloudiotRegistryTimeoutsToTerraform(struct?: CloudiotRegistryTimeoutsOutputReference | CloudiotRegistryTimeouts | cdktf.IResolvable): any;
export declare class CloudiotRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudiotRegistryTimeouts | undefined;
    set internalValue(value: CloudiotRegistryTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry google_cloudiot_registry}
*/
export declare class CloudiotRegistry extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudiot_registry google_cloudiot_registry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudiotRegistryConfig
    */
    constructor(scope: Construct, id: string, config: CloudiotRegistryConfig);
    private _httpConfig?;
    get httpConfig(): {
        [key: string]: string;
    };
    set httpConfig(value: {
        [key: string]: string;
    });
    resetHttpConfig(): void;
    get httpConfigInput(): {
        [key: string]: string;
    } | undefined;
    get id(): string;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _mqttConfig?;
    get mqttConfig(): {
        [key: string]: string;
    };
    set mqttConfig(value: {
        [key: string]: string;
    });
    resetMqttConfig(): void;
    get mqttConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _stateNotificationConfig?;
    get stateNotificationConfig(): {
        [key: string]: string;
    };
    set stateNotificationConfig(value: {
        [key: string]: string;
    });
    resetStateNotificationConfig(): void;
    get stateNotificationConfigInput(): {
        [key: string]: string;
    } | undefined;
    private _credentials?;
    get credentials(): CloudiotRegistryCredentials[] | cdktf.IResolvable;
    set credentials(value: CloudiotRegistryCredentials[] | cdktf.IResolvable);
    resetCredentials(): void;
    get credentialsInput(): cdktf.IResolvable | CloudiotRegistryCredentials[] | undefined;
    private _eventNotificationConfigs?;
    get eventNotificationConfigs(): CloudiotRegistryEventNotificationConfigs[] | cdktf.IResolvable;
    set eventNotificationConfigs(value: CloudiotRegistryEventNotificationConfigs[] | cdktf.IResolvable);
    resetEventNotificationConfigs(): void;
    get eventNotificationConfigsInput(): cdktf.IResolvable | CloudiotRegistryEventNotificationConfigs[] | undefined;
    private _timeouts;
    get timeouts(): CloudiotRegistryTimeoutsOutputReference;
    putTimeouts(value: CloudiotRegistryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudiotRegistryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
